package ibase.dashboard.scm.ejb;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.ejb.Stateless;
import org.json.simple.JSONObject;

/**
 * Session Bean implementation class CustomerInfoEJB
 */
@Stateless
public class SupplierInfoEJB extends ValidatorEJB implements SupplierInfoRemote, SupplierInfoLocal {

    /**
     * Default constructor. 
     */
    public SupplierInfoEJB() {
        
    }
    
    @SuppressWarnings("unchecked")
	@Override
    public JSONObject getPendingPurchase(String suppCode, String prdCode,String dataSourceName) throws RemoteException, ITMException
    {
		JSONObject rawDataPendingPurchJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		
		try
		{
			
			System.out.println(" Inside SupplierInfoEJB for getPendingPurchase Method Data Soruc Name ="+dataSourceName+" suppCode:"+suppCode+" prdCode is =" + prdCode);
			
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			
			sql = " /*Put Sql Query */";
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;			
			while (rs.next())
			{
				rowData = new JSONObject();
				/*rowData.put("sp_name", (rs.getString("sp_name")));
				rowData.put("max_event_date", (rs.getString("max_event_date")));
				rowData.put("year", (rs.getString("yyyymm")));
				rowData.put("month", (rs.getString("monyyyy")));
				rowData.put("brand_code", (rs.getString("brand_code")));
				rowData.put("brand", (rs.getString("brand")));
				rowData.put("doc_code", rs.getString("doc_code"));
				rowData.put("doc_name", rs.getString("doc_name"));		
				rowData.put("spl_code", rs.getString("spl_code"));		
				rowData.put("spl_descr", rs.getString("spl_descr"));		
				rowData.put("presc_no", rs.getString("presc_no"));	*/	
				rawDataPendingPurchJson.put(count, rowData);
				count++;
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :SupplierInfoEJB for getPendingPurchase Method :" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataPendingPurchJson;
		
	}

    
	
	private String getGeolocation(String geoLocation)
	{
		String[] geoLocArray = this.getSplitedStrng(geoLocation);
		String modifyGeoLoc = "";
		if (geoLocArray != null)
		{
			for (int i = 0; i < geoLocArray.length; i++)
			{
				if (i == geoLocArray.length - 1)
				{
					modifyGeoLoc = modifyGeoLoc + "'" + geoLocArray[i] + "'";
				} else
				{
					modifyGeoLoc = modifyGeoLoc + "'" + geoLocArray[i] + "',";
				}
			}
		} else
		{
			modifyGeoLoc = "";
		}
		return modifyGeoLoc;

	}

	private String[] getSplitedStrng(String year)
	{
		String[] splitedArray = null;
		if (year != null && year.length() > 0)
		{
			splitedArray = year.split(",");
		}
		return splitedArray;
	}

}
