package ibase.webitm.ejb.wms;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.TreeMap;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.ConnDriver;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.reports.utility.JasperReportGenerator;
import ibase.webitm.reports.utility.XSDParser;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;

@Stateless
public class DDPorderReportSendMail extends ActionHandlerEJB implements DDPorderReportSendMailLocal,DDPorderReportSendMailRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	String objName = "";
	String reportName ="";
	String emailID="";
	String cC = "";
	String mailSubject = "";
	String message = "message";
	
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	
	public String actionHandler(String tranId, String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{
		System.out.println("--------------ActionHandler method of Send Mail for PO ------------- : ["+tranId+"]");
		String retString = "";	
		Connection conn = null;
		//Commented by Santosh on 14-06-2016
		//ConnDriver connDriver = new ConnDriver();
		
		try
		{		
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//conn = connDriver.getConnectDB("DriverITM");
			//connDriver = null;
			conn = getConnection();
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			retString = sendReport(tranId,xtraParams,forcedFlag,conn);			
		}
		catch(Exception e)
		{
			System.out.println("Exception :SendReport :actionHandler():" + e.getMessage() + ":");
			retString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		
		return retString;
	}
	
	public String sendReport(String tranId,String xtraParams,String forcedFlag,Connection conn) throws RemoteException,ITMException
	{
		System.out.println("==================In sendReport=======================");
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;	
		
		String confirmed = "";
		String ordDate = "";
		String siteCodeOrd = "";
		String ZZ = "ZZ";
		String loginEmpCode = "";
		String userId = "";
		String loginSite = "";
		String newOrdDate = "";
		String errString = "";
		String suppCode = "";
		String contactCode = "";
		
		Boolean isError = false;
		
		E12GenericUtility genericUtility = new E12GenericUtility();
		System.out.println("XTRA PARAMS ["+xtraParams+"]");
		
		
		loginEmpCode = checkNullAndTrim(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode"));
		userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
		loginSite = checkNullAndTrim((genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode")));
		
		try
		{
			//sql = "select confirmed from porder where purc_order = ?";
			  sql = "select confirmed,ord_date,site_code__ord from porder where purc_order = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				confirmed = checkNullAndTrim(rs.getString("confirmed"));
				ordDate   = checkNullAndTrim(rs.getString("ord_date"));
				siteCodeOrd  = checkNullAndTrim(rs.getString("site_code__ord"));
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			System.out.println("Before Date="+ordDate);
			newOrdDate = genericUtility.getValidDateString(ordDate, genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
			System.out.println("After Date="+newOrdDate);
			
			if("Y".equalsIgnoreCase(confirmed))
			{
				System.out.println("Purchase order is confirmed="+tranId);
				
				sql = " select send_to,copy_to,subject,body_text from mail_format where format_code = 'POSENDREP' ";
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					 //emailID	 = checkNullAndTrim(rs.getString("send_to"));
					 //cC			 = checkNullAndTrim(rs.getString("copy_to"));
					 mailSubject = checkNullAndTrim(rs.getString("subject"));
					 message	 = checkNullAndTrim(rs.getString("body_text"));
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				
				sql = " select supp_code from porder where purc_order = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				rs = pstmt.executeQuery();
				
				if(rs.next())
				{
					 suppCode	 = checkNullAndTrim(rs.getString("supp_code"));
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				System.out.println("Supplier is="+suppCode);
				
				sql = " select email_addr,contact_code from supplier where supp_code = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,suppCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					emailID	 = checkNullAndTrim(rs.getString("email_addr"));
					contactCode	 = checkNullAndTrim(rs.getString("contact_code"));
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				
				sql = " select email_addr from contact where contact_code = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,contactCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					cC	 = checkNullAndTrim(rs.getString("email_addr"));
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				
				
				ibase.webitm.reports.utility.JasperReportGenerator jrGenerator = new ibase.webitm.reports.utility.JasperReportGenerator();
				String xsdString ="<Arguments>" +
										"<Argument id=\"arg1\" name=\"msite_code\">" +
										"<argType>java.lang.String</argType>" +
										"<value>"+siteCodeOrd+"</value>" +
										"</Argument>" +
										
										"<Argument id=\"arg1\" name=\"msupp_code__from\">" +
										"<argType>java.lang.String</argType>" +
										"<value>"+00+"</value>" +
										"</Argument>" +
										
										"<Argument id=\"arg1\" name=\"msupp_code__to\">" +
										"<argType>java.lang.String</argType>" +
										"<value>"+ZZ+"</value>" +
										"</Argument>" +
										
										"<Argument id=\"arg1\" name=\"mitem_ser__from\">" +
										"<argType>java.lang.String</argType>" +
										"<value>"+00+"</value>" +
										"</Argument>" +
										
										"<Argument id=\"arg1\" name=\"mitem_ser__to\">" +
										"<argType>java.lang.String</argType>" +
										"<value>"+ZZ+"</value>" +
										"</Argument>" +
										
										"<Argument id=\"arg1\" name=\"mpurc_order__from\">" +
										"<argType>java.lang.String</argType>" +
										"<value>"+tranId+"</value>" +
										"</Argument>" +
										
										"<Argument id=\"arg1\" name=\"mpurc_order__to\">" +
										"<argType>java.lang.String</argType>" +
										"<value>"+tranId+"</value>" +
										"</Argument>" +
										
										"<Argument id=\"arg1\" name=\"mdate_from\">" +
										"<argType>java.util.Date</argType>" +
										"<value>"+newOrdDate+"</value>" +
										"</Argument>" +
										
										"<Argument id=\"arg1\" name=\"mdate_to\">" +
										"<argType>java.util.Date</argType>" +
										"<value>"+newOrdDate+"</value>" +
										"</Argument>" +
										
										"<Argument id=\"arg1\" name=\"msites\">" +
										"<argType>java.lang.String</argType>" +
										"<value>"+siteCodeOrd+"</value>" +
										"</Argument>" +
										
										"<Argument id=\"arg1\" name=\"reprint_flag\">" +
										"<argType>java.lang.String</argType>" +
										"<value>N</value>" +
										"</Argument>" +
										
										"<Argument id=\"arg8\" name=\"x_path\">" +
										"<argType>java.lang.String</argType>" +
										"<value>/DocumentRoot/d_po_hdr_print</value>" +
										"</Argument>" +
										
										"<Argument id=\"arg9\" name=\"design_source\">" +
										"<argType>java.lang.String</argType>" +
										"<value>d_po_hdr_print.jrxml</value>" +
										"</Argument>" +
										
										"<Argument id=\"arg9\" name=\"data_source\">" +
										"<argType>java.lang.String</argType>" +
										"<value>SQL</value>" +
										"</Argument>" +
										
										"<Argument id=\"arg9\" name=\"bind_type\">" +
										"<argType>java.lang.Integer</argType>" +
										"<value>"+0+"</value>" +
										"</Argument>" +
										
										"<Argument id=\"arg9\" name=\"report_type\">" +
										"<argType>java.lang.String</argType>" +
										"<value>JASPER</value>" +
										"</Argument>" +
										
										"<Argument id=\"arg7\" name=\"report_save_type\">" +
										"<argType>java.lang.String</argType>" +
										"<value>NATIVE</value>" +
										"</Argument>" +
						
									"</Arguments>";
				
				System.out.println(" XSD parser **->["+xsdString+"]");
				
				String name = "d_po_hdr_print";
			/*	Document document = ibase.utility.new E12GenericUtility().parseString( name );
				UserInfoBean userInfo= new UserInfoBean( new E12GenericUtility().serializeDom(document.getElementsByTagName( "USERINFOXML" ).item(0).getChildNodes().item(0)));
				String userName = userInfo.getLoginCode();*/
				String outputFilename =  this.objName + "BASE" + System.currentTimeMillis();
				XSDParser xsdParser = new XSDParser(this.objName);	
				TreeMap argMap = jrGenerator.createArgMap(xsdString);
				String userName = "BASE";
				
				System.out.println("-------objName--------"+this.objName);
				System.out.println("-------reportName--------"+this.reportName);
				System.out.println("argMap-----------------"+argMap);
				System.out.println("xsdParser-----------------"+xsdParser);
				System.out.println("userName------------------"+userName);
				System.out.println("outputFilename------------------"+outputFilename);
				System.out.println("emailID------------------"+emailID);
				System.out.println("cC------------------"+cC);
				System.out.println("mailSubject------------------"+mailSubject);
				System.out.println("message------------------"+message);
				
				//emailID = "wasim.ansari@baseinformation.com";
				//cC = "ppatro@baseinformation.com";
				
				System.out.println("User Name from xtraparams="+loginEmpCode);
				
				cC = checkNullAndTrim(cC);
				System.out.println("Cc Lenght="+cC);
				
				if(cC.length() <=0)
				{
					cC = emailID;
				}
				System.out.println("Final cC="+cC);
				
				jrGenerator.createAndMailReport(name, argMap, xsdParser, loginEmpCode, outputFilename, emailID, cC, mailSubject, message);
				
			}
			else
			{
				System.out.println("Purchase Order is not Confirmed");
				errString = itmDBAccessEJB.getErrorString("","VTNOTCONF","","",conn);
				isError = true;
				return errString;
			}
		}
		catch(Exception e)
		{
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			if(isError == false)
			{
				errString = itmDBAccessEJB.getErrorString("","VTMAILSEND","","",conn);
			}
			else
			{
				errString = itmDBAccessEJB.getErrorString("","VTERRMAIL","","",conn);
			}
			try
			{
				if(conn != null)
				{					
					if(pstmt != null)
					{
						pstmt.close();
						pstmt=null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
	}	 
	private static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
	
}
