package ibase.webitm.ejb.fin;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ITMDBAccessLocal;
//import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.ActionHandlerEJB;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.ejb.Stateless;

@Stateless
public class CustBankDeactivate extends ActionHandlerEJB implements CustBankDeactivateLocal,CustBankDeactivateRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	public String actionHandler(String tranId, String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{
		System.out.println("--------------confirm method of CustBankDeactivate ------------- : ");
		String retString = "";		
		try
		{
						
				retString = deactive(tranId,xtraParams,forcedFlag);
			
		}
		catch(Exception e)
		{
			System.out.println("Exception :CustBankDeactivate :confirm():" + e.getMessage() + ":");
			retString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		
		return retString;
	}
	
	private String deactive(String tranId,String xtraParams,String forcedFlag) 
	{
		System.out.println("---------Class : CustBankDeactivate-->> deactive method called-----------");   
		String CustCode = null;
		String bankcode = null;
		ResultSet rs=null;
		Connection conn=null;
		ConnDriver ConnDriver = new ConnDriver();
		PreparedStatement pstmt=null;
		String errString="",sql="",ActiveYN="";
		int updCnt=0;
		ITMDBAccessLocal itmdbAccess=new ITMDBAccessEJB();
		try
		{		
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			//Changes and Commented By Bhushan on 13-06-2016 :START
			//conn = connDriver.getConnectDB("DriverValidator");
			conn = getConnection();
			//Changes and Commented By Bhushan on 13-06-2016 :END 
			conn.setAutoCommit(false);
			String confirmed="";
			String split[]=tranId.split(":");
			CustCode=split[0];
			bankcode=split[1];
			
			sql = "select confirmed,active_yn from customer_bank WHERE cust_code = ? and bank_code__ben = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, CustCode);
			pstmt.setString(2, bankcode);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				confirmed =rs.getString(1)==null ? "N":rs.getString(1);
				ActiveYN=rs.getString(2)==null ? "Y" : rs.getString(2);
			}	
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if( ActiveYN != null && ActiveYN.equalsIgnoreCase("N") )
			{
				//deactivate transaction can not confirm
				System.out.println("transaction is already deactivated");
				errString = itmdbAccess.getErrorString("", "VMDETPTAL", "", "", conn);
				return errString;
			}				
//			GenericUtility genericUtility=new GenericUtility();
			String loginCode=genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			System.out.println("Login Code ------->> "+loginCode);
			sql="update customer_bank set active_yn = ? where cust_code = ? and bank_code__ben = ? ";
			pstmt=conn.prepareStatement(sql);
			pstmt.setString(1, "N");
			pstmt.setString(2, CustCode);
			pstmt.setString(3, bankcode);
			updCnt=pstmt.executeUpdate();
			pstmt.close();
			pstmt = null;
			System.out.println("Update count is"+ updCnt);
			if (updCnt > 0)
			{	
				System.out.println("successfully deactivated");
				errString = itmdbAccess.getErrorString("", "VMDETRASU", "", "", conn);
				conn.commit();
			}
			
		}
		catch(SQLException se)
		{
			System.out.println("SQLException : class CustBankDeactivate : ");
			se.printStackTrace();
			try
			{
			  conn.rollback();
			}
			catch(Exception e){
				System.out.println("Exception : Occure during rollback........");e.printStackTrace();
				}
		}
		catch(Exception e)
		{
			try
			{
				conn.rollback();
			}
			catch (Exception e1)
			{
			}
			e.printStackTrace();
			System.out.println("Exception Class [CustBankDeactivate]::"+e.getMessage());
			
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;					
				}	
				if (conn!=null)
				{
					conn.close();
					conn=null;
				}
							
			}
			catch(Exception e)
			{
				System.out.println(e.getMessage());
				e.printStackTrace();
				
			}
		}
		System.out.println("[CustBankDeactivate]errstring :"+errString);
		return errString;
	
}
}
