package ibase.e12ria.e12widgets.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;

/**
 * A widget which will display a label with some text, and when that label
 * is clicked, it will display a popup with a list of options.
 * 
 * <p>
 * The client has to set the text to be displayed on the label. The client also
 * has to add text which will be displayed in the options to be displayed in the 
 * popup.
 * 
 * <p>
 * To add functionality to the option when selected, the client has to register
 * handlers for each option.
 * 
 * @author Gopalakrishna Bharat
 */
public class PopupOptions extends E12DisclosurePanel
{

    
    /** Flag to indicate whether this widget has been loaded on the page. */
    private boolean isLoaded = false;

    
    /** Label which forms the header. */
    protected Label headerLabel = new Label();
    
    /** Panel which forms the content of the popup. */
    protected Panel contentPanel = new VerticalPanel();

    
    /** Text to be displayed in the header; set by the client. */
    protected String headerText = "";
    
    
    /** List of String</code> which forms the text to be displayed for each option. */
    protected List< String > optionList = new ArrayList< String >();
    
    /** Mapping of each option with respective handler. */
    protected Map< String, ClickHandler > handlerMap = 
        new HashMap< String, ClickHandler >();

    
    /** Style name for panel containing each option widget. */
    protected String optionContainerPanelStyleName;
    
    /** Style name for each option widget. */
    protected String optionButtonStyleName;
    
    //Added by Dnyaneshwar chavan on 15-JAN-2013 [] Start
    /** Multiple style name for each option widget */
    protected Map< String, List<String> > optionButtonAddStyleName = new HashMap< String, List< String > > (); 
    //Added by Dnyaneshwar chavan on 15-JAN-2013 [] End

    
    /**
     * Creates new widget of this class.
     *  
     * @param text the text to be displayed in the label.
     */
    public PopupOptions( String text )
    {
        headerText = text;
    }

    
    /** Sets the text to be displayed in the label. */
    public void setText( String text )
    {
        headerText = text;
        updateWidget();
    }

    
    /** Sets the style name to be used by the panel containing each option widget. */
    public void setOptionContainerPanelStyleName( String styleName )
    {
        optionContainerPanelStyleName = styleName;
    }

    
    /** Sets the style name to be used by each option widget. */
    public void setOptionButtonStyleName( String styleName )
    {
        optionButtonStyleName = styleName;
    }
    
    //Added by Dnyaneshwar chavan on 15-JAN-2013 [] Start
    /** 
     * Add multiples style names to be used by each option widget 
     * 
     * @param option the display on pop-up panel  
     * @param styleNames the List of style names
     * 
     * */
    public void addOptionButtonStyleName( String option, List< String >  styleNames )
    {
    	optionButtonAddStyleName.put( option, styleNames );
    }
        
    /** 
     * Sets the style name to be used by Pop-up Panel.
     * 
     * @param styleName 
     * */
    public void setPopupStyleName( String styleName )
    {
    	popupPanelStyleName = styleName;
    }
    
    /** 
     * Add the style name to be used by Pop-up Panel.
     * 
     * @param styleName 
     * */
    public void addPopupStyleName( String styleName )
    {
    	popupPanelAddStyleName.add( styleName );
    }
    //Added by Dnyaneshwar chavan on 15-JAN-2013 [] End
    
    @Override
    protected void onLoad()
    {
        isLoaded = false;
        
        super.onLoad();

        isLoaded = true;
        updateWidget();
        isLoaded = false;
        
        setHeader( headerLabel );
        setContent( contentPanel );
        
        isLoaded = true;
    }

    
    @Override
    protected void updateWidget()
    {
        super.updateWidget();
        if( isLoaded )
        {
            updateHeader();
            updateContent();
        }
    }

    
    /** Redraws the label. */
    private void updateHeader()
    {
        headerLabel.setText( headerText );
    }

    
    /** Redraws the contents. */
    private void updateContent()
    {
        contentPanel.clear();
        for( String option : optionList )
        {
            Panel optionContainerPanel = new SimplePanel();
            optionContainerPanel.setStyleName( optionContainerPanelStyleName );
            //Added by Dnyaneshwar chavan on 15-JAN-2013 [] Start
            //Button optionButton = new Button( option );
            Label optionLabel = new Label( option );
            optionLabel.setStyleName( ( optionButtonStyleName == null ? "gwt-Label" : optionButtonStyleName ) );
            //List< String > styleNames = optionButtonAddStyleName.get( option );
            for( String styleName : optionButtonAddStyleName.get( option ) )
            {
            	optionLabel.addStyleName( styleName );
            }
            //Added by Dnyaneshwar chavan on 15-JAN-2013 [] End
            
            addClickHandler( option, optionLabel );
            
            optionContainerPanel.add( optionLabel );
            
            contentPanel.add( optionContainerPanel );
        }
    }

    
    /** Adds the respective click handler to option widget. */
    private void addClickHandler( String option, HasClickHandlers optionWidget )
    {
        ClickHandler clickHandler = handlerMap.get( option );
        if( clickHandler != null )
        {
            optionWidget.addClickHandler( clickHandler );
            optionWidget.addClickHandler( new ClickHandler()
            {
                @Override
                public void onClick(ClickEvent event)
                {
                    showOrHidePopup(); // will hide popup
                }
            } );
        }
    }

    
    /** 
     * Adds a new option to be displayed in the options list.
     * 
     * @param option the text to displayed for that option
     */
    public void addOption( String option )
    {
        optionList.add( option );
        updateWidget();
    }

    
    /**
     * Registers a handler which will be invoked what a particular option
     * is selected.
     * 
     * @param option the option on which this handler should be called
     * @param handler the actual handler which will be called
     */
    public void registerHandler( String option, ClickHandler handler )
    {
        handlerMap.put( option, handler );
        updateWidget();
    }
    
}
