package ibase.dashboard.wms.servlet;

import ibase.dashboard.wms.ejb.WMS3PLDashboardRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;

import java.io.IOException;
import java.io.OutputStream;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.json.simple.JSONObject;

public class SalesOrderWiseDetailServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		WMS3PLDashboardRemote wms3PLDashboardRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		
		String dataSourceName = "";
		String siteCode = "";
		JSONObject jsonObjData = null;
		OutputStream outputStream = null;
		
		try
		{
			
			response.setContentType("application/xml");
			siteCode = request.getParameter("siteCode");
			dataSourceName = request.getParameter("dataSourceName");

			System.out.println("*********** In SalesOrderWiseDetailServlet siteCode is *************** =" + siteCode);
			
			context = new InitialContext(appConnectParm.getProperty());
			wms3PLDashboardRemote = (WMS3PLDashboardRemote) context.lookup("ibase/WMS3PLDashboard/remote");
			jsonObjData = (JSONObject) wms3PLDashboardRemote.getSalesOrderWiseDetail(siteCode, dataSourceName);
			outputStream = response.getOutputStream();
			outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set for SalesOrderWiseDetailServlet  build the Graph is === "+ jsonObjData);

		}
		catch (Exception e)
		{
			System.out.println("Exception : SalesOrderWiseDetailServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			}
			catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}

}
