/*
 * Decompiled with CFR 0.152.
 */
package ibase.e12ria.client;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.Node;
import com.google.gwt.xml.client.NodeList;
import com.google.gwt.xml.client.XMLParser;
import ibase.e12ria.client.E12CommonUtils;
import ibase.e12ria.client.E12Constants;
import ibase.e12ria.client.E12Global;
import ibase.e12ria.client.E12RequestBuilder;
import ibase.e12ria.client.E12TNCViewer;
import ibase.e12ria.client.TNCWrapper;
import ibase.e12ria.e12widgets.client.E12PopupPanel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class E12TermsNCondition {
    private static E12TermsNCondition e12TermsNCondition = null;
    private HashMap<String, TNCWrapper> tncWrapperMap = new HashMap();

    public static E12TermsNCondition getInstance() {
        try {
            if (e12TermsNCondition == null) {
                e12TermsNCondition = new E12TermsNCondition();
            }
        }
        catch (Exception e) {
            Window.alert((String)("Exception : E12TermsNCondition getInstance " + e.getMessage()));
            e.printStackTrace();
        }
        return e12TermsNCondition;
    }

    public void initTermsNConditions() {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ACTION", "TNC_DEFAULT");
        String paramString = E12CommonUtils.getInstance().getEncodedParamString(paramMap);
        String url = String.valueOf(E12Global.getHostUrl()) + "/ibase/RIAWizardHandlerServlet?" + paramString;
        HashMap<String, String> requestDataMap = new HashMap<String, String>();
        E12RequestBuilder requestBuilder = new E12RequestBuilder(RequestBuilder.POST, url);
        try {
            try {
                requestBuilder.sendRequest(requestDataMap, new RequestCallback(){

                    public void onResponseReceived(Request request, Response response) {
                        String cocDetailXML = response.getText();
                        if (cocDetailXML != null && !"false".equalsIgnoreCase(cocDetailXML)) {
                            E12TermsNCondition.this.populateTermsNConditions(cocDetailXML);
                        }
                    }

                    public void onError(Request request, Throwable exception) {
                        Window.alert((String)("ERROR: Error on E12TermsNConditions: " + exception.toString()));
                    }
                });
            }
            catch (Exception e) {
                Window.alert((String)("ERROR: Error while calling servlet [" + url + "]: " + e.toString()));
                throw new RuntimeException(e);
            }
        }
        finally {
            paramString = null;
            url = null;
        }
    }

    public void populateTermsNConditions(String tncDetailXML) {
        try {
            Document tncDoc = XMLParser.parse((String)tncDetailXML);
            XMLParser.removeWhitespace((Node)tncDoc);
            NodeList detailNodeList = tncDoc.getElementsByTagName("Detail1");
            int len = detailNodeList.getLength();
            int cntr = 0;
            while (cntr < len) {
                Node node = detailNodeList.item(cntr);
                if (node != null && node.getChildNodes() != null) {
                    TNCWrapper wrapper = new TNCWrapper();
                    NodeList childNodeList = node.getChildNodes();
                    int childLen = childNodeList.getLength();
                    int index = 0;
                    while (index < childLen) {
                        Node currNode = childNodeList.item(index);
                        String nodeName = currNode.getNodeName();
                        String nodeValue = "";
                        if (currNode.getFirstChild() != null && currNode.getFirstChild().getNodeType() == 4) {
                            nodeValue = currNode.getFirstChild().getNodeValue();
                        }
                        wrapper.setTNCAttrib(nodeName, nodeValue);
                        if ("IS_AGREE".equalsIgnoreCase(nodeName)) {
                            wrapper.setAgreed(Boolean.parseBoolean(nodeValue));
                        }
                        if ("FINENT_DESCR".equalsIgnoreCase(nodeName)) {
                            wrapper.setFinentDescr(nodeValue);
                        }
                        ++index;
                    }
                    wrapper.setTNCAttrib("TNC_SAVE_XML", node.toString());
                    this.tncWrapperMap.put(wrapper.getTNCAttrib("tnc_code"), wrapper);
                }
                ++cntr;
            }
            this.showTermsNCondition();
        }
        catch (Exception e) {
            Window.alert((String)("Exception while populating Terms and Conditions[" + e.getMessage() + "]"));
        }
    }

    private void showTermsNCondition() {
        try {
            for (String tncCode : this.tncWrapperMap.keySet()) {
                TNCWrapper wrapper = this.tncWrapperMap.get(tncCode);
                if (wrapper == null || wrapper.isAgreed()) continue;
                this.showTermsNCondition(tncCode);
                return;
            }
        }
        catch (Exception e) {
            Window.alert((String)("Exception while showing Terms and Conditions[" + e.getMessage() + "]"));
        }
    }

    public void showTermsNCondition(final String tncCode) {
        try {
            final TNCWrapper wrapper = this.tncWrapperMap.get(tncCode);
            if (wrapper != null) {
                final E12PopupPanel e12PopupPanel = new E12PopupPanel(true, true, "", true);
                int clientWidth = Window.getClientWidth();
                int clientHeight = Window.getClientHeight();
                e12PopupPanel.setPopupPosition(25, 20);
                e12PopupPanel.setWidth(String.valueOf(clientWidth - 50) + "px");
                e12PopupPanel.setHeight(String.valueOf(clientHeight - 50) + "px");
                E12TNCViewer e12TNCViewer = new E12TNCViewer(wrapper, new Command(){

                    public void execute() {
                        String dateAccept = wrapper.getTNCAttrib("date_accept");
                        if (wrapper.checkNull(dateAccept).length() == 0) {
                            Date currentDate = new Date(System.currentTimeMillis());
                            SimpleDateFormat sdf = new SimpleDateFormat(E12Constants.dispDate);
                            dateAccept = sdf.format(currentDate);
                        }
                        HashMap<String, String> paramMap = new HashMap<String, String>();
                        paramMap.put("ACTION", "TNC_AGREE");
                        paramMap.put("OBJ_NAME", "tncaccept");
                        paramMap.put("DATE_ACCEPT", dateAccept);
                        paramMap.put("TNC_XML", wrapper.getTNCAttrib("TNC_SAVE_XML"));
                        String paramString = E12CommonUtils.getInstance().getEncodedParamString(paramMap);
                        String url = String.valueOf(E12Global.getHostUrl()) + "/ibase/RIAWizardHandlerServlet?" + paramString;
                        HashMap<String, String> requestDataMap = new HashMap<String, String>();
                        E12RequestBuilder requestBuilder = new E12RequestBuilder(RequestBuilder.POST, url);
                        try {
                            try {
                                requestBuilder.sendRequest(requestDataMap, new RequestCallback(){

                                    public void onResponseReceived(Request request, Response response) {
                                        String respStr = response.getText();
                                        if (!"false".equalsIgnoreCase(respStr)) {
                                            Window.alert((String)respStr);
                                            wrapper.setAgreed(true);
                                            E12TermsNCondition.this.tncWrapperMap.put(tncCode, wrapper);
                                        }
                                    }

                                    public void onError(Request request, Throwable exception) {
                                        Window.alert((String)("ERROR: Error on E12TermsNCondition: " + exception.toString()));
                                    }
                                });
                            }
                            catch (Exception e) {
                                Window.alert((String)("ERROR: Error while calling servlet [" + url + "]: " + e.toString()));
                                throw new RuntimeException(e);
                            }
                        }
                        finally {
                            paramString = null;
                            url = null;
                        }
                        e12PopupPanel.hide();
                    }
                });
                e12PopupPanel.setWidget((Widget)e12TNCViewer);
                e12PopupPanel.show();
            }
        }
        catch (Exception e) {
            Window.alert((String)("Exception while showing Terms and Conditions[" + tncCode + "]\n[" + e.getMessage() + "]"));
        }
    }

    public VerticalPanel getListOfTNC(final Widget parent) {
        VerticalPanel listOfCode = new VerticalPanel();
        listOfCode.setSpacing(10);
        for (String cocCode : this.tncWrapperMap.keySet()) {
            Anchor anchor = new Anchor(cocCode);
            anchor.getElement().setId(cocCode);
            anchor.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    Anchor anchor = (Anchor)event.getSource();
                    if (parent instanceof PopupPanel) {
                        ((PopupPanel)parent).hide();
                    }
                    E12TermsNCondition.this.showTermsNCondition(anchor.getElement().getId());
                }
            });
            anchor.addStyleName("button");
            anchor.addStyleName("cocPanel-Btn");
            anchor.getElement().setAttribute("style", "color:white;");
            listOfCode.add((Widget)anchor);
        }
        return listOfCode;
    }
}

