package ibase.webitm.ejb.mfg.adv;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.dis.StockUpdate;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.ejb.fin.FinCommonInvAcct;
import ibase.webitm.ejb.fin.InvAcct;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import ibase.webitm.ejb.fin.FinCommon;	
import ibase.webitm.ejb.mfg.MfgCommon;	
import ibase.webitm.ejb.dis.DistCommon;	
import ibase.webitm.ejb.dis.InvAllocTraceBean;	
import ibase.webitm.ejb.mfg.LotWiseScanBean;	
import ibase.webitm.ejb.mfg.WOBean;	
import ibase.webitm.ejb.mfg.GenWOIssue;	
import ibase.webitm.ejb.mfg.adv.WorkorderIssConf;	

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.*; 
import java.sql.*;

import javax.ejb.Stateless;

@Stateless 
public class WorkorderIssConf extends ActionHandlerEJB implements WorkorderIssConfLocal,WorkorderIssConfRemote
{
	
	public String confirm(String tranID,String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{
		String retString = "";		
		Connection conn = null;	
		try
		{
			retString = confirm( tranID, xtraParams, forcedFlag,conn, "I");		
				
		}
		catch(Exception exception)
		{
			System.out.println("Exception in [RcpBackflushConfirm] confirm " + exception.getMessage());
		}
		return retString;
	}
	
	public String confirm( String tranID, String xtraParams,String forcedFlag,Connection conn, String issType ) throws RemoteException,ITMException
	{		
		System.out.println("************woiss_confirm ***************");
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		PreparedStatement pstmt = null,pstmt1 = null,pstmtDet =null,pstmtSL=null;
		ResultSet rs = null,rs1 = null,rsDet =null,rsSL=null;
		String sql = "",errCode ="",errString ="";
		String ledgpostconf ="";
		Timestamp  tranDate =null,effDate =null;
		String siteCode="",deptCode="",workOrder="",tranType="",tranIdReq="";
		int operation =0,upd=0,stkNoArt=0, LINEnO =1;
		String acctCodeWp="",cctrCodeWp="",orderType="",stkopt =null;
		String itemCode="",locCode="",lotNo="",lotSl="",unit="",expLev="",qcReqd="",reasCode="",calcPotency="";
		double quantity=0,shortQty=0,grossWeight=0,tareWeight=0,netWeight=0,potencyAdj=0;
		int lineNo=0,noArt=0;
		String itemSer="",itemunit="",trackShelfLife="";
		double stkQty=0,stkRate=0,grossRate=0,qtystduom=0;
		String issCriteria ="";
		String stkGrade="",suppCodeMfg="",acct_code__inv="",cctr_code__inv="",acct_code__oh="",cctr_code__oh="";
		HashMap stkUpdMap =null;
		String userId="",siteCodeVal="",useInvstatus="";
		String autoReqc="",itemUnit="",stkOpt="",tranSer="";
		String itemCodeRef="",detTable = "workorder_issdet", hdrTable ="workorder_iss";;
		double qtyPerArt = 0;
		ArrayList qtyStd = new ArrayList();
		GenericUtility genericUtility = null;
		boolean flag =false;
		boolean localConnection = false;
		try
		{
			if ( conn == null )
			{
				ConnDriver connDriver = null;
				connDriver = new ConnDriver();
				conn = connDriver.getConnectDB("DriverITM");
				conn.setAutoCommit(false);
				connDriver = null;
				localConnection = true;
			}
			genericUtility = GenericUtility.getInstance();
			stkUpdMap = new HashMap();
			DistCommon distCommon = new DistCommon();
			MfgCommon mfgCommon = new MfgCommon();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			tranID = rsSL.getString(1);
			sql = "select (case when LEDG_POST_CONF is null then 'N' else LEDG_POST_CONF end ) "
			+" from transetup where lower(tran_window) = 'w_worder_iss'  ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
					ledgpostconf = rs.getString(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			if(ledgpostconf == null )
			{
				ledgpostconf ="N";
			}
			if("R".equalsIgnoreCase(issType))
			{
				detTable ="WORDER_ISSDET_RND";
				hdrTable ="WORDER_ISS_RND";
			}
			else
			{
				detTable ="workorder_issdet";
				hdrTable ="workorder_iss";
			}
			sql = "select site_code 		, tran_date 		, dept_code 	, work_order, "
					+" tran_type 		, operation 		, eff_date  	, tran_id__req "
					+" from 	 "+hdrTable+" where  tran_id ='"+tranID+"' ";
			pstmt1 = conn.prepareStatement(sql);
			rs1 = pstmt1.executeQuery();
			if(rs1.next())
			{
				siteCode	= rs1.getString("site_code");
				tranDate	= rs1.getTimestamp("tran_date");
				deptCode	= rs1.getString("dept_code");
				workOrder	= rs1.getString("work_order");
				tranType	= rs1.getString("tran_type");
				operation	= rs1.getInt("operation");
				effDate		= rs1.getTimestamp("eff_date");
				tranIdReq	= rs1.getString("tran_id__req");
			}
			rs1.close();
			rs1 = null;
			pstmt1.close();
			pstmt1 = null;
			if("Y".equalsIgnoreCase(ledgpostconf))
			{
				//tranDate = new Timestamp(System.currentTimeMillis());
				SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
				tranDate =	java.sql.Timestamp.valueOf(sdf1.format(new Timestamp(System.currentTimeMillis())) + " 00:00:00.0");
				System.out.println("18/08/10 tranDate !"+tranDate);

				//String timeStr = 	genericUtility.getValidDateString(new Timestamp(System.currentTimeMillis()).toString(),genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat()) + " 00:00:00.000" ;
				//System.out.println("18/08/10 timeStr [" +timeStr + "]");
				//tranDate =  Timestamp.valueOf(timeStr);
			}
			sql =" select	acct_code__wp	, cctr_code__wp,	order_type "
				 +" from	  	workorder  where		work_order ='"+workOrder+"' ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				acctCodeWp	= rs.getString("acct_code__wp");
				cctrCodeWp	= rs.getString("cctr_code__wp");
				orderType	= rs.getString("order_type");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			if("R".equalsIgnoreCase(tranType))
			{
				 tranSer ="W-IRTN";
			}
			else
			{
				 tranSer ="W-ISS";
			}
			sql = "select 	item_code	,	loc_code		,	lot_no		,	lot_sl		,"
				  +"  quantity		,	unit			,	line_no		,	exp_lev		,	 "
				  +"  qc_reqd		,	nvl(potency_adj,0) as potency_adj	, 	reas_code	, 	gross_weight,	 "
				  +"  tare_weight	,	net_weight	, 	no_art		, 	short_qty	,	 "
				  +"  case when calc_potency is null then 'N' else calc_potency end	 calc_potency "
				  +" from 	 "+detTable+" where  tran_id ='"+tranID+"' ";
			pstmtDet = conn.prepareStatement(sql);
			rsDet = pstmtDet.executeQuery();
			while (rsDet.next())
			{
				itemCode		= rsDet.getString("item_code");
				locCode			= rsDet.getString("loc_code");
				lotNo			= rsDet.getString("lot_no");
				lotSl			= rsDet.getString("lot_sl");
				quantity		= rsDet.getDouble("quantity");
				unit			= rsDet.getString("unit");
				lineNo			= rsDet.getInt("line_no");
				expLev			= rsDet.getString("exp_lev");
				qcReqd			= rsDet.getString("qc_reqd");
				potencyAdj		= rsDet.getDouble("potency_adj");
				reasCode		= rsDet.getString("reas_code");
				grossWeight		= rsDet.getDouble("gross_weight");
				tareWeight		= rsDet.getDouble("tare_weight");
				netWeight		= rsDet.getDouble("net_weight");
				noArt			= rsDet.getInt("no_art");
				shortQty		= rsDet.getDouble("short_qty");
				calcPotency		= rsDet.getString("calc_potency");
				stkOpt = null;
				if("T".equalsIgnoreCase(orderType))
				{
					String strValue = mfgCommon.getEnvMfg("999999","RND_NO_STK_SITE",conn);
					if(! strValue.equals("NULLFOUND"))
					{
						strValue = strValue.trim();
						StringTokenizer st = new StringTokenizer(strValue,",");
						while (st.hasMoreTokens())
						{
							siteCodeVal = st.nextToken();
							if(siteCodeVal.equalsIgnoreCase(siteCode))
							{
								stkOpt = "0" ;
								break;
							}
						}
					}
				}
				if(stkOpt == null)
				{
					sql  ="select case when stk_opt is null then 'N' else stk_opt end "
					   +" from siteitem where item_code ='"+itemCode+"' "
					   +" and    site_code ='"+siteCode+"' ";
					pstmt = conn.prepareStatement(sql);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						stkOpt = rs.getString(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null ;
				}
				if(stkOpt == null || "N".equalsIgnoreCase(stkOpt) )
				{
					sql  ="select case when stk_opt is null then '0' else stk_opt end "
					   +" from item where item_code ='"+itemCode+"' " ;
					pstmt = conn.prepareStatement(sql);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						stkOpt = rs.getString(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null ;
				}
				if(! "0".equalsIgnoreCase(stkOpt))
				{
					///for qc_reqd to be first checked from siteitem &if not
					//then from item
					sql  ="select case when qc_reqd is null then 'N' else qc_reqd end "
							 +" from	siteitem where	item_code ='"+itemCode+"' "
							 +" and	site_code ='"+siteCode+"' ";
					pstmt = conn.prepareStatement(sql);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
								qcReqd = rs.getString(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null ;
					if(qcReqd ==null && qcReqd.trim().length() ==0)
					{
						sql  ="select case when qc_reqd is null then 'N' else qc_reqd end "
								+" from	item where	item_code ='"+itemCode+"' " ;
						pstmt = conn.prepareStatement(sql);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							qcReqd = rs.getString(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null ;
					}
					sql  ="select case when  auto_reqc is null then 'Y' else auto_reqc end"
						+" from siteitem where	site_code ='"+siteCode+"' "
						+" and item_code ='"+itemCode+"' ";
					pstmt = conn.prepareStatement(sql);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						autoReqc = rs.getString(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null ;
					if(autoReqc ==null && autoReqc.trim().length() ==0)
					{
						sql  ="select case when  auto_reqc is null then 'Y' else auto_reqc end "
								+" from	item where	item_code ='"+itemCode+"' " ;
						pstmt = conn.prepareStatement(sql);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							autoReqc = rs.getString(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null ;
					}
					sql  =" select item_ser, unit, nvl(track_shelf_life,'N') "
								+" from	item where	item_code ='"+itemCode+"' " ;
					pstmt = conn.prepareStatement(sql);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						itemSer = rs.getString(1);
						itemUnit = rs.getString(2);
						trackShelfLife = rs.getString(3);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null ;
					double stkquantity =0,stkalloc_qty=0;
					stkUpdMap.put("item_code",itemCode);
					stkUpdMap.put("item_ser",itemSer);
					stkUpdMap.put("site_code",siteCode);
					stkUpdMap.put("loc_code",locCode);
					stkUpdMap.put("lot_no",lotNo);
					stkUpdMap.put("lot_sl",lotSl);
					stkUpdMap.put("no_art",Integer.toString(Math.abs(noArt)) ); // 04/03/14 manoharan to pass no_art so that it will be reduced 
					
					
					
					if(! "R".equalsIgnoreCase(tranType))
					{
						if("Y".equalsIgnoreCase(calcPotency))
						{
							//genWOIssue.writeLog(this.curTranId, "In woiss_confirm() update stock  potencyAdj + quantity [" + potencyAdj + quantity + "]"); // 23/01/11 manoharan write the log
							stkUpdMap.put("quantity",Double.toString(potencyAdj + quantity));
						}
						else
						{
							//genWOIssue.writeLog(this.curTranId, "In woiss_confirm() update stock  quantity [" + quantity + "]"); // 23/01/11 manoharan write the log
							stkUpdMap.put("quantity",Double.toString(quantity));
						}
					}
					else
					{
						if("Y".equalsIgnoreCase(calcPotency))
						{
							//genWOIssue.writeLog(this.curTranId, "In woiss_confirm() update stock  potencyAdj + quantity [" + potencyAdj + quantity + "]"); // 23/01/11 manoharan write the log
							stkUpdMap.put("quantity",Double.toString(Math.abs(quantity + potencyAdj)));
						}
						else
						{
							//genWOIssue.writeLog(this.curTranId, "In woiss_confirm() update stock  quantity [" + quantity + "]"); // 23/01/11 manoharan write the log
							stkUpdMap.put("quantity",Double.toString(Math.abs(quantity)) );
						}
					}
					// 11/07/13 manoharan to avoid null pointer exception
					//genWOIssue.writeLog(this.curTranId, "In woiss_confirm() workorder_issdet unit was null");
					if (unit == null || unit.trim().length() == 0)
					{
						unit = itemUnit;
					}
					// 11/07/13 manoharan to avoid null pointer exception
					stkUpdMap.put("unit",unit);
					if(! unit.equalsIgnoreCase(itemUnit))
					{
						if("Y".equalsIgnoreCase(calcPotency))
						{
							qtyStd   = distCommon.getConvQuantityFact(unit,itemUnit,itemCode,potencyAdj + quantity,0.0,conn);
							qtystduom = Double.parseDouble(qtyStd.get(1).toString());
							// qtystduom = gf_conv_qty_fact(ls_unit, ls_itemunit, ls_item, ld_qty + ld_potency_adj_qty, ld_convfact)
						}
						else
						{
							 qtyStd = distCommon.getConvQuantityFact(unit,itemUnit,itemCode,quantity,0.0,conn);
							 qtystduom = Double.parseDouble(qtyStd.get(1).toString());
							//qtystduom = gf_conv_qty_fact(ls_unit, ls_itemunit, ls_item, ld_qty , ld_convfact)
						}
						if(qtystduom < 0 && !"R".equalsIgnoreCase(tranType))
						{
							errCode = "VTUNIT3";
						}
					}
					else
					{
						if("Y".equalsIgnoreCase(calcPotency))
						{
							qtystduom = potencyAdj + quantity;
							qtystduom =getReqDecimal(qtystduom,3);
						}
						else
						{
							qtystduom = quantity;
							qtystduom =getReqDecimal(qtystduom,3);
						}
					}
					if(! "R".equalsIgnoreCase(tranType))
					{
						stkUpdMap.put("qty_stduom",Double.toString(qtystduom));
					}
					else
					{
						stkUpdMap.put("qty_stduom",Double.toString(Math.abs(qtystduom)));
					}
					//genWOIssue.writeLog(this.curTranId, "In woiss_confirm() update stock  qty_stduom [" + qtystduom + "]"); // 23/01/11 manoharan write the log
					//stkUpdMap.put("qty_stduom",Double.toString(stkquantity));
					stkUpdMap.put("tran_type","ID");
					stkUpdMap.put("tran_date",tranDate);
					stkUpdMap.put("tran_id",tranID);
					stkUpdMap.put("tran_ser",tranSer);
					stkUpdMap.put("sorder_no",workOrder);
					//stkUpdMap.put("line_no",Integer.toString(lineNo));
					System.out.println("manoharan 30/11/12 2  substring 3  [" + ("   " +lineNo).substring(("   " +lineNo).length()-3) + "] lineNoIss [" + lineNo + "]");
					stkUpdMap.put("line_no",("   " +lineNo).substring(("   " +lineNo).length()-3));
					//	stkUpdMap.put("lineno",workOrder);left('   ',3 -len(trim(String(ll_lineno)))) + trim(String(ll_lineno)
					stkUpdMap.put("site_code__mfg",siteCode);
					stkUpdMap.put("sundry_code",deptCode);
					stkUpdMap.put("sundry_type","D");
					if( "I".equalsIgnoreCase(tranType) || "O".equalsIgnoreCase(tranType) || "D".equalsIgnoreCase(tranType) || "F".equalsIgnoreCase(tranType) )
					{
						sql   =" select item_code, item_code__ref "
							+" from workorder_bill  where work_order  ='"+workOrder+"' "
							+" and operation ="+operation
							+" and exp_lev ='"+expLev+"'";
						pstmt = conn.prepareStatement(sql);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							itemCode 	= rs.getString(1);
							itemCodeRef = rs.getString(2);
							sql =" select use_invstatus from bomdet where bom_code = "
								+" (select bom_code from workorder where work_order = '"+workOrder+"' ) "
								+" and item_code ='"+itemCode+"' "
								+" and item_ref ='"+itemCodeRef+"'";
							pstmt = conn.prepareStatement(sql);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								useInvstatus = rs.getString(1);
							}
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null ;
						if(useInvstatus == null)
						{
							useInvstatus = "U";
						}
						sql =" Select a.quantity,rate, a.grade, a.supp_code__mfg, a.acct_code__inv, a.cctr_code__inv, "
							+" a.acct_code__oh,a.cctr_code__oh,a.gross_rate ,a.qty_per_art  "
							+" from stock a, location b, invstat c where  "
							+" a.loc_code = b.loc_code and b.inv_stat = c.inv_stat "
							+" and a.item_code ='"+itemCode+"' "
							+" and a.site_code ='"+siteCode+"'"
							+" and a.lot_no ='"+lotNo+"' "
							+" and a.lot_sl ='"+lotSl+"' "
							+" and a.loc_code ='"+locCode+"' "
							+" and c.stat_type <> 'S' ";

						if("Y".equalsIgnoreCase(trackShelfLife) || "U".equalsIgnoreCase(useInvstatus))
						{
							sql = sql+" and (( a.exp_date >  ? or  a.exp_date is null )) ";
						}
						if("U".equalsIgnoreCase(useInvstatus))
						{
							sql = sql+" and c.available = 'Y' ";
						}
						if( "Y".equalsIgnoreCase(qcReqd) || "Y".equalsIgnoreCase(autoReqc) )
						{
							sql = sql+" and ( a.retest_date > ? ) ";
						}
						pstmt = conn.prepareStatement(sql);
						if("Y".equalsIgnoreCase(trackShelfLife) || "U".equalsIgnoreCase(useInvstatus))
						{
							pstmt.setTimestamp(1,effDate);
							flag =true;
						}
						if( "Y".equalsIgnoreCase(qcReqd) || "Y".equalsIgnoreCase(autoReqc) )
						{
							if(flag)
							{
								pstmt.setTimestamp(2,effDate);
							}
							else
							{
								pstmt.setTimestamp(1,effDate);
							}
						}
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							stkQty			= rs.getDouble(1);
							stkRate			= rs.getDouble(2);
							stkGrade		= rs.getString(3);
							suppCodeMfg		= rs.getString(4);
							acct_code__inv	= rs.getString(5);
							cctr_code__inv	= rs.getString(6);
							acct_code__oh	= rs.getString(7);
							cctr_code__oh	= rs.getString(8);
							grossRate		= rs.getDouble(9);
							qtyPerArt		= rs.getDouble(10);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null ;
						// if any of the weight or no_art is zero get from stock as per old logic
						sql =" select a.no_art, a.gross_weight,a.tare_weight,a.net_weight "
						  +" from stock a  where a.item_code ='"+itemCode+"' "
						  +" and a.site_code ='"+siteCode+"' "
						  +" and a.lot_no ='"+lotNo+"' "
						  +" and a.lot_sl ='"+lotSl+"' "
						  +" and a.loc_code ='"+locCode+"' ";
						pstmt = conn.prepareStatement(sql);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							stkNoArt			= rs.getInt(1);
							grossWeight			= rs.getDouble(2);
							tareWeight			= rs.getDouble(3);
							netWeight			= rs.getDouble(4);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null ;
						if("R".equalsIgnoreCase(tranType))
						{
						  stkUpdMap.put("acct_code__dr",acct_code__inv);
						  stkUpdMap.put("cctr_code__dr",cctr_code__inv);
						  stkUpdMap.put("acct_code__cr",acctCodeWp);
						  stkUpdMap.put("cctr_code__cr",cctrCodeWp);
						}
						else
						{
						  stkUpdMap.put("acct_code__dr",acctCodeWp);
						  stkUpdMap.put("cctr_code__dr",cctrCodeWp);
						  stkUpdMap.put("acct_code__cr",acct_code__inv);
						  stkUpdMap.put("cctr_code__cr",cctr_code__inv);
						}
						sql =" select iss_criteria  from item  where  item_code ='"+itemCode+"'";
						pstmt = conn.prepareStatement(sql);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							issCriteria	= rs.getString(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null ;
						double noOfArt =0;
						int noOfArticles = 0;
						quantity=  Double.parseDouble(stkUpdMap.get("quantity").toString());  //04/06/09
						quantity = getReqDecimal(quantity,3);
						if(quantity > qtyPerArt )
						{
							noOfArt = quantity / qtyPerArt;
							if(noOfArt > (int)noOfArt)
							{
								 noOfArticles  =(int)noOfArt+1;
							}
							else
							{
							 noOfArticles = (int)noOfArt;
							}
						}
						else
						{
							noOfArticles =1;
						}

						// 19/05/10 manoharan no_art to be rounded to integer
						//stkUpdMap.put("gross_weight",Double.toString(grossWeight));
						//stkUpdMap.put("tare_weight",Double.toString(tareWeight));
						//stkUpdMap.put("net_weight",Double.toString(netWeight));
						stkUpdMap.put("gross_weight", getReqDecString(grossWeight, 3));
						stkUpdMap.put("tare_weight",getReqDecString(tareWeight, 3));
						stkUpdMap.put("net_weight",getReqDecString(netWeight, 3));


						//stkUpdMap.put("no_art",Integer.toString(noOfArticles));

						noOfArticles = (new Double(noOfArticles)).intValue();
						// end 19/05/10 manoharan



						stkUpdMap.put("grade",stkGrade);
						stkUpdMap.put("gross_rate",Double.toString(grossRate));
						stkUpdMap.put("supp_code__mfg",suppCodeMfg);
						stkUpdMap.put("acct_code_inv",acct_code__inv);
						stkUpdMap.put("cctr_code_inv",cctr_code__inv);
						stkUpdMap.put("acct_code_oh",acct_code__oh);
						stkUpdMap.put("cctr_code_oh",cctr_code__oh);
						//genWOIssue.writeLog(this.curTranId, "In woiss_confirm() 04/03/14  stkUpdMap [" + stkUpdMap.toString() + "]"); // 04/03/14 manoharan write the log
						StockUpdate stkUpd =  new StockUpdate();
						errString = stkUpd.updateStock(stkUpdMap,xtraParams,conn);
						stkUpd =null;
						if(errString != null && errString.indexOf("Error") != -1  )
						{
							return errString;
						}
						stkUpdMap.clear();
						//stkOpt ="0";
					}
				}
				if("0".equalsIgnoreCase(stkOpt))
				{
					upd =0;
					sql ="update workorder_bill set iss_qty =  quantity + nvl(potency_adj,0) , "
					  +" iss_date = ? where  work_order ='"+workOrder+"'  and operation ="+operation
					  +"and exp_lev ='"+expLev+"'";
					pstmt = conn.prepareStatement(sql);
					pstmt.setTimestamp(1,new Timestamp(System.currentTimeMillis()));
					upd = pstmt.executeUpdate();
					pstmt.close();
					pstmt = null ;
				}
				else
				{
					upd =0;
					sql ="update workorder_bill set iss_qty =  case when iss_qty is null then 0 else iss_qty end + " + quantity
					  +", iss_date = ? where  work_order ='"+workOrder+"'  and operation ="+operation
					  +"and exp_lev ='"+expLev+"'";
					pstmt = conn.prepareStatement(sql);
					pstmt.setTimestamp(1,new Timestamp(System.currentTimeMillis()));
					upd = pstmt.executeUpdate();
					pstmt.close();
					pstmt = null ;
				}
			}
			rsDet.close();
			rsDet = null;
			pstmtDet.close();
			pstmtDet = null;
			String empCodeAprv = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");

			sql =" update "+hdrTable+" set emp_code__aprv ='"+empCodeAprv+"' ,confirmed ='Y', chg_term ='"+userId+"', tran_date =?,conf_date=? "
				+" where tran_id ='"+tranID+"' ";
			pstmt = conn.prepareStatement(sql); //conf_date
			pstmt.setTimestamp(1,tranDate);
			//CHANGED BY HKUMAR ON 18-03-10
			//pstmt.setTimestamp(2,new Timestamp(System.currentTimeMillis()));//conf_date added on 04/01/2010 at dadra
			Timestamp confDate = new Timestamp(System.currentTimeMillis());
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
			java.util.Date date = sdf.parse(confDate.toString());
			confDate = Timestamp.valueOf(sdf.format(date).toString() + " 00:00:00.0");
			pstmt.setTimestamp(2,confDate);
			upd = pstmt.executeUpdate();
			pstmt.close();
			pstmt = null ;
			if ("R".equals(tranType) )
			{
				tranSer = "W-IRTN";
			}
			else
			{
				tranSer = "W-ISS";
			}
			if ( errString == null || errString.trim().length() == 0 ) 
			{
				InvAcct invAcct = new InvAcct();
				errString = invAcct.wipPost( tranID,tranSer,  conn );
			}
			if (errString == null || errString.trim().length() == 0)
			{
				if( localConnection )
				{
					conn.commit();
				}
				errString = itmDBAccessEJB.getErrorString("","VTCNFSUCC","");
			}
			else
			{
				if( localConnection )
				{
					conn.rollback();
					
				}
			}
			
		}
		catch(SQLException ex)
		{
			ex.printStackTrace();
			errString = "VTCONFERR";
			throw new ITMException(ex);
		}
		catch(Exception e)
		{
			e.printStackTrace();
			errString = "VTCONFERR";
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;					
				}		
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;					
				}		
				//if( conn != null && ! conn.isClosed() ) // Gulzar - 25/11/11
				if( conn != null && !conn.isClosed() && localConnection ) //Gulzar - 25/11/11
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println(e.getMessage());
				throw new ITMException(e);
			}
		}
		return errString;
	}	
	public double getReqDecimal(double actVal, int prec)  throws ITMException, Exception
	{
		DecimalFormat decFormat = null;
		try
		 {
			String fmtStr = "############0";
			String strValue = null;
			//System.out.println("manohar 18/08/10 actVal  [" + actVal + "]");
			if (prec > 0)
			{
				fmtStr = fmtStr + "." + "000000000".substring(0, prec);
			}
			decFormat = new DecimalFormat(fmtStr);
			//System.out.println("manohar 03/08/10 confirm DecimalFormat(fmtStr) [" + decFormat + "]");
			//System.out.println("manohar 03/08/10 confirm Double.parseDouble(decFormat.format(actVal)) [" + Double.parseDouble(decFormat.format(actVal)) + "]");
		}
		catch(Exception e)
		{
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			actVal = 0;
			System.out.println("manohar 03/08/10 confirm Double.parseDouble(decFormat.format(actVal)) [" + Double.parseDouble(decFormat.format(actVal)) + "]");
			throw new ITMException(e);
		}
		//
		return Double.parseDouble(decFormat.format(actVal));
	}
	public String getReqDecString(double actVal, int prec)
	{
		NumberFormat numberFormat = NumberFormat.getIntegerInstance ();
		Double DoubleValue = new Double (actVal);
		numberFormat.setMaximumFractionDigits(3);
		String strValue = numberFormat.format(DoubleValue);
		strValue = strValue.replaceAll(",","");
		//double reqVal = Double.parseDouble(strValue);
		//return reqVal;
		return strValue;
	}
}
