package ibase.webitm.bean.wms;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.wms.DDProductWizRemote;
import ibase.webitm.utility.ITMException;

import javax.naming.InitialContext;
import javax.servlet.http.HttpSession;

public class ItemDetailsBean
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	private ibase.utility.UserInfoBean userInfo = null;
	private HttpSession sessionCtx = null;
	private String objName = "";
	private String user_lang ="en"; 
	private String user_country = "US";
	
	/**
	 * 
	 * @param objName
	 * @param sessionCtx
	 * @throws ITMException
	 */
	public ItemDetailsBean(String objName, HttpSession sessionCtx) throws ITMException 
	{
		try
		{
			this.objName = objName;
			this.sessionCtx = sessionCtx;
			this.userInfo = ( ibase.utility.UserInfoBean ) this.sessionCtx.getAttribute("USER_INFO");
			
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
	}
	
	public ItemDetailsBean() {
		// TODO Auto-generated constructor stub
	}

	/**
	 * display list in popup 
	 * @param loginCode
	 * @param field
	 * @param values
	 * @return
	 * @throws ITMException
	 */
	public String getList( String loginCode, String field, String[] values ) throws ITMException
	{
		System.out.println("loginCode in getList =["+loginCode+"]");
		String itemTypeList = "";
		
		DDProductWizRemote ddProductWizRemote = null;
		
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			ddProductWizRemote = (ibase.webitm.ejb.wms.DDProductWizRemote) ctx.lookup("ibase/DDProductWizEJB/remote");
			itemTypeList = ddProductWizRemote.getList(loginCode, field, values);

			String xslFileName = getXSLFileName( "dd_productWiz_itemList_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			
			itemTypeList = (genericUtility).transformToString( xslFileName, itemTypeList, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );

		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if ( ddProductWizRemote != null )
			{
				ddProductWizRemote = null;
			}
		}
		return itemTypeList;
	}
	
	/**
	 * go to prevoius form
	 * @param formNo
	 * @param xmlData
	 * @return
	 * @throws ITMException
	 */
	public String previousForm( String formNo, String xmlData ) throws ITMException 
	{
		String retHtmlData = null;
		
		try
		{
			System.out.println("In Method : [previousForm]");
			
			System.out.println("xmlString : ["+ xmlData +"]");
			
			String xslFileName = getXSLFileName( this.objName + formNo + "_wiz_" + this.user_lang + "_" + this.user_country + "_" + "A" + ".xsl" );
			
			retHtmlData = (genericUtility).transformToString( xslFileName, xmlData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );

		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
		}
		return retHtmlData;
	}
	
	/**
	 * get XSL filename
	 * @param xslFileName
	 * @return
	 * @throws ITMException
	 */
	private String getXSLFileName( String xslFileName )throws ITMException
	{   
		String retFileName = null;
		try
		{
			String defaultPath = null;
			if( CommonConstants.APPLICATION_CONTEXT != null )
			{
				defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT + File.separator;
			}
			else
			{
				defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + CommonConstants.ITM_CONTEXT + File.separator;
			}
			File xslPath = new File( defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME + File.separator + "WIZARD");
			if ( !xslPath.exists() )
			{
				xslPath.mkdir();
			}
			System.out.println( " xslPath [" + xslPath +"] xslFileName ["+xslFileName +"]");
			File xslFile = new File(xslPath , xslFileName);
			if( xslFile.exists() )
			{
				retFileName = xslFile.getAbsolutePath();
			}
			else
			{
				throw new ITMException( new Exception( retFileName + " Wizard XSL file Not Found") );	
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return retFileName;
	}
	
	/**
	 * 
	 * @param sizeCode
	 * @return
	 * @throws ITMException
	 */
	//Added by Parikshit Kumbhar on 18/05/2015 [added getSizeDetails() function] Start
	public String getSizeDetails( String sizeCode ) throws ITMException 
	{
		E12GenericUtility genericUtility = new E12GenericUtility();
		StringBuffer valueXmlString = new StringBuffer("<Root>\r\n");
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try 
		{
			ConnDriver connDriver = new ConnDriver();
			//Added & replace by sarita on 27DEC2017 
			//conn = connDriver.getConnectDB("DriverITM");
			conn = connDriver.getConnectDB(userInfo.getTransDB());

			String sql = "SELECT Attrib_Id, TRIM(Descr),trim(sh_descr) FROM itm_attrib_val WHERE Attrib_Code=? ORDER BY sort_order";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, sizeCode);
			rs = pstmt.executeQuery();
			
			int num = 1;
			while (rs.next())
			{
				String fieldId = checkNullAndTrim(rs.getString(1));
				String fieldValue = checkNullAndTrim(rs.getString(2));
				//Changed by Samadhan on 22/12/2015
				String shortDescr = checkNullAndTrim(rs.getString(3));

				valueXmlString.append("<PROD_SIZE domID='"+ num +"' selected = 'N'>\r\n");

				valueXmlString.append("<fieldId><![CDATA[").append(fieldId).append("]]></fieldId>\r\n");
				valueXmlString.append("<fieldValue><![CDATA[").append(fieldValue).append("]]></fieldValue>\r\n");
				//Changed by Samadhan on 22/12/2015
				valueXmlString.append("<shortDescr><![CDATA[").append(shortDescr).append("]]></shortDescr>\r\n");
				valueXmlString.append("</PROD_SIZE>\r\n");
				num++;
			}
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
			System.out.println("Exception :ITMWizardStatefulEJB :getList(String):"	+ e.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		} 
		finally 
		{
			try 
			{
				if (rs != null) 
				{					
					rs.close();
					rs = null;
				}
				if (pstmt != null ) 
				{					
					pstmt.close();
					pstmt = null;
				}
				if (conn != null && !conn.isClosed()) 
				{					
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e) 
			{
				System.out.println("Exception :ITMWizardStatefulEJB :getProdTypeList(String) :==>\n"+ e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append("</Root>\r\n");
		System.out.println("\n****ValueXmlString :" + valueXmlString.toString()	+ ":********");
		
		return valueXmlString.toString();
	}
	//Added by Parikshit Kumbhar on 18/05/2015 [added getSizeDetails() function] End
	
	// Changed by Sneha on 25-10-2016, for customer item reference flag [Start]
	public String getCustItemRefFlag() throws ITMException 
	{
		String itemTypeList = "";
		
		DDProductWizRemote ddProductWizRemote = null;
		
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			ddProductWizRemote = (ibase.webitm.ejb.wms.DDProductWizRemote) ctx.lookup("ibase/DDProductWizEJB/remote");
			itemTypeList = ddProductWizRemote.getCustItemRefFlagVal();
			
			System.out.println("getCustItemRefFlag =====>>["+itemTypeList+"]");
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if ( ddProductWizRemote != null )
			{
				ddProductWizRemote = null;
			}
		}
		return itemTypeList;
	}
	// Changed by Sneha on 25-10-2016, for customer item reference flag [End]
	
	// Changed by Sneha on 23-11-2016, to default values flag [Start]
	public String getDefaultValuesFlag() throws ITMException 
	{
		String defaultValuesFlag = "";
		DDProductWizRemote ddProductWizRemote = null;
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			ddProductWizRemote = (ibase.webitm.ejb.wms.DDProductWizRemote) ctx.lookup("ibase/DDProductWizEJB/remote");
			defaultValuesFlag = ddProductWizRemote.defaultValueFlag();
			
			System.out.println("getDefaultValuesFlag =====>>["+defaultValuesFlag+"]");
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if ( ddProductWizRemote != null )
			{
				ddProductWizRemote = null;
			}
		}
		return defaultValuesFlag;
	}
	// Changed by Sneha on 23-11-2016, to default values flag [End]
	
	// Changed by Sneha on 25-10-2016, for customer item reference flag [Start]
	public String getDefaultBarcodeFlag() throws ITMException 
	{
		String returnVal = "";
		
		DDProductWizRemote ddProductWizRemote = null;
		
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			ddProductWizRemote = (ibase.webitm.ejb.wms.DDProductWizRemote) ctx.lookup("ibase/DDProductWizEJB/remote");
			returnVal = ddProductWizRemote.getDefaultBarcodeFlagVal();
			
			System.out.println("getDefaultBarcodeFlag =====>>["+returnVal+"]");
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if ( ddProductWizRemote != null )
			{
				ddProductWizRemote = null;
			}
		}
		return returnVal;
	}
	// Changed by Sneha on 25-10-2016, for customer item reference flag [End]
		
	
	// Changed by Sneha on 25-10-2016, for customer item reference flag [Start]
	/*public String defaultBarcodeVal(String userId) throws ITMException 
	{
		String returnVal = "";
		
		DDProductWizRemote ddProductWizRemote = null;
		
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			ddProductWizRemote = (ibase.webitm.ejb.wms.DDProductWizRemote) ctx.lookup("ibase/DDProductWizEJB/remote");
			returnVal = ddProductWizRemote.generateTranId("w_barcode", userId, null);
			
			System.out.println("defaultBarcodeVal =====>>["+returnVal+"]");
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if ( ddProductWizRemote != null )
			{
				ddProductWizRemote = null;
			}
		}
		return returnVal;
	}*/
	// Changed by Sneha on 25-10-2016, for customer item reference flag [End]
		
	
	/**
	 * 
	 * @param input
	 * @return
	 */
	private String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}	
}
