package ibase.webitm.ejb.dis.adv;

import java.text.SimpleDateFormat;
import java.util.*;
import java.sql.*;
import java.rmi.RemoteException;
import org.w3c.dom.*;

import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.ejb.fin.FinCommon;

import ibase.webitm.utility.ITMException;
import javax.ejb.Stateless; // added for ejb3
import javax.naming.InitialContext;

@Stateless // added for ejb3
public class StockTransferAct extends ActionHandlerEJB implements StockTransferActLocal,StockTransferActRemote
{
	public String actionHandler() throws RemoteException,ITMException
	{
		return "";
	}
	
	public String actionHandler(String actionType, String xmlString, String xmlString1, String objContext, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		String  retString = null;

		ibase.utility.E12GenericUtility genericUtility= new  ibase.utility.E12GenericUtility();
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				System.out.println("XML String :"+xmlString);
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				System.out.println("XML String1 :"+xmlString1);
				dom1 = genericUtility.parseString(xmlString1);
			}

			System.out.println("actionType:"+actionType+":");

			if (actionType.equalsIgnoreCase("All Items"))
			{
				
				retString = actionAllItems(dom, dom1, xtraParams, actionType); 
			}
			
			if (actionType.equalsIgnoreCase("Stock"))
			{
				retString = actionStock(dom, dom1, xtraParams);
			}
			
			if (actionType.equalsIgnoreCase("Allocate"))
			{
				StringBuffer valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n");
				retString = actionAllocate(dom, dom1, xtraParams, actionType); 
				valueXmlString.append(retString);
				valueXmlString.append("</Root>\r\n");
				retString = valueXmlString.toString();
			}
		
		}
	   	catch(Exception e)
		{
			System.out.println("Exception :StockTransferAct :actionHandler(String xmlString):" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("returning String from StockTransferAct : actionHandler"+retString);
	    return retString;
	}
	
	public String actionHandlerTransform(String actionType, String xmlString, String xmlString1, String objContext, String xtraParams, String selDataStr) throws RemoteException,ITMException
	{
		System.out.println("actionHandlerTransform is calling.............");
		Document dom = null;
		Document dom1 = null;
		Document selDataDom = null;

		String  retString = null;
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = new  ibase.utility.E12GenericUtility().parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = new  ibase.utility.E12GenericUtility().parseString(xmlString1);
			}
			if(selDataStr != null && selDataStr.length() > 0)
			{
				selDataDom = new  ibase.utility.E12GenericUtility().parseString(selDataStr);
			}

			System.out.println("actionType:"+actionType+":");
						
			if (actionType.equalsIgnoreCase("Stock"))
			{
				retString = stockTransform(dom, dom1, objContext, xtraParams, selDataDom);
			}
		}
	   	catch(Exception e)
		{
			System.out.println("Exception :StockTransferAct :actionHandlerTransform(String xmlString):" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("returning String from StockTransferAct : actionHandlerTransform"+retString);
	    return retString;
	}


private String actionAllItems(Document dom, Document dom1, String xtraParams, String actionType) throws RemoteException,ITMException //Added - - Gulzar 25/04/07
	{
	System.out.println("xmlString from StockTransferEJB :"+dom+" \n xmlString1 :"+dom1);
	String consumeOrder = "",refSerFor="";

	ResultSet rs = null;
	Connection conn = null;
	Statement stmt = null;
	PreparedStatement pstmt = null;
	ArrayList lineNo = new ArrayList();
	String lineNoStr = "",locCode = "",availableYn = "",available = "",sql = "",errCode = "", errString = "";
	StringBuffer valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n");
	StringBuffer allocateBuffer = new StringBuffer("");
	StringBuffer itemChgXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n"); 
	String allocateStr = "";
	String detailCnt = "";
	String itemChgRetStr = "";
	int detCnt = 0;
	 String refserfr = "";
	 String consOrder = "";
	Document temp = null;

	ibase.utility.E12GenericUtility genericUtility= new  ibase.utility.E12GenericUtility();
	System.out.println("Action Default Entry time :: " );
	detailCnt = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"detCnt"); 
	if (detailCnt != null)
	{
		detCnt = Integer.parseInt(detailCnt);
		System.out.println("detCnt...........:: " + detCnt);
	}
	
	if (dom == null || detCnt > 1) 
	{
		valueXmlString.append("</Root>\r\n");
		return valueXmlString.toString();
	}

	ConnDriver connDriver = new ConnDriver();

	ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
	try
	{
	
		conn = getConnection();
		
		stmt = conn.createStatement();
		consumeOrder = genericUtility.getColumnValue("ref_id__for",dom1);	
		
	    if(consumeOrder != null && consumeOrder.trim().length() > 0)
	    {
		 consOrder = consumeOrder;				
         System.out.println("Consumer Order Reference series::::::::"+consOrder);					
		}
	    
		 refSerFor = genericUtility.getColumnValue("ref_ser__for",dom1);
		 if(refSerFor.trim().equalsIgnoreCase("C-ORD"))
		 {
	        refserfr = refSerFor;
			System.out.println("Consumer Order Reference id::::::::"+refserfr);
		 }
		
		 locCode = genericUtility.getColumnValue("loc_code",dom);
			System.out.println("locCode :"+locCode);
			if(locCode != null && locCode.trim().length() > 0)
			{
				availableYn = genericUtility.getColumnValue("available_yn",dom1);
				System.out.println("availableYn :"+availableYn);
				sql = "SELECT B.AVAILABLE FROM LOCATION A , INVSTAT B "
					 +"WHERE A.INV_STAT = B.INV_STAT AND A.LOC_CODE  = '"+locCode+"'";
				System.out.println("sql :"+sql);
				rs = stmt.executeQuery(sql);
				if (rs.next())
				{
					available = rs.getString(1);
					System.out.println("available :"+available);
				}
				
				rs.close();
				rs=null;
				stmt.close();
				stmt=null;
				if (!available.equalsIgnoreCase(availableYn))
				{
					errCode = "VTAVAIL";
					errString = itmDBAccess.getErrorString("",errCode,"","",conn);
					System.out.println("errString :"+errString);
					return errString;
				}
			}
	 
		
		System.out.println("The size of ArrayList :"+lineNo.size());
		
		itemChgRetStr = getItemChanged(dom1,consumeOrder,conn);
		itemChgXmlString.append(itemChgRetStr);

		itemChgXmlString.append("</Root>\r\n"); 
		
		if(itemChgXmlString.toString() != null && itemChgXmlString.toString().trim().length()!=0)
		{
			System.out.println("After ItemChange Of Detail [itemChgXmlString] :"+itemChgXmlString.toString());
			dom = genericUtility.parseString(itemChgXmlString.toString()); 
		}
		valueXmlString.append("</Root>\r\n");
	
	}
	catch (SQLException sqx)
	{
		System.out.println("The sqlException occure in StockTransferAct :"+sqx);
		throw new ITMException(sqx);
	}
	catch (Exception e)
	{
		System.out.println("The Exception occure in StockTransferAct :"+e);
		throw new ITMException(e);
	}
	finally
	{
		try
		{
			conn.close();
			conn = null;
		}
		catch (Exception e){}
	}
	System.out.println("valueXmlString return from StockTransferAct[actionAllItems] :"+itemChgXmlString.toString());
	return itemChgXmlString.toString();

	} //End of actionAllItems method 

private String actionStock(Document dom, Document dom1, String xtraParams)throws RemoteException, ITMException
{

	String siteCode = "", itemCode = "", quantity = "", availableYn = "", sql = "";
	String errCode = "", errString = "";
	String expDate1 = "", retestDate1 = "";
	java.sql.Date expDate = null, retestDate = null;
	int countItemCode = 0;
	Statement stmt = null;
	ResultSet rs = null;
	Connection conn = null;
	StringBuffer valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n");

	if (dom == null)
	{
		valueXmlString.append("</Root>\r\n");
		return valueXmlString.toString();
	}

	ibase.utility.E12GenericUtility genericUtility= new  ibase.utility.E12GenericUtility();
	ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
	ConnDriver connDriver = new ConnDriver();
	try
	{
		
		conn = getConnection();		
		stmt = conn.createStatement();

		siteCode = genericUtility.getColumnValue("site_code",dom1);
		System.out.println("site_code :"+siteCode);
		itemCode = genericUtility.getColumnValue("item_code", dom);
		System.out.println("itemCode :"+itemCode);
		quantity = genericUtility.getColumnValue("quantity", dom);
		System.out.println("quantity :"+quantity);
		//availableYn = genericUtility.getColumnValue("available_yn", dom1);
		System.out.println("availableYn :"+availableYn);

		sql = "SELECT COUNT(*) FROM STOCK A, INVSTAT B "
				+"WHERE A.INV_STAT  = B.INV_STAT "
				+"AND A.ITEM_CODE = '"+itemCode+"' "
				+"AND A.SITE_CODE = '"+siteCode+"' "
				+"AND B.AVAILABLE = '"+availableYn+"' "
				+"AND (CASE WHEN ((CASE WHEN A.QUANTITY IS NULL THEN 0 ELSE A.QUANTITY END) - (CASE WHEN A.ALLOC_QTY IS NULL THEN 0 ELSE A.ALLOC_QTY END)) IS NULL THEN 0 ELSE ((CASE WHEN A.QUANTITY IS NULL THEN 0 ELSE A.QUANTITY END) - (CASE WHEN A.ALLOC_QTY IS NULL THEN 0 ELSE A.ALLOC_QTY END))END)  > 0";
		System.out.println("SQL :"+sql);
		rs = stmt.executeQuery(sql);
		if (rs.next())
		{
			countItemCode = rs.getInt(1);
			System.out.println("countItemCode :"+countItemCode);
		}
		if (countItemCode == 0)
		{
			errCode = "VTSTOCK1";
			errString = itmDBAccess.getErrorString("",errCode,"","",conn);
			System.out.println("errString :"+errString);
			return errString;
		}
		sql = "SELECT STOCK.ITEM_SER, "  
				+"STOCK.ITEM_CODE, " 
				+"STOCK.UNIT, " 
				+"STOCK.LOC_CODE, " 
				+"STOCK.LOT_NO," 
				+"STOCK.LOT_SL,"			
				+"STOCK.QUANTITY - STOCK.ALLOC_QTY AS QUANTITY, " 
				+"STOCK.SITE_CODE, " 
				+"STOCK.NO_ART, "
				+"STOCK.EXP_DATE, " 
				+"STOCK.RETEST_DATE, " 
				+"STOCK.DIMENSION, " 
				+"STOCK.RATE "  
				+"FROM STOCK, INVSTAT " 
				+"WHERE STOCK.INV_STAT = INVSTAT.INV_STAT "
				+"AND STOCK.ITEM_CODE = '"+itemCode+"' "
				+"AND STOCK.SITE_CODE = '"+siteCode+"' "
				+"AND STOCK.QUANTITY - STOCK.ALLOC_QTY > 0 "
				+"AND INVSTAT.AVAILABLE = '"+availableYn+"' "
				+"ORDER BY CASE WHEN STOCK.EXP_DATE IS NULL THEN STOCK.CREA_DATE ELSE STOCK.EXP_DATE END ASC, STOCK.LOT_NO ASC, STOCK.LOT_SL ASC";
		System.out.println("sql :"+sql);						
		rs = stmt.executeQuery(sql);
		//SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
		while (rs.next())
		{
			/*expDate = rs.getDate(9);
			if (expDate != null)
			{
				expDate1 = sdf.format(expDate);
				System.out.println("expDate1 :"+expDate1);
			}
			retestDate = rs.getDate(10);
			if (retestDate != null)
			{
				retestDate1 = sdf.format(retestDate); 
				System.out.println("retestDate1 :"+retestDate1);
			}*/
			valueXmlString.append("<Detail>\r\n");
			//valueXmlString.append("<line_no__ord>").append("<![CDATA[").append(genericUtility.getColumnValue("line_no__ord",dom)).append("]]>").append("</line_no__ord>\r\n");			
			//valueXmlString.append("<cons_order>").append("<![CDATA[").append(genericUtility.getColumnValue("cons_order",dom1)).append("]]>").append("</cons_order>\r\n");			
			//valueXmlString.append("<item_ser>").append("<![CDATA[").append(rs.getString(1).trim()).append("]]>").append("</item_ser>\r\n");			
			valueXmlString.append("<item_code>").append("<![CDATA[").append(rs.getString(2).trim()).append("]]>").append("</item_code>\r\n");			
			valueXmlString.append("<loc_code__fr>").append("<![CDATA[").append(rs.getString(4)).append("]]>").append("</loc_code__fr>\r\n");			
			valueXmlString.append("<lot_no__fr>").append("<![CDATA[").append(rs.getString(5)).append("]]>").append("</lot_no__fr>\r\n");			
			valueXmlString.append("<lot_sl__fr>").append("<![CDATA[").append(rs.getString(6)).append("]]>").append("</lot_sl__fr>\r\n");						
			valueXmlString.append("<quantity>").append("<![CDATA[").append(rs.getDouble(7)).append("]]>").append("</quantity__fr>\r\n");			
			//valueXmlString.append("<site_code>").append("<![CDATA[").append(rs.getString(8).trim()).append("]]>").append("</site_code>\r\n");	
			valueXmlString.append("<no_art>").append("<![CDATA[").append(rs.getInt(9)).append("]]>").append("</no_art>\r\n");	
			valueXmlString.append("</Detail>\r\n");
			retestDate1 = "";
			expDate1 = "";
		}//while end
		stmt.close();
		valueXmlString.append("</Root>\r\n");			
	}//try end
	catch (SQLException sqx)
	{
		System.out.println("The SQLException occurs in StockTransferAct for Packet button :"+sqx);
		throw new ITMException(sqx);
	}
	catch (Exception e)
	{
		System.out.println("The Exception occure in StockTransferAct  for Packet button:"+e);
		throw new ITMException(e);
	}
	finally
	{
		try
		{
			conn.close();
			conn = null;
		}
		catch (Exception e){}
	}
	System.out.println("valueXmlString return from StockTransferAct[actionStock]] :"+valueXmlString.toString());
	return valueXmlString.toString();

}

private String stockTransform(Document dom,Document dom1, String objContext, String xtraParams, Document selDataDom)throws ITMException
{

	System.out.println("stockTransform is calling.............");
	StringBuffer valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n");
	String sql = "", issCriteria  = "", acctCodeInv = "", cctrCodeInv = "";
	String detCnt = "0", errCode = "", errString = "",siteCode="";
	Connection conn = null;
	Statement stmt = null;
	ResultSet rset = null;
	String quantity = "", acctCode = "", cctrCode = "", taxChap = "", taxClass = "", taxEnv = "";
	String consIssue = "", consOrder = "", lineNoOrd = "", siteCodeReq = "", itemCode = "", partyQty = "";   
	String locCode = "", lotNo = "", lotSl = "", unit = "", stockQty = "", rate = "",tranType="";
	Node currDetail = null, currDetail1 = null; 
	int count = 0;
	double stkQty = 0, noArt = 0, qtyPerArt = 0;
	ConnDriver connDriver = new ConnDriver();
	ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
	try
	{
		conn = getConnection();	
		stmt = conn.createStatement();		
		consOrder = new  ibase.utility.E12GenericUtility().getColumnValue("ref_id__for", dom1);
		lineNoOrd = new  ibase.utility.E12GenericUtility().getColumnValue("line_no", dom);
		siteCodeReq = new  ibase.utility.E12GenericUtility().getColumnValue("site_code", dom1);
		itemCode = new  ibase.utility.E12GenericUtility().getColumnValue("item_code", dom);
		quantity = new  ibase.utility.E12GenericUtility().getColumnValue("quantity", dom);
		tranType = new  ibase.utility.E12GenericUtility().getColumnValue("tran_type",dom1);
		//noArt = new  ibase.utility.E12GenericUtility().getColumnValue("no_art",dom);
		//acctCode = new  ibase.utility.E12GenericUtility().getColumnValue("acct_code", dom);
		//cctrCode = new  ibase.utility.E12GenericUtility().getColumnValue("cctr_code", dom);
	
		double quantity1 = Double.parseDouble(quantity);
		sql = "SELECT ISS_CRITERIA FROM ITEM WHERE ITEM_CODE = '"+itemCode+"'";
		System.out.println("sql :"+sql);
		rset = stmt.executeQuery(sql);
		if (rset.next())
		{
			issCriteria = rset.getString(1);
			System.out.println("issCriteria  :"+issCriteria);
		}

		if (rset !=null)
		{
			rset.close();
			rset = null;
		}

		NodeList detailList = selDataDom.getElementsByTagName("Detail");
		int noOfDetails = detailList.getLength();
		for(int ctr = 0; ctr < noOfDetails; ctr++)
		{
			currDetail = detailList.item(ctr);
			stkQty = stkQty + Double.parseDouble((new  ibase.utility.E12GenericUtility().getColumnValueFromNode("quantity", currDetail)));
		}
		System.out.println("stkQty  :"+stkQty);
		
		partyQty = new  ibase.utility.E12GenericUtility().getColumnValue("part_qty", dom1);
		System.out.println("partyQty  :"+partyQty);
		if (partyQty == null)
		{
			partyQty = "X";
		}
		if (partyQty.equals("X"))
		{
			if (stkQty < quantity1)
			{
				errCode = "VTSTOCK1";			
				errString = itmDBAccess.getErrorString("",errCode,"","",conn);				
				conn.close();
				conn = null;
				return errString;
			}
		}
		else if(partyQty.equals("W"))
		{
				errCode = "VTSTOCK2";			
				errString = itmDBAccess.getErrorString("",errCode,"","",conn);				
				System.out.println("errString :"+errString);
		}
		if (noOfDetails > 0)
		{
			for(int ctr = 0; ctr < noOfDetails && quantity1 > 0; ctr++)
			{
				valueXmlString.append("<Detail>");
				currDetail1 = detailList.item(ctr);
				locCode = new  ibase.utility.E12GenericUtility().getColumnValueFromNode("loc_code", currDetail1);
				lotNo = new  ibase.utility.E12GenericUtility().getColumnValueFromNode("lot_no", currDetail1);
				lotSl = new  ibase.utility.E12GenericUtility().getColumnValueFromNode("lot_sl", currDetail1);
				stockQty = new  ibase.utility.E12GenericUtility().getColumnValueFromNode("quantity", currDetail1);
			
				System.out.println("locCode==>  :"+locCode);
				System.out.println("lotNo==>  :"+lotNo);
				System.out.println("lotSl==>  :"+lotSl);
				System.out.println("stockQty==>  :"+stockQty);

				valueXmlString.append("<cons_order isSrvCallOnChg='0'>").append("<![CDATA[").append(consOrder).append("]]>").append("</cons_order>\r\n");
				valueXmlString.append("<line_no isSrvCallOnChg='0'>").append("<![CDATA[").append(lineNoOrd).append("]]>").append("</line_no>\r\n");
				valueXmlString.append("<item_code isSrvCallOnChg='0'>").append("<![CDATA[").append(itemCode).append("]]>").append("</item_code>\r\n");
				valueXmlString.append("<loc_code__fr isSrvCallOnChg='0'>").append("<![CDATA[").append(locCode).append("]]>").append("</loc_code__fr>\r\n");
				valueXmlString.append("<lot_no__fr isSrvCallOnChg='1'>").append("<![CDATA[").append(lotNo).append("]]>").append("</lot_no__fr>\r\n");
				valueXmlString.append("<lot_sl__fr isSrvCallOnChg='0'>").append("<![CDATA[").append(lotSl).append("]]>").append("</lot_sl__fr>\r\n");
				//valueXmlString.append("<acct_code isSrvCallOnChg='0'>").append("<![CDATA[").append(acctCode).append("]]>").append("</acct_code>\r\n");
				//valueXmlString.append("<cctr_code isSrvCallOnChg='0'>").append("<![CDATA[").append(cctrCode).append("]]>").append("</cctr_code>\r\n");
				
				sql = "SELECT QTY_PER_ART FROM STOCK " 
					 +"WHERE ITEM_CODE = '"+itemCode+"' "
					 +"AND SITE_CODE = '"+siteCodeReq+"' "
					 +"AND LOC_CODE = '"+locCode+"' "
					 +"AND LOT_NO = '"+lotNo+"' "
					 +"AND LOT_SL = '"+lotSl+"' ";
				System.out.println("sql :"+sql);
				rset = stmt.executeQuery(sql);
				if (rset.next())
				{
					//acctCodeInv = rset.getString(1);
					//cctrCodeInv = rset.getString(2);
					qtyPerArt = rset.getDouble("QTY_PER_ART");
					System.out.println("QTY_PER_ART  :"+qtyPerArt);
				
					//valueXmlString.append("<acct_code__inv isSrvCallOnChg='0'>").append("<![CDATA[").append(acctCodeInv).append("]]>").append("</acct_code__inv>\r\n");
					//valueXmlString.append("<cctr_code__inv isSrvCallOnChg='0'>").append("<![CDATA[").append(cctrCodeInv).append("]]>").append("</cctr_code__inv>\r\n");
				}
				// Changed by Manish on 01/04/16 for max cursor issue [start]
				if (rset !=null)
				{
					rset.close();
					rset = null;
				}
				// Changed by Manish on 01/04/16 for max cursor issue [end]
				if (Double.parseDouble(stockQty) <= quantity1)
				{
					valueXmlString.append("<quantity isSrvCallOnChg='0'>").append("<![CDATA[").append(stockQty).append("]]>").append("</quantity>\r\n");
					quantity1 = quantity1 - Double.parseDouble(stockQty);
					noArt = (Double.parseDouble(stockQty)) / qtyPerArt;
					System.out.println("Mayur 22/02/18  before noArt [" + noArt + "] Math.floor(noArt) [" + Math.floor(noArt) + "]");
					if ( (noArt - Math.floor(noArt) ) != 0 )
					{
						noArt = Math.floor(noArt + 0.5d);
					}
					else
					{
						noArt = Math.floor(noArt);
						
					}
					System.out.println("Mayur 22/02/18   after noArt [" + noArt + "]");
				}
				else
				{
					if (issCriteria != null &&  issCriteria.equals("W"))
					{
						valueXmlString.append("<quantity isSrvCallOnChg='0'>").append("<![CDATA[").append(stockQty).append("]]>").append("</quantity>\r\n");
						//valueXmlString.append("<quantity__std isSrvCallOnChg='0'>").append("<![CDATA[").append(stockQty).append("]]>").append("</quantity__std>\r\n");
						noArt = (Double.parseDouble(stockQty)) / qtyPerArt;
						System.out.println("Mayur 22/02/18   before noArt [" + noArt + "] Math.floor(noArt) [" + Math.floor(noArt) + "]");
						if ( (noArt - Math.floor(noArt) ) != 0 )
						{
							noArt = Math.floor(noArt + 0.5d);
						}
						else
						{
							noArt = Math.floor(noArt);
						}
						System.out.println("Mayur 22/02/18   after noArt [" + noArt + "]");
					}
					else
					{
						valueXmlString.append("<quantity isSrvCallOnChg='0'>").append("<![CDATA[").append(quantity1).append("]]>").append("</quantity>\r\n");
						//valueXmlString.append("<quantity__std isSrvCallOnChg='0'>").append("<![CDATA[").append(quantity1).append("]]>").append("</quantity__std>\r\n");
						noArt = quantity1 / qtyPerArt;
						System.out.println("Mayur 22/02/18  before noArt [" + noArt + "] Math.floor(noArt) [" + Math.floor(noArt) + "]");
						if ( (noArt - Math.floor(noArt) ) != 0 )
						{
							noArt = Math.floor(noArt + 0.5d);
						}
						else
						{
							noArt = Math.floor(noArt);
						}
						System.out.println("Mayur 22/02/18  after noArt [" + noArt + "]");
					}
					valueXmlString.append("<no_art>").append("<![CDATA[").append(noArt).append("]]>").append("</no_art>\r\n");
					quantity1 = 0;
				}// end else
				valueXmlString.append("</Detail>");
			}// for end
		}// end if
		valueXmlString.append("</Root>");
	}// end try
	catch(ITMException itme)
	{
		throw itme;
	}
	catch(Exception e)
	{
		throw new ITMException(e);
	}
	finally
	{
		try
		{
			System.out.println("Closing Connection...");
			conn.close();
			conn = null;
		}
		catch (Exception e){}
	}
	System.out.println("valueXmlString from :"+valueXmlString.toString());
	return valueXmlString.toString();

}
private String actionAllocate(Document dom, Document dom1, String xtraParams, String actionType)throws RemoteException, ITMException // Added - Gulzar 25/04/07
{

	String tranType = "", itemSer = "", consIss = "", consOrd = "", lineOrd = "", siteCodeReq = "";     
	String itemCode = "", itemDescr = "", locCode = "", lotNo = "", lotSl = "", quantity = "";    
	String acctCode = "", cctrCode = "", taxChap = "", taxClass = "", taxEnv = "", availableYn = "";
	String allocDate = "", partQuantity = "", errCode = "", errString = "", sql = "", retResult = "";
	String acctCodeInv = "", cctrCodeInv = "", sql1 = "";
	String validateStr = "",lotSerial = ""; 
	double remainingQty = 0d, inputQty = 0d, qtyPerArt = 0, noArt = 0;
	int minShelfLife = 0, noOfStkDet = 0;
	String trackShelfLife = "", chkDate = "";
	ArrayList acctCodeInvArrLst = new ArrayList();
	java.util.Date chkDate1 = null, expDate1 = null;;
	java.sql.Date expDate = null;
	double stockQuantity = 0d;
	
	String lotNum = "", locCode1 = "";
	double hmQty = 0d;
	NodeList detailList = null; 
	Node currDetail = null;
	int	detailListLength = 0; 
	HashMap hm = new HashMap(); 

	Statement stmt = null, stmt1 = null;
	Connection conn = null;
	ResultSet rs = null, rs1 = null;
	ConnDriver connDriver = new ConnDriver();

	StringBuffer valueXmlString = new StringBuffer(""); 
	boolean stkExpFlag = false;

	if (dom == null)
	{
		valueXmlString.append("</Root>\r\n");
		return valueXmlString.toString();
	}


	ibase.utility.E12GenericUtility genericUtility= new  ibase.utility.E12GenericUtility();
	ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
	double rate=0;
	try
	{
		
		conn = getConnection();
		
		System.out.println("[Validating .....]");
		AppConnectParm appConnect = new AppConnectParm();
		java.util.Properties p = appConnect.getProperty();
		InitialContext ctx = new InitialContext(p);

		detailList = dom.getElementsByTagName("Detail2");
		detailListLength = detailList.getLength();
		System.out.println("detailListLength : " + detailListLength);
		System.out.println("actionType : " + actionType);
		if (actionType.equalsIgnoreCase("Allocate"))
		{
			detailListLength = 1;
		}
		for (int ctr = 0;ctr < detailListLength;ctr++)
		{
			stmt = conn.createStatement();
			currDetail = detailList.item(ctr);
	
			String varValue = "",stkExpLoc = "";
		
			varValue = itmDBAccess.getEnvDis("999999","NEAREXP_LOC",conn);
			if(varValue != null && varValue.trim().length() > 0 && !(varValue.equalsIgnoreCase("NULLFOUND")))
			{
				stkExpLoc = varValue;
			}
	
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			
			tranType = genericUtility.getColumnValue("tran_type", dom1);
			itemSer = genericUtility.getColumnValue("item_ser", dom1);
		//	consIss = genericUtility.getColumnValue("cons_issue", dom1);
			consOrd = genericUtility.getColumnValueFromNode("ref_id__for", dom1);
			lineOrd = genericUtility.getColumnValueFromNode("line_no", currDetail);
			siteCodeReq = genericUtility.getColumnValue("site_code", dom1);
			itemCode = genericUtility.getColumnValueFromNode("item_code", currDetail);
			itemDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
			locCode = genericUtility.getColumnValueFromNode("loc_code",currDetail);
			lotNo = genericUtility.getColumnValueFromNode("lot_no", currDetail);
			lotSl =	genericUtility.getColumnValueFromNode("lot_sl", currDetail);
			quantity = genericUtility.getColumnValueFromNode("quantity", currDetail);
			//availableYn = genericUtility.getColumnValue("available_yn", dom1);
			///acctCode = genericUtility.getColumnValueFromNode("acct_code", currDetail);
			//cctrCode = genericUtility.getColumnValueFromNode("cctr_code", currDetail);
			//taxChap = genericUtility.getColumnValueFromNode("tax_chap", currDetail);
			//taxClass = genericUtility.getColumnValueFromNode("tax_class", currDetail);
			//taxEnv = genericUtility.getColumnValueFromNode("tax_env", currDetail);
			
			//allocDate = genericUtility.getColumnValue("issue_date", dom1);
			partQuantity = genericUtility.getColumnValue("part_qty", dom1);
			
			System.out.println("locCode :"+locCode);
	
			if(partQuantity == null || partQuantity.trim().length()== 0) // partial quantity is set as X when it is null
			{
				partQuantity = " ";
			}
			
			if (locCode == null || "null".equalsIgnoreCase(locCode) || locCode.trim().length() == 0)
			{
				System.out.println("If locCode = null || length() == 0");
				locCode = "%";			
				System.out.println("If locCodelocCode is null then [%] :" +locCode);
			}
			if (lotNo == null || lotNo.trim().length() == 0)
			{
				
				sql = "SELECT SUM(A.QUANTITY-CASE WHEN A.ALLOC_QTY IS NULL THEN 0 ELSE A.ALLOC_QTY END-CASE WHEN A.HOLD_QTY IS NULL THEN 0 ELSE A.HOLD_QTY END) "
					 +"FROM STOCK A, LOCATION L, INVSTAT B "
					 +"WHERE L.LOC_CODE = A.LOC_CODE "
					 + " AND L.INV_STAT  = B.INV_STAT "
					 +"AND A.ITEM_CODE = '"+itemCode+"' "
					 +"AND A.SITE_CODE = '"+siteCodeReq+"' "
					 +"AND B.AVAILABLE = '"+availableYn+"' "
					// +"AND A.QUANTITY  > 0 "
					 +"AND A.LOC_CODE  LIKE '"+locCode+"' "
					 +" HAVING SUM(A.QUANTITY-CASE WHEN A.ALLOC_QTY IS NULL THEN 0 ELSE A.ALLOC_QTY END-CASE WHEN A.HOLD_QTY IS NULL THEN 0 ELSE A.HOLD_QTY END) > 0 ";
				
				System.out.println("locCode in query ===" + locCode );
				
			}
		
			else 
			{
			
				sql = "SELECT SUM(A.QUANTITY-CASE WHEN A.ALLOC_QTY IS NULL THEN 0 ELSE A.ALLOC_QTY END-CASE WHEN A.HOLD_QTY IS NULL THEN 0 ELSE A.HOLD_QTY END) "
					 +"FROM STOCK A, LOCATION L, INVSTAT B "
					 +"WHERE L.LOC_CODE = A.LOC_CODE "
					 + " AND L.INV_STAT  = B.INV_STAT "
					  +"AND A.ITEM_CODE = '"+itemCode+"' "
					  +"AND A.SITE_CODE = '"+siteCodeReq+"' "
					  +"AND A.LOC_CODE  = '"+locCode+"' "
					  +"AND A.LOT_NO    = '"+lotNo+"' "
					  +"AND A.LOT_SL	 = '"+lotSl+"' "
				//	  +"AND (A.QUANTITY - A.ALLOC_QTY) >="+quantity
					  +" AND B.AVAILABLE = '"+availableYn+"'"
					  +" HAVING SUM(A.QUANTITY-CASE WHEN A.ALLOC_QTY IS NULL THEN 0 ELSE A.ALLOC_QTY END-CASE WHEN A.HOLD_QTY IS NULL THEN 0 ELSE A.HOLD_QTY END) > 0 ";
					  
			}//
			System.out.println("sql :"+sql);
			rs = stmt.executeQuery(sql);
			if (rs.next())
			{
				stockQuantity = rs.getDouble(1);
				System.out.println("stockQuantity :"+stockQuantity);
				
			}
			

			
			if (stockQuantity == 0  && "X".equals (partQuantity))
			{
				errCode = "VTNOSTK";
				errString = itmDBAccess.getErrorString("",errCode,"","",conn);
				System.out.println("errString :"+errString);
				return errString;
			}
			else if (stockQuantity == 0)
			{
				continue;
			}	
		
			rs.close();
			rs=null;
			stmt.close();
			stmt=null;
			
			if (lotNo == null || lotNo.trim().length() == 0) 
			{
				
				sql = "SELECT A.LOT_NO, A.LOT_SL,(A.QUANTITY - CASE WHEN A.ALLOC_QTY IS NULL THEN 0 ELSE A.ALLOC_QTY END -CASE WHEN A.HOLD_QTY IS NULL THEN 0 ELSE A.HOLD_QTY END), A.EXP_DATE, A.UNIT, "
					  +"A.ITEM_SER, A.SITE_CODE__MFG, A.MFG_DATE, A.POTENCY_PERC, A.ALLOC_QTY, " 
					  +"A.PACK_CODE, A.LOC_CODE, A.ACCT_CODE__INV,A.CCTR_CODE__INV, A.RATE, a.qty_per_art as QTY_PER_ART "  
					  +"FROM STOCK A, LOCATION L, INVSTAT B "
					  +"WHERE L.LOC_CODE = A.LOC_CODE "
					  + " AND L.INV_STAT  = B.INV_STAT "
					  +"AND A.ITEM_CODE = '"+itemCode+"' "
					  +"AND A.SITE_CODE = '"+siteCodeReq+"' "
					  +"AND B.AVAILABLE = '"+availableYn+"' "
					 // +"AND A.QUANTITY - A.ALLOC_QTY > 0 "
					  +"AND A.QUANTITY - CASE WHEN A.ALLOC_QTY IS NULL THEN 0 ELSE A.ALLOC_QTY END -CASE WHEN A.HOLD_QTY IS NULL THEN 0 ELSE A.HOLD_QTY END > 0 "
					  +"AND A.LOC_CODE  LIKE '"+locCode+"' "			
					  +"ORDER BY A.EXP_DATE, A.LOT_NO, A.LOT_SL ";
			}

			else 
			{
				
				sql = "SELECT A.LOT_NO, A.LOT_SL,(A.QUANTITY - CASE WHEN A.ALLOC_QTY IS NULL THEN 0 ELSE A.ALLOC_QTY END -CASE WHEN A.HOLD_QTY IS NULL THEN 0 ELSE A.HOLD_QTY END), A.EXP_DATE, A.UNIT, "
					  +"A.ITEM_SER, A.SITE_CODE__MFG, A.MFG_DATE, A.POTENCY_PERC, A.ALLOC_QTY, " 
					  +"A.PACK_CODE, A.LOC_CODE, A.ACCT_CODE__INV,A.CCTR_CODE__INV, A.RATE, a.qty_per_art as QTY_PER_ART "  
					  +"FROM STOCK A, LOCATION L, INVSTAT B "
					  +"WHERE L.LOC_CODE = A.LOC_CODE "
					  + " AND L.INV_STAT  = B.INV_STAT "
					  +"AND A.ITEM_CODE = '"+itemCode+"' "
					  +"AND A.SITE_CODE = '"+siteCodeReq+"' "
					  +"AND A.LOC_CODE  = '"+locCode+"' "
					  +"AND A.LOT_NO    = '"+lotNo+"' "
					  +"AND A.LOT_SL	 = '"+lotSl+"' "
					  //+"AND (A.QUANTITY - A.ALLOC_QTY) >="+quantity
					  +"AND (A.QUANTITY - CASE WHEN A.ALLOC_QTY IS NULL THEN 0 ELSE A.ALLOC_QTY END -CASE WHEN A.HOLD_QTY IS NULL THEN 0 ELSE A.HOLD_QTY END) >="+quantity
					  +" AND B.AVAILABLE = '"+availableYn+"'";			
			}
			System.out.println("sql :"+sql);

			stmt = conn.createStatement(ResultSet.TYPE_SCROLL_INSENSITIVE,ResultSet.CONCUR_UPDATABLE);
			rs = stmt.executeQuery(sql);
			while (rs.next())
			{
				lotNum = rs.getString(1); 
				locCode1 = rs.getString(12); 
				lotSerial = rs.getString(2); 
				System.out.println("lotNum :"+lotNum);
				System.out.println("locCode1 :"+locCode1);
				if (! hm.containsKey(itemCode+"~"+siteCodeReq+"~"+locCode1+"~"+lotNum + "~" + lotSerial ))
				{
					
					hm.put(itemCode+"~"+siteCodeReq+"~"+locCode1+"~"+lotNum+"~"+ lotSerial,new Double(rs.getDouble(3)));
				}
			}
			System.out.println("Hashmap :"+hm);
			remainingQty = Double.parseDouble(quantity);
			System.out.println("remainingQty :"+remainingQty);
			rs.beforeFirst(); 
			while (rs.next())
			{
				noOfStkDet++;
				lotNum = rs.getString(1);
				locCode1 = rs.getString(12); 
				lotSerial = rs.getString(2);
				qtyPerArt = rs.getDouble("QTY_PER_ART"); 
				System.out.print("Combination Key :  "+itemCode+"~"+siteCodeReq+"~"+locCode1+"~"+lotNum + "~" + lotSerial);
				hmQty = Double.parseDouble((hm.get(itemCode+"~"+siteCodeReq+"~"+locCode1+"~"+lotNum + "~" + lotSerial)).toString());
				System.out.println(" ::Value [hmQty] :: "+hmQty);
				if (hmQty == 0)
				{
					continue;
				}
				/*if (availableYn.equals("Y"))
				{
					sql1 = "SELECT MIN_SHELF_LIFE, (CASE WHEN TRACK_SHELF_LIFE IS NULL THEN 'N' ELSE TRACK_SHELF_LIFE END) " 
						 +"FROM ITEM WHERE ITEM_CODE = '"+itemCode+"' "; 
					System.out.println("sql1 :"+sql1);
					stmt1 = conn.createStatement();
					rs1 = stmt1.executeQuery(sql1);
					if (rs1.next())
					{
						minShelfLife = rs1.getInt(1);
						trackShelfLife = rs1.getString(2);
					}
					rs1.close();
					rs1=null;
					stmt1.close(); 
					stmt1 = null; 
					stkExpFlag = false;
					String token = "";
					StringTokenizer stToken = new StringTokenizer(stkExpLoc,",");
					while(stToken.hasMoreTokens())
					{
						token = stToken.nextToken();
						if(locCode.equalsIgnoreCase(token))
						{
							stkExpFlag = true;
							break;
						}
					}
					if(stkExpFlag == false){
						if (minShelfLife == 0)
						{
							minShelfLife = 1; 
						}
						if (trackShelfLife.equals("Y"))
						{
							chkDate = calcExpiry(allocDate,minShelfLife); 
							System.out.println("chkDate :"+chkDate);
							chkDate1 = sdf.parse(chkDate);
							System.out.println("chkDate1 :"+chkDate1);
							expDate = rs.getDate(4);
							System.out.println("expDate :"+expDate);
							if(expDate != null)
							{
								expDate1 = new java.util.Date(expDate.getTime());
								System.out.println("expDate1 :"+expDate1);
								if (chkDate1.compareTo(expDate1) > 0)
								{
									continue;
								}
							}							
						}
					}
				}*/
				System.out.println("remainingQty before if :"+remainingQty);
				System.out.println("rs.getDouble(3) :"+rs.getDouble(3));

				if (remainingQty == 0)
				{
					break;
				}
			
				else if(hmQty >= remainingQty)
				{
					inputQty = remainingQty;
					System.out.println("inputQty :"+inputQty);
					remainingQty = 0;
					hm.put(itemCode+"~"+siteCodeReq+"~"+locCode1+"~"+lotNum + "~" + lotSerial,new Double(hmQty - inputQty));
				
					System.out.println("hmQty - remainingQty :"+(hmQty - inputQty));
					System.out.println("hm if [hmQty >= remainingQty] :"+hm);
				}
			
				else if (hmQty < remainingQty) 
				{
				
					inputQty = hmQty; 
					System.out.println("inputQty :"+inputQty);					
					remainingQty = remainingQty - inputQty;
					System.out.println("remainingQty :"+remainingQty);
					hm.put(itemCode+"~"+siteCodeReq+"~"+locCode1+"~"+lotNum + "~" + lotSerial,new Double(0));
				}
				System.out.println("Hashmap :"+hm);
				valueXmlString.append("<Detail>\r\n");
				valueXmlString.append("<ref_id__for>").append("<![CDATA[").append(consOrd).append("]]>").append("</ref_id__for>\r\n");
				//System.out.println("rs.getDouble(15) :"+rs.getDouble(15));
				/*if (rs.getDouble(15) > 0)
				{
					rate=rs.getDouble(15);
					valueXmlString.append("<rate>").append("<![CDATA[").append(rs.getDouble(15)).append("]]>").append("</rate>\r\n");
				}
				else
				{
					sql1 = "SELECT RATE	FROM CONSUME_ORD_DET "
						  +"WHERE CONS_ORDER = '"+consOrd+"' "
						  +"AND LINE_NO = "+lineOrd+" ";		
					System.out.println("sql1 :"+sql1);
					stmt1 = conn.createStatement();
					rs1 = stmt1.executeQuery(sql1);
					if (rs1.next())
					{
						rate=rs1.getDouble(1);
						valueXmlString.append("<rate>").append("<![CDATA[").append(rate).append("]]>").append("</rate>\r\n");
					}
					stmt1.close(); //Gulzar 20/02/07
					stmt1 = null; //Gulzar 20/02/07
				}*/
		
				valueXmlString.append("<cons_order isSrvCallOnChg=\"0\">").append("<![CDATA[").append(consOrd).append("]]>").append("</cons_order>\r\n");
				valueXmlString.append("<line_no isSrvCallOnChg=\"0\">").append("<![CDATA[").append(lineOrd).append("]]>").append("</line_no__ord>\r\n");
				valueXmlString.append("<item_code isSrvCallOnChg=\"0\">").append("<![CDATA[").append(itemCode).append("]]>").append("</item_code>\r\n");
				valueXmlString.append("<item_descr isSrvCallOnChg=\"0\">").append("<![CDATA[").append(itemDescr).append("]]>").append("</item_descr>\r\n");
				valueXmlString.append("<quantity isSrvCallOnChg=\"0\">").append("<![CDATA[").append(inputQty).append("]]>").append("</quantity>\r\n");
				//valueXmlString.append("<quantity__std isSrvCallOnChg=\"0\">").append("<![CDATA[").append(inputQty).append("]]>").append("</quantity__std>\r\n");
				//valueXmlString.append("<unit isSrvCallOnChg=\"0\">").append("<![CDATA[").append(rs.getString(5)).append("]]>").append("</unit>\r\n");
				//valueXmlString.append("<unit__std isSrvCallOnChg=\"0\">").append("<![CDATA[").append(rs.getString(5)).append("]]>").append("</unit__std>\r\n");
				valueXmlString.append("<loc_code__fr isSrvCallOnChg=\"0\">").append("<![CDATA[").append(rs.getString(12)).append("]]>").append("</loc_frcode>\r\n");
				valueXmlString.append("<lot_sl__fr isSrvCallOnChg=\"0\">").append("<![CDATA[").append(rs.getString(2)).append("]]>").append("</lot_sl__fr>\r\n");
				valueXmlString.append("<lot_no__fr isSrvCallOnChg='0'>").append("<![CDATA[").append(rs.getString(1)).append("]]>").append("</lot_no__fr>\r\n");
				//valueXmlString.append("<conv_qty_stduom isSrvCallOnChg=\"0\">").append("<![CDATA[").append(1).append("]]>").append("</conv_qty_stduom>\r\n");
				//valueXmlString.append("<acct_code isSrvCallOnChg=\"0\">").append("<![CDATA[").append((acctCode == null) ? "":acctCode).append("]]>").append("</acct_code>\r\n");
				//valueXmlString.append("<cctr_code isSrvCallOnChg=\"0\">").append("<![CDATA[").append(cctrCode).append("]]>").append("</cctr_code>\r\n");
				//valueXmlString.append("<tax_chap isSrvCallOnChg=\"0\">").append("<![CDATA[").append((taxChap == null) ? "":taxChap).append("]]>").append("</tax_chap>\r\n");
				//valueXmlString.append("<tax_class isSrvCallOnChg=\"0\">").append("<![CDATA[").append((taxClass == null) ? "":taxClass).append("]]>").append("</tax_class>\r\n");
				//valueXmlString.append("<tax_env isSrvCallOnChg=\"0\">").append("<![CDATA[").append((taxEnv == null) ? "":taxEnv).append("]]>").append("</tax_env>\r\n");
				//valueXmlString.append("<amount>").append("<![CDATA[").append(inputQty*rate).append("]]>").append("</amount>\r\n");
				
				// 17/10/13 Manoharan set no_art
				
				
				noArt = inputQty / qtyPerArt;
				System.out.println("Manohar 17/10/13  before noArt [" + noArt + "] Math.floor(noArt) [" + Math.floor(noArt) + "]");
				if ( (noArt - Math.floor(noArt) ) != 0 )
				{
					noArt = Math.floor(noArt + 0.5d);
				}
				else
				{
					noArt = Math.floor(noArt);
				}
				System.out.println("Manohar 17/10/13  after noArt [" + noArt + "]");
				
			/*	System.out.println("rs.getString(13) :"+rs.getString(13)+" \nrs.getString(14) :"+rs.getString(14));
				if ((rs.getString(13) == null || rs.getString(13).trim().length() == 0) || (rs.getString(14) == null || rs.getString(14).trim().length() == 0)) 
				{
					retResult = acctDetrTType(itemCode, rs.getString(6), "IN", tranType);
					System.out.println("retResult :"+retResult);
					if (retResult.substring(retResult.length()-5).equals("DS000")) //Change the Error Code
					{
						acctCodeInv = " ";
						cctrCodeInv = " ";
					}
					else
					{
						acctCodeInvArrLst = genericUtility.getTokenList(retResult, "\t");
						System.out.println("acctCodeInvArrLst.size :"+acctCodeInvArrLst.size());
						System.out.println("acctCodeInvArrLst.get(1) :"+(String)acctCodeInvArrLst.get(1));
						acctCodeInv = (String)acctCodeInvArrLst.get(0); 
						System.out.println("acctCodeInv :"+acctCodeInv);
						cctrCodeInv = (String)acctCodeInvArrLst.get(1);
						System.out.println("cctrCodeInv :"+cctrCodeInv);
					}
				}
				if (rs.getString(13) == null)
				{
					valueXmlString.append("<acct_code__inv isSrvCallOnChg=\"0\">").append("<![CDATA[").append(acctCodeInv).append("]]>").append("</acct_code__inv>\r\n");
				}
				else
				{
					valueXmlString.append("<acct_code__inv isSrvCallOnChg=\"0\">").append("<![CDATA[").append(rs.getString(13)).append("]]>").append("</acct_code__inv>\r\n");
				}
				if (rs.getString(14) == null)
				{
					valueXmlString.append("<cctr_code__inv isSrvCallOnChg=\"0\">").append("<![CDATA[").append(cctrCodeInv).append("]]>").append("</cctr_code__inv>\r\n");
				}
				else
				{
					valueXmlString.append("<cctr_code__inv isSrvCallOnChg=\"0\">").append("<![CDATA[").append(rs.getString(14)).append("]]>").append("</cctr_code__inv>\r\n");
				}*/
				valueXmlString.append("<no_art isSrvCallOnChg=\"0\">").append("<![CDATA[").append(noArt).append("]]>").append("</no_art>\r\n");
				valueXmlString.append("</Detail>\r\n");
			}// while end
		
			rs=null;
			stmt.close();
			stmt=null;
			if (remainingQty > 0)   
			{
				if (partQuantity.equals("X")) 
				{
					errCode = "VTSTOCK1";
					errString = itmDBAccess.getErrorString("",errCode,"","",conn);
					System.out.println("errString :"+errString);
					return errString;
				
				}
			}
		
			if (errCode != null && errCode.trim().length() > 0)
			{
				System.out.println("errCode :"+errCode);
				errString = itmDBAccess.getErrorString("",errCode,"","",conn);
				System.out.println("errString :"+errString);
				return errString;
			}
			
		} //End Of For Loop
	}//try end
	catch (SQLException sqx)
	{
		System.out.println("The SQLException occurs in StockTransferAct :(Allocate) Button :"+sqx);
		throw new ITMException(sqx);
	}
	catch (Exception e)
	{
		System.out.println("The Exception occurs in StockTransferAct : (Allocate) Button :"+e);
		throw new ITMException(e);
	}
	finally
	{
		try
		{
			conn.close();
			conn = null;
		}
		catch (Exception e){}
	}
	System.out.println("valueXmlString return from StockTransferAct[actionAllocate] :"+valueXmlString.toString());
	return valueXmlString.toString();

} //End of actionAllocate method

private String getItemChanged(Document dom1,String consumeOrder,Connection conn) throws Exception
{

	Statement stmt = null;
	ResultSet rs = null;
	String tranType = "",itemSer="",sql = "";
	String rate ="";
	String qcReqd = "";
    String qtyStr = "";
	String itemAcctDetr = "";
	String itemCode = "";
	String locCode = "";
	String itemDescr = "";
	String consOrd = "";
	String lotNoTo = "";
	String lotSlTo = "";
	String acctCode ="";
	String cctrCode = "";
	double qtyIssue = 0;
	String locCodeDescr = "",acctCodeInv="",cctrCodeInv="",noArt="",acctCodeDr="",cctrCodeDr="";
	double quantity = 0;
	
	StringBuffer valueXmlString = new StringBuffer("");
	ibase.utility.E12GenericUtility genericUtility=	new  ibase.utility.E12GenericUtility();
	FinCommon finCommon = new FinCommon();
	Statement stmt1 = null;
	ResultSet rs1 = null;
	String lineNoStr="";
	try
	{
		tranType	= genericUtility.getColumnValue("tran_type",dom1);
		consOrd	= genericUtility.getColumnValue("ref_id__for",dom1); 
	//	itemSer =  genericUtility.getColumnValue("item_ser",dom1); 
		
		sql = "select line_no,item_code,loc_code,quantity from consume_ord_det "+
				"where cons_order = '"+consumeOrder+"' ";
		System.out.println("SQL ::"+sql); 
		stmt = conn.createStatement();
		rs = stmt.executeQuery(sql);
		while(rs.next())
		{
		   lineNoStr = rs.getString("line_no");
		   itemCode = rs.getString("item_code");	
		   quantity = rs.getDouble("quantity");
		   locCode= rs.getString("loc_code");	
		   	
			System.out.println("itemCode ::"+itemCode); 
			System.out.println("quantity ::"+quantity); 
			System.out.println("Location code ::"+locCode); 
		
			sql = "select a.issue_qty from consume_ord_det a, consume_ord b "+
					 "where a.cons_order = b.cons_order " +
					// " and b.cons_issue <> '"+consIssue+"'" + //Gulzar 21-02-07 
					 " where a.cons_order = '"+consumeOrder+"'" + 
					 " and a.line_no = "+lineNoStr+"";
			
			System.out.println("SQL ::"+sql);
			stmt1 = conn.createStatement();
			rs1 = stmt1.executeQuery(sql);
			
			if(rs1.next())
			{
				qtyIssue = rs1.getDouble(1);
			}

			rs1.close();
			rs1=null;
			stmt1.close();
			stmt1=null;
			quantity = Double.parseDouble(qtyStr) - qtyIssue;

			sql = "select descr from item where item_code = '"+itemCode+"'";
			System.out.println("SQL ::"+sql);	
			stmt1 = conn.createStatement();
			rs1 = stmt1.executeQuery(sql);
			if(rs1.next())
			{
			   itemDescr = rs1.getString("descr");
			  //qcReqd = rs1.getString("qc_reqd");
			}
	
			rs1.close();
			rs1=null;
			stmt1.close();
			stmt1=null;
			
			if(tranType != null && tranType == "R")
			{				
					sql = "SELECT SUM(CASE WHEN B.TRAN_TYPE = 'I' THEN A.QUANTITY ELSE (-1 * A.QUANTITY) END)" +
						 " FROM CONSUME_ORD_DET A, CONSUME_ORD B " +
						 " WHERE A.CONS_ORDER = B.CONS_ORDER " +
						// " AND B.CONS_ISSUE <> '"+consIssue+"'" +
						 //" AND (B.CONS_ISSUE = '"+tranIDIssue+"' OR B.TRAN_ID__ISS = '"+tranIDIssue+"')" +
						 " AND A.CONS_ORDER =  '"+consumeOrder+"'" +
						 " AND A.LINE_NO = "+lineNoStr+"" ; 
					System.out.println("SQL ::"+sql);
					stmt1 = conn.createStatement();
					rs1 = stmt1.executeQuery(sql);
					if(rs1.next())
					{
						qtyIssue = rs1.getDouble(1);
					}
				
					rs1.close();
					rs1=null;
					stmt1.close();
					stmt1=null;
					quantity = qtyIssue;
			}	//end of if 
			
				sql = "select a.acct_code,a.cctr_code,a.acct_code__inv,a.cctr_code__inv	, a.rate "+
						"from consume_ord_det a,consume_ord b where  a.cons_order = b.cons_order "+
						"and b.tran_type = 'I' and a.cons_order = '"+consumeOrder+"' and "+
						"a.line_no = "+lineNoStr+"";
				System.out.println("SQL ::"+sql);
				stmt1 = conn.createStatement();
				rs1 =stmt1.executeQuery(sql);
				if(rs1.next())
				{
					acctCode = rs1.getString(1);
					cctrCode = rs1.getString(2);
					acctCodeInv = rs1.getString(3);
					cctrCodeInv = rs1.getString(4);
					rate = rs1.getString(5);
				}
				
				rs1.close();
				rs1=null;
				stmt1.close();
				stmt1=null;
			}	
			
			
			System.out.println("isSrvCallOnChg is set ---");
	
			valueXmlString.append("<Detail>\r\n>");
			//valueXmlString.append("<cons_order isSrvCallOnChg=\"0\">").append("<![CDATA[").append((consumeOrder == null) ? "":consumeOrder).append("]]>").append("</cons_order>\r\n");
			valueXmlString.append("<line_no isSrvCallOnChg=\"0\">").append("<![CDATA[").append(lineNoStr).append("]]>").append("</line_no>\r\n");
			valueXmlString.append("<item_code isSrvCallOnChg=\"0\">").append("<![CDATA[").append(itemCode).append("]]>").append("</item_code>\r\n");
			valueXmlString.append("<item_descr isSrvCallOnChg=\"0\">").append("<![CDATA[").append(itemDescr).append("]]>").append("</item_descr>\r\n");
			valueXmlString.append("<quantity isSrvCallOnChg=\"0\">").append("<![CDATA[").append(quantity).append("]]>").append("</quantity>\r\n");
			valueXmlString.append("<loc_code__fr isSrvCallOnChg=\"0\">").append("<![CDATA[").append((locCode == null) ? "":locCode).append("]]>").append("</loc_code__fr>\r\n");
			valueXmlString.append("<location_descr__fr isSrvCallOnChg=\"0\">").append("<![CDATA[").append((locCodeDescr == null) ? "":locCodeDescr).append("]]>").append("</location_descr__fr>\r\n");			
			//valueXmlString.append("<loc_code__to isSrvCallOnChg=\"0\">").append("<![CDATA[").append((locCode == null) ? "":locCode).append("]]>").append("</loc_code__to>\r\n");
		 	//valueXmlString.append("<loc_descr__to isSrvCallOnChg=\"0\">").append("<![CDATA[").append((locCodeDescr == null) ? "":locCodeDescr).append("]]>").append("</loc_descr__to>\r\n");
			valueXmlString.append("<lot_no__fr isSrvCallOnChg=\"0\">").append("<![CDATA[").append((lotNoTo == null) ? "":lotNoTo).append("]]>").append("</lot_no__fr>\r\n");
			valueXmlString.append("<lot_sl__fr isSrvCallOnChg=\"0\">").append("<![CDATA[").append((lotSlTo == null) ? "":lotSlTo).append("]]>").append("</lot_sl__fr>\r\n");
		    //valueXmlString.append("<lot_no__to isSrvCallOnChg=\"0\">").append("<![CDATA[").append((lotNoTo == null) ? "":lotNoTo).append("]]>").append("</lot_no__to>\r\n");
			//valueXmlString.append("<lot_sl__to isSrvCallOnChg=\"0\">").append("<![CDATA[").append((lotSlTo == null) ? "":lotSlTo).append("]]>").append("</lot_sl__to>\r\n");			
			//valueXmlString.append("<acct_code__cr isSrvCallOnChg=\"0\">").append("<![CDATA[").append((acctCodeInv == null) ? "":acctCodeInv).append("]]>").append("</acct_code__cr>\r\n");	
			//valueXmlString.append("<cctr_code__cr isSrvCallOnChg=\"0\">").append("<![CDATA[").append((cctrCodeInv == null) ? "":cctrCodeInv).append("]]>").append("</cctr_code__cr>\r\n");			
			//valueXmlString.append("<acct_code__dr isSrvCallOnChg=\"0\">").append("<![CDATA[").append((acctCodeDr == null) ? "":acctCodeDr).append("]]>").append("</acct_code__dr>\r\n");
			//valueXmlString.append("<cctr_code__dr isSrvCallOnChg=\"0\">").append("<![CDATA[").append((cctrCodeDr == null) ? "":cctrCodeDr).append("]]>").append("</cctr_code__dr>\r\n");		
			valueXmlString.append("<no_art isSrvCallOnChg=\"0\">").append("<![CDATA[").append((noArt == null) ? "":noArt).append("]]>").append("</no_art>\r\n");
			
	
			valueXmlString.append("</Detail>");

		rs.close();
		rs=null;
		stmt.close();
		stmt=null;
		
	}
	catch(Exception e)
	{
		System.out.println("Exception [StockTransferAct][getItemChanged] :"+e);
		e.printStackTrace();
		throw e;
	}
	System.out.println("valueXmlString return from StockTransferAct[getItemChanged] :"+valueXmlString.toString());
	return valueXmlString.toString();

   } //End of getItemChanged method 

}



