package ibase.dashboard.sfa.servlet;
import ibase.dashboard.sfa.ejb.Compliance_NovaRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.simple.JSONObject;
import javax.servlet.http.HttpSession;

public class ComplianceCustServlet_Nova extends HttpServlet
{
	private static final long serialVersionUID = 1L;
	JSONObject jsonObjMetaData = null;
	JSONObject jsonMetaData = null;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	@SuppressWarnings("unchecked")
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		Compliance_NovaRemote complianceRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String loginId = "";
		String firstIndex ="";
		String cellVal = "";
		
		try
		{
			response.setContentType("application/xml");

			HttpSession session = request.getSession(true);
			ibase.utility.UserInfoBean userInfo = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");
			loginId = userInfo.getLoginCode();
			dataSourceName = request.getParameter("dataSourceName");
			firstIndex 	   = request.getParameter("salesPers");
			cellVal 	   = request.getParameter("date");
			
			System.out.println("in ComplianceCustServlet  firstIndex :"+firstIndex+"===== cellVal :"+cellVal);
			context = new InitialContext(appConnectParm.getProperty());
			complianceRemote = (Compliance_NovaRemote) context.lookup("ibase/Compliance_Nova/remote");
			JSONObject jsonObjData = (JSONObject) complianceRemote.getComplianceCustDetails(firstIndex, cellVal, dataSourceName);
			OutputStream outputStream   = response.getOutputStream();
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println("Final data set for ComplianceCustServlet build the Graph is===" + jsonObjData);

		} catch (Exception e)
		{
			System.out.println("Exception : ComplianceCustServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}

	}

}