import { Injectable } from '@angular/core';
import { Http, Response, Headers, RequestOptions } from '@angular/http';
import { Observable } from 'rxjs/Observable';
import 'rxjs/add/operator/catch';
import 'rxjs/add/operator/map';
export class BBAutosuggestService {
    constructor(http) {
        this.http = http;
    }
    getChipListData(dataSourceURL) {
        console.log("URL: " + dataSourceURL);
        let headers = new Headers({ 'Content-Type': 'application/json' });
        let options = new RequestOptions({ headers: headers });
        return this.http.get(dataSourceURL, options)
            .map(res => this.extractData(res))
            .catch(this.handleError);
    }
    transformData(data) {
        //TODO : 
        let formatedData = [];
        if (data) {
            console.log('data', data);
            console.log('typeof data in service', typeof data, Array.isArray(data));
            console.log('transformData data.details', data.details, typeof data.details, Array.isArray(data.details));
            console.log('transformData', data.imgUrl);
            console.log('transformData', data.chipMetadata);
            console.log('transformData', data.suggestMetadata);
            console.log('transformData', data.valueFields);
            if (data.details) {
                for (let detail of data.details) {
                    let displayChipText = data.chipMetadata || data.chipMetaData;
                    let displaySuggestText = data.suggestMetadata || data.suggestMetaData;
                    let value = data.valueFields || data.valueField;
                    let image = data.imgUrl;
                    //let dataObj = detail;
                    let errData = false;
                    console.log('transformData in loop', detail, Object.keys(detail), typeof detail, Array.isArray(detail));
                    for (let key of Object.keys(detail)) {
                        if (detail[key] == 'INVALID_DATA') {
                            errData = true;
                            detail[key] = '';
                        }
                        console.log('transformData', key, detail[key]);
                        let rKey = '<' + key + '>';
                        displayChipText = displayChipText.replace(rKey, detail[key]);
                        displaySuggestText = displaySuggestText.replace(rKey, detail[key]);
                        value = value.replace(key, detail[key]);
                        if (image) {
                            image = image.replace(rKey, detail[key]);
                        }
                    }
                    formatedData.push({ 'displayChipText': displayChipText, 'displaySuggestText': displaySuggestText, 'value': value, 'image': image, 'detail': detail, 'errData': errData });
                }
            }
        }
        if (formatedData)
            data = formatedData;
        console.log("formatedData", formatedData, Array.isArray(formatedData));
        return data;
    }
    extractData(res) {
        let jsonData = res.json();
        console.log('extractData[' + JSON.stringify[jsonData] + ']');
        return this.transformData(jsonData) || {};
    }
    handleError(error) {
        let errMsg;
        if (error instanceof Response) {
            const body = error.json() || '';
            const err = body.error || JSON.stringify(body);
            errMsg = `${error.status} - ${error.statusText || ''} ${err}`;
        }
        else {
            errMsg = error.message ? error.message : error.toString();
        }
        console.error('Service handleError:' + errMsg);
        return Observable.throw(errMsg);
    }
}
BBAutosuggestService.decorators = [
    { type: Injectable },
];
/** @nocollapse */
BBAutosuggestService.ctorParameters = () => [
    { type: Http, },
];
//# sourceMappingURL=bb-autosuggest.service.js.map