package proteus.ecm.hibernate.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.hibernate.HibernateException;
import org.hibernate.query.Query;
import org.hibernate.Session;

import proteus.ecm.cache.dao.SystemCache;
import proteus.ecm.hibernate.bean.Country;
import proteus.ecm.hibernate.bean.ECMParm;
import proteus.ecm.hibernate.bean.SiteItem;
import proteus.ecm.hibernate.bean.SiteMaster;
import proteus.ecm.hibernate.bean.State;
import proteus.ecm.hibernate.util.HibernateUtil;

public class SystemMasterDAO 
{
	SystemCache systemCache = new SystemCache();
	
	// @RestService == > "/sys/site"
	//public List<SiteMaster> getAllSites() 
	public void fetchAllSites(String cacheName) 
	{
		List<SiteMaster> allSites = new ArrayList<SiteMaster>();
		try 
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory().openSession();

			// 2. Create Query
			// SiteItem for ECM_TYPE : 1 - eShop; 2 - Market Place; 3 - Internal;
			Query query = session.createQuery("from SiteMaster WHERE siteCode IN ( "
																				+ " SELECT siteCode "
																				+ " FROM SiteItem "
																				+ " WHERE ecmType IN (1, 2, 3) "
																				+ " )");
			allSites = query.getResultList();
			
			systemCache.storeSites(allSites, cacheName);
			
			System.out.println("fetchAllSites Sites selected \n allSites : [" + allSites.size() + "]");
			session.close();
		} 
		catch (HibernateException e) 
		{
			System.out.println("fetchAllSites HibernateException :");
			System.out.println(e.getMessage());
		}
		//return allSites;
	}

	// @RestService == > "/sys/site/{siteCode}"
	//public SiteMaster getSite(String siteCode) 
	public void fetchSite(String siteCode, String cacheName) 
	{
		SiteMaster site = new SiteMaster();
		try 
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory().openSession();

			// 2. Create Query
			Query query = session.createQuery("from SiteMaster where siteCode = :siteCode");
			query.setParameter("siteCode", siteCode);
			List<SiteMaster> sites = query.getResultList();
			System.out.println("\n\n Sites selected \n siteCode : [" + siteCode + "] \n sites : [" + sites + "]");
			
			if( sites.size() > 0 )
			{
				site = sites.get(0);
			}
			systemCache.storeSites(sites, cacheName);
			
			session.close();
		} 
		catch (HibernateException e) 
		{
			System.out.println("fetchSite HibernateException :");
			System.out.println(e.getMessage());
		}
		System.out.println("fetchSite return Site" + site);
		//return site;
	}

	// @RestService == > "/sys/siteitems/{siteCode}"
	//public List<SiteItem> getSiteItems(String siteCode) 
	public void fetchSiteItems(String siteCode, String cacheName) 
	{
		List<SiteItem> siteItems = new ArrayList<SiteItem>();
		try 
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory().openSession();

			// 2. Create Query
			Query query = session.createQuery("from SiteItem  where siteCode = :siteCode");
			query.setParameter("siteCode", siteCode);
			siteItems = query.getResultList();
			
			System.out.println("fetchSiteItems SiteItems selected \n siteCode : [" + siteCode + "] \n siteItems : [" + siteItems.size() + "]");
			
			systemCache.storeSiteItems(siteItems, cacheName);
			
			session.close();
		} 
		catch (HibernateException e) 
		{
			System.out.println("fetchSiteItems HibernateException :");
			System.out.println(e.getMessage());
		}
		//return siteItems;
	}
	
	// @RestService == > "/sys/siteitems/{siteCode}"
	//public List<SiteItem> getSiteItems(String siteCode) 
	public HashMap<String,ECMParm> fetchEcmParms(String varName, boolean matchExact) 
	{
		HashMap<String,ECMParm> ecmParamsData = new HashMap<String,ECMParm>();
		try 
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory().openSession();
			String qString = "";
			if( matchExact )
			{
				qString = "from ECMParm  where varName = :varName";
			}
			else
			{
				qString = "from ECMParm  where varName like :varName || '%' ";
			}
			// 2. Create Query
			Query query = session.createQuery( qString );
			query.setParameter("varName", varName);
			List<ECMParm> ecmParms = query.getResultList();
			for(ECMParm ecmParm : ecmParms)
			{
				System.out.println("ecmParm[" + ecmParm + "]");
				ecmParamsData.put(ecmParm.getVarName(), ecmParm);
			}
			System.out.println("fetchEcmParms ecmParms selected \n varName : [" + varName + "] \n ecmParms : [" + ecmParms.size() + "]");
			
			session.close();
		} 
		catch (HibernateException e) 
		{
			System.out.println("fetchEcmParms HibernateException :");
			System.out.println(e.getMessage());
		}
		return ecmParamsData;
	}

	  public void fetchStates(String cacheName) {
	     List allStates = new ArrayList();
	     try
	     {
	       Session session = HibernateUtil.getSessionFactory().openSession();
	 
	       Query query = session.createQuery("from State ");
	       allStates = query.getResultList();
	 
	       this.systemCache.storeStates(allStates, cacheName);
	 
	       System.out.println("fetchStates States selected \n allStates : [" + allStates.size() + "]");
	       session.close();
	     }
	     catch (HibernateException e)
	     {
	       System.out.println("fetchStates HibernateException :");
	       System.out.println(e.getMessage());
	     }
	   }
	 
	   public void fetchCountries(String cacheName) {
	     List allCountries = new ArrayList();
	     try
	     {
	       Session session = HibernateUtil.getSessionFactory().openSession();
	 
	       Query query = session.createQuery("from Country ");
	       allCountries = query.getResultList();
	 
	       this.systemCache.storeCountries(allCountries, cacheName);
	 
	       System.out.println("fetchCountries Countries selected \n allCountries : [" + allCountries.size() + "]");
	       session.close();
	     }
	     catch (HibernateException e)
	     {
	       System.out.println("fetchCountries HibernateException :");
	       System.out.println(e.getMessage());
	     }
	   }
	
}
