import { Component, OnInit, Input, ViewEncapsulation, ViewChild } from '@angular/core';
import { Address } from '../address.model';
import { EcmLocationService } from '../../../ecm-search/ecm-location.service';
import { EcmLocation } from '../../../ecm-search/ecm-location';
import { Observable } from 'rxjs/Observable';
import { Store } from '@ngrx/store';
import { AppState } from '../../../ecm-store/reducers';
import { UserAddressService } from '../../ecm-user-address.service';
import { FormControl } from '@angular/forms';
import { NgForm, NgModel, FormBuilder, FormGroup, NgModelGroup, Validators } from '@angular/forms';

@Component({
  selector: 'address-screen',
  templateUrl: './address-screen.component.html',
  styleUrls: ['./address-screen.component.css'],
  encapsulation: ViewEncapsulation.None
})
export class AddressScreenComponent implements OnInit {

	@Input() editMode : string = 'V';
    @Input() address : Address;
    @ViewChild('userAddress') addressForm: NgForm;
    
    public storeUserLocation :  Observable<EcmLocation>;
    stateCtrl = new FormControl();
    countryCtrl = new FormControl();
    stateOptions;
    countryOptions;

	constructor(private locationService: EcmLocationService,private userAddressService: UserAddressService, private store: Store<AppState>) { 
	    
	    this.countryCtrl.valueChanges.debounceTime(100).subscribe((val: any) => {
          console.log("Selected Value[" +val+ "]");
          let trimmedVal = '';
          if( val ){
              trimmedVal = val.trim();
          }
          if(trimmedVal.length > 2)
          {    
              this.userAddressService.getSuggestions('country', trimmedVal).subscribe(data => {
                  
                  if( data )
                  {
                      this.countryOptions = data;
                  }
                  else 
                  {
                      this.countryOptions = [];
                  }
              });
          }
	    });
	    
	    this.stateCtrl.valueChanges.debounceTime(100).subscribe((val: any) => {
	          console.log("Selected Value[" +val+ "]");
	          let trimmedVal = '';
	          if( val ){
	              trimmedVal = val.trim();
	          }
	          
	          if(trimmedVal.length > 2)
	          {    
	              this.userAddressService.getSuggestions('state', trimmedVal).subscribe(data => {
	                  if( data )
	                  {
	                      this.stateOptions = data;
	                  }
	                  else 
	                  {
	                      this.stateOptions = [];
	                  }
	              });
	          }
        });
	}

	ngOnInit() {
	    this.storeUserLocation = this.store.select('location');
	}
	
	//For extracting User Location to Address
	updateuserLocation() {
        this.locationService.getGeoLocation();
        this.storeUserLocation.subscribe( userLocation => {
            
            console.log("userlocation  -----------",userLocation );
            this.address.city = userLocation.city;
            this.address.pinCode = userLocation.pincode; 
            this.address.stateDescr  = userLocation.state; //TODO : Mapped with STATE_CODE and its DESCR
            this.address.countDescr = userLocation.country; //TODO : Mapped with COUNT_CODE and its DESCR
            
            console.log("adress  -----------",this.address );
        });
    }
	
	//To set addrUse = D - Delivery or A - All 
	updateAddrUseD(evt) {
	    this.address.addrUse = evt.checked ? ( this.address.addrUse == "B" ? "A" : "D") : (  this.address.addrUse == "A" ? "B" : "" );
    }

	//To set addrUse = B - Billing or A - All 
    updateAddrUseB(evt) {
        this.address.addrUse = evt.checked ? ( this.address.addrUse == "D" ? "A" : "B") : (  this.address.addrUse == "A" ? "D" : "" );
    }
    
	updateDefault(evt) {
	    this.address.isDefault = evt.checked ? "Y" : "N";
	}
	
	submitAddress(userAddress) {
	     console.log('Submitted Address Data', userAddress);
	}
	
	getSeparator( displayVal ){
	    if( displayVal ) {
	        return ',';
	    }
        return '';
	}
}
