/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */

import {NgModule} from '@angular/core';

import {OverlayModule} from '@angular/cdk/overlay';
import {A11yModule} from '@angular/cdk/a11y';
import {BidiModule} from '@angular/cdk/bidi';
import {ObserversModule} from '@angular/cdk/observers';
import {PortalModule} from '@angular/cdk/portal';

import {MdCommonModule, MdRippleModule, PlatformModule, StyleModule, MdNativeDateModule } from '@angular/material/core';
import {MdButtonToggleModule} from '@angular/material/button-toggle';
import {MdButtonModule} from '@angular/material/button';
import {MdCheckboxModule} from '@angular/material/checkbox';
import {MdRadioModule} from '@angular/material/radio';
import {MdSelectModule} from '@angular/material/select';
import {MdSlideToggleModule} from '@angular/material/slide-toggle';
import {MdSliderModule} from '@angular/material/slider';
import {MdSidenavModule} from '@angular/material/sidenav';
import {MdListModule} from '@angular/material/list';
import {MdGridListModule} from '@angular/material/grid-list';
import {MdCardModule} from '@angular/material/card';
import {MdChipsModule} from '@angular/material/chips';
import {MdIconModule} from '@angular/material/icon';
import {MdProgressSpinnerModule} from '@angular/material/progress-spinner';
import {MdProgressBarModule} from '@angular/material/progress-bar';
import {MdInputModule} from '@angular/material/input';
import {MdSnackBarModule} from '@angular/material/snack-bar';
import {MdTabsModule} from '@angular/material/tabs';
import {MdToolbarModule} from '@angular/material/toolbar';
import {MdTooltipModule} from '@angular/material/tooltip';
import {MdMenuModule} from '@angular/material/menu';
import {MdDialogModule} from '@angular/material/dialog';
import {MdAutocompleteModule} from '@angular/material/autocomplete';
import {MdDatepickerModule} from '@angular/material/datepicker';
import {MdExpansionModule} from '@angular/material/expansion';
import {MdTableModule} from '@angular/material/table';
import {MdSortModule} from '@angular/material/sort';
import {MdPaginatorModule} from '@angular/material/paginator';
import {MdFormFieldModule} from '@angular/material/form-field';
import {MdStepperModule} from '@angular/material/stepper';

const MATERIAL_MODULES = [
  MdAutocompleteModule,
  MdButtonModule,
  MdButtonToggleModule,
  MdCardModule,
  MdChipsModule,
  MdCheckboxModule,
  MdDatepickerModule,
  MdTableModule,
  MdDialogModule,
  MdExpansionModule,
  MdFormFieldModule,
  MdGridListModule,
  MdIconModule,
  MdInputModule,
  MdListModule,
  MdMenuModule,
  MdPaginatorModule,
  MdProgressBarModule,
  MdProgressSpinnerModule,
  MdRadioModule,
  MdRippleModule,
  MdSelectModule,
  MdSidenavModule,
  MdSliderModule,
  MdSlideToggleModule,
  MdSnackBarModule,
  MdSortModule,
  MdTabsModule,
  MdToolbarModule,
  MdTooltipModule,
  OverlayModule,
  PortalModule,
  BidiModule,
  StyleModule,
  A11yModule,
  PlatformModule,
  MdCommonModule,
  ObserversModule,
  MdNativeDateModule,
  MdStepperModule
];

/** @deprecated */
@NgModule({
  imports: MATERIAL_MODULES,
  exports: MATERIAL_MODULES,
})
export class MaterialModule {}
