import { Component, Directive, Input, ContentChildren, forwardRef, Optional, Output, EventEmitter, ChangeDetectorRef, ViewChild } from '@angular/core';
import { UniqueSelectionDispatcher } from '@angular/material/core';
import { FocusMonitor } from '@angular/cdk/a11y';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
import { coerceBooleanProperty } from '@angular/cdk/coercion';
var MatRadioChange = (function () {
    function MatRadioChange() {
    }
    return MatRadioChange;
}());
export { MatRadioChange };
export var MAT_RADIO_GROUP_CONTROL_VALUE_ACCESSOR = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: forwardRef(function () { return BBRadiobuttonGroup; }),
    multi: true
};
var nextUniqueId = 0;
var BBRadiobuttonGroup = (function () {
    function BBRadiobuttonGroup(_changeDetector) {
        this._changeDetector = _changeDetector;
        this._name = "bb-radio-group-" + nextUniqueId++;
        this._value = null;
        this._selected = null;
        this._disabled = false;
        this._isInitialized = false;
        this._controlValueAccessorChangeFn = function () { };
        this.onTouched = function () { };
        this.change = new EventEmitter();
    }
    BBRadiobuttonGroup.prototype._markRadiosForCheck = function () {
        if (this._radios) {
            this._radios.forEach(function (radio) { return radio._markForCheck(); });
        }
    };
    BBRadiobuttonGroup.prototype.writeValue = function (value) {
        this.value = value;
        this._changeDetector.markForCheck();
    };
    BBRadiobuttonGroup.prototype.registerOnChange = function (fn) {
        this._controlValueAccessorChangeFn = fn;
    };
    BBRadiobuttonGroup.prototype.registerOnTouched = function (fn) {
        this.onTouched = fn;
    };
    BBRadiobuttonGroup.prototype.setDisabledState = function (isDisabled) {
        this.disabled = isDisabled;
        this._changeDetector.markForCheck();
    };
    Object.defineProperty(BBRadiobuttonGroup.prototype, "name", {
        get: function () { return this._name; },
        set: function (value) {
            this._name = value;
            this._updateRadioButtonNames();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(BBRadiobuttonGroup.prototype, "value", {
        get: function () { return this._value; },
        set: function (newValue) {
            if (this._value != newValue) {
                this._value = newValue;
                this._updateSelectedRadioFromValue();
                this._checkSelectedRadioButton();
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(BBRadiobuttonGroup.prototype, "selected", {
        get: function () { return this._selected; },
        set: function (selected) {
            this._selected = selected;
            console.log('-------');
            this.value = selected ? selected.bbValue : null;
            this._checkSelectedRadioButton();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(BBRadiobuttonGroup.prototype, "disabled", {
        get: function () { return this._disabled; },
        set: function (value) {
            this._disabled = coerceBooleanProperty(value);
            this._markRadiosForCheck();
        },
        enumerable: true,
        configurable: true
    });
    BBRadiobuttonGroup.prototype._checkSelectedRadioButton = function () {
        if (this._selected && !this._selected.bbChecked) {
            this._selected.bbChecked = true;
        }
    };
    BBRadiobuttonGroup.prototype.ngAfterContentInit = function () {
        this._isInitialized = true;
    };
    BBRadiobuttonGroup.prototype._touch = function () {
        if (this.onTouched) {
            this.onTouched();
        }
    };
    BBRadiobuttonGroup.prototype._updateRadioButtonNames = function () {
        var _this = this;
        if (this._radios) {
            this._radios.forEach(function (radio) {
                radio.name = _this.name;
            });
        }
    };
    BBRadiobuttonGroup.prototype._updateSelectedRadioFromValue = function () {
        var _this = this;
        // If the value already matches the selected radio, do nothing.
        var isAlreadySelected = this._selected != null && this._selected.bbValue == this._value;
        if (this._radios != null && !isAlreadySelected) {
            this._selected = null;
            this._radios.forEach(function (radio) {
                radio.bbChecked = _this.value == radio.bbValue;
                if (radio.bbChecked) {
                    _this._selected = radio;
                }
            });
        }
    };
    BBRadiobuttonGroup.prototype._emitChangeEvent = function () {
        if (this._isInitialized) {
            var event_1 = new MatRadioChange();
            event_1.source = this._selected;
            event_1.value = this._value;
            this.change.emit(event_1);
        }
    };
    BBRadiobuttonGroup.prototype.ngAfterViewChecked = function () {
        console.log('_selected', this._selected);
        console.log('_value', this._value);
    };
    BBRadiobuttonGroup.decorators = [
        { type: Directive, args: [{
                    selector: 'bb-radio-group',
                    providers: [MAT_RADIO_GROUP_CONTROL_VALUE_ACCESSOR]
                },] },
    ];
    /** @nocollapse */
    BBRadiobuttonGroup.ctorParameters = function () { return [
        { type: ChangeDetectorRef, },
    ]; };
    BBRadiobuttonGroup.propDecorators = {
        '_radios': [{ type: ContentChildren, args: [forwardRef(function () { return BBRadiobuttonComponent; }),] },],
        'change': [{ type: Output },],
        'name': [{ type: Input },],
        'value': [{ type: Input },],
        'selected': [{ type: Input },],
        'disabled': [{ type: Input },],
    };
    return BBRadiobuttonGroup;
}());
export { BBRadiobuttonGroup };
var BBRadiobuttonComponent = (function () {
    function BBRadiobuttonComponent(radioGroup, _changeDetector, _radioDispatcher, _focusMonitor) {
        this._changeDetector = _changeDetector;
        this._radioDispatcher = _radioDispatcher;
        this._focusMonitor = _focusMonitor;
        this._uniqueId = "bb-radio-" + ++nextUniqueId;
        this.uxDesign = 'UX3';
        this.bbChecked = false;
        this.bbValue = false;
        this.bbId = this._uniqueId;
        this.bbDisabled = false;
        this.bbRequired = false;
        this.bbLabelPosition = 'after';
        this._value = null;
        this._checked = false;
        this.change = new EventEmitter();
        this.radioGroup = radioGroup;
        console.log('radioGroup', this.radioGroup);
    }
    BBRadiobuttonComponent.prototype.ngOnInit = function () {
        if (this.radioGroup) {
            this.name = this.radioGroup.name;
        }
    };
    BBRadiobuttonComponent.prototype._markForCheck = function () {
        this._changeDetector.markForCheck();
    };
    BBRadiobuttonComponent.prototype.changeInput = function () {
        console.log('---Input Changed---');
        event.stopPropagation();
        var groupValueChanged = this.radioGroup && this.bbValue != this.radioGroup.value;
        this.bbChecked = true;
        this._emitChangeEvent();
        if (this.radioGroup) {
            this.radioGroup._controlValueAccessorChangeFn(this.bbValue);
            console.log('this.radioGroup', this.radioGroup);
            console.log('value--', +this.bbValue);
            this.radioGroup._touch();
            if (groupValueChanged) {
                this.radioGroup._emitChangeEvent();
            }
        }
    };
    BBRadiobuttonComponent.prototype._emitChangeEvent = function () {
        var event = new MatRadioChange();
        event.source = this;
        event.value = this._value;
        this.change.emit(event);
    };
    BBRadiobuttonComponent.decorators = [
        { type: Component, args: [{
                    selector: 'bb-radio-button',
                    template: "\n\n      <span [ngSwitch]=\"uxDesign\">\n      \t<span *ngSwitchCase=\"'UX1'\">\n      \t\t<input type=\"radio\" name=\"gender\" value=\"male\"> Option 1\n      \t\t<input type=\"radio\" name=\"gender\" value=\"female\"> Option 1\n      \t</span>\n\t\n      \t<span *ngSwitchCase=\"'UX3'\">\n      \t\t<md-radio-button (change)=\"changeInput()\" [id]=\"bbId\" [name]=\"name\" [required]=\"bbRequired\" [disabled]=\"bbDisabled\" [checked]=\"bbChecked\" [value]=\"bbValue\" [labelPosition]=\"bbLabelPosition\">\n      \t\t\t<ng-container *ngTemplateOutlet=\"content\"></ng-container>\n      \t\t</md-radio-button>\n      \t</span>\n\t\n      \t<ng-template #content><ng-content></ng-content></ng-template>\n      </span>\n    ",
                    styles: ["\n\n    "]
                },] },
    ];
    /** @nocollapse */
    BBRadiobuttonComponent.ctorParameters = function () { return [
        { type: BBRadiobuttonGroup, decorators: [{ type: Optional },] },
        { type: ChangeDetectorRef, },
        { type: UniqueSelectionDispatcher, },
        { type: FocusMonitor, },
    ]; };
    BBRadiobuttonComponent.propDecorators = {
        'uxDesign': [{ type: Input, args: ['uxDesign',] },],
        'bbChecked': [{ type: Input, args: ['checked',] },],
        'bbValue': [{ type: Input, args: ['value',] },],
        'name': [{ type: Input, args: ['name',] },],
        'bbId': [{ type: Input, args: ['id',] },],
        'bbDisabled': [{ type: Input, args: ['disabled',] },],
        'bbRequired': [{ type: Input, args: ['required',] },],
        'bbLabelPosition': [{ type: Input, args: ['labelPosition',] },],
        '_inputElement': [{ type: ViewChild, args: ['input',] },],
        'change': [{ type: Output },],
    };
    return BBRadiobuttonComponent;
}());
export { BBRadiobuttonComponent };
//# sourceMappingURL=bb-radio-button-group.component.js.map