var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { Component, Directive, Input, ContentChildren, ElementRef, forwardRef, Output, EventEmitter } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
import { ValueAccessorBase } from '../../key-input/form/value-accessor';
var _uniqueIdCounter = 0;
export var BB_SELECT_CONTROL_VALUE_ACCESSOR = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: forwardRef(function () { return BBSelect; }),
    multi: true
};
var BBSelect = (function (_super) {
    __extends(BBSelect, _super);
    function BBSelect() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.uxDesign = 'UX3';
        _this.bbPlaceholder = 'Select';
        _this.bbRequired = false;
        _this.bbDisableRipple = false;
        _this.bbMultiple = false;
        _this.bbChange = new EventEmitter();
        _this.bbOnOpen = new EventEmitter();
        _this.bbOnClose = new EventEmitter();
        return _this;
    }
    BBSelect.prototype.ngAfterContentInit = function () {
        console.log('optionGroups', this.options);
        this.options.forEach(function (alertInstance) { return console.log(alertInstance); });
    };
    BBSelect.decorators = [
        { type: Component, args: [{
                    selector: 'bb-select',
                    template: "\n      <span [ngSwitch]=\"uxDesign\">\n      \t<span *ngSwitchCase=\"'UX1'\">\n      \t\t<select [(ngModel)]=\"value\" value=\"bbValue\">\n      \t\t  <option *ngFor=\"let option of options\" value=\"{{option.value}}\">{{option.viewValue}}</option>\n      \t\t</select>\n      \t</span>\n\t\n      \t<span *ngSwitchCase=\"'UX3'\">\n      \t\t<md-select [(ngModel)]=\"value\" (change)=\"bbChange.emit();\" (onOpen)=\"bbOnOpen.emit();\" (onClose)=\"bbOnClose.emit();\" [required]=\"bbRequired\" [floatPlaceholder]=\"bbFloatPlaceholder\" [placeholder]=\"bbPlaceholder\" [multiple]=\"bbMultiple\" [disableRipple]=\"bbDisableRipple\" [panelClass]=\"bbPanelClass\">\n      \t\t\t<md-option *ngFor=\"let option of options\" [value]=\"option.bbValue\" [disabled]=\"option.bbDisabled\">\n      \t\t\t\t{{option.viewValue}}\n      \t\t\t</md-option>\n      \t\t</md-select>\n      \t</span>\n\t\n      \t<ng-template #content><ng-content></ng-content></ng-template>\n      </span>\n    ",
                    styles: ["\n\n    "],
                    providers: [BB_SELECT_CONTROL_VALUE_ACCESSOR]
                },] },
    ];
    /** @nocollapse */
    BBSelect.ctorParameters = function () { return []; };
    BBSelect.propDecorators = {
        'options': [{ type: ContentChildren, args: [forwardRef(function () { return BBOption; }),] },],
        'uxDesign': [{ type: Input, args: ['uxDesign',] },],
        'bbPlaceholder': [{ type: Input, args: ['placeholder',] },],
        'bbRequired': [{ type: Input, args: ['required',] },],
        'bbFloatPlaceholder': [{ type: Input, args: ['floatPlaceholder',] },],
        'bbValue': [{ type: Input, args: ['value',] },],
        'bbDisableRipple': [{ type: Input, args: ['disableRipple',] },],
        'bbPanelClass': [{ type: Input, args: ['panelClass',] },],
        'bbMultiple': [{ type: Input, args: ['multiple',] },],
        'bbChange': [{ type: Output },],
        'bbOnOpen': [{ type: Output },],
        'bbOnClose': [{ type: Output },],
    };
    return BBSelect;
}(ValueAccessorBase));
export { BBSelect };
var BBOption = (function () {
    function BBOption(_element) {
        this._element = _element;
        this._uniqueId = "bb-option-" + _uniqueIdCounter++;
        this.bbId = this._uniqueId;
        this.bbDisabled = false;
    }
    BBOption.prototype._getHostElement = function () {
        return this._element.nativeElement;
    };
    Object.defineProperty(BBOption.prototype, "viewValue", {
        get: function () {
            return (this._getHostElement().textContent || '').trim();
        },
        enumerable: true,
        configurable: true
    });
    BBOption.decorators = [
        { type: Directive, args: [{
                    selector: 'bb-option'
                },] },
    ];
    /** @nocollapse */
    BBOption.ctorParameters = function () { return [
        { type: ElementRef, },
    ]; };
    BBOption.propDecorators = {
        'bbValue': [{ type: Input, args: ['value',] },],
        'bbId': [{ type: Input, args: ['id',] },],
        'bbDisabled': [{ type: Input, args: ['disabled',] },],
    };
    return BBOption;
}());
export { BBOption };
//# sourceMappingURL=bb-choice.component.js.map