package ibase.webitm.ejb.wms;

import ibase.webitm.ejb.*;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.GenericUtility;

import java.rmi.RemoteException;
import java.sql.*;

import org.w3c.dom.*;

import javax.ejb.*;

@javax.ejb.Stateless
public class PoRcpRmPmPrs extends ValidatorEJB //implements PoRcpPrsLocal, PoRcpPrsRemote
{
	public String preSave() throws RemoteException,ITMException
	{
		return "";
	}

	public String preSave(String xmlString, String editFlag, String xtraParams, Connection conn)throws RemoteException,ITMException
	{

		System.out.println("PoRcpPrs EJB called");
		Document dom = null;
		try
		{
			System.out.println("xmlString in PoRcpPrs : preSaveRec \n"+xmlString);			
			if (xmlString != null && xmlString.trim().length() > 0)
			{
				dom = GenericUtility.getInstance().parseString(xmlString);
				executepreSave( dom, editFlag, xtraParams, conn );
			}			
		}
		catch(Exception e)
		{
			System.out.println("Exception :PoRcpPrs :" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return "";
	}

	private String executepreSave( Document dom, String editFlag, String xtraParams, Connection conn ) throws RemoteException, ITMException
	{
		
		 System.out.println("Call WFVAlDATA for PRS RMPM porder");
		String sql = "";			
		String purcOrder = ""; 
		String tranId = "";
		
		int deleteCount = 0;
		int cnt = 0;			

		ResultSet rs = null;
		PreparedStatement pstmt = null;

		try
		{			
			conn.setAutoCommit(false); 
			GenericUtility genericUtility = GenericUtility.getInstance();
			
			purcOrder = genericUtility.getColumnValue( "purc_order", dom, "2" );
			
			if( purcOrder != null && purcOrder.trim().length() > 0 )
			{					
				sql = "SELECT TRAN_ID FROM PORCP WHERE PURC_ORDER = ?";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1, purcOrder);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					tranId = rs.getString("TRAN_ID");
				}
				 System.out.println("Call WFVAlDATA for PRS RMPM porder TRAN ID  "+tranId);
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( tranId != null && tranId.trim().length() > 0 )
				{
					sql = "DELETE FROM PORCPDET WHERE TRAN_ID = ?";	
					pstmt =  conn.prepareStatement(sql);
					pstmt.setString(1, tranId);
					deleteCount = pstmt.executeUpdate();						
					if( deleteCount > 0 )
					{
						System.out.println( "Row with Tran_ID " + tranId + " deleted from PORCPDET table" );
					}						
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}	
					
					sql = "DELETE FROM PORCP WHERE TRAN_ID = ?";
					pstmt =  conn.prepareStatement(sql);
					pstmt.setString(1, tranId);
					deleteCount = pstmt.executeUpdate();						
					if( deleteCount > 0 )
					{
						System.out.println( "Row with Tran_ID " + tranId + " deleted from PORCP table" );
					}						
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
			}
		}
		catch (SQLException sqe)
		{
			System.out.println("The SQLException occurs in PorcpPrs :"+sqe);
			sqe.printStackTrace();
			throw new ITMException(sqe);
		}
		catch(Exception e)
		{
			System.out.println("The Exception occurs in PorcpPrs :"+e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :PorcpPrs :\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return "";
	}
}
