/*
Window Name : w_voucher
Button name : Receipt
Action		: Get Details from PORCP, PORCPDET Table where Receipt is confirmed.
*/

package ibase.webitm.ejb.fin.adv;

import ibase.webitm.utility.GenericUtility;
import java.rmi.RemoteException;
import java.sql.*;
import org.w3c.dom.*;
import javax.ejb.*;

import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.*;
import ibase.system.config.*;
import java.text.SimpleDateFormat;
import javax.ejb.Stateless; // added for ejb3

@Stateless // added for ejb3

public class VoucherAct extends ActionHandlerEJB implements VoucherActLocal,VoucherActRemote //SessionBean
{
	/*public void ejbCreate() throws RemoteException, CreateException 
	{
		System.out.println("VoucherActEJB Created.....");
	}

	public void ejbRemove()
	{
	}

	public void ejbActivate() 
	{
	}

	public void ejbPassivate() 
	{
	}*/

    public String actionHandler() throws RemoteException,ITMException
	{
		return "";
	}

	public String actionHandler(String actionType, String xmlString, String objContext, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		String  resString = null;
		GenericUtility genericUtility = GenericUtility.getInstance(); 
		try
		{
			if (actionType.equalsIgnoreCase("PurRcpt"))
			{
				if(xmlString != null && xmlString.trim().length()!=0)
				{
					System.out.println("XML String :"+xmlString);
					dom = genericUtility.parseString(xmlString); 
				}
				resString = actionPurRcpt(dom,objContext,xtraParams);
			}
		}
	   	catch(Exception e)
		{
			System.out.println("Exception :VoucherActEJB :actionHandler(String xmlString):" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("returning from VoucherActEJB actionHandler"+resString);
	    return resString;
	}

	public String actionHandlerTransform(String actionType, String xmlString, String xmlString1, String objContext, String xtraParams, String selDataStr) throws RemoteException,ITMException
	{
		System.out.println("actionHandlerTransform is calling.............");
		Document dom = null;
		Document dom1 = null;
		Document selDataDom = null;

		String  retString = null;
		try
		{
			if(xmlString != null && xmlString.trim().length() > 0)
			{
				dom = GenericUtility.getInstance().parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length() > 0)
			{
				dom1 = GenericUtility.getInstance().parseString(xmlString1);
			}
			if(selDataStr != null && selDataStr.length() > 0)
			{
				selDataDom = GenericUtility.getInstance().parseString(selDataStr);
			}

			System.out.println("actionType:"+actionType+":");
						
			if (actionType.equalsIgnoreCase("PurRcpt"))
			{
				retString = purRcptTransform(dom, dom1, objContext, xtraParams, selDataDom);
			}
		}
	   	catch(Exception e)
		{
			System.out.println("Exception : VoucherActEJB :actionHandlerTransform(String xmlString):" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("returning String from VoucherActEJB : actionHandlerTransform"+retString);
	    return retString;
	}

	private String actionPurRcpt(Document dom, String objContext, String xtraParams) throws RemoteException , ITMException
	{
		String siteCode = "";
		String sundryCode = "";
		StringBuffer valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n");
		String sql = "";
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
	    ConnDriver connDriver = new ConnDriver();
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			SimpleDateFormat sdf = new SimpleDateFormat(GenericUtility.getInstance().getApplDateFormat());
			conn = connDriver.getConnectDB("DriverITM");			
			siteCode = genericUtility.getColumnValue("site_code",dom);
			sundryCode = genericUtility.getColumnValue("supp_code",dom);
			
			sql = "SELECT PORCP.TRAN_ID, "   
						  +"PORCP.DC_NO, " 
						  +"PORCP.DC_DATE, "
						  +"PORCP.TRAN_DATE, " 
						  +"PORCP.SUPP_CODE, "
						  +"PORCP.PURC_ORDER, " 
						  +"PORCPDET.LINE_NO__ORD, "
						  +"PORCP.CURR_CODE, "
						  +"PORCPDET.LINE_NO, "
						  +"PORCPDET.ITEM_CODE, "
						  +"PORCPDET.QUANTITY, "
						  +"PORCPDET.UNIT, "
						  +"PORCPDET.RATE, "
						  +"PORCPDET.LOC_CODE, "
						  +"PORCPDET.LOT_NO, "
						  +"PORCPDET.LOT_SL, "
						  +"PORCPDET.NET_AMT, "
						  +"PORCP.TRAN_SER "
						  +"FROM PORCP, PORCPDET "   
						  +"WHERE PORCPDET.TRAN_ID = PORCP.TRAN_ID "
						  +"AND ( PORCP.SUPP_CODE = '" + sundryCode + "' ) "
						  +"AND ( PORCP.SITE_CODE = '" + siteCode + "' ) "
						  +"AND ( PORCP.CONFIRMED = 'Y' ) "
				  +"MINUS "
				  +"SELECT PORCP.TRAN_ID, "
						  +"PORCP.DC_NO, "
						  +"PORCP.DC_DATE, "
						  +"PORCP.TRAN_DATE, "
						  +"PORCP.SUPP_CODE, "
						  +"PORCP.PURC_ORDER, "
						  +"PORCPDET.LINE_NO__ORD, "
						  +"PORCP.CURR_CODE, "
						  +"PORCPDET.LINE_NO, "
						  +"PORCPDET.ITEM_CODE, "
						  +"PORCPDET.QUANTITY, "
						  +"PORCPDET.UNIT, "
						  +"PORCPDET.RATE, "
						  +"PORCPDET.LOC_CODE, "
						  +"PORCPDET.LOT_NO, "
						  +"PORCPDET.LOT_SL, "
						  +"PORCPDET.NET_AMT, "
						  +"PORCP.TRAN_SER "
						  +"FROM PORCP, PORCPDET, VOUCHRCP "
						  +"WHERE PORCPDET.TRAN_ID = PORCP.TRAN_ID "
						  +"AND ( PORCPDET.TRAN_ID = VOUCHRCP.PRCP_ID ) "
						  +"AND ( PORCPDET.LINE_NO = VOUCHRCP.LINE_NO__RCP ) "
						  +"AND ( PORCP.SUPP_CODE = '" + sundryCode + "' ) "
						  +"AND ( PORCP.SITE_CODE = '" + siteCode + "' ) "
						  +"AND ( PORCP.CONFIRMED = 'Y' )";
			System.out.println("The SQL :: "+sql);
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
			while (rs.next())
			{
				valueXmlString.append("<Detail>\r\n");
				valueXmlString.append("<tran_ser>").append((rs.getString(18) == null) ? "":rs.getString(18)).append("</tran_ser>\r\n");
				valueXmlString.append("<tran_id>").append((rs.getString(1) == null) ? "":rs.getString(1)).append("</tran_id>\r\n");
				valueXmlString.append("<tran_date>").append((rs.getDate(4) == null) ? "":sdf.format(rs.getDate(4))).append("</tran_date>\r\n");
				valueXmlString.append("<supp_code>").append((rs.getString(5) == null) ? "":rs.getString(5)).append("</supp_code>\r\n");
				valueXmlString.append("<purc_order>").append((rs.getString(6) == null) ? "":rs.getString(6)).append("</purc_order>\r\n");
				valueXmlString.append("<line_no__ord>").append((rs.getString(7) == null) ? "":rs.getString(7)).append("</line_no__ord>\r\n");
				valueXmlString.append("<line_no>").append((rs.getString(9) == null) ? "":rs.getString(9)).append("</line_no>\r\n");
				valueXmlString.append("<item_code>").append((rs.getString(10) == null) ? "":rs.getString(10)).append("</item_code>\r\n");
				valueXmlString.append("<quantity>").append((rs.getString(11) == null) ? "":rs.getString(11)).append("</quantity>\r\n");
				valueXmlString.append("<unit>").append((rs.getString(12) == null) ? "":rs.getString(12)).append("</unit>\r\n");
				valueXmlString.append("<rate>").append((rs.getString(13) == null) ? "":rs.getString(13)).append("</rate>\r\n");
				valueXmlString.append("<loc_code>").append((rs.getString(14) == null) ? "":rs.getString(14)).append("</loc_code>\r\n");
				valueXmlString.append("<lot_no>").append((rs.getString(15) == null) ? "":rs.getString(15)).append("</lot_no>\r\n");
				valueXmlString.append("<lot_sl>").append((rs.getString(16) == null) ? "":rs.getString(16)).append("</lot_sl>\r\n");
				valueXmlString.append("<net_amt>").append((rs.getString(17) == null) ? "":rs.getString(17)).append("</net_amt>\r\n");				
				valueXmlString.append("<curr_code>").append((rs.getString(8) == null) ? "":rs.getString(8)).append("</curr_code>\r\n");				
				valueXmlString.append("<dc_no>").append((rs.getString(2) == null) ? "":rs.getString(2)).append("</dc_no>\r\n");				
				valueXmlString.append("<dc_date>").append((rs.getDate(3) == null) ? "":sdf.format(rs.getDate(3))).append("</dc_date>\r\n");							
				//valueXmlString.append("<line_no__rcp>").append(rs.getString(9)).append("</line_no__rcp>\r\n");
				valueXmlString.append("</Detail>\r\n");
			}
			stmt.close();
			valueXmlString.append("</Root>\r\n");			
		}
		catch(Exception e)
		{
			System.out.println("Exception : VoucherActEJB : actionHandler :(Document dom)" +e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			System.out.println("Closing Connection.......");
			try{
				conn.close();
				conn = null;
			}catch(Exception e){}
		}
		return valueXmlString.toString();
	}

	private String purRcptTransform(Document dom,Document dom1, String objContext, String xtraParams, Document selDataDom)throws ITMException
	{
		StringBuffer valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n");
		try
		{			
			valueXmlString.append("</Root>");
		}
		catch (Exception e)
		{
			System.out.println("Exception :: purRcptTransform :: "+e.getMessage());
		}
		return valueXmlString.toString();
	}
}