/**
 * @author : Akhilesh Sikarwar 
 * @Version : 1.0
 * Date : 05/02/13
 */
package ibase.webitm.ejb.fin.adv;

import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.text.*;
import java.sql.BatchUpdateException;




import javax.ejb.Stateless;
@Stateless
public class ReceiptAdvConf extends ActionHandlerEJB implements ReceiptAdvConfLocal,ReceiptAdvConfRemote 
{
	public String confirm(String tranID,String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{
		String retString = "";
		boolean isConn= false;
		Connection conn = null;
        boolean isPreview = false;
		try
		{
			retString = confirm( tranID, xtraParams, forcedFlag, conn ,isPreview);

			if ( retString != null && retString.length() > 0 )
			{
				throw new Exception("Exception while calling confirm for tran  Id:["+tranID+"]");
			}
		}
		catch(Exception exception)
		{
			System.out.println("Exception in [InvHoldConfEJB] getCurrdateAppFormat " + exception.getMessage());
		}
		return retString;
	}
	//Added by vishakha
	public String confirm(String tranID,String xtraParams, String forcedFlag, Connection conn) throws RemoteException,ITMException
	{
		String retString = "";
		boolean isConn= false;

        boolean isPreview = false;
		try
		{
			retString = confirm( tranID, xtraParams, forcedFlag, conn ,isPreview);

			if ( retString != null && retString.length() > 0 )
			{
				throw new Exception("Exception while calling confirm for tran  Id:["+tranID+"]");
			}
		}
		catch(Exception exception)
		{
			System.out.println("Exception in [InvHoldConfEJB] getCurrdateAppFormat " + exception.getMessage());
		}
		return retString;
	}
	public String confirm(String tranId,String xtraParams,String forcedFlag, Connection conn, boolean isPreview) throws RemoteException,ITMException
	{
		System.out.println("confirm called........");
		String sql = "";
		String confirm = "";
		String siteCode = "";
		String errString = "" ;
		String tranSer = "";
		String loginEmpCode = "";
		//Connection conn = null;
		//ConnDriver connDriver = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		FinCommon finCommon = null;
		GenericUtility genericUtility = null;
		ITMDBAccessEJB itmDBAccessEJB = null;
		ValidatorEJB validatorEJB = null;
		System.out.println("tran id = "+tranId);
		boolean connStatus=false;
		String chgUser="";
		try
		{
			if ( conn == null )//changed by Gulzar - 25/11/11
			{
				ConnDriver connDriver = null;
				connDriver = new ConnDriver();
				conn = connDriver.getConnectDB("DriverITM");
				conn.setAutoCommit(false);
				connDriver = null;
				connStatus = true;
			}
			finCommon = new FinCommon();
			genericUtility = new GenericUtility();
			itmDBAccessEJB = new ITMDBAccessEJB();
			validatorEJB = new ValidatorEJB();
			//connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			//connDriver = null;
			//conn.setAutoCommit(false);
			loginEmpCode =validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
			System.out.println("Printing loginEmpCode---1-----"+loginEmpCode+"--");
			
			

			sql = "select confirmed ,site_code,chg_user  from receipt where tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				confirm = rs.getString("confirmed") == null ?"N":rs.getString("confirmed");
				siteCode = rs.getString("site_code") == null ?" ":rs.getString("site_code");
				chgUser = rs.getString("chg_user") == null ?" ":rs.getString("chg_user");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			if(chgUser==null || chgUser.trim().length()==0)
			{
				chgUser="SYSTEM";
			}
			if("null".equalsIgnoreCase(loginEmpCode) || loginEmpCode==null || loginEmpCode.trim().length()==0)
			{
				sql="select emp_code from users where code=?";
				pstmt=conn.prepareStatement(sql);
				pstmt.setString(1,chgUser);
				
				rs=pstmt.executeQuery();
				if(rs.next())
				{
					loginEmpCode=rs.getString(1);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				System.out.println("Printing loginEmpCode---2-----"+loginEmpCode+"--");
				
			}
			
			if(isPreview != false){
				errString = gbfRetrieveReceipt(tranId,siteCode,xtraParams,conn,isPreview);
			}
			else{
				
			if(confirm != null  && confirm.equalsIgnoreCase("N"))
			{
				errString = gbfRetrieveReceipt(tranId,siteCode,xtraParams,conn);
				System.out.println("err String from gdfRetrieveMiscRcp ="+errString);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
				
				//added by akhilesh on 05/09/2013 for check cr dr amt 
				//sql = "select distinct(ref_ser) from gltrace where ref_id = ?";	
				//pstmt = conn.prepareStatement(sql);
				//pstmt.setString(1,tranId);  
				//rs = pstmt.executeQuery();
				//if(rs.next())
				//{     
				//	tranSer = rs.getString(1);
				//}
				//rs.close();
				//rs = null;
				//pstmt.close();
				//pstmt = null;
									
				//errString = finCommon.checkGlTranDrCr(tranSer,tranId,conn);
				//System.out.println("err String from checkGlTranDrCr ="+errString);
				
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
				
				if(errString == null || errString.trim().length() == 0)
				{
					if("null".equalsIgnoreCase(loginEmpCode) || loginEmpCode==null || loginEmpCode.trim().length()==0)
					{
						loginEmpCode="E03952";
					}
					System.out.println("loginEmpCode--3-"+loginEmpCode);
					sql = "update receipt set confirmed = 'Y', conf_date = ?,emp_code__aprv = ? where tran_id = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setDate(1, new java.sql.Date(new java.util.Date().getTime()));
					pstmt.setString(2, loginEmpCode);
					pstmt.setString(3, tranId);
					int updateCoount = pstmt.executeUpdate();
					System.out.println("no of row update = "+updateCoount);
					pstmt.close();
					pstmt = null;
					if(updateCoount > 0)
					{
						errString = itmDBAccessEJB.getErrorString("","VTCICONF3","","",conn);
					}
				}
				else 
				{
					//errString = itmDBAccessEJB.getErrorString("","VTDESNCONF ","","",conn);
					return errString;
				}
			}
			else
			{
				System.out.println("The Selected transaction is already confirmed");
				errString = itmDBAccessEJB.getErrorString("","VTMCONF1","","",conn);
				return errString;
			}
			System.out.println("115 err String from confirm method.....");
		} 
		}
		catch( Exception e)
		{
			if(conn!=null)
			{
				try {
					conn.rollback();
				} catch (SQLException ex) {

					System.out.println("Exception : "+e);
					e.printStackTrace();
					throw new ITMException(e);

				}
			}
			System.out.println("Exception : "+e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			
				try
				{
					
					if(errString != null && errString.trim().length() > 0)
					{
						if( conn != null && !conn.isClosed() && connStatus ) 
						{
							if(errString.indexOf("VTCICONF3") > -1)
							{
								conn.commit();
							}
							else
							{
								conn.rollback();
							}
							conn.close();
							conn = null;
						}
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					//conn.close();
				}
				catch(Exception e)
				{
					System.out.println("Exception : "+e);e.printStackTrace();
					throw new ITMException(e);
				}
			
		}
		return errString;
	} //end of confirm method
	//vishakha
	private String gbfRetrieveReceipt(String tranId,String siteCode,String xtraParams,Connection conn)throws RemoteException,ITMException
	{
		String errString = gbfRetrieveReceipt(tranId,siteCode,xtraParams,conn,false);
		
		return errString;
	}
	
	private String gbfRetrieveReceipt(String tranId,String siteCode,String xtraParams,Connection conn,boolean isPreview)throws RemoteException,ITMException
	{
		System.out.println("gdf Retrieve Receipt Called...........");
		String errString = "";
		String sundryCode = "";
		String sql = "";
		String cctrFin = "";
		String cctrFins = "";
		String rcpType = "";
		String bdFluctuationCf = "";
		String ledgPostConf = "";
		String acctFin = "";
		String acctFins = "";
		String refser = "";
		String refNo ="";
		String acctCodeAr  = "";
		String cctrCodeAr  = "";	
		String billDisc ="";
		String custCode  = "";	
		String rcpClubPost = "";
		String partyDocRef = "";
		String lineNoRef = ""; 
		String acct = "";
		String cctr = "";
		String stype = "";
		String scode = "";
		String acctCode = "";
		String cctrCode = "";
		String currCode = "";
		String sundryType = "";
		String hcurrCode = "";
		String finEntity = "";
		String hcustCode = "";
		String refSer = "";
		String acctCodeDr = "";
		String cctrCodeDr = "";
		String acctCodeCr = "";
		String cctrCodeCr = "";
		String rcpepcAdj = "";
		String analCode = "";
		String empCode = "";
		String effectParty = "N";
		int count = 0;
		double netAmount = 0.0;
		double exchRateRcv  = 0.0;	
		double rcpAmt  = 0.0;
		double finChg  = 0.0;
		double totalAmt = 0.0;
		double advAmt = 0.0 ;
		double finTotal = 0.0;
		double exchRate = 0.0;
		double exch = 0.0;
		double totbdDiff = 0.0;
		double total = 0.0;
		double tFin = 0.0;
		double hExchRate = 0.0 ;
		double amount = 0.0;
		double totEpc = 0.0;
		double totEpcBc = 0.0 ;
		double hexchRate = 0.0;
		double diffAmtExch = 0.0;
		double badDebtAmt =  0.0;
		double amtProv = 0.0;
		double amtRevrsed = 0.0;
		double amtRev = 0.0;
		double badAmt = 0.0;
		double totBc = 0.0;
		double chq = 0.0;
		int i = 0;
		int cnt = 0 ;
		int maxline = 0;
		int cnt1 = 0 , findIndex = -1;

		Date tranDate = null;
		HashMap RcpHdrMap = null;
		HashMap DetMap = null;
		HashMap RcpDetMap = null;
		HashMap ADetMap = null;
		HashMap EpcAdjMap = null;
		boolean isError = false;
		String retString = "";
		ArrayList EpcAdjList = new ArrayList();
		boolean isEpcCurrSame = false;
		ArrayList RcpDetList = new ArrayList();
		ArrayList DetList = new ArrayList();
		ArrayList ADetList = new ArrayList();
		ArrayList miscRcpDetList = new ArrayList();
		PreparedStatement pstmt = null, pstmt1 = null;
		ResultSet rs = null;
		ITMDBAccessEJB itmDBAccessEJB = null;
		FinCommon finCommon = null;
		DistCommon disCommon = null;
		double amountMap = 0;
		double detAmount = 0;
		HashMap detMap = null;
		int detListSize = 0;
		double amtNoBankEffect=0;
		try
		{
			finCommon = new FinCommon();
			disCommon = new DistCommon();


			cctrFin = finCommon.getFinparams("999999", "ACCT_FINCHG", conn);
			if(cctrFin != null && ! "NULLFOUND".equalsIgnoreCase(cctrFin))
			{
				if (cctrFin.indexOf(";") > -1)
				{
					acctFin = cctrFin.substring(0, cctrFin.indexOf(";"));
					cctrFin = cctrFin.substring(cctrFin.indexOf(";") +1);
				}
				else
				{
					acctFin = cctrFin;
					cctrFin = "    ";
				}
			}
			else
			{
				errString = itmDBAccessEJB.getErrorString("","VTFINPARM ","","",conn);
				return errString;
			}
			

			cctrFins = finCommon.getFinparams("999999", "ACCT_FINCHG_AR", conn);
			if(cctrFins != null && ! "NULLFOUND".equalsIgnoreCase(cctrFins))
			{
				if (cctrFins.indexOf(";") > -1)
				{
					acctFins = cctrFins.substring(0, cctrFins.indexOf(";"));
					cctrFins = cctrFins.substring(cctrFins.indexOf(";") +1);
				}
				else
				{
					acctFins = cctrFins;
					cctrFins = "    ";
				}
			}
			else
			{
				errString = itmDBAccessEJB.getErrorString("","VTFINPARM ","","",conn);
				return errString;
			}


			bdFluctuationCf = finCommon.getFinparams("999999", "BD_FLUCTUATION_CF", conn);
			if( "NULLFOUND".equalsIgnoreCase(bdFluctuationCf))
			{
				errString = itmDBAccessEJB.getErrorString("","VTFINPARM ","","",conn);
				return errString;
			}


			rcpClubPost = finCommon.getFinparams("999999", "RCP_CLUB_POST", conn);
			if( "NULLFOUND".equalsIgnoreCase(rcpClubPost))
			{
				errString = itmDBAccessEJB.getErrorString("","VTFINPARM ","","",conn);
				return errString;
			}

           System.out.println("rcpClubPost>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"+rcpClubPost);
			itmDBAccessEJB = new ITMDBAccessEJB();

			if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
			{
				sql = "SELECT tran_id, adv_amt, rcp_type FROM receipt  WHERE tran_id = ? for update ";
			}

			else if ( "mssql".equalsIgnoreCase(CommonConstants.DB_NAME ))
			{
				sql = "SELECT tran_id, adv_amt, rcp_type FROM receipt (updlock) WHERE tran_id = ? " ;
			}
			else
			{
				sql =" SELECT tran_id, adv_amt, rcp_type FROM receipt WHERE tran_id =  ? for update nowait" ;
			}
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				tranId = rs.getString("tran_id") == null ? " ":rs.getString("tran_id");
				advAmt = rs.getDouble("adv_amt");
				rcpType = rs.getString("rcp_type") == null ? " ":rs.getString("rcp_type");
			}
			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;

			if(advAmt < 0)
			{
				errString = itmDBAccessEJB.getErrorString("","VTRCPADV2","","",conn);
				return errString ;
			}

			java.util.Date today=	new java.sql.Date(new java.util.Date().getTime());

			sql = "select tran_id, tran_date, cust_code, tran_type, rcp_mode, bank_code, ref_no, ref_date, remarks, net_amt, curr_code," +
					" exch_rate, net_amt__bc, fin_entity, acct_code__ar, cctr_code__ar, acct_code__bal, cctr_code__bal, site_code," +
					" confirmed, adv_amt ,acct_code__cf, cctr_code__cf,eff_date, chq_amt,remarks, proj_code, entry_batch_no,bill_amt ," +
					" diff_amt__exch, net_amt__bc,  anal_code, bill_disc_amt, oth_amt, efundadj_amt, acct_code__adv, cctr_code__adv ,tax_amt ,item_ser" +
					" from  receipt  where tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				RcpHdrMap = new HashMap();
				RcpHdrMap.put("tran_date",rs.getDate("tran_date"));
				RcpHdrMap.put("tran_id",rs.getString("tran_id"));
				RcpHdrMap.put("cust_code",rs.getString("cust_code"));
				RcpHdrMap.put("tran_type",rs.getString("tran_type"));
				RcpHdrMap.put("rcp_mode",rs.getString("rcp_mode"));
				RcpHdrMap.put("bank_code",rs.getString("bank_code"));
				RcpHdrMap.put("ref_no",rs.getString("ref_no"));
				RcpHdrMap.put("ref_date",rs.getDate("ref_date"));
				RcpHdrMap.put("remarks",rs.getString("remarks"));
				RcpHdrMap.put("net_amt",rs.getDouble("net_amt"));
				RcpHdrMap.put("exch_rate",rs.getDouble("exch_rate"));
				RcpHdrMap.put("curr_code",rs.getString("curr_code"));
				RcpHdrMap.put("net_amt__bc",rs.getDouble("net_amt__bc"));
				RcpHdrMap.put("fin_entity",rs.getString("fin_entity"));
				RcpHdrMap.put("acct_code__ar",rs.getString("acct_code__ar"));
				RcpHdrMap.put("cctr_code__ar",rs.getString("cctr_code__ar")==null?"":rs.getString("cctr_code__ar"));
				RcpHdrMap.put("acct_code__bal",rs.getString("acct_code__bal"));
				RcpHdrMap.put("cctr_code__bal",rs.getString("cctr_code__bal")==null?"":rs.getString("cctr_code__bal"));
				RcpHdrMap.put("site_code",rs.getString("site_code"));
				RcpHdrMap.put("confirmed",rs.getString("confirmed"));
				RcpHdrMap.put("adv_amt",rs.getDouble("adv_amt"));
				RcpHdrMap.put("acct_code__cf",rs.getString("acct_code__cf"));
				RcpHdrMap.put("cctr_code__cf",rs.getString("cctr_code__cf")==null?"":rs.getString("cctr_code__cf"));
				RcpHdrMap.put("eff_date",rs.getDate("eff_date"));
				RcpHdrMap.put("chq_amt",rs.getDouble("chq_amt"));
				RcpHdrMap.put("remarks",rs.getString("remarks"));
				RcpHdrMap.put("proj_code",rs.getString("proj_code"));
				RcpHdrMap.put("entry_batch_no",rs.getString("entry_batch_no"));
				RcpHdrMap.put("bill_amt",rs.getDouble("bill_amt"));
				RcpHdrMap.put("diff_amt__exch",rs.getDouble("diff_amt__exch"));
				RcpHdrMap.put("anal_code",rs.getString("anal_code"));
				RcpHdrMap.put("bill_disc_amt",rs.getDouble("bill_disc_amt"));
				RcpHdrMap.put("oth_amt",rs.getDouble("oth_amt"));
				RcpHdrMap.put("efundadj_amt",rs.getDouble("efundadj_amt"));
				RcpHdrMap.put("acct_code__adv",rs.getString("acct_code__adv"));
				RcpHdrMap.put("cctr_code__adv",rs.getString("cctr_code__adv")==null?"":rs.getString("cctr_code__adv"));
				RcpHdrMap.put("tax_amt",rs.getDouble("tax_amt"));
				RcpHdrMap.put("item_ser",rs.getString("item_ser"));
				System.out.println(" Header Map..........");
				System.out.println(RcpHdrMap.toString());
			}
			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;

			sql =" select ledg_post_conf from transetup where upper(tran_window) = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,"W_RECEIPT_ADV");  // issue
			rs = pstmt.executeQuery();
			if(rs.next())
			{     
				ledgPostConf = rs.getString("ledg_post_conf");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			if(ledgPostConf != null  && "Y".equalsIgnoreCase(ledgPostConf))
			{
				if(((Date)RcpHdrMap.get("tran_date")).compareTo(today)!= 0){tranDate = today;}
				sql = "update receipt set tran_date  =? where tran_id = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setDate(1, new java.sql.Date(new java.util.Date().getTime()));
				pstmt.setString(2, tranId);
				int updateCoount = pstmt.executeUpdate();

				pstmt.close();
				pstmt = null;

			}

			if(((Date)RcpHdrMap.get("eff_date")).compareTo(today) > 0)
			{
				errString = itmDBAccessEJB.getErrorString("","VTRCPDT1","","",conn);
				return errString;
			}


			// populate rcpacct

			// 29/01/14 manoharan effect_party considered
//if(!isPreview){ commented by vishaka for F14ISUN006 for acct receipt window
			sql = "select sundry_type,sundry_code,acct_code,cctr_code,emp_code, anal_code,curr_code ,exch_rate,amount,party_doc_ref,case when effect_party is null then 'N' else effect_party end as effect_party,case when eff_bank is null then 'N' else eff_bank end as eff_bank from rcpacct where tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				DetMap = new HashMap();
				DetMap.put("sundry_type", rs.getString("sundry_type"));
				DetMap.put("sundry_code", rs.getString("sundry_code"));
				DetMap.put("acct_code", rs.getString("acct_code"));
				DetMap.put("cctr_code", rs.getString("cctr_code"));
				DetMap.put("emp_code", rs.getString("emp_code"));
				DetMap.put("anal_code", rs.getString("anal_code"));
				DetMap.put("curr_code", rs.getString("curr_code"));
				DetMap.put("exch_rate", rs.getDouble("exch_rate"));
				DetMap.put("amount", rs.getDouble("amount"));
				DetMap.put("party_doc_ref", rs.getString("party_doc_ref"));
				DetMap.put("effect_party", rs.getString("effect_party")); // 29/01/14 manoharan
				DetMap.put("eff_bank", rs.getString("eff_bank")); // 03/02/14 Manoj
				DetList.add(DetMap);
				//System.out.println(" receipt Acct Map..........");
				System.out.println("DetList initial [" + DetList.toString() + "]");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			detListSize = DetList.size();
		//	}
			sql = "select ref_ser, ref_no,adj_amt,acct_code,cctr_code,exch_rate__vouch from rcpadv where tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{	
				ADetMap = new HashMap();
				ADetMap.put("ref_ser", rs.getString("ref_ser"));
				ADetMap.put("ref_no", rs.getString("ref_no"));
				ADetMap.put("adj_amt", rs.getDouble("adj_amt"));
				ADetMap.put("sundry_type", "C");
				ADetMap.put("sundry_code", (String) RcpHdrMap.get("sundry_code"));
				ADetMap.put("acct_code", rs.getString("acct_code"));
				ADetMap.put("cctr_code", rs.getString("cctr_code"));
				ADetMap.put("exch_rate__vouch", rs.getDouble("exch_rate__vouch"));
				ADetList.add(ADetMap);
				System.out.println(" receipt Adv Map..........");
				System.out.println(ADetMap.toString());
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			sql = "select ref_ser, ref_no,curr_code,exch_rate,amount,acct_code,cctr_code,sundry_type,sundry_code from rcpepc_adj where tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{	
				EpcAdjMap = new HashMap();
				EpcAdjMap.put("ref_ser", rs.getString("ref_ser"));
				EpcAdjMap.put("ref_no", rs.getString("ref_no"));

				EpcAdjMap.put("curr_code", rs.getString("curr_code"));
				EpcAdjMap.put("exch_rate", rs.getString("exch_rate"));
				EpcAdjMap.put("amount", rs.getString("amount"));

				EpcAdjMap.put("acct_code", rs.getString("acct_code"));
				EpcAdjMap.put("cctr_code", rs.getString("cctr_code"));
				EpcAdjMap.put("sundry_type", rs.getString("sundry_type"));
				EpcAdjMap.put("sundry_code", rs.getString("sundry_code"));
				EpcAdjList.add(EpcAdjMap);
				System.out.println(" Rcpepc Adj Map..........");
				System.out.println(EpcAdjList.toString());
			}

			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			//RcpDetMap = new HashMap();
			sql = "select line_no__ref,ref_ser,ref_no,acct_code__ar,cctr_code__ar,exch_rate__rcv,rcp_amt,fin_chg,cust_code,bad_debt_amt,bill_disc_amt,exch_rate from rcpdet where tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				RcpDetMap = new HashMap();
				RcpDetMap.put("line_no__ref", rs.getString("line_no__ref"));
				RcpDetMap.put("ref_ser", rs.getString("ref_ser"));
				RcpDetMap.put("ref_no", rs.getString("ref_no"));
				RcpDetMap.put("acct_code__ar", rs.getString("acct_code__ar"));
				RcpDetMap.put("cctr_code__ar", rs.getString("cctr_code__ar")==null?"":rs.getString("cctr_code__ar"));
				RcpDetMap.put("exch_rate__rcv", rs.getDouble("exch_rate__rcv"));
				RcpDetMap.put("exch_rate", rs.getDouble("exch_rate"));
				RcpDetMap.put("rcp_amt", rs.getDouble("rcp_amt"));
				RcpDetMap.put("fin_chg", rs.getDouble("fin_chg"));
				RcpDetMap.put("cust_code", rs.getString("cust_code"));
				RcpDetMap.put("bad_debt_amt", rs.getDouble("bad_debt_amt"));
				RcpDetMap.put("bill_disc_amt", rs.getDouble("bill_disc_amt")); 				//ADDED BY RITESH ON 24/05/13
				RcpDetList.add(RcpDetMap);

				System.out.println(" DetMap  Map..........");
				System.out.println(RcpDetMap.toString());

			}

			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			for(i=0 ; i<RcpDetList.size() ; i++)
			{
				//RcpDetMap = new HashMap();
				RcpDetMap = (HashMap) RcpDetList.get(i);
				
				if(!((String)RcpDetMap.get("ref_ser")).equals("M-INV"))
				{
					// to convert in terms of header currency in case multiple currency
					//total = total + (Double)RcpDetMap.get("rcp_amt");
					total = total + ( (double) Double.parseDouble( "" + RcpDetMap.get("rcp_amt")) * (double) Double.parseDouble( "" + RcpDetMap.get("exch_rate")) /  (double) Double.parseDouble( "" + RcpHdrMap.get("exch_rate")) );
					
					//finTotal = finTotal + (double) Double.parseDouble( "" + RcpDetMap.get("fin_chg"));
					tFin = tFin + (double) Double.parseDouble( "" + RcpDetMap.get("fin_chg"));

					//System.out.println("LINE NO 541"+total);

					if(rcpClubPost.equals("Y"))
					{

						/* sql = "select count(*) from rcpacct where acct_code = ? and cctr_code = ? and exch_rate = ? and tran_id = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,(String)RcpDetMap.get("acct_code__ar"));
						pstmt.setString(2,(String)RcpDetMap.get("cctr_code__ar")==null?"":(String)RcpDetMap.get("cctr_code__ar"));
						pstmt.setDouble(3,(Double)RcpDetMap.get("exch_rate__rcv"));
						pstmt.setString(4,tranId);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							cnt = rs.getInt(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						
						sql = "select max(LINE_NO) from rcpacct where  tran_id = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,tranId);//issue
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							maxline = rs.getInt(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						
						if(cnt == 0)
						{

							//CLOSE INSERT
							sql = "Insert into rcpacct (TRAN_ID,LINE_NO,ACCT_CODE,CCTR_CODE,EXCH_RATE,AMOUNT,EMP_CODE,ANAL_CODE,EFFECT_PARTY,SUNDRY_TYPE,SUNDRY_CODE) values (?,?,?,?,?,?,?,?,?,?,?)";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,tranId);//issue
							pstmt.setString(2,String.valueOf(maxline+1));
							pstmt.setString(3,(String)RcpDetMap.get("acct_code__ar"));
							pstmt.setString(4,(String)RcpDetMap.get("cctr_code__ar")==null?"":(String)RcpDetMap.get("cctr_code__ar"));
							pstmt.setDouble(5,(Double)RcpDetMap.get("exch_rate__rcv"));
							pstmt.setDouble(6,(Double)RcpDetMap.get("rcp_amt"));
							pstmt.setString(7,"");
							pstmt.setString(8,"");
							pstmt.setString(9,"Y");
							pstmt.setString(10,"C");
							pstmt.setString(11,(String)RcpDetMap.get("cust_code"));
							pstmt.executeUpdate();

							pstmt.close();
							pstmt = null;
						}
						else
						{

							sql = "update rcpacct set amount  =? where tran_id = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setDouble(1, ((Double)total));//added by akhilesh on 19/aug/13
							//pstmt.setDouble(1, ((Double)RcpDetMap.get("rcp_amt")+(Double)(DetMap.get("amount")==null?0.0:DetMap.get("amount"))));
							pstmt.setString(2, tranId);
							int updateCoount = pstmt.executeUpdate();

							pstmt.close();
							pstmt = null;
						}*/
						// 29/09/13 manoharan check whether exists in rcpacct map, if so, add the amount, else add new map to list
						findIndex = findExistingIndex(DetList,(String) RcpDetMap.get("acct_code__ar"), (String) RcpDetMap.get("cctr_code__ar"), (double) Double.parseDouble( "" + RcpDetMap.get("exch_rate__rcv")));
					}
					else
					{
						findIndex = -1;
					}
				//	System.out.println("findIndex>>>>>>>>>>>>>>>>>>>>>>>>>>>>773"+findIndex);
					if (findIndex > -1) 
					{
						detMap = (HashMap) DetList.get(findIndex);
						amountMap = (double) Double.parseDouble( "" + detMap.get("amount"));
						detAmount = (double) Double.parseDouble( "" + RcpDetMap.get("rcp_amt"));
						detMap.put("amount", amountMap + detAmount );
						DetList.set(findIndex, detMap);
					//	System.out.println("amount>>>>>>>>>>>>>>>>>>>>>>>>>>>>781"+(amountMap + detAmount));
					}
				
					else
					{
						detMap = new HashMap();
						
						detMap.put("sundry_type", "C");
						detMap.put("sundry_code", (String)RcpDetMap.get("cust_code"));
						detMap.put("acct_code", (String)RcpDetMap.get("acct_code__ar"));
						detMap.put("cctr_code", (String)RcpDetMap.get("cctr_code__ar"));
						detMap.put("emp_code", null);
						detMap.put("anal_code", null);
						//detMap.put("curr_code", rs.getString("curr_code"));
						detMap.put("exch_rate", (double) Double.parseDouble( "" + RcpDetMap.get("exch_rate__rcv")));
						detMap.put("amount", (double) Double.parseDouble( "" + RcpDetMap.get("rcp_amt")));
						partyDocRef = finCommon.gfGetPartyDocRef((String)RcpDetMap.get("ref_ser"), (String)RcpDetMap.get("ref_no"),conn);
						detMap.put("party_doc_ref", partyDocRef);
						detMap.put("effect_party", "Y"); // 29/01/14 manoharan
						detMap.put("eff_bank", "Y"); // 03/02/14 Manoj
						DetList.add(detMap);
					}
				}
						
						
			}
			// populate bill if bill is discounted
			// then credit the amount to the BD
			System.out.println("DetList*****************************811******************"+DetList.toString());
			for(i=0 ; i<RcpDetList.size() ; i++)
			{
				//RcpDetMap = new HashMap();
				RcpDetMap = (HashMap)RcpDetList.get(i);


				refSer 			= (String)RcpDetMap.get( "ref_ser");
				refNo   		= (String)RcpDetMap.get("ref_no");
				hExchRate 		= (double) Double.parseDouble( "" + RcpDetMap.get("exch_rate")); // 26/09/13 Manoharan take from detail instead of 
				lineNoRef       = (String)RcpDetMap.get("line_no__ref"); 


				if(refSer.trim().equalsIgnoreCase("S-INV") || refSer.substring(0, 4).equalsIgnoreCase("R-IBC")) 
				{
					sql = "select receivables.bill_disc from receivables where tran_ser = ? and ref_no = ? and line_no__ref = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,refSer);
					pstmt.setString(2,refNo);
					pstmt.setString(3,lineNoRef);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						billDisc = rs.getString(1)==null?"N":rs.getString(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
				}
				if(billDisc.equalsIgnoreCase("Y"))
				{
					sql = "SELECT export_fund.acct_code__ar, export_fund.cctr_code__ar, export_fund.exch_rate, sundry_type,sundry_code  FROM 	export_fund,    export_fundet   WHERE ( export_fund.tran_id = export_fundet.tran_id ) and  	( export_fund.confirmed 	= 'Y') and( ( export_fundet.ref_ser 	= ? ) and   ( export_fundet.ref_no 		= ? ) )"   ;
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,refSer);				//modify by ritesh on 24/05/13
					pstmt.setString(2,refNo);				//modify by ritesh on 24/05/13
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						acct = rs.getString(1);
						cctr = rs.getString(2)==null?"":rs.getString(2);
						exch = rs.getDouble(3);
						stype = rs.getString(4);
						scode = rs.getString(5);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;

					//		rcpAmt = (Double)RcpDetMap.get( "rcp_amt");
					rcpAmt = (double) Double.parseDouble( "" + RcpDetMap.get( "bill_disc_amt"));               //added by ritesh on 15/05/13 as per discussion with pravin
					totbdDiff 	= totbdDiff + (rcpAmt * hExchRate ) - (rcpAmt * exch );						
					//		rcpAmt  		= 0 - (Double)RcpDetMap.get( "rcp_amt");
					rcpAmt  		= -1 * (double) Double.parseDouble( "" + RcpDetMap.get( "bill_disc_amt"));  // //added by ritesh on 15/05/13 as per discussion with pravin
					finChg 	        = -1 * (double) Double.parseDouble( "" + RcpDetMap.get( "fin_chg"));

					total = total + rcpAmt;

					//System.out.println("total in 666"+total);


					tFin = tFin + finChg;
					if (rcpAmt != 0)
					{
						if(rcpClubPost.equals("Y"))
						{
							findIndex = findExistingIndex(DetList, acct, cctr, exch);
						}
						else
						{
							findIndex = -1;
						}

						if (findIndex > -1) 
						{
							detMap = (HashMap) DetList.get(findIndex);
							amountMap = (double) Double.parseDouble( "" + detMap.get("amount"));
							detMap.put("amount", amountMap + rcpAmt );
							DetList.set(findIndex, detMap);
						}
						else
						{
							detMap = new HashMap();
							
							detMap.put("sundry_type", stype);
							detMap.put("sundry_code", scode);
							detMap.put("acct_code", acct);
							detMap.put("cctr_code", cctr);
							detMap.put("emp_code", null);
							detMap.put("anal_code", null);
							//detMap.put("curr_code", rs.getString("curr_code"));
							detMap.put("exch_rate", exch);
							detMap.put("amount", rcpAmt);
							detMap.put("party_doc_ref", null);
							detMap.put("effect_party", "N"); // 29/01/14 manoharan
							detMap.put("eff_bank", "Y"); // 03/02/14 Manoj
							DetList.add(detMap);
						}
					}
					
					/*	sql = "select count(*) from rcpacct where acct_code = ? and cctr_code = ? and exch_rate = ? and tran_id = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,acct);
						pstmt.setString(2,cctr==null?"":cctr);
						pstmt.setDouble(3,exch);
						pstmt.setString(4,tranId);
						rs = pstmt.executeQuery();
						while(rs.next())
						{
							cnt1 = rs.getInt(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						
						sql = "select max(LINE_NO) from rcpacct where  tran_id = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,tranId);//issue
						rs = pstmt.executeQuery();
						while(rs.next())
						{
							maxline = rs.getInt(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						
						
						
						if(cnt1 == 0)
						{

							sql = "Insert into rcpacct (TRAN_ID,LINE_NO,ACCT_CODE,CCTR_CODE,EXCH_RATE,AMOUNT,EMP_CODE,ANAL_CODE,EFFECT_PARTY,SUNDRY_TYPE,SUNDRY_CODE) values (?,?,?,?,?,?,?,?,?,?,?)";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,tranId);
							pstmt.setString(2,String.valueOf(maxline+1));
							pstmt.setString(3,acct);
							pstmt.setString(4,cctr==null?"":cctr);
							pstmt.setDouble(5,exch);
							pstmt.setDouble(6,rcpAmt);
							pstmt.setString(7,"");
							pstmt.setString(8,"");
							pstmt.setString(9,"N");
							pstmt.setString(10,stype);
							pstmt.setString(11,scode);
							pstmt.executeUpdate();


							pstmt.close();
							pstmt = null;
						}
						else
						{

							sql = "update rcpacct set amount  =? where tran_id = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setDouble(1, (rcpAmt+(Double)(DetMap.get("amount")==null?0.0:DetMap.get("amount"))));
							pstmt.setString(2, tranId);
							int updateCoount = pstmt.executeUpdate();


							pstmt.close();
							pstmt = null;
						}
					
					}*/

				}
			}
			System.out.println("DetList*****************984******************************"+DetList.toString());
			//adjust for advances adjusted

			for(i=0 ; i<ADetList.size() ; i++)
			{
				//ADetMap = new HashMap();
				ADetMap = (HashMap) ADetList.get(i);


				acct = (String)ADetMap.get("acct_code");
				cctr = (String)ADetMap.get("cctr_code");
				exch = (double) Double.parseDouble( "" + ADetMap.get("exch_rate__vouch"));
				amount = (double) Double.parseDouble( "" + ADetMap.get("adj_amt"));

				total  = total + amount;
				System.out.println("LINE NO 743"+total);
				if(rcpClubPost.equals("Y"))
				{
					findIndex = findExistingIndex(DetList, acct, cctr, exch);
					/*sql = "select count(*) from rcpacct where acct_code = ? and cctr_code = ? and exch_rate = ? and tran_id = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,acct);
					pstmt.setString(2,cctr==null?"":cctr);
					pstmt.setDouble(3,exch);
					pstmt.setString(4,tranId);//issue
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						cnt = rs.getInt(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					*/
				}
				else
				{
					findIndex = -1;
				}

				if (findIndex > -1) 
				{
					detMap = (HashMap) DetList.get(findIndex);
					amountMap = (double) Double.parseDouble( "" + detMap.get("amount"));
					detMap.put("amount", amountMap + amount );
					DetList.set(findIndex, detMap);
				}
				else
				{
					detMap = new HashMap();
					
					detMap.put("sundry_type", "C");
					detMap.put("sundry_code", (String) RcpHdrMap.get("cust_code"));
					detMap.put("acct_code", acct);
					detMap.put("cctr_code", cctr);
					detMap.put("emp_code", null);
					detMap.put("anal_code", null);
					//detMap.put("curr_code", rs.getString("curr_code"));
					detMap.put("exch_rate", exch);
					detMap.put("amount", amount);
					detMap.put("party_doc_ref", null);
					detMap.put("effect_party", "Y"); // 29/01/14 manoharan
					detMap.put("eff_bank", "Y"); // 03/02/14 Manoj
					DetList.add(detMap);
				}
					
				/*
				sql = "select max(LINE_NO) from rcpacct where  tran_id = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranId);//issue
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					maxline = rs.getInt(1);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				
				

				if(cnt == 0)
				{
					sql = "Insert into rcpacct (TRAN_ID,LINE_NO,ACCT_CODE,CCTR_CODE,EXCH_RATE,AMOUNT,EMP_CODE,ANAL_CODE,EFFECT_PARTY,SUNDRY_TYPE,SUNDRY_CODE) values (?,?,?,?,?,?,?,?,?,?,?)";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,tranId);//issue
					pstmt.setString(2,String.valueOf(maxline+1));
					pstmt.setString(3,acct);
					pstmt.setString(4,cctr==null?"":cctr);
					pstmt.setDouble(5,exch);
					pstmt.setDouble(6,amount);
					pstmt.setString(7,"");
					pstmt.setString(8,"");
					pstmt.setString(9,"Y");
					pstmt.setString(10,"C");
					pstmt.setString(11,(String)RcpHdrMap.get("cust_code"));
					pstmt.executeUpdate();


					pstmt.close();
					pstmt = null;
				}
				else
				{

					sql = "update rcpacct set amount  =? where tran_id = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setDouble(1, (amount+(Double)(DetMap.get("amount")==null?0.0:DetMap.get("amount"))));
					pstmt.setString(2, tranId);
					int updateCoount = pstmt.executeUpdate();


					pstmt.close();
					pstmt = null;
				}*/
			}
		//	System.out.println("DetList****************************1102*******************"+DetList.toString());

			// insert data for finchg			
			//take but det and insert 

			if(tFin != 0)
			{
				total = total + tFin;
				System.out.println("LINE NO 812"+total);


				acct = acctFin==null?"":acctFin;
				cctr = cctrFin;
				exch = (double) Double.parseDouble( "" + RcpHdrMap.get("exch_rate"));

				
				
				/*sql = "select max(LINE_NO) from rcpacct where  tran_id = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranId);//issue
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					maxline = rs.getInt(1);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				
				
				
				
				sql = "Insert into rcpacct (TRAN_ID,LINE_NO,ACCT_CODE,CCTR_CODE,EXCH_RATE,AMOUNT,EMP_CODE,ANAL_CODE,EFFECT_PARTY,SUNDRY_TYPE,SUNDRY_CODE) values (?,?,?,?,?,?,?,?,?,?,?)";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranId);//issue
				pstmt.setString(2,String.valueOf(maxline+1));////issue
				pstmt.setString(3,acct);
				pstmt.setString(4,cctr==null?"":cctr);
				pstmt.setDouble(5,exch);
				pstmt.setDouble(6,tFin);
				pstmt.setString(7,"");
				pstmt.setString(8,"");
				pstmt.setString(9,"N");
				pstmt.setString(10,"C");
				pstmt.setString(11,(String)RcpHdrMap.get("cust_code"));
				pstmt.executeUpdate();
				pstmt.close();
				pstmt = null;
				*/
				detMap = new HashMap();
				detMap.put("sundry_type", "O");
				detMap.put("sundry_code", null);
				detMap.put("acct_code", acct);
				detMap.put("cctr_code", cctr);
				detMap.put("emp_code", null);
				detMap.put("anal_code", null);
				detMap.put("exch_rate", exch);
				detMap.put("amount", tFin);
				detMap.put("party_doc_ref", null);
				detMap.put("effect_party", "N"); // 29/01/14 manoharan
				detMap.put("eff_bank", "Y"); // 03/02/14 Manoj
				DetList.add(detMap);
				

				/*sql = "Insert into rcpacct (TRAN_ID,LINE_NO,ACCT_CODE,CCTR_CODE,EXCH_RATE,AMOUNT,EMP_CODE,ANAL_CODE,EFFECT_PARTY,SUNDRY_TYPE,SUNDRY_CODE) values (?,?,?,?,?,?,?,?,?,?,?)";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranId);//issue
				pstmt.setString(2,String.valueOf(maxline+1));//issue
				pstmt.setString(3,acctFins);
				pstmt.setString(4,cctrFins==null?"":cctrFins);
				pstmt.setDouble(5,exch);
				pstmt.setDouble(6,tFin);
				pstmt.setString(7,"");
				pstmt.setString(8,"");
				pstmt.setString(9,"Y");
				pstmt.setString(10,"C");
				pstmt.setString(11,(String)RcpHdrMap.get("cust_code"));
				pstmt.executeUpdate();
				pstmt.close();
				pstmt = null;
				*/
				detMap = new HashMap();
				detMap.put("sundry_type", "C");
				detMap.put("sundry_code", (String)RcpHdrMap.get("cust_code"));
				detMap.put("acct_code", acctFins);
				detMap.put("cctr_code", cctrFins);
				detMap.put("emp_code", null);
				detMap.put("anal_code", null);
				detMap.put("exch_rate", exch);
				detMap.put("amount", tFin);
				detMap.put("party_doc_ref", null);
				detMap.put("effect_party", "Y"); // 29/01/14 manoharan
				detMap.put("eff_bank", "Y"); // 03/02/14 Manoj
				DetList.add(detMap);
				

				/*sql = "Insert into rcpacct (TRAN_ID,LINE_NO,ACCT_CODE,CCTR_CODE,EXCH_RATE,AMOUNT,EMP_CODE,ANAL_CODE,EFFECT_PARTY,SUNDRY_TYPE,SUNDRY_CODE) values (?,?,?,?,?,?,?,?,?,?,?)";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranId);//issue
				pstmt.setString(2,String.valueOf(maxline+1));//issue
				pstmt.setString(3,acct);
				pstmt.setString(4,cctr==null?"":cctr);
				pstmt.setDouble(5,exch);
				pstmt.setDouble(6,0-tFin);
				pstmt.setString(7,"");
				pstmt.setString(8,"");
				pstmt.setString(9,"Y");
				pstmt.setString(10,"C");
				pstmt.setString(11,(String)RcpHdrMap.get("cust_code"));
				pstmt.executeUpdate();
				pstmt.close();
				pstmt = null;
				*/
				detMap = new HashMap();
				detMap.put("sundry_type", "C");
				detMap.put("sundry_code", (String)RcpHdrMap.get("cust_code"));
				detMap.put("acct_code", acctFins);
				detMap.put("cctr_code", cctrFins);
				detMap.put("emp_code", null);
				detMap.put("anal_code", null);
				detMap.put("exch_rate", exch);
				detMap.put("amount", -1 * tFin);
				detMap.put("party_doc_ref", null);
				detMap.put("effect_party", "Y"); // 29/01/14 manoharan
				detMap.put("eff_bank", "Y"); // 03/02/14 Manoj
				DetList.add(detMap);
				

			}
		//	System.out.println("DetList**************************1231*********************"+DetList.toString());
			
			// insert data for advance
			advAmt = 	(double) Double.parseDouble( "" + RcpHdrMap.get("adv_amt"));
			System.out.println("ADVAMT*********"+advAmt);
			if(advAmt!= 0)
			{
				total = total + advAmt;
				System.out.println("LINE NO 874"+total);
				//System.out.println("total in adv"+total);
				acct = (String)RcpHdrMap.get("acct_code__adv")==null?"":(String)RcpHdrMap.get("acct_code__adv");
				cctr = (String)RcpHdrMap.get("cctr_code__adv")==null?"":(String)RcpHdrMap.get("cctr_code__adv");
				exch = (double) Double.parseDouble( "" + RcpHdrMap.get("exch_rate"));
				

				if(rcpClubPost.equals("Y"))
				{
					findIndex = findExistingIndex(DetList, acct, cctr, exch);
					System.out.println("FINDINDEX>>>>>>>1243>>>>>"+findIndex);
				}
				else
				{
					findIndex = -1;
				}

				if (findIndex > -1) 
				{
					detMap = (HashMap) DetList.get(findIndex);
					amountMap = (double) Double.parseDouble( "" + detMap.get("amount"));
					detMap.put("amount", amountMap + advAmt );
					DetList.set(findIndex, detMap);
				}
				else
				{
					System.out.println("Into Else part of findIndex > -1>>>>");
					detMap = new HashMap();
					sql="select sum(amount*exch_rate/?) from rcpacct where tran_id=? and eff_bank='N'";
					pstmt=conn.prepareStatement(sql);
					pstmt.setDouble(1, exch);
					pstmt.setString(2, tranId);
					rs=pstmt.executeQuery();
					if(rs.next())
					{
						amtNoBankEffect=rs.getDouble(1);
					}
					rs.close();
					rs=null;
					pstmt.close();
					pstmt=null;
					detMap.put("sundry_type", "C");
					detMap.put("sundry_code", (String) RcpHdrMap.get("cust_code"));
					detMap.put("acct_code", acct);
					detMap.put("cctr_code", cctr);
					detMap.put("emp_code", null);
					detMap.put("anal_code", null);
					//detMap.put("curr_code", rs.getString("curr_code"));
					detMap.put("exch_rate", exch);
					detMap.put("amount", (advAmt-amtNoBankEffect));//Changed by Manoj dtd 03/02/14
					detMap.put("party_doc_ref", null);
					detMap.put("effect_party", "Y"); // 29/01/14 manoharan
					
					detMap.put("eff_bank", "Y"); // 03/02/14 Manoj
					DetList.add(detMap);
				}
				System.out.println("1273---DetList.toString()----"+DetList.toString());

					/*sql = "select count(*) from rcpacct where acct_code = ? and cctr_code = ? and exch_rate = ? and tran_id = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,acct);
					pstmt.setString(2,cctr==null?"":cctr);
					pstmt.setDouble(3,exch);
					pstmt.setString(4,tranId);//issue
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						cnt = rs.getInt(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;


					sql = "select max(LINE_NO) from rcpacct where  tran_id = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,tranId);//issue
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						maxline = rs.getInt(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;




					if(cnt == 0)
					{
						sql = "Insert into rcpacct (TRAN_ID,LINE_NO,ACCT_CODE,CCTR_CODE,EXCH_RATE,AMOUNT,EMP_CODE,ANAL_CODE,EFFECT_PARTY,SUNDRY_TYPE,SUNDRY_CODE) values (?,?,?,?,?,?,?,?,?,?,?)";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,tranId);//issue
						pstmt.setString(2,String.valueOf(maxline+1));//issue
						pstmt.setString(3,acct);
						pstmt.setString(4,cctr==null?"":cctr);
						pstmt.setDouble(5,exch);
						pstmt.setDouble(6,advAmt);
						pstmt.setString(7,"");
						pstmt.setString(8,"");
						pstmt.setString(9,"Y");
						pstmt.setString(10,"C");
						pstmt.setString(11,((String)RcpHdrMap.get("cust_code")).trim());
						pstmt.executeUpdate();
						pstmt.close();
						pstmt = null;
					}
					else
					{
						sql = "update rcpacct set amount  =? where tran_id = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setDouble(1, ((Double)(RcpHdrMap.get("adv_amt")==null?0.0:RcpHdrMap.get("adv_amt"))+(Double)(DetMap.get("amount")==null?0.0:DetMap.get("amount"))));
						pstmt.setString(2, tranId);
						int updateCoount = pstmt.executeUpdate();
						pstmt.close();
						pstmt = null;
					}*/

			}

			// insert data for EPC ADJUSTED 
			///// insert rows for epc adjustment
			for(i=0 ; i<EpcAdjList.size() ; i++)
			{
				//EpcAdjMap = new HashMap();
				EpcAdjMap = (HashMap) DetList.get(i);

				currCode = (String)EpcAdjMap.get("curr_code");
				acctCode = (String)EpcAdjMap.get("acct_code");
				cctrCode = (String)EpcAdjMap.get("cctr_code")==null?"":(String)EpcAdjMap.get("cctr_code");
				exchRate = (double) Double.parseDouble( "" + EpcAdjMap.get("exch_rate"));
				amount = (double) Double.parseDouble( "" + EpcAdjMap.get("amount"));
				sundryType = (String)EpcAdjMap.get("sundry_type");
				sundryCode = (String)EpcAdjMap.get("sundry_code");

				hcurrCode = (String)RcpHdrMap.get("curr_code");
				//hexchRate = (Double)RcpHdrMap.get("exch_rate");
				totEpc = totEpc + amount;
				if(!currCode.equalsIgnoreCase(hcurrCode))
				{
					isEpcCurrSame = false;
					totEpcBc = totEpcBc + (exchRate * amount);
				}
				else
				{
					totEpcBc = totEpcBc + (hexchRate * amount);
				}


				if(rcpClubPost.equals("Y"))
				{
					findIndex = findExistingIndex(DetList, acctCode, cctrCode, exchRate);
				}
				else
				{
					findIndex = -1;
				}
				if (findIndex > -1) 
				{
					detMap = (HashMap) DetList.get(findIndex);
					amountMap = (double) Double.parseDouble( "" + detMap.get("amount")) ;
					detMap.put("amount", amountMap + amount );
					DetList.set(findIndex, detMap);
				}
				else
				{
					detMap = new HashMap();
					
					detMap.put("sundry_type", sundryType);
					detMap.put("sundry_code", sundryCode);
					detMap.put("acct_code", acctCode);
					detMap.put("cctr_code", cctrCode);
					detMap.put("emp_code", null);
					detMap.put("anal_code", null);
					//detMap.put("curr_code", rs.getString("curr_code"));
					detMap.put("exch_rate", exchRate);
					detMap.put("amount", amount);
					detMap.put("party_doc_ref", null);
					detMap.put("effect_party", "N"); // 29/01/14 manoharan
					detMap.put("eff_bank", "Y"); // 03/02/14 Manoj
					
					DetList.add(detMap);
				}
					/*sql = "select count(*) from rcpacct where acct_code = ? and cctr_code = ? and exch_rate = ? and tran_id = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,acctCode);
					pstmt.setString(2,cctrCode==null?"":cctrCode);
					pstmt.setDouble(3,exchRate);
					pstmt.setString(4,tranId);//issue
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						cnt = rs.getInt(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					
					sql = "select max(LINE_NO) from rcpacct where  tran_id = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,tranId);//issue
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						maxline = rs.getInt(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					
					
					if(cnt == 0)
					{

						sql = "Insert into rcpacct (TRAN_ID,LINE_NO,ACCT_CODE,CCTR_CODE,EXCH_RATE,AMOUNT,EMP_CODE,ANAL_CODE,EFFECT_PARTY,SUNDRY_TYPE,SUNDRY_CODE) values (?,?,?,?,?,?,?,?,?,?,?)";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,tranId);//issue
						pstmt.setString(2,String.valueOf(maxline+1));////issue
						pstmt.setString(3,acctCode);
						pstmt.setString(4,cctrCode==null?"":cctrCode);
						pstmt.setDouble(5,exchRate);
						pstmt.setDouble(6,advAmt);
						pstmt.setString(7,"");
						pstmt.setString(8,"");
						pstmt.setString(9,"Y");
						pstmt.setString(10,"C");
						pstmt.setString(11,(String)RcpHdrMap.get("cust_code"));
						pstmt.executeUpdate();
						pstmt.close();
						pstmt = null;
					}

					else
					{
						sql = "update rcpacct set amount  =? where tran_id = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setDouble(1, ((Double)EpcAdjMap.get("amount")+(Double)DetMap.get("amount")));
						pstmt.setString(2, tranId);
						int updateCoount = pstmt.executeUpdate();
						pstmt.close();
						pstmt = null;
					}
				//}*/
			}
			// insert rows for  ADVANCE BOOKING adjustment

			finEntity = (String)RcpHdrMap.get("fin_entity");
			sql = "select curr_code from finent  where fin_entity = ? " ;
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, finEntity);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				currCode = rs.getString("curr_code");
			}

			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;


			acct = (String)RcpHdrMap.get("acct_code__ar");
			cctr = (String)RcpHdrMap.get("cctr_code__ar");
			stype = "C";

			exchRate = 1;
			amount = diffAmtExch;
			sql = "SELECT diff_amt__exch FROM RCPADVBKING_ADJ where tran_id  = ? " ;
		
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				diffAmtExch = rs.getDouble("diff_amt__exch");
				if(rcpClubPost.equals("Y"))
				{
					findIndex = findExistingIndex(DetList, acct, cctr, exchRate);
				}
				else
				{
					findIndex = -1;
				}
				if (findIndex > -1) 
				{
					detMap = (HashMap) DetList.get(findIndex);
					amountMap = (double) Double.parseDouble( "" + detMap.get("amount"));
					detMap.put("amount", amountMap + diffAmtExch );
					DetList.set(findIndex, detMap);
				}
				else
				{
					detMap = new HashMap();
					
					detMap.put("sundry_type", stype);
					detMap.put("sundry_code", (String)RcpHdrMap.get("cust_code"));
					detMap.put("acct_code", acct);
					detMap.put("cctr_code", cctr);
					detMap.put("emp_code", null);
					detMap.put("anal_code", null);
					//detMap.put("curr_code", rs.getString("curr_code"));
					detMap.put("exch_rate", exchRate);
					detMap.put("amount", diffAmtExch);
					detMap.put("party_doc_ref", null);
					detMap.put("effect_party", "N"); // 29/01/14 manoharan
					detMap.put("eff_bank", "Y"); // 03/02/14 Manoj
					DetList.add(detMap);
				}
			}

			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;




			/*if(rcpClubPost.equals("Y"))
			{

				sql = "select count(*) from rcpacct where acct_code = ? and cctr_code = ? and exch_rate = ? and tran_id = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,acct);
				pstmt.setString(2,cctr==null?"":cctr);
				pstmt.setDouble(3,exch);
				pstmt.setString(4,tranId);//issue
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					cnt = rs.getInt(1);
				}

				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				if(cnt==0)
				{


					sql = "Insert into rcpacct (TRAN_ID,LINE_NO,ACCT_CODE,CCTR_CODE,EXCH_RATE,AMOUNT,EMP_CODE,ANAL_CODE,EFFECT_PARTY,SUNDRY_TYPE,SUNDRY_CODE) values (?,?,?,?,?,?,?,?,?,?,?)";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,tranId);//issue
					pstmt.setString(2,String.valueOf(cnt+1));////issue
					pstmt.setString(3,acct);
					pstmt.setString(4,cctr==null?"":cctr);
					pstmt.setDouble(5,exch);
					pstmt.setDouble(6,amount);
					pstmt.setString(7,"");
					pstmt.setString(8,"");
					pstmt.setString(9,"N");
					pstmt.setString(10,"C");
					pstmt.setString(11,(String)RcpHdrMap.get("cust_code"));
					cnt = pstmt.executeUpdate();
					pstmt.close();
					pstmt = null;
				}

				else
				{

					sql = "update rcpacct set amount  =? where tran_id = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setDouble(1, (diffAmtExch+diffAmtExch));
					pstmt.setString(3, tranId);
					int updateCoount = pstmt.executeUpdate();
					pstmt.close();
					pstmt = null;
				/ //OPEN
			}*/
			double totBad = 0;
			for(i=0 ; i<RcpDetList.size() ; i++)
			{
				//RcpDetMap = new HashMap();
				RcpDetMap = (HashMap) RcpDetList.get(i);

				refSer	= (String)RcpDetMap.get("ref_ser");
				refNo	= (String)RcpDetMap.get("ref_no");
				rcpAmt	= (double) Double.parseDouble( "" + RcpDetMap.get("rcp_amt"));
				badDebtAmt	=(double) Double.parseDouble( "" + RcpDetMap.get("bad_debt_amt"));
				lineNoRef	= (String)RcpDetMap.get("line_no__ref");

				sql = "select case when bad_debt_amt is null then 0 else bad_debt_amt end, exch_rate from receivables where tran_ser = ? and ref_no = ? and line_no__ref = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,refSer);
				pstmt.setString(2,refNo);
				pstmt.setString(3,lineNoRef);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					badDebtAmt = rs.getDouble(1);
					exchRate = rs.getDouble("exch_rate");

				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				System.out.println("badDebtAmt>>>>>>1642>>>>>>>"+badDebtAmt);
				if(badDebtAmt > 0)
				{
					sql = "select tran_id, acct_code__dr,cctr_code__dr, acct_code__cr, cctr_code__cr, amt_prov, case when amt_revrsed is null then 0 else amt_revrsed end from bad_debts_prov where tran_ser = ? and ref_no = ? and amt_prov <> 0 order by tran_date";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,refSer);
					pstmt.setString(2,refNo);
					pstmt.setString(3,lineNoRef);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						//badDebtAmt = rs.getDouble("baddebt_amt");
						tranId = rs.getString("tran_id");
						acctCodeDr = rs.getString("acct_code__dr");
						cctrCodeDr = rs.getString("cctr_code__dr")==null?"":rs.getString("cctr_code__dr");
						acctCodeCr = rs.getString("acct_code__cr");
						cctrCodeCr = rs.getString("cctr_code__cr")==null?"":rs.getString("cctr_code__cr");
						amtProv = rs.getDouble("amt_prov");
						amtRevrsed = rs.getDouble("amt_revrsed");

						amtRev = Math.min(badDebtAmt,amtProv);
						totBad = totBad + amtRev;
						System.out.println("LINE NO 1164"+total);

						if(rcpClubPost.equals("Y"))
						{
							findIndex = findExistingIndex(DetList, acctCodeDr, cctrCodeDr, exchRate);
						}
						else
						{
							findIndex = -1;
						}

						if (findIndex > -1) 
						{
							detMap = (HashMap) DetList.get(findIndex);
							amountMap = (double) Double.parseDouble( "" + detMap.get("amount"));
							detMap.put("amount", amountMap + (amtRev * -1) );
							DetList.set(findIndex, detMap);
							
						}
						else
						{
							detMap = new HashMap();
							
							detMap.put("sundry_type", "O");
							detMap.put("sundry_code", null);
							detMap.put("acct_code", acctCodeDr);
							detMap.put("cctr_code", cctrCodeDr);
							detMap.put("emp_code", null);
							detMap.put("anal_code", null);
							//detMap.put("curr_code", rs.getString("curr_code"));
							detMap.put("exch_rate", exchRate);
							detMap.put("amount", (amtRev * -1));
							detMap.put("party_doc_ref", null);
							detMap.put("effect_party", "N"); // 29/01/14 manoharan
							detMap.put("eff_bank", "Y"); // 03/02/14 Manoj
							DetList.add(detMap);
						}

						/*	sql = "select count(*) from rcpacct where acct_code = ? and cctr_code = ? and exch_rate = ? and tran_id = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,acctCodeDr);
							pstmt.setString(2,cctrCodeDr==null?"":cctrCodeDr);
							pstmt.setDouble(3,exch);
							pstmt.setString(4,tranId);//issue
							rs = pstmt.executeQuery();
							while(rs.next())
							{
								cnt = rs.getInt(1);
							}

							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;


							if(cnt==0)
							{

								sql = "Insert into rcpacct (TRAN_ID,LINE_NO,ACCT_CODE,CCTR_CODE,EXCH_RATE,AMOUNT,EMP_CODE,ANAL_CODE,EFFECT_PARTY) values (?,?,?,?,?,?,?,?,?)";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,tranId);//issue
								pstmt.setString(2,(String)RcpDetMap.get("line_no__ref"));////issue
								pstmt.setString(3,acctCodeDr);
								pstmt.setString(4,cctrCodeDr==null?"":cctrCodeDr);
								pstmt.setDouble(5,exchRate);
								pstmt.setDouble(6,amtRev);
								pstmt.setString(7,"");
								pstmt.setString(8,"");
								pstmt.setString(9,"N");
								cnt = pstmt.executeUpdate();

								pstmt.close();
								pstmt = null;

							}
							else
							{
								sql = "update rcpacct set amount  =? where tran_id = ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setDouble(1, ((badDebtAmt*-1)+(Double)DetMap.get(amount)));
								pstmt.setString(2, tranId);
								int updateCoount = pstmt.executeUpdate();

								pstmt.close();
								pstmt = null;
							}
							*/
							
						if(rcpClubPost.equals("Y"))
						{
							findIndex = findExistingIndex(DetList, acctCodeCr, cctrCodeCr, exchRate);
						}
						else
						{
							findIndex = -1;
						}
						if (findIndex > -1) 
						{
							
							detMap = (HashMap) DetList.get(findIndex);
							amountMap = (double) Double.parseDouble( "" + detMap.get("amount"));
							detMap.put("amount", amountMap + amtRev );
							DetList.set(findIndex, detMap);

						}
						else
						{
							detMap = new HashMap();
							
							detMap.put("sundry_type", "O");
							detMap.put("sundry_code", "");
							detMap.put("acct_code", acctCodeCr);
							detMap.put("cctr_code", cctrCodeCr);
							detMap.put("emp_code", "");
							detMap.put("anal_code", "");
							//detMap.put("curr_code", rs.getString("curr_code"));
							detMap.put("exch_rate", exchRate);
							detMap.put("amount", amtRev );
							detMap.put("party_doc_ref", "");
							detMap.put("effect_party", "N"); // 29/01/14 manoharan
							detMap.put("eff_bank", "Y"); // 03/02/14 Manoj
							DetList.add(detMap);

						}

								/*sql = "select count(*) from rcpacct where acct_code = ? and cctr_code = ? and exch_rate = ? and tran_id = ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,acctCodeCr);
								pstmt.setString(2,cctrCodeCr==null?"":cctrCodeCr);
								pstmt.setDouble(3,exch);
								pstmt.setString(4,tranId);//issue
								rs = pstmt.executeQuery();
								while(rs.next())
								{
									cnt = rs.getInt(1);
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;

								if(cnt==0)
								{

									// for debit account
									sql = "Insert into rcpacct (TRAN_ID,LINE_NO,ACCT_CODE,CCTR_CODE,EXCH_RATE,AMOUNT,EMP_CODE,ANAL_CODE,EFFECT_PARTY) values (?,?,?,?,?,?,?,?,?)";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1,tranId);//issue
									pstmt.setString(2,(String)RcpDetMap.get("line_no__ref"));////issue
									pstmt.setString(3,acctCodeCr);
									pstmt.setString(4,cctrCodeCr==null?"":cctrCodeCr);
									pstmt.setDouble(5,exchRate);
									pstmt.setDouble(6,amtRev);
									pstmt.setString(7,"");
									pstmt.setString(8,"");
									pstmt.setString(9,"N");
									cnt = pstmt.executeUpdate();
									pstmt.close();
									pstmt = null;
								}
							}
							else
							{

								sql = "update rcpacct set amount  =? where tran_id = ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setDouble(1, (badDebtAmt+(Double)DetMap.get(amount)));
								pstmt.setString(2, tranId);
								int updateCoount = pstmt.executeUpdate();
								pstmt.close();
								pstmt = null;
							}
							*/
						if(!isPreview){ //if is preview is false****added by vishakha 
						sql = "update bad_debts_prov set amt_prov = amt_prov - ?, amt_revrsed = amt_revrsed + ?  where tran_id = ?";
						pstmt1 = conn.prepareStatement(sql);
						pstmt1.setDouble(1,amtRev);
						pstmt1.setDouble(2,amtRev);
						pstmt1.setString(3,tranId);
						pstmt1.executeUpdate();
						pstmt1.close();
						pstmt1 = null;
						}
						badDebtAmt = badDebtAmt - amtRev;
						if (badDebtAmt == 0)
						{
							break;
						}
							
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
				}
if(!isPreview){
				sql = " update receivables set bad_debt_amt = bad_debt_amt - ? where  tran_ser = ? and ref_no = ?  and   line_no__ref = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setDouble(1, totBad);
				pstmt.setString(2,refser);
				pstmt.setString(3,refNo);
				pstmt.setString(4,lineNoRef);
				pstmt.executeUpdate();
				pstmt.close();
				pstmt = null;
				totBad = 0;
			}
						//System.out.println("aaaaaaaaaaaa"+total);
					//System.out.println("BBBBBBBBBBB"+total);
				
				//System.out.println("CCCCCCCCCCCC"+total);
			}

			exchRate = (double) Double.parseDouble( "" + RcpHdrMap.get("exch_rate"));
			// 14/01/14 manoharan no need to recalculate as it is taken care off in pose_save
			//total = total + ( (double) Double.parseDouble( "" + RcpHdrMap.get("tax_amt")));	//change done by akhilesh on 05/sep/2013 for adjust tax amount
			//totBc = total * exchRate;
			total = (double) Double.parseDouble( "" + RcpHdrMap.get("net_amt"));
			totBc = (double) Double.parseDouble( "" + RcpHdrMap.get("net_amt__bc"));
			System.out.println("Final total ["+ total + "] totBc [" + totBc + "]");
			//total = 0;

			
			/// the upper block is transfer here.
			
			//totBc = totBc + (Double)RcpHdrMap.get("net_amt__bc")+(Double)RcpHdrMap.get("tax_amt");	//change done by akhilesh on 05/sep/2013 for adjust tax amount

			//System.out.println("net_amt AND net_amt__bc 1"+total+""+totBc);


			if(bdFluctuationCf.equalsIgnoreCase("N"))
			{
				totBc = totBc + totbdDiff;
				System.out.println("bdFluctuationCf [" + bdFluctuationCf + "] totBc ["+totBc + "]");
			}

			// if EPC is adjusted in diff currency then update the net amount bc.

			if(isEpcCurrSame == true)
			{
				System.out.println("total ["+total+"] totEpc ["+totEpc+"] totEpcBc ["+totEpcBc + "]");
				total = total + totEpc;	
				totBc = totBc +totEpcBc;
			}
			else	
			{
				totBc = totBc + totEpcBc;	
			}

			/*
			//if EPC can be adjusted in base currency if it is so then check in base currency		
			sql = "SELECT count(*)  FROM  rcpepc_adj  WHERE rcpepc_adj.tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				rcpepcAdj = rs.getString(1);
			}

			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			*/
			chq = ((double) Double.parseDouble( "" + RcpHdrMap.get("chq_amt")) ) - ((double) Double.parseDouble( "" + RcpHdrMap.get("bill_disc_amt")));// + ((double) Double.parseDouble( "" + RcpHdrMap.get("oth_amt")) );

			// if EPC adjusted in same currency then
			if(isEpcCurrSame == true)
			{
				chq = chq + ((double) Double.parseDouble( "" + RcpHdrMap.get("efundadj_amt"))) ;	
			}
			System.out.println("chq and  ["+chq+"] total ["+total + "] diff [" + Math.abs(chq - total) +"]");
			if(Math.abs(chq - total) > 1)
			{
				errString = itmDBAccessEJB.getErrorString("","VTRCPT8","","",conn);
				conn.rollback();
				return errString;
			}

			RcpHdrMap.put("net_amt", total);
			RcpHdrMap.put("net_amt__bc", totBc);

			System.out.println("net_amt  ["+total+"] net_amt__bc ["+totBc + "]");
			
			// 14/01/14 manoharan details has to be inserted
			sql = "select max(line_no) from rcpacct where  tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);//issue
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				maxline = rs.getInt(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
            System.out.println("Max Line>>>"+maxline);
		if(!isPreview )
			{
			System.out.println(" >>>>>>>>>>>>>"+isPreview);
			sql = "Insert into rcpacct (TRAN_ID,LINE_NO,ACCT_CODE,CCTR_CODE,EXCH_RATE,AMOUNT,EMP_CODE,ANAL_CODE,EFFECT_PARTY,SUNDRY_TYPE,SUNDRY_CODE) values (?,?,?,?,?,?,?,?,?,?,?)";
			pstmt = conn.prepareStatement(sql);
			for(i = detListSize ; i<DetList.size() ; i++)
			{
				maxline++;
				detMap = (HashMap) DetList.get(i);

				sundryType = (String) detMap.get("sundry_type");
				sundryCode = (String) detMap.get("sundry_code");
				acctCode = (String) detMap.get("acct_code");
				cctrCode = (String) detMap.get("cctr_code");
				empCode = (String)	detMap.get("emp_code");
				analCode = (String)	detMap.get("anal_code");
				// 29/01/14 manoharan
				effectParty = (String)	detMap.get("effect_party");
				if (effectParty == null || "null".equals(effectParty))
				{
					effectParty = "N";
				}
				if (sundryType == null || "O".equals(sundryType))
				{
					effectParty = "N";
				}
				if (sundryType != null && !"null".equals(sundryType) && !"O".equals(sundryType) && sundryCode != null && !"null".equals(sundryCode) && sundryCode.trim().length() > 0 )
				{
					effectParty = "Y";
				}
					//detMap.put("curr_code", rs.getString("curr_code"));
				exchRate =	(double) Double.parseDouble( "" +detMap.get("exch_rate"));
				amount	=  (double) Double.parseDouble( "" +detMap.get("amount"));
				//	detMap.put("party_doc_ref", "");

						
				pstmt.setString(1,tranId);
				// 29/12/14 manoharan line_no is numeric not string
				//pstmt.setString(2,String.valueOf(maxline));
				pstmt.setInt(2,maxline);
				pstmt.setString(3,acctCode);
				pstmt.setString(4,cctrCode==null?"":cctrCode);
				pstmt.setDouble(5,exchRate);
				pstmt.setDouble(6,amount);
				pstmt.setString(7,empCode);
				pstmt.setString(8,analCode);
				pstmt.setString(9,effectParty); // "Y"); // 29/01/14 manoharan
				pstmt.setString(10,sundryType);
				pstmt.setString(11,sundryCode);
				pstmt.addBatch();
				pstmt.clearParameters();
			}
		
			if (DetList.size() > 0)
			{
				pstmt.executeBatch();
			}
			pstmt.close();
			pstmt = null;
			}
			// end 14/01/14 manoharan

			if(errString == null || errString.trim().length() == 0)
			{
				errString = gbfPostReceipt(tranId,xtraParams, RcpHdrMap, DetList,RcpDetList,ADetList,EpcAdjList,amtNoBankEffect, conn,isPreview);
			}
			else
			{
				//conn.rollback();
			}



			/*sql = "update receipt set net_amt = ?, net_amt__bc = ? where tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setDouble(1,total);
			pstmt.setDouble(2,totBc);
			pstmt.setString(3,tranId);//issue
			pstmt.executeUpdate();
			pstmt.close();
			pstmt = null;
			*/

		}
		catch(BatchUpdateException buex)
        {
			isError = true;
			retString = "ERROR";
			int [] updateCounts = buex.getUpdateCounts();
			for (int j = 0; j < updateCounts.length; i++)
			{
				System.err.println("  Statement " + i + ":" + updateCounts[i]);
			}
			System.err.println(" Message: " + buex.getMessage());
			System.err.println(" SQLSTATE: " + buex.getSQLState());
			System.err.println(" Error code: " + buex.getErrorCode());
			SQLException ex = buex.getNextException();
			while (ex != null)
			{ 
				System.err.println("SQL exception:");
				System.err.println(" Message: " + ex.getMessage());
				System.err.println(" SQLSTATE: " + ex.getSQLState());
				System.err.println(" Error code: " + ex.getErrorCode());
				ex = ex.getNextException();
			}
        }
		catch(Exception e)
		{
			System.out.println(e.getMessage());
			System.out.println("Exception : "+e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		return errString;
	}
	// 26/09/13 manoharan to find existing detail
	private int findExistingIndex(ArrayList detList, String acctCode, String cctrCode, double exchRate)throws RemoteException,ITMException
	{
		int findIndex  = -1;
		HashMap detMap = null;
		String acctCodeMap = null, cctrCodeMap = null;
		double exchRateMap = 0;
		try
		{
			for(int ctr=0 ; ctr < detList.size() ; ctr++)
			{
				detMap = (HashMap) detList.get(ctr);
				acctCodeMap = (String) detMap.get("acct_code");
				cctrCodeMap = (String) detMap.get("cctr_code");
				exchRateMap = (double) Double.parseDouble( "" + detMap.get("exch_rate"));
				if (acctCodeMap.trim().equalsIgnoreCase(acctCode.trim()) && cctrCodeMap.trim().equalsIgnoreCase(cctrCode.trim()) && exchRateMap == exchRate)
				{
					findIndex = ctr;
					break;
				}
				
			}
		}
		catch(Exception e)
		{
			System.out.println(e.getMessage());
			System.out.println("Exception : "+e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		return findIndex;
	}


	private String gbfPostReceipt(String tranId,String xtraParams,HashMap RcpHdrMap,ArrayList DDetList, ArrayList RcpDetList,ArrayList ADetList,ArrayList EpcAdjList,double amtNoBankEffect, Connection conn,boolean isPreview)throws RemoteException,ITMException
	{
		System.out.println("gbfPostReceipt Called..........");
		String errString = "";
		String ledgPostConf = "";
		String sql = "";
		String refNo = "";
		String commCalcOnOff = "";
		String confDrcrOpt = "";
		String confJvOpt   = "";
		HashMap DetMap = null;
		ArrayList DetList = new ArrayList();
		double netAmount = 0.0;
		double amount = 0.0;
		double debit = 0.0;
		double credit = 0.0;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ITMDBAccessEJB itmDBAccessEJB = null;
		FinCommon finCommon = null;
		DistCommon disCommon = null;
		try
		{
			itmDBAccessEJB = new ITMDBAccessEJB();
			finCommon = new FinCommon();


			// populate rcpacct

			//DetMap = new HashMap();
			/*sql = "select sundry_type,sundry_code,acct_code,cctr_code,emp_code, anal_code,curr_code ,exch_rate,amount,party_doc_ref from rcpacct where tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				DetMap = new HashMap();
				DetMap.put("sundry_type", rs.getString("sundry_type"));
				DetMap.put("sundry_code", rs.getString("sundry_code"));
				DetMap.put("acct_code", rs.getString("acct_code"));
				DetMap.put("cctr_code", rs.getString("cctr_code"));
				DetMap.put("emp_code", rs.getString("emp_code"));
				DetMap.put("anal_code", rs.getString("anal_code"));
				DetMap.put("curr_code", rs.getString("curr_code"));
				DetMap.put("exch_rate", rs.getDouble("exch_rate"));
				DetMap.put("amount", rs.getDouble("amount"));
				DetMap.put("party_doc_ref", rs.getString("party_doc_ref"));
				DetList.add(DetMap);
			}			

			System.out.println(" receipt Acct Map 1445..........");
			System.out.println(DetList.toString());



			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			*/

			// header posting
			errString = gbfPostRcphdr(tranId, xtraParams,RcpHdrMap, DDetList,amtNoBankEffect,conn,isPreview);
			System.out.println("ERROR......................"+errString);
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}
			else
			{
				errString=gbfPostRcpdet(tranId,xtraParams,RcpHdrMap,DDetList,RcpDetList,ADetList,EpcAdjList,conn,isPreview);//Changed by Manoj dtd 15/01/2014 to return errString from method
				System.out.println("errString while posting rcpdet......................"+errString);
			}
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}
if(! isPreview)//if isPreview is false
{
			sql = "SELECT ref_no , amount FROM  rcpepc_adj  WHERE rcpepc_adj.tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				refNo = rs.getString(1);
				amount = rs.getDouble(2);
				if(amount < 0 ){amount = -amount;}
				if(amount > 0)
				{
					sql = "update advbking set bal_amt = bal_amt - ? where tran_id  = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setDouble(1,amount);
					pstmt.setString(2,refNo);
					pstmt.executeUpdate();

					pstmt.close();
					pstmt = null;

				}
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			sql = "SELECT ref_no , amount FROM  rcpepc_adj  WHERE rcpepc_adj.tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				refNo = rs.getString(1);
				amount = rs.getDouble(2);
				if(amount < 0 )
				{
					amount = -amount;
				}
				if(amount > 0)
				{
					sql = "update advbking set bal_amt = bal_amt - ? where tran_id  = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setDouble(1,amount);
					pstmt.setString(2,refNo);
					pstmt.executeUpdate();

					pstmt.close();
					pstmt = null;

				}
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			if(errString == null || errString.trim().length() == 0)
			{
				/*if(Math.abs(debit - credit) >= 1)
				{
					errString = itmDBAccessEJB.getErrorString("","VTAMTMIS","","",conn);
					return errString;
				}*/
				errString = finCommon.checkGlTranDrCr("RCP",tranId,conn);

			}

			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}


			commCalcOnOff = finCommon.getFinparams("999999", "COMM_CALC_ON_OFF", conn);
			if(commCalcOnOff.equalsIgnoreCase("Y"))
			{


				//nvo_commission_calculation lnvo_commission
				///lnvo_commission = create nvo_commission_calculation

				confDrcrOpt = finCommon.getFinparams("999999", "COMM_DRCR_CONF", conn);
				confJvOpt = finCommon.getFinparams("999999", "COMM_JV_CONF", conn);


				//for Commission  Calculate

				CalculateCommission  calCommission = new CalculateCommission();
				errString = calCommission.CalCommission("","R", tranId, confDrcrOpt, confJvOpt,xtraParams, conn);	
				return errString;



			}
           }//end of isPreview condition**vishakha
		}
		catch(Exception e)
		{
			System.out.println(e.getMessage());
			System.out.println(e.getMessage());
			System.out.println("Exception : "+e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		return errString;

	}
	private String gbfPostRcphdr(String tranId,String xtraParams,HashMap RcpHdrMap,ArrayList RcpDetList,double amtNoBankEffect,Connection conn,boolean isPreview)throws RemoteException,ITMException
	{
		System.out.println("gbfPostRcphdr called........");
		String errString = "";
		String currCode = "";
		String siteCode = "";
		String siteCodeFor = "";
		String finEntity = "";
		String acctCode = "";
		String cctrCode = "";
		String acctCodePay = "";
		String cctrCodePay = "";
		String acctCodeAr = "";
		String cctrCodeAr = "";
		String projectCode = "";
		String analCode = "";
		String bankCode = "";
		String remarks = "";
		String sundryType = "";
		String sundryCode = "";
		String sundryTypeFor = "";
		String sundryCodeFor = "";
		String contactCode = "";
		String empCode = "";
		String refNO = "";
		String rcpMode = "";
		String batchNo = "";
		String tranType = "";
		String confirm = "";
		String loginEmpCode = "";
		String winName = "";
		String editOption = "";
		String confirmed = "";
		String sql = "";
		String errorType = "";
		String bdFluctuationCf = "";
		String acctCodeBal = "";
		String cctrCodeBal = "";
		String basecurrCode = "";
		String projCode = "";
		String custCode = "";
		String salesPers = "";
		String refSer = "";
		String refNo = "";
		String acctCodeCf = "";
		String payslip = "";
		boolean isInBaseCurr =false;
		int count = 0;
		int cnt1 = 0 ;
		int cnt = 0;
		double exchRate = 0.0;
		double netAmount = 0.0;
		double amount = 0.0;
		double advAmt = 0.0;
		double netAmt = 0.0;
		double chqAmt = 0.0;
		double debit  = 0.0;
		double credit = 0.0;
		double totAmt = 0.0;
		double ediOption = 0.0;
		double netAmountBc = 0.0;
		double taxAmt = 0.0;
		Date effDate = null;
		Date tranDate = null;
		Date refDate = null;
		HashMap detListMap = null;
		HashMap glTraceMap = null;
		HashMap sundryBalMap = null;
		HashMap bankTranLogMap = null;
		HashMap receivablesMap = null;
		HashMap epcadjMap = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		FinCommon finCommon = null;
		ValidatorEJB validatorEJB = new ValidatorEJB();
		GenericUtility genericUtility = new GenericUtility();
		ITMDBAccessEJB itmDBAccessEJB = null;
		
		try
		{
			finCommon =new  FinCommon();
			loginEmpCode = validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
			java.util.Date today=	new java.sql.Date(new java.util.Date().getTime());
			itmDBAccessEJB = new ITMDBAccessEJB();
			bdFluctuationCf = finCommon.getFinparams("999999", "BD_FLUCTUATION_CF", conn);
			if(bdFluctuationCf.equalsIgnoreCase("NULLFOUND"))
			{
				errString = itmDBAccessEJB.getErrorString("","VTFINPARM","","",conn);
			}

			System.out.println("net_amt AND net_amt__bc 1"+RcpHdrMap.get("net_amt")+""+RcpHdrMap.get("net_amt__bc"));
			tranId = (String)RcpHdrMap.get("tran_id");
			tranType = (String)RcpHdrMap.get("tran_type");
			if(tranType.equalsIgnoreCase("J"))
			{

				if((double) Double.parseDouble( "" + RcpHdrMap.get("adv_amt")) != 0 && (double) Double.parseDouble( "" + RcpHdrMap.get("chq_amt")) != 0)
				{
					errString = itmDBAccessEJB.getErrorString("","VTRCPJVAMT","","",conn);
				}
			}

			if((double) Double.parseDouble( "" + RcpHdrMap.get("bill_amt")) == 0 && (double) Double.parseDouble( "" + RcpHdrMap.get("adv_amt")) == 0 && (double) Double.parseDouble( "" + RcpHdrMap.get("net_amt")) != 0)
			{
				errString = itmDBAccessEJB.getErrorString("","VTRCPT11","","",conn);
				return errString;
			}

			tranId = (String)RcpHdrMap.get("tran_id");

			/// count for EPC. in diffrent currency.
			sql =" SELECT count(*) FROM rcpepc_adj,receipt  WHERE ( rcpepc_adj.tran_id = receipt.tran_id ) and   ( rcpepc_adj.curr_code <> receipt.curr_code ) and   ( ( receipt.tran_id = ? ) ) ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				cnt = rs.getInt(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			// 20/12/13 manoharan wrong validation commented
			//if(cnt1 == 0)
			//{
			//	errString = itmDBAccessEJB.getErrorString("","VTIBCA5","","",conn);
			//	//return errString;
			//}
			

			sql =" SELECT count(*) FROM rcpacct,receipt  WHERE ( rcpacct.tran_id = receipt.tran_id ) and  ( rcpacct.curr_code <> receipt.curr_code ) and  ( ( receipt.tran_id = ? ) )";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				cnt1 = rs.getInt(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			// 20/12/13 manoharan wrong validation commented
			//if(cnt1 == 0)
			//{
			//	errString = itmDBAccessEJB.getErrorString("","VTIBCA5","","",conn);
			//	//return errString;
			//}
			

			/// if EPC in diff currency.
			if((double) Double.parseDouble( "" + RcpHdrMap.get("efundadj_amt")) != 0 && cnt > 0)
			{
				isInBaseCurr = true;
			}
			// for other charges in diff currency.
			if((double) Double.parseDouble( "" + RcpHdrMap.get("oth_amt")) != 0 && cnt1 > 0)
			{
				isInBaseCurr = true;
			}

			if((double) Double.parseDouble( "" + RcpHdrMap.get("bill_disc_amt")) != 0 && bdFluctuationCf.equalsIgnoreCase("N"))
			{
				isInBaseCurr = true;
			}
			finEntity = (String)RcpHdrMap.get("fin_entity");
			sql = "SELECT finent.curr_code  FROM finent WHERE finent.fin_entity = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,finEntity);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				basecurrCode = rs.getString(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			analCode = (String)RcpHdrMap.get("anal_code");
			tranDate = (Date)RcpHdrMap.get("tran_date");
			refDate = (Date)RcpHdrMap.get("ref_date");
			effDate = (Date)RcpHdrMap.get("eff_date");
			remarks = (String)RcpHdrMap.get("remarks");
			finEntity = (String)RcpHdrMap.get("fin_entity");
			siteCode = (String)RcpHdrMap.get("site_code");
			bankCode = (String)RcpHdrMap.get("bank_code");
			acctCodeBal = (String)RcpHdrMap.get("acct_code__bal");
			cctrCodeBal = (String)RcpHdrMap.get("cctr_code__bal");
			netAmt = (double) Double.parseDouble( "" + RcpHdrMap.get("net_amt"));
			currCode = (String)RcpHdrMap.get("curr_code");
			exchRate = (double) Double.parseDouble( "" + RcpHdrMap.get("exch_rate"));
			projCode = (String)RcpHdrMap.get("proj_code");
			projCode = (String)RcpHdrMap.get("proj_code");
			refNO = (String)RcpHdrMap.get("ref_no");
			chqAmt = (double) Double.parseDouble( "" + RcpHdrMap.get("chq_amt"));
			custCode = (String)RcpHdrMap.get("cust_code");
			netAmountBc = (double) Double.parseDouble( "" + RcpHdrMap.get("net_amt__bc"));
			acctCodeCf = (String)RcpHdrMap.get("acct_code__cf");
			rcpMode = (String)RcpHdrMap.get("rcp_mode");
			//Added by Manoj dtd 09/12/2013 to set Accound code Adv and cctrCode Adv
			acctCode=(String)RcpHdrMap.get("acct_code__adv");
			cctrCode=(String)RcpHdrMap.get("cctr_code__adv");
			//added by akhilesh on 31/july/13 for tax provision

			sql =" select case when sum(tax_amt) is null then 0 else sum(tax_amt) end as taxAmt "
					+" from taxtran where tran_code= ? and "
					+" tran_id	= ? and tax_amt <> 0 and effect <> 'N' ";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,"RCP");
			pstmt.setString(2,tranId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{  
				taxAmt = taxAmt+ rs.getDouble("taxAmt");
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
			
			System.out.println("netAmountBc+taxAmt amount --------->"+netAmountBc);


			//ended by akhilesh on 31/july/13 for tax provision


			for (int ctr =0; ctr < RcpDetList.size(); ctr++)
			{
				detListMap = new HashMap();
				detListMap = (HashMap) RcpDetList.get(ctr);


				cctrCodeAr = (String)detListMap.get("cctr_code__ar");

			}
			// insert into gltrace for bank

			glTraceMap = new HashMap();
			glTraceMap.put("tran_date", new Timestamp(tranDate.getTime()));
			glTraceMap.put("eff_date",new Timestamp(effDate.getTime()));
			glTraceMap.put("fin_entity", finEntity);
			glTraceMap.put("site_code", siteCode);
			glTraceMap.put("sundry_type", "B");
			glTraceMap.put("sundry_code", bankCode);
			glTraceMap.put("acct_code", acctCodeBal);
			glTraceMap.put("cctr_code", cctrCodeBal);
			glTraceMap.put("emp_code", "");
			glTraceMap.put("anal_code", "");


			System.out.println("AMOUTTTTTTTTTTTTTTT"+(Double)RcpHdrMap.get("net_amt")+""+netAmountBc);
			if(isInBaseCurr == true)
			{
				//netAmountBc = netAmountBc+taxAmt;//added by akhilesh on 31/july/13 for tax provision
				System.out.println("IN TRUE!!!!!!!!!!!!!!!!!");
				glTraceMap.put("curr_code", basecurrCode);

				glTraceMap.put("exch_rate", 1.0);
				if((double) Double.parseDouble( "" + RcpHdrMap.get("net_amt__bc")) < 0 )
				{
					glTraceMap.put("dr_amt", 0.0);
					glTraceMap.put("cr_amt", -1 *  netAmountBc);
				}

				else{
					glTraceMap.put("dr_amt", netAmountBc);
					glTraceMap.put("cr_amt", 0.0);
				}
			}
			else 
			{
				//netAmt = netAmt+taxAmt;//added by akhilesh on 31/july/13 for tax provision

				System.out.println("IN FALSE!!!!!!!!!!!!!!!!!");
				glTraceMap.put("curr_code", currCode);

				glTraceMap.put("exch_rate", exchRate);
				if((double) Double.parseDouble( "" + RcpHdrMap.get("net_amt")) < 0 )
				{
					glTraceMap.put("dr_amt", 0.0);
					glTraceMap.put("cr_amt",  -1 * netAmt);
				}

				else{
					glTraceMap.put("dr_amt", netAmt);
					glTraceMap.put("cr_amt", 0.0);
				}
			}
			glTraceMap.put("ref_type","F");
			glTraceMap.put("ref_ser", "RCP");
			glTraceMap.put("ref_id", tranId);
			glTraceMap.put("remarks", remarks);
			glTraceMap.put("proj_code", projectCode);
			//ls_errcode = gbf_gltrace_upd(lstr_gltrace)
			System.out.println("1766 glTraceUpdate Called........isPreview value......"+isPreview);
			System.out.println("the vslue for CR AMT**********************"+glTraceMap.get("cr_amt"));
			errString = finCommon.glTraceUpdate(glTraceMap,conn,isPreview); 
			System.out.println("ERROR STRING>>>>>>>>>>>>>>>>>>>>>>"+errString);
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}
			 
			
			debit  = debit  + (double) Double.parseDouble( "" + glTraceMap.get("dr_amt")) * (double) Double.parseDouble( "" + glTraceMap.get("exch_rate"));
			credit = credit + (double) Double.parseDouble( "" + glTraceMap.get("cr_amt")) * (double) Double.parseDouble( "" + glTraceMap.get("exch_rate"));

			// update sundrybal for bank

			sundryBalMap = new HashMap();
			sundryBalMap.put("tran_date",new Timestamp(tranDate.getTime()));
			sundryBalMap.put("eff_date",new Timestamp(effDate.getTime()));
			sundryBalMap.put("fin_entity", finEntity);
			sundryBalMap.put("site_code", siteCode);
			sundryBalMap.put("sundry_type", "B");
			sundryBalMap.put("sundry_code", bankCode);
			sundryBalMap.put("acct_code", acctCodeBal);
			sundryBalMap.put("cctr_code", cctrCodeBal);
			if(isInBaseCurr == true)
			{
				sundryBalMap.put("curr_code", basecurrCode);

				sundryBalMap.put("exch_rate", 1.0);
				if((double) Double.parseDouble( "" + RcpHdrMap.get("net_amt__bc")) < 0 )
				{
					sundryBalMap.put("dr_amt", 0.0);
					sundryBalMap.put("cr_amt", -1 * netAmountBc );
				}

				else{
					sundryBalMap.put("dr_amt", netAmountBc);
					sundryBalMap.put("cr_amt", 0.0);
				}
			}
			else 
			{
				sundryBalMap.put("curr_code", currCode);

				sundryBalMap.put("exch_rate", exchRate);
				if((double) Double.parseDouble( "" + RcpHdrMap.get("net_amt")) < 0 )
				{
					sundryBalMap.put("dr_amt", 0.0);
					sundryBalMap.put("cr_amt", -1 * netAmt);
				}

				else{
					sundryBalMap.put("dr_amt", netAmt);
					sundryBalMap.put("cr_amt", 0.0);
				}
			}

			sundryBalMap.put("adv_amt", 0.0);
			sundryBalMap.put("contact_code", "");
			//Added by Sharon as instructed by Shiri madam on 29-July-2004
			if (chqAmt != 0 || advAmt > 0 )
			{
				System.out.println("In 1826 SUNDRY-BAL !!!!!!!!!!!!!!!!!!!!!!!!!!");
				if (! isPreview)//if isPreview is false *****vishakha
				{
				errString = finCommon.gbf_sundrybal_upd(sundryBalMap,conn);
				}
			}
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}

			//if chq amt is zero then should not be entered into banktran_log
			if (chqAmt != 0 && (! isPreview ))//if isPreview is false *** vishakha
			{
				// update banktran_log
				bankTranLogMap = new HashMap();
				bankTranLogMap.put("tran_date", new Timestamp(tranDate.getTime()));
				bankTranLogMap.put("tran_ser", "RCP");
				bankTranLogMap.put("tran_no", tranId);
				bankTranLogMap.put("bank_code", bankCode);
				bankTranLogMap.put("ref_no", refNO);
				bankTranLogMap.put("ref_date", new Timestamp(refDate.getTime()));
				bankTranLogMap.put("ref_mode", rcpMode);
				if(isInBaseCurr == true)
				{
					bankTranLogMap.put("curr_code", basecurrCode);
					bankTranLogMap.put("exch_rate", 1.0);
					if((double) Double.parseDouble( "" + RcpHdrMap.get("net_amt__bc")) < 0 )
					{
						bankTranLogMap.put("amount", -1 * (double) Double.parseDouble( "" + RcpHdrMap.get("net_amt__bc")));
						bankTranLogMap.put("tran_type", "P");
					}

					else{
						bankTranLogMap.put("amount",(double) Double.parseDouble( "" + RcpHdrMap.get("net_amt__bc")));
						bankTranLogMap.put("tran_type", "R");
					}
				}
				else 
				{
					bankTranLogMap.put("curr_code", currCode);

					bankTranLogMap.put("exch_rate", exchRate);
					if((double) Double.parseDouble( "" + RcpHdrMap.get("net_amt")) < 0 )
					{
						bankTranLogMap.put("amount", -1 * netAmt);
						bankTranLogMap.put("tran_type", "P");
					}

					else{
						bankTranLogMap.put("amount",netAmt);
						bankTranLogMap.put("tran_type", "R");
					}
				}
				bankTranLogMap.put("site_code", siteCode);
				bankTranLogMap.put("acct_code", acctCodeBal);
				bankTranLogMap.put("cctr_code",cctrCodeBal);
				bankTranLogMap.put("sundry_type", "C");
				bankTranLogMap.put("sundry_code", custCode);
				bankTranLogMap.put("remarks", remarks);
				bankTranLogMap.put("due_date", new Timestamp(tranDate.getTime()));
				//bankTranLogMap.put("exch_rate", exchRate);
				bankTranLogMap.put("entry_batch_no",(String)RcpHdrMap.get("entry_batch_no") );
				//ls_errcode = gbf_banktranlog_upd(lstr_banktranlog)
				System.out.println("545 bankTranLogUpdateeUpdate Called..............");
				errString = finCommon.bankTranLogUpdate(bankTranLogMap, xtraParams, conn);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}

			}

			// insert into gltrace for currency fluctuation
			if((double) Double.parseDouble( "" + RcpHdrMap.get("diff_amt__exch")) != 0)
			{
				glTraceMap = new HashMap();

				glTraceMap.put("tran_date", new Timestamp(tranDate.getTime()));
				glTraceMap.put("eff_date",new Timestamp(effDate.getTime()));
				glTraceMap.put("fin_entity", finEntity);
				glTraceMap.put("site_code", siteCode);
				glTraceMap.put("sundry_type", "O");
				glTraceMap.put("sundry_code", "");
				glTraceMap.put("acct_code", (String)RcpHdrMap.get("acct_code__cf"));
				if(acctCodeCf ==null || acctCodeCf.trim().length() == 0)
				{
					if(RcpDetList.size() >= 1)
					{
						glTraceMap.put("cctr_code", cctrCodeAr);
					}
				}
				else
				{
					glTraceMap.put("cctr_code", (String)RcpHdrMap.get("cctr_code__cf"));
				}
				glTraceMap.put("emp_code", "");
				glTraceMap.put("anal_code", "");
				glTraceMap.put("curr_code", basecurrCode);
				glTraceMap.put("exch_rate", 1.0);
				if((double) Double.parseDouble( "" + RcpHdrMap.get("diff_amt__exch")) > 0)
				{
					glTraceMap.put("dr_amt",(double) Double.parseDouble( "" + RcpHdrMap.get("diff_amt__exch")));
					glTraceMap.put("cr_amt", 0);
					cnt1=1;
				}else
				{
					glTraceMap.put("dr_amt", 0.0);
					glTraceMap.put("cr_amt", -1 * (double) Double.parseDouble( "" + RcpHdrMap.get("diff_amt__exch")));
					cnt1=2;
				}

				glTraceMap.put("ref_type","F");
				glTraceMap.put("ref_ser", "RCP");
				glTraceMap.put("ref_id", tranId);
				glTraceMap.put("remarks", remarks);
				glTraceMap.put("proj_code", projectCode);
				//ls_errcode = gbf_gltrace_upd(lstr_gltrace)
				System.out.println("1938 glTraceUpdate Called..............");
				errString = finCommon.glTraceUpdate(glTraceMap,conn,isPreview);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
          

			}
			debit  = debit  + ((double) Double.parseDouble( "" + glTraceMap.get("dr_amt")) * (double) Double.parseDouble( "" + glTraceMap.get("exch_rate")));
			credit = credit + ((double) Double.parseDouble( "" + glTraceMap.get("cr_amt")) * (double) Double.parseDouble( "" + glTraceMap.get("exch_rate")));



			// insert into receivables for advance amount

			if((double) Double.parseDouble( "" + RcpHdrMap.get("adv_amt")) > 0 && (! isPreview))//if isPreview is False **** vishakha
			{
				sql = "select sales_pers  from customer where cust_code  = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,custCode);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					salesPers = rs.getString(1);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				receivablesMap = new HashMap();
				receivablesMap.put("tran_ser", "R-ADV");
				receivablesMap.put("tran_date", new Timestamp(tranDate.getTime()));
				receivablesMap.put("fin_entity", finEntity);
				receivablesMap.put("site_code", siteCode);
				receivablesMap.put("ref_no", tranId);
				receivablesMap.put("sale_order", (String)RcpHdrMap.get("sale_order"));
				receivablesMap.put("ref_date", new Timestamp(tranDate.getTime()));
				receivablesMap.put("due_date", new Timestamp(tranDate.getTime()));
				receivablesMap.put("curr_code", currCode);
				receivablesMap.put("exch_rate", exchRate);
				receivablesMap.put("cust_code", custCode);
				receivablesMap.put("acct_code", acctCode);
				receivablesMap.put("cctr_code", cctrCode);
				receivablesMap.put("eff_date", new Timestamp(effDate.getTime()));
				receivablesMap.put("tax_amt", 0);
				receivablesMap.put("discount", 0);
				receivablesMap.put("tot_amt", -1 * ((double) Double.parseDouble( "" + RcpHdrMap.get("adv_amt"))-amtNoBankEffect));//Manoj dtd 04/02/2013 to reduce rcpacctamt of eff_bank='N'  from receivables
				receivablesMap.put("auto_rcp", "N");
				receivablesMap.put("bank_code",(String)RcpHdrMap.get("bank_code")==null?"":(String)RcpHdrMap.get("bank_code"));
				receivablesMap.put("ref_type", "F");
				receivablesMap.put("cr_term", null);
				receivablesMap.put("sales_pers", salesPers);
				receivablesMap.put("item_ser", (String)RcpHdrMap.get("item_ser")==null?"":(String)RcpHdrMap.get("item_ser"));
				receivablesMap.put("fin_scheme",(String)RcpHdrMap.get("fin_scheme"));
				//added extra column for gbfReceivablesUpd method 
				receivablesMap.put("sales_pers__1",null);
				receivablesMap.put("sales_pers__2",null);
				receivablesMap.put("line_no__ref",null);
				receivablesMap.put("mrp_value","0");
				receivablesMap.put("gp_no",null);
				receivablesMap.put("gp_date",null);
				receivablesMap.put("cust_ref_no",null);
				receivablesMap.put("cust_ref_date",null);
				receivablesMap.put("cust_ref_amt","");

				System.out.println("In 1997 receivablesMap [" + receivablesMap + "]");			
				errString = finCommon.gbfReceivablesUpd(receivablesMap,conn);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}

				// update sundrybal for adv amt > 0
				sundryBalMap = new HashMap();
				sundryBalMap.put("tran_date",new Timestamp(tranDate.getTime()));
				sundryBalMap.put("eff_date",new Timestamp(effDate.getTime()));
				sundryBalMap.put("fin_entity", finEntity);
				sundryBalMap.put("site_code", siteCode);
				sundryBalMap.put("sundry_type", "B");
				sundryBalMap.put("sundry_code", bankCode);
				sundryBalMap.put("acct_code", (String)RcpHdrMap.get("acct_code__adv"));
				sundryBalMap.put("cctr_code", (String)RcpHdrMap.get("cctr_code__adv"));
				sundryBalMap.put("curr_code", currCode);
				sundryBalMap.put("exch_rate", exchRate);
				sundryBalMap.put("dr_amt", 0.0);
				sundryBalMap.put("cr_amt", 0.0);
				sundryBalMap.put("adv_amt", ((double) Double.parseDouble( "" + RcpHdrMap.get("adv_amt"))));
				contactCode = finCommon.getContactCode(sundryType, sundryCode, conn);
				sundryBalMap.put("contact_code",contactCode );
				System.out.println("In 2021 sundryBalMap [" + sundryBalMap + "]");
				
				errString = finCommon.gbf_sundrybal_upd(sundryBalMap,conn);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}

				// Update pay-in-slip 

				payslip = (String)RcpHdrMap.get("entry_batch_no")==null?"":(String)RcpHdrMap.get("entry_batch_no");

				if(payslip.trim().length() > 0)
				{
					sql =" select count(1) from receipt_pay_in_slip where tran_id = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,tranId);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						cnt = rs.getInt(1);
					}
					//change done by kunal on 31/jan/14 close correct sql statement  
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					if(cnt <= 0)
					{
						sql = "insert into receipt_pay_in_slip ( tran_id, entry_batch_no ) values (?, ?)";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,tranId);
						pstmt.setString(2,payslip);
						rs = pstmt.executeQuery();

						pstmt.close();
						pstmt = null;
					}
				}

				/*rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;*/


				confirmed = (String)RcpHdrMap.get("confirmed");
				/*if(!confirmed.equalsIgnoreCase("Y"))
				{
					sql = "update receipt set confirmed = ?, conf_date = ?, emp_code__aprv = ? where tran_id = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,"Y");
					pstmt.setDate(2,new java.sql.Date(new java.util.Date().getTime()));
					pstmt.setString(3,loginEmpCode);
					pstmt.setString(4,tranId);
					pstmt.executeUpdate();

					pstmt.close();
					pstmt = null;

				}*/
				//lds_deta.retrieve(lstr_gltrace.ref_id)

				// Selecting from transetup
				sql = "select edi_option from transetup where tran_window = ?";	
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,"w_receipt_adv");	
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					ediOption = rs.getInt(1);
				}

				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				if(ediOption > 0)
				{
					RcpHdrMap.put("confirmed", "Y");
					RcpHdrMap.put("conf_date", today);
					RcpHdrMap.put("emp_code__aprv", loginEmpCode);
				}



				/*
				sql = "select edi_option from transetup where tran_window = ?";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,"w_misc_rcp_oth");
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					editOption = rs.getString("edi_option") == null ?" ":rs.getString("edi_option");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				if(editOption != null && editOption.trim().equalsIgnoreCase("0"))
				{

					String dataStr = "";
					if ( "1".equals(editOption.trim()) )
					{
						CreateRCPXML createRCPXML = new CreateRCPXML("w_misc_rcp","tran_id");
						dataStr = createRCPXML.getTranXML( tranId, conn );
						System.out.println( "dataStr =[ "+ dataStr + "]" );
						Document ediDataDom = genericUtility.parseString(dataStr);
						E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
						String retString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_misc_rcp", "0", xtraParams, conn );
						createRCPXML = null;
						e12CreateBatchLoad = null;
						if( retString != null && "SUCCESS".equals(retString) )
						{
							System.out.println("retString from batchload = 	["+retString+"]");
						}
					}

				}*/

			}
		}
		catch(Exception e)
		{
			System.out.println(e.getMessage());
			System.out.println(e.getMessage());
			System.out.println("Exception : "+e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		return errString;
	}

	private String gbfPostRcpdet(String tranId,String xtraParams,HashMap RcpHdrMap,ArrayList DetList, ArrayList RcpDetList ,ArrayList ADetList,ArrayList EpcAdjList,Connection conn,boolean isPreview)throws RemoteException,ITMException
	{
		System.out.println("gbfPostRcpdet called.............."+RcpDetList);
		String errString = "";
		String currCode = "";
		String siteCode = "";
		String siteCodeFor = "";
		String finEntity = "";
		String acctCode = "";
		String cctrCode = ""; 
		String recoAcctCode = "";
		String recoCctrCode = "";
		String taxAcctCode = "";
		String taxCctrCode = "";
		String acctCode1 = "";
		String cctrCode1 = "";
		String acctCodeAr = "";
		String cctrCodeAr = "";
		String projectCode = "";
		String analCode = "";
		String bankCode = "";
		String remarks = "";
		String sundryType = "";
		String contactCode = "";
		String sundryCode = "";
		String sundryTypeFor = "";
		String sundryCodeFor = "";
		String tranType = "";
		String empCode = "";
		String refNO = "";
		String rcpMode = "";
		String batchNo = "";
		String confirm = "";
		String loginEmpCode = "";
		String winName = "";
		String editOption = "";
		String sql = "";
		String hcurrCode = "";
		String errorType = "";
		String payslip = "";
		String partyDocRef = "";
		String refSer = "";
		String refNo = "";
		String salesPers = "";
		String status = "";
		String lineNoPef = "";
		int count = 0;
		int lineNo = 0;
		double exchRate = 0.0;
		double hexchRate = 0.0;
		double netAmount = 0.0;
		double amount = 0.0;
		double taxAmount = 0.0;
		double recoAmount = 0.0;
		double debit  = 0.0;
		double credit = 0.0;
		double totAmt = 0.0;
		double advAmt = 0.0;
		double adjAmt = 0.0;
		double advAdj = 0.0;
		double recoverAmt = 0.0;
		Date effDate = null;
		Date tranDate = null;
		Date refDate = null;
		HashMap DetMap = null;
		HashMap RcpDetMap = null;
		HashMap ADetMap = null;
		HashMap EpcAdjMap = null;
		HashMap glTraceMap = null;
		HashMap sundryBalMap = null;
		HashMap bankTranLogMap = null;
		HashMap detListMap = null;
		HashMap recofiltMap = null;
		HashMap recodataMap = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		FinCommon finCommon = null;
		DistCommon distCommon = null;
		ITMDBAccessEJB itmDBAccessEJB = null;
		ValidatorEJB validatorEJB = new ValidatorEJB();
		GenericUtility genericUtility = new GenericUtility();
		double nobankEffectAmt=0;
		double exchRateHdr=0;
		try
		{
			finCommon = new  FinCommon();
			distCommon = new DistCommon();
			itmDBAccessEJB = new ITMDBAccessEJB();
			loginEmpCode = validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "loginCode");

			tranDate = (Date)RcpHdrMap.get("tran_date");
			effDate = (Date)RcpHdrMap.get("eff_date");
			finEntity = (String)RcpHdrMap.get("fin_entity");
			siteCode = (String)RcpHdrMap.get("site_code");
			siteCodeFor = (String)RcpHdrMap.get("site_code__for");
			projectCode = (String)RcpHdrMap.get("proj_code");
			hcurrCode = (String)RcpHdrMap.get("curr_code");
			hexchRate = (double) Double.parseDouble( "" + RcpHdrMap.get("exch_rate"));
			remarks = (String)RcpHdrMap.get("remarks");

			System.out.println("DetList SIZE ["+DetList.size() + "] DetList [" +DetList + "]");
			
			
			for (int ctr =0; ctr < DetList.size(); ctr++)
			{

				//System.out.println("no of times "+ctr);
				//DetMap = new HashMap();
				DetMap = (HashMap) DetList.get(ctr);

				System.out.println(" DetMap ctr [" + ctr + "] ["+DetMap + "]");

				/* sundryType = (String)detListMap.get("sundry_type");
				sundryCode = (String)detListMap.get("sundry_code");					
				acctCode = (String)detListMap.get("acct_code");
				cctrCode = (String)detListMap.get("cctr_code");
				analCode = (String)detListMap.get("anal_code");
				empCode = (String)detListMap.get("emp_code");
				//projectCode = (String)detListMap.get("proj_code");
				currCode = (String)detListMap.get("curr_code");
				exchRate = (Double)detListMap.get("exch_rate");
				partyDocRef = (String)detListMap.get("party_doc_ref");*/
				/*String sType=(String)DetMap.get("sundry_type")==null?"O":(String)DetMap.get("sundry_type");
				if(sType != null && !("O".equalsIgnoreCase(sType)))
				{
					amount=amount-nobankEffectAmt;
				}*/
				sundryType = (String)DetMap.get("sundry_type")==null?"O":(String)DetMap.get("sundry_type");
				sundryCode = (String)DetMap.get("sundry_code")== null?"":(String)DetMap.get("sundry_code");
				glTraceMap = new HashMap();
				glTraceMap.put("tran_date",new Timestamp(tranDate.getTime()));
				glTraceMap.put("eff_date",new Timestamp(effDate.getTime()));
				glTraceMap.put("fin_entity", finEntity);
				glTraceMap.put("site_code", siteCode);
				glTraceMap.put("sundry_type",(String)DetMap.get("sundry_type")==null?"O":(String)DetMap.get("sundry_type"));
				glTraceMap.put("sundry_code",(String)DetMap.get("sundry_code")== null?"":(String)DetMap.get("sundry_code"));
				glTraceMap.put("acct_code", (String)DetMap.get("acct_code"));
				System.out.println("818 account chek ="+acctCode+"  "+sundryType+"   "+sundryCode);
				glTraceMap.put("cctr_code", (String)DetMap.get("cctr_code")==null?"":(String)DetMap.get("cctr_code"));
				glTraceMap.put("emp_code", (String)DetMap.get("emp_code"));
				glTraceMap.put("anal_code", (String)DetMap.get("anal_code"));
				glTraceMap.put("curr_code", (String)DetMap.get("curr_code")==null?hcurrCode:(String)DetMap.get("curr_code"));
				glTraceMap.put("proj_code", projectCode);
				glTraceMap.put("exch_rate", (double) Double.parseDouble( "" + DetMap.get("exch_rate")));

				amount = (double) Double.parseDouble( "" + DetMap.get("amount"));
				if(amount > 0)
				{
					glTraceMap.put("dr_amt",0.0);
					glTraceMap.put("cr_amt",amount);
				}
				else
				{
					glTraceMap.put("dr_amt", -1 *  amount);
					glTraceMap.put("cr_amt",0.0);
				}
				glTraceMap.put("ref_type","F");
				glTraceMap.put("ref_ser", "RCP");
				glTraceMap.put("ref_id", tranId);
				glTraceMap.put("remarks",remarks);
				glTraceMap.put("party_doc_ref",partyDocRef);
				System.out.println("848 glTraceUpdate Called..ctr [" + ctr + "] glTraceMap [" + glTraceMap + "]");
				errString = finCommon.glTraceUpdate(glTraceMap,conn,isPreview);
				if(errString != null && errString.trim().length() > 0)
				{
					System.out.println("ERROR IN GLTRACE ........... errString [" + errString + "]");

					return errString;
				}

				
				debit  = debit  + ((double) Double.parseDouble( "" + glTraceMap.get("dr_amt")) * (double) Double.parseDouble( "" + glTraceMap.get("exch_rate")));
				credit = credit + ((double) Double.parseDouble( "" + glTraceMap.get("cr_amt")) * (double) Double.parseDouble( "" + glTraceMap.get("exch_rate")));

				/// update sundrybal for customer code
				if((String)glTraceMap.get("sundry_type") != null && !((String)glTraceMap.get("sundry_type")).trim().equalsIgnoreCase("O") && (! isPreview))//if is Preview is false **vishakha
				{
					System.out.println("COMES INTO CONDITION ...........");


					sundryBalMap = new HashMap();
					sundryBalMap.put("tran_date",new Timestamp(tranDate.getTime()));
					sundryBalMap.put("eff_date",new Timestamp(effDate.getTime()));
					sundryBalMap.put("fin_entity", finEntity);
					sundryBalMap.put("site_code", siteCode);
					sundryBalMap.put("sundry_type", (String)glTraceMap.get("sundry_type"));
					sundryBalMap.put("sundry_code", sundryCode);
					sundryBalMap.put("acct_code", (String)DetMap.get("acct_code"));
					sundryBalMap.put("cctr_code", (String)DetMap.get("cctr_code")==null?"":(String)DetMap.get("cctr_code"));
					sundryBalMap.put("curr_code", (String)DetMap.get("curr_code")==null?hcurrCode:(String)DetMap.get("curr_code"));
					sundryBalMap.put("exch_rate", (double) Double.parseDouble( "" + DetMap.get("exch_rate")));

					amount = (double) Double.parseDouble( "" + DetMap.get("amount"));
					if(amount > 0)
					{
						sundryBalMap.put("dr_amt", 0.0);
						sundryBalMap.put("cr_amt", amount);
					}
					else
					{
						sundryBalMap.put("dr_amt", -1 *  amount);
						sundryBalMap.put("cr_amt", 0.0);
					}
					sundryBalMap.put("adv_amt", 0.0);
					contactCode = finCommon.getContactCode(sundryType, sundryCode, conn);
					sundryBalMap.put("contact_code",contactCode );
					System.out.println("2366 sundryBaleUpdate Called..............");
					errString = finCommon.gbf_sundrybal_upd(sundryBalMap, conn);
					if(errString != null && errString.trim().length() > 0)
					{
						System.out.println("error is sundryBaleUpdate ..........."+errString);

						return errString;
					}
				}


				System.out.println("last ...........");
			}
          if(! isPreview) // if isPreview is false ****vishakha
           {
			for (int ctr =0; ctr < RcpDetList.size(); ctr++)
			{
				RcpDetMap = new HashMap();
				RcpDetMap = (HashMap) RcpDetList.get(ctr);


				refSer = (String)RcpDetMap.get("ref_ser");
				refNo = (String)RcpDetMap.get("ref_no");
				amount = (double) Double.parseDouble( "" + RcpDetMap.get("rcp_amt"));
				lineNoPef = (String)RcpDetMap.get("line_no__ref");


				itmDBAccessEJB = new ITMDBAccessEJB();

				if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
				{
					sql = "SELECT tot_amt, adj_amt, recover_amt, sales_pers FROM receivables  WHERE tran_ser = ?  and ref_no = ? and line_no__ref  = ? for update ";
				}

				else if ( "mssql".equalsIgnoreCase(CommonConstants.DB_NAME ))
				{
					sql = "SELECT tot_amt, adj_amt, recover_amt, sales_pers FROM receivables (updlock) where tran_ser = ?  and ref_no = ? and line_no__ref  = ? " ;
				}
				else
				{
					sql =" SELECT tot_amt, adj_amt, recover_amt, sales_pers FROM receivables WHERE tran_ser = ?  and ref_no = ? and line_no__ref  = ? for update nowait" ;
				}
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,refSer);
				pstmt.setString(2,refNo);
				pstmt.setString(3,lineNoPef);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					totAmt = rs.getDouble("tot_amt");
					adjAmt = rs.getDouble("adj_amt");
					recoverAmt = rs.getDouble("recover_amt");
					salesPers = rs.getString("sales_pers");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				System.out.println("05/04/14 manoharan totAmt [" + totAmt + "] adjAmt [ " + adjAmt + "] amount [" + amount + "] Math.abs(totAmt - adjAmt) [" + Math.abs(totAmt - adjAmt) + "] Math.abs(amount) [" + Math.abs(amount) + "]");
				if(getReqDecimal(Math.abs(totAmt - adjAmt),2) < getReqDecimal(Math.abs(amount),2))
				{
					errString = itmDBAccessEJB.getErrorString("","VTBAL1","","",conn);
					return errString;
				}


				adjAmt = adjAmt + amount;
				if(totAmt == adjAmt)
				{
					status = "A";
				}
				else
				{
					status = "P";
				}


				sql = "update receivables set adj_amt = ?, status = ?,stat_date = ? where tran_ser = ? and ref_no = ? and line_no__ref = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setDouble(1,adjAmt);
				pstmt.setString(2,status);
				pstmt.setDate(3,new java.sql.Date(new java.util.Date().getTime()));
				pstmt.setString(4,refSer);
				pstmt.setString(5,refNo);
				pstmt.setString(6,lineNoPef);
				pstmt.executeUpdate();

				pstmt.close();
				pstmt = null;

				/*if(recoverAmt > 0)
				{
					/// filter data	
					recofiltMap.put("crnote_date", new Timestamp(tranDate.getTime()));//issue
					recofiltMap.put("site_code",siteCode);
				}

				/// actual data for generating debit/credit note.

				if(recoverAmt <= amount)
				{
					recodataMap.put("os_reco_amt", recoverAmt);//issue
				}
				else
				{
					recodataMap.put("os_reco_amt", amount);
				}

				recodataMap.put("tran_ser", refSer);
				recodataMap.put("ref_no", refNo);
				recodataMap.put("sales_pers", salesPers);
				recodataMap.put("curr_code", currCode);
				recodataMap.put("exch_rate", exchRate);
				recodataMap.put("site_code", siteCode);
				recodataMap.put("fin_entity", finEntity);

				recodataMap.put("tot_amt", totAmt);
				recodataMap.put("adj_amt", adjAmt);*/ //open

				/*ls_errcode = nvo_drcr_rcp.gbf_misc_credit_note_os_reco_dealer(lds_recofilt, lds_recodata, 'C', 'RCP', ls_tranid) */ //issue



			}


			// do the advance adjustmentopen

			for (int ctr =0; ctr < ADetList.size(); ctr++)
			{
				ADetMap = new HashMap();
				ADetMap = (HashMap) ADetList.get(ctr);


				refSer = (String)ADetMap.get("ref_ser");
				refNo = (String)ADetMap.get("ref_no");
				advAdj = (double) Double.parseDouble( "" + ADetMap.get("adj_amt"));


				sql ="select tot_amt, adj_amt from receivables where tran_ser = ? and ref_no = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,refSer);
				pstmt.setString(2,refNo);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					amount = rs.getDouble("tot_amt");
					adjAmt = rs.getDouble("adj_amt");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				System.out.println("05/04/14 manoharan 2 adjAmt [ " + adjAmt + "] amount [" + amount + "] Math.abs(amount - adjAmt) [" + Math.abs(amount - adjAmt) + "] Math.abs(adjAmt) [" + Math.abs(adjAmt) + "]");

				if(getReqDecimal(Math.abs(amount - adjAmt),2) < getReqDecimal(Math.abs(adjAmt),2))
				{
					errString = itmDBAccessEJB.getErrorString("","VTBAL1","","",conn);
				}


				if (Math.abs(amount) == Math.abs(adjAmt + advAdj))
				{
					status = "A";
				}
				else
				{
					status = "P";
				}
				adjAmt = adjAmt + advAdj;
				sql = "update receivables set adj_amt = adj_amt + ?,status = ?, stat_date = ? where tran_ser = ? and ref_no = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setDouble(1,advAdj);
				pstmt.setString(2,status);
				pstmt.setDate(3,new java.sql.Date(new java.util.Date().getTime()));
				pstmt.setString(4,refSer);
				pstmt.setString(5,refNo);
				pstmt.executeUpdate();

				pstmt.close();
				pstmt = null;
				// adjusted in sunbdrybal

				sundryBalMap = new HashMap();
				sundryBalMap.put("tran_date",new Timestamp(tranDate.getTime()));
				sundryBalMap.put("eff_date",new Timestamp(effDate.getTime()));
				sundryBalMap.put("fin_entity", finEntity);
				sundryBalMap.put("site_code", siteCode);
				sundryBalMap.put("sundry_type", "C");
				sundryBalMap.put("sundry_code", (String)RcpHdrMap.get("cust_code"));
				sundryBalMap.put("acct_code", (String)ADetMap.get("acct_code"));
				sundryBalMap.put("cctr_code", (String)ADetMap.get("cctr_code"));
				sundryBalMap.put("curr_code", hcurrCode);
				sundryBalMap.put("exch_rate", (double) Double.parseDouble( "" + ADetMap.get("exch_rate__vouch")));
				sundryBalMap.put("dr_amt", 0.0);
				sundryBalMap.put("cr_amt", 0.0);
				sundryBalMap.put("adv_amt", (double) Double.parseDouble( "" + ADetMap.get("adj_amt")));
				contactCode = finCommon.getContactCode((String)sundryBalMap.get("sundry_type"),(String) sundryBalMap.get("sundry_code"), conn);
				sundryBalMap.put("contact_code",contactCode );
				System.out.println("884 sundryBaleUpdate Called..............");
				errString = finCommon.gbf_sundrybal_upd(sundryBalMap, conn);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}

			}

			for (int ctr =0; ctr < EpcAdjList.size(); ctr++)
			{
				EpcAdjMap = new HashMap();
				EpcAdjMap = (HashMap) EpcAdjList.get(ctr);


				refSer = (String)EpcAdjMap.get("ref_ser");
				refNo = (String)EpcAdjMap.get("ref_no");
				amount = (double) Double.parseDouble( "" + EpcAdjMap.get("amount"));


				itmDBAccessEJB = new ITMDBAccessEJB();

				if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
				{
					sql = "SELECT  tot_amt, adj_amt FROM receivables  WHERE tran_ser = ?  and ref_no = ?  for update ";
				}

				else if ( "mssql".equalsIgnoreCase(CommonConstants.DB_NAME ))
				{
					sql = "SELECT  tot_amt, adj_amt FROM receivables (updlock) where tran_ser = ? and  ref_no = ?  " ;
				}
				else
				{
					sql =" SELECT  tot_amt, adj_amt FROM receivables WHERE tran_ser = ?  and ref_no = ?  for update nowait" ;
				}
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,"E-FUND");
				pstmt.setString(2,refNo);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					totAmt = rs.getDouble("tot_amt");
					adjAmt = rs.getDouble("adj_amt");

				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				System.out.println("05/04/14 manoharan 3 adjAmt [ " + adjAmt + "] amount [" + amount + "] Math.abs(amount - adjAmt) [" + Math.abs(amount - adjAmt) + "] Math.abs(amount) [" + Math.abs(amount) + "]");
				if(getReqDecimal(Math.abs(amount - adjAmt),2) < getReqDecimal(Math.abs(amount),2))
				{
					errString = itmDBAccessEJB.getErrorString("","VTBAL1","","",conn);
					return errString;
				}


				adjAmt = adjAmt + totAmt;
				if(totAmt == adjAmt)
				{
					status = "A";
				}
				else
				{
					status = "P";
				}


				sql = "update misc_payables set adj_amt = ?  where tran_ser = 'E-FUND' and ref_no = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setDouble(1,adjAmt);
				pstmt.setString(2,"E-FUND");
				pstmt.setString(3,refNo);
				pstmt.executeUpdate();

				pstmt.close();
				pstmt = null;
			}
			//added by akhilesh on 31/july/13 for tax provision
			errString = taxPost(tranId,xtraParams,RcpHdrMap, conn);
			if(errString != null && errString.trim().length() > 0)
			{
				System.out.println("error is taxPost ..........."+errString);
				return errString;
			}
			
		}
		}
		catch(Exception e)
		{
			System.out.println(e.getMessage());
			System.out.println(e.getMessage());
			System.out.println("Exception : "+e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		return errString;
	}
	
	//added by akhilesh on 31/july/13 for tax provision	
	private String taxPost(String tranId,String xtraParams,HashMap RcpHdrMap,Connection conn)throws RemoteException,ITMException
	{
		System.out.println("taxPost called.............."+RcpHdrMap);

		
		String errString = "";
		String acctCode = "";
		String cctrCode = ""; 
		String projectCode = "";
		String analCode = "";
		String empCode = "";
		String loginEmpCode = "";
		String drcrFlag = "";
		String anal1 = "";
		String anal2 = "";
		String anal3 = "";
		double amount = 0.0;
		Date effDate = null;
		Date tranDate = null;
		
		HashMap glTraceMap = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		FinCommon finCommon = null;
		DistCommon distCommon = null;
		ITMDBAccessEJB itmDBAccessEJB = null;
		ValidatorEJB validatorEJB = new ValidatorEJB();
		GenericUtility genericUtility = new GenericUtility();
        boolean isPreview = false;
		try
		{
			finCommon = new  FinCommon();
			distCommon = new DistCommon();
			itmDBAccessEJB = new ITMDBAccessEJB();
			loginEmpCode = validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			
			
			tranDate = (Date)RcpHdrMap.get("tran_date");
			effDate = (Date)RcpHdrMap.get("eff_date");
			
			//drcrFlag = (String)RcpHdrMap.get("drcr_flag");
			//acctCode=(String) RcpHdrMap.get("acct_code__ar");
			//cctrCode=(String) RcpHdrMap.get("cctr_code__ar");
			
			pstmt=conn.prepareStatement("select * from taxtran where tran_id=? and tran_code='RCP' and tax_amt<>0");
			pstmt.setString(1,tranId);
			rs=pstmt.executeQuery();
			while(rs.next())
			{
				glTraceMap = new HashMap();
				
				acctCode = rs.getString("acct_code");
				cctrCode = rs.getString("cctr_code");
				
				System.out.println("cctrCode:" +cctrCode + ":");

				amount = rs.getDouble("tax_amt");

				
				glTraceMap.put("tran_date",new Timestamp(tranDate.getTime()));
				glTraceMap.put("eff_date",new Timestamp(effDate.getTime()));
				glTraceMap.put("fin_entity",(RcpHdrMap.get("fin_entity")));
				glTraceMap.put("site_code",(RcpHdrMap.get("site_code")));
				glTraceMap.put("sundry_type","O"); 
				glTraceMap.put("sundry_code","");
				glTraceMap.put("acct_code",acctCode);
				glTraceMap.put("cctr_code",cctrCode==null?"":cctrCode);
				glTraceMap.put("emp_code",empCode);
				glTraceMap.put("anal_code",analCode);
				glTraceMap.put("curr_code",(RcpHdrMap.get("curr_code")));
				glTraceMap.put("exch_rate",(RcpHdrMap.get("exch_rate")));
				/*if("D".equalsIgnoreCase(drcrFlag))
				{*/
					if(amount > 0)
					{
						glTraceMap.put("dr_amt",0);
						glTraceMap.put("cr_amt", Math.abs(amount));
					}
					else
					{
						glTraceMap.put("dr_amt", Math.abs(amount));
						glTraceMap.put("cr_amt",0);
					}
			//	}
				
				glTraceMap.put("ref_type","F");
				glTraceMap.put("ref_id",tranId);
				glTraceMap.put("ref_ser","RCP");
				glTraceMap.put("remarks",(RcpHdrMap.get("remarks")));
				glTraceMap.put("analysis1",anal1);
				glTraceMap.put("analysis2",anal2);
				glTraceMap.put("analysis3",anal3);
				
				System.out.println("glTraceUpdate before update  "+glTraceMap);
				
				errString = finCommon.glTraceUpdate(glTraceMap,conn,isPreview);
				System.out.println("glTraceUpdate errString "+errString);
				
				if(errString != null && errString.trim().length() > 0)
				{
					System.out.println("error is taxPost ..........."+errString);
					return errString;
				}
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
			
		}
		catch(Exception e)
		{
			System.out.println(e.getMessage());
			System.out.println(e.getMessage());
			System.out.println("Exception : "+e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{				
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception : "+e);e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
	}
	public double getReqDecimal(double actVal, int prec)
	{
		String fmtStr = "############0";
		String strValue = null;
		double retVal = 0;
		if (prec > 0)
		{
			fmtStr = fmtStr + "." + "000000000".substring(0, prec);
		}
		DecimalFormat decFormat = new DecimalFormat(fmtStr);
		retVal = Double.parseDouble(decFormat.format(actVal));
		if (Math.abs(retVal) == 0)
		{
			retVal = 0;
		}
		return retVal;
	}


}
