/********************************************************
 Title : LoanPartyBankDeactivate
 Date  : 07/08/2013
 Author: Swati Bade

 ********************************************************/

package ibase.webitm.ejb.fin.adv;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import javax.ejb.Stateless;

@Stateless
public class LoanPartyBankDeactivate extends ActionHandlerEJB implements 
                LoanPartyBankDeactivateLocal,LoanPartyBankDeactivateRemote {
	
	public LoanPartyBankDeactivate() {
		System.out.println("inside loanparty Deactivate:LoanPartyBankDeactivate");
	}

	public String deactivate(String tranId,String xtraParams, String forcedFlag) 
			                  throws RemoteException, ITMException{
		
		System.out.println("in LoanPartyBankDeactivate EJB deactivate method");
        GenericUtility genericUtility;
        Connection conn = null;
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String sql="";
		String errString = "",errCode="";
		String partyCode="",bankBenCode="";
		String userId = "",confirmed="",activeStatus="";
		String[] temp;
		int count=0;
		ITMDBAccessEJB itmDBAccessEJB = null;
	       try
	       {
	         itmDBAccessEJB = new ITMDBAccessEJB();
	         ConnDriver connDriver = new ConnDriver();
			 conn = connDriver.getConnectDB("DriverITM");
			 connDriver = null;
			 if(tranId.length()>0 && tranId!="")
	         {
				 temp =tranId.split(":");
		          partyCode=temp[0];
		          bankBenCode=temp[1];
		          genericUtility = GenericUtility.getInstance();
		          userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,
		        		                                           "loginCode");
		          sql = " SELECT CONFIRMED,ACTIVE_YN FROM LOANPARTY_BANK WHERE " 
		          	   +" PARTY_CODE=? AND BANK_CODE__BEN=? ";
		          pStmt = conn.prepareStatement(sql);
		          pStmt.setString(1, partyCode);
				  pStmt.setString(2, bankBenCode);
				  rs = pStmt.executeQuery();
				  while(rs.next())
					{
						confirmed = rs.getString(1)==null?"":rs.getString(1);
						activeStatus = rs.getString(2)==null?"":rs.getString(2);						
					}
				  pStmt = null;
				  rs.close();
				  rs = null;
				  if(confirmed.equalsIgnoreCase("Y") )
				  {
	               errString = itmDBAccessEJB.getErrorString("","VMCNTRDEC","",
	            		                                      "",conn);
	                    
				  }else if(activeStatus.equalsIgnoreCase("N")){
					  
				   errString = itmDBAccessEJB.getErrorString("","VTTRANACT","",
						                                     "",conn);
					  
				  }else if(activeStatus.equalsIgnoreCase("Y")){
					  
					  sql=" UPDATE LOANPARTY_BANK SET ACTIVE_YN='N' " +
					  	  " WHERE PARTY_CODE=? AND BANK_CODE__BEN=?";
		       		  pStmt = conn.prepareStatement(sql);		       		  
		       		  pStmt.setString(1, partyCode);
		       		  pStmt.setString(2, bankBenCode);
		       		  count =pStmt.executeUpdate();		       		  
		       		  if(count>0)	{
		       			errString = itmDBAccessEJB.getErrorString("","VMDACTSUCC",
		       					                                  "","",conn);							
		       		  }else{
		       			errString = itmDBAccessEJB.getErrorString("","VTTRATWINS",
		       					                                  "","",conn);
		       		  }
					  
				  }
				  
	         }
	         
	       }
	       catch(Exception e)
	       {
	    	    e.printStackTrace();
				System.out.println("Exception LoanPartyBankDeactivate " 
	    	                       + e.getMessage());
				errString = e.getMessage();
				throw new ITMException(e);
	         
	       }
	       finally {
				try {
					if (rs != null) {
						rs.close();
						rs = null;
					}
					if (pStmt != null) {
						pStmt.close();
						pStmt = null;
					}
					if (conn != null) {
						conn.close();
					}
					conn = null;
				} catch (Exception d) {
				d.printStackTrace();
				System.out.println("Exception LoanPartyBankDeactivate:deactivate "
					                  + d);
				}
			}
	       return errString;
		
			
		
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	

}