

package ibase.webitm.ejb.fin;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
//import javax.ejb.SessionBean;
// added for ejb3

@Stateless // added for ejb3

public class TransporterBankConf extends ActionHandlerEJB implements TransporterBankConfLocal, TransporterBankConfRemote //implements SessionBean
{
   
    public String confirm(String tranId,String xtraParams, String forcedFlag) throws RemoteException,ITMException
    {
    	System.out.println("<-------Confirmed Called------------->");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "";
        ConnDriver connDriver = null;
		String loginEmpCode = null;
        ibase.webitm.utility.GenericUtility genericUtility = null;
		Document dom = null;
		int count=0;
		ITMDBAccessEJB itmDBAccessEJB = null;
		String errString = null;
		int upd = 0;
		String tranCode="", bankCodeBen="";
		String activeYN="", confTrans="";
        try
		{
        	System.out.println("tran Code"+tranId);
            itmDBAccessEJB = new ITMDBAccessEJB();
			genericUtility = ibase.webitm.utility.GenericUtility.getInstance();
            connDriver = new ConnDriver();
            conn = connDriver.getConnectDB("DriverITM");
            conn.setAutoCommit(false);
            java.sql.Timestamp currDate = new java.sql.Timestamp( System.currentTimeMillis() );
			loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
			
			String split[]=tranId.split(":");
			tranCode=split[0];
			bankCodeBen=split[1];
			
			if( errString == null || errString.trim().length() == 0 )
			{
				
				sql = "select confirmed, active_yn from transporter_bank where tran_code =? and bank_code__ben = ?";
					
				pstmt = conn.prepareStatement( sql );
				pstmt.setString(1, tranCode.trim() );
				pstmt.setString(2, bankCodeBen.trim());
				rs = pstmt.executeQuery();
				
				if( rs.next() )
				{
					confTrans=rs.getString(1).trim();
					activeYN=rs.getString(2).trim();
				}
				pstmt.close();
				pstmt = null;				
				rs.close();
				rs = null;
				
				if( "Y".equalsIgnoreCase(confTrans))
				{
					errString = itmDBAccessEJB.getErrorString("","VTALCONF","","",conn);
				}
				
				if("N".equalsIgnoreCase(activeYN))
				{
					errString = itmDBAccessEJB.getErrorString("","VTALDEACT","","",conn);
				}
			}
			if( errString == null || errString.trim().length() == 0 )
			{
//				
				sql = "update transporter_bank set confirmed = 'Y',conf_date=?,emp_code__aprv=? where tran_code = ? and bank_code__ben = ?";
				pstmt = conn.prepareStatement( sql );
				pstmt.setTimestamp(1, currDate);
				pstmt.setString(2, loginEmpCode);
				pstmt.setString( 3, tranCode.trim());
				pstmt.setString(4, bankCodeBen.trim());
				pstmt.executeUpdate();
				pstmt.close();
				pstmt = null;
			}
            if( errString != null && errString.trim().length() > 0 )
			{
                
                conn.rollback();
                return errString;
            }
			else
			{
				conn.commit();
				errString = itmDBAccessEJB.getErrorString("","CONFSUCC","");
			}
            System.out.println("errString : "+errString);
        }catch(ITMException ie)
		{
            try{
				conn.rollback();
			}catch(Exception t){}
            ie.printStackTrace();
            errString = itmDBAccessEJB.getErrorString("","VTDESNCONF","","",conn);
			throw new ITMException( ie );
        	}catch(Exception e){
            try{
				conn.rollback();
			}catch(Exception t){}
            e.printStackTrace();
            errString = itmDBAccessEJB.getErrorString("","VTDESNCONF","","",conn);
			throw new ITMException( e );
        }
		finally
		{
            try{
				if( pstmt != null )
				{
					pstmt.close();
				}
				pstmt = null;
				if(conn != null)
				{
					conn.close();
				}
				conn = null;
            }catch(Exception e){
				e.printStackTrace();
			}
        }
        return errString;
	}
}

