
/*
 * JvYearEndIC.java
 * Developer - Kunal Mandhre
 * Date - 09/APR/14 
 * FI3LFRA001
 */

package ibase.webitm.ejb.fin;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.util.*;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import javax.ejb.Stateless; 
@Stateless 

public class JvYearEndIC extends ValidatorEJB implements  JvYearEndICLocal, JvYearEndICRemote
{
	GenericUtility genericUtility = GenericUtility.getInstance();

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			if (xmlString != null && xmlString.trim().length() > 0 )
			{
				dom = parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() > 0 )
			{
				dom1 = parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() > 0 )
			{
				dom2 = parseString(xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [JvYearEndIC][wfValData( String, String )] :==>\n" + e.getMessage());
			throw new ITMException(e);
		}
		return(errString);
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String acctPrdFr = "" ,accountCode = "" , active = "" ,accountCat = "";
		String childNodeName = null;
		String errString = "";
		String errCode = "";
		String userId = "";
		String sql = "";
		String errorType = "",finEntity = "";
		//double amountPerc = 0, totAmountPerc = 0;// prvSequence = 0;
		//double sequence = 0;
		//double sequenceArry [] = null; ;

		int count = 0;
		int ctr=0;
		int currentFormNo = 0;
		int childNodeListLength;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;	
		Node parentNode = null;
		Node childNode = null;
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		Connection conn = null;
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		ConnDriver connDriver = new ConnDriver();
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
		System.out.println("editFlag="+editFlag);
		try
		{
			conn = connDriver.getConnectDB("DriverITM");
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
			case 1 :
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr ++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equalsIgnoreCase("fin_entity"))
			    	{
						finEntity = genericUtility.getColumnValue("fin_entity", dom);
						if(finEntity == null || (finEntity.length() == 0))
						{
							errList.add("VMFINENT1 ");
							errFields.add(childNodeName.toLowerCase());
						}
						if(finEntity != null && finEntity.trim().length() > 0)
						{
							sql = " select count(*) from finent where fin_entity = ?  ";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,finEntity);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								count =  rs.getInt(1);
							}
							if(count == 0) 
							{
								errCode = "VMFINENTM2";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());	
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
					}
					else if(childNodeName.equalsIgnoreCase("tran_date"))
			    	{
						if (genericUtility.getColumnValue("tran_date", dom) == null)
						{
							errCode = "VMTRANDT";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
			    	}
					else if(childNodeName.equalsIgnoreCase("acct_prd__fr"))
			    	{
						acctPrdFr = checkNull(genericUtility.getColumnValue("acct_prd__fr", dom));
						if(acctPrdFr == null || (acctPrdFr.length() == 0))
						{
							errList.add("VMINVPRDFR");
							errFields.add(childNodeName.toLowerCase());
						}
						if(acctPrdFr != null && acctPrdFr.trim().length() > 0)
						{
							sql = "select count(*) as count from acctprd where code =?";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,acctPrdFr);
							rs = pstmt.executeQuery();
							if(rs.next())
							{   
								count = rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close(); 
							pstmt = null;

							if( count == 0 )
							{
								errCode = "PRDCODE1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
						
					}
					/*else if(childNodeName.equalsIgnoreCase("prd_code_to"))
			    	{
						periodCode = genericUtility.getColumnValue("prd_code_to", dom);
						if(periodCode == null || (periodCode.length() == 0))
						{
							errList.add("VMINVPRD");
							errFields.add(childNodeName.toLowerCase());
						}
						
					}*/
					else if(childNodeName.equalsIgnoreCase("acct_code_pl"))
			    	{
						accountCode = genericUtility.getColumnValue("acct_code_pl", dom);
						if(accountCode == null || (accountCode.length() == 0))
						{
							errList.add("VMACCTCD1");
							errFields.add(childNodeName.toLowerCase());
						}
						else
						{
							if(!(isExist(conn, "ACCOUNTS", "ACCT_CODE" ,accountCode)))
							{
								errList.add("VMACCT1");
								errFields.add(childNodeName.toLowerCase());
							}
							else
							{
								sql = " select active from accounts where acct_code =  ?   ";
								pstmt =  conn.prepareStatement(sql);
								pstmt.setString(1,accountCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									active =  rs.getString("active");
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								if(! "Y".equalsIgnoreCase(active))
								{
									errList.add("VMACCTA");
									errFields.add(childNodeName.toLowerCase());
								}
								else
								{
									sql = " select acctgrp.acct_cat from acctgrp ,acctsgrp , accounts   where acctgrp.group_code = acctsgrp.group_code and acctsgrp.sgroup_code = accounts.sgroup_code and accounts.acct_code = ?   ";
									pstmt =  conn.prepareStatement(sql);
									pstmt.setString(1,accountCode);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										accountCat =  rs.getString("acct_cat");
									}
									rs.close();
									rs = null;
									pstmt.close();
									pstmt = null;
									if("A".equalsIgnoreCase(accountCat) || "L".equalsIgnoreCase(accountCat))
									{
										errList.add("VTACCT01");
										errFields.add(childNodeName.toLowerCase());
									}
								}
							}
						}
						
					}
					else if(childNodeName.equalsIgnoreCase("acct_code_bs"))
			    	{
						accountCode = genericUtility.getColumnValue("acct_code_bs", dom);
						if(accountCode == null || (accountCode.length() == 0))
						{
							errList.add("VMACCTCD1");
							errFields.add(childNodeName.toLowerCase());
						}
						else
						{
							if(!(isExist(conn, "ACCOUNTS", "ACCT_CODE" ,accountCode)))
							{
								errList.add("VMACCT1");
								errFields.add(childNodeName.toLowerCase());
							}
							else
							{
								sql = " select active from accounts where acct_code =  ?   ";
								pstmt =  conn.prepareStatement(sql);
								pstmt.setString(1,accountCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									active =  rs.getString("active");
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								if(! "Y".equalsIgnoreCase(active))
								{
									errList.add("VMACCTA");
									errFields.add(childNodeName.toLowerCase());
								}
								else
								{
									sql = " select acctgrp.acct_cat from acctgrp ,acctsgrp , accounts   where acctgrp.group_code = acctsgrp.group_code and acctsgrp.sgroup_code = accounts.sgroup_code and accounts.acct_code = ?   ";
									pstmt =  conn.prepareStatement(sql);
									pstmt.setString(1,accountCode);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										accountCat =  rs.getString("acct_cat");
									}
									rs.close();
									rs = null;
									pstmt.close();
									pstmt = null;
									if("I".equalsIgnoreCase(accountCat) || "E".equalsIgnoreCase(accountCat))
									{
										errList.add("VTACCT02");
										errFields.add(childNodeName.toLowerCase());
									}
								}
							}
						}
						
					}
				}
				break;


			}
			int errListSize = errList.size();
			count = 0;
			String errFldName = null;
			if(errList != null && errListSize > 0)
			{
				for(count = 0; count < errListSize; count ++)
				{
					errCode = errList.get(count);
					errFldName = errFields.get(count);
					System.out.println("errCode .........." + errCode);
					errString = getErrorString(errFldName, errCode, userId);
					errorType = errorType(conn , errCode);
					if(errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if(errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			else
			{
				errStringXml = new StringBuffer("");
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(rs != null) 
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null) 
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close();
				}
				conn = null;
			} 
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		return errString;
	}//end of validation

	// method for item change
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		System.out.println("xmlString............."+xmlString);
		System.out.println("xmlString1............"+xmlString);
		System.out.println("xmlString2............"+xmlString);
		try
		{   
			if(xmlString != null && xmlString.trim().length() > 0)
			{
				dom = parseString(xmlString);
			}
			if(xmlString1 != null && xmlString1.trim().length() > 0)
			{
				dom1 = parseString(xmlString1);
			}
			if(xmlString2 != null && xmlString2.trim().length() > 0)
			{
				dom2 = parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [JvYearEndIC][itemChanged( String, String )] :==>\n" + e.getMessage());
			throw new ITMException(e);
		}
		return valueXmlString;
	}

	// method for item change
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		String plAccountCode = "" ,bsAccountCode = "",acctPrdFr = "" ,acctPrdTo = "";
		String childNodeName = null;
		String sql = "";
		StringBuffer valueXmlString = new StringBuffer();
		int ctr = 0;
		int currentFormNo = 0;
		int childNodeListLength = 0;
		Timestamp toDate = null ;
		Date newDate = null;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		GenericUtility genericUtility = GenericUtility.getInstance();
		ConnDriver connDriver = new ConnDriver();
		FinCommon finCommon = new FinCommon();
		try
		{   
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?> <Root> <header> <editFlag>");
			valueXmlString.append(editFlag).append("</editFlag> </header>");
			switch(currentFormNo)
			{

			case 1 : 
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				valueXmlString.append("<Detail>");
				childNodeListLength = childNodeList.getLength();
				do
				{   
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					ctr ++;
				}while(ctr < childNodeListLength  && ! childNodeName.equals(currentColumn));
				
				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{
					plAccountCode = finCommon.getFinparams("999999","PL_ACCT_CODE",conn);
					if(plAccountCode == null || "NULLFOUND".equalsIgnoreCase(plAccountCode) )
					{
						plAccountCode = "";
					}
					bsAccountCode = finCommon.getFinparams("999999","BS_ACCT_CODE",conn);
					if(bsAccountCode == null || "NULLFOUND".equalsIgnoreCase(bsAccountCode) )
					{
						bsAccountCode = "";
					}
					valueXmlString.append("<acct_code_pl>").append(plAccountCode).append("</acct_code_pl>\r\n");
					valueXmlString.append("<acct_code_bs>").append(bsAccountCode).append("</acct_code_bs>\r\n");
					
				}
				else if( currentColumn.trim().equalsIgnoreCase( "acct_prd__fr" ) )
				{
					acctPrdFr = checkNull(genericUtility.getColumnValue("acct_prd__fr", dom));
					
					sql = "select to_date from acctprd where code = ?";
					pstmt =  conn.prepareStatement(sql);
					pstmt.setString(1,acctPrdFr);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						toDate =  rs.getTimestamp("to_date");
						
					}
					rs.close();
					rs = null;
					pstmt.close(); 
					pstmt = null;
					if(toDate != null)
					{		
						newDate =  (java.util.Date ) relativeDate(toDate, 1);								
						sql = "select code from acctprd  where fr_date = ?";
						pstmt =  conn.prepareStatement(sql);				
						pstmt.setDate(1, new java.sql.Date(newDate.getTime()));
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							acctPrdTo =  rs.getString("code");
							
						}
						rs.close();
						rs = null;
						pstmt.close(); 
						pstmt = null;
					}
					valueXmlString.append("<acct_prd__to>").append("<![CDATA["+acctPrdTo+"]]>").append("</acct_prd__to>");
				}
				valueXmlString.append("</Detail>");
				break; 

			}
			valueXmlString.append("</Root>");
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(rs != null) 
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null) 
					{
						pstmt.close();
						pstmt = null;

					}
					conn.close();
				}
				conn = null;	
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}			
		}
		return valueXmlString.toString();
	}
	private String checkNull(String input) 
	{
		if(input == null)
		{
			input = "";
		}
		return input.trim();
	}
	private boolean isExist(Connection conn, String tableName, String columnName, String value) throws  ITMException, RemoteException
	{
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";
		boolean status = false;
		try
		{			
			sql = "SELECT count(*) from " + tableName + " where " + columnName +"  = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,value);
			rs = pstmt.executeQuery();

			if(rs.next())
			{					 
				if(rs.getBoolean(1))
				{					
					status = true;
				}
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;	        
		}
		catch(Exception e)
		{
			System.out.println("Exception in isExist ");
			e.printStackTrace();
			throw new ITMException(e); 
		}
		System.out.println("returning String from isExist ");
		return status;
	}
	
	private String findValue(Connection conn, String columnName ,String tableName, String columnName2, String value) throws  ITMException, RemoteException
	{

		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";
		String findValue = "";
		
		try
		{			
			sql = "SELECT " + columnName + " from " + tableName + " where " + columnName2 +"  = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,value);
			rs = pstmt.executeQuery();

			if(rs.next())
			{					
				findValue = rs.getString(columnName);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;	        
		}
		catch(Exception e)
		{
			System.out.println("Exception in findValue ");
			e.printStackTrace();
			throw new ITMException(e); 
		}
		System.out.println("returning String from findValue ");
		return findValue;
	}	
	private String errorType(Connection conn , String errorCode) throws ITMException
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1,errorCode);			
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex);
		}		
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}		
		return msgType;
	}
	public static java.util.Date relativeDate(java.util.Date date, int days) 
	{
		java.util.Date calculatedDate = null;
		if (date != null) 
		{
			final GregorianCalendar calendar = new GregorianCalendar();
			calendar.setTime(date);
			calendar.add(Calendar.DATE,days);
			calculatedDate = new java.util.Date(calendar.getTime().getTime());
		}		
		return calculatedDate;
	}
	
	
	
	
}	
