package ibase.webitm.ejb.adm;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;  
import java.util.Date;

import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class EmpBasicInfo extends ValidatorEJB implements EmpBasicInfoLocal ,EmpBasicInfoRemote
{

	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		
		String errString = null;

		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			System.out.println("EmpBasicInfo xmlString in itemChanged..::["+xmlString+"]");
			System.out.println("EmpBasicInfo xmlString1 in itemChanged..:: ["+xmlString1+"]");
			System.out.println("EmpBasicInfo xmlString2 in itemChanged..:: ["+xmlString2+"]");
			
			if(xmlString != null && xmlString.length() > 0)
			{
				dom = genericUtility.parseString(xmlString);				
			}
			if(xmlString1 != null  &&  xmlString1.length() > 0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if(xmlString2 != null && xmlString2.length() > 0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = itemChanged( dom, dom1, dom2, objContext, currentColumn,  editFlag,  xtraParams);
			System.out.println("EmpBasicInfo errString Returing at Stage 1["+errString+"]");
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception :EmpBasicInfo [:" + e.getMessage() + ":]" );
			errString = genericUtility.createErrorString(e);
		}
		System.out.println("EmpBasicInfo errString returing at Stage 2[" + errString+"]");
		return errString;
	}
		
	//Start of itemChanged block
	public String itemChanged(Document dom, Document dom1,Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		String objNameDefault = "";
		//Variable defined for  employee details . Start
		String contactCode = "";
		String empName = "";
		String funcGroup = "";
		String funGroupDescr = "";
		String parentDept = "";
		String parentDeptDescr = "";
		String deptCode = "";
		String departmentDescr = "";
		String designation = "";
		String reportToAdmin = "";
		String empCode= "";
		String posCode = "";
		String posCodeDescr = "";
		String cadreCode ="";
		String cadreCodeDescr ="";
		String gradeCode = "";
		String gradeCodeDescr = "";
		String cadreCodeGread = "";
		String designCode = "";
		String joinedAs = "";
		String empClass ="";
		String empClassDescr = "";
		String reportTo = "";
		String empCodeHod ="";
		String empCodeHodFname ="";
		String empCodeHodLname ="";
		
		//Variable defined for employee details . End

		int currentFormNo = 0;
		GenericUtility genericUtility = GenericUtility.getInstance();
				
		//To get login Employee Code 
		String loginEmpCode = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode"));
		String loginSite = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode"));

		StringBuffer valueXmlString = new StringBuffer();
		
		System.out.println("Login Employee got..:: ["+loginEmpCode+"]");
		System.out.println("objContext ..:: ["+objContext+"]");
		System.out.println("currentColumn ..:: ["+currentColumn+"]");
		System.out.println("editFlag ..:: ["+editFlag+"]");
		System.out.println("xtraParams ..:: ["+xtraParams+"]");
		

		if(objContext != null && objContext.trim().length() > 0)
		{
			currentFormNo = Integer.parseInt(objContext);
		}

		try
		{
			conn = connDriver.getConnectDB("Driver");
			conn.setAutoCommit(false);

			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");

			objNameDefault  = checkNull(getObjName(dom ,"1"));
			System.out.println("objNameDefault ..:: ["+objNameDefault+"]");
			
			switch (currentFormNo)
			{
				case 1:
						{
							valueXmlString.append("<Detail1 domID='1' dbID='' objContext='1' objName='"+objNameDefault+"' selected='Y'>\r\n");

							if (currentColumn.equalsIgnoreCase("contact_code"))
							{
								empName = "";
								contactCode = checkNull(getColumnValue("contact_code",dom,"1")) ;
								empCode = checkNull(getColumnValue("emp_code",dom,"1")) ;
								String fname = "";
								String mname = "";
								String lname = "";
								if(editFlag .equalsIgnoreCase("A"))
								{
									if (contactCode != null && contactCode.trim().length() > 0)
									{
										sql = "SELECT NAME FROM CONTACT WHERE CONTACT_CODE = ? ";
										pstmt = conn.prepareStatement(sql);
										pstmt.setString(1,contactCode);
										rs = pstmt.executeQuery();
										if(rs.next())
										{
											empName = checkNull(rs.getString("NAME"));
										}
										if( rs != null )
										{
											rs.close();
											rs = null;
										}
										if( pstmt != null )
										{
											pstmt.close();
											pstmt = null;
										}
										System.out.println("empName ..:: ["+empName+"]");
										String string = empName;
										String[] str = string.split(" ");
										//fname = str[0];
										//mname = str[1]; 
										//lname = str[2]; 
										System.out.println("Array Length:::::::"+str.length);
										for (int i =0; i < str.length; i++)
										{										
											if (i == 0)
											{
												fname = str[i];
											}
											
											if (i == 1)
											{
												mname = str[i];
											}
											
											if (i == 2)
											{
												lname = str[i];
											}
										}
										System.out.println("fname:::::::"+fname);
										System.out.println("mname:::::::"+mname);
										System.out.println("lname:::::::"+lname);
										
										if(fname.length() > 15)
										{
											fname = fname.substring(0, 16);
											System.out.println("empName ..:: ["+fname+"]");
										}
										if(mname.length() > 15)
										{
											mname = mname.substring(0,16);
											System.out.println("mname ..:: ["+mname+"]");
										}
										if(lname.length() > 15)
										{
											lname = lname.substring(0,16);
											System.out.println("lname ..:: ["+lname+"]");
										}
										valueXmlString.append("<emp_fname><![CDATA[").append(fname).append("]]></emp_fname>\r\n");
										valueXmlString.append("<emp_mname><![CDATA[").append(mname).append("]]></emp_mname>\r\n");
										valueXmlString.append("<emp_lname><![CDATA[").append(lname).append("]]></emp_lname>\r\n");
										
										if(empCode == null || empCode.length() == 0)
										{
											valueXmlString.append("<emp_code><![CDATA[").append(contactCode).append("]]></emp_code>\r\n");
										}
									}
								}
							}
							else if (currentColumn.equalsIgnoreCase("func_group"))
							{
								funcGroup = checkNull(getColumnValue("func_group",dom,"1")) ;
								if(funcGroup != null && funcGroup.length() > 0)
								{
									sql = "SELECT DESCR FROM DEPARTMENT WHERE DEPT_CODE = ? ";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1,funcGroup);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										funGroupDescr = checkNull(rs.getString("DESCR"));
									}
									if( rs != null )
									{
										rs.close();
										rs = null;
									}
									if( pstmt != null )
									{
										pstmt.close();
										pstmt = null;
									}
									System.out.println("funGroupDescr ..:: ["+funGroupDescr+"]");
									valueXmlString.append("<func_group_descr><![CDATA[").append(funGroupDescr).append("]]></func_group_descr>\r\n");
								}
								else
								{
									valueXmlString.append("<func_group_descr><![CDATA[]]></func_group_descr>\r\n");
								}
							}
							else if (currentColumn.equalsIgnoreCase("parent_dept"))
							{
								parentDept = checkNull(getColumnValue("parent_dept",dom,"1")) ;
								if(parentDept != null && parentDept.length() > 0)
								{
									sql = "SELECT DESCR FROM DEPARTMENT WHERE DEPT_CODE = ? ";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1,parentDept);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										parentDeptDescr = checkNull(rs.getString("DESCR"));
									}
									if( rs != null )
									{
										rs.close();
										rs = null;
									}
									if( pstmt != null )
									{
										pstmt.close();
										pstmt = null;
									}
									System.out.println("parentDeptDescr ..:: ["+parentDeptDescr+"]");
									valueXmlString.append("<parent_dept_descr><![CDATA[").append(parentDeptDescr).append("]]></parent_dept_descr>\r\n");
								}
								else
								{
									valueXmlString.append("<parent_dept_descr><![CDATA[]]></parent_dept_descr>\r\n");
								}
							}
							else if (currentColumn.equalsIgnoreCase("dept_code"))
							{
								deptCode = checkNull(getColumnValue("dept_code",dom,"1")) ;
						
								sql = "SELECT DESCR FROM DEPARTMENT WHERE DEPT_CODE = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,deptCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									departmentDescr = checkNull(rs.getString("DESCR"));
								}
								if( rs != null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								System.out.println("departmentDescr ..:: ["+departmentDescr+"]");
								valueXmlString.append("<department_descr><![CDATA[").append(departmentDescr).append("]]></department_descr>\r\n");
							
								if(loginSite != null && loginSite.length() > 0)
								{
									valueXmlString.append("<emp_site><![CDATA[").append(loginSite).append("]]></emp_site>\r\n");
								}
								posCode = checkNull(getColumnValue("pos_code",dom,"1")) ;
								deptCode = checkNull(getColumnValue("dept_code",dom,"1")) ;
								empCode = checkNull(getColumnValue("emp_code",dom,"1")) ;
								
								sql = "select fn_get_pos_descr(?,?,?) As pos_code_descr from dual ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,empCode);	
								pstmt.setString(2,deptCode);	
								pstmt.setString(3,posCode);	
								rs = pstmt.executeQuery();

								if( rs.next())
								{
									posCodeDescr = checkNull(rs.getString("pos_code_descr"));	
								}
								if( rs != null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								System.out.println("posCodeDescr ..:: ["+posCodeDescr+"]");
								valueXmlString.append("<pos_code_descr><![CDATA[").append(posCodeDescr).append("]]></pos_code_descr>\r\n");
							}
							else if (currentColumn.equalsIgnoreCase("cadre_code"))
							{
								cadreCode = checkNull(getColumnValue("cadre_code",dom,"1")) ;
								sql = "SELECT DESCR  FROM CADRE WHERE CADRE_CODE = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,cadreCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cadreCodeDescr = checkNull(rs.getString("DESCR"));
								}
								if( rs != null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
									System.out.println("cadreCodeDescr ..:: ["+cadreCodeDescr+"]");
									valueXmlString.append("<cadre_descr><![CDATA[").append(cadreCodeDescr).append("]]></cadre_descr>\r\n");
							}
							else if (currentColumn.equalsIgnoreCase("grade_code"))
							{
								gradeCode = checkNull(getColumnValue("grade_code",dom,"1")) ;
								cadreCode = checkNull(getColumnValue("cadre_code",dom,"1")) ;
								sql = "SELECT  CADRE_CODE, DESCR FROM GRADE WHERE GRADE_CODE = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,gradeCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cadreCodeGread = checkNull(rs.getString("CADRE_CODE"));
									gradeCodeDescr = checkNull(rs.getString("DESCR"));
								}
								if( rs != null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
									System.out.println("gradeCodeDescr ..:: ["+gradeCodeDescr+"]");
									valueXmlString.append("<grade_descr><![CDATA[").append(gradeCodeDescr).append("]]></grade_descr>\r\n");
									if(( cadreCode == null  || cadreCode .length() == 0 ) || editFlag.equalsIgnoreCase("A"))
									{
										valueXmlString.append("<cadre_code><![CDATA[").append(cadreCodeGread).append("]]></cadre_code>\r\n");

										sql = "SELECT DESCR  FROM CADRE WHERE CADRE_CODE = ? ";
										pstmt = conn.prepareStatement(sql);
										pstmt.setString(1,cadreCodeGread);
										rs = pstmt.executeQuery();
										if(rs.next())
										{
											cadreCodeDescr = checkNull(rs.getString("DESCR"));
										}
										if( rs != null )
										{
											rs.close();
											rs = null;
										}
										if( pstmt != null )
										{
											pstmt.close();
											pstmt = null;
										}
										System.out.println("cadreCodeDescr ..:: ["+cadreCodeDescr+"]");
										valueXmlString.append("<cadre_descr><![CDATA[").append(cadreCodeDescr).append("]]></cadre_descr>\r\n");
									}
							}
							else if (currentColumn.equalsIgnoreCase("report_to"))
							{
								reportTo = checkNull(getColumnValue("report_to",dom,"1")) ;
								sql = "SELECT EMP_LNAME, EMP_FNAME FROM EMPLOYEE WHERE EMP_CODE = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,reportTo);
								rs = pstmt.executeQuery();
								String reportToFname = "";
								String reportToLname = "";
								if(rs.next())
								{
									reportToFname = checkNull(rs.getString("EMP_FNAME"));
									reportToLname = checkNull(rs.getString("EMP_LNAME"));
								}
								if( rs != null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								System.out.println("reportToFname ..:: ["+reportToFname+"]");
								System.out.println("reportToLname ..:: ["+reportToLname+"]");
								valueXmlString.append("<fname><![CDATA[").append(reportToFname).append("]]></fname>\r\n");
								valueXmlString.append("<lname><![CDATA[").append(reportToLname).append("]]></lname>\r\n");
							}
							else if (currentColumn.equalsIgnoreCase("design_code"))
							{
								designCode = checkNull(getColumnValue("design_code",dom,"1")) ;
								sql = "SELECT DESIGNATION FROM DESIGNATION WHERE DESIGN_CODE = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,designCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									designation = checkNull(rs.getString("DESIGNATION"));
								}
								if( rs != null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
									System.out.println("designation ..:: ["+designation+"]");
									valueXmlString.append("<designation><![CDATA[").append(designation).append("]]></designation>\r\n");
									joinedAs = checkNull(getColumnValue("joined_as",dom,"1")) ;
									if(joinedAs == null || joinedAs.length() == 0)
									{
										valueXmlString.append("<joined_as><![CDATA[").append(designation).append("]]></joined_as>\r\n");
									}
							}
							else if (currentColumn.equalsIgnoreCase("designation"))
							{
								designation = checkNull(getColumnValue("designation",dom,"1")) ;
								joinedAs = checkNull(getColumnValue("joined_as",dom,"1")) ;
								if(joinedAs == null || joinedAs.length() == 0)
								{
									valueXmlString.append("<joined_as><![CDATA[").append(designation).append("]]></joined_as>\r\n");
								}								
							}
							else if (currentColumn.equalsIgnoreCase("report_to__admin"))
							{
								reportToAdmin = checkNull(getColumnValue("report_to__admin",dom,"1")) ;
								sql = "SELECT EMP_LNAME, EMP_FNAME FROM EMPLOYEE WHERE EMP_CODE = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,reportToAdmin);
								rs = pstmt.executeQuery();
								String adminFname = "";
								String adminLname = "";
								if(rs.next())
								{
									adminLname = checkNull(rs.getString("EMP_LNAME"));
									adminFname = checkNull(rs.getString("EMP_FNAME"));
								}
								if( rs != null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								System.out.println("adminFname ..:: ["+adminFname+"]");
								System.out.println("adminLname ..:: ["+adminLname+"]");
								valueXmlString.append("<admin_fname><![CDATA[").append(adminFname).append("]]></admin_fname>\r\n");
								valueXmlString.append("<admin_lname><![CDATA[").append(adminLname).append("]]></admin_lname>\r\n");
							}
							else if (currentColumn.equalsIgnoreCase("emp_class"))
							{
								empClass = checkNull(getColumnValue("emp_class",dom,"1")) ;
								sql = "SELECT DESCR FROM GENCODES WHERE FLD_NAME = 'EMP_CLASS' AND FLD_VALUE = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,empClass);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									empClassDescr = checkNull(rs.getString("DESCR"));
								}
								if( rs != null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								System.out.println("empClassDescr ..:: ["+empClassDescr+"]");
								valueXmlString.append("<emp_class_descr><![CDATA[").append(empClassDescr).append("]]></emp_class_descr>\r\n");
							}
							else if (currentColumn.equalsIgnoreCase("emp_code__hod"))
							{
								empCodeHod = checkNull(getColumnValue("emp_code__hod",dom,"1")) ;
								sql = "SELECT EMP_FNAME, EMP_LNAME FROM EMPLOYEE WHERE EMP_CODE = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,empCodeHod);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									empCodeHodFname = checkNull(rs.getString("EMP_FNAME"));
									empCodeHodLname = checkNull(rs.getString("EMP_LNAME"));
								}
								if( rs != null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
									System.out.println("empCodeHodFname ..:: ["+empCodeHodFname+"]");
									System.out.println("empCodeHodLname ..:: ["+empCodeHodLname+"]");
									valueXmlString.append("<emp_code_hod__fname><![CDATA[").append(empCodeHodFname).append("]]></emp_code_hod__fname>\r\n");
									valueXmlString.append("<emp_code_hod__lname><![CDATA[").append(empCodeHodLname).append("]]></emp_code_hod__lname>\r\n");
							}
							else if (currentColumn.equalsIgnoreCase("pos_code"))
							{
								posCode = checkNull(getColumnValue("pos_code",dom,"1")) ;
								deptCode = checkNull(getColumnValue("dept_code",dom,"1")) ;
								empCode = checkNull(getColumnValue("emp_code",dom,"1")) ;
								
								sql = "select fn_get_pos_descr(?,?,?) As pos_code_descr from dual ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,empCode);	
								pstmt.setString(2,deptCode);	
								pstmt.setString(3,posCode);	
								rs = pstmt.executeQuery();

								if( rs.next())
								{
									posCodeDescr = checkNull(rs.getString("pos_code_descr"));	
								}
								if( rs != null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								System.out.println("posCodeDescr ..:: ["+posCodeDescr+"]");
								valueXmlString.append("<pos_code_descr><![CDATA[").append(posCodeDescr).append("]]></pos_code_descr>\r\n");
							}
	
							valueXmlString.append("</Detail1>\r\n");
						
						}//End of Case 1
						break;
			
			}//END OF SWITCH
			
		}//End of try block		
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :EmpBasicInfo [itemChanged(String xmlString)] : ==>\n"+e.getMessage());
			throw new ITMException(e);
		}//End of cacth block
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
				
			}
			catch(Exception e)
			{
				System.out.println("Exception ::"+e);
				e.printStackTrace();
			}			
		}//End of finally block
		
		valueXmlString.append("</Root>\r\n");
		System.out.println("valueXmlString....["+valueXmlString.toString());
		return valueXmlString.toString();
	}//End of itemChanged block


	//Start of wfValData Start
	public String wfValData() throws RemoteException,ITMException
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("Came Inside 1 wfValData:::");
		GenericUtility genericUtility = GenericUtility.getInstance();

		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";
		System.out.println("xmlString ["+xmlString+"]");
		System.out.println("xmlString1["+xmlString1+"]");
		System.out.println("xmlString2["+xmlString2+"]");
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = parseString(xmlString); 
			}
			else
			{
				System.out.println("xmlstring is null");
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = parseString(xmlString1); 
			}
			else
			{
				System.out.println("xmlstring1 is null");
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = parseString(xmlString2);
			}
			else
			{
				System.out.println("xmlstring2 is null");
			}
			System.out.println("Before call valdata");
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [EmpBasicInfo][wfValData(String xmlString)] : ==>\n"+e.getMessage());
			e.printStackTrace();
			errString = genericUtility.createErrorString(e);
			
		}
		return (errString); 
	}


	public String wfValData( Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams ) throws RemoteException,ITMException
	{
		System.out.println("Came Inside 2 wfValData:::");
		String errString = "";
		Connection conn = null;
		
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");
			conn.setAutoCommit(false);
			
			errString = wfValData( dom, dom1, dom2, objContext, editFlag, xtraParams,conn);
		}
		catch ( Exception e )
		{
			e.printStackTrace();
			errString = genericUtility.createErrorString(e);
		}
		finally
		{
			try
			{
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e1)
			{
				System.out.println( "Exception : [EmpBasicInfo][wfValData] : ==>\n"+e1.getMessage());
				throw new ITMException(e1);
			}
		}
		return errString;
	}

	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams,Connection conn) throws RemoteException,ITMException
	{
	
		Node parentNode = null;
		Node childNode = null;

		NodeList parentNodeList = null;
		NodeList childNodeList = null;

		String errString = "";
		String childNodeName = "";	

		int currentFormNo = 0;		
		int childNodeListLength = 0;

		 
		String msgType = "";
		String errCode = "";
		String errFldName = "";
		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");

		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();

		int cnt = 0;
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;


		//Varibles used in case 1 Start

		String empCode = "";
		String contactCode = "";
		String userId = "";
		String empLname = "";
		String empFname = "";
		String empMname = "";
		String empCodeLink = "";
		String funcGroup = "";
		String parentDept ="";
		String deptCode = "";
		String cadreCode = "";
		String gradeCode = "";
		String designCode = "";
		String reportTo = "";
		String reportToAdmin = "";
		String posCode = "";
		String empCodeHod = "";
		//Varibles used in  case 1 End

		int ctr = 0;		
		int count = 0;	
		GenericUtility genericUtility = GenericUtility.getInstance();

		try
		{
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			switch(currentFormNo)
			{
				case 1:
				{
					parentNodeList = dom.getElementsByTagName("Detail"+currentFormNo);
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();

					for(ctr = 0; ctr < childNodeListLength; ctr++)
					{
						childNode = childNodeList.item(ctr);
						
						System.out.println("childNode"+childNode);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}

						childNodeName = childNode.getNodeName();
						//Validation For Employee Code
						if(childNodeName.equalsIgnoreCase("emp_code"))
						{
							if(editFlag.equalsIgnoreCase("A"))
							{
								empCode = checkNull(getColumnValue("emp_code",dom,objContext));
								System.out.println("empCode code got in the validation ..::["+empCode+"]");
								sql = "SELECT KEY_FLAG FROM TRANSETUP WHERE TRAN_WINDOW = 'w_emp_basic_info' " ;
								pstmt = conn.prepareStatement(sql);					
								rs = pstmt.executeQuery();		
								String keyFlag = "M";
								if( rs.next() )
								{
									keyFlag  = checkNull(rs.getString("KEY_FLAG"));
								}
								System.out.println("keyFlag:::: "+keyFlag);
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								if(keyFlag.equalsIgnoreCase("M"))
								{
									if (empCode == null || empCode.length() == 0)
									{
										System.out.println("Employee code null");
																		
										errList.add( "VEEMP2" );
										errFields.add( childNodeName.toLowerCase() );
										
										msgType =  errorType( conn , "VEEMP2" );
										if ( msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
									else
									{
											sql = "";
											count = 0;
											sql = "SELECT COUNT(*) AS COUNT FROM EMPLOYEE WHERE EMP_CODE = ?" ;
											pstmt = conn.prepareStatement(sql);					
											pstmt.setString(1,empCode);
											rs = pstmt.executeQuery();					
											if( rs.next() )
											{
												count  = rs.getInt("COUNT");
											}
											System.out.println("value of count in emp_code:::: "+count);
											if ( rs != null )
											{
												rs.close();
												rs = null;
											}
											if ( pstmt != null )
											{
												pstmt.close();
												pstmt = null;
											}
											if(count > 0)
											{
												System.out.println("emp_code is already exist in employee master");
												
												errList.add( "VMDUPL1" );
												errFields.add( childNodeName.toLowerCase() );
												
												msgType =  errorType( conn , "VMDUPL1" );
												if ( msgType.equalsIgnoreCase("E"))
												{
													break;
												}
											}
										}
									}
								}
							}
						//Validation For Employee Code
						else if(childNodeName.equalsIgnoreCase("contact_code"))
						{
							contactCode = checkNull(getColumnValue("contact_code",dom,objContext));
							if(contactCode == null || contactCode.length() == 0)
							{
								System.out.println("contact code null");
								
								errList.add( "VMCCD1" );
								errFields.add( childNodeName.toLowerCase() );
								
								msgType =  errorType( conn , "VMCCD1" );
								if ( msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							else 
							{
								count = 0;
								sql = "SELECT COUNT(*) AS COUNT FROM CONTACT WHERE CONTACT_CODE = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,contactCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									count = rs.getInt("COUNT");
								}
								System.out.println("Value of Count in catact master......."+count);
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								if(count == 0)
								{
									System.out.println("Contact code does not exist in the Contact master");
									
									errList.add( "VMCCD2");
									errFields.add( childNodeName.toLowerCase() );
									
									msgType =  errorType( conn , "VMCCD2" );
									if ( msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}								
							}
						}
						else if(childNodeName.equalsIgnoreCase("emp_lname"))
						{
							empLname = checkNull(getColumnValue("emp_lname",dom,objContext));
							if(empLname == null || empLname.length() == 0)
							{
								System.out.println("empLname code null");
								
								errList.add( "VEEMP3" );
								errFields.add( childNodeName.toLowerCase() );
								
								msgType =  errorType( conn , "VEEMP3" );
								if ( msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("emp_fname"))
						{
							empFname = checkNull(getColumnValue("emp_fname",dom,objContext));
							if(empFname == null || empFname.length() == 0)
							{
								System.out.println("empFname code null");
								
								errList.add( "VEEMP4" );
								errFields.add( childNodeName.toLowerCase() );
								
								msgType =  errorType( conn , "VEEMP4" );
								if ( msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("emp_mname"))
						{
							empMname = checkNull(getColumnValue("emp_mname",dom,objContext));
							if(empMname == null || empMname.length() == 0)
							{
								System.out.println("empMname code null");
								
								errList.add( "VEEMP5" );
								errFields.add( childNodeName.toLowerCase() );
								
								msgType =  errorType( conn , "VEEMP5" );
								if ( msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("emp_code__link"))
						{
							count = 0;
							//empCodeLink = checkNull(getColumnValue("emp_code__link",dom,objContext));
							empCodeLink = checkNull(genericUtility.getColumnValue("emp_code__link",dom,objContext) , false);
							if(empCodeLink != null && empCodeLink.length() > 0)
							{
								sql = "SELECT COUNT(*) AS COUNT FROM EMPLOYEE WHERE EMP_CODE = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,empCodeLink);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									count = rs.getInt("COUNT");
								}
								System.out.println("Value of Count in Employee  master......."+count);
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								if(count == 0)
								{
									System.out.println("Employee does not present in employee master :::::::::");
									
									errList.add( "VMEMP1");
									errFields.add( childNodeName.toLowerCase() );
									
									msgType =  errorType( conn , "VMEMP1" );
									if ( msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
								else
								{
									sql = "SELECT RELIEVE_DATE FROM EMPLOYEE WHERE EMP_CODE = ? ";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1,empCodeLink);
									rs = pstmt.executeQuery();
									String relieveDate ="";
									if(rs.next())
									{
										relieveDate = checkNull(rs.getString("RELIEVE_DATE"));
									}
									System.out.println("relieveDate:::::::::::"+relieveDate);
									if ( rs != null )
									{
										rs.close();
										rs = null;
									}
									if ( pstmt != null )
									{
										pstmt.close();
										pstmt = null;
									}
									if(relieveDate == null || relieveDate.trim().length() == 0)
									{
										System.out.println("relieveDate does not exist ");
										
										errList.add( "VTEMPRLVDT");
										errFields.add( childNodeName.toLowerCase() );
										
										msgType =  errorType( conn , "VTEMPRLVDT" );
										if ( msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
									// Modified by Piyush on 07/11/2014 [To incorporate changes asked in SUN URS-0000 (Employee Master.pdf) Point No. 9].Start
									else if (relieveDate.trim().length() > 0)
									{
										count = 0;
										String ffsConfirmedVal = "";
										sql = "SELECT 1 AS CNT, CONFIRMED FROM FULLFINAL_HDR WHERE EMP_CODE = ? AND CASE WHEN CONFIRMED IS NULL THEN 'N' ELSE CONFIRMED END <> 'X'";
										pstmt = conn.prepareStatement(sql);
										pstmt.setString(1,empCodeLink);
										rs = pstmt.executeQuery();
										if(rs.next())
										{
											count = rs.getInt("CNT");
											ffsConfirmedVal = checkNull(rs.getString("CONFIRMED") , true);
										}
										System.out.println("FFS Count & Confirmed::::::::::: [" + count + "] [" + ffsConfirmedVal + "]");
										if ( rs != null )
										{
											rs.close();
											rs = null;
										}
										if ( pstmt != null )
										{
											pstmt.close();
											pstmt = null;
										}
										if (count == 0)
										{
											errList.add( "VEEMP6");
											errFields.add( childNodeName.toLowerCase() );
											
											msgType =  errorType( conn , "VEEMP6" );
											if ( msgType.equalsIgnoreCase("E"))
											{
												break;
											}
										}
										else if (!ffsConfirmedVal.equalsIgnoreCase("Y"))
										{
											errList.add( "VEEMP7");
											errFields.add( childNodeName.toLowerCase() );
											
											msgType =  errorType( conn , "VEEMP7" );
											if ( msgType.equalsIgnoreCase("E"))
											{
												break;
											}
										}
									}
									// Modified by Piyush on 07/11/2014 [To incorporate changes asked in SUN URS-0000 (Employee Master.pdf) Point No. 9].End
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("func_group"))
						{
							count = 0;
							//funcGroup = checkNull(getColumnValue("func_group",dom,objContext));
							funcGroup = checkNull(genericUtility.getColumnValue("func_group",dom,objContext),false);
							if(funcGroup != null && funcGroup.length() >0)
							{
								sql= "SELECT COUNT(*) AS COUNT FROM DEPARTMENT WHERE DEPT_CODE = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,funcGroup);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									count = rs.getInt("COUNT");
								}
								System.out.println("Value of count  :::::::::::"+count);
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								if(count == 0)
								{
									System.out.println("Department does not present :::::::::");
									
									errList.add( "VMEMPFGRP1");
									errFields.add( childNodeName.toLowerCase() );
									
									msgType =  errorType( conn , "VMEMPFGRP1" );
									if ( msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("parent_dept"))
						{
							count = 0;
							//parentDept = checkNull(getColumnValue("parent_dept",dom,objContext));
							parentDept = checkNull(genericUtility.getColumnValue("parent_dept",dom,objContext),false);
							if(parentDept != null && parentDept.length() >0)
							{
								sql= "SELECT COUNT(*) AS COUNT FROM DEPARTMENT WHERE DEPT_CODE = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,parentDept);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									count = rs.getInt("COUNT");
								}
								System.out.println("Value of count  :::::::::::"+count);
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								if(count == 0)
								{
									System.out.println("Department does not present :::::::::");
									
									errList.add( "VMEMPPDPT1");
									errFields.add( childNodeName.toLowerCase() );
									
									msgType =  errorType( conn , "VMEMPPDPT1" );
									if ( msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("dept_code"))
						{
							count = 0;
							deptCode = checkNull(getColumnValue("dept_code",dom,objContext));
							sql= "SELECT COUNT(*) AS COUNT FROM DEPARTMENT WHERE DEPT_CODE = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,deptCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								count = rs.getInt("COUNT");
							}
							System.out.println("Value of count  :::::::::::"+count);
							if ( rs != null )
							{
								rs.close();
								rs = null;
							}
							if ( pstmt != null )
							{
								pstmt.close();
								pstmt = null;
							}
							if(count == 0)
							{
								System.out.println("Department does not present :::::::::");
								
								errList.add( "VMDEP1");
								errFields.add( childNodeName.toLowerCase() );
								
								msgType =  errorType( conn , "VMDEP1" );
								if ( msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							else
							{
								sql = "SELECT STATUS FROM DEPARTMENT WHERE DEPT_CODE = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,deptCode);
								rs = pstmt.executeQuery();
								String status = "";
								if(rs.next())
								{
									status = checkNull(rs.getString("STATUS"));
								}
								System.out.println("status :::::::::::"+status);
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								if(status.equalsIgnoreCase("I"))
								{
									System.out.println("Department status Inactive:::::");
									
									errList.add( "VTDPINAC");
									errFields.add( childNodeName.toLowerCase() );
									
									msgType =  errorType( conn , "VTDPINAC" );
									if ( msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("cadre_code"))
						{
							count = 0;
							cadreCode = checkNull(getColumnValue("cadre_code",dom,objContext));
							sql= "SELECT COUNT(*) AS COUNT FROM CADRE WHERE CADRE_CODE = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,cadreCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								count = rs.getInt("COUNT");
							}
							System.out.println("Value of count  :::::::::::"+count);
							if ( rs != null )
							{
								rs.close();
								rs = null;
							}
							if ( pstmt != null )
							{
								pstmt.close();
								pstmt = null;
							}
							if(count == 0)
							{
								System.out.println("Cadre Code does not present :::::::::");
								
								errList.add( "VMCAD1");
								errFields.add( childNodeName.toLowerCase() );
								
								msgType =  errorType( conn , "VMCAD1" );
								if ( msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("grade_code"))
						{
							count = 0;
							gradeCode = checkNull(getColumnValue("grade_code",dom,objContext));
							sql= "SELECT COUNT(*) AS COUNT FROM GRADE WHERE GRADE_CODE = ?  ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,gradeCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								count = rs.getInt("COUNT");
							}
							System.out.println("Value of count  :::::::::::"+count);
							if ( rs != null )
							{
								rs.close();
								rs = null;
							}
							if ( pstmt != null )
							{
								pstmt.close();
								pstmt = null;
							}
							if(count == 0)
							{
								System.out.println("Grade Code does not present :::::::::");
								
								errList.add( "VMGRA1");
								errFields.add( childNodeName.toLowerCase() );
								
								msgType =  errorType( conn , "VMGRA1" );
								if ( msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("design_code"))
						{
							count = 0;
							//designCode = checkNull(getColumnValue("design_code",dom,objContext));
							designCode = checkNull(genericUtility.getColumnValue("design_code",dom,objContext),false);
							if(designCode !=null && designCode.length() > 0)
							{
								sql= "SELECT COUNT(*) AS COUNT FROM DESIGNATION WHERE DESIGN_CODE = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,designCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									count = rs.getInt("COUNT");
								}
								System.out.println("Value of count  :::::::::::"+count);
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								if(count == 0)
								{
									System.out.println("Designation does not present :::::::::");
									
									errList.add( "VMDESIGN");
									errFields.add( childNodeName.toLowerCase() );
									
									msgType =  errorType( conn , "VMDESIGN" );
									if ( msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
								else
								{
									sql = "SELECT STATUS FROM DESIGNATION WHERE DESIGN_CODE = ?  ";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1,designCode);
									rs = pstmt.executeQuery();
									String status = "";
									if(rs.next())
									{
										status = checkNull(rs.getString("STATUS"));
									}
									System.out.println("status :::::::::::"+status);
									if ( rs != null )
									{
										rs.close();
										rs = null;
									}
									if ( pstmt != null )
									{
										pstmt.close();
										pstmt = null;
									}
									if(status.equalsIgnoreCase("I"))
									{
										System.out.println("Designation status Inactive:::::");
										
										errList.add( "VTDGINAC");
										errFields.add( childNodeName.toLowerCase() );
										
										msgType =  errorType( conn , "VTDGINAC" );
										if ( msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
								}
						}
						else
						{
							if(designCode == null || designCode.length() == 0)
							{
								System.out.println("DesignCode isNull:::::");
								
								errList.add( "VMDESIGN2");
								errFields.add( childNodeName.toLowerCase() );
								
								msgType =  errorType( conn , "VMDESIGN2" );
								if ( msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("report_to"))
					{
						count = 0;
						//reportTo = checkNull(getColumnValue("report_to",dom,objContext));
						//empCode = checkNull(getColumnValue("emp_code",dom,objContext));
						reportTo = checkNull(genericUtility.getColumnValue("report_to",dom,objContext),false);
						empCode = checkNull(genericUtility.getColumnValue("emp_code",dom,objContext),false);
						if(reportTo !=null && reportTo.length() > 0)
						{	
							sql = "SELECT COUNT(*) AS COUNT FROM EMPLOYEE WHERE EMP_CODE = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,reportTo);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								count = rs.getInt("COUNT");
							}
							System.out.println("Value of count :::::::::::"+count);
							if ( rs != null )
							{
								rs.close();
								rs = null;
							}
							if ( pstmt != null )
							{
								pstmt.close();
								pstmt = null;
							}
							if(count == 0)
							{
								System.out.println("Employee does not present in Employee master :::::::::");
								
								errList.add( "VMEMP1");
								errFields.add( childNodeName.toLowerCase() );
								
								msgType =  errorType( conn , "VMEMP1" );
								if ( msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							else
							{
								sql = "SELECT STATUS FROM EMPLOYEE WHERE EMP_CODE = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,reportTo);
								rs = pstmt.executeQuery();
								String status = "";
								if(rs.next())
								{
									status = checkNull(rs.getString("STATUS"));
								}
								System.out.println("status :::::::::::"+status);
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								if(status.equalsIgnoreCase("S"))
								{
									System.out.println("Inside status of employee:::::");
									
									errList.add( "VMEMP2");
									errFields.add( childNodeName.toLowerCase() );
									
									msgType =  errorType( conn , "VMEMP2" );
									if ( msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
								else
								{
									if(reportTo.trim().equalsIgnoreCase(empCode.trim()))
									{
										System.out.println("inside reportTo.trim() == empCode.trim()");
										
										errList.add( "VMEMP4");
										errFields.add( childNodeName.toLowerCase() );
										
										msgType =  errorType( conn , "VMEMP4" );
										if ( msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
								}
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("report_to__admin"))
					{
						count = 0;
						//reportToAdmin = checkNull(getColumnValue("report_to__admin",dom,objContext));
						//empCode = checkNull(getColumnValue("emp_code",dom,objContext));
						reportToAdmin = checkNull(genericUtility.getColumnValue("report_to__admin",dom,objContext),false);
						empCode = checkNull(genericUtility.getColumnValue("emp_code",dom,objContext),false);
						if(reportToAdmin !=null && reportToAdmin.length() > 0)
						{	
							sql = "SELECT COUNT(*) AS COUNT FROM EMPLOYEE WHERE EMP_CODE = ?  ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,reportToAdmin);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								count = rs.getInt("COUNT");
							}
							System.out.println("Value of count :::::::::::"+count);
							if ( rs != null )
							{
								rs.close();
								rs = null;
							}
							if ( pstmt != null )
							{
								pstmt.close();
								pstmt = null;
							}
							if(count == 0)
							{
								System.out.println("Employee does not present in Employee master :::::::::");
								
								errList.add( "VMEMP1");
								errFields.add( childNodeName.toLowerCase() );
								
								msgType =  errorType( conn , "VMEMP1" );
								if ( msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							else if(reportToAdmin.trim().equalsIgnoreCase(empCode.trim()))
							{
								System.out.println("Inside reportToAdmin.trim() == empCode.trim()  :::::::::");
								
								errList.add( "VMEMPACD");
								errFields.add( childNodeName.toLowerCase() );
								
								msgType =  errorType( conn , "VMEMPACD" );
								if ( msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							else
							{
								sql = "SELECT RELIEVE_DATE FROM EMPLOYEE WHERE EMP_CODE = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,reportToAdmin);
								rs = pstmt.executeQuery();
								String relieveDate ="";
								if(rs.next())
								{
									relieveDate = checkNull(rs.getString("RELIEVE_DATE"));
								}
								System.out.println("relieveDate:::::::::::"+relieveDate);
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								if(relieveDate != null && relieveDate.trim().length() > 0)
								{
									System.out.println("relieveDate  exist ");
									
									errList.add( "VMEMPREL");
									errFields.add( childNodeName.toLowerCase() );
									
									msgType =  errorType( conn , "VMEMPREL" );
									if ( msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("pos_code"))
					{
						//posCode = checkNull(getColumnValue("pos_code",dom,objContext));
						posCode = checkNull(genericUtility.getColumnValue("pos_code",dom,objContext),false);
						empCode = checkNull(getColumnValue("emp_code",dom,objContext));
						deptCode = checkNull(getColumnValue("dept_code",dom,objContext));
						//errString = wf_val_pos(empCode , posCode , deptCode , null, conn);
						errString = validatePosition(empCode , posCode , deptCode , null, conn);
						if (errString.length() > 0)
						{
							errList.add(errString);
							errFields.add( childNodeName.toLowerCase() );
							
							msgType =  errorType( conn ,errString );
							
							if ( msgType.equalsIgnoreCase("E"))
							{
								break;
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("emp_code__hod"))
					{
						errString = "";
						//empCodeHod = checkNull(getColumnValue("emp_code__hod",dom,objContext));	
						empCodeHod = checkNull(genericUtility.getColumnValue("emp_code__hod",dom,objContext),false);	
						if(empCodeHod != null && empCodeHod.length() >0)
						{
							sql = "SELECT RELIEVE_DATE FROM EMPLOYEE WHERE EMP_CODE = ?  ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,empCodeHod);
							rs = pstmt.executeQuery();
							String relieveDate ="";
							if(rs.next())
							{
								relieveDate = checkNull(rs.getString("RELIEVE_DATE"));
							}
							else
							{
								errString = "VMEMP1";
							}
							System.out.println("relieveDate:::::::::::"+relieveDate);
							if ( rs != null )
							{
								rs.close();
								rs = null;
							}
							if ( pstmt != null )
							{
								pstmt.close();
								pstmt = null;
							}
							if (errString != null && errString.trim().length() > 0)
							{
								errList.add( errString);
								errFields.add( childNodeName.toLowerCase() );
								
								msgType =  errorType( conn , errString );
								if ( msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							 if(relieveDate != null && relieveDate.trim().length() > 0)
							{
								System.out.println("Inside relieveDate == null");
									
									errList.add( "VMEMPREL");
									errFields.add( childNodeName.toLowerCase() );
									
									msgType =  errorType( conn , "VMEMPREL" );
									if ( msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
					}
			}//End of case
			break;		
		}//End of Switch
			int errListSize = errList.size();
				if ( errList != null && errListSize > 0 )
				{
					for (cnt = 0; cnt < errListSize; cnt++ )
					{
						errCode = (String)errList.get(cnt);
						errFldName = (String)errFields.get(cnt);
						System.out.println("errCode .........."+errCode);
						
						errString = getErrorString( errFldName, errCode, userId );
						System.out.println("errString is : ::::>>>> " + errString);
						msgType =  errorType( conn , errCode );
						if ( errString.length() > 0)
						{
							String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8,errString.indexOf("<trace>"));
							bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8,errString.indexOf("</Errors>"));
							errStringXml.append(bifurErrString);
							System.out.println("errStringXml .........."+errStringXml);
							errString = "";
						}
						if ( msgType.equalsIgnoreCase("E"))
						{
							break;
						}
					}
					errList.clear();
					errList = null;
					errFields.clear();
					errFields = null;
					
					errStringXml.append("</Errors></Root>\r\n");
				}
				else
				{
					errStringXml = new StringBuffer( "" );
				}
				errString = errStringXml.toString();

		}
		catch(Exception e)
		{
			System.out.println( "Exception : [EmpBasicInfo][wfValData(String xmlString)] : ==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
	
		return errString;
	}
	//Start of wfValData End


	private String checkNull( String input )
	{
		if (input == null)
		{
			input = "";
		}
		else
		{
			input = input.trim();
		}
		return input;
	}

	private String checkNull( String input , boolean valueToBeTrimmed )
	{
		if (input == null)
		{
			input = "";
		}
		else if (valueToBeTrimmed)
		{
			input = input.trim();
		}
		return input;
	}

	private String getObjName(Document dom,String objContext)
	{	
		Node elementName = null;
		NodeList elementList = null;
		String objName = "";
		elementList = dom.getElementsByTagName("Detail"+objContext);
		elementName = elementList.item(0);
		if (elementName!=null && ("Detail"+objContext).equalsIgnoreCase(elementName.getNodeName()))
		{
			NamedNodeMap etlAttributes = elementName.getAttributes();
			if (etlAttributes!=null)
			{
				if (etlAttributes.getNamedItem("objName")!=null)
				{
					objName = etlAttributes.getNamedItem("objName").getNodeValue();
				}
			}
		}
		return objName;
	}

	private String errorType( Connection conn , String errorCode ) throws ITMException
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ? ";
			
			pstmt = conn.prepareStatement( sql );			
			pstmt.setString(1, errorCode);			
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex);
		}		
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}		
		return msgType;
	}

	//private String wf_val_pos(String empCode , String posCode , String deptCode , Date joinDate , Connection conn) throws ITMException
	private String validatePosition(String empCode , String posCode , String deptCode , Date joinDate , Connection conn) throws ITMException
	{
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String dbPosCode  =  "";
		java.util.Date dbJoinDate = null ;	
		String dbDeptCode = "";
		String tableno = "";
		String errString = "";
		String versionId = "";
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			if(posCode == null || posCode.length() == 0)
			{
				return "";
			}
			Date currentDate = new Date();
			SimpleDateFormat sdf = new SimpleDateFormat(getApplDateFormat());
			String curDate = sdf.format(currentDate);
			curDate = genericUtility.getValidDateTimeString(curDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			
			sql = "SELECT POS_CODE  AS  POS_CODE_OLD , DATE_JOIN  AS  JOIN_DATE_OLD ,  DEPT_CODE  AS  DEPT_CODE_OLD  FROM  EMPLOYEE  WHERE  EMP_CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,empCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				dbPosCode = checkNull(rs.getString("POS_CODE_OLD"));
				dbJoinDate = rs.getDate("JOIN_DATE_OLD");
				dbDeptCode = checkNull(rs.getString("DEPT_CODE_OLD"));
			}
			else
			{
				dbPosCode = null;
				dbJoinDate = null;
				dbDeptCode = null;
			}
			if( rs != null)
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			System.out.println("posCodeOld:::::::::"+dbPosCode);
			System.out.println("joinDateOld:::::::::"+dbJoinDate);
			System.out.println("deptCodeOld:::::::::"+dbDeptCode);
			if(dbJoinDate == null)
			{
				dbJoinDate = currentDate;
			}
			if(joinDate == null)
			{
				joinDate = dbJoinDate ;
			}
			if(dbPosCode == null || dbPosCode.trim().length() == 0 )
			{
				dbPosCode = "!";
			}
			if(dbDeptCode == null || dbDeptCode.trim().length() == 0 )
			{
				dbDeptCode = "!";
			}
			if(deptCode == null || deptCode.trim().length() == 0)
			{
				deptCode = dbDeptCode ;
			}
			if(!(dbPosCode.equalsIgnoreCase(posCode)) || dbJoinDate.compareTo(joinDate) > 0 || !(dbDeptCode.equalsIgnoreCase(deptCode)))
			{
				sql = "SELECT ITEM_SER AS TABLENO FROM DEPARTMENT WHERE DEPT_CODE = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,deptCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					tableno = checkNull(rs.getString("TABLENO"));
				}
				if( rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				System.out.println("tableno:::::::::"+tableno);
				if(tableno == null || tableno.length() == 0)
				{
					errString = "VMTBLNO";
				}
				sql = "SELECT VERSION_ID  FROM VERSION WHERE ? BETWEEN EFF_FROM AND VALID_UPTO ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setTimestamp(1,java.sql.Timestamp.valueOf(curDate));
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					versionId = checkNull(rs.getString("VERSION_ID"));
				}
				else
				{
					errString ="VERID";
				}
				if( rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				System.out.println("versionId:::::::::"+versionId);
				
				sql = "SELECT EMP_CODE AS EMP_CODE_ORG FROM ORG_STRUCTURE WHERE VERSION_ID = ? AND TABLE_NO = ? AND POS_CODE = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,versionId);
				pstmt.setString(2,tableno);
				pstmt.setString(3,posCode);
				rs = pstmt.executeQuery();
				String empCodeOrg = "";
				if(rs.next())
				{
					empCodeOrg = checkNull(rs.getString("EMP_CODE_ORG"));
				}
				else
				{
					errString = "NOPOS";
				}
				if( rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				System.out.println("empCodeOrg:::::::::"+empCodeOrg);
				if(( empCodeOrg != null && empCodeOrg.trim().length() > 0 ) && !(empCodeOrg.trim().equalsIgnoreCase(empCode.trim())))
				{
					errString = "POSNA";
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			errString = "DS000";
			throw new ITMException(e);
		}
		return errString ;
	}
	
}