package ibase.e12ria.e12widgets.client;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.TextBoxBase;

public class E12TextBox extends TextBoxBase
{
	  /**
	   * Creates simple text box .
	   */
	  private static int winScrollTop;
	  private static boolean isScroll = true;
	  private static boolean isFocus = false;
	  
	  public E12TextBox() {
		this(Document.get().createTextInputElement(), "gwt-TextBox");
		initEventHandlers();
	  }

	  /**
	   * Creates text box for given Input Type.
	   */
	  public E12TextBox(String inputType) {
	    this(createNumberInputElement(Document.get(), inputType), "gwt-TextBox");
	    initEventHandlers();
	  }

	  /**
	   * This constructor may be used by subclasses to explicitly use an existing
	   * element. This element must be an &lt;input&gt; element whose type is
	   * 'text'.
	   *
	   * @param element the element to be used
	   */
	  protected E12TextBox(Element element) {
	    super(element);
	    assert ( InputElement.as(element).getType().equalsIgnoreCase("text") || 
	    		 InputElement.as(element).getType().equalsIgnoreCase("number") || 
	    		 InputElement.as(element).getType().equalsIgnoreCase("time")  || 
	    		 InputElement.as(element).getType().equalsIgnoreCase("password") );
	  }

	  E12TextBox(Element element, String styleName) {
	    super(element);
	    if (styleName != null) {
	      setStyleName(styleName);
	    }
	  }

	  /**
	   * Gets the maximum allowable length of the text box.
	   *
	   * @return the maximum length, in characters
	   */
	  public int getMaxLength() {
	    return getInputElement().getMaxLength();
	  }

	  /**
	   * Gets the number of visible characters in the text box.
	   *
	   * @return the number of visible characters
	   */
	  public int getVisibleLength() {
	    return getInputElement().getSize();
	  }

	  /**
	   * Sets the maximum allowable length of the text box.
	   *
	   * @param length the maximum length, in characters
	   */
	  public void setMaxLength(int length) {
	    getInputElement().setMaxLength(length);
	  }

	  /**
	   * Sets the number of visible characters in the text box.
	   *
	   * @param length the number of visible characters
	   */
	  public void setVisibleLength(int length) {
	    getInputElement().setSize(length);
	  }

	  private InputElement getInputElement() {
	    return getElement().cast();
	  }
	  
	  public native static InputElement createNumberInputElement(Document doc, String type) /*-{
	    var e = doc.createElement("INPUT");
	    e.type = type;
	    return e;
	  }-*/;

	  
	//Added by Dnyaneshwar on 26-FEB-14 [ The FocusHandle and BlurHandle are created static for use in E12ListBox and E12DateBox classes ] Start
	public static FocusHandler focusHandler = new FocusHandler() 
	{
		
		@Override
		public void onFocus(FocusEvent event) 
		{
			print("onFocus Done!!!");
	    	setClassAttribute("MobileHeader", "outerHeader outerHeader-onFocus");
	    	setClassAttribute("MobileContents", "contents contents-onFocus");
	    	setClassAttribute("MobileFooter", "outerFooter outerFooter-onFocus");
	    	
	    	setClassAttribute( "MenuComponetHeader", "outerHeader outerHeader-onFocus" );
			setClassAttribute( "MenuComponetContents", "contents contents-onFocus" );
			setClassAttribute( "MenuComponetFooter", "outerFooter outerFooter-onFocus" );
			
			setClassAttribute( "PageComponentHeader", "outerHeader outerHeader-onFocus" );
			setClassAttribute( "PageComponentContents", "contents contents-onFocus" );
			setClassAttribute( "PageComponentFooter", "outerFooter outerFooter-onFocus" );
			winScrollTop = Window.getScrollTop();
			isScroll = false;
			isFocus = true;
		}
	};
	
	public static BlurHandler blurHandler = new BlurHandler()
	{
		
		@Override
		public void onBlur(BlurEvent event) 
		{
			isScroll = true;
			print("onBlur Done!!! winScrollTop["+winScrollTop+"]" );
			new Timer() {
				
				@Override
				public void run() {
					print("onBlur Timer Execute isScroll["+isScroll+"] isFocus["+isFocus+"]" );
					if( isScroll && isFocus )
					{
						Window.scrollTo(0, winScrollTop);
						setClassAttribute("MobileHeader", "outerHeader");
						setClassAttribute("MobileContents", "contents");
						setClassAttribute("MobileFooter", "outerFooter");
						
						setClassAttribute( "MenuComponetHeader", "outerHeader" );
						setClassAttribute( "MenuComponetContents", "contents" );
						setClassAttribute( "MenuComponetFooter", "outerFooter" );
						
						setClassAttribute( "PageComponentHeader", "outerHeader" );
						setClassAttribute( "PageComponentContents", "contents" );
						setClassAttribute( "PageComponentFooter", "outerFooter" );
						isFocus = false;
					}
				}
			}.schedule( 100 );
			
		}
	};
	//Added by Dnyaneshwar on 26-FEB-14 [ The FocusHandle and BlurHandle are created static for use in E12ListBox and E12DateBox classes ] Start
	  
	private void initEventHandlers() {
		
		addFocusHandler(focusHandler);
		addBlurHandler(blurHandler);
	}

	private static void setClassAttribute(String elemID, String className){
		Element element = DOM.getElementById( elemID );
		//print("setClassAttribute["+element+"]elemID["+elemID+"]className["+className+"]");
		if( element == null )
		{
			return;
		}
		element.setAttribute("class", className);
		//print("setClassAttribute Done!!!");
	};
	
	  private static native void print(String text) /*-{
		console.log(text);
	  }-*/;

}
