/*
 * Author:Wasim Ansari
 * Date: 13-OCT-15
 * Request ID: W15GSUN003
 * Description: Creating a scheduler for acknowledgement from AWMS and create or confirm stock transfer.
 */

package ibase.webitm.utility.wms;
import ibase.scheduler.utility.interfaces.Schedule;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.sql.*;

import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import ibase.webitm.ejb.*;
import ibase.webitm.ejb.dis.CreateDistIssue;
import ibase.webitm.ejb.dis.CreateDistOrder;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.dis.DistOrderClubBean;
import ibase.webitm.ejb.dis.DistStkUpdLocal;
import ibase.webitm.ejb.dis.InvAllocTraceBean;
import ibase.webitm.ejb.dis.InvHoldGen;
import ibase.webitm.ejb.dis.adv.InvHoldConf;
import ibase.webitm.ejb.dis.adv.StockTransferConf;
import ibase.webitm.ejb.wms.UploadOrderEJB;
import ibase.utility.E12GenericUtility;
import ibase.utility.CommonConstants;
import ibase.system.config.*;

public class ScheduleAWMSInOutTasks implements Schedule
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	DistCommon distComm = new DistCommon();

	public String schedulePriority(String wrkflwPriority)throws Exception
	{
		return "";
	}
	public String schedule(HashMap map)throws Exception
	{
		return "";
	}
	public String schedule(String scheduleParamXML)throws Exception
	{
		String siteCode = "";
		ibase.utility.UserInfoBean userInfo = null;
		String xtraParams = "";
		try
		{
			System.out.println("Schedule Param ["+scheduleParamXML+"]");
			userInfo = new ibase.utility.UserInfoBean(scheduleParamXML);
			siteCode = userInfo.getSiteCode();
			System.out.println("Site code = "+siteCode);
			xtraParams = "loginCode="+userInfo.getEmpCode()+"~~chgTerm="+userInfo.getRemoteHost()+"~~loginSiteCode="+siteCode;
			scheduleStockTransfer(siteCode,scheduleParamXML,xtraParams);
			System.out.println("Final Return from schedular");
		}
		catch(Exception e)
		{
			throw new Exception(e);
		}
		return "";
	}
	public String scheduleStockTransfer(String siteCode , String scheduleParamXML, String xtraParams) throws RemoteException,ITMException
	{
		Connection conn = null;
		ResultSet rs = null,rsInf = null;
		PreparedStatement pstmt = null, interfacePstmt = null,pstmtUpdate = null;	
		String errString = "", sql = "",inOut = "",refSer = "",refId = "",palletRej = "",sqlInf = "",tranId = "",sqlUpdate = "";
		boolean isScheduleReq = true,isError = false;
		int flag,countError;
		String lineNo = "";
		int caseCount = 0;

		try
		{
			ConnDriver connDriver = new ConnDriver(); 
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;
			conn.setAutoCommit(false);

			//sql = "SELECT DISTINCT REF_ID,REF_SER,IN_OUT,MSG_STAT FROM INTERFACE WHERE SYSDATE > TRANS_DT_ACK";
			sql = "SELECT DISTINCT REF_ID,REF_SER,IN_OUT FROM WMS_TO_HOST WHERE REF_ID IN "
					+ "(SELECT REF_ID FROM SWMS_TO_AWMS WHERE SCHEDULE_STATUS = 'N')";//Changed by wasim on 26-11-15 to schedule_status is null to N
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				try
				{
					refSer = checkNullAndTrim(rs.getString("REF_SER"));
					refId = checkNullAndTrim(rs.getString("REF_ID"));
					inOut = checkNullAndTrim(rs.getString("IN_OUT"));

					System.out.println("Schedullar going to schedule for refId["+refId+"]["+refSer+"]["+inOut+"]");

					HashMap interfaceHmap = new HashMap();
					interfaceHmap.put("REF_ID", refId);
					interfaceHmap.put("REF_SER", refSer);
					interfaceHmap.put("IN_OUT", inOut);


					if("D-SO".equalsIgnoreCase(refSer))
					{
						isScheduleReq = checkCountPalletReq(refId,conn);
						System.out.println("Count for D-S0="+isScheduleReq);
						if(isScheduleReq)
						{
							System.out.println("D-SO["+refId+"]can be schedule");
						}
						else
						{
							continue;
						}
					}

					if("P".equalsIgnoreCase(inOut))
					{	
						if(!"PZ".equalsIgnoreCase(refSer))
						{
							System.out.println("Schedullar going to inventory hold refId["+refId+"]["+refSer+"]["+inOut+"]");
							errString = inventoryHold(interfaceHmap, siteCode, xtraParams, conn);
						}
						else
						{
							sqlUpdate = " UPDATE SWMS_TO_AWMS SET SCHEDULE_STATUS = 'Y' WHERE REF_ID = ? AND "
									+" LINE_NO IN (SELECT LINE_NO FROM WMS_TO_HOST WHERE IN_OUT = 'P' AND REF_ID = ?)";
							pstmtUpdate = conn.prepareStatement(sqlUpdate);
							pstmtUpdate.setString(1, refId);
							pstmtUpdate.setString(2, refId);
							caseCount = pstmtUpdate.executeUpdate();
							System.out.println("Updated ="+caseCount);
							pstmtUpdate.close();pstmtUpdate = null;

							sqlUpdate = "UPDATE PALLET_HDR SET STATUS = 'R' WHERE TRAN_ID = ?";
							pstmtUpdate = conn.prepareStatement(sqlUpdate);
							pstmtUpdate.setString(1, refId);
							caseCount = pstmtUpdate.executeUpdate();
							System.out.println("Updated ="+caseCount);
							pstmtUpdate.close();pstmtUpdate = null;

							conn.commit();
						}
					}
					//if("I".equalsIgnoreCase(inOut) || "O".equalsIgnoreCase(inOut))//Changed by wasim on 11-01-2015 as component migrated to mobile wizard 
					if("I".equalsIgnoreCase(inOut) || "R".equalsIgnoreCase(inOut))
					{	
						System.out.println("Going for stock transfer refId["+refId+"]refSer["+refSer+"]inOut["+inOut+"]");
						errString = stockTransfer(interfaceHmap,xtraParams,conn);
					}	
				}
				catch(Exception ex)
				{
					System.out.println("Exception caught for refId["+refId+"] so rollbacking and going for next ref id");
					conn.rollback();
					StringWriter sw = new StringWriter();
					PrintWriter pw = new PrintWriter(sw);
					ex.printStackTrace(pw);
					writeLog(refId,sw.toString());
					continue;
				}
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
		}
		catch(Exception e)
		{
			isError = true;
			System.out.println("Exception caught");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("isError="+isError);
				if(isError)
				{
					conn.rollback();
				}
				else
				{
					conn.commit();
					//errString = itmDBAccessEJB.getErrorString("","VTCONPARM","","",conn);   
				}
				if(pstmt != null){pstmt.close();pstmt=null;}
				if(interfacePstmt != null){interfacePstmt.close();interfacePstmt=null;}
				if(pstmtUpdate != null){pstmtUpdate.close();pstmtUpdate=null;}
				if(rs != null){rs.close();rs=null;}
				if(rsInf != null){rsInf.close();rsInf=null;}
				if(conn != null){conn.close();conn=null;}
			}
			catch(Exception se)
			{
				throw new ITMException(se);
			}
		}
		System.out.println("Final return string" + errString);
		return errString;  	
	}

	private String stockTransfer(HashMap interfaceMap,String xtraParams,Connection conn) throws SQLException, ITMException
	{
		PreparedStatement pstmt=null, pstmtHdr = null, pstmtDet = null,pstmtInterface = null,pstmtUpdate = null,pstmtDso = null,pstmtQc = null;
		ResultSet rs = null,rsInterface = null,rsDso = null,rsQc = null;

		String sql = "",insertSql = "",tranID = "",loginSiteCode = "",userId = "",errString = "",sqlInterface = "",sqlUpdate = "",sqlDso = "",
				sqlQc = "",locCodeQuarnt = "",chgTerm = "",rePalltLocCodeTo = "";

		String refSer = "",refId = "",itemCode = "",lotNo = "",lotSl = "",acctCodeInv = "",cctrCodeInv = "",noArt = "",inOut = "",
				palletNo = "",locCodeTo = "",locCodeFrom = "",siteCode = "",lineNoInterface = "",qcOrderStatus = "",locCodeReturn = "";

		double quantity = 0,allocQty = 0,distOrderAlloc = 0,sordAllocQty = 0;
		int updCnt = 0,lineNo = 0,countDso = 0,countInLoc = 0;
		boolean checkRecord =false;//Added by Jagruti Shinde Req id:[W16GSUN005]

		//HashMap hashMap = new HashMap(); 

		loginSiteCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" );
		userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
		chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );

		boolean headerFlag = true;
		DistStkUpdLocal distStkUpd = null;

		ArrayList lineNoList = new ArrayList();
		ArrayList tranIdList = new ArrayList();
		ArrayList allocList = new ArrayList();
		ArrayList locationList = new ArrayList();
		ArrayList tranIdIssList = new ArrayList();
		ArrayList DistStkList = new ArrayList();

		boolean isRecordExist = false;
		boolean isStkConf = false;
		String remarks = "";

		try
		{
			System.out.println("Inside stock transfer");

			java.sql.Timestamp currDate = getCurrtDate();
			System.out.println("Current date for stock transfer is"+currDate);

			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDateStr = sdfAppl.format(currDate);

			refSer = (String) interfaceMap.get("REF_SER");
			refId = (String) interfaceMap.get("REF_ID");
			inOut = (String) interfaceMap.get("IN_OUT");

			if("PZ".equalsIgnoreCase(refSer))
			{
				sql = "SELECT P.ITEM_CODE,P.LINE_NO,P.QUANTITY,P.ALLOC_QTY,P.LOT_NO,P.LOT_SL,P.NO_ART,"
						+ " S.ACCT_CODE__INV,S.CCTR_CODE__INV, "
						+ "	P.LOC_CODE,P.SITE_CODE,P.PALLET_NO FROM PALLET_DET P,STOCK S WHERE TRAN_ID = ? AND P.LINE_NO = ?"
						+ " AND P.ITEM_CODE = S.ITEM_CODE AND P.SITE_CODE = S.SITE_CODE"
						+ " AND P.LOC_CODE = S.LOC_CODE AND P.LOT_NO = S.LOT_NO AND P.LOT_SL = S.LOT_SL AND  S.QUANTITY > 0";
			}
			else if("RPZ".equalsIgnoreCase(refSer))
			{
				sql = "SELECT S.ITEM_CODE,S.QUANTITY,S.LOT_NO,S.LOT_SL,S.LOC_CODE,S.ALLOC_QTY,P.NO_ART,"
						+" S.ACCT_CODE__INV,S.CCTR_CODE__INV, " 
						+" S.SITE_CODE FROM STOCK S,PALLET_REQ_DET P WHERE" 
						+" P.TRAN_ID = ? AND P.LINE_NO = ? AND"
					    +" (S.LOC_CODE = P.PALLET_NO OR S.LOC_CODE = ? OR S.LOC_CODE = ? OR S.LOC_CODE = ? OR S.LOC_CODE = ? OR S.LOC_CODE = ? OR S.LOC_CODE = ? OR S.LOC_CODE = ?) "
					    +" AND S.QUANTITY > 0"; 
			}
			
			insertSql = "INSERT INTO STOCK_TRANSFER_DET(TRAN_ID, LINE_NO, ITEM_CODE, QUANTITY, LOC_CODE__FR,"
					+ " LOC_CODE__TO, LOT_NO__FR, LOT_NO__TO, LOT_SL__FR, LOT_SL__TO, ACCT_CODE__CR, ACCT_CODE__DR,"
					+ " CCTR_CODE__DR, CCTR_CODE__CR, NO_ART) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			pstmtDet = conn.prepareStatement(insertSql);

			sqlInterface = "SELECT DISTINCT (LINE_NO),PALLET_NO,BAY_NO FROM WMS_TO_HOST WHERE REF_ID = ? "
					+ " AND LINE_NO IN (SELECT LINE_NO FROM SWMS_TO_AWMS WHERE REF_ID = ? AND SCHEDULE_STATUS = 'N')"
					+ " AND IN_OUT != 'P' ORDER BY LINE_NO";
			pstmtInterface = conn.prepareStatement(sqlInterface);
			pstmtInterface.setString(1, refId);
			pstmtInterface.setString(2, refId);
			rsInterface = pstmtInterface.executeQuery();
			while(rsInterface.next())
			{	
				if("PZ".equalsIgnoreCase(refSer))
				{
					isRecordExist = false;
				}
				
				lineNoInterface = checkNullAndTrim(rsInterface.getString("LINE_NO"));
				
				System.out.println("Line number is ["+lineNoInterface+"]");
				
				/*if(headerFlag)
				{	
					insertSql = "INSERT INTO STOCK_TRANSFER(TRAN_ID,TRAN_DATE,SITE_CODE,REF_SER__FOR,REF_ID__FOR,"+
							"REAS_CODE,ITEM_SER,CONFIRMED,"+
							"EMP_CODE__APRV,CHG_DATE,CHG_TERM,CHG_USER) "+
							"VALUES(?,?,?,?,?,?,?,?,?,?,?,?)";
					pstmtHdr = conn.prepareStatement(insertSql);
					tranID = generateTranTd("w_stock_transfer", currDateStr, loginSiteCode, conn);
					pstmtHdr.setString( 1, tranID );
					pstmtHdr.setTimestamp( 2, currDate );
					pstmtHdr.setString( 3, loginSiteCode );
					pstmtHdr.setString( 4, "XFRX");
					pstmtHdr.setString( 5, refId );
					pstmtHdr.setString( 6, "" );
					pstmtHdr.setString( 7, "" );
					pstmtHdr.setString( 8, "N" );
					pstmtHdr.setString( 9, "" );
					pstmtHdr.setTimestamp( 10, currDate );
					pstmtHdr.setString( 11, chgTerm );
					pstmtHdr.setString( 12, userId );
					updCnt = pstmtHdr.executeUpdate();
					pstmtHdr.close();
					pstmtHdr = null;
				}*/	

				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, refId);
				pstmt.setString(2, lineNoInterface);

				if("RPZ".equalsIgnoreCase(refSer))
				{
					locCodeQuarnt = checkNullAndTrim(rsInterface.getString("PALLET_NO"));
					rePalltLocCodeTo = checkNullAndTrim(rsInterface.getString("BAY_NO"));//Added by wasim on 12-01-2016
					pstmt.setString(3, locCodeQuarnt+"Q");
					pstmt.setString(4, locCodeQuarnt+"U");
					pstmt.setString(5, locCodeQuarnt+"P");
					pstmt.setString(6, locCodeQuarnt+"M");
					pstmt.setString(7, locCodeQuarnt+"X");
					pstmt.setString(8, locCodeQuarnt+"B");
					pstmt.setString(9, locCodeQuarnt+"S");
				}
				
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					isRecordExist = true;
					
					itemCode = checkNullAndTrim(rs.getString("ITEM_CODE"));
					quantity   = rs.getDouble("QUANTITY");
					lotNo  = checkNullAndTrim(rs.getString("LOT_NO"));
					lotSl  = checkNullAndTrim(rs.getString("LOT_SL"));
					siteCode  = checkNullAndTrim(rs.getString("SITE_CODE"));
					noArt  = checkNullAndTrim(rs.getString("NO_ART"));
					allocQty  = rs.getDouble("ALLOC_QTY");
					locCodeFrom  = checkNullAndTrim(rs.getString("LOC_CODE"));
					acctCodeInv  = checkNullAndTrim(rs.getString("ACCT_CODE__INV"));
					cctrCodeInv  = checkNullAndTrim(rs.getString("CCTR_CODE__INV"));
					
					//Changed by wasim on 15-07-2016 to insert site code as stock allocated site code [START] 
					if(headerFlag)
					{	
						insertSql = "INSERT INTO STOCK_TRANSFER(TRAN_ID,TRAN_DATE,SITE_CODE,REF_SER__FOR,REF_ID__FOR,"+
								"REAS_CODE,ITEM_SER,CONFIRMED,"+
								"EMP_CODE__APRV,CHG_DATE,CHG_TERM,CHG_USER) "+
								"VALUES(?,?,?,?,?,?,?,?,?,?,?,?)";
						pstmtHdr = conn.prepareStatement(insertSql);
						tranID = generateTranTd("w_stock_transfer", currDateStr, siteCode, conn);
						pstmtHdr.setString( 1, tranID );
						pstmtHdr.setTimestamp( 2, currDate );
						pstmtHdr.setString( 3, siteCode );
						pstmtHdr.setString( 4, "XFRX");
						pstmtHdr.setString( 5, refId );
						pstmtHdr.setString( 6, "" );
						pstmtHdr.setString( 7, "" );
						pstmtHdr.setString( 8, "N" );
						pstmtHdr.setString( 9, "" );
						pstmtHdr.setTimestamp( 10, currDate );
						pstmtHdr.setString( 11, chgTerm );
						pstmtHdr.setString( 12, userId );
						updCnt = pstmtHdr.executeUpdate();
						pstmtHdr.close();
						pstmtHdr = null;
					}
					//Changed by wasim on 15-07-2016 to insert site code as stock allocated site code [START] 
					
					if("PZ".equalsIgnoreCase(refSer))
					{
						System.out.println("Before location code TO is=["+locCodeTo+"]");
						
						System.out.println("countInLoc"+countInLoc);
						if(countInLoc == 0)
						{	
							locCodeTo  = checkNullAndTrim(rs.getString("PALLET_NO"));
							locCodeTo = getLocCodeTo(itemCode,lotNo,locCodeFrom,locCodeTo,siteCode,conn);
							System.out.println("Final location code TO is=["+locCodeTo+"]");
							countInLoc++;
						}	
					}
					else if("RPZ".equalsIgnoreCase(refSer))
					{
						locCodeTo  = rePalltLocCodeTo;
						//Changed by wasim on 13-07-2016 to get respected location code TO 
						locCodeTo = getLocCodeTo(itemCode,lotNo,locCodeFrom,locCodeTo,siteCode,conn);
					}
					System.out.println("Loc code to recieved=["+locCodeTo+"]Loc Code From["+locCodeFrom+"]");

					lineNo++;

					pstmtDet.setString( 1, tranID );
					pstmtDet.setInt( 2, lineNo );
					pstmtDet.setString( 3, itemCode );
					pstmtDet.setDouble( 4, quantity );
					pstmtDet.setString( 5, locCodeFrom );
					pstmtDet.setString( 6, locCodeTo );
					pstmtDet.setString( 7, lotNo );
					pstmtDet.setString( 8, lotNo );
					pstmtDet.setString( 9, lotSl );
					pstmtDet.setString( 10, lotSl );
					pstmtDet.setString( 11, acctCodeInv );
					pstmtDet.setString( 12, acctCodeInv );
					pstmtDet.setString( 13, cctrCodeInv );
					pstmtDet.setString( 14, cctrCodeInv );
					pstmtDet.setString( 15, noArt );

					updCnt = pstmtDet.executeUpdate();
					System.out.println("UPdate in stock transfer det="+updCnt);
					pstmtDet.clearParameters();

					System.out.println("@@Quantity=["+quantity+"]Alloc Qty=["+allocQty+"]");

					HashMap hashMap1 = new HashMap(); 
					hashMap1.put("tran_date", new java.sql.Date(System.currentTimeMillis()));
					hashMap1.put("ref_ser",refSer);
					hashMap1.put("ref_id", refId);
					hashMap1.put("ref_line", lineNoInterface);
					hashMap1.put("item_code", itemCode);
					hashMap1.put("site_code", siteCode);
					hashMap1.put("loc_code",locCodeFrom);
					hashMap1.put("lot_no",lotNo);
					hashMap1.put("lot_sl",lotSl);
					hashMap1.put("alloc_qty", (quantity-allocQty));
					hashMap1.put("chg_win","W_STOCK_TRANSFER_MULTI");
					hashMap1.put("chg_user", userId);
					hashMap1.put("chg_term", chgTerm);

					if("RPZ".equalsIgnoreCase(refSer))
					{	
						if((quantity-allocQty) > 0)
						{	 
							distStkUpd = getComponent("DistStkUpd");
							if (distStkUpd.updAllocTrace(hashMap1, conn) > 0)
							{
								System.out.println("distStkUpd.UpdAllocTrace(HashMap, Connection) : Sucessuful!");
							}
						}	
					}
					if("PZ".equalsIgnoreCase(refSer) || "RPZ".equalsIgnoreCase(refSer))
					{
						//HashMap allocation = new HashMap();
						ArrayList allocLocList = new ArrayList();

						System.out.println("Going for Allocation location code TO");
						HashMap hashMap = new HashMap(); 
						hashMap.put("tran_date", new java.sql.Date(System.currentTimeMillis()));
						hashMap.put("ref_ser",refSer);
						hashMap.put("ref_id", refId);
						hashMap.put("ref_line", lineNoInterface);
						hashMap.put("item_code", itemCode);
						hashMap.put("site_code", siteCode);
						hashMap.put("loc_code",locCodeTo);
						hashMap.put("lot_no",lotNo);
						hashMap.put("lot_sl",lotSl);
						hashMap.put("chg_win","W_STOCK_TRANSFER_MULTI");
						hashMap.put("chg_user", userId);
						hashMap.put("chg_term", chgTerm);

						if(("PZ".equalsIgnoreCase(refSer) || "RPZ".equalsIgnoreCase(refSer)) && allocQty > 0)
						{
							allocLocList = checkStockAllocation(siteCode,itemCode,lotNo,lotSl,locCodeFrom,locCodeTo,conn);
							hashMap.put("alloc_qty", allocQty);
							allocList.add(hashMap);
							locationList.add(allocLocList);
						}
					}

					sqlUpdate = "UPDATE SWMS_TO_AWMS SET SCHEDULE_STATUS = 'Y',REMARKS = '' WHERE REF_ID = ? AND LINE_NO = ?";
					pstmtUpdate = conn.prepareStatement(sqlUpdate);
					pstmtUpdate.setString(1, refId);
					pstmtUpdate.setString(2, lineNoInterface.trim());//this trim is for in case of S-ORD
					int caseCount = pstmtUpdate.executeUpdate();
					System.out.println("Updated ="+caseCount);
					pstmtUpdate.close();pstmtUpdate = null;

					if("RPZ".equalsIgnoreCase(refSer))
					{
						sqlUpdate = "UPDATE PALLET_REQ_DET SET STATUS = 'V' WHERE TRAN_ID = ? AND LINE_NO = ?";
						pstmtUpdate = conn.prepareStatement(sqlUpdate);
						pstmtUpdate.setString(1, refId);
						pstmtUpdate.setString(2, lineNoInterface);
						caseCount = pstmtUpdate.executeUpdate();
						System.out.println("Updated ="+caseCount);
						pstmtUpdate.close();pstmtUpdate = null;
					}

					headerFlag = false;
				}	
				pstmt.close();pstmt = null;
				rs.close();rs = null;

				if(("RPZ".equalsIgnoreCase(refSer)) && isRecordExist)
				{
					isStkConf = true;//Changed by wasim on 12-07-2016
					System.out.println("@@[RPZ] Error while stock transfer confirm"+isStkConf);
					
					System.out.println(" created successfully RPZ Case---------------["+tranID+"]refId["+refId);
					headerFlag = true;
					StockTransferConf stkConfAdd = new StockTransferConf();
					errString = stkConfAdd.confirm(tranID, xtraParams, "", conn, false);
					System.out.println("Stock transfer confirm for ===============RPZ="+errString);
					if( errString != null &&  errString.indexOf( "CONFSUCC" ) > -1)
					{
						errString = allocStockLocCodeTo(allocList,false,conn);
						System.out.println("Return from alloc To for RPZ="+errString);

						allocList.clear();//Changed by wasim on to clear list for PR/PRS as we take pallet one by one for this ref ser.

						if(errString != null &&  (errString.indexOf("CONFSTKSUCC") > -1))
						{
							System.out.println("Stock Transfer allocation on location code TO updated successfully");
							updateLocation(locationList,conn);
							locationList.clear();     //Changed by wasim on 08-12-2015 to clear list
							conn.commit();
						}
						else
						{
							throw new Exception (errString);
						}
					}
					else
					{
						//conn.rollback();
						throw new Exception (errString);
					}
				}
			}	
			pstmtInterface.close();pstmtInterface = null;
			rsInterface.close();rsInterface = null;

			if(isRecordExist && (!"RPZ".equalsIgnoreCase(refSer)))
			{
				isStkConf = true;//Changed by wasim on 12-07-2016
				System.out.println("@@[PZ] Error while stock transfer confirm"+isStkConf);

				//Changed by Jagruti Shinde Req id:[W16GSUN005][Start]
				System.out.println("Before checkCountPalletReq for--------------["+tranID+"]refId["+refId);
				checkRecord = checkCountPalletReq(refId,conn);
				System.out.println("Acknowlegement recieved for all items="+checkRecord);
				if(checkRecord)
				{
					System.out.println("Before StockTransferConf------------");//CONFSUCC
					StockTransferConf stkConf = new StockTransferConf();
					errString = stkConf.confirm(tranID, xtraParams, "", conn, false);
					System.out.println("After StockTransferConf-------------");

					System.out.println("Return String from stock transfer===="+errString);//CONFSUCC

					if( errString != null &&  errString.indexOf( "CONFSUCC" ) > -1)
					{
						errString = allocStockLocCodeTo(allocList,false,conn);
						System.out.println("Return from alloc To="+errString);

						if(errString != null &&  (errString.indexOf("CONFSTKSUCC") > -1))
						{	
							if ("PZ".equalsIgnoreCase(refSer))
							{
								updateLocation(locationList,conn);
								conn.commit();
								System.out.println("Stock Transfer for PZ completed successfully and committed");
							}
						}
						else
						{
							throw new Exception (errString);
						}
					}
					else
					{
						throw new Exception (errString);
					}
				}
				else
				{
					conn.commit();
					System.out.println("in else commit");
				}

				System.out.println("outside if else  block of checkRecord------------");//CONFSUC
				/*System.out.println("Inside record exist block------------");//CONFSUCC
			StockTransferConf stkConf = new StockTransferConf();
			errString = stkConf.confirm(tranID, xtraParams, "", conn, false);*/


				/*System.out.println("Return String from stock transfer===="+errString);//CONFSUCC

				if( errString != null &&  errString.indexOf( "CONFSUCC" ) > -1)
				{
					errString = allocStockLocCodeTo(allocList,false,conn);
					System.out.println("Return from alloc To="+errString);

					if(errString != null &&  (errString.indexOf("CONFSTKSUCC") > -1))
					{	
						if ("PZ".equalsIgnoreCase(refSer))
						{
							updateLocation(locationList,conn);
							conn.commit();
							System.out.println("Stock Transfer for PZ completed successfully and committed");
						}
					}
					else
					{
						throw new Exception (errString);
					}
				}
				else
				{
					throw new Exception (errString);
				}*/
				//Changed by Jagruti Shinde Req id:[W16GSUN005][END]
			}
			else
			{
				System.out.println("No data found in stock or Palletization detail is empty");
				conn.rollback();
			}
		}
		catch(Exception e)
		{
			System.out.println("Stock Transfer Catch Received");
			
			try
			{
				String logPath = "";
				System.out.println("Exception caught for refId["+refId+"] so rollbacking");
				conn.rollback();
				
				StringWriter sw = new StringWriter();
				PrintWriter pw = new PrintWriter(sw);
				e.printStackTrace(pw);
				logPath = writeLog(refId,sw.toString());
				
				//remarks = e.getMessage();
				//remarks = remarks.substring(remarks.indexOf("<description>") + 13 ,remarks.indexOf("</description>"));
				remarks = "Error occured while doing stock transfer, please check Log at "+logPath;
				
				System.out.println("Error while stock transfer conf="+isStkConf);
				if(isStkConf) //Error while stock transfer confirm
				{
					sqlUpdate = " UPDATE SWMS_TO_AWMS SET REMARKS = ? WHERE REF_ID = ?";
					pstmtUpdate = conn.prepareStatement(sqlUpdate);
					pstmtUpdate.setString(1, remarks);
					pstmtUpdate.setString(2, refId);
				}
				else
				{
					sqlUpdate = " UPDATE SWMS_TO_AWMS SET REMARKS = ? WHERE REF_ID = ? AND LINE_NO = ?";
					pstmtUpdate = conn.prepareStatement(sqlUpdate);
					pstmtUpdate.setString(1, remarks);
					pstmtUpdate.setString(2, refId);
					pstmtUpdate.setString(3, lineNoInterface);
				}
				pstmtUpdate.executeUpdate();
				conn.commit();
				
				pstmtUpdate.close();pstmtUpdate = null;
			}
			catch(Exception exc)
			{
				exc.printStackTrace();
			}
		}
		finally
		{
			try
			{
				if(pstmt != null){pstmt.close();pstmt = null;}
				if(pstmtHdr != null){pstmtHdr.close();pstmtHdr = null;}
				if(pstmtUpdate != null){pstmtUpdate.close();pstmtUpdate = null;}
				if(pstmtDet != null){pstmtDet.close();pstmtDet = null;}
				if(rs != null){rs.close();rs = null;}
				if(pstmtDso != null){pstmtDso.close();pstmtDso = null;}
				if(rsDso != null){rsDso.close();rsDso = null;}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		return errString;
	}
	private String inventoryHold(HashMap interfaceMap,String siteCode, String xtraParams,Connection conn) throws SQLException, ITMException
	{
		PreparedStatement pstmt= null,pstmtHold = null,pstmtHolddet = null,pstmtInterface= null,pstmtUpdate = null,pstmtDso = null;
		ResultSet rs = null,rsInterface = null,rsDso = null;

		String sql = "",loginSiteCode = "",userId = "",sqlInterface = "",sqlDso = "",chgTerm = "";
		int updCnt = 0,lineNo = 0,caseCount = 0,countDso = 0;

		String holdInsertSql = "",holddetInsertSql = "",invtranId = "",invLockDetsql = "",errString = "",sqlUpdate = "",locCodeQuarnt = "";

		String refSer = "",refId = "",itemCode = "",locCode = "",lotNo = "",lotSl = "";

		loginSiteCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" );
		userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
		chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );

		String lockCodeName = "AWMS_LOCK",lockCode = "",lineNoInterface = "",locCodeFrom = "",palletNo = "";
		boolean headerFlag = true;

		try
		{
			System.out.println("Inside inventory hold");

			java.sql.Timestamp currDate = getCurrtDate();
			System.out.println("Current date for inventory hold is"+currDate);

			lockCode = distComm.getDisparams("999999",lockCodeName,conn); 
			System.out.println("Lock code is ="+lockCode);

			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDateStr = sdfAppl.format(currDate);

			refSer = checkNullAndTrim((String) interfaceMap.get("REF_SER"));
			refId = checkNullAndTrim((String) interfaceMap.get("REF_ID"));
			//locCode = checkNullAndTrim((String) interfaceMap.get("PALLET_NO"));

			holddetInsertSql = "INSERT INTO INV_HOLD_DET(TRAN_ID,LINE_NO,ITEM_CODE,SITE_CODE,LOC_CODE,LOT_NO,LOT_SL,HOLD_STATUS,SCH_REL_DATE)"
					+ "	VALUES(?,?,?,?,?,?,?,?,?)";
			pstmtHolddet = conn.prepareStatement(holddetInsertSql);

			if("D-SO".equalsIgnoreCase(refSer))
			{
				/*sql = "SELECT ITEM_CODE,LINE_NO,QUANTITY,LOT_NO,LOT_SL,LOC_CODE,SITE_CODE__MFG AS SITE_CODE"
        				+ " FROM DISTORDER_ALLOC WHERE DIST_ORDER = ? AND LINE_NO = ?";*/
				sqlDso = "SELECT COUNT(*) AS COUNT FROM DISTORDER_ALLOC WHERE DIST_ORDER = ?";
				pstmtDso = conn.prepareStatement(sqlDso);
				pstmtDso.setString(1, refId);
				rsDso = pstmtDso.executeQuery();
				if(rsDso.next())
				{
					countDso = rsDso.getInt("COUNT");
				}
				if(pstmtDso != null){pstmtDso.close();pstmtDso = null;}
				if(rsDso != null){rsDso.close();rsDso = null;}

				System.out.println("Count DSO ="+countDso);

				if(countDso == 0)
				{
					sql = "SELECT D.ITEM_CODE,D.LINE_NO,D.QUANTITY,D.LOT_NO,D.LOT_SL,D.LOC_CODE,H.SITE_CODE"
							+" FROM DISTORD_ISSDET D,DISTORD_ISS H  WHERE D.TRAN_ID = H.TRAN_ID AND H.CONFIRMED = 'N' AND D.DIST_ORDER = ?"
							+" AND D.LINE_NO = ? AND D.QUANTITY > 0";
				}
				else
				{
					/*sql = "SELECT ITEM_CODE,LINE_NO,QUANTITY,LOT_NO,LOT_SL,LOC_CODE,SITE_CODE__MFG AS SITE_CODE"
							+ " FROM DISTORDER_ALLOC WHERE DIST_ORDER = ? AND LINE_NO = ?";*/
					sql = "SELECT S.ITEM_CODE,S.QUANTITY,S.LOT_NO,S.LOT_SL,S.LOC_CODE,H.SITE_CODE"
							//+" FROM DISTORDER_ALLOC D,DISTORDER H,STOCK S WHERE D.DIST_ORDER = ? AND D.LINE_NO = ?"
							//+" FROM DISTORDER_ALLOC D,DISTORDER H,STOCK S WHERE D.DIST_ORDER = ? AND D.LOC_CODE = ? AND D.LINE_NO = ?"
							+" FROM DISTORDER_ALLOC D,DISTORDER H,STOCK S WHERE D.DIST_ORDER = ? AND (D.LOC_CODE = ? OR D.LOC_CODE = ? OR D.LOC_CODE = ? OR D.LOC_CODE = ?) AND D.LINE_NO = ?"//Changed by wasim on 09-02-2016 to conside X location for D-SO/S-ORD
							+" AND D.DIST_ORDER = H.DIST_ORDER AND S.SITE_CODE = H.SITE_CODE AND S.ITEM_CODE = D.ITEM_CODE"
							+" AND S.LOC_CODE = D.LOC_CODE AND S.LOT_SL = D.LOT_SL AND S.LOT_NO = D.LOT_NO";
				}
			}
			else if("S-ORD".equalsIgnoreCase(refSer))
			{
				/*sql = "SELECT ITEM_CODE,LINE_NO,QUANTITY,LOT_NO,LOT_SL,LOC_CODE,"
						+ "SITE_CODE FROM SORDALLOC WHERE SALE_ORDER = ? AND LINE_NO = ?";*/
				sql = "SELECT S.ITEM_CODE,D.LINE_NO,S.QUANTITY,S.LOT_NO,S.LOT_SL,S.LOC_CODE,S.SITE_CODE"
				      +" FROM SORDALLOC D,SORDER H,STOCK S" 
				      +" WHERE D.SALE_ORDER = ? AND (D.LOC_CODE = ? OR S.LOC_CODE = ? OR D.LOC_CODE = ? OR D.LOC_CODE = ?) AND D.LINE_NO = ? AND S.QUANTITY > 0"
				      +" AND D.SALE_ORDER = H.SALE_ORDER"
					  +" AND D.LOT_NO = S.LOT_NO AND D.LOT_SL = S.LOT_SL"
					  +" AND D.ITEM_CODE = S.ITEM_CODE AND D.LOC_CODE = S.LOC_CODE AND D.SITE_CODE = S.SITE_CODE";//Changed by wasim on 09-02-2016 to conside X location for D-SO/S-ORD
			}
			else if("PZ".equalsIgnoreCase(refSer))
			{
				sql = "SELECT P.ITEM_CODE,P.LOT_NO,P.LOT_SL,"
						+ "	P.LOC_CODE,P.SITE_CODE,P.PALLET_NO FROM PALLET_DET P,STOCK S WHERE TRAN_ID = ? AND P.LINE_NO = ?"
						+ " AND P.ITEM_CODE = S.ITEM_CODE AND P.SITE_CODE = S.SITE_CODE AND S.QUANTITY > 0"
						+ " AND P.LOC_CODE = S.LOC_CODE AND P.LOT_NO = S.LOT_NO AND P.LOT_SL = S.LOT_SL";
			}
			else if("PR".equalsIgnoreCase(refSer))
			{
				//sql = "SELECT S.ITEM_CODE,S.LOT_NO,S.LOT_SL,S.LOC_CODE,"+
				sql = "SELECT S.ITEM_CODE,S.LOT_NO,S.LOT_SL,S.LOC_CODE,P.PALLET_NO,"+ //Changed by wasim on 08-12-2015 to TAKE loc code for PR/PRS as it will be pallet no 
						" S.SITE_CODE FROM STOCK S,PALLET_REQ_DET P WHERE " +
						" P.TRAN_ID = ? AND P.LINE_NO = ? AND S.QUANTITY > 0 AND "+
						" (S.LOC_CODE = P.PALLET_NO OR S.LOC_CODE = ? OR S.LOC_CODE = ? OR S.LOC_CODE = ? OR S.LOC_CODE = ? OR S.LOC_CODE = ? OR S.LOC_CODE = ? OR S.LOC_CODE = ?)";
			}
			else if("PRS".equalsIgnoreCase(refSer))
			{
				sql = "SELECT P.ITEM_CODE,P.QUANTITY,P.LOT_NO,P.LOT_SL,S.LOC_CODE,H.SITE_CODE,P.PALLET_NO"
						+" FROM PALLET_REQ_DET P,STOCK S,PALLET_REQ_HDR H WHERE P.TRAN_ID = ? AND P.LINE_NO = ?" 
						+" AND P.TRAN_ID = H.TRAN_ID "
						+" AND P.ITEM_CODE = S.ITEM_CODE AND H.SITE_CODE = S.SITE_CODE AND"
						+" (P.PALLET_NO = S.LOC_CODE OR S.LOC_CODE = ? OR S.LOC_CODE = ? OR S.LOC_CODE = ? OR S.LOC_CODE = ? OR S.LOC_CODE = ? OR S.LOC_CODE = ? OR S.LOC_CODE = ?) "
						+" AND P.LOT_NO = S.LOT_NO" 
						+" AND P.LOT_SL = S.LOT_SL AND S.QUANTITY > 0";
			}
			pstmt = conn.prepareStatement(sql);

			sqlInterface = "SELECT DISTINCT (LINE_NO),PALLET_NO FROM WMS_TO_HOST WHERE REF_ID = ? AND IN_OUT = 'P'" //Changed by wasim on 21-12-15 to change msg_stat to in_out = p 
					+ " AND LINE_NO IN (SELECT LINE_NO FROM SWMS_TO_AWMS WHERE REF_ID = ? AND SCHEDULE_STATUS = 'N')";//Changed by wasim on 26-11-15 to schedule_status is null to N
			pstmtInterface = conn.prepareStatement(sqlInterface);
			pstmtInterface.setString(1, refId);
			pstmtInterface.setString(2, refId);
			rsInterface = pstmtInterface.executeQuery();
			while(rsInterface.next())
			{
				
				locCodeFrom = checkNullAndTrim(rsInterface.getString("PALLET_NO"));
				palletNo = checkNullAndTrim(rsInterface.getString("PALLET_NO"));
				
				if("S-ORD".equalsIgnoreCase(refSer))//this is because sordalloc has char(3) in line_no
				{
					lineNoInterface = checkNullAndTrim(rsInterface.getString("LINE_NO"));
					lineNoInterface = "   " + lineNoInterface;
					lineNoInterface = lineNoInterface.substring( lineNoInterface.length()-3 );
				}
				else
				{
					lineNoInterface = checkNullAndTrim(rsInterface.getString("LINE_NO"));
				}
				System.out.println("Line no in inH["+lineNoInterface+"]");
				
				if(headerFlag)
				{	
					holdInsertSql = "INSERT INTO INV_HOLD(TRAN_ID,TRAN_DATE,SITE_CODE,CONFIRMED,REF_ID,REF_SER,CHG_USER,CHG_DATE,CHG_TERM, LOCK_CODE,REF_NO) "
							+ "VALUES(?,?,?,?,?,?,?,?,?,?,?)";
					pstmtHold = conn.prepareStatement(holdInsertSql);
					invtranId = generateTranTd("w_inv_hold",currDateStr, loginSiteCode, conn);

					pstmtHold.setString( 1, invtranId );
					pstmtHold.setTimestamp( 2, currDate);
					pstmtHold.setString( 3, siteCode );
					pstmtHold.setString( 4, "N" );
					pstmtHold.setString( 5, refId );
					pstmtHold.setString( 6, refSer );
					pstmtHold.setString( 7, userId );
					pstmtHold.setTimestamp( 8, currDate );
					pstmtHold.setString( 9, chgTerm );
					pstmtHold.setString( 10, lockCode );
					pstmtHold.setString( 11, "" );	
					updCnt = pstmtHold.executeUpdate();
					pstmtHold.clearParameters();
				}	

				pstmt.setString(1, refId);
				//pstmt.setString(2, lineNoInterface);
				if("D-SO".equalsIgnoreCase(refSer) && countDso > 0)
				{
					pstmt.setString(2, locCodeFrom);
					pstmt.setString(3, locCodeFrom+"X");
					pstmt.setString(4, locCodeFrom+"B");
					pstmt.setString(5, locCodeFrom+"P");
					pstmt.setString(6, lineNoInterface);//Changed by wasim on 09-02-2016 to consider X location for D-SO/S-ORD
				}
				else if("S-ORD".equalsIgnoreCase(refSer))
				{
					pstmt.setString(2, locCodeFrom);
					pstmt.setString(3, locCodeFrom+"X");
					pstmt.setString(4, locCodeFrom+"B");
					pstmt.setString(5, locCodeFrom+"P");
					pstmt.setString(6, lineNoInterface);//Changed by wasim on 09-02-2016 to consider X location for D-SO/S-ORD
				}
				else if("PR".equalsIgnoreCase(refSer) || "PRS".equalsIgnoreCase(refSer))
				{
					pstmt.setString(2, lineNoInterface);
					//locCodeQuarnt = checkNullAndTrim(rsInterface.getString("PALLET_NO"));
					pstmt.setString(3, locCodeFrom+"Q");
					pstmt.setString(4, locCodeFrom+"U");
					pstmt.setString(5, locCodeFrom+"P");
					pstmt.setString(6, locCodeFrom+"M");
					pstmt.setString(7, locCodeFrom+"X");
					pstmt.setString(8, locCodeFrom+"B");
					pstmt.setString(9, locCodeFrom+"S");
				}
				else
				{
					pstmt.setString(2, lineNoInterface);
				}
				
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					itemCode = checkNullAndTrim(rs.getString("ITEM_CODE"));
					lotNo  = checkNullAndTrim(rs.getString("LOT_NO"));
					lotSl  = checkNullAndTrim(rs.getString("LOT_SL"));
					locCode  = checkNullAndTrim(rs.getString("LOC_CODE"));
					siteCode  = checkNullAndTrim(rs.getString("SITE_CODE"));

					lineNo++;

					pstmtHolddet.setString( 1, invtranId );
					pstmtHolddet.setInt( 2, lineNo );
					pstmtHolddet.setString( 3, itemCode );
					pstmtHolddet.setString( 4, siteCode );
					pstmtHolddet.setString( 5, locCode );
					pstmtHolddet.setString( 6, lotNo );
					pstmtHolddet.setString( 7, lotSl );
					pstmtHolddet.setString( 8, "H" );
					pstmtHolddet.setTimestamp( 9, currDate);
					pstmtHolddet.addBatch();
					pstmtHolddet.clearParameters();
				}
				pstmtHolddet.executeBatch();
				pstmtHolddet.clearBatch();

				rs.close();rs = null;
				pstmt.clearParameters();

				//sqlUpdate = "UPDATE SWMS_TO_AWMS SET SCHEDULE_STATUS = 'Y' WHERE REF_ID = ? AND LINE_NO = ?";
				sqlUpdate = "UPDATE SWMS_TO_AWMS SET SCHEDULE_STATUS = 'Y' WHERE REF_ID = ? AND LINE_NO = ? AND PALLET_NO = ?";
				pstmtUpdate = conn.prepareStatement(sqlUpdate);
				pstmtUpdate.setString(1, refId);
				pstmtUpdate.setString(2, lineNoInterface.trim());
				pstmtUpdate.setString(3, palletNo);
				caseCount = pstmtUpdate.executeUpdate();
				System.out.println("Updated ="+caseCount);
				pstmtUpdate.close();pstmtUpdate = null;

				//if("PR".equalsIgnoreCase(refSer))//Changed by wasim on 19-11-2015 to add new ref ser PRS
				if("PR".equalsIgnoreCase(refSer) || "PRS".equalsIgnoreCase(refSer))
				{	
					sqlUpdate = "UPDATE PALLET_REQ_DET SET STATUS = 'R' WHERE TRAN_ID = ? AND LINE_NO = ?";
					pstmtUpdate = conn.prepareStatement(sqlUpdate);
					pstmtUpdate.setString(1, refId);
					pstmtUpdate.setString(2, lineNoInterface);
					caseCount = pstmtUpdate.executeUpdate();
					System.out.println("Updated ="+caseCount);
					pstmtUpdate.close();pstmtUpdate = null;
				}	
				headerFlag = false;
			}
			rsInterface.close();rsInterface = null;
			pstmtInterface.close();pstmtInterface = null;	

			InvHoldConf invHoldConf = new InvHoldConf();
			errString = invHoldConf.confirm( invtranId, xtraParams, "" , conn ,false);//VTCNFSUCC

			System.out.println("Return String from inventory holdr="+errString);
			if( errString != null &&  errString.indexOf( "VTCNFSUCC" ) > -1)
			{
				System.out.println("Inventory successfully go to hold and committed transaction"+invtranId);
				conn.commit();
				/*sql = "UPDATE INTERFACE2 SET SCHEDULE_STATUS = 'Y' WHERE REF_ID = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, refId);
				caseCount = pstmt.executeUpdate();
				System.out.println("Updated ="+caseCount);*/
			}
			else
			{
				throw new Exception(errString);
			}
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmtHold != null){pstmtHold.close();pstmtHold = null;}
				if(pstmtHolddet != null){pstmtHolddet.close();pstmtHolddet = null;}
				if(pstmt != null){pstmt.close();pstmt = null;}
				if(rs != null){rs.close();rs = null;}
			}
			catch(Exception ex)
			{
				throw new ITMException(ex); 
			}
		}
		return errString;
	}
	private String generateTranTd(String windowName,String tranDate,String siteCode, Connection  conn )throws ITMException
	{		
		System.out.println("inside generateTranTd@@.........");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String tranId = "";
		String newKeystring = "",tranSer1 = "",keyString = "",keyCol = "";
		CommonConstants commonConstants = new CommonConstants();
		try
		{		 	
			sql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, windowName);

			rs = pstmt.executeQuery();
			System.out.println("keyString :"+sql);

			if (rs.next())
			{
				keyString = rs.getString(1);
				keyCol = rs.getString(2);
				tranSer1 = rs.getString(3);
			}
			else
			{
				sql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, "GENERAL");
				rs = pstmt.executeQuery();
				System.out.println("keyString :"+sql);				
				if (rs.next())
				{
					keyString = rs.getString(1);
					keyCol = rs.getString(2);
					tranSer1 = rs.getString(3);
				}
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			System.out.println("keyString :"+keyString);
			System.out.println("keyCol :"+keyCol);
			System.out.println("tranSer1 :"+tranSer1);
			String xmlValues = "";
			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +	"<tran_id></tran_id>";
			xmlValues = xmlValues + "<site_code>" + siteCode + "</site_code>";
			xmlValues = xmlValues + "<tran_date>"+ tranDate + "</tran_date>";
			xmlValues = xmlValues + "<tran_type>"+"U"+"</tran_type>";
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", commonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer1, keyCol, keyString, conn);

			System.out.println("tranId ::"+tranId);
		}
		catch (SQLException ex)
		{			
			System.out.println("Exception ::" +sql+ ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{		
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}

		return tranId;
	}
	private ArrayList checkStockAllocation(String siteCode,String itemCode,String lotNo,String lotSl,String locCodeFrom,String locCodeTo,Connection conn)  throws ITMException, Exception
	{
		String sqlSordAlloc = "",sqlDisorderAlloc = "",sqlDistIss = "",locCodeReturn = "",tranId = "",expLev = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "",scheduleStatus = "",tableName = "",lineNo = "",refSer = "",id = "";
		double quantity = 0;
		boolean flag = false;
		ArrayList allocLocList = new ArrayList();
		try
		{
			System.out.println("inside checkStockAllocation");

			sql = "SELECT EXP_LEV,SALE_ORDER,LOC_CODE,QUANTITY,LINE_NO FROM SORDALLOC WHERE SITE_CODE = ? AND ITEM_CODE = ? AND LOT_NO = ? AND LOT_SL = ?" 
					+" AND LOC_CODE = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode);
			pstmt.setString(2, itemCode);
			pstmt.setString(3, lotNo);
			pstmt.setString(4, lotSl);
			pstmt.setString(5, locCodeFrom);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				tranId = checkNullAndTrim(rs.getString("SALE_ORDER"));
				locCodeReturn = checkNullAndTrim(rs.getString("LOC_CODE"));
				quantity = rs.getDouble("QUANTITY");
				//lineNo = checkNullAndTrim(rs.getString("LINE_NO"));//Changed by wasim on 11-01-2015 as sordalloc has char(3) line no
				lineNo = rs.getString("LINE_NO");
				expLev = rs.getString("EXP_LEV");
				
				tableName = "SORDALLOC";
				refSer = "S-ORD";
				id = "SALE_ORDER";
				flag = true;

				HashMap hm = new HashMap();
				hm.put("LOC_CODE_NEW", locCodeTo);
				hm.put("LOC_CODE_OLD", locCodeFrom);//Added by wasim on 20-01-2016
				hm.put("LOT_NO", lotNo);//Added by wasim on 20-01-2016
				hm.put("LOT_SL", lotSl);//Added by wasim on 20-01-2016
				hm.put("SITE_CODE", siteCode);//Added by wasim on 20-01-2016
				hm.put("ITEM_CODE", itemCode);//Added by wasim on 20-01-2016
				hm.put("EXP_LEV", expLev);
				
				hm.put("LINE_NO", lineNo);
				hm.put("TABLE", tableName);
				hm.put("TRAN_ID", tranId);
				hm.put("REF_SER", refSer);
				hm.put("ID", id);

				allocLocList.add(hm);
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;

			sql = "SELECT D.DIST_ORDER,D.LOC_CODE,D.QUANTITY,D.LINE_NO FROM DISTORDER_ALLOC D,DISTORDER H WHERE H.SITE_CODE = ? AND D.ITEM_CODE = ? "
					+ "AND D.LOT_NO = ? AND D.LOT_SL = ? AND D.LOC_CODE = ? AND H.DIST_ORDER = D.DIST_ORDER";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode);
			pstmt.setString(2, itemCode);
			pstmt.setString(3, lotNo);
			pstmt.setString(4, lotSl);
			pstmt.setString(5, locCodeFrom);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				tranId = checkNullAndTrim(rs.getString("DIST_ORDER"));
				locCodeReturn = checkNullAndTrim(rs.getString("LOC_CODE"));
				quantity = rs.getDouble("QUANTITY");
				lineNo = checkNullAndTrim(rs.getString("LINE_NO"));
				tableName = "DISTORDER_ALLOC";
				refSer = "D-SO";
				id = "DIST_ORDER";
				flag = true;

				HashMap hm = new HashMap();
				hm.put("LOC_CODE_NEW", locCodeTo);
				hm.put("LOC_CODE_OLD", locCodeFrom);//Added by wasim on 20-01-2016
				hm.put("LOT_NO", lotNo);//Added by wasim on 20-01-2016
				hm.put("LOT_SL", lotSl);//Added by wasim on 20-01-2016
				hm.put("SITE_CODE", siteCode);//Added by wasim on 20-01-2016
				hm.put("ITEM_CODE", itemCode);//Added by wasim on 20-01-2016
				hm.put("LINE_NO", lineNo);
				hm.put("TABLE", tableName);
				hm.put("TRAN_ID", tranId);
				hm.put("REF_SER", refSer);
				hm.put("ID", id);

				allocLocList.add(hm);
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;

			sql = "SELECT D.TRAN_ID,D.LOC_CODE,D.QUANTITY,D.LINE_NO FROM DISTORD_ISSDET D,DISTORD_ISS H WHERE H.SITE_CODE = ? AND D.ITEM_CODE = ? AND D.LOT_NO = ?" 
					+" AND D.LOT_SL = ? AND D.LOC_CODE = ? AND H.TRAN_ID = D.TRAN_ID";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode);
			pstmt.setString(2, itemCode);
			pstmt.setString(3, lotNo);
			pstmt.setString(4, lotSl);
			pstmt.setString(5, locCodeFrom);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				tranId = checkNullAndTrim(rs.getString("TRAN_ID"));
				locCodeReturn = checkNullAndTrim(rs.getString("LOC_CODE"));
				quantity = rs.getDouble("QUANTITY");
				lineNo = checkNullAndTrim(rs.getString("LINE_NO"));
				tableName = "DISTORD_ISSDET";
				refSer = "D-SO";
				id = "TRAN_ID";
				flag = true;

				HashMap hm = new HashMap();
				hm.put("LOC_CODE_NEW", locCodeTo);
				hm.put("LOC_CODE_OLD", locCodeFrom);//Added by wasim on 20-01-2016
				hm.put("LOT_NO", lotNo);//Added by wasim on 20-01-2016
				hm.put("LOT_SL", lotSl);//Added by wasim on 20-01-2016
				hm.put("SITE_CODE", siteCode);//Added by wasim on 20-01-2016
				hm.put("ITEM_CODE", itemCode);//Added by wasim on 20-01-2016
				hm.put("LINE_NO", lineNo);
				hm.put("TABLE", tableName);
				hm.put("TRAN_ID", tranId);
				hm.put("REF_SER", refSer);
				hm.put("ID", id);

				allocLocList.add(hm);
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;

			/*hm.put("LOC_CODE_NEW", locCodeTo);
			hm.put("LINE_NO", lineNo);
			hm.put("TABLE", tableName);
			hm.put("TRAN_ID", tranId);
			hm.put("REF_SER", refSer);
			hm.put("ID", id);*/
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt != null){pstmt.close();pstmt = null;}
				if(rs != null){rs.close();rs = null;}
			}
			catch(Exception ex)
			{
				throw new ITMException(ex);
			}
		}
		return allocLocList;
	}
	private String updateLocation(ArrayList locList,Connection conn)  throws ITMException, Exception
	{
		String sqlSordAlloc = "",sqlDisorderAlloc = "",sqlDistIss = "",locCodeReturn = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "",scheduleStatus = "",tableName = "",locCode = "",refSer = "",tranId = "",id = "",lineNo = "",locCodeOld = "";
		double quantity = 0;
		boolean flag = false;
		HashMap hm = new HashMap();
		String retString = "",lotNo = "",lotSl = "",siteCode = "",itemCode = "",expLev = "";
		int updCount = 0;
		try
		{
			System.out.println("inside updateLocation");

			Iterator itr = locList.iterator();
			System.out.println("Array Total size="+locList.size());

			while(itr.hasNext())
			{  
				ArrayList mainList = new ArrayList();
				mainList = (ArrayList) itr.next();

				Iterator itrMain = mainList.iterator();

				System.out.println("Main Array List size="+mainList.size());
				while(itrMain.hasNext())
				{
					HashMap detail = new HashMap();
					detail = (HashMap) itrMain.next();

					if(detail.size() > 0)
					{	  
						tableName = (String) detail.get("TABLE");
						locCode = (String) detail.get("LOC_CODE_NEW");
						
						locCodeOld = (String) detail.get("LOC_CODE_OLD");//Changed by wasim on 20-1-2016
						lotNo = (String) detail.get("LOT_NO");//Changed by wasim on 20-1-2016
						lotSl = (String) detail.get("LOT_SL");//Changed by wasim on 20-1-2016
						siteCode = (String) detail.get("SITE_CODE");//Changed by wasim on 20-1-2016
						itemCode = (String) detail.get("ITEM_CODE");//Changed by wasim on 20-1-2016
						
						lineNo = (String) detail.get("LINE_NO");
						refSer = (String) detail.get("REF_SER");
						tranId = (String) detail.get("TRAN_ID");
						id = (String) detail.get("ID");

						lineNo = "   " + lineNo;
						lineNo = lineNo.substring( lineNo.length()-3 );

						//sql = "UPDATE "+tableName+" SET LOC_CODE = ? WHERE "+id+" = ? AND LINE_NO = ?";
						System.out.println("Table["+tableName+"]");
						
						if("SORDALLOC".equalsIgnoreCase(tableName))
						{
							expLev = (String) detail.get("EXP_LEV");//Changed by wasim on 20-1-2016
							
							sql = "UPDATE "+tableName+" SET LOC_CODE = ? WHERE "+id+" = ? AND LINE_NO = ? AND LOC_CODE = ?"
									+ " AND LOT_NO = ? AND LOT_SL = ? AND  ITEM_CODE = ? AND EXP_LEV = ?";
						}
						else
						{
							sql = "UPDATE "+tableName+" SET LOC_CODE = ? WHERE "+id+" = ? AND LINE_NO = ? AND LOC_CODE = ?"
									+ " AND LOT_NO = ? AND LOT_SL = ? AND  ITEM_CODE = ?";
						}
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, locCode);
						pstmt.setString(2, tranId);
						pstmt.setString(3, lineNo);
						pstmt.setString(4, locCodeOld);
						
						pstmt.setString(5, lotNo);
						pstmt.setString(6, lotSl);
						pstmt.setString(7, itemCode);
						if("SORDALLOC".equalsIgnoreCase(tableName))
						{
							pstmt.setString(8, expLev);
						}
						
						updCount = pstmt.executeUpdate();
						System.out.println("Update="+updCount);
						pstmt.clearParameters();
					}  
				}
			}	
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt != null){pstmt.close();pstmt = null;}
				if(rs != null){rs.close();rs = null;}
			}
			catch(Exception ex)
			{
				throw new ITMException(ex);
			}
		}
		return retString;
	}

	private String getCurrdateAppFormat() 
	{
		String s = "";
		E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{
			java.util.Date date = null;
			Timestamp timestamp = new Timestamp(System.currentTimeMillis());

			SimpleDateFormat simpledateformat = new SimpleDateFormat(genericUtility.getDBDateFormat());
			date = simpledateformat.parse(timestamp.toString());
			timestamp = Timestamp.valueOf(simpledateformat.format(date).toString() + " 00:00:00.0");
			s = new SimpleDateFormat(genericUtility.getApplDateFormat()).format(timestamp).toString();
		}
		catch (Exception localException)
		{
		}

		return s;
	}
	
	private  String getError(String saleOrder,String Code,Connection conn)  throws ITMException, Exception
	{
		String mainStr ="";
		try
		{
			String errString = "";
			errString =  new ITMDBAccessEJB().getErrorString("",Code,"","",conn);
			String begPart = errString.substring(0,errString.indexOf("<message>")+9);
			String endDesc = errString.substring(errString.indexOf("</description>"));
			mainStr= begPart+"Invalid Data"+"</message><description>";
			mainStr= mainStr+"Sale Order ["+saleOrder+""+endDesc;
			System.out.println("mainStr:::::::::::::::::: "+mainStr);
			begPart = null;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return mainStr;
	}
	private DistStkUpdLocal getComponent(String componentName)throws Exception
	{
		DistStkUpdLocal comp = null;
		try
		{
			System.out.println("Looking For Component.... :: " + componentName);
			AppConnectParm appConnect = new AppConnectParm();
			java.util.Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			comp = (DistStkUpdLocal)ctx.lookup("ibase/DistStkUpd/local"); // for ejb3
			//comp = distStkUpdHome.create();
			System.out.println(componentName+" Found.....");			
		}
		catch(Exception e)
		{
			throw e;
		}
		return comp;
	}
	private static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
	private String checkNull( String input )
	{
		if ( input == null )
		{
			input = "";
		}
		return input;
	}
	private java.sql.Timestamp getCurrtDate() throws RemoteException,ITMException 
	{
		String currAppdate = "";
		java.sql.Timestamp currDate = null;
		try 
		{
			Object date = null;
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(genericUtility.getDBDateFormat());
			date = sdf.parse(currDate.toString());
			currDate = java.sql.Timestamp.valueOf(sdf.format(date).toString()+ " 00:00:00.0");

		} 
		catch (Exception e) 
		{
			throw new ITMException(e);
		}
		return (currDate);
	}
	//private String allocStockLocCodeTo(ArrayList stkList,ArrayList tranIdIssList,String refSer,String refId,int countDso,Connection conn)  throws ITMException, Exception
	//private String allocStockLocCodeTo(ArrayList stkList,Connection conn)  throws ITMException, Exception
	private String allocStockLocCodeTo(ArrayList stkList,boolean deallocFlag,Connection conn)  throws ITMException, Exception
	{
		String result = "",locCodeTo = "",sqlUpdate = "",tranIdList = "",deallocQty = "";
		PreparedStatement pstmt=null;
		ResultSet rs = null;
		DistStkUpdLocal distStkUpd = null;
		int count = 0;
		int cntList = 0;
		double allocQty = 0;
		boolean isError = false;
		try
		{
			System.out.println("Inside allocStockLocCodeTo");
			//System.out.println("Count DSO="+countDso);

			Iterator itr = stkList.iterator();
			System.out.println("Array List size="+stkList.size());

			if(stkList.size() > 0)
			{	
				while(itr.hasNext())
				{  
					HashMap detail = new HashMap();
					detail = (HashMap) itr.next();
					
					if(deallocFlag)
					{
						System.out.println("Inside deallocation alloc_qty");
						allocQty = (Double) detail.get("dealloc_qty");
						System.out.println("Final dealloc quantity="+allocQty);
						detail.put("alloc_qty", allocQty);
					}

					distStkUpd = getComponent("DistStkUpd");
					if (distStkUpd.updAllocTrace(detail, conn) > 0)
					{
						System.out.println("distStkUpd.UpdAllocTrace(HashMap, Connection) : Sucessuful!="+count);
					}
					count++;
				}
			} 

			/*if("D-SO".equalsIgnoreCase(refSer) && countDso == 0)
				{
			    	locCodeTo  = distComm.getDisparams("999999",refSer,conn); 

			    	while(cntList < tranIdIssList.size())
					{
						if(cntList != 0)
						{
							tranIdList = tranIdList + ",?";
						}
						else
						{
							tranIdList = tranIdList + "?";
						}
						cntList++;
					}
					System.out.println( "tranIdList ["+tranIdList+"]");

					sqlUpdate = "UPDATE DISTORD_ISSDET SET LOC_CODE = ? WHERE TRAN_ID IN ("+tranIdList+")";
					pstmt = conn.prepareStatement(sqlUpdate);
					pstmt.setString(1, locCodeTo);

					for(cntList=0 ; cntList<tranIdIssList.size(); cntList++)
					{
						System.out.println( "tranId ["+(String)tranIdIssList.get(cntList)+"]");
						pstmt.setString( (cntList+2), (String)tranIdIssList.get(cntList));
					}

					System.out.println("CNT List count ["+cntList+"]");
					int upctr = pstmt.executeUpdate();	
					System.out.println("NO OF ROW UPDATED = "+upctr);
					pstmt.close();pstmt = null;
				}*/
		}
		catch(Exception e)
		{
			isError = true;
			System.out.println("Catch allocStockLocCodeTo");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(isError)
				{
					result = "ERROR";
				}
				else
				{
					result = "CONFSTKSUCC";
				}
				if(pstmt != null){pstmt.close();pstmt = null;}
				if(rs != null){rs.close();rs = null;}
			}
			catch(Exception ex)
			{
				throw new ITMException(ex);
			}
		}
		return result;
	}
	
	//public void writeLog(String refId,String errString) throws Exception
	public String writeLog(String refId,String errString) throws Exception
	{
		FileOutputStream fos1 = null;
		String fileName = "",logPath = "";
		
		final Logger logger = Logger.getLogger(ScheduleAWMSInOutTasks.class.getName());
		try
		{
			fileName = "AWMS_"+refId;

			System.out.println("Schdular Log Name is ="+fileName);

			File dir = new File ( CommonConstants.JBOSSHOME + File.separator + "log" );
			if(!dir.exists())
			{
				dir.mkdirs();
			}
			File file1 = new File( dir ,fileName);
			file1.createNewFile();

			System.out.println("PATH123 :"+file1.getAbsolutePath());

			Handler fh = new FileHandler(file1.getAbsolutePath(), true);
			fh.setFormatter(new SimpleFormatter());  // Set the log format								
			logger.addHandler(fh);								
			logger.setLevel(Level.FINE);								
			logger.log(Level.SEVERE, errString, errString);								
			fh.flush();
			fh.close();	
			
			logPath = file1.getAbsolutePath();
		}
		catch(Exception e)
		{
			throw new Exception(e);
		}
		return logPath;
	}
	private boolean checkCountPalletReq(String refId,Connection conn)  throws ITMException, Exception
	{
		boolean result = false;
		int countWms = 0;
		int countAWms = 0;
		PreparedStatement pstmt=null;
		ResultSet rs = null;
		String sql = "",scheduleStatus = "";
		try
		{
			sql = "SELECT COUNT(*) AS COUNT FROM SWMS_TO_AWMS WHERE REF_ID = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, refId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				countWms = rs.getInt("COUNT");
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;

			sql = "SELECT COUNT(*) AS COUNT FROM WMS_TO_HOST WHERE REF_ID = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, refId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				countAWms = rs.getInt("COUNT");
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;

			System.out.println("Count WMS is="+countWms);
			System.out.println("Count AWMS is="+countAWms);

			if(countWms == countAWms)
			{
				return true;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt != null){pstmt.close();pstmt = null;}
				if(rs != null){rs.close();rs = null;}
			}
			catch(Exception ex)
			{
				throw new ITMException(ex);
			}
		}
		return result;
	}
	
	private String getLocCodeTo(String itemCode,String lotNo,String locCodeFrom,String locCodeTo,String siteCode,Connection conn)  throws ITMException, Exception
	{
		String itemSerRg = "",locGroup = "",QcStatus = "",exempted = "",locCodeToReturn = "",itemSerRgDisparm = "";
		PreparedStatement pstmt=null;
		ResultSet rs = null;
		String sql = "",sqlQcOrder= "",sqlOtherSite ="",available ="";//Changed by Jagruti Shinde  Request Id:[W16FSUN009]
		int countQcOrder = 0;
		try
		{
			exempted = checkNullAndTrim(distComm.getDisparams("999999", "EXTEMP_LOC_PARM" , conn));
			itemSerRgDisparm = checkNullAndTrim(distComm.getDisparams("999999", "ITEM_SER_RG1" , conn));
			
			System.out.println("ITEM_SER_RG1 found from disparm["+itemSerRgDisparm+"]");
			System.out.println("Exempted found from disparm["+exempted+"]");
			//sql = "SELECT LOC_GROUP FROM LOCATION WHERE LOC_CODE = ? AND SITE_CODE = ?";//Changed by wasim on 19-02-2016 as site code not required 
			sql = "SELECT LOC_GROUP FROM LOCATION WHERE LOC_CODE = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, locCodeFrom);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				locGroup = checkNullAndTrim(rs.getString("LOC_GROUP"));
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
			System.out.println("Location group found from location["+locGroup+"]");


			String[] exp = exempted.split(",");
			String disparmExemp = "";
			boolean exempFlag = false;

			System.out.println("Exemp Disparm Lenght="+exp.length);
			for (int j = 0; j < exp.length; j++) 
			{
				disparmExemp = exp[j].trim();
				System.out.println("item ser rg1 disparm=["+disparmExemp+"] and site item rg1["+locGroup+"]");

				if(disparmExemp.equalsIgnoreCase(locGroup))
				{
					System.out.println("****Match found in disparm for"+locGroup);
					exempted = locGroup;
					exempFlag = true;
					break;
				}
				else
				{
					System.out.println("****Match not found****");
				}
			}
			System.out.println("####Final flag for Exempted="+exempFlag);

			sql = "SELECT ITEM_SER__RG1 FROM SITEITEM WHERE ITEM_CODE = ? AND SITE_CODE = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, itemCode);
			pstmt.setString(2, siteCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				itemSerRg = checkNullAndTrim(rs.getString("ITEM_SER__RG1"));
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
			System.out.println("Item series RG found from item["+itemSerRg+"]");

			String[] rg1 = itemSerRgDisparm.split(",");
			String disparmRg1 = "";
			boolean flag = false;

			System.out.println("Disparm Lenght="+rg1.length);
			for (int x = 0; x < rg1.length; x++) 
			{
				disparmRg1 = rg1[x].trim();
				System.out.println("item ser rg1 disparm=["+disparmRg1+"] and site item rg1["+itemSerRg+"]");

				if(disparmRg1.equalsIgnoreCase(itemSerRg))
				{
					System.out.println("****Match found in disparm for"+itemSerRg);
					itemSerRgDisparm = itemSerRg;
					flag = true;
					break;
				}
				else
				{
					System.out.println("****Match not found****");
				}
			}
			System.out.println("####Final flag for item ser rg1="+flag);

			sql = "SELECT STATUS FROM QC_ORDER WHERE SITE_CODE = ? AND ITEM_CODE = ? AND LOT_NO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode);
			pstmt.setString(2, itemCode);
			pstmt.setString(3, lotNo);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				QcStatus = checkNullAndTrim(rs.getString("STATUS"));
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
			System.out.println("QC Status found from QC_ORDER1["+QcStatus+"]");

			if(QcStatus == null || QcStatus.length() == 0 || !"U".equalsIgnoreCase(QcStatus))
			{
				QcStatus = "NA";
			}
			//if(locGroup == null || locGroup.length() == 0 || !exempted.equalsIgnoreCase(locGroup))
			if(locGroup == null || locGroup.length() == 0 || !exempFlag)
			{
				locGroup = "NA";
			}
			//if(itemSerRg == null || itemSerRg.length() == 0 || !itemSerRgDisparm.equalsIgnoreCase(itemSerRg))
			if(itemSerRg == null || itemSerRg.length() == 0 || !flag)
			{
				itemSerRg = "NA";
			}

			//Changed by Jagruti Shinde for palletization stock transfer location should be check whether it is quarantine or approved if qc_order is created at one site and palletization is done on another side Request Id:[W16FSUN009].[Start]
			//sqlQcOrder="SELECT COUNT(*) FROM QC_ORDER WHERE SITE_CODE = ? AND ITEM_CODE = ? AND LOT_NO = ? AND STATUS = ? ";
			sqlQcOrder="SELECT COUNT(*) FROM QC_ORDER WHERE SITE_CODE = ? AND ITEM_CODE = ? AND LOT_NO = ? AND STATUS != ? ";
			pstmt = conn.prepareStatement(sqlQcOrder);
			pstmt.setString(1,siteCode);
			pstmt.setString(2,itemCode);
			pstmt.setString(3,lotNo);
			pstmt.setString(4,"C");
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				countQcOrder = rs.getInt(1);
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}

			if(countQcOrder > 0)
			{
				System.out.println("countQcOrder is greter than 0:::"+countQcOrder);
				//Changed by Jagruti Shinde for palletization stock transfer location should be check whether it is quarantine or approved if qc_order is created at one site and palletization is done on another side Request Id:[W16FSUN009].[End]

				System.out.println("********Loc Group["+locGroup+"]Item RG1["+itemSerRg+"]QC Status["+QcStatus+"]**********");

				if(exempted.equalsIgnoreCase(locGroup) && itemSerRgDisparm.equalsIgnoreCase(itemSerRg) && "U".equalsIgnoreCase(QcStatus))
				{
					locCodeToReturn = locCodeTo + "U";
				}
				else if(exempted.equalsIgnoreCase(locGroup) && itemSerRgDisparm.equalsIgnoreCase(itemSerRg) && "NA".equalsIgnoreCase(QcStatus))
				{
					locCodeToReturn = locCodeTo + "P";
				}
				else if(exempted.equalsIgnoreCase(locGroup) && "NA".equalsIgnoreCase(itemSerRg) && "U".equalsIgnoreCase(QcStatus))
				{
					locCodeToReturn = locCodeTo + "M";
				}
				else if(exempted.equalsIgnoreCase(locGroup) && "NA".equalsIgnoreCase(itemSerRg) && "NA".equalsIgnoreCase(QcStatus))
				{
					locCodeToReturn = locCodeTo + "X";
				}
				else if("NA".equalsIgnoreCase(locGroup) && itemSerRgDisparm.equalsIgnoreCase(itemSerRg) && "NA".equalsIgnoreCase(QcStatus))
				{
					locCodeToReturn = locCodeTo + "B";
				}
				else if("NA".equalsIgnoreCase(locGroup) && itemSerRgDisparm.equalsIgnoreCase(itemSerRg) && "U".equalsIgnoreCase(QcStatus))
				{
					locCodeToReturn = locCodeTo + "S";
				}
				else if("NA".equalsIgnoreCase(locGroup) && "NA".equalsIgnoreCase(itemSerRg) && "U".equalsIgnoreCase(QcStatus))
				{
					locCodeToReturn = locCodeTo + "Q";
				}
				else if("NA".equalsIgnoreCase(locGroup) && "NA".equalsIgnoreCase(itemSerRg) && "NA".equalsIgnoreCase(QcStatus))
				{
					locCodeToReturn = locCodeTo;
				}
				//Changed by Jagruti Shinde for palletization stock transfer location should be check whether it is quarantine or approved if qc_order is created at one site and palletization is done on another side Request Id:[W16FSUN009].[Start]
			}
			else
			{
				sqlOtherSite="SELECT AVAILABLE FROM INVSTAT WHERE INV_STAT IN (SELECT INV_STAT FROM LOCATION WHERE LOC_CODE = ?)";
				pstmt = conn.prepareStatement(sqlOtherSite);
				pstmt.setString(1, locCodeFrom);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					available = checkNullAndTrim(rs.getString("AVAILABLE"));
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs!=null)
				{
					rs.close();
					rs = null;
				}
				if("N".equalsIgnoreCase(available) && ("NA".equalsIgnoreCase(locGroup) && "NA".equalsIgnoreCase(itemSerRg)))
				{
					locCodeToReturn = locCodeTo + "Q";
					System.out.println("locCodeToReturn Q for available 'N':::::::"+locCodeToReturn);
				}
				
				else if("N".equalsIgnoreCase(available) && (exempted.equalsIgnoreCase(locGroup) && "NA".equalsIgnoreCase(itemSerRg)))
				{
					locCodeToReturn = locCodeTo + "M";
					System.out.println("locCodeToReturn M for available 'N':::::::"+locCodeToReturn);
				}
				else if("N".equalsIgnoreCase(available) && ("NA".equalsIgnoreCase(locGroup) && itemSerRgDisparm.equalsIgnoreCase(itemSerRg)))
				{
					locCodeToReturn = locCodeTo + "S";
					System.out.println("locCodeToReturn S for available 'N':::::::"+locCodeToReturn);
				}
				
				else if("Y".equalsIgnoreCase(available) && ("NA".equalsIgnoreCase(locGroup) && "NA".equalsIgnoreCase(itemSerRg)))
				{
					locCodeToReturn = locCodeTo;
					System.out.println("locCodeToReturn Normal for available 'Y':::::::"+locCodeToReturn);
				}
				else if("Y".equalsIgnoreCase(available) && (exempted.equalsIgnoreCase(locGroup) && "NA".equalsIgnoreCase(itemSerRg)))
				{
					locCodeToReturn = locCodeTo + "X";
					System.out.println("locCodeToReturn for X available 'Y':::::::"+locCodeToReturn);
				}
				else if("Y".equalsIgnoreCase(available) && ("NA".equalsIgnoreCase(locGroup) && itemSerRgDisparm.equalsIgnoreCase(itemSerRg)))
				{
					locCodeToReturn = locCodeTo + "B";
					System.out.println("locCodeToReturn for B available 'Y':::::::"+locCodeToReturn);
				}
			}
			//Changed by Jagruti Shinde for palletization stock transfer location should be check whether it is quarantine or approved if qc_order is created at one site and palletization is done on another side Request Id:[W16FSUN009].[End]
		}
		catch(Exception e)
		{
			System.out.println("Catch getLocCodeTo");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt != null){pstmt.close();pstmt = null;}
				if(rs != null){rs.close();rs = null;}
			}
			catch(Exception ex)
			{
				throw new ITMException(ex);
			}
		}
		System.out.println("Location code returing["+locCodeToReturn+"]");
		return locCodeToReturn;
	}

}

