import { Directive, Input } from '@angular/core';
import { NG_VALIDATORS } from '@angular/forms';
export class NumberValidator {
    constructor() {
        this.expression = /^\+?\d{2}[- ]?\d{3}[- ]?\d{5}$/;
        this.validation = false;
    }
    validate(c) {
        console.log('-------', c.value);
        if (!this.validation) {
            return null;
        }
        const isValidPassword = this.expression.test(c.value);
        const message = {
            'password': {
                'message': this.invalidMessage
            }
        };
        return isValidPassword ? null : message;
    }
}
NumberValidator.decorators = [
    { type: Directive, args: [{
                selector: '[number-validator]',
                providers: [
                    { provide: NG_VALIDATORS, useExisting: NumberValidator, multi: true }
                ]
            },] },
];
/** @nocollapse */
NumberValidator.ctorParameters = () => [];
NumberValidator.propDecorators = {
    'expression': [{ type: Input, args: ['expression',] },],
    'invalidMessage': [{ type: Input, args: ['invalidMessage',] },],
    'validation': [{ type: Input, args: ['validation',] },],
};
//# sourceMappingURL=number-validator.js.map