import { Directive, Input } from '@angular/core';
import { NG_VALIDATORS, } from '@angular/forms';
var TextAreaValidator = (function () {
    function TextAreaValidator() {
        this.bbRequired = false;
        this.requiredMessage = 'Please enter some text';
        this.invalidMessage = 'Please enter valid text';
    }
    TextAreaValidator.prototype.validate = function (control) {
        //console.log('this.invalidMessage'+this.invalidMessage);
        if (!control.value && this.bbRequired) {
            return { message: this.requiredMessage };
        }
        if (control.value) {
            var value = control.value.trim();
            if (this.invalidMessage) {
                return { message: this.invalidMessage };
            }
        }
        return null;
    };
    TextAreaValidator.decorators = [
        { type: Directive, args: [{
                    selector: '[text-area-validator]',
                    providers: [
                        { provide: NG_VALIDATORS, useExisting: TextAreaValidator, multi: true }
                    ]
                },] },
    ];
    /** @nocollapse */
    TextAreaValidator.ctorParameters = function () { return []; };
    TextAreaValidator.propDecorators = {
        'bbRequired': [{ type: Input, args: ['required',] },],
        'requiredMessage': [{ type: Input, args: ['requiredMessage',] },],
        'invalidMessage': [{ type: Input, args: ['invalidMessage',] },],
    };
    return TextAreaValidator;
}());
export { TextAreaValidator };
//# sourceMappingURL=text-area-validator.js.map