import { Directive, Input } from '@angular/core';
import { NG_VALIDATORS } from '@angular/forms';
var PasswordValidator = (function () {
    function PasswordValidator() {
        this.expression = /^(?=.*\d)(?=.*[!@#$%^&*])(?=.*[a-z])(?=.*[A-Z]).{8,}$/;
        this.validation = false;
    }
    PasswordValidator.prototype.validate = function (c) {
        console.log('-------', c.value);
        if (!this.validation) {
            return null;
        }
        var isValidPassword = this.expression.test(c.value);
        var message = {
            'password': {
                'message': this.invalidMessage
            }
        };
        return isValidPassword ? null : message;
    };
    PasswordValidator.decorators = [
        { type: Directive, args: [{
                    selector: '[password-validator]',
                    providers: [
                        { provide: NG_VALIDATORS, useExisting: PasswordValidator, multi: true }
                    ]
                },] },
    ];
    /** @nocollapse */
    PasswordValidator.ctorParameters = function () { return []; };
    PasswordValidator.propDecorators = {
        'expression': [{ type: Input, args: ['expression',] },],
        'invalidMessage': [{ type: Input, args: ['invalidMessage',] },],
        'validation': [{ type: Input, args: ['validation',] },],
    };
    return PasswordValidator;
}());
export { PasswordValidator };
//# sourceMappingURL=password-validator.js.map