import { Directive, Input } from '@angular/core';
import { NG_VALIDATORS } from '@angular/forms';
var NumberValidator = (function () {
    function NumberValidator() {
        this.expression = /^\+?\d{2}[- ]?\d{3}[- ]?\d{5}$/;
        this.validation = false;
    }
    NumberValidator.prototype.validate = function (c) {
        console.log('-------', c.value);
        if (!this.validation) {
            return null;
        }
        var isValidPassword = this.expression.test(c.value);
        var message = {
            'password': {
                'message': this.invalidMessage
            }
        };
        return isValidPassword ? null : message;
    };
    NumberValidator.decorators = [
        { type: Directive, args: [{
                    selector: '[number-validator]',
                    providers: [
                        { provide: NG_VALIDATORS, useExisting: NumberValidator, multi: true }
                    ]
                },] },
    ];
    /** @nocollapse */
    NumberValidator.ctorParameters = function () { return []; };
    NumberValidator.propDecorators = {
        'expression': [{ type: Input, args: ['expression',] },],
        'invalidMessage': [{ type: Input, args: ['invalidMessage',] },],
        'validation': [{ type: Input, args: ['validation',] },],
    };
    return NumberValidator;
}());
export { NumberValidator };
//# sourceMappingURL=number-validator.js.map