<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">

<html>

<body >
<script type="text/javascript" src="/ibase/webitm/js/sorderWizard.js"></script>	
<script type="text/javascript" src="/ibase/webitm/js/jquery-1.10.2.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-ui-1.10.4.custom.min.js"></script>
<link type="text/css" rel="stylesheet" href="/ibase/webitm/css/htmlWizard.css"/>
<link type="text/css" rel="stylesheet" href="/ibase/webitm/css/sorderWiz.css"/>
<link href="/ibase/webitm/css/DD/jquery-ui-1.10.4.custom.min.css" rel="stylesheet"/>

<script language="Javascript" src="/ibase/webitm/js/jquery.datetimepicker.full.js"></script>
<link type="text/css" rel="stylesheet" href="/ibase/webitm/css/jquery.datetimepicker.css"/>
<link href="/ibase/webitm/css/Galaxy/galaxy-theme.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/Standard/default.css" rel="stylesheet"/>

<style type="text/css">
.tHeader
{
	border-top: #6cf 2px solid !important;
	border-left: 1px solid #ddd !important;
	border-right: 1px solid #ddd !important;
	border-bottom: 1px solid #ddd !important
}
.ft_container table tr td
{
	color: #555 !important;
}

</style>

<script>
<![CDATA[
		
	$(document).on("keydown", function (e) {
	    if (e.which === 8 && !$(e.target).is("input, textarea, form")) {
	        e.preventDefault();
	    }
	    else if(e.which === 13){
	    	 e.preventDefault();
	    }
	});
	
]]>
</script>

	<xsl:variable name="item_code"><xsl:value-of select="item_code"/></xsl:variable>
	<xsl:variable name="quantity"><xsl:value-of select="quantity"/></xsl:variable>
	<xsl:variable name="item_descr"><xsl:value-of select="item_descr"/></xsl:variable>
	<xsl:variable name="rate"><xsl:value-of select="rate"/></xsl:variable>
	<xsl:variable name="discount"><xsl:value-of select="discount"/></xsl:variable>
	<xsl:variable name="tax_class"><xsl:value-of select="tax_class"/></xsl:variable>
	<xsl:variable name="tax_chap"><xsl:value-of select="tax_chap"/></xsl:variable>
	<xsl:variable name="tax_env"><xsl:value-of select="tax_env"/></xsl:variable>
	<xsl:variable name="nature"><xsl:value-of select="nature"/></xsl:variable>
	
	
<!--     <xsl:variable name="dbIDs"><xsl:value-of select="domId"/></xsl:variable> -->
  
    
	<div id="mainPageHeaderContatiner">
		<div id="detailPage-input-Container">
			<table class = "tableClass" id="schemeDetails">
		
				<thead class="table-head">
					<tr class = "trClass">
						<th class="tHeader" nowrap="true" style="width:50px;">
									
						</th>
						<th class="tHeader" nowrap="true" valign="bottom">
							Item Code
						</th>
						<th class="tHeader" nowrap="true" valign="bottom">
							Item Description 
						</th>
						<th class="tHeader" nowrap="true" valign="bottom">
							No. Of Free Quantities  
						</th>
						
						<th class="tHeader" style="width:230px;" nowrap="true" valign="bottom" >
							Purchase Quantities
						</th>
						
					</tr>
				</thead>
				<tbody class="table-body">
				<xsl:for-each select="//Detail">
				  <xsl:variable name="domId"><xsl:value-of select="@domId"/></xsl:variable>  
				<tr class = "trClass" id="Detail2.{normalize-space($domId)}.rowID" value="{$domId}" >
						<td>
					<!-- 	 <input type="checkbox" class="editInputClass editInputCur" name="quantity" id="quantity1" 
									style="width:100%;border:none;text-align: right; outline:none" maxlength="10" /> -->
									
						<Input type='checkbox'  class="editInputClass editInputCur messageCheckbox" value="{$domId}" name="Detail2.{normalize-space($domId)}.selectbox" 
						       id="Detail2.{normalize-space($domId)}.selectbox" onclick="setChecked('{$domId}');" style="width:100%;border:none;text-align: right; outline:none" maxlength="10"  />
						       
									
						</td>
						<td nowrap="true">
						
								<input type="text"  maxlength="4" readOnly = "1"
									   value="{item_code}" name="Detail2.{normalize-space($domId)}.item_code" id="Detail2.{normalize-space($domId)}.item_code" 
									   style="width:150px;background-color: transparent;border: none;color:#666666;" tabindex="-1"/>
							
							
						</td>
						<td nowrap="true">
								<input type="text"  maxlength="4" readOnly = "1"
									   value="{item_descr}" name="Detail2.{normalize-space($domId)}.item_descr" id="Detail2.{normalize-space($domId)}.item_descr" 
									   style="width:300px;background-color: transparent;border: none;color:#666666;" tabindex="-1"/>
						</td>
						<td nowrap="true">
								<input type="text"  maxlength="4" readOnly = "1"
									   value="{quantity}" name="Detail2.{normalize-space($domId)}.quantity" id="Detail2.{normalize-space($domId)}.quantity" 
									   style="width:250px;background-color: transparent;border: none;color:#666666;" tabindex="-1"/>
						</td>
						
						
						<td nowrap="true">
						 <input type="text" class="editInputClass editInputCur"  value="" name="quantity" id="Detail2.{normalize-space($domId)}.disQty"  
									style="width:100%;border:none;text-align: right;  outline:none font-size: 14px !important; " maxlength="10" 
									onchange='calAmount({$domId});' onclick = 'calTrue({$domId})' readonly = 'true' />
						</td>
						
						<!-- 	<input type="hidden"  value="{$item_code}" name="Detail2.{normalize-space($domId)}.item_code" id="Detail3.{normalize-space($domId)}.item_code" />
							<input type="hidden"  value="{$item_descr}" name="Detail2.{normalize-space($domId)}.item_descr" id="Detail3.{normalize-space($domId)}.item_descr" />
 							<input type="hidden"  value="" name="Detail2.{normalize-space($domId)}.item_descr" id="Detail3.{normalize-space($domId)}.item_descr" />
 						 -->
 					<input type="hidden"  value="{rate}" name="Detail2.{normalize-space($domId)}.rate" id="Detail2.{normalize-space($domId)}.rate" />
 					<input type="hidden"  value="{discount}" name="Detail2.{normalize-space($domId)}.discount" id="Detail2.{normalize-space($domId)}.discount" />
 					<input type="hidden"  value="{tax_class}" name="Detail2.{normalize-space($domId)}.tax_class" id="Detail2.{normalize-space($domId)}.tax_class" />
 					<input type="hidden"  value="{tax_chap}" name="Detail2.{normalize-space($domId)}.tax_chap" id="Detail2.{normalize-space($domId)}.tax_chap" />
 					<input type="hidden"  value="{tax_env}" name="Detail2.{normalize-space($domId)}.tax_env" id="Detail2.{normalize-space($domId)}.tax_env" />
 					<input type="hidden"  value="{nature}" name="Detail2.{normalize-space($domId)}.nature" id="Detail2.{normalize-space($domId)}.nature" />
 				
 				</tr>
					
				</xsl:for-each>
				</tbody>
			</table>
		</div>
		
	</div>
	
 	
  
  <div class="closeDiv" id="e12popUpPnl-close" onclick="closePopUpOfScheme()">x</div>
  <div class="taxApplyButton"  id="applyTax" name="applyTax" title="Apply Tax" onclick ="getCheckedVal();">
  <p class="checkTax"> <img src="/ibase/webitm/images/checkMark.png" height="15" width="15"/> </p>
  <input  type="hidden"  name="PRE_SCHEME_VAL" ID="PRE_SCHEME_VAL" />
  
  </div> 
	
</body>

</html>
</xsl:template>
</xsl:stylesheet>
