package proteus.ecm.service;

import java.net.URL;
import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.params.SolrParams;
import org.json.JSONObject;

import proteus.ecm.hibernate.bean.ECMParm;
import proteus.ecm.hibernate.dao.SystemMasterDAO;

@Path("/solr")
public class SolrService {
	
	SolrQuery solrQuery;
	String query;
	String solrURL="";
	
	@Context
    HttpServletRequest request;
	@Context
	HttpServletResponse response;

    private SystemMasterDAO masterDAO = new SystemMasterDAO();
    
	@GET
	@Path("/{CORE_NAME}/{QUERY}/{FORMAT}/{START}/{SORT}/{FILTER}")
	@Produces({ "application/xml", "application/json" })
	public Response fetchData(@PathParam("CORE_NAME") String CORE_NAME, @PathParam("QUERY") String QUERY, @PathParam("FORMAT") String FORMAT, @PathParam("START") String START, @PathParam("SORT") String SORT, @PathParam("FILTER") String FILTER) throws Exception{
		
        System.out.println("SOLR GET service called");		
		HashMap<String,ECMParm> ecmParamData = masterDAO.fetchEcmParms("solr_url", true);
		ECMParm solrUrlParam = ecmParamData.get("solr_url");
		System.out.println("solrUrlParam SOLR_URL : [" + solrUrlParam + "]");
		if( solrUrlParam != null && solrUrlParam.getVarValue() != null )
		{
			solrURL = solrUrlParam.getVarValue();
			System.out.println("SOLR_URL : [" + solrURL + "]");
			solrURL = solrURL.endsWith("/") ? solrURL : solrURL + "/"; 
			solrURL = solrURL + CORE_NAME + "/select";
			
			query = QUERY;
			solrQuery = new SolrQuery();
			solrQuery.setQuery(QUERY);
			solrQuery.setFacet(true);
			solrQuery.set("wt", FORMAT);
			solrQuery.set("start", START);
			solrQuery.set("sort", SORT);
			solrQuery.set("fq", FILTER);
			
			return Response.status(200).entity( setConnection(response, solrQuery) ).build();
		}
		else
		{
			return Response.status(200).entity( "{\"message\":\"Unable to process request SOLR not configured .\"}" ).build();
		}
	}
	
	@GET
	@Path("/{CORE_NAME}/{QUERY}/{FORMAT}")
	@Produces({ "application/xml", "application/json" })
	public Response fetchSuggestions(@PathParam("CORE_NAME") String CORE_NAME, @PathParam("QUERY") String QUERY, @PathParam("FORMAT") String FORMAT) throws Exception{
		
        System.out.println("SOLR GET service called");		
		HashMap<String,ECMParm> ecmParamData = masterDAO.fetchEcmParms("solr_url", true);
		ECMParm solrUrlParam = ecmParamData.get("solr_url");
		System.out.println("solrUrlParam SOLR_URL : [" + solrUrlParam + "]");
		if( solrUrlParam != null && solrUrlParam.getVarValue() != null )
		{
			solrURL = solrUrlParam.getVarValue();
			System.out.println("SOLR_URL : [" + solrURL + "]");
			solrURL = solrURL.endsWith("/") ? solrURL : solrURL + "/"; 
			solrURL = solrURL + CORE_NAME + "/suggest";
			
			query = QUERY;
			solrQuery = new SolrQuery();
			solrQuery.setQuery(QUERY);
			solrQuery.setFacet(true);
			solrQuery.set("wt", FORMAT);
			
			String resp = setConnection(response, solrQuery);
			JSONObject obj = new JSONObject(resp.toString());
			System.out.println("JSON of response: ["+obj+"]");
			String suggestions = obj.getJSONObject("suggest").getJSONObject("infixSuggester").getJSONObject(QUERY).getString("suggestions");
			System.out.println("Suggestions["+suggestions+"]");
			
			return Response.status(200).entity( suggestions ).build();
		}
		else
		{
			return Response.status(200).entity( "{\"message\":\"Unable to process request SOLR not configured .\"}" ).build();
		}
		
	}
	
	private String setConnection(HttpServletResponse response, SolrParams query) throws Exception
	{
		try 
		{
			
			System.out.println("solrURL["+solrURL+"]");
			String urlQueryString = ClientUtils.toQueryString(query, true);	
			System.out.println("urlQueryString: [\n"+urlQueryString);
			URL url = new URL(solrURL + urlQueryString);
			String strUrl=url.toString();
			int index=strUrl.indexOf("&amp;");
			System.out.println("index["+index+"]");
			strUrl=strUrl.replaceAll("&amp;", "&");
			System.out.println("strUrl111["+strUrl+"]");
			URL url1 = new URL(strUrl);
			System.out.println("SolrUrl 423 ---------["+ url1 );

			String xmlResponse = org.apache.commons.io.IOUtils.toString(url1);
			System.out.println("xmlResponse["+xmlResponse+"]");
		
//			response.setCharacterEncoding("UTF-8");
//			response.setContentType("application/json");
//			OutputStream outputStream = response.getOutputStream();
//		    
//			outputStream.write(xmlResponse.getBytes());
//		    outputStream.flush();
//		    outputStream.close();
		    return xmlResponse;
		}
		catch (Exception e) 
		{
			System.out.println("Exception in setConnection:"+e.getMessage());
			return  "{\"message\":\"Unable to process request SOLR not configured .\"}";
		}
	}
	
	@POST
	@Path("/update/{CORE_NAME}/{ENTITY}")
	@Produces({ "application/json" })
	public Response updateSolr(@PathParam("CORE_NAME") String CORE_NAME, @PathParam("ENTITY") String ENTITY) throws Exception {
        System.out.println("SOLR POST service called");		
		HashMap<String,ECMParm> ecmParamData = masterDAO.fetchEcmParms("solr_url", true);
		ECMParm solrUrlParam = ecmParamData.get("solr_url");
		System.out.println("solrUrlParam SOLR_URL : [" + solrUrlParam + "]");
		if( solrUrlParam != null && solrUrlParam.getVarValue() != null )
		{
			solrURL = solrUrlParam.getVarValue();
			System.out.println("SOLR_URL : [" + solrURL + "]");
			solrURL = solrURL.endsWith("/") ? solrURL : solrURL + "/"; 
			solrURL = solrURL + CORE_NAME + "/dataimport";
			
			solrQuery = new SolrQuery();
			solrQuery.set("command", "delta-import");
			solrQuery.set("entity", ENTITY);
			
			return Response.status(200).entity( setConnection(response, solrQuery) ).build();
		}
		else
		{
			return Response.status(200).entity( "{\"message\":\"Unable to process request SOLR not configured .\"}" ).build();
		}
	}

}
