/*
 * Author:Wasim Ansari
 * Date:03-05-2017
 * Request ID:F17BBAS001 (GST Wizard Post Save Component for Reconciliation Trace)
 */
package ibase.webitm.ejb.gst;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.util.gst.GSTCommonUtil;
import ibase.webitm.util.gst.GSTCommonUtil;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class Gstr3BPosEJB extends ValidatorEJB implements Gstr3BPosEJBLocal,Gstr3BPosEJBRemote 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	GSTCommonUtil gstUtility = new GSTCommonUtil();
	ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
    /**
     * Default constructor. 
     */
    public Gstr3BPosEJB() {
        // TODO Auto-generated constructor stub
    }

	@Override
	public String postSave(String xmlStringAll, String tranID, String editFlag, String xtraParams, Connection conn) throws RemoteException, ITMException 
	{
		String retString="";
		try 
		{
			retString = postSave(xmlStringAll, xtraParams, "", conn);
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
			
	public String postSave(String xmlstring, String xtraParams, String forcedFlag, Connection conn) throws RemoteException,ITMException
	{
		System.out.println("Inside GstrPurchasePosEJB Post Save ["+xmlstring+"] \n xtraParams ["+xtraParams+"] \n forcedFlag["+forcedFlag+"]");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Timestamp currDate = null;
		Timestamp validUptoDate = null;
		boolean isError = false,isLocCon = false;
		Document dom = null;
		String sql = "",retString = "";
		int cnt = 0,cnt1 = 0;
		FinCommon  finCommon = null;
		String loginSite = "";
		java.sql.Date chg_date=null;
		String val = "";
		String loginSiteCode = "";
		String name="",addr1="",addr2="",addr3="",city="",state="",pin="",taxRegNo="",tran_type="",tranId="";
		String supply_type="",itc_type="";	
		String 	recordType = "", // Gstr type rec_type
				sPos = "", // Supplier Place Of Supplay gst_code
				cPos = "", // Customer Place Of Supplay
				gstType ="", 
				docType ="",
				reverseCharge ="N",//Reverse Charge reverse_chrg
				eCommGtin ="",//Ecommerce Gtin  ecom_reg_no
				gtin = "",//Supplier GTIN
				tranType = "";		
		double invAmt =0.0,b2clInvVal = 0.0,gstRate = 0.0;//amount
		boolean isWithPay = false;
	
		try
		{	
			System.out.println("===================Inside GstrPosEJB class========================");
			if(conn == null || conn.isClosed())
			{
				System.out.println("@@Connection is null");
				conn = getConnection();
				isLocCon = true;
			}
			else
			{
				System.out.println("@@Connection is not null");
			}
			
			if(xmlstring != null &&  (xmlstring.indexOf("Detail1") != -1))
			{
				finCommon = new FinCommon(); 
				currDate = new java.sql.Timestamp(System.currentTimeMillis());
	            SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
	            SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
	            String currDateStr = sdfAppl.format(currDate.getTime());
	            currDate = Timestamp.valueOf(genericUtility.getValidDateString(currDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
	            //System.out.println("currDate:::::::::"+currDate);			
			    dom = genericUtility.parseString(xmlstring); 				
				NodeList detail1NodeList =dom.getElementsByTagName("Detail1");
				int detail3NodeListlen = detail1NodeList.getLength();
				loginSite = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
				System.out.println("loginSite>>>>>>>>>>"+loginSite);
				
				for(int ctrH = 0; ctrH < detail3NodeListlen ; ctrH++)
				{
					NodeList childNodeList = detail1NodeList.item(ctrH).getChildNodes();
					int childNodeListlen = childNodeList.getLength();
					System.out.println("childNodeListlen>>>>>"+childNodeListlen);
					for(int ctrD = 0; ctrD < childNodeListlen ; ctrD++)
					{
						Node childNode = childNodeList.item(ctrD);
						System.out.println("childNode.getNodeName()>>"+childNode.getNodeName());
						if(childNode != null && "tran_type".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							tran_type = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("GSTR Customer tran_type is===="+tran_type);
						}
						//Changed By Pragyan.start
						else if(childNode != null && "rec_type".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							recordType = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else if(childNode != null && "gst_type".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							gstType = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else if(childNode != null && "doc_type".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							docType = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else if(childNode != null && "gst_code_state".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							cPos = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else if(childNode != null && "tran_id".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							tranId = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
					}
				}
				NodeList nodeList =dom.getElementsByTagName("Detail2");
				int nodeListlen = nodeList.getLength();
				System.out.println("NodeList for Detail2 is ========"+nodeListlen);
				cnt1 = gstUtility.getNumOfNonDelDetail(dom,2);
				System.out.println("Value of cnt1 in GstrPosEJB is =="+cnt1);
				
				for(int ctr = 0; ctr < nodeListlen ; ctr++)
				{
					NodeList childNodeList = nodeList.item(ctr).getChildNodes();
					int childNodeListlen = childNodeList.getLength();
					System.out.println("childNodeListlen>>>>>"+childNodeListlen);
					for(int ctrD = 0; ctrD < childNodeListlen ; ctrD++)
					{
						Node childNode = childNodeList.item(ctrD);
						if(childNode != null && "gst_rate".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							gstRate = Double.parseDouble(childNode.getFirstChild().getNodeValue());
							System.out.println("gstRate::::::::::::"+gstRate);									
						}
						else if(childNode != null && "supply_type".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							supply_type = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("supply_type::::::::::::"+supply_type);	
						}
						else if(childNode != null && "itc_type".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							itc_type = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("itc_type::::::::::::"+itc_type);	
						}
					}
				}
								
				sPos = getGstStateCode(loginSite,conn);
					
				System.out.println("Record Type["+recordType+"]Gst Type ["+gstType+"]Doc Type["+docType+"]");
				System.out.println("CTIN["+taxRegNo+"]Ecom Gtin["+eCommGtin+"]Suppplier POS["+sPos+"] Customer Pos["+cPos+"]Revrse Charge["+reverseCharge+"]Invoice amount ["+invAmt+"]");
				System.out.println("supply_type:::::"+supply_type +"itc_type:::::["+itc_type+"]");
				
				if("6".equalsIgnoreCase(recordType))
				{				
					if("D".equalsIgnoreCase(gstType))
					{
						tranType = "06";
					}
					
					else if("C".equalsIgnoreCase(gstType))
					{
						tranType = "07";
					}
					
					else if("I".equalsIgnoreCase(gstType))
					{
						tranType = "08";
					}
	
					else if("L".equalsIgnoreCase(gstType)) 
					{
						tranType = "32";
					}
				
					System.out.println("Tran Id ::::["+tranId+"]");
					
					
					System.out.println("Tran Type is ====="+tranType);
					sql = "update gst_data_hdr set tran_type=? where tran_id=?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,tranType);
					pstmt.setString(2,tranId);
					pstmt.executeUpdate();
					if(pstmt != null)
					{
						pstmt.close(); 
						pstmt = null;
					}	
				}

				//Changed By Pragyan 04/07/17 to update tran type logics.end	
			}	
			else //if(xmlstring == null ||  (xmlstring.indexOf("Detail1") == 0))
			{
				System.out.println("Detail1 not found");
				retString = itmDBAccessLocal.getErrorString("","VTBLNKDTL","","",conn);
				return retString;
			}
			//if(xmlstring != null && xmlstring.indexOf("Detail2") == -1 && !(gstType.equalsIgnoreCase("L")))
			if(cnt1 == 0 && !(gstType.equalsIgnoreCase("O")))
			{
				System.out.println("Detail2 is empty in xmlString....");
				retString = itmDBAccessLocal.getErrorString("","VTBLNKDTL2","","",conn);
				return retString;
			}
		}// end of try block
		catch(Exception e)
		{
			System.out.println("Exception GstrPosEJB ==>"+e.getMessage());
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("Inside finally GstrPurchasePosEJB isError["+isError+"] connStatus["+isLocCon+"]");
				if (rs != null )
				{
					rs.close();rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();pstmt = null;
				}
				if(isLocCon)
				{
					if(isError)
					{
						System.out.println("Inside rollbacking....");
						conn.rollback();
					}
					else
					{
						System.out.println("Inside committing....");
						conn.commit();
					}
					if (conn != null )
					{
						conn.close();conn = null;
					}
				}
			}
			catch( Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println("errString from post save GstrPosEJB =["+retString+"]");
		return retString;
	}
	
	private static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
	
	private String  getGstStateCode(String siteCode , Connection conn) throws ITMException
	{
		String pos ="";
		String sSQL ="";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		try
		{
			
			sSQL = "SELECT ST.GST_CODE FROM TARODEV.SITE S,TARODEV.STATE ST WHERE S.STATE_CODE = ST.STATE_CODE AND S.SITE_CODE = ?";
			pstmt = conn.prepareStatement(sSQL);
			pstmt.setString(1,siteCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				pos = rs.getString("GST_CODE");
			}
			
			if(pstmt != null)
			{
			    pstmt.close(); 
			    pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
			    rs = null;
			} 
			
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				
				if (rs != null )
				{
					rs.close();rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();pstmt = null;
				}
				
			}
			catch( Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		
		return pos;
	}
	
}
