/*Author Priyanka Chavan.
 * Date :
 */

package ibase.webitm.ejb.gst;

import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ITMUploadFileRemote;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import ibase.webitm.ejb.fin.FinCommon;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map.Entry;
import java.util.Set;

import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import net.sf.saxon.functions.CurrentDateTime;
import jxl.Sheet;
import jxl.Workbook;
public class GSTPurcUploadExcelTemplate extends ValidatorEJB 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
    String glbPeriodeCode = "";//Only for Nil AND ITC Rates
    String glbDocDate = "";//Only for Nil  AND ITC Rates
	public String readExcelfile(Workbook workbook, UserInfoBean userInfo,File DUMP_DIR,String fileName,String objName) throws ITMException, SQLException //Read Uploaded Excel Sheet and Insert Data in to Gst Tables..
	{  
		Connection  conn=null;
		InitialContext ctx = null;
		ResultSet rs = null;
		PreparedStatement stmt = null;
		boolean isError = false,isExcelDriver=false,isRetainPkValue=false,isIntractive=false;
		String message="",responseXML="";
		HSSFWorkbook outputWorkbook = new HSSFWorkbook();
		try
		{
			conn = getConnection();
			outputWorkbook=createXlsShite( outputWorkbook,objName);
			int noOfSheet = workbook.getNumberOfSheets();	
			String[] sheetName = workbook.getSheetNames();
			for (int wbcnt = 0; wbcnt < noOfSheet; wbcnt++) 
			{
				System.out.println("No. of sheet : "+noOfSheet);
				Sheet sheet = workbook.getSheet(wbcnt); 
				int noOfRows = sheet.getRows();
				int noOfColumns = sheet.getColumns();
				String eachSheetName = sheetName[wbcnt];
				System.out.println("row :"+noOfRows);
				System.out.println("Columns :"+noOfColumns);
				System.out.println("sheetNames :"+eachSheetName);
				ArrayList<String> hdrDetColumnNameList = new ArrayList<String>();
				HashMap<String, HashMap<String,Object>> b2bInvoicesHMap = new HashMap<String, HashMap<String,Object>>();
				
				//Read And Insert Data For b2b 
				if("b2b".equalsIgnoreCase(eachSheetName)) //Read b2b sheet and Insert data in to Gst Table.....
				{     
					b2bInvoicesHMap.clear();
					for (int row = 0; row < noOfRows; row++) 
					{
						HashMap<String, Object> eachInvoiceDataHMap = new HashMap<String, Object>();
						HashMap<String, String> eachDetailHMap = new HashMap<String, String>();
						String invoiceId = "";
						for (int column = 0; column < noOfColumns; column++) 
						{
							String testData = sheet.getCell(column, row).getContents();
							if(column<=7) //Read Header Data From GST Excel Sheet .......
							{
								if(row==1)
								{   
									String hdrData = sheet.getCell(column, row).getContents();
									hdrDetColumnNameList.add(hdrData);
								}
								if(row>=2)
								{   
									String hdrData2 = sheet.getCell(column, row).getContents();
									if(column==1)
									{
										invoiceId = hdrData2;
									}
									eachInvoiceDataHMap.put(hdrDetColumnNameList.get(column), hdrData2);
								}
							}
							else if(column>7)  // Read Detail Data From GST Excel Sheet .......
							{
								if(row==1)
								{
									String dtlData = sheet.getCell(column, row).getContents();
									hdrDetColumnNameList.add(dtlData);
								}
								if(row>=2)
								{
									String dtlData2 = sheet.getCell(column, row).getContents();
									eachDetailHMap.put(hdrDetColumnNameList.get(column), dtlData2);
								}
							}
							// data From Detail 
						}
						if(row>=2)
						{
							System.out.println("invoice id="+invoiceId +" i="+row);
							if(b2bInvoicesHMap.containsKey(invoiceId))
							{
								HashMap<String, Object> tempHMap = b2bInvoicesHMap.get(invoiceId);
								ArrayList<HashMap<String,String>> tempList = (ArrayList<HashMap<String, String>>) tempHMap.get("detailData");
								tempList.add(eachDetailHMap);
								tempHMap.put("detailData", tempList);
								b2bInvoicesHMap.put(invoiceId, tempHMap);
							}
							else
							{
								ArrayList<HashMap<String, String>> detailDataList = new ArrayList<HashMap<String,String>>();
								detailDataList.add(eachDetailHMap);
								eachInvoiceDataHMap.put("detailData", detailDataList);
								b2bInvoicesHMap.put(invoiceId, eachInvoiceDataHMap);
							}
						}
					}
					System.out.println("b2bInvoicesHMap["+b2bInvoicesHMap+"]");
					outputWorkbook= insertIntoXlsShit(b2bInvoicesHMap, outputWorkbook, userInfo,eachSheetName);
				}
				//Read And Insert Data For B2C
				if("b2c".equalsIgnoreCase(eachSheetName))  // Read Sheet b2cl and Insert Data INTO GST Table....
				{
					for (int row = 0; row < noOfRows; row++) 
					{
						//b2bInvoicesHMap.clear();
						HashMap<String, Object> eachInvoiceDataHMap = new HashMap<String, Object>();
						HashMap<String, String> eachDetailHMap = new HashMap<String, String>();
						String invoiceId = "";
						for (int column = 0; column < noOfColumns; column++) 
						{
							String testData = sheet.getCell(column, row).getContents();
							if(column<=4) //Read Header Data From Gst Excel Sheet .......
							{
								if(row==1)
								{   
									//System.out.println("inside2.......");
									String hdrData = sheet.getCell(column, row).getContents();
									hdrDetColumnNameList.add(hdrData);
								}
								if(row>=2)
								{   
									String hdrData2 = sheet.getCell(column, row).getContents();
									if(column==0)
									{
										invoiceId = hdrData2;
									}
									eachInvoiceDataHMap.put(hdrDetColumnNameList.get(column), hdrData2);
								}
							}
							else if(column>4) //Read Detail Data From Gst Excel Sheet .......
							{
								if(row==1)
								{
									String dtlData = sheet.getCell(column, row).getContents();
									hdrDetColumnNameList.add(dtlData);
								}
								if(row>=2)
								{
									String dtlData2 = sheet.getCell(column, row).getContents();
									eachDetailHMap.put(hdrDetColumnNameList.get(column), dtlData2);

								}
							}

						}
						if(row>=2)
						{
							System.out.println("invoice id="+invoiceId +" i="+row);
							if(b2bInvoicesHMap.containsKey(invoiceId))
							{
								HashMap<String, Object> tempHMap = b2bInvoicesHMap.get(invoiceId);
								ArrayList<HashMap<String,String>> tempList = (ArrayList<HashMap<String, String>>) tempHMap.get("detailData");
								tempList.add(eachDetailHMap);
								tempHMap.put("detailData", tempList);
								b2bInvoicesHMap.put(invoiceId, tempHMap);
							}
							else
							{
								ArrayList<HashMap<String, String>> detailDataList = new ArrayList<HashMap<String,String>>();
								detailDataList.add(eachDetailHMap);
								eachInvoiceDataHMap.put("detailData", detailDataList);
								b2bInvoicesHMap.put(invoiceId, eachInvoiceDataHMap);
							}
						}
					}
					System.out.println("b2bInvoicesHMap["+b2bInvoicesHMap+"]");
					outputWorkbook= insertIntoXlsShit(b2bInvoicesHMap, outputWorkbook, userInfo,eachSheetName);
				}
				
				//Read And Insert Data For CDN
				if("cdn".equalsIgnoreCase(eachSheetName))
				{
					for (int row = 0; row < noOfRows; row++) 
					{
						//b2bInvoicesHMap.clear();
						HashMap<String, Object> eachInvoiceDataHMap = new HashMap<String, Object>();
						HashMap<String, String> eachDetailHMap = new HashMap<String, String>();
						String invoiceId = "";
						for (int column = 0;column < noOfColumns; column++) 
						{
							String testData = sheet.getCell(column, row).getContents();
							if(column<=10) //Read Header Data From Gst Excel Sheet .......
							{
								if(row==1)
								{   
									//System.out.println("inside2.......");
									String hdrData = sheet.getCell(column, row).getContents();
									hdrDetColumnNameList.add(hdrData);
								}
								if(row>=2 )
								{   
									String hdrData2 = sheet.getCell(column, row).getContents();
									if(column==1)
									{
										invoiceId = hdrData2;
									}
									eachInvoiceDataHMap.put(hdrDetColumnNameList.get(column), hdrData2);
								}
							}
							else if(column>10) //Read Detail Data From Gst Excel Sheet .......
							{
								if(row==1)
								{
									String dtlData = sheet.getCell(column, row).getContents();
									hdrDetColumnNameList.add(dtlData);
								}
								if(row>=2)
								{
									String dtlData2 = sheet.getCell(column, row).getContents();
									eachDetailHMap.put(hdrDetColumnNameList.get(column), dtlData2);

								}
							}
						}
						if(row>=2)
						{
							System.out.println("invoice id="+invoiceId +" i="+row);
							if(b2bInvoicesHMap.containsKey(invoiceId))
							{
								HashMap<String, Object> tempHMap = b2bInvoicesHMap.get(invoiceId);
								ArrayList<HashMap<String,String>> tempList = (ArrayList<HashMap<String, String>>) tempHMap.get("detailData");
								tempList.add(eachDetailHMap);
								tempHMap.put("detailData", tempList);
								b2bInvoicesHMap.put(invoiceId, tempHMap);
							}
							else
							{
								ArrayList<HashMap<String, String>> detailDataList = new ArrayList<HashMap<String,String>>();
								detailDataList.add(eachDetailHMap);
								eachInvoiceDataHMap.put("detailData", detailDataList);
								b2bInvoicesHMap.put(invoiceId, eachInvoiceDataHMap);
							}
						}
					}
					System.out.println("b2bInvoicesHMap["+b2bInvoicesHMap+"]");
					outputWorkbook= insertIntoXlsShit(b2bInvoicesHMap, outputWorkbook, userInfo,eachSheetName);
				}
				
				//Read And Insert Data For Imports 
				if("Imports".equalsIgnoreCase(eachSheetName))
				{
					for (int row = 0; row < noOfRows; row++) 
					{
						//b2bInvoicesHMap.clear();
						HashMap<String, Object> eachInvoiceDataHMap = new HashMap<String, Object>();
						HashMap<String, String> eachDetailHMap = new HashMap<String, String>();
						String invoiceId = "";
						for (int column = 0; column < noOfColumns; column++) 
						{
							String testData = sheet.getCell(column, row).getContents();
							if(column<=9) //Read Header Data From Gst Excel Sheet .......
							{
								if(row==1)
								{   
									//System.out.println("inside2.......");
									String hdrData = sheet.getCell(column, row).getContents();
									hdrDetColumnNameList.add(hdrData);
								}
								if(row>=2)
								{   
									String hdrData2 = sheet.getCell(column, row).getContents();
									if(column==0)
									{
										invoiceId = hdrData2;
									}
									eachInvoiceDataHMap.put(hdrDetColumnNameList.get(column), hdrData2);
								}
							}
							else if(column>9) //Read Detail Data From Gst Excel Sheet .......
							{
								if(row==1)
								{
									String dtlData = sheet.getCell(column, row).getContents();
									hdrDetColumnNameList.add(dtlData);
								}
								if(row>=2)
								{
									String dtlData2 = sheet.getCell(column, row).getContents();
									eachDetailHMap.put(hdrDetColumnNameList.get(column), dtlData2);
								}
							}
						}
						if(row>=2)
						{
							System.out.println("invoice id="+invoiceId +" i="+row);
						//	System.out.println("b2bInvoicesHMap= "+b2bInvoicesHMap);
							if(b2bInvoicesHMap.containsKey(invoiceId))
							{
								HashMap<String, Object> tempHMap = b2bInvoicesHMap.get(invoiceId);
								ArrayList<HashMap<String,String>> tempList = (ArrayList<HashMap<String, String>>) tempHMap.get("detailData");
								tempList.add(eachDetailHMap);
								tempHMap.put("detailData", tempList);
								b2bInvoicesHMap.put(invoiceId, tempHMap);
							}
							else
							{
								ArrayList<HashMap<String, String>> detailDataList = new ArrayList<HashMap<String,String>>();
								detailDataList.add(eachDetailHMap);
								eachInvoiceDataHMap.put("detailData", detailDataList);
								b2bInvoicesHMap.put(invoiceId, eachInvoiceDataHMap);
							}
						}
					}
					System.out.println("b2bInvoicesHMap["+b2bInvoicesHMap+"]");
					outputWorkbook= insertIntoXlsShit(b2bInvoicesHMap, outputWorkbook, userInfo,eachSheetName);

				}
				//Read And Insert Data For ADVANCE 
				if("advance".equalsIgnoreCase(eachSheetName))
				{
					int invoiceId = 0;
					for (int row = 0; row < noOfRows; row++) 
					{
						
						HashMap<String, Object> eachInvoiceDataHMap = new HashMap<String, Object>();
						HashMap<String, String> eachDetailHMap = new HashMap<String, String>();

						for (int column = 0; column < noOfColumns; column++) 
						{
							String testData = sheet.getCell(column,row).getContents();
							if(column<=2) //Read Header Data From Gst Excel Sheet .......
							{
								if(row==1)
								{   
									//System.out.println("inside2.......");
									String hdrData = sheet.getCell(column, row).getContents();
									hdrDetColumnNameList.add(hdrData);
								}
								if(row >= 2)
								{   
									String hdrData2 = sheet.getCell(column, row).getContents();
									eachInvoiceDataHMap.put(hdrDetColumnNameList.get(column), hdrData2);
								}
							}
							else if(column>2) //Read Detail Data From Gst Excel Sheet .......
							{
								if(row==1)
								{
									String dtlData = sheet.getCell(column, row).getContents();
									hdrDetColumnNameList.add(dtlData);
								}
								if(row>=2)
								{
									String dtlData2 = sheet.getCell(column, row).getContents();
									System.out.println("dtl data" +dtlData2);
									//eachDetailHMap.put(Integer.toString(invoiceId), dtlData2);
									eachDetailHMap.put(hdrDetColumnNameList.get(column), dtlData2);
								}
							}
						}
						if(row>=2)
						{
							System.out.println("invoice id="+invoiceId +" i="+row);
							ArrayList<HashMap<String, String>> detailDataList = new ArrayList<HashMap<String,String>>();
							detailDataList.add(eachDetailHMap);
							eachInvoiceDataHMap.put("detailData", detailDataList);
							b2bInvoicesHMap.put(Integer.toString(invoiceId), eachInvoiceDataHMap);

						}
						invoiceId++;
					}
					System.out.println("b2bInvoicesHMap["+b2bInvoicesHMap+"]");
					outputWorkbook= insertIntoXlsShit(b2bInvoicesHMap, outputWorkbook, userInfo,eachSheetName);
				}
				
				//Read And Insert Data For NIL 
				if("nil".equalsIgnoreCase(eachSheetName))
				{
					b2bInvoicesHMap.clear();
					int row,column,tranType=15;
					for (row = 2; row < noOfRows; row++) 
					{
						for ( column = 1; column < noOfColumns; column++) 
						{
							String testData = sheet.getCell(column, row).getContents();
							if(column<=4 ) //Read Header Data From Gst Excel Sheet .......
							{
								if(row>=2)
								{   
									String hdrData2 = sheet.getCell(column, row).getContents();
									HashMap<String,Object> HeraderMap = new HashMap<String,Object>();
									HeraderMap.put("tran_type",Integer.toString(tranType));
									HeraderMap.put("amount",hdrData2);
									b2bInvoicesHMap.put(Integer.toString(tranType), HeraderMap)	;
									tranType++;
								}
								if(column>4){break;}
							}
						}
						if(row>2){break;}
					}
					System.out.println("b2bInvoicesHMap["+b2bInvoicesHMap+"]");
					outputWorkbook= insertIntoXlsShit(b2bInvoicesHMap, outputWorkbook, userInfo,eachSheetName);
				}
				if("itc".equalsIgnoreCase(eachSheetName))
				{
					int invoiceId = 0,tranType=26;
					for (int row = 0; row < noOfRows; row++) 
					{
						
						HashMap<String, Object> eachInvoiceDataHMap = new HashMap<String, Object>();
						HashMap<String, String> eachDetailHMap = new HashMap<String, String>();

						for (int column = 0; column < noOfColumns; column++) 
						{
							String testData = sheet.getCell(column,row).getContents();
							if(column<=0) //Read Header Data From Gst Excel Sheet .......
							{
								if(row==1)
								{   
									//System.out.println("inside2.......");
									String hdrData = sheet.getCell(column, row).getContents();
									hdrDetColumnNameList.add(hdrData);
								}
								if(row >= 2)
								{
								eachInvoiceDataHMap.put(hdrDetColumnNameList.get(column), Integer.toString(tranType));
								tranType++;
								}
							}
							else if(column>0) //Read Detail Data From Gst Excel Sheet .......
							{
								if(row==1)
								{
									String dtlData = sheet.getCell(column, row).getContents();
									hdrDetColumnNameList.add(dtlData);
								}
								if(row>=2)
								{
									String dtlData2 = sheet.getCell(column, row).getContents();
									eachDetailHMap.put(Integer.toString(invoiceId), dtlData2);
									eachDetailHMap.put(hdrDetColumnNameList.get(column), dtlData2);
								}
							}
						}
						if(row>=2)
						{
							System.out.println("invoice id="+invoiceId +" i="+row);
							ArrayList<HashMap<String, String>> detailDataList = new ArrayList<HashMap<String,String>>();
							detailDataList.add(eachDetailHMap);
							eachInvoiceDataHMap.put("detailData", detailDataList);
							b2bInvoicesHMap.put(Integer.toString(invoiceId), eachInvoiceDataHMap);

						}
						invoiceId++;
					}
					System.out.println("b2bInvoicesHMap["+b2bInvoicesHMap+"]");
					outputWorkbook= insertIntoXlsShit(b2bInvoicesHMap, outputWorkbook, userInfo,eachSheetName);
				}
			}
			 String  XslfileName= fileName.split("\\.")[0];
			  XslfileName = XslfileName+".xls";
			  System.out.println("XslfileName :"+XslfileName);
			  String newFileName = System.currentTimeMillis() + "_" + userInfo.getLoginCode() + "_" + XslfileName;
			  System.out.println("newFileName :"+newFileName);
			  System.out.println("/home/base/GST_Purchase_Template.xls");
			  FileOutputStream fileOut = new FileOutputStream(DUMP_DIR + File.separator + newFileName );
			  outputWorkbook.write(fileOut);
			  fileOut.flush();
			  fileOut.close();
			 String [] fileInfoArr = new String[7];
			  fileInfoArr[0] =  String.valueOf(isIntractive);
			  fileInfoArr[1] = newFileName;
			  System.out.println("newFileName" +fileInfoArr[1]);
			  fileInfoArr[2] = objName;
			  System.out.println("objName" +fileInfoArr[2]);
			  fileInfoArr[3] = "";
			  System.out.println("XslfileName" +fileInfoArr[3]);
			  fileInfoArr[4] = "";
			  fileInfoArr[5] = String.valueOf(isExcelDriver);
			  fileInfoArr[6] = String.valueOf(isRetainPkValue);
			  System.out.println("fileInfoArr" +fileInfoArr);
			  System.out.println("userInfo :" +userInfo);
			  System.out.println("DUMP_DIR :" +DUMP_DIR);
			  System.out.println("ibaseer  :" +CommonConstants.APPLICATION_CONTEXT);
			  System.out.println("isExcelDriver :" +isExcelDriver);
			  ctx=getInitialContext();
			  ITMUploadFileRemote validation = (ibase.webitm.ejb.ITMUploadFileRemote) ctx.lookup("ibase/ITMUploadFileEJB/remote");
			  responseXML = validation.insertFileData(fileInfoArr , userInfo , DUMP_DIR , CommonConstants.APPLICATION_CONTEXT, "", isExcelDriver, isRetainPkValue);
			  System.out.println("responseXML" +responseXML);
			  
			  System.out.println("finallllllllll :");
			message="Excel sheet read Successfully not uploaded";
		}
		catch(Exception e)
		{ 
			System.out.println(e);
			message = e.getMessage();
		System.out.println("Exception 3::" +message + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			System.out.println("updategst isError="+isError);
			if(isError)
			{
				conn.rollback();
			}
			else
			{
				conn.commit();
			}
			if(stmt != null){stmt.close();stmt = null;}
			if(rs != null){rs.close();rs = null;}
			if(conn != null){conn.close();conn = null;}
		}
		return responseXML;
	}
	
	private HSSFWorkbook createXlsShite( HSSFWorkbook outputWorkbook, String objName) 
	{
		 System.out.println("inside createXlsShite");
		 HSSFSheet shit =  outputWorkbook.createSheet("metadata");  
		 HSSFRow row = shit.createRow((short)0);
		 row.createCell(0).setCellValue("obj_name");
		 row.createCell(1).setCellValue("pk_name");
		 HSSFSheet shit2 =  outputWorkbook.getSheet("metadata");  
		 HSSFRow row2 = shit2.createRow((short)1);
		 row2.createCell(0).setCellValue(objName);
		 row2.createCell(1).setCellValue("tran_id");
			
		final String[] titleshdr =
		{"tran_id","tran_date","tran_id__ref","site_code","prd_code","rec_type","tran_type","cust_code","cust_name","submission_type","doc_checksum","doc_type","doc_no","doc_date","amount","reverse_chrg","lr_no","lr_date","reas_code","ref_id__inv","ref_date__inv","prov_assmnt","order_no","order_date","remarks","submit_status","submit_date","add_user","add_date","add_term","chg_user","chg_date","chg_term","tax_reg_no","name","reco_status","ecom_reg_no","ref_ser","gst_code_state","gst_type","ref_id"};
		
		final String[] titlesdet ={"tran_id", "line_no","status","sr_no__old","line_type","gs_code","taxable_amt","igst_perc","igst_amt","cgst_perc","cgst_amt","sgst_perc","sgst_amt","gs_descr","unit","quantity","supply_type","cess_perc","cess_amt","remarks","itc_type","itc_igst","itc_cgst","itc_sgst","itc_cess","gst_rate"};
				
 		HSSFSheet sheet =  outputWorkbook.createSheet("HeaderShit");  
		HSSFRow rowheader = sheet.createRow((short)0);
		for(int cellCnt=0;cellCnt<titleshdr.length;cellCnt++)
		{
		rowheader.createCell(cellCnt).setCellValue(titleshdr[cellCnt]);
		}
		
		HSSFSheet sheet1 =  outputWorkbook.createSheet("DetailShit");  
		HSSFRow rowdetail = sheet1.createRow((short)0);
		for(int cellCnt=0;cellCnt<titlesdet.length;cellCnt++)
		{
		rowdetail.createCell(cellCnt).setCellValue(titlesdet[cellCnt]);
		}
		return outputWorkbook;
	}
	
	private HSSFWorkbook insertIntoXlsShit(HashMap<String, HashMap<String, Object>> b2bInvoicesHMap, HSSFWorkbook outputWorkbook,UserInfoBean userInfo,String eachSheetName) throws ITMException 
	{
		
		 System.out.println("inside insertIntoXlsShit");

		
		 FinCommon  finCommon = new FinCommon(); 
		 StringBuffer valueXmlString = new StringBuffer();
		 Connection  conn=null;
		 ResultSet rs = null;String headersql="",detailSql="";
		 Boolean isError = false,isWithPay=false;
		 PreparedStatement pstmt=null , pstmt1=null;
		 String  taxRegNo="",refIdInv="",refDateInv="",gstCode="",gstCodeAct="",reverseChrg="",document="",documentAct="",ecomRegNo="",siteCode="";
		 String  lineNo="",provAssmnt="",ordNo="",subStatus="",addUser="",addTerm="",statusDet="",srnoOldDet="",lineTypeDet="",gscodeDet="";
		 String  subDate="",chgUser="",chgTerm="",chgDate="",taxableamtDet="",igstpercDet="",igstamtDet="",cgstpercDet="",cgstamtDet="",sgstpercDet="";
		 String  docDate = "",lrDate = "",ordDate="",refId="",addDate="",sgstamtDet="",gsdescrDet="",unitDet="",quantityDet="",supptypeDet="",cesspercDet="",cessamtDet="";
		 String  tranType = "",custCode = "",custName = "",subType="",itctypeDet="",itcigstDet="",itccgstDet="",
				 docCheckSum = "",docNo = "",lrNo = "",reasCode = "",itcsgstDet="",itccessDet="",remarks = "",tranIdRef="",
				 recoStatus = "",refSer = "",docType = "",remarksDet = "",
				 gstType = "",tranDate="",sPos="", message="",prdCodenew="";
		 String recType = "2",refDateAct="",Name="";
		 int caseCount = 0,transactionId=1;
		 double invAmt=0, b2clInvVal=0,gstRate=0;
		 int currentDetilRow=0;
		 int currentHaderRow=0;
		
		
		try
		{ 
			conn = getConnection();
			b2clInvVal = Double.parseDouble(finCommon.getFinparams("999999", "GST_B2CL_INV_VAL", conn));
			System.out.println("b2clInvVal :"+b2clInvVal);
			for (String key : b2bInvoicesHMap.keySet()) 
			{   
			int val2=1,val=1;
			HSSFSheet sheet =  outputWorkbook.getSheet("HeaderShit");
			currentHaderRow = sheet.getLastRowNum()+1;
			HSSFRow rowheader = sheet.createRow((currentHaderRow));//Add Row as per data database column...
			HashMap header = (HashMap) b2bInvoicesHMap.get(key);
			//HashMap HeraderMap = (HashMap) b2bInvoicesHMap.get(key);
			siteCode = userInfo.getSiteCode();
			//System.out.println("GSTTranId ::::::::::::: " + transactionId);
			//taxRegNo = checkNullandTrim((String) header.get("tax_reg_no"));
			taxRegNo = checkNullandTrim((String) header.get("tax_reg_no"));
			System.out.println("taxRegNo="+taxRegNo);
			custName = checkNullandTrim((String) header.get("cust_name"));
			System.out.println("custName="+custName);
			Name = checkNullandTrim((String) header.get("name"));
			System.out.println("Name="+Name);
			refIdInv = checkNullandTrim((String) header.get("ref_id__inv"));
			System.out.println("refIdInv="+refIdInv);
			refDateInv =checkNullandTrim( (String) header.get("ref_date__inv"));
			System.out.println("refDateInv"+refDateInv);
			invAmt = getDouble((String)header.get("amount"));
			System.out.println("invAmt="+invAmt);
			gstCode =  checkNullandTrim((String) header.get("gst_code"));
			if(gstCode != null && gstCode.trim().length() > 0)
			{
				gstCodeAct = gstCode.substring(0, 2);
			}
			System.out.println("gstCodeAct="+gstCodeAct);
			reverseChrg =  checkNullandTrim((String) header.get("reverse_chrg"));
			System.out.println("reverseChrg="+reverseChrg);
			document =  checkNullandTrim((String) header.get("doc_type"));
			System.out.println("document="+document);
			if(document != null && document.trim().length() > 0)
			{
				documentAct = document.split("-")[0];
			}
			System.out.println("documentAct="+documentAct);
			ecomRegNo =  checkNullandTrim((String) header.get("ecom_reg_no"));
			System.out.println("ecomRegNo="+ecomRegNo);
			gstType =  checkNullandTrim((String) header.get("gst_type"));
			if(gstType != null && gstType.trim().length() > 0)
			{
				gstType = gstType.split("-")[0];
			}
			docDate =  checkNullandTrim((String) header.get("doc_date"));
			if(docDate!= null  && docDate.trim().length() > 0)
			{
				prdCodenew=	genericUtility.getValidDateString(docDate, genericUtility.getApplDateFormat(), "MMYYYY");
				glbPeriodeCode = prdCodenew;
				glbDocDate = docDate;
				System.out.println("prdCodenew" +prdCodenew);
			}
			docNo =  checkNullandTrim((String) header.get("doc_no"));
			reasCode =  checkNullandTrim((String) header.get("reas_code"));
			lrNo =  checkNullandTrim((String) header.get("lr_no"));
			lrDate =  checkNullandTrim((String) header.get("lr_date"));
			ordNo =  checkNullandTrim((String) header.get("order_no"));
			tranType =  checkNullandTrim((String) header.get("tran_type"));
			sPos = getGstStateCode(siteCode,conn);
			System.out.println("b2clInvVal :"+sPos);


			if(header.get("detailData")!= null)
			{
				ArrayList<HashMap<String, String>> detailAl = (ArrayList<HashMap<String, String>>) header.get("detailData");
				for(Iterator<HashMap<String, String>> iter = detailAl.iterator();iter.hasNext();)
				{
					HSSFSheet sheet1 =  outputWorkbook.getSheet("DetailShit"); 
					currentDetilRow = sheet1.getLastRowNum()+1;
					HSSFRow rowdetail = sheet1.createRow((currentDetilRow));				
					HashMap<String, String> detail = iter.next();
                      
					lineNo =  checkNullandTrim((String) detail.get("line_no"));
					System.out.println("  lineNo="+  lineNo);
					gscodeDet =  checkNullandTrim((String) detail.get("gs_code"));
					gsdescrDet =  checkNullandTrim((String) detail.get("gs_descr"));
					unitDet =  checkNullandTrim((String) detail.get("unit"));
					//gstRate =  Double.parseDouble(detail.get("gst_rate")) ;
					gstRate = getDouble((String)detail.get("gst_rate"));
					System.out.println(" gstRate="+ gstRate);
					if(gstRate <= 0)
					{
						isWithPay = true;
					}
					taxableamtDet =  checkNullandTrim((String) detail.get("taxable_amt"));
					System.out.println(" taxableAmt="+ taxableamtDet);
					cessamtDet =  checkNullandTrim((String) detail.get("cess_amt"));
					System.out.println(" cessAmt="+ cessamtDet);
					quantityDet =  checkNullandTrim((String) detail.get("quantity"));
					System.out.println(" quantityDet="+ quantityDet);
					
					itctypeDet =  checkNullandTrim((String) detail.get("itc_type"));
					if(itctypeDet != null && itctypeDet.trim().length() > 0)
					{
						itctypeDet = itctypeDet.split("-")[0];
						System.out.println(" itctypeDet="+ itctypeDet);
					}
					itcigstDet =  checkNullandTrim((String) detail.get("itc_igst"));
					System.out.println(" itcigstDet="+ itcigstDet);
					
					itccgstDet =  checkNullandTrim((String) detail.get("itc_cgst"));
					System.out.println(" itccgstDet="+ itccgstDet);
					
					itcsgstDet =  checkNullandTrim((String) detail.get("itc_sgst"));
					System.out.println(" itcsgstDet="+ itcsgstDet);
					
					itccessDet =  checkNullandTrim((String) detail.get("itc_cess"));
					System.out.println(" itccessDet="+ itccessDet);

					//insert data in to detail sheet....
					rowdetail.createCell(0).setCellValue(currentHaderRow);
					rowdetail.createCell(1).setCellValue(lineNo);
					rowdetail.createCell(2).setCellValue(statusDet);
					rowdetail.createCell(3).setCellValue(srnoOldDet);
					rowdetail.createCell(4).setCellValue(lineTypeDet);
					rowdetail.createCell(5).setCellValue(gscodeDet);
					rowdetail.createCell(6).setCellValue(taxableamtDet);
					rowdetail.createCell(7).setCellValue(igstpercDet);
					rowdetail.createCell(8).setCellValue(igstamtDet);
					rowdetail.createCell(9).setCellValue(cgstpercDet);
					rowdetail.createCell(10).setCellValue(cgstamtDet);
					rowdetail.createCell(11).setCellValue(sgstpercDet);
					rowdetail.createCell(12).setCellValue(sgstamtDet);
					rowdetail.createCell(13).setCellValue(gsdescrDet);
					rowdetail.createCell(14).setCellValue(unitDet);
					rowdetail.createCell(15).setCellValue(quantityDet);
					rowdetail.createCell(16).setCellValue(supptypeDet);
					rowdetail.createCell(17).setCellValue(cesspercDet);
					rowdetail.createCell(18).setCellValue(cessamtDet);
					rowdetail.createCell(19).setCellValue(remarksDet);
					rowdetail.createCell(20).setCellValue(itctypeDet);
					rowdetail.createCell(21).setCellValue(itcigstDet);
					rowdetail.createCell(22).setCellValue(itccgstDet);
					rowdetail.createCell(23).setCellValue(itcsgstDet);
					rowdetail.createCell(24).setCellValue(itccessDet);
					rowdetail.createCell(25).setCellValue(gstRate);
					currentDetilRow++;
				}
			}
	         // Get GST_TYPE by sheetName.
					if("b2b".equalsIgnoreCase(eachSheetName) && "N".equalsIgnoreCase(reverseChrg) )
					{
						gstType="I";
					}

					else if("b2b".equalsIgnoreCase(eachSheetName) && "Y".equalsIgnoreCase(reverseChrg))
					{
						gstType="R";
					}
					
					else if("b2c".equalsIgnoreCase(eachSheetName) && (taxRegNo.length() ==0)&&(custName.length() >0))
					{
						gstType="U";
					}
					
					else if("nil".equalsIgnoreCase(eachSheetName))
					{
						gstType="L";
						docDate = glbDocDate;//For Nil Rated
						prdCodenew = glbPeriodeCode;//For Nil Rated
					}
					else if("itc".equalsIgnoreCase(eachSheetName))
					{
						gstType="V";
						docDate = glbDocDate;//For Nil Rated
						prdCodenew = glbPeriodeCode;//For Nil Rated
					}
					if("I".equalsIgnoreCase(gstType)) //B2B Supplies, with SEZ and deemed exports
					{
						if((taxRegNo.length() > 0)
								&& ("N".equalsIgnoreCase(reverseChrg) || "".equalsIgnoreCase(reverseChrg))
								&& ("R".equalsIgnoreCase(documentAct) || "".equalsIgnoreCase(documentAct)))
						{
							tranType = "01";
						}
						else if((taxRegNo.length() > 0) 
								&& ("N".equalsIgnoreCase(reverseChrg) || "".equalsIgnoreCase(reverseChrg))
								&& ("Z".equalsIgnoreCase(documentAct) || "".equalsIgnoreCase(documentAct) && !isWithPay))
						{
							tranType = "02";
						}
						else if((taxRegNo.length() > 0) 
								&& ("N".equalsIgnoreCase(reverseChrg) || "".equalsIgnoreCase(reverseChrg))
								&& ("Z".equalsIgnoreCase(documentAct) || "".equalsIgnoreCase(documentAct) && isWithPay))
						{
							tranType = "03";
						}
						else if((taxRegNo.length() > 0) 
								&& ("N".equalsIgnoreCase(reverseChrg) || "".equalsIgnoreCase(reverseChrg))
								&& ("DE".equalsIgnoreCase(documentAct) || "".equalsIgnoreCase(documentAct)))
						{
							tranType = "04";
						}
					}
					System.out.println("VAlues of b2c :"+" "+taxRegNo.length()+reverseChrg+ " "+ecomRegNo.length() +" "+sPos  +" "+b2clInvVal);

					if("R".equalsIgnoreCase(gstType))
					{
						tranType = "05";
					}
					
					else if("U".equalsIgnoreCase(gstType)) //B2BUR  unregistered supplies no taxRegNO
					{
						tranType = "06";
					}

					else if("S".equalsIgnoreCase(gstType))//IMPS Import of service invoice data
					{
						tranType = "07";
					}
					else if("G".equalsIgnoreCase(gstType))
					{
						if( taxRegNo.length() > 0)  //IMPG Import of goods from SEZ
						{
							tranType = "09";
						}
						else
						{
							tranType = "08"; //IMPG Import of goods
						}
					}
					else if("C".equalsIgnoreCase(gstType))
					{
						if( taxRegNo.length() > 0) //Credit Note to registered customer 
						{
							tranType = "12";
						}
						else
						{
							tranType = "13"; //Credit Note to unregistered customer 
						}
					}
					else if("D".equalsIgnoreCase(gstType)) //Debite Note to registered customer 
					{
						if( taxRegNo.length() > 0)  
						{
							tranType = "10";
						}
						else //Debit Note to unregistered customer 
						{
							tranType = "11";
						}
					}

					else if("A".equalsIgnoreCase(gstType))
					{
						if(sPos.equalsIgnoreCase(gstType)) //TXPI Intra-State advance Paid(Rate wise)
						{
							tranType = "14";
						}
						else if(!sPos.equalsIgnoreCase(gstType)) // TXPI Inter-State advance Paid(Rate wise)
						{
							tranType = "15";
						}
					}
					else if("T".equalsIgnoreCase(gstType))//Advance adjusted 
					{
						if(sPos.equalsIgnoreCase(gstType)) //TXPD Intra-State advance adjusted(Rate wise)
						{
							tranType = "16";
						}
						else if(!sPos.equalsIgnoreCase(gstType))//TXPD Inter-State advance adjusted(Rate wise)
						{
							tranType = "17";
						}
					}
			rowheader.createCell(0).setCellValue(currentHaderRow);
			rowheader.createCell(1).setCellValue(tranDate);
			rowheader.createCell(2).setCellValue(tranIdRef);
			rowheader.createCell(3).setCellValue(siteCode);
			rowheader.createCell(4).setCellValue(prdCodenew);
			rowheader.createCell(5).setCellValue(recType);
			rowheader.createCell(6).setCellValue(tranType);
			rowheader.createCell(7).setCellValue(custCode);
			rowheader.createCell(8).setCellValue(custName);
			rowheader.createCell(9).setCellValue(subType);
			rowheader.createCell(10).setCellValue(docCheckSum);
			rowheader.createCell(11).setCellValue(documentAct);
			rowheader.createCell(12).setCellValue(docNo);
			rowheader.createCell(13).setCellValue(docDate);
			rowheader.createCell(14).setCellValue(invAmt);
			rowheader.createCell(15).setCellValue(reverseChrg);
			rowheader.createCell(16).setCellValue(lrNo);
			rowheader.createCell(17).setCellValue(lrDate);
			rowheader.createCell(18).setCellValue(reasCode);
			rowheader.createCell(19).setCellValue(refIdInv);
			rowheader.createCell(20).setCellValue(refDateInv);
			rowheader.createCell(21).setCellValue(provAssmnt);
			rowheader.createCell(22).setCellValue(ordNo);
			rowheader.createCell(23).setCellValue(ordDate);
			rowheader.createCell(24).setCellValue(remarks);
			rowheader.createCell(25).setCellValue(subStatus);
			rowheader.createCell(26).setCellValue(subDate);
			rowheader.createCell(27).setCellValue(addUser);
			rowheader.createCell(28).setCellValue(addDate);
			rowheader.createCell(29).setCellValue(addTerm);
			rowheader.createCell(30).setCellValue(chgUser);
			rowheader.createCell(31).setCellValue(chgDate);
			rowheader.createCell(32).setCellValue(chgTerm);
			rowheader.createCell(33).setCellValue(taxRegNo);
			rowheader.createCell(34).setCellValue(Name);
			rowheader.createCell(35).setCellValue(recoStatus);
			rowheader.createCell(36).setCellValue(ecomRegNo);
			rowheader.createCell(37).setCellValue(refSer);
			rowheader.createCell(38).setCellValue(gstCodeAct);
			rowheader.createCell(39).setCellValue(gstType);
			rowheader.createCell(40).setCellValue(refId);
			currentHaderRow++;
			}	
		}
		catch (Exception e)
		{
			System.out.println("Exception 1::"  +headersql+""+ e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			
		}
		return outputWorkbook;
	}
	
	/*public String insertsql(HashMap<String, HashMap<String, Object>> b2bInvoicesHMap,UserInfoBean userInfo,String sheetType)throws Exception , SQLException
	{   FinCommon  finCommon = new FinCommon(); 
		
		System.out.println("Inside Insert SQL :");
		Connection  conn=null;
		ResultSet rs = null;String headersql="",detailSql="";
		Boolean isError = false,isWithPay=false;
		PreparedStatement pstmt=null , pstmt1=null;
		String  taxRegNo="",refIdInv="",refDateInv="",gstCode="",gstCodeAct="",reverseChrg="",document="",documentAct="",ecomRegNo="",transactionId="",siteCode="";
		String  lineNo="",provAssmnt="",ordNo="",subStatus="",addUser="",addTerm="",statusDet="",srnoOldDet="",lineTypeDet="",gscodeDet="";
		String  subDate="",chgUser="",chgTerm="",chgDate="",taxableamtDet="",igstpercDet="",igstamtDet="",cgstpercDet="",cgstamtDet="",sgstpercDet="";
		String  docDate = null,lrDate = null,ordDate="",refId="",addDate="",sgstamtDet="",gsdescrDet="",unitDet="",quantityDet="",supptypeDet="",cesspercDet="",cessamtDet="";
		String  tranType = "",custCode = "",custName = "",subType="",itctypeDet="",itcigstDet="",itccgstDet="",
				docCheckSum = "",docNo = "",lrNo = "",reasCode = "",itcsgstDet="",itccessDet="",remarks = "",tranIdRef="",
				recoStatus = "",refSer = "",docType = "",remarksDet = "",
				gstType = "",tranDate="",sPos="", message="";
        String recType = "2";
		int caseCount = 0;
		double invAmt=0, b2clInvVal=0,gstRate=0;
		Timestamp refDateAct = null;
		
		try
		{ 
			String validationMsg = validateInput(b2bInvoicesHMap,sheetType);
			if(validationMsg != null && validationMsg.trim().length() > 0)
			{
				return validationMsg;
			}
			conn = getConnection();
			b2clInvVal = Double.parseDouble(finCommon.getFinparams("999999", "GST_B2CL_INV_VAL", conn));
			System.out.println("b2clInvVal :"+b2clInvVal);
			

			for (String key : b2bInvoicesHMap.keySet()) 
			{
				HashMap header = (HashMap) b2bInvoicesHMap.get(key);
				//HashMap HeraderMap = (HashMap) b2bInvoicesHMap.get(key);
				siteCode = userInfo.getSiteCode();
				System.out.println("Inside Insert SQL :");
				transactionId = generateTranId("w_gstr_purc",  siteCode, conn);
				System.out.println("GSTTranId ::::::::::::: " + transactionId);
				//taxRegNo = checkNullandTrim((String) header.get("tax_reg_no"));
				taxRegNo = checkNullandTrim((String) header.get("tax_reg_no"));
				System.out.println("taxRegNo="+taxRegNo);
				custName = checkNullandTrim((String) header.get("cust_name"));
				System.out.println("custName="+custName);
				refIdInv = checkNullandTrim((String) header.get("ref_id__inv"));
				System.out.println("refIdInv="+refIdInv);
				refDateInv =checkNullandTrim( (String) header.get("ref_date__inv"));
				System.out.println("refDateInv"+refDateInv);
				refDateAct = getTimeStamp(refDateInv);
				System.out.println("refDateAct="+refDateAct);
				//invAmt =	Double.parseDouble((String) header.get("amount"));
				invAmt = getDouble((String)header.get("amount"));
				System.out.println("invAmt="+invAmt);
				gstCode =  checkNullandTrim((String) header.get("gst_code"));
				if(gstCode != null && gstCode.trim().length() > 0)
				{
					gstCodeAct = gstCode.substring(0, 2);
				}
				System.out.println("gstCodeAct="+gstCodeAct);
				reverseChrg =  checkNullandTrim((String) header.get("reverse_chrg"));
				System.out.println("reverseChrg="+reverseChrg);
				document =  checkNullandTrim((String) header.get("doc_type"));
				System.out.println("document="+document);
				if(document != null && document.trim().length() > 0)
				{
					documentAct = document.split("-")[0];
				}
				System.out.println("documentAct="+documentAct);
				ecomRegNo =  checkNullandTrim((String) header.get("ecom_reg_no"));
				System.out.println("ecomRegNo="+ecomRegNo);
				gstType =  checkNullandTrim((String) header.get("gst_type"));
				if(gstType != null && gstType.trim().length() > 0)
				{
					gstType = gstType.split("-")[0];
				}
				docDate =  checkNullandTrim((String) header.get("doc_date"));
				String prdCodenew=	genericUtility.getValidDateString(docDate, genericUtility.getApplDateFormat(), "MMYYYY");
				System.out.println("prdCodenew" +prdCodenew);
				System.out.println("prdCodenew"+prdCodenew);
				docNo =  checkNullandTrim((String) header.get("doc_no"));
				reasCode =  checkNullandTrim((String) header.get("reas_code"));
				lrNo =  checkNullandTrim((String) header.get("lr_no"));
				lrDate =  checkNullandTrim((String) header.get("lr_date"));
				ordNo =  checkNullandTrim((String) header.get("order_no"));
				tranType =  checkNullandTrim((String) header.get("tran_type"));
				sPos = getGstStateCode(siteCode,conn);
				System.out.println("b2clInvVal :"+sPos);
				

				if(header.get("detailData")!= null)
				{
					ArrayList<HashMap<String, String>> detailAl = (ArrayList<HashMap<String, String>>) header.get("detailData");
					detailSql = "insert into gst_data_det(TRAN_ID,LINE_NO,STATUS,SR_NO__OLD,LINE_TYPE,GS_CODE,TAXABLE_AMT,IGST_PERC,IGST_AMT,CGST_PERC,CGST_AMT,SGST_PERC,SGST_AMT,GS_DESCR,UNIT,QUANTITY,SUPPLY_TYPE,CESS_PERC,CESS_AMT,REMARKS,ITC_TYPE,ITC_IGST,ITC_CGST,ITC_SGST,ITC_CESS,GST_RATE) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)"; //Insert INTO GST_DATA_DET Table....
					pstmt1 = conn.prepareStatement(detailSql);
					for(Iterator<HashMap<String, String>> iter = detailAl.iterator();iter.hasNext();)
					{
						HashMap<String, String> detail = iter.next();
						lineNo =  checkNullandTrim((String) detail.get("line_no"));
						System.out.println("  lineNo="+  lineNo);
						gscodeDet =  checkNullandTrim((String) detail.get("gs_code"));
						gsdescrDet =  checkNullandTrim((String) detail.get("gs_descr"));
						unitDet =  checkNullandTrim((String) detail.get("unit"));
						//	gstRate =  Double.parseDouble(detail.get("gst_rate")) ;
						gstRate = getDouble((String)detail.get("gst_rate"));
						System.out.println(" gstRate="+ gstRate);
						if(gstRate <= 0)
						{
							isWithPay = true;
						}
						taxableamtDet =  checkNullandTrim((String) detail.get("taxable_amt"));
						System.out.println(" taxableAmt="+ taxableamtDet);
						cessamtDet =  checkNullandTrim((String) detail.get("cess_amt"));
						System.out.println(" cessAmt="+ cessamtDet);
						
						itctypeDet =  checkNullandTrim((String) detail.get("itc_type"));
						if(itctypeDet != null && itctypeDet.trim().length() > 0)
						{
							itctypeDet = itctypeDet.split("-")[0];
							System.out.println(" itc_type ="+ itctypeDet);
						}
						itcigstDet =  checkNullandTrim((String) detail.get("itc_igst"));
						System.out.println(" itc_igst="+ itcigstDet);
						itccgstDet =  checkNullandTrim((String) detail.get("itc_cgst"));
						System.out.println(" itc_cgst="+ itccgstDet);
						itcsgstDet =  checkNullandTrim((String) detail.get("itc_sgst"));
						System.out.println(" itc_sgst="+ itcsgstDet);
						itccessDet =  checkNullandTrim((String) detail.get("itc_cess"));
						System.out.println(" itc_cess="+ itccessDet);
						

						pstmt1.setString(1,transactionId);	
						pstmt1.setString(2,lineNo);
						pstmt1.setString(3,statusDet);
						pstmt1.setString(4,srnoOldDet);
						pstmt1.setString(5,lineTypeDet);
						pstmt1.setString(6,gscodeDet);
						pstmt1.setString(7,taxableamtDet);
						pstmt1.setString(8,igstpercDet);
						pstmt1.setString(9,igstamtDet);
						pstmt1.setString(10,cgstpercDet);
						pstmt1.setString(11,cgstamtDet);
						pstmt1.setString(12,sgstpercDet);
						pstmt1.setString(13,sgstamtDet);
						pstmt1.setString(14,gsdescrDet);
						pstmt1.setString(15,unitDet);
						pstmt1.setString(16,quantityDet);
						pstmt1.setString(17,supptypeDet);
						pstmt1.setString(18,cesspercDet);
						pstmt1.setString(19,cessamtDet);
						pstmt1.setString(20,remarksDet);
						pstmt1.setString(21,itctypeDet);
						pstmt1.setString(22,itcigstDet);
						pstmt1.setString(23,itccgstDet);
						pstmt1.setString(24,itcsgstDet);
						pstmt1.setString(25,itccessDet);
						pstmt1.setDouble(26,gstRate);
						pstmt1.addBatch();
						pstmt1.clearParameters();
					}
				}
                 // Get GST_TYPE by sheetName.
				if("b2b".equalsIgnoreCase(sheetType) && "N".equalsIgnoreCase(reverseChrg) )
				{
					gstType="I";
				}

				else if("b2b".equalsIgnoreCase(sheetType) && "Y".equalsIgnoreCase(reverseChrg))
				{
					gstType="R";
				}
				
				else if("b2b".equalsIgnoreCase(sheetType) && (taxRegNo.length() ==0)&&(custName.length() >0))
				{
					gstType="U";
				}
				else if("b2c".equalsIgnoreCase(sheetType))
				{
					gstType="S";
				}
				else if("import".equalsIgnoreCase(sheetType))
				{
					gstType="G";
				}
				else if("import".equalsIgnoreCase(sheetType))
				{
					gstType="S";
				}

				else if("nil".equalsIgnoreCase(sheetType))
				{
					gstType="L";
				}
				else if("itc".equalsIgnoreCase(sheetType))
				{
					gstType="V";
				}


				if("I".equalsIgnoreCase(gstType)) //B2B Supplies, with SEZ and deemed exports
				{
					if((taxRegNo.length() > 0)
							&& ("N".equalsIgnoreCase(reverseChrg) || "".equalsIgnoreCase(reverseChrg))
							&& ("R".equalsIgnoreCase(docType) || "".equalsIgnoreCase(docType)))
					{
						tranType = "01";
					}
					else if((taxRegNo.length() > 0) 
							&& ("N".equalsIgnoreCase(reverseChrg) || "".equalsIgnoreCase(reverseChrg))
							&& ("Z".equalsIgnoreCase(docType) || "".equalsIgnoreCase(docType) && !isWithPay))
					{
						tranType = "02";
					}
					else if((taxRegNo.length() > 0) 
							&& ("N".equalsIgnoreCase(reverseChrg) || "".equalsIgnoreCase(reverseChrg))
							&& ("Z".equalsIgnoreCase(docType) || "".equalsIgnoreCase(docType) && isWithPay))
					{
						tranType = "03";
					}
					else if((taxRegNo.length() > 0) 
							&& ("N".equalsIgnoreCase(reverseChrg) || "".equalsIgnoreCase(reverseChrg))
							&& ("DE".equalsIgnoreCase(docType) || "".equalsIgnoreCase(docType)))
					{
						tranType = "04";
					}
				}
				System.out.println("VAlues of b2c :"+" "+taxRegNo.length()+reverseChrg+ " "+ecomRegNo.length() +" "+sPos  +" "+b2clInvVal);

				if("R".equalsIgnoreCase(gstType))
				{
					tranType = "05";
				}
				
				else if("U".equalsIgnoreCase(gstType)) //B2BUR  unregistered supplies no taxRegNO
				{
					tranType = "06";
				}

				else if("S".equalsIgnoreCase(gstType))//IMPS Import of service invoice data
				{
					tranType = "07";
				}
				else if("G".equalsIgnoreCase(gstType))
				{
					if( taxRegNo.length() > 0)  //IMPG Import of goods from SEZ
					{
						tranType = "09";
					}
					else
					{
						tranType = "08"; //IMPG Import of goods
					}
				}
				else if("C".equalsIgnoreCase(gstType))
				{
					if( taxRegNo.length() > 0) //Credit Note to registered customer 
					{
						tranType = "12";
					}
					else
					{
						tranType = "13"; //Credit Note to unregistered customer 
					}
				}
				else if("D".equalsIgnoreCase(gstType)) //Debite Note to registered customer 
				{
					if( taxRegNo.length() > 0)  
					{
						tranType = "10";
					}
					else //Debit Note to unregistered customer 
					{
						tranType = "11";
					}
				}

				else if("A".equalsIgnoreCase(gstType))
				{
					if(sPos.equalsIgnoreCase(gstType)) //TXPI Intra-State advance Paid(Rate wise)
					{
						tranType = "14";
					}
					else if(!sPos.equalsIgnoreCase(gstType)) // TXPI Inter-State advance Paid(Rate wise)
					{
						tranType = "15";
					}
				}
				else if("T".equalsIgnoreCase(gstType))//Advance adjusted 
				{
					if(sPos.equalsIgnoreCase(gstType)) //TXPD Intra-State advance adjusted(Rate wise)
					{
						tranType = "16";
					}
					else if(!sPos.equalsIgnoreCase(gstType))//TXPD Inter-State advance adjusted(Rate wise)
					{
						tranType = "17";
					}
				}

				headersql="insert into gst_data_hdr(TRAN_ID,TRAN_DATE,TRAN_ID__REF,SITE_CODE,PRD_CODE,REC_TYPE,TRAN_TYPE,CUST_CODE,CUST_NAME,SUBMISSION_TYPE,DOC_CHECKSUM,DOC_TYPE,DOC_NO,DOC_DATE,AMOUNT,REVERSE_CHRG,LR_NO,LR_DATE,REAS_CODE,REF_ID__INV,REF_DATE__INV,PROV_ASSMNT,ORDER_NO,ORDER_DATE,REMARKS,SUBMIT_STATUS,SUBMIT_DATE,ADD_USER,ADD_DATE,ADD_TERM,CHG_USER,CHG_DATE,CHG_TERM,TAX_REG_NO,RECO_STATUS,ECOM_REG_NO,REF_SER,GST_CODE,GST_TYPE,REF_ID) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				pstmt = conn.prepareStatement(headersql);
				System.out.println("PSTMT"+pstmt);
				pstmt.setString(1,transactionId);	
				pstmt.setTimestamp(2,getTimeStamp(tranDate));	
				pstmt.setString(3,tranIdRef);	
				pstmt.setString(4,siteCode);
				pstmt.setString(5,prdCodenew);
				pstmt.setString(6,recType);	
				pstmt.setString(7,tranType);
				pstmt.setString(8,custCode);
				pstmt.setString(9,custName);
				pstmt.setString(10,subType);
				pstmt.setString(11,docCheckSum);	
				pstmt.setString(12,documentAct);
				pstmt.setString(13,docNo);	//doc_no
				pstmt.setTimestamp(14,getTimeStamp(docDate));
				pstmt.setDouble(15,invAmt);
				pstmt.setString(16,reverseChrg);	
				pstmt.setString(17,lrNo);
				pstmt.setTimestamp(18,getTimeStamp(lrDate));	
				pstmt.setString(19,reasCode);
				pstmt.setString(20,refIdInv);
				pstmt.setTimestamp(21,(refDateAct));
				pstmt.setString(22,provAssmnt);
				pstmt.setString(23,ordNo);	
				pstmt.setTimestamp(24,getTimeStamp(ordDate));
				pstmt.setString(25,remarks);		
				pstmt.setString(26,subStatus);
				pstmt.setTimestamp(27,getTimeStamp(subDate));
				pstmt.setString(28,addUser);	
				pstmt.setTimestamp(29,getTimeStamp(addDate));
				pstmt.setString(30,addTerm);	
				pstmt.setString(31,chgUser);
				pstmt.setTimestamp(32,getTimeStamp(chgDate));	
				pstmt.setString(33,chgTerm);
				pstmt.setString(34,taxRegNo);	
				pstmt.setString(35,recoStatus);
				pstmt.setString(36,ecomRegNo);		
				pstmt.setString(37,refSer);
				pstmt.setString(38,gstCodeAct);		
				pstmt.setString(39,gstType);
				pstmt.setString(40,refId);

				caseCount = pstmt.executeUpdate();
				pstmt.close(); pstmt = null;
				System.out.println("Update Count GSTHDR= "+caseCount);
				if(header.get("detailData")!= null)
				{
					int[] count = pstmt1.executeBatch();
					pstmt1.close(); pstmt1 = null;
				}
				System.out.println("Update Count GSTDET= "+caseCount);
			}	
			message ="Template Upload Succefully";
		}
		catch (Exception e)
		{
			System.out.println("Exception 1::"  +headersql+""+ e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			System.out.println("updategst isError="+isError);
			if(isError)
			{
				conn.rollback();
			}
			else
			{
				conn.commit();
			}
			if(pstmt != null){pstmt.close();pstmt = null;}
			if(pstmt1 != null){pstmt1.close();pstmt1 = null;}
			if(rs != null){rs.close();rs = null;}
			if(conn != null){conn.close();conn = null;}
		}
		return message;
	}*/
	private double getDouble(String amount) 
	{
	double result = 0.0;
	result = Double.parseDouble((amount==null||amount.equals("")) ? "0" : amount);
	return result;
	}
	private String  getGstStateCode(String siteCode , Connection conn) throws ITMException
	{
		String pos ="";
		String sSQL ="";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		try
		{
			
			sSQL = "SELECT ST.GST_CODE FROM TARODEV.SITE S,TARODEV.STATE ST WHERE S.STATE_CODE = ST.STATE_CODE AND S.SITE_CODE = ?";
			pstmt = conn.prepareStatement(sSQL);
			pstmt.setString(1,siteCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				pos = rs.getString("GST_CODE");
			}
			
			if(pstmt != null)
			{
			    pstmt.close(); 
			    pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
			    rs = null;
			} 
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs != null )
				{
					rs.close();rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();pstmt = null;
				}
			}
			catch( Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		
		return pos;
	}
	
	public String generateTranId( String windowName, String siteCode, Connection conn )throws Exception
	{
		System.out.println("windowName inside generateTranId =========>>"+windowName);
		System.out.println("siteCode inside generateTranId =========>>"+siteCode);
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String selSql = "";
		String tranId = "";
		String tranSer = "";
		String keyString = "";
		String keyCol = "";
		String xmlValues = "";
		String paySiteCode = "";
		String effectiveDate = "";
		java.sql.Timestamp currDate = null;
		java.sql.Date effDate = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{
			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			String currDateStr = sdfAppl.format(currDate);

			selSql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";

			pstmt = conn.prepareStatement(selSql);
			pstmt.setString( 1, windowName );
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				keyString = rs.getString("KEY_STRING");
				keyCol = rs.getString("TRAN_ID_COL");
				tranSer = rs.getString("REF_SER");
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
			System.out.println("keyString :"+keyString);
			System.out.println("keyCol :"+keyCol);
			System.out.println("tranSer :"+tranSer);

			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +        "<tran_id></tran_id>";
			xmlValues = xmlValues +        "<site_code>" + siteCode + "</site_code>";
			xmlValues = xmlValues +        "<tran_date>" + currDateStr + "</tran_date>";
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			System.out.println("tranId :"+tranId);
		}
		catch (SQLException ex)
		{
			System.out.println("Exception 2::" +selSql+ ex.getMessage() + ":");
			ex.printStackTrace();throw new ITMException(ex);
		}
		return tranId;
	}
	private static String checkNullandTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
	//	System.out.println("Input" +input);
		return input.trim();
		
	}
	private Timestamp getTimeStamp(String dateStr) throws ITMException, Exception 
	{
		String dbDateStr = "";
		if(dateStr != null && !dateStr.equals(""))
		{
			dbDateStr =(new E12GenericUtility()).getValidDateTimeString(dateStr, (new E12GenericUtility()).getApplDateTimeFormat(), (new E12GenericUtility()).getDBDateTimeFormat());
			return java.sql.Timestamp.valueOf(dbDateStr);          
		}
		else
		{
			return null;
		}
	}
	
	public String validateInput(HashMap<String, HashMap<String, Object>> b2bInvoicesHMap,String sheetType)throws  Exception 
	{
		String validationMsg="";
		try
		{
		if("b2b".equalsIgnoreCase(sheetType))
		{
			for (String key : b2bInvoicesHMap.keySet()) 
			{
				HashMap header = (HashMap) b2bInvoicesHMap.get(key);
				if(header.get("tax_reg_no")== null && ("b2b".equalsIgnoreCase(sheetType) ||"cdn".equalsIgnoreCase(sheetType)))
				{   
					/*DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
					DocumentBuilder dBuilder =  dbFactory.newDocumentBuilder();
					Document doc = dBuilder.newDocument();
					Element rootElement = doc.createElement("validation");
					doc.appendChild(rootElement);
					Element sheetName = doc.createElement("sheet_name");
					rootElement.appendChild(sheetName);
					doc.createTextNode(sheetType);
					Element focusColumn = doc.createElement("focus_column");
					rootElement.appendChild(focusColumn);
					doc.createTextNode(sheetType);
					Element validDescr = doc.createElement("valid_descr");
					rootElement.appendChild(validDescr);
					doc.createTextNode("Enter TAX REG NO ");*/
					String validMsg ="Enter Valid TAX REG NO ";
		    		String msg ="<validation>"+
					"<sheet_name>"+sheetType+"</sheet_name>"+
					"<focus_coloumn>"+sheetType+"</focus_coloumn>"+
					"<valid_descr>"+validMsg+"</valid_descr>"+
					"</validation>";
				throw new Exception(msg);
				}
				if(header.get("doc_no")== null && ("b2b".equalsIgnoreCase(sheetType) ||"cdn".equalsIgnoreCase(sheetType)))
				{
					String validMsg ="Enter Valid Document NO ";
		    		String msg ="<validation>"+
					"<sheet_name>"+sheetType+"</sheet_name>"+
					"<focus_coloumn>"+sheetType+"</focus_coloumn>"+
					"<valid_descr>"+validMsg+"</valid_descr>"+
					"</validation>";
				throw new Exception(msg);
				}
				if(header.get("doc_date")== null && ("b2b".equalsIgnoreCase(sheetType) ||"cdn".equalsIgnoreCase(sheetType)))
				{
					String validMsg ="Enter Valid Document Date ";
		    		String msg ="<validation>"+
					"<sheet_name>"+sheetType+"</sheet_name>"+
					"<focus_coloumn>"+sheetType+"</focus_coloumn>"+
					"<valid_descr>"+validMsg+"</valid_descr>"+
					"</validation>";
				throw new Exception(msg);
				}
				if(header.get("amount")== null && ("b2b".equalsIgnoreCase(sheetType) ||"cdn".equalsIgnoreCase(sheetType)))
				{
					String validMsg ="Enter Valid Amount";
		    		String msg ="<validation>"+
					"<sheet_name>"+sheetType+"</sheet_name>"+
					"<focus_coloumn>"+sheetType+"</focus_coloumn>"+
					"<valid_descr>"+validMsg+"</valid_descr>"+
					"</validation>";
				throw new Exception(msg);
				}
				if(header.get("gst_code")== null)
				{
					String validMsg ="Enter Valid GST CODE ";
		    		String msg ="<validation>"+
					"<sheet_name>"+sheetType+"</sheet_name>"+
					"<focus_coloumn>"+sheetType+"</focus_coloumn>"+
					"<valid_descr>"+validMsg+"</valid_descr>"+
					"</validation>";
				throw new Exception(msg);
					
				}
				if(header.get("detailData")!= null)
				{
					ArrayList<HashMap<String, String>> detailAl = (ArrayList<HashMap<String, String>>) header.get("detailData");
					for(Iterator<HashMap<String, String>> iter = detailAl.iterator();iter.hasNext();)
					{
						
					}
				}
			}
		}
	}
	catch (Exception e)
	{
		throw new Exception();
	}
		return validationMsg;
		
	}
	
	protected InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("GstrCustomTranServlet.getInitialContext()");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("GstrCustomTranServlet.getInitialContext()"+e.getMessage());
			throw new ITMException(e);
		}
		return ctx;
	}
}


