package ibase.dashboard.scm.bean;
import ibase.dashboard.scm.ejb.*;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;
import java.io.Serializable;
import java.rmi.RemoteException;
import javax.naming.InitialContext;

@SuppressWarnings("serial")
public class LocationStockOccuBean implements Serializable
{

	LocationStockOccupancyRemote  locationStockOccupancyRemote = null;  

	public LocationStockOccuBean()
	{
		System.out.println("inside LocationStockOccuBean Created");
		InitialContext ctx  = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
			locationStockOccupancyRemote = (LocationStockOccupancyRemote) ctx.lookup("ibase/LocationStockOccupancy/remote");
			System.out.println("instance created");
			
		}
		catch(Exception e)
		{
			System.out.println("Exception in creating LocationStockOccupancy");
			e.printStackTrace();
		}
	}
	
	public String getLocPhyArea() throws RemoteException, ITMException
	{
		String xmlData = "";
		try
		{
			xmlData = locationStockOccupancyRemote.getLocPhyArea();
		}
		catch(Exception e)
		{
			System.out.println("Exception in LocationStockOccuBean.getLocPhyArea() in accessing EJB");
			e.printStackTrace();
			xmlData = null;
		}
		return xmlData;
	}
	
	public String getSelectedArea( )
	{
		
		String selectedEntity="";
		try
		{
			selectedEntity = locationStockOccupancyRemote.getSelectedArea();
		}
		catch(Exception e)
		{
			System.out.println("Exception in LocationStockOccuBean.getSelectedArea() in accessing EJB");
			e.printStackTrace();
			selectedEntity = null;
		}
		return selectedEntity;
	}
	
	public String getLocDtl(String locPhyArea, String siteCode,String locationRange) throws RemoteException, ITMException
	{
		String xmlData ="";		
		try
		{			
			xmlData = locationStockOccupancyRemote.getLocDtl(locPhyArea,siteCode,locationRange);
		
		}
		catch(Exception e)
		{
			System.out.println("Exception in LocationStockOccuBean.getLocDtl() in accessing EJB");
			e.printStackTrace();
			xmlData = null;
		}
		return xmlData;
		
	}
		
}
