import { Component, Input } from '@angular/core';
export class ValidationComponent {
    /*
      private readonly defErrorMessages = {
          'required': () => 'Required field',
          'minlength': ( params ) => 'The min number of characters is ' + params.requiredLength,
          'maxlength': ( params ) => 'The max allowed number of characters is ' + params.requiredLength,
          'email': (params) => params.message,
          'password': (params) => params.message,
          'phone': (params) => params.message
      };
    */
    ngDoCheck() {
        if (this.customErrors) {
            this.localErrors = this.customErrors;
        }
        else if (this.control && this.control.errors) {
            this.localErrors = this.control.errors;
        }
        else {
            this.localErrors = null;
        }
        this.shouldShowErrors();
    }
    shouldShowErrors() {
        return this.localErrors && (this.control.dirty || this.control.touched);
    }
    listOfErrors() {
        return Object.keys(this.localErrors).map(field => this.getMessage(field, this.localErrors[field])).splice(0, 1);
    }
    getMessage(type, params) {
        return this.customErrorMessages[type](params);
    }
}
ValidationComponent.decorators = [
    { type: Component, args: [{
                selector: 'validation',
                template: `
    <span *ngIf="shouldShowErrors()">
      <span style="color: #f44336;" *ngFor="let error of listOfErrors()">{{error}}</span>
    </span>
  `,
                styles: []
            },] },
];
/** @nocollapse */
ValidationComponent.ctorParameters = () => [];
ValidationComponent.propDecorators = {
    'control': [{ type: Input, args: ['control',] },],
    'customErrors': [{ type: Input, args: ['errors',] },],
    'customErrorMessages': [{ type: Input, args: ['errorMessages',] },],
};
//# sourceMappingURL=validation.js.map