import { Validators, } from '@angular/forms';
import { Observable } from 'rxjs';
const normalizeValidator = (validator) => {
    const func = validator.validate.bind(validator);
    if (typeof func === 'function') {
        return (c) => func(c);
    }
    else {
        return validator;
    }
};
export const composeValidators = (validators) => {
    if (validators == null || validators.length === 0) {
        return null;
    }
    return Validators.compose(validators.map(normalizeValidator));
};
export const validate = (validators, asyncValidators) => {
    return (control) => {
        const synchronousValid = () => composeValidators(validators)(control);
        if (asyncValidators) {
            const asyncValidator = composeValidators(asyncValidators);
            return asyncValidator(control).map((v) => {
                const secondary = synchronousValid();
                if (secondary || v) {
                    return Object.assign({}, secondary, v);
                }
            });
        }
        if (validators) {
            return Observable.of(synchronousValid());
        }
        return Observable.of(null);
    };
};
export const message = (validator, key) => {
    switch (key) {
        case 'minlength':
            return 'Value must be N characters';
        case 'maxlength':
            return 'Value must be a maximum of N characters';
    }
    switch (typeof validator[key]) {
        case 'string':
            return validator[key];
        default:
            return ``;
    }
};
//# sourceMappingURL=validate.js.map