import { BaseBlockComponent } from '../base-block.component';
import { Component, Input, ViewChild, forwardRef, Attribute } from '@angular/core';
import { NG_VALUE_ACCESSOR, NG_VALIDATORS, NgModel } from '@angular/forms';
export class BBPhoneComponent extends BaseBlockComponent {
    constructor(validator) {
        super();
        this.validator = validator;
        this.requiredMessage = 'This field is required';
        this.invalidMessage = 'Please enter Valid Phone Number';
        this.bbValidation = false;
        this.bbExpression = /^\+?\d{2}[- ]?\d{3}[- ]?\d{5}$/;
        this.customErrorMessages = {
            'required': () => this.requiredMessage,
            'minlength': (params) => 'The min number of characters is ' + params.requiredLength,
            'maxlength': (params) => 'The max allowed number of characters is ' + params.requiredLength,
            'email': (params) => params.message,
            'password': (params) => params.message,
            'phone': (params) => params.message
        };
        this.bbType = 'tel';
    }
    validate(c) {
        if (!this.validator) {
            return;
        }
        if (!c.value) {
            this.errors = null;
            return;
        }
        const isValidPhone = new RegExp(this.bbExpression, 'i').test(c.value);
        const message = {
            'phone': {
                'message': this.invalidMessage
            }
        };
        if (!isValidPhone) {
            this.errors = message;
        }
        else {
            this.errors = null;
        }
        return isValidPhone ? null : message;
    }
    validateMax(e) {
        var input;
        input = String.fromCharCode(e.which);
        return !!/[\d\s#+-]/.test(input);
    }
}
BBPhoneComponent.decorators = [
    { type: Component, args: [{
                selector: 'bb-phone',
                template: `

      <span [ngSwitch]="uxDesign">
      	<span *ngSwitchCase="'UX3'"> 
      		<md-form-field>
      			<input mdInput #phone="ngModel" [(ngModel)]="value" [type]="bbType" [placeholder]="bbPlaceholder" [required]="bbRequired" [disabled]="bbDisabled" [value]="bbValue" [maxlength]="bbMaxlength" [minlength]="bbMinlength" [readOnly]="bbReadOnly" [autofocus]="bbAutofocus" (keypress)=" validateMax($event);"/>
      			<md-hint>
      				<validation [control]="model" [errors]="errors" [errorMessages]="customErrorMessages"></validation>
      			</md-hint>
      		</md-form-field>	
      	</span>
	
      	<span *ngSwitchCase="'UX2'">
      		<span  [ngClass]="{'labelPostion':bbLabelPostion === 'top'}">{{bbLabel}}</span>
      		<input  #phone="ngModel" [(ngModel)]="value" [type]="bbType" [required]="bbRequired" [disabled]="bbDisabled" [value]="bbValue" [maxlength]="bbMaxlength" [minlength]="bbMinlength" [readOnly]="bbReadOnly" [autofocus]="bbAutofocus" (keypress)=" validateMax($event);"/>
      		<validation [control]="model" [errors]="errors" [errorMessages]="customErrorMessages"></validation>
		
      	</span>
	
      	<span *ngSwitchCase="'UX1'">
      		<input  #phone="ngModel" [(ngModel)]="value" [type]="bbType" [placeholder]="bbPlaceholder" [required]="bbRequired" [disabled]="bbDisabled" [value]="bbValue" [maxlength]="bbMaxlength" [minlength]="bbMinlength" [readOnly]="bbReadOnly" [autofocus]="bbAutofocus" (keypress)=" validateMax($event);" />
      		<validation [control]="model" [errors]="errors" [errorMessages]="customErrorMessages"></validation>
      	</span>
      </span>
    `,
                styles: [`
      .labelPostion{
      display: table;
      }
    `],
                providers: [
                    {
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => BBPhoneComponent),
                        multi: true
                    },
                    {
                        provide: NG_VALIDATORS,
                        useExisting: BBPhoneComponent,
                        multi: true
                    }
                ]
            },] },
];
/** @nocollapse */
BBPhoneComponent.ctorParameters = () => [
    { type: undefined, decorators: [{ type: Attribute, args: ["validator",] },] },
];
BBPhoneComponent.propDecorators = {
    'requiredMessage': [{ type: Input, args: ['requiredMessage',] },],
    'invalidMessage': [{ type: Input, args: ['invalidMessage',] },],
    'bbValidation': [{ type: Input, args: ['validation',] },],
    'bbExpression': [{ type: Input, args: ['expression',] },],
    'model': [{ type: ViewChild, args: [NgModel,] },],
};
//# sourceMappingURL=bb-phone.component.js.map