import { BaseBlockComponent } from '../base-block.component';
import { Component, Input, ViewChild, forwardRef, Attribute } from '@angular/core';
import { NG_VALUE_ACCESSOR, NG_VALIDATORS, NgModel } from '@angular/forms';
export class BBPasswordComponent extends BaseBlockComponent {
    constructor(validator) {
        super();
        this.validator = validator;
        this.requiredMessage = 'This field is required';
        this.invalidMessage = 'Password must be of 8 characters and must contain uppercase, lowercase, digit and a special character';
        this.bbExpression = /^(?=.*\d)(?=.*[!@#$%^&*])(?=.*[a-z])(?=.*[A-Z]).{8,}$/;
        this.customErrorMessages = {
            'required': () => this.requiredMessage,
            'minlength': (params) => 'The min number of characters is ' + params.requiredLength,
            'maxlength': (params) => 'The max allowed number of characters is ' + params.requiredLength,
            'email': (params) => params.message,
            'password': (params) => params.message,
            'phone': (params) => params.message
        };
        this.bbType = 'password';
    }
    validate(c) {
        if (!this.validator) {
            return;
        }
        if (!c.value) {
            this.errors = null;
            return;
        }
        const isValidPassword = new RegExp(this.bbExpression, 'i').test(c.value);
        const message = {
            'password': {
                'message': this.invalidMessage
            }
        };
        if (!isValidPassword) {
            this.errors = message;
        }
        else {
            this.errors = null;
        }
        return isValidPassword ? null : message;
    }
}
BBPasswordComponent.decorators = [
    { type: Component, args: [{
                selector: 'bb-password',
                template: `

      <span [ngSwitch]="uxDesign">
      	<span *ngSwitchCase="'UX3'"> 
      		<md-form-field>
      			<input mdInput #password="ngModel" [(ngModel)]="value" [type]="bbType" [placeholder]="bbPlaceholder" [required]="bbRequired" [disabled]="bbDisabled" [value]="bbValue" [maxlength]="bbMaxlength" [minlength]="bbMinlength" [readOnly]="bbReadOnly" [autofocus]="bbAutofocus"/>
      			<md-hint>
      				<validation [control]="model" [errors]="errors" [errorMessages]="customErrorMessages"></validation>
      			</md-hint>
      		</md-form-field>	
      	</span>
	
      	<span *ngSwitchCase="'UX2'">
      		<span  [ngClass]="{'labelPostion':bbLabelPostion === 'top'}">{{bbLabel}}</span>
      		<input  #password="ngModel" [(ngModel)]="value" [type]="bbType"  [required]="bbRequired" [disabled]="bbDisabled" [value]="bbValue" [maxlength]="bbMaxlength" [minlength]="bbMinlength" [readOnly]="bbReadOnly" [autofocus]="bbAutofocus"/>
      		<validation [control]="model" [errors]="errors" [errorMessages]="customErrorMessages"></validation>
		
      	</span>
	
      	<span *ngSwitchCase="'UX1'">
      		<input  #password="ngModel" [(ngModel)]="value" [type]="bbType" [placeholder]="bbPlaceholder"  [required]="bbRequired" [disabled]="bbDisabled" [value]="bbValue" [maxlength]="bbMaxlength" [minlength]="bbMinlength" [readOnly]="bbReadOnly" [autofocus]="bbAutofocus"/>
      		<validation [control]="model" [errors]="errors" [errorMessages]="customErrorMessages"></validation>

      	</span>
      </span>
    `,
                styles: [`
      .labelPostion{
      display: table;
      }
    `],
                providers: [
                    {
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => BBPasswordComponent),
                        multi: true
                    },
                    {
                        provide: NG_VALIDATORS,
                        useExisting: BBPasswordComponent,
                        multi: true
                    }
                ]
            },] },
];
/** @nocollapse */
BBPasswordComponent.ctorParameters = () => [
    { type: undefined, decorators: [{ type: Attribute, args: ["validator",] },] },
];
BBPasswordComponent.propDecorators = {
    'requiredMessage': [{ type: Input, args: ['requiredMessage',] },],
    'invalidMessage': [{ type: Input, args: ['invalidMessage',] },],
    'bbExpression': [{ type: Input, args: ['expression',] },],
    'model': [{ type: ViewChild, args: [NgModel,] },],
};
//# sourceMappingURL=bb-password.component.js.map