import { Directive, Input } from '@angular/core';
import { NG_VALIDATORS } from '@angular/forms';
var EmailValidator = (function () {
    function EmailValidator() {
        this.validation = false;
    }
    EmailValidator.prototype.validate = function (c) {
        console.log('-------', c.value);
        if (!this.validation) {
            return null;
        }
        var isValidEmail = this.expression.test(c.value);
        var message = {
            'email': {
                'message': this.invalidMessage
            }
        };
        return isValidEmail ? null : message;
    };
    EmailValidator.decorators = [
        { type: Directive, args: [{
                    selector: '[email-validator]',
                    providers: [
                        { provide: NG_VALIDATORS, useExisting: EmailValidator, multi: true }
                    ]
                },] },
    ];
    /** @nocollapse */
    EmailValidator.ctorParameters = function () { return []; };
    EmailValidator.propDecorators = {
        'expression': [{ type: Input, args: ['expression',] },],
        'invalidMessage': [{ type: Input, args: ['invalidMessage',] },],
        'validation': [{ type: Input, args: ['validation',] },],
    };
    return EmailValidator;
}());
export { EmailValidator };
//# sourceMappingURL=email-validator.js.map