import { Validators, } from '@angular/forms';
import { Observable } from 'rxjs';
var normalizeValidator = function (validator) {
    var func = validator.validate.bind(validator);
    if (typeof func === 'function') {
        return function (c) { return func(c); };
    }
    else {
        return validator;
    }
};
export var composeValidators = function (validators) {
    if (validators == null || validators.length === 0) {
        return null;
    }
    return Validators.compose(validators.map(normalizeValidator));
};
export var validate = function (validators, asyncValidators) {
    return function (control) {
        var synchronousValid = function () { return composeValidators(validators)(control); };
        if (asyncValidators) {
            var asyncValidator = composeValidators(asyncValidators);
            return asyncValidator(control).map(function (v) {
                var secondary = synchronousValid();
                if (secondary || v) {
                    return Object.assign({}, secondary, v);
                }
            });
        }
        if (validators) {
            return Observable.of(synchronousValid());
        }
        return Observable.of(null);
    };
};
export var message = function (validator, key) {
    switch (key) {
        case 'minlength':
            return 'Value must be N characters';
        case 'maxlength':
            return 'Value must be a maximum of N characters';
    }
    switch (typeof validator[key]) {
        case 'string':
            return validator[key];
        default:
            return "";
    }
};
//# sourceMappingURL=validate.js.map