var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { BBInputComponent } from '../key-input.component';
import { Component, Input, ViewChild, forwardRef, Attribute } from '@angular/core';
import { NG_VALUE_ACCESSOR, NG_VALIDATORS, NgModel } from '@angular/forms';
var BBNumberComponent = (function (_super) {
    __extends(BBNumberComponent, _super);
    function BBNumberComponent(validator) {
        var _this = _super.call(this) || this;
        _this.validator = validator;
        _this.requiredMessage = 'This field is required';
        _this.invalidMessage = 'Please enter a valid number';
        _this.align = "right";
        _this.bbMaxValue = -1; //default value for max
        _this.bbMinValue = -1; //default value for min
        _this.bbExpression = /^/;
        _this.customErrorMessages = {
            'required': function () { return _this.requiredMessage; },
            'minlength': function (params) { return 'The min number of characters is ' + params.requiredLength; },
            'maxlength': function (params) { return 'The max allowed number of characters is ' + params.requiredLength; },
            'email': function (params) { return params.message; },
            'password': function (params) { return params.message; },
            'phone': function (params) { return params.message; },
            'number': function (params) { return params.message; }
        };
        _this.bbType = 'number';
        return _this;
    }
    BBNumberComponent.prototype.validate = function (c) {
        if (!this.validator) {
            return;
        }
        if (!c.value) {
            this.errors = null;
            return;
        }
        var isValidNumber = this.bbExpression.test(c.value);
        var message = {
            'number': {
                'message': this.invalidMessage
            }
        };
        if (!isValidNumber) {
            this.errors = message;
        }
        else {
            this.errors = null;
        }
        return isValidNumber ? null : message;
    };
    BBNumberComponent.decorators = [
        { type: Component, args: [{
                    selector: 'bb-number',
                    template: "\n\n      <span [ngSwitch]=\"uxDesign\">\n      \t<span *ngSwitchCase=\"'UX3'\"> \n      \t\t<md-form-field>\n      \t\t\t<input mdInput #number=\"ngModel\" [(ngModel)]=\"value\" [type]=\"bbType\" [placeholder]=\"bbPlaceholder\" [required]=\"bbRequired\" [disabled]=\"bbDisabled\" [value]=\"bbValue\" [maxLength]=\"bbMaxlength\" [minLength]=\"bbMinlength\" [readOnly]=\"bbReadOnly\" [autofocus]=\"bbAutofocus\" [style.textAlign]=\"align\"/>\n      \t\t\t<md-hint>\n      \t\t\t\t<validation [control]=\"model\" [errors]=\"errors\" [errorMessages]=\"customErrorMessages\"></validation>\n      \t\t\t</md-hint>\n      \t\t</md-form-field>\t\n      \t</span>\n\t\n      \t<span *ngSwitchCase=\"'UX2'\">\n      \t\t<div>{{bbPlaceholder}}</div>\n      \t\t<input [type]=\"bbType\" [value]=\"bbValue\">\n      \t</span>\n\t\n\t\n      \t<span *ngSwitchCase=\"'UX1'\">\n      \t\t<input mdInput #number=\"ngModel\" [(ngModel)]=\"value\" [type]=\"bbType\" [placeholder]=\"bbPlaceholder\" [required]=\"bbRequired\" [disabled]=\"bbDisabled\" [value]=\"bbValue\" [maxLength]=\"bbMaxlength\" [minLength]=\"bbMinlength\" [readOnly]=\"bbReadOnly\" [autofocus]=\"bbAutofocus\" [style.textAlign]=\"align\"/>\n      \t\t<validation [control]=\"model\" [errors]=\"errors\" [errorMessages]=\"customErrorMessages\"></validation>\n      \t</span>\n      </span>\n    ",
                    styles: ["\n\n    "],
                    providers: [
                        {
                            provide: NG_VALUE_ACCESSOR,
                            useExisting: forwardRef(function () { return BBNumberComponent; }),
                            multi: true
                        },
                        {
                            provide: NG_VALIDATORS,
                            useExisting: BBNumberComponent,
                            multi: true
                        }
                    ]
                },] },
    ];
    /** @nocollapse */
    BBNumberComponent.ctorParameters = function () { return [
        { type: undefined, decorators: [{ type: Attribute, args: ["validator",] },] },
    ]; };
    BBNumberComponent.propDecorators = {
        'requiredMessage': [{ type: Input, args: ['requiredMessage',] },],
        'invalidMessage': [{ type: Input, args: ['invalidMessage',] },],
        'align': [{ type: Input, args: ['align',] },],
        'bbMaxValue': [{ type: Input, args: ['max',] },],
        'bbMinValue': [{ type: Input, args: ['min',] },],
        'bbExpression': [{ type: Input, args: ['expression',] },],
        'model': [{ type: ViewChild, args: [NgModel,] },],
    };
    return BBNumberComponent;
}(BBInputComponent));
export { BBNumberComponent };
//# sourceMappingURL=bb-number.component.js.map