//

/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package ibase.e12ria.e12table.client;

import com.google.gwt.cell.client.AbstractEditableCell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.cell.client.Cell.Context;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.SelectElement;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
//Commented By Prashant Chavan on 11-Mar-15 to avoid to avoid additional import 
//import ibase.e12ria.client.E12CommonUtils;
import ibase.e12ria.e12table.client.E12CustomTextCell.CellData;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/**
 * A {@link Cell} used to render a drop-down list.
 */

public class E12SelectionCell extends AbstractEditableCell<String, E12CustomTextCell.CellData> { // AbstractInputCell<String, String> {

  interface Template extends SafeHtmlTemplates {
    @Template("<option value=\"{0}\">{1}</option>")
    SafeHtml deselected( String optionValue, String optionItem);

    @Template("<option value=\"{0}\" selected=\"selected\">{1}</option>")
    SafeHtml selected( String optionValue, String optionItem);
  }

  private static Template template;

  private HashMap<String, Integer> indexForOption = new HashMap<String, Integer>();

  private final List<String> optionsItem;
  private final List<String> optionsValue;

  private E12CellUpdater<String> valueUpdater;
  
  /**
   * Construct a new {@link SelectionCell} with the specified options.
   *
   * @param optionsItem the options in the cell
   */
  public E12SelectionCell(HashMap<String, String> optionsMap) {
    super("change");
    if (template == null) {
      template = GWT.create(Template.class);
    }
    this.optionsItem = new ArrayList<String>();
    this.optionsValue = new ArrayList<String>();
    int index = 0;
    if( optionsMap != null)
	{
		Iterator<String> optionIterator = optionsMap.keySet().iterator();
		while( optionIterator.hasNext() )
		{
			String item = optionIterator.next();
			String value = optionsMap.get( item );
			optionsValue.add(index, value);
			optionsItem.add(index, item);
			indexForOption.put(value, index++);
		}
	}
    else
    {
    	optionsValue.add(index, "no_value");
		optionsItem.add(index, "No Data");
    }
  }

  @Override
  public void onBrowserEvent(Context context, Element parent, String value, NativeEvent event, ValueUpdater<String> valueUpdater) 
  {
    //super.onBrowserEvent(context, parent, value, event, valueUpdater);
    String type = event.getType();
    if ("change".equals(type)) 
    {
	  this.valueUpdater = (E12CellUpdater<String>) valueUpdater;
	  Object key = context.getKey();
	  CellData cellData = getViewData( context );
	  SelectElement select = parent.getFirstChild().cast();
	  String newValue = optionsValue.get(select.getSelectedIndex());
	  //Commented By Prasahnt Chavan on 11-Mar-15
	  //	  E12CommonUtils.printOnConsole("\nnewValue["+newValue+"]");
	  if (this.valueUpdater != null) 
	  {
		String currData = cellData.checkNull( cellData.getData() );
		if( cellData.isItemChanged() )
		{
			if( !currData.equalsIgnoreCase( newValue ))
			{
				this.valueUpdater.doItemChange(value);
			}
		}
		this.valueUpdater.update(newValue);
	  }
	  cellData.setData(newValue);
	  setViewData(key, cellData);
    }
  }

  @Override
  public void render(Context context, String value, SafeHtmlBuilder sb) {
    // Get the view data.
    Object key = context.getKey();
    CellData viewData = getViewData( context );
    if (viewData != null && viewData.getData().equals(value)) {
      clearViewData(key);
      viewData = null;
    }

    int selectedIndex = getSelectedIndex( viewData == null ? value : viewData.getData() );
    sb.appendHtmlConstant("<select tabindex=\"-1\">");
    int index = 0;
    for (String optionItem : optionsItem) {
      String optionValue = optionsValue.get(index);
      if (index++ == selectedIndex) {
        sb.append(template.selected(optionValue, optionItem));
      } else {
        sb.append(template.deselected(optionValue, optionItem));
      }
    }
    sb.appendHtmlConstant("</select>");
  }

  private int getSelectedIndex(String value) {
    Integer index = indexForOption.get(value);
    if (index == null) {
      return -1;
    }
    return index.intValue();
  }

	@Override
	public boolean isEditing(com.google.gwt.cell.client.Cell.Context context,
			Element parent, String value) {
		return false;
	}
	
    public CellData getViewData( Context context ) 
    {
    	Object key = context.getKey();
    	CellData cellData = ((DataGridTableRowModel) key).getCellData(context.getColumn());
		setViewData(key, cellData);
	    return cellData;
	}

}
