<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">

<html>

<body >
<script type="text/javascript" src="/ibase/webitm/js/sorderWizard.js"></script>	
<script type="text/javascript" src="/ibase/webitm/js/jquery-1.10.2.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-ui-1.10.4.custom.min.js"></script>
<link type="text/css" rel="stylesheet" href="/ibase/webitm/css/htmlWizard.css"/>
<link type="text/css" rel="stylesheet" href="/ibase/webitm/css/sorderWiz.css"/>
<link href="/ibase/webitm/css/DD/jquery-ui-1.10.4.custom.min.css" rel="stylesheet"/>

<script language="Javascript" src="/ibase/webitm/js/jquery.datetimepicker.full.js"></script>
<link type="text/css" rel="stylesheet" href="/ibase/webitm/css/jquery.datetimepicker.css"/>
<link href="/ibase/webitm/css/Galaxy/galaxy-theme.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/Standard/default.css" rel="stylesheet"/>

<style type="text/css">
.tHeader
{
	border-top: #6cf 2px solid !important;
	border-left: 1px solid #ddd !important;
	border-right: 1px solid #ddd !important;
	border-bottom: 1px solid #ddd !important
}
.ft_container table tr td
{
	color: #555 !important;
}
input:focus{
    outline: none;
}

.table-body>tr>td {
    word-wrap: break-word;
}
.tableClass {
    table-layout: fixed;
}

</style>

<script>
<![CDATA[
		
	$(document).on("keydown", function (e) {
	    if (e.which === 8 && !$(e.target).is("input, textarea, form")) {
	        e.preventDefault();
	    }
	    else if(e.which === 13){
	    	 e.preventDefault();
	    }
	});
	
]]>
</script>

	
<!--     <xsl:variable name="dbIDs"><xsl:value-of select="domId"/></xsl:variable> -->
  
    
	<div id="mainPageHeaderContatiner">
		<div id="detailPage-input-Container">
			<table class = "tableClass" id="schemeDetails">
		
				<thead class="table-head">
					<tr class = "trClass">
						<th class="tHeader" nowrap="true" style="width:40px;">
									
						</th>
						<th class="tHeader" nowrap="true" valign="bottom">
							Scheme Code
						</th>
						<th class="tHeader" nowrap="false" style="max-width:100px;" valign="bottom">
							Scheme Description 
						</th>
						<th class="tHeader" nowrap="true" valign="bottom">
							Item Code
						</th>
						<th class="tHeader" nowrap="false" style="max-width:100px;" valign="bottom">
							Item Description 
						</th>
						<th class="tHeader" nowrap="true" valign="bottom" align="right">
							Free Quantity  
						</th>
						
						<th class="tHeader" nowrap="true" valign="bottom" align="right">
							Free Quantity taken
						</th>
						
					</tr>
				</thead>
				<tbody class="table-body">
				<xsl:for-each select="//Detail">
				  	<xsl:variable name="domId"><xsl:value-of select="@domId"/></xsl:variable> 
				<tr class = "trClass" id="Detail2.{normalize-space($domId)}.rowID" value="{$domId}" >
						<td>
					<!-- 	 <input type="checkbox" class="editInputClass editInputCur" name="quantity" id="quantity1" 
									style="width:100%;border:none;text-align: right; outline:none" maxlength="10" /> -->
									
						<Input type='checkbox'  class="editInputClass editInputCur messageCheckbox" value="{$domId}" name="Detail2.{normalize-space($domId)}.selectbox" 
						       id="Detail2.{normalize-space($domId)}.selectbox" onclick="setCheckedScheme('{$domId}', '{applicable_scheme}');" style="width:100%;border:none;text-align: right; outline:none" maxlength="10"  />
						       
									
						</td>
						<td nowrap="true">
						
								<input type="text"  maxlength="4" readOnly = "1"
									   value="{applicable_scheme}" name="Detail2.{normalize-space($domId)}.applicable_scheme" id="Detail2.{normalize-space($domId)}.applicable_scheme" 
									   style="width:100px;background-color: transparent;border: none;color:#666666;" tabindex="-1"/>
							
							
						</td>
						<td style="max-width:100px;color:#666666;">
						
							<xsl:value-of select="scheme_descr"/>
						
								<input type="hidden"  maxlength="4" readOnly = "1"
									   value="{scheme_descr}" name="Detail2.{normalize-space($domId)}.scheme_descr" id="Detail2.{normalize-space($domId)}.scheme_descr" 
									   style="width:100px;background-color: transparent;border: none;color:#666666;" tabindex="-1"/>
							
							
						</td>
						<td nowrap="true">
						
								<input type="text"  maxlength="4" readOnly = "1"
									   value="{item_code}" name="Detail2.{normalize-space($domId)}.item_code" id="Detail2.{normalize-space($domId)}.item_code" 
									   style="width:100px;background-color: transparent;border: none;color:#666666;" tabindex="-1"/>
							
							
						</td>
						<td style="max-width:100px;color:#666666;">
							<xsl:value-of select="item_descr"/>
								<input type="hidden"  maxlength="4" readOnly = "1"
									   value="{item_descr}" name="Detail2.{normalize-space($domId)}.item_descr" id="Detail2.{normalize-space($domId)}.item_descr" 
									   style="width:300px;background-color: transparent;border: none;color:#666666;" tabindex="-1"/>
						</td>
						<td nowrap="true" align="right">
								<input type="text"  maxlength="4" readOnly = "1"
									   value="{free_quantity}" name="free_quantity_{applicable_scheme}" id="Detail2.{normalize-space($domId)}.quantity" 
									   style="width:40px;background-color: transparent;border: none;color:#666666;text-align:right;" tabindex="-1"/>
						</td>
						
						
						<td nowrap="true" align="right" style="padding:0px;">
						 <input type="text" class="editInputClass editInputCur" rowid="{$domId}"  value="0" name="quantity_{applicable_scheme}" id="Detail2.{normalize-space($domId)}.disQty" onpaste="return false;"  onkeypress="return isNumberKey(event);" 
									style="width:100%;height:100%;border:none;text-align: right; padding:0px 8px 0px 0px; outline:none font-size: 14px !important;text-align:right; " maxlength="10" 
									onchange="calAmount({$domId},'{applicable_scheme}');" onclick = 'calTrue({$domId});'  readonly = 'true' />
						</td>
						
						<!-- 	<input type="hidden"  value="{$item_code}" name="Detail2.{normalize-space($domId)}.item_code" id="Detail3.{normalize-space($domId)}.item_code" />
							<input type="hidden"  value="{$item_descr}" name="Detail2.{normalize-space($domId)}.item_descr" id="Detail3.{normalize-space($domId)}.item_descr" />
 							<input type="hidden"  value="" name="Detail2.{normalize-space($domId)}.item_descr" id="Detail3.{normalize-space($domId)}.item_descr" />
 						 -->
 					<input type="hidden"  value="{rate}" name="Detail2.{normalize-space($domId)}.rate" id="Detail2.{normalize-space($domId)}.rate" tabindex="-1" />
 					<input type="hidden"  value="{discount}" name="Detail2.{normalize-space($domId)}.discount" id="Detail2.{normalize-space($domId)}.discount" tabindex="-1" />
 					<input type="hidden"  value="{tax_class}" name="Detail2.{normalize-space($domId)}.tax_class" id="Detail2.{normalize-space($domId)}.tax_class" tabindex="-1" />
 					<input type="hidden"  value="{tax_chap}" name="Detail2.{normalize-space($domId)}.tax_chap" id="Detail2.{normalize-space($domId)}.tax_chap" tabindex="-1" />
 					<input type="hidden"  value="{tax_env}" name="Detail2.{normalize-space($domId)}.tax_env" id="Detail2.{normalize-space($domId)}.tax_env" tabindex="-1" />
 					<input type="hidden"  value="{nature}" name="Detail2.{normalize-space($domId)}.nature" id="Detail2.{normalize-space($domId)}.nature" tabindex="-1" />
 				
 				</tr>
					
				</xsl:for-each>
				</tbody>
			</table>
		</div>
		
	</div>
	
 	
  
  <div class="closeDiv" id="e12popUpPnl-close" onclick="closePopUpOfScheme()">x</div>
  <div class="taxApplyButton"  id="applyTax" name="applyTax" title="Apply Tax" onclick ="getCheckedVal();">
  <p class="checkTax"> <img src="/ibase/webitm/images/checkMark.png" height="15" width="15"/> </p>
  <input  type="hidden"  name="PRE_SCHEME_VAL" ID="PRE_SCHEME_VAL" />
  
  </div> 
	
</body>

</html>
</xsl:template>
</xsl:stylesheet>
