/**
 * PURPOSE : PalletizationIC component
 * AUTHOR : Sneha Mestry
 * DATE : 02-10-2015
 */

package ibase.webitm.ejb.wms;

import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.wms.CommonWmsUtil;

import java.rmi.RemoteException;
import java.sql.*;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.*;

import org.apache.xerces.dom.AttributeMap;
import org.w3c.dom.*;

@javax.ejb.Stateless
public class PalletizationIC extends ValidatorEJB implements PalletizationICLocal, PalletizationICRemote 
{
	/**
	 * The method is defined without any parameter and returns blank string
	 */	
	DistCommon discommon = new DistCommon();
	@Override
	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}

	/**
	 * The public method is used for converting the current form data into a document(DOM)
	 * The dom is then given as argument to the overloaded function wfValData to perform validation
	 * Returns validation string if exists else returns null in XML format
	 * @param xmlString contains the current form data in XML format
	 * @param xmlString1 contains all the header information in the XML format
	 * @param xmlString2 contains the data of all the forms in XML format
	 * @param objContext represents the form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */	
	@Override
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		E12GenericUtility genericUtility = new E12GenericUtility();    

		try
		{
			System.out.println( "xmlString ::" + xmlString);
			System.out.println( "xmlString1 ::" + xmlString1);
			System.out.println( "xmlString2 ::" + xmlString2);
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = wfValData( dom, dom1, dom2, objContext, xtraParams);
			System.out.println( "ErrString: " + errString);
		}
		catch(Exception e)
		{
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		return (errString); 
	}
	/**
	 * The public overloaded method takes a document as input and is used for the validation of required fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currFormDataDom contains the current form data as a document object model
	 * @param hdrDataDom contains all the header information
	 * @param allFormDataDom contains the field data of all the forms 
	 * @param objContext represents form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */
	@Override
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String xtraParams) throws RemoteException, ITMException
	{   				
		NodeList parentNodeList = null,parentNodeListNew  = null;
		NodeList childNodeList = null,childNodeListNew = null;
		Node parentNode = null,parentNodeNew = null;
		Node childNode = null,childNodeNew = null;
		Connection conn = null;
		E12GenericUtility genericUtility;

		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
		String loginSite = "", userId = "", childNodeName = "", errorType = "", errCode = "", errString = "",locGroupDisp="",
		itemSql="",StatusSql="",status ="",itemRgSql="",locSql="",locGroup="",itemSer="",itemSerRgDisparm="",itemCode="",lotNo="",lotNoPrev= "",lotSlPrev = "",
		locSuffixDisp="",stkSql="",lastCharS="" ,sqlTranId = "" ,tranId ="";
		int currentFormNo = 0, childNodeListLength = 0, cnt = 0, ctr = 0 ,palletHdrCount = 0 ,stockCount = 0,countPalletDetLot =0;//Added by Jagruti Shinde Req id:[W16GSUN003]
		int childNodeListLengthNew = 0;
		char lastChar ;
		ArrayList <String> errList = new ArrayList<String>();
		ArrayList <String> errFields = new ArrayList <String> ();
		//Added by Jagruti Shinde Request id:[W16GSUN003]
		double PalletSwmsQty ;
		ITMDBAccessEJB itmdbAccess = new ITMDBAccessEJB();
		List<String> lotSlList = new ArrayList<String>();
		HashMap<String, Integer> lotSlMap = new HashMap<String, Integer>();

		try
		{	
			genericUtility = new E12GenericUtility();	
			CommonWmsUtil commonWmsUtility = CommonWmsUtil.getInstance();

			System.out.println("xtraParam----->>["+xtraParams+"]");
			System.out.println("DOM---->>["+genericUtility.serializeDom(dom).toString()+"]");
			System.out.println("DOM1----->>["+genericUtility.serializeDom(dom1).toString()+"]");
			System.out.println("DOM2----->>["+genericUtility.serializeDom(dom2).toString()+"]");	

			loginSite = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));

			ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			conn.setAutoCommit(false);
			connDriver = null;
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");

			if (objContext != null && objContext.trim().length() > 0) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}	

			switch ( currentFormNo )  
			{
			case 1:
				System.out.println("------in detail1 validation----------------");
				System.out.println("DOM---->>["+genericUtility.serializeDom(dom).toString()+"]");
				System.out.println("DOM1----->>["+genericUtility.serializeDom(dom1).toString()+"]");
				System.out.println("DOM2----->>["+genericUtility.serializeDom(dom2).toString()+"]");	

				String palletNo = "", sql = "";
				PreparedStatement pstmt = null ;
				ResultSet rs = null ; 
				int palletNoCount = 0, palletAWMSCount = 0,cntLoc =0,palcnt=0;
				double palletQty = 0;
				//Change by Jagruti Shinde Request Id:[W15JSUN008]  requirement change for Exempted/BSR location inv_stat[start]
				locSuffixDisp = checkNullAndTrim(discommon.getDisparams("999999", "AWMS_LOCATION_SUFFIX", conn));
				System.out.println("AWMS_LOCATION_SUFFIX["+locSuffixDisp+"]");
				String[] locS = locSuffixDisp.split(",");
				System.out.println("Disparm Lenght for locSuffixDisp="+locS.length);
				//Change by Jagruti Shinde Request Id:[W15JSUN008]  requirement change for Exempted/BSR location inv_stat[end]

				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();

				palletNo = checkNullAndTrim(genericUtility.getColumnValue("pallet_no", dom));
				//System.out.println("palletNo ------->>["+palletNo+"]");				
				//locStockList = getLocationCode(conn, loginSite);			

				for (ctr = 0; ctr < childNodeListLength; ctr++) 
				{					
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					//System.out.println("childNodeName ------->>["+childNodeName+"]");

					if("pallet_no".equalsIgnoreCase(childNodeName))
					{
						if(palletNo.length() <= 0) 
						{
							System.out.println("Pallet No length less than 0 :::::::::: ");
							errCode = "VMNLPALLET";		
							errList.add( errCode );
							errFields.add(childNodeName.toLowerCase());
						}
						else
						{
							//Change by Jagruti Shinde Request Id:[W15JSUN008]  requirement change for Exempted/BSR location inv_stat[start]
							/*palletNoCount = getPalletNoCount(palletNo, loginSite, conn);	
							if(palletNoCount <= 0 && palletNo.length() > 0) // exist in location
							{
								System.out.println("Invalid Pallet No :::::::::: ");
								errCode = "INVPALTNO";		
								errList.add( errCode );
								errFields.add(childNodeName.toLowerCase());
								else
							 {
							}*/

							sql = "SELECT COUNT(1) FROM LOCATION WHERE INV_STAT = ?  AND LOC_CODE =? ";							
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, "AWMS");
							pstmt.setString(2, palletNo);
							//pstmt.setString(3, loginSite);
							rs = pstmt.executeQuery();
							if(rs.next())
							{	
								cntLoc = rs.getInt(1);
								System.out.println( "cntLoc:::"+cntLoc);
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}

							if(cntLoc > 0)
							{
								for (int z = 0; z < locS.length; z++) 
								{
									locSuffixDisp = locS[z].trim();
									lastChar=palletNo.charAt(palletNo.trim().length()-1);
									lastCharS = Character.toString(lastChar);
									System.out.println("lastChar:"+lastChar); 
									System.out.println("locSuffix disparm=["+locSuffixDisp+"] and lastChar["+lastChar+"]");

									if(locSuffixDisp.equalsIgnoreCase(lastCharS))
									{
										System.out.println("****Match found in disparm for:"+lastChar);
										errCode = "VTPALPEEXT";
										errList.add( errCode );
										errFields.add( childNodeName.toLowerCase() );
										break;
									}
								}
							}
							else
							{
								System.out.println("pallet not in AWMS::::::::" +cntLoc);
								errCode = "VTPALPEEXT";//pallet 
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );
								break;
							}

							//Changed by Jagruti Shinde Request Id:[W15JSUN008] for requirement change for Exempted/BSR location inv_stat[End]

							//Changed by Jagruti Shinde Request Id:[W16GSUN003][Start]
							palletAWMSCount = getPalletAWMSCount(palletNo, conn);
							if(palletAWMSCount > 0)
							{
								System.out.println("Pallet No still in transist :::::::::: ");
								errCode = "VTINOUTTR";		
								errList.add( errCode );
								errFields.add(childNodeName.toLowerCase());
								break;
							}
							PalletSwmsQty = getPalletSwmsQty(palletNo, loginSite, conn);
							if(PalletSwmsQty > 0)
							{
								System.out.println("Pallet is not empty checked from tables::::::::: ");
								errCode = "VTINOUTQT";
								errList.add( errCode );
								errFields.add(childNodeName.toLowerCase());
								break;
							}
							palletQty = getPalletNoQty(palletNo, loginSite, conn);
							if(palletQty > 0)
							{
								System.out.println("Pallet is not empty :::::::::: ");
								errCode = "VMPALLETNO";		
								errList.add( errCode );
								errFields.add(childNodeName.toLowerCase());
								break;
							}

							palletHdrCount = getPalletHdrCount(palletNo, conn);
							if(palletHdrCount > 0)
							{
								sqlTranId ="SELECT TRAN_ID FROM PALLET_HDR WHERE PALLET_NO = ? AND CONFIRMED = ? ";
								pstmt = conn.prepareStatement(sqlTranId);
								pstmt.setString(1, palletNo);
								pstmt.setString(2, "N");
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									tranId = rs.getString("TRAN_ID");
									System.out.println("Transaction Id for Pallet_hdr:::::"+tranId);
								}
								if(pstmt != null)
								{ 
									pstmt.close(); 
									pstmt = null;
								}
								if(rs != null)
								{ 
									rs.close(); 
									rs = null; 
								}

								sql="SELECT COUNT(1) FROM PALLET_DET WHERE TRAN_ID = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, tranId);
								rs = pstmt.executeQuery();
								if(rs.next())
								{	
									stockCount = rs.getInt(1);	
									System.out.println("Stock count for pallet_det::" +stockCount);
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
								if(rs!=null)
								{
									rs.close();
									rs = null;
								}
								if (stockCount > 0)
								{
									continue;
								}
								else
								{
									System.out.println("stock is NOT present in pallet_det");
									errString = itmdbAccess.getErrorString("", "VTALLSCAND", "", "", conn);
									return errString;
								}
							}
							//Changed by Jagruti Shinde Request Id:[W16GSUN003][END]
						}
					}
				}
				break;			

			case 2:
				System.out.println("------in detail2 validation----------------");
				System.out.println("DOM---->>["+genericUtility.serializeDom(dom).toString()+"]");
				System.out.println("DOM1----->>["+genericUtility.serializeDom(dom1).toString()+"]");
				System.out.println("DOM2----->>["+genericUtility.serializeDom(dom2).toString()+"]");	

				String tranType = "", palletType = "", remarks = "";

				parentNodeList = dom2.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();

				tranType = checkNullAndTrim(genericUtility.getColumnValue("tran_type",dom));
				palletType = checkNullAndTrim(genericUtility.getColumnValue("pallet_type",dom));
				remarks = checkNullAndTrim(genericUtility.getColumnValue("remarks",dom));

				for(ctr = 0; ctr < childNodeListLength; ctr++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					//System.out.println("value of child node name ["+childNodeName + "]");

					if("".equalsIgnoreCase(tranType))
					{
						//System.out.println(" Blank Transcation Type :::::::::: ");
						errCode = "VMNULLTT";		
						errList.add( errCode );
						errFields.add(childNodeName.toLowerCase());
					}
					else if(tranType.length() > 3)
					{
						//System.out.println(" Blank Transcation Type :::::::::: ");
						errCode = "VMTTYPELEN";		
						errList.add( errCode );
						errFields.add(childNodeName.toLowerCase());
					}
					/*if("".equalsIgnoreCase(palletType))
					{
						System.out.println("Blank Pallet Type :::::::::: ");
						errCode = "VMNULLPT";		
						errList.add( errCode );
						errFields.add(childNodeName.toLowerCase());
					}*/
					if(remarks.length() > 60)
					{
						//System.out.println(" Remarks cannot be greater than 60 :::::::::: ");
						errCode = "VTREMLEN";		
						errList.add( errCode );
						errFields.add(childNodeName.toLowerCase());
					}
				} 
				break;

			case 3:

				System.out.println("------in detail3 validation----------------");
				System.out.println("DOM---->>["+genericUtility.serializeDom(dom).toString()+"]");
				System.out.println("DOM1----->>["+genericUtility.serializeDom(dom1).toString()+"]");
				System.out.println("DOM2----->>["+genericUtility.serializeDom(dom2).toString()+"]");	

				String familyGrp = "", qcType = "", stroPref = "", familyGrpDB = "", qcTypeDB = "", stroPrefDB = "", qcSampleType = "", 
				lotSl = "", statusDB = "",  itemCodeDB = "", quantity = "", statusQ = "", lotNoDB = "", 
				lotSlDB = "",itemSerRg1DB="",itemSerRg1="",qcSampleTypeDB = "",locGroupDB="";
				HashMap hm = new HashMap();
				HashMap hm1 = new HashMap();
				HashMap hm2 = new HashMap();
				locGroupDisp = checkNullAndTrim(discommon.getDisparams("999999", "EXTEMP_LOC_PARM", conn));
				System.out.println("EXTEMP_LOC_PARM["+locGroupDisp+"]");

				int count = 0 ,PalletLotAWMSCount =0 ;
				double PalletLotQty;

				parentNodeList = dom.getElementsByTagName("Detail3");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();

				itemCode = checkNullAndTrim(genericUtility.getColumnValue("item_code",dom));
				quantity = checkNullAndTrim(genericUtility.getColumnValue("quantity",dom));
				lotNo = checkNullAndTrim(genericUtility.getColumnValue("lot_no",dom));
				lotSl = checkNullAndTrim(genericUtility.getColumnValue("lot_sl",dom));	
				palletNo = checkNullAndTrim(genericUtility.getColumnValue("pallet_no",dom1));
				qcSampleType = checkNullAndTrim(genericUtility.getColumnValue("qc_sample_type", dom));

				parentNodeListNew = dom2.getElementsByTagName("Detail3");
				System.out.println("parent nodelist length:: " + parentNodeListNew.getLength());
					
				for(int i = 0; i< parentNodeListNew.getLength();i++){
					
					parentNodeNew = parentNodeListNew.item(i);
					childNodeListNew = parentNodeNew.getChildNodes();
					childNodeListLengthNew = childNodeListNew.getLength();
					
					for(int j = 0;j < childNodeListLengthNew;j++){
						childNodeNew = childNodeListNew.item(j);
						if(childNodeNew.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						if(childNodeNew != null && childNodeNew.getFirstChild() != null){
							if("lot_no".equalsIgnoreCase(checkNull(childNodeNew.getNodeName()))){
								 lotNoPrev = childNodeNew.getFirstChild().getNodeValue().trim();
								 System.out.println("lotno previous dom::["+lotNoPrev+"]:::");
							}
							if("lot_sl".equalsIgnoreCase(checkNull(childNodeNew.getNodeName()))){
								 lotSlPrev = childNodeNew.getFirstChild().getNodeValue().trim();
								 System.out.println("::lot sl previous dom ::["+lotSlPrev+"]");
							}
						}
					}
					lotNoPrev = lotNoPrev == null ? "" : lotNoPrev;
					lotSlPrev = lotSlPrev == null ? "" : lotSlPrev;
					
					System.out.println("lotno previous::["+lotNoPrev+"]::lot sl previous::["+lotSlPrev+"]");
					
					/*if(!lotSlList.contains(lotSlPrev)){
						lotSlList.add(lotSlPrev);	
					}
					System.out.println("list::" + lotSlList);*/
					
					if(!lotSlMap.containsKey(lotSlPrev)){
						int countLotSl = 1;
						lotSlMap.put(lotSlPrev.trim(), countLotSl++);
					}else{
						lotSlMap.put(lotSlPrev.trim(), lotSlMap.get(lotSlPrev) + 1);
					}
				}
				System.out.println("map::: " + lotSlMap);
				if(lotSlMap.get(lotSl) > 1){
					return itmdbAccess.getErrorString("", "VTINOUTIT", "");
				}
				
				
				
				
				System.out.println("itemCode :::::::::::::: " + itemCode);
				System.out.println("quantity :::::::::::::: " + quantity);
				System.out.println("lotNo :::::::::::::: " + lotNo);
				System.out.println("lotSl :::::::::::::: " + lotSl);
				System.out.println("palletNo :::::::::::::: " + palletNo);

				for (ctr = 0; ctr < childNodeListLength; ctr++) 
				{					
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					//System.out.println("childNodeName ------->>["+childNodeName+"]");

					if("lot_no".equalsIgnoreCase(childNodeName))
					{
						if(lotNo.length() <= 0) 
						{
							System.out.println("lot No is blank :::::::::::::::: ");
							errCode = "VTLOTBLNK";		
							errList.add( errCode );
							errFields.add(childNodeName.toLowerCase());
						}
					}
					if("lot_sl".equalsIgnoreCase(childNodeName))
					{
						if(lotSl.length() <= 0) 
						{
							System.out.println("lot sl is blank ::::::::::: ");
							errCode = "VTLSLBLNK";		
							errList.add( errCode );
							errFields.add(childNodeName.toLowerCase());
						}
						else
						{
							//Changed by Jagruti Shinde Request Id:[W16GSUN003][Start]
							/*sql = "SELECT COUNT(1) FROM PALLET_DET D, PALLET_HDR H WHERE D.LOT_NO = ? AND D.LOT_SL = ? AND " 
								+ " D.SITE_CODE = ? AND D.TRAN_ID = H.TRAN_ID AND H.CONFIRMED = ? ";						
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, lotNo);
							pstmt.setString(2, lotSl);
							pstmt.setString(3, loginSite);
							//pstmt.setString(4, "N");
							pstmt.setString(4, "Y");
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								count = rs.getInt(1);		
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}*/

							PalletLotAWMSCount = getPalletLotAWMSCount(palletNo, lotNo, lotSl, conn);
							if(PalletLotAWMSCount > 0)
							{
								System.out.println("Pallet No still in transist, in both  table :::::::::: ");
								errCode = "VTINOUTIT";	//VTINOUTTR	
								errList.add( errCode );
								errFields.add(childNodeName.toLowerCase());
								break;
							}

							PalletLotQty = getPalletLotQty(palletNo, lotNo, lotSl,loginSite, conn);
							if(PalletLotQty > 0)
							{
								System.out.println("Pallet is not empty checked from tables::::::::: ");
								errCode = "VTITEMTQT";//PALLET_HDR,'Y' swms_to_awms 'Y' quantity check VTINOUTQT
								errList.add( errCode );
								errFields.add(childNodeName.toLowerCase());
								break;
							}

							//Changed by wasim on 28-06-2016 to validate the confirmed/unconfirmed pallet_det records for scanned lotNo and lotSl [START]
							//countPalletDetLot = 0;
							sql = "SELECT COUNT(*) FROM PALLET_DET D, PALLET_HDR H WHERE D.LOT_NO = ? AND D.LOT_SL = ? AND " 
									+ " D.SITE_CODE = ? AND D.TRAN_ID = H.TRAN_ID AND H.CONFIRMED = ? ";						
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, lotNo);
							pstmt.setString(2, lotSl);
							pstmt.setString(3, loginSite);
							pstmt.setString(4, "N");
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								countPalletDetLot = rs.getInt(1);		
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
							//Changed by wasim on 28-06-2016 to validate the confirmed/unconfirmed pallet_det records for scanned lotNo and lotSl [END]	
							if(countPalletDetLot > 0)
							{
								System.out.println("lot no-lot sl Record already scanned in previous transaction:::::::::: ");
								errCode = "VTSMRCD";		
								errList.add( errCode );
								errFields.add(childNodeName.toLowerCase());
								break;
							}
							//else
							//{
							/*PalletLotQty = getPalletLotQty(palletNo, lotNo, lotSl,loginSite, conn);
							if(PalletLotQty > 0)
							{
								System.out.println("Pallet is not empty checked from tables::::::::: ");
								errCode = "VTINOUTQT";//PALLET_HDR,'Y' swms_to_awms 'Y' quantity check
								errList.add( errCode );
								errFields.add(childNodeName.toLowerCase());
								break;
							}*/
							//Changed by Jagruti Shinde Request Id:[W16GSUN003][End]
							else
							{
								System.out.println("in else of (PalletLotQty > 0)::::::::");
								hm2 = getScanItem(palletNo, loginSite, conn);
								itemCodeDB = (String) hm2.get("ITEM_CODE"); 
								lotNoDB = (String) hm2.get("LOT_NO");
								lotSlDB = (String) hm2.get("LOT_SL");
								qcSampleTypeDB = (String) hm2.get("QC_SAMPLE_TYPE");

								System.out.println("itemCodeDB :::::::::: " + itemCodeDB);
								System.out.println("lotNoDB :::::::::: " + lotNoDB);
								System.out.println("qcSampleTypeDB :::::::::: " + qcSampleTypeDB);

								if(itemCodeDB.length() > 0) 
								{
									// Validation for Analysis Class
									hm = commonWmsUtility.getPalletizedAttributes(itemCode, loginSite, conn);
									familyGrp = (String) hm.get("LOC_ZONE__PREF"); 
									//Change by Jagruti Shinde Request Id:[W15JSUN008]  PRO_MTH validation remove
									//qcType = (String) hm.get("PROC_MTH");
									stroPref = (String) hm.get("ANALYSIS_CLASS");
									//Change by Jagruti Shinde  for item_ser__rg1 Request ID:[W15JSUN008][Start]
									itemSerRg1 = (String) hm.get("ITEM_SER__RG1");
									//Change by Jagruti Shinde for item_ser__rg1 Request ID:[W15JSUN008][End]

									hm1 = commonWmsUtility.getPalletizedAttributes(itemCodeDB, loginSite, conn);
									familyGrpDB = (String) hm1.get("LOC_ZONE__PREF"); 
									//Change by Jagruti Shinde Request Id:[W15JSUN008]  PRO_MTH validation remove
									//qcTypeDB = (String) hm1.get("PROC_MTH");
									stroPrefDB = (String) hm1.get("ANALYSIS_CLASS");
									//Change by Jagruti Shinde for item_ser__rg1 Request ID:[W15JSUN008][Start]
									itemSerRg1DB = (String) hm1.get("ITEM_SER__RG1");
									//Change by Jagruti Shinde for item_ser__rg1 Request ID:[W15JSUN008][End]


									/*System.out.println("familyGrp :::::::::: " + familyGrp);
										System.out.println("familyGrpDB :::::::::: " + familyGrpDB);
										System.out.println("stroPref :::::::::: " + stroPref);
										System.out.println("stroPrefDB :::::::::: " + stroPrefDB);
										System.out.println("qcSampleType:::::::::: " + qcSampleType);
										System.out.println("qcSampleTypeDB :::::::::: " + qcSampleTypeDB);*/


									//if(!familyGrpDB.equalsIgnoreCase(familyGrp) || !qcTypeDB.equalsIgnoreCase(qcType) || !stroPrefDB.equalsIgnoreCase(stroPref) )
									//Change by Jagruti Shinde Request Id:[W15JSUN008]  PRO_MTH validation remove
									//if(!familyGrpDB.equalsIgnoreCase(familyGrp) || !qcTypeDB.equalsIgnoreCase(qcType) || !stroPrefDB.equalsIgnoreCase(stroPref))
									if(!familyGrpDB.equalsIgnoreCase(familyGrp) || !stroPrefDB.equalsIgnoreCase(stroPref))
									{
										System.out.println(" item code is not of same analysis grp :::::::::: ");
										errCode = "VTINVAC";		
										errList.add( errCode );
										errFields.add(childNodeName.toLowerCase());
									}
									//Change by Jagruti Shinde Request ID:[W15JSUN008][Start]
									// Validation for item_ser__rg1
									/*System.out.println("itemSerRg1 :::::::::: " + itemSerRg1);
										System.out.println("itemSerRg1DB :::::::::: " + itemSerRg1DB);*/
									if(!itemSerRg1DB.equalsIgnoreCase(itemSerRg1))
									{
										System.out.println(" item_ser__rg1 not belong to same series :::::::::: ");
										errCode = "VMITSEGEXT";		
										errList.add( errCode );
										errFields.add(childNodeName.toLowerCase());
									}

									// Validation for location group 
									locGroupDB = getLocGroup(itemCodeDB, lotNoDB,lotSlDB,loginSite, conn);
									locGroup = getLocGroup(itemCode, lotNo,lotSl,loginSite,  conn);

									if(locGroup.equalsIgnoreCase(locGroupDisp))
									{
										locGroup ="EXEX";
										System.out.println("locationGroup for EXEX :::::::::: "+locGroup);
									}
									else
									{
										locGroup ="OTHER";
										System.out.println(" locationGroup other than EXEX:::::::::: "+locGroup);
									}

									if(locGroupDB.equalsIgnoreCase(locGroupDisp))
									{
										locGroupDB ="EXEX";
										System.out.println("locationGroupDB for EXEX :::::::::: "+locGroupDB);
									}
									else
									{
										locGroupDB ="OTHER";
										System.out.println(" locationGroupDB other than EXEX:::::::::: "+locGroupDB);
									}

									/*System.out.println("locGroup :::::::::: " + locGroup);
										System.out.println("locGroupDB :::::::::: " + locGroupDB);*/
									if(!locGroupDB.equalsIgnoreCase(locGroup))
									{
										System.out.println(" location code is not for same series location group :::::::::: ");
										errCode = "VMLOCGPEXT";		
										errList.add( errCode );
										errFields.add(childNodeName.toLowerCase());
									}
									//Change by Jagruti Shinde Request ID:[W15JSUN008][End]

									// Validation for QC Sample Type 
									System.out.println("Checking validation for QC Sample Type  :::::::::: " );

									if("".equalsIgnoreCase(statusDB) || statusDB == null)
									{
										statusDB = "C";
									}
									if("".equalsIgnoreCase(status) || status == null)
									{
										status = "C";
									}

									System.out.println("value of statusDB after if :::::::::: " + statusDB);
									System.out.println("value of status after if :::::::::: " + status);
									System.out.println("Checking validation for QC order status :::::::::: " );
									statusDB = getItemQcStatus(itemCodeDB, lotNoDB, loginSite, conn);
									status = getItemQcStatus(itemCode, lotNo, loginSite, conn);
									if(!statusDB.equalsIgnoreCase(status))
									{
										System.out.println(" item code is not of same qc order status :::::::::: ");
										errCode = "VTINVQCS";		
										errList.add( errCode );
										errFields.add(childNodeName.toLowerCase());
									}

									// Validation for QC Sample Type 
									System.out.println("Checking validation for QC Sample Type  :::::::::: " );
									/*System.out.println("value of qcSampleTypeDB  :::::::::: " + qcSampleTypeDB);
					        			System.out.println("value of qcSampleType  :::::::::: " + qcSampleType);*/

									if(!qcSampleTypeDB.equalsIgnoreCase(qcSampleType))
									{
										System.out.println(" item code is not of same qc sample type :::::::::: ");
										errCode = "VTINVQST";		
										errList.add( errCode );
										errFields.add(childNodeName.toLowerCase());
									}
								}
							}
							//}
						}	//end lot_sl not blank			
					}//end if lot_sl
				}
				break;
			}//End of switch statement

			int errListSize = errList.size();
			cnt =0;
			String errFldName = null;
			if ( errList != null && errListSize > 0 )
			{
				for (cnt = 0; cnt < errListSize; cnt++ )
				{
					errCode = errList.get(cnt);
					errFldName = errFields.get(cnt);
					System.out.println("errCode .........." + errCode);
					errString = getErrorString( errFldName, errCode, userId );
					errorType =  errorType( conn, errCode );
					if ( errString.length() > 0)
					{
						String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						System.out.println("errStringXml .........."+errStringXml);
						errString = "";
					}
					if ( errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;

				errStringXml.append("</Errors></Root>\r\n");
			}
			else
			{
				errStringXml = new StringBuffer( "" );
			}	
			errString = errStringXml.toString();
		}
		catch ( Exception e )
		{
			System.out.println ( "Exception: PalletizationIC: wfValData( Document currFormDataDom ): " + e.getMessage() + ":" );
			throw new ITMException(e);	
		}
		finally
		{
			try
			{

				if (conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception : PalletizationIC:wfValData : " + e.getMessage() );
				throw new ITMException(e);
			}
		}
		System.out.println( "errString>>>>>>>::" + errString );
		return errString;
	}

	private String errorType( Connection conn , String errorCode )
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO =   ? ";

			pstmt = conn.prepareStatement( sql );			
			pstmt.setString(1, errorCode);			
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}

	//Change by Jagruti Shinde to consider Exempted /BSR Location
	/*private Double getPalletNoQty(String palletNo, String loginSite, Connection conn) throws Exception
	{
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";
		double quantity = 0;
		try
		{	
			sql = "select sum(quantity) from stock where loc_code = ? and site_code = ? and  inv_stat = ?  group by loc_code ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, palletNo);
			pstmt.setString(2, loginSite);
			pstmt.setString(3, "AWMS");
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				quantity = rs.getInt(1);
			}
			if(pstmt != null){ pstmt.close(); pstmt = null; }
			if(rs != null){ rs.close(); rs = null; }

			if(quantity <= 0)
			{
				sql = "select sum(quantity) from stock where loc_code = ? and site_code = ? and  inv_stat = ? group by loc_code ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, palletNo+"Q");
				pstmt.setString(2, loginSite);
				pstmt.setString(3, "AWMSQ");
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					quantity = rs.getInt(1);
				}
				if(pstmt != null){ pstmt.close(); pstmt = null; }
				if(rs != null){ rs.close(); rs = null; }
			}


		}
		catch(Exception e)
		{
			System.out.println("Exception in getPalletNoQty ::::::::: " + e);
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		System.out.println("Return  from getPalletNoQty ------>>" + quantity);		
		return quantity;
	}*/

	//Change by Jagruti Shinde for Exempted /BSR Location [START]
	private Double getPalletNoQty(String palletNo, String loginSite, Connection conn) throws Exception
	{
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";
		double quantity = 0;
		try
		{	
			sql = "SELECT SUM(QUANTITY) FROM STOCK WHERE LOC_CODE IN(?,?,?,?,?,?,?,?) AND SITE_CODE = ? AND  INV_STAT IN(?,?) ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, palletNo);
			pstmt.setString(2, palletNo+"Q");
			pstmt.setString(3, palletNo+"B");
			pstmt.setString(4, palletNo+"X");
			pstmt.setString(5, palletNo+"M");
			pstmt.setString(6, palletNo+"U");
			pstmt.setString(7, palletNo+"P");
			pstmt.setString(8, palletNo+"S");
			pstmt.setString(9, loginSite);
			pstmt.setString(10, "AWMS");
			pstmt.setString(11, "AWMSQ");
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				quantity = rs.getInt(1);
			}
			if(pstmt != null)
			{ 
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{ 
				rs.close(); 
				rs = null;
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception in getPalletNoQty ::::::::: " + e);
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		System.out.println("Return  from getPalletNoQty ------>>" + quantity);		
		return quantity;
	}
	//Change by Jagruti Shinde for Exempted /BSR Location [END]
	//Change by Jagruti Shinde Request Id:[W15JSUN008] for requirement change for Exempted/BSR location inv_stat[start]
	/*private int getPalletNoCount(String palletNo, String loginSite, Connection conn) throws Exception
	{
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";
		int count = 0;
		try
		{	
			// Change by Jagruti Shinde as site_code is not consider for location master
			//sql = "select count(loc_code) from location where  site_code = ? and  inv_stat = ? and loc_code = ? ";		
			sql = "select count(loc_code) from location where inv_stat = ? and loc_code = ? ";	
			pstmt = conn.prepareStatement(sql);
			//pstmt.setString(1, loginSite);
			pstmt.setString(1, "AWMS");
			pstmt.setString(2, palletNo);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				count = rs.getInt(1);
			}
			if(pstmt != null){ pstmt.close(); pstmt = null; }
			if(rs != null){ rs.close(); rs = null; }
		}
		catch(Exception e)
		{
			System.out.println("Exception in getPalletNoCount ::::::: " + e);
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		System.out.println("return value from getPalletNoCount :::::::::: " + count);
		return count;
	}*/
	//Change by Jagruti Shinde Request Id:[W15JSUN008] for requirement change for Exempted/BSR location inv_stat[End]
	private int getPalletAWMSCount(String palletNo, Connection conn) throws Exception
	{	
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";
		int count = 0;
		try
		{	
			//Changed by Jagruti Shinde Req id:[W16GSUN003][Start]
			//sql ="SELECT COUNT(*) FROM SWMS_TO_AWMS WHERE PALLET_NO = ? AND SCHEDULE_STATUS = ? AND REF_SER = ? ";
			sql =" SELECT COUNT(1) FROM SWMS_TO_AWMS S,PALLET_HDR H,PALLET_DET D WHERE H.TRAN_ID = S.REF_ID AND" +
			"  H.TRAN_ID = D.TRAN_ID AND H.PALLET_NO = S.PALLET_NO AND H.PALLET_NO = ? " +
			" AND S.SCHEDULE_STATUS = ? AND S.REF_SER = ? AND H.CONFIRMED= ?  ";	
			//Changed by Jagruti Shinde Req id:[W16GSUN003][End]
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, palletNo);
			pstmt.setString(2, "N");
			pstmt.setString(3, "PZ");
			pstmt.setString(4, "Y");
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				count = rs.getInt(1);		
			}
			if(pstmt != null)
			{ 
				pstmt.close(); 
				pstmt = null;
			}
			if(rs != null)
			{ 
				rs.close(); 
				rs = null; 
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception in getPalletAWMSCount ::::::: " + e);
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		System.out.println("return value from getPalletAWMSCount :::::::::: " + count);
		return count;
	}

	private HashMap getScanItem(String palletNo, String siteCode, Connection conn) throws Exception
	{	
		HashMap hm = new HashMap();
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "", itemCodeDB = "", lotNoDB = "", lotSlDB = "", qcSampleTypeDB = "";		
		try
		{	
			/*sql ="select distinct(item_code) as item_code, lot_no, d.qc_sample_type from pallet_hdr h, pallet_det d where d.pallet_no = ? and " 
				+ "h.confirmed = ? and h.site_code = ? and d.tran_id = h.tran_id and rownum < 2  ";*/

			sql ="SELECT DISTINCT(ITEM_CODE) AS ITEM_CODE, LOT_NO, LOT_SL, D.QC_SAMPLE_TYPE FROM PALLET_HDR H, PALLET_DET D WHERE D.PALLET_NO = ? AND " 
				+ "H.CONFIRMED = ? AND H.SITE_CODE = ? AND D.TRAN_ID = H.TRAN_ID AND ROWNUM < 2  ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, palletNo);
			pstmt.setString(2, "N");
			pstmt.setString(3, siteCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				itemCodeDB = checkNullAndTrim(rs.getString("ITEM_CODE"));		
				lotNoDB = checkNullAndTrim(rs.getString("LOT_NO"));	
				lotSlDB = checkNullAndTrim(rs.getString("LOT_SL"));	
				qcSampleTypeDB = checkNullAndTrim(rs.getString("qc_sample_type"));	
				lotSlDB = checkNullAndTrim(rs.getString("lot_sl"));		
			}
			if(pstmt != null){ pstmt.close(); pstmt = null; }
			if(rs != null){ rs.close(); rs = null; }

			hm.put("ITEM_CODE", itemCodeDB);
			hm.put("LOT_NO", lotNoDB);
			hm.put("QC_SAMPLE_TYPE", qcSampleTypeDB);
			hm.put("LOT_SL", lotSlDB);
		}
		catch(Exception e)
		{
			System.out.println("Exception in getScanItem ::::::: " + e);
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		System.out.println("return value from getScanItem :::::::::: " + hm);
		return hm;
	}

	private String getItemQcStatus(String itemCode, String lotNo, String siteCode, Connection conn) throws Exception
	{	
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "", status = "";		
		try
		{	
			sql ="SELECT STATUS FROM QC_ORDER WHERE ITEM_CODE = ? AND LOT_NO = ? AND SITE_CODE = ? " ;
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, itemCode);
			pstmt.setString(2, lotNo);
			pstmt.setString(3, siteCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				status = checkNullAndTrim(rs.getString("status"));		
			}
			if(pstmt != null){ pstmt.close(); pstmt = null; }
			if(rs != null){ rs.close(); rs = null; }
		}
		catch(Exception e)
		{
			System.out.println("Exception in getItemQcStatus ::::::: " + e);
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		System.out.println("return value from getItemQcStatus :::::::::: " + status);
		return status;
	}
	//Change by Jagruti Shinde  for loc_group Request ID:[W15JSUN008][Start]
	private String getLocGroup(String itemCode, String lotNo, String lotSl,String siteCode, Connection conn) throws Exception
	{	
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "", locCode = "",locGroup="";		
		try
		{	

			sql="SELECT S.LOC_CODE FROM STOCK S, ITEM I, SITEITEM SI WHERE S.LOT_NO = ? AND S.LOT_SL = ? AND " +
			"S.SITE_CODE = ? AND S.QUANTITY > 0 AND S.INV_STAT NOT IN (?,?)  AND S.ITEM_CODE = I.ITEM_CODE AND " +
			"I.ITEM_CODE = SI.ITEM_CODE  AND S.ITEM_CODE = SI.ITEM_CODE AND S.SITE_CODE = SI.SITE_CODE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, lotNo);
			pstmt.setString(2, lotSl);
			pstmt.setString(3, siteCode);
			pstmt.setString(4, "AWMS");
			pstmt.setString(5, "AWMSQ");
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				locCode = checkNullAndTrim(rs.getString("LOC_CODE"));		
			}
			if(pstmt != null){ pstmt.close(); pstmt = null; }
			if(rs != null){ rs.close(); rs = null; }

			// Change by Jagruti Shinde as site_code is not consider for location master
			//sql ="SELECT LOC_GROUP FROM LOCATION WHERE LOC_CODE = ? AND SITE_CODE = ? " ;
			sql ="SELECT LOC_GROUP FROM LOCATION WHERE LOC_CODE = ? " ;
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, locCode);
			//pstmt.setString(2, siteCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				locGroup = checkNullAndTrim(rs.getString("LOC_GROUP"));		
			}
			if(pstmt != null){ pstmt.close(); pstmt = null; }
			if(rs != null){ rs.close(); rs = null; }


		}
		catch(Exception e)
		{
			System.out.println("Exception in getLocGroup ::::::: " + e);
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		System.out.println("return value from getLocGroup :::::::::: " + locGroup);
		return locGroup;
	}
	//Change by Jagruti Shinde  for loc_group Request ID:[W15JSUN008][End]

	private String getQcSampleType(String itemCode, String siteCode, Connection conn) throws Exception
	{	
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "", qcSampleType = "";		
		try
		{	
			sql ="SELECT QC_SAMPLE_TYPE FROM  SITEITEM  WHERE ITEM_CODE = ?  AND SITE_CODE = ? " ;
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, itemCode);
			pstmt.setString(2, siteCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				qcSampleType = checkNullAndTrim(rs.getString("qc_sample_type"));		
			}
			if(pstmt != null){ pstmt.close(); pstmt = null; }
			if(rs != null){ rs.close(); rs = null; }
		}
		catch(Exception e)
		{
			System.out.println("Exception in getQcSampleType ::::::: " + e);
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		System.out.println("return value from getQcSampleType :::::::::: " + qcSampleType);
		return qcSampleType;
	}

	@Override
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}

	@Override
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currFormDataDom = null;
		Document hdrDataDom = null;
		Document allFormDataDom = null;
		String errString = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		System.out.println("xmlString ["+xmlString+"]");
		System.out.println("xmlString1 ["+xmlString1+"]");
		System.out.println("xmlString2 ["+xmlString2+"]");
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				currFormDataDom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				hdrDataDom = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				allFormDataDom = genericUtility.parseString(xmlString2); 
			}
			System.out.println ( "Calling  itemChanged( currFormDataDom, hdrDataDom, allFormDataDom, objContext, currentColumn, editFlag, xtraParams )");
			errString = itemChanged( currFormDataDom, hdrDataDom, allFormDataDom, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception : PalletizationIC:itemChanged(String,String):" + e.getMessage() + ":" );
			throw new ITMException(e);
		}
		System.out.println ( "returning from PalletizationIC itemChanged \n[" + errString + "]" );

		return errString;
	}

	@Override
	public String itemChanged( Document currFormDataDom, Document hdrDataDom, Document allFormDataDom, String objContext, String currentColumn,String editFlag, String xtraParams ) throws RemoteException,ITMException
	{	
		Connection conn = null;
		PreparedStatement pstmt = null, pstmt1 = null;
		ResultSet rs = null, rs1 = null;		
		int currentFormNo = 0, domId = 0;
		String sql = "", tranId = "", chgUser = "", chgTerm = "", loginEmpCode = "", loginSite = "", invstatForQstk = "";
		StringBuffer valueXmlString;

		System.out.println("xtraParams=["+xtraParams+"]");
		System.out.println("PalletizationCalled123........................... : ["+currentColumn+"]");

		E12GenericUtility genericUtility = new E12GenericUtility();	
		NodeList parenNodeList = null,childNodeList1 = null;
		Node parentNode1 = null, childNode1 = null;
		int childNodeListLength1 = 0,parentNodeListLength = 0;
		String childNodeName = "";
		valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>").append( editFlag );
		try
		{
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(currentDate.getTime());	

			loginSite = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));			
			loginEmpCode = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));	
			chgUser = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"));
			chgTerm = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId"));
			System.out.println("loginEmpCode---->>["+loginEmpCode+"] chgUser---->>["+chgUser+"]");	

			//Added & replace by sarita on 27DEC2017
			/*ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( "DriverITM" );	
			connDriver = null;*/
			conn = getConnection();

			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			System.out.println("current form no["+currentFormNo+"]");
			valueXmlString.append("</editFlag>\r\n</Header>\r\n");

			switch ( currentFormNo )  
			{
			case 1:
			{
				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{
					System.out.println("------------------ inside case 1 itemchange --------------- ");
				}
			} //Case 1. End
			break;

			case 2:
			{
				System.out.println("-------------- itemchanged in Details 2 ----------------------");
				System.out.println("Tran_id123@----------->>["+tranId+"]");		

				System.out.println("hdrDataDom------->>["+genericUtility.serializeDom(hdrDataDom)+"]");	
				System.out.println("currFormDataDom------>>["+genericUtility.serializeDom(currFormDataDom)+"]");
				System.out.println("allFormDataDom------>>["+genericUtility.serializeDom(allFormDataDom)+"]");

				String palletNo = "";
				String siteCodeEdit = "", tranTypeEdit = "", palletTypeEdit = "", invStatEdit = "", palletNoEdit = "", palletStatusEdit = "",
				remarksEdit = "", chgUserEdit = "", chgTermEdit = "",  invStat = "", tranIdEdit = "", palletNoCheck = "";
				Date  chgDateEdit = null, tranDateEdit = null;

				palletNo = checkNullAndTrim(genericUtility.getColumnValue("pallet_no", hdrDataDom));

				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{	
					System.out.println(" Inside if details 2 for itm_default ::::::::::::::::: ");

					sql = "SELECT  TRAN_ID, TRAN_DATE, SITE_CODE, TRAN_TYPE, PALLET_TYPE, PALLET_NO, REMARKS, PALLET_STATUS, " 
						+ "CHG_USER, CHG_DATE, CHG_TERM FROM PALLET_HDR " 
						+ "WHERE PALLET_NO = ? " 
						+ "AND  SITE_CODE = ?  AND CASE WHEN CONFIRMED IS NULL THEN 'N' ELSE CONFIRMED END = 'N' ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, palletNo);
					pstmt.setString(2, loginSite);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						tranIdEdit = checkNullAndTrim(rs.getString("tran_id"));
						tranDateEdit = rs.getDate("tran_date");
						siteCodeEdit = checkNullAndTrim(rs.getString("site_code"));
						tranTypeEdit = checkNullAndTrim(rs.getString("tran_type"));
						palletTypeEdit = checkNullAndTrim(rs.getString("pallet_type"));
						palletNoEdit = checkNullAndTrim(rs.getString("pallet_no"));
						remarksEdit = checkNullAndTrim(rs.getString("remarks"));
						chgUserEdit = checkNullAndTrim(rs.getString("chg_user"));
						chgDateEdit = rs.getDate("chg_date");
						chgTermEdit = checkNullAndTrim(rs.getString("chg_term"));
						palletStatusEdit = checkNullAndTrim(rs.getString("pallet_status"));

						System.out.println("-------------- itemchanged Edit mode in Details 2 ----------------------");						           
						System.out.println("in itm_default@@@@@.........." + tranId);

						valueXmlString.append("<Detail2 domID=\"1\" selected=\"Y\">\r\n");
						valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\" />\r\n");

						valueXmlString.append( "<tran_id><![CDATA[" ).append( tranIdEdit ).append( "]]></tran_id>\r\n" );
						valueXmlString.append( "<tran_date><![CDATA[" ).append( sdf.format(tranDateEdit).toString() ).append( "]]></tran_date>\r\n" );
						valueXmlString.append( "<site_code><![CDATA[" ).append( siteCodeEdit ).append( "]]></site_code>\r\n" );
						valueXmlString.append( "<tran_type><![CDATA[" ).append( tranTypeEdit ).append( "]]></tran_type>\r\n" );
						valueXmlString.append( "<pallet_status><![CDATA[" ).append( palletStatusEdit ).append( "]]></pallet_status>\r\n" );
						valueXmlString.append( "<loc_code><![CDATA[" ).append( "" ).append( "]]></loc_code>\r\n" );
						valueXmlString.append( "<pallet_type><![CDATA[" ).append( palletTypeEdit ).append( "]]></pallet_type>\r\n" );
						valueXmlString.append( "<inv_stat><![CDATA[" ).append( "" ).append( "]]></inv_stat>\r\n" );
						valueXmlString.append( "<pallet_no><![CDATA[" ).append( palletNoEdit ).append( "]]></pallet_no>\r\n" );
						valueXmlString.append( "<remarks><![CDATA[" ).append( remarksEdit ).append( "]]></remarks>\r\n" );
						valueXmlString.append( "<confirmed><![CDATA[" ).append( "N" ).append( "]]></confirmed>\r\n" );
						valueXmlString.append( "<conf_date><![CDATA[" ).append( "" ).append( "]]></conf_date>\r\n" );
						valueXmlString.append( "<emp_code__aprv><![CDATA[" ).append( loginEmpCode ).append( "]]></emp_code__aprv>\r\n" );
						valueXmlString.append( "<status><![CDATA[" ).append( "P" ).append( "]]></status>\r\n" );
						valueXmlString.append( "<add_user><![CDATA[" ).append( chgUser ).append( "]]></add_user>\r\n" );
						valueXmlString.append( "<add_date><![CDATA[" ).append( currDate ).append( "]]></add_date>\r\n" );
						valueXmlString.append( "<add_term><![CDATA[" ).append( chgTerm ).append( "]]></add_term>\r\n" );
						valueXmlString.append( "<chg_user><![CDATA[" ).append( chgUserEdit ).append( "]]></chg_user>\r\n" );
						valueXmlString.append( "<chg_date><![CDATA[" ).append( sdf.format(chgDateEdit).toString() ).append( "]]></chg_date>\r\n" );
						valueXmlString.append( "<chg_term><![CDATA[" ).append( chgTermEdit ).append( "]]></chg_term>\r\n" );
						valueXmlString.append("</Detail2>\r\n");
					}
					else
					{
						System.out.println("in itm_default@@@@@.........." + tranId);
						System.out.println("-------------- itemchanged Add mode in Details 2 ----------------------");

						valueXmlString.append("<Detail2 domID=\"1\" selected=\"N\">\r\n");
						valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" />\r\n");
						valueXmlString.append( "<tran_id><![CDATA[" ).append( "" ).append( "]]></tran_id>\r\n" );
						valueXmlString.append( "<tran_date><![CDATA[" ).append( currDate ).append( "]]></tran_date>\r\n" );
						valueXmlString.append( "<site_code><![CDATA[" ).append( loginSite ).append( "]]></site_code>\r\n" );
						valueXmlString.append( "<tran_type><![CDATA[" ).append( "P" ).append( "]]></tran_type>\r\n" );
						valueXmlString.append( "<pallet_status><![CDATA[" ).append( "F" ).append( "]]></pallet_status>\r\n" );
						valueXmlString.append( "<loc_code><![CDATA[" ).append( "" ).append( "]]></loc_code>\r\n" );

						palletNoCheck = String.valueOf(palletNo.charAt(0));
						if("1".equalsIgnoreCase(palletNoCheck))
						{
							valueXmlString.append( "<pallet_type><![CDATA[" ).append( "N" ).append( "]]></pallet_type>\r\n" );
						}
						else if("2".equalsIgnoreCase(palletNoCheck))
						{
							valueXmlString.append( "<pallet_type><![CDATA[" ).append( "C" ).append( "]]></pallet_type>\r\n" );
						}
						else if("3".equalsIgnoreCase(palletNoCheck))
						{
							valueXmlString.append( "<pallet_type><![CDATA[" ).append( "S" ).append( "]]></pallet_type>\r\n" );
						}
						else
						{
							valueXmlString.append( "<pallet_type><![CDATA[" ).append( "N" ).append( "]]></pallet_type>\r\n" );
						}


						valueXmlString.append( "<inv_stat><![CDATA[" ).append( "" ).append( "]]></inv_stat>\r\n" );					
						valueXmlString.append( "<pallet_no><![CDATA[" ).append( palletNo ).append( "]]></pallet_no>\r\n" );
						valueXmlString.append( "<remarks><![CDATA[" ).append( "" ).append( "]]></remarks>\r\n" );
						valueXmlString.append( "<confirmed><![CDATA[" ).append( "N" ).append( "]]></confirmed>\r\n" );
						valueXmlString.append( "<conf_date><![CDATA[" ).append( "" ).append( "]]></conf_date>\r\n" );
						valueXmlString.append( "<emp_code__aprv><![CDATA[" ).append( loginEmpCode ).append( "]]></emp_code__aprv>\r\n" );
						valueXmlString.append( "<status><![CDATA[" ).append( "P" ).append( "]]></status>\r\n" );
						valueXmlString.append( "<add_user><![CDATA[" ).append( chgUser ).append( "]]></add_user>\r\n" );
						valueXmlString.append( "<add_date><![CDATA[" ).append( currDate ).append( "]]></add_date>\r\n" );
						valueXmlString.append( "<add_term><![CDATA[" ).append( chgTerm ).append( "]]></add_term>\r\n" );
						valueXmlString.append( "<chg_user><![CDATA[" ).append( chgUser ).append( "]]></chg_user>\r\n" );
						valueXmlString.append( "<chg_date><![CDATA[" ).append( currDate ).append( "]]></chg_date>\r\n" );
						valueXmlString.append( "<chg_term><![CDATA[" ).append( chgTerm ).append( "]]></chg_term>\r\n" );
						valueXmlString.append("</Detail2>\r\n");
					}
					if(pstmt != null) { pstmt.close(); pstmt = null; }
					if(rs != null) { rs.close(); rs = null; }
				}
			} //Case 2. End
			break;

			case 3://Case 3. Start
			{
				String palletNo = "", domID = "", itemCode = "", descr = "", lotNo = "", lotSl = "", unit = "", locCode = "", qcSampleType = "";
				int noArt = 0, lineNo = 0;
				double quantity = 0, allocQty = 0;

				System.out.println("-------------- itemchanged in Details 3 ----------------------");

				System.out.println("hdrDataDom------->>["+genericUtility.serializeDom(hdrDataDom)+"]");	
				System.out.println("currFormDataDom------>>["+genericUtility.serializeDom(currFormDataDom)+"]");
				System.out.println("allFormDataDom------>>["+genericUtility.serializeDom(allFormDataDom)+"]");

				tranId = checkNull(genericUtility.getColumnValue("tran_id", allFormDataDom, "2" ));
				palletNo = checkNullAndTrim(genericUtility.getColumnValue("pallet_no", hdrDataDom));
				lotNo = checkNullAndTrim(genericUtility.getColumnValue("lot_no", currFormDataDom));
				lotSl = checkNullAndTrim(genericUtility.getColumnValue("lot_sl", currFormDataDom));

				System.out.println("Tran_id----------->>["+tranId+"]");
				System.out.println("palletNo----------->>["+palletNo+"]");
				System.out.println("lotNo 1st ----------->>["+lotNo+"]");
				System.out.println("lotSl 1st ----------->>["+lotSl+"]");

				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{
					System.out.println("--------------inside itm_default  ----------------------");

					if( tranId != null && tranId.trim().length() > 0 )
					{
						System.out.println("--------------inside itm_default edit mode details 3  ----------------------");

						sql = "SELECT D.ITEM_CODE, I.DESCR, D.LOT_NO, D.LOT_SL, D.QUANTITY, I.UNIT, D.NO_ART, D.LOC_CODE, D.LINE_NO, D.ALLOC_QTY, D.QC_SAMPLE_TYPE " 
							+ "FROM PALLET_HDR H, PALLET_DET D, ITEM I " 
							+ "WHERE D.SITE_CODE = ? AND D.TRAN_ID = ? AND D.TRAN_ID = H.TRAN_ID AND " 
							+ "D.ITEM_CODE = I.ITEM_CODE ";	
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, loginSite);		
						pstmt.setString(2, tranId);	
						rs = pstmt.executeQuery();
						while(rs.next())
						{ 							
							itemCode = checkNullAndTrim(rs.getString("item_code"));
							lineNo = rs.getInt("line_no");
							descr = checkNullAndTrim(rs.getString("descr"));	
							lotNo = checkNullAndTrim(rs.getString("lot_no"));	
							lotSl = checkNullAndTrim(rs.getString("lot_sl"));	
							quantity = rs.getDouble("quantity");
							unit = checkNullAndTrim(rs.getString("unit"));
							noArt = rs.getInt("no_art");
							locCode = checkNullAndTrim(rs.getString("loc_code"));	
							allocQty = rs.getDouble("alloc_qty");
							qcSampleType = checkNullAndTrim(rs.getString("qc_sample_type"));

							valueXmlString.append("<Detail3 domID='"+lineNo+"' selected=\"Y\">\r\n");
							valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\" />\r\n"); 

							valueXmlString.append( "<tran_id><![CDATA[" ).append( tranId ).append( "]]></tran_id>\r\n" );
							valueXmlString.append( "<line_no><![CDATA[" ).append( lineNo ).append( "]]></line_no>\r\n" );
							valueXmlString.append( "<item_code><![CDATA[" ).append( itemCode ).append( "]]></item_code>\r\n" );
							valueXmlString.append( "<item_descr><![CDATA[" ).append( descr ).append( "]]></item_descr>\r\n" );
							valueXmlString.append( "<site_code><![CDATA[" ).append( loginSite ).append( "]]></site_code>\r\n" );
							valueXmlString.append( "<loc_code><![CDATA[" ).append( locCode ).append( "]]></loc_code>\r\n" );
							valueXmlString.append( "<lot_no><![CDATA[" ).append( lotNo ).append( "]]></lot_no>\r\n" );
							valueXmlString.append( "<lot_sl><![CDATA[" ).append( lotSl ).append( "]]></lot_sl>\r\n" );
							valueXmlString.append( "<pallet_no><![CDATA[" ).append( palletNo ).append( "]]></pallet_no>\r\n" );
							valueXmlString.append( "<quantity><![CDATA[" ).append( quantity ).append( "]]></quantity>\r\n" );
							valueXmlString.append( "<item_unit><![CDATA[" ).append( unit ).append( "]]></item_unit>\r\n" );
							valueXmlString.append( "<no_art><![CDATA[" ).append( noArt ).append( "]]></no_art>\r\n" );
							valueXmlString.append( "<alloc_qty><![CDATA[" ).append( allocQty ).append( "]]></alloc_qty>\r\n" );
							valueXmlString.append( "<qc_sample_type><![CDATA[" ).append( qcSampleType ).append( "]]></qc_sample_type>\r\n" );
							valueXmlString.append("</Detail3>\r\n");
						}
						if(pstmt != null) { pstmt.close(); pstmt = null; }
						if(rs != null) { rs.close(); rs = null; }
					}
				}

				if(currentColumn.trim().equalsIgnoreCase("itm_default_add"))
				{	
					System.out.println("--------------inside itm_default_add  ----------------------");

					
					int tmpLineNo=0;
					NodeList parentList = allFormDataDom.getElementsByTagName("Detail3");
					parentNodeListLength = parentList.getLength();
					System.out.println((new StringBuilder("parentNodeListLength[")).append(parentNodeListLength).append("]").toString());
					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++)
					{
						parentNode1 = parentList.item(prntCtr);

						AttributeMap attrMap = (AttributeMap) parentNode1.getAttributes();
						System.out.println("[" + prntCtr + "] Node domID [" + attrMap.getNamedItem("domID").getLocalName() + ":" + attrMap.getNamedItem("domID").getNodeValue() + "]");
						lineNo = Integer.parseInt(attrMap.getNamedItem("domID").getNodeValue());
						System.out.println("lineNo----" + lineNo);
						
						childNodeList1 = parentNode1.getChildNodes();
	                    childNodeListLength1 = childNodeList1.getLength();
	                    System.out.println("childNodeListLength1::: "+ childNodeListLength1+"\n");
	                    for (int childRow = 0; childRow < childNodeListLength1; childRow++)
	                    {
	                        childNode1 = childNodeList1.item(childRow);
	                        childNodeName = childNode1.getNodeName();
	                        System.out.println("childNodeName :"+childNodeName);
	                        if (childNodeName.equals("line_no"))
	                        {
	                            if(childNode1.getFirstChild()!=null)
	                            {
	                            	lineNo = Integer.parseInt(childNode1.getFirstChild().getNodeValue().trim());
		                            System.out.println("Detail3 lineNo:::]" +lineNo);
		                            if(tmpLineNo<=lineNo)
		                            {
		                            	tmpLineNo=lineNo;
		                            }
	                            }
	                        }
	                        System.out.println("childRow :"+childRow);
	                        System.out.println("childNodeListLength1 :"+childNodeListLength1);
	                    }
					}
					tmpLineNo++;
					//lineNo = getMaxLineNo(tranId, palletNo, loginSite, conn);
					System.out.println("lineNo in itm_default_add :::::::::::::: " + tmpLineNo);

					if( tranId != null && tranId.trim().length() > 0 ) // edit mode
					{	

						valueXmlString.append("<Detail3 domID='"+tmpLineNo+"' selected=\"N\">\r\n");
						valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" />\r\n");

						valueXmlString.append( "<tran_id><![CDATA[" ).append( tranId ).append( "]]></tran_id>\r\n" );

					}
					else
					{
						valueXmlString.append("<Detail3 domID='"+tmpLineNo+"' selected=\"N\">\r\n");
						valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" />\r\n");

						valueXmlString.append( "<tran_id><![CDATA[]]></tran_id>\r\n" );
					}

					valueXmlString.append( "<line_no><![CDATA[]]></line_no>\r\n" );
					valueXmlString.append( "<item_code><![CDATA[]]></item_code>\r\n" );
					valueXmlString.append( "<item_descr><![CDATA[]]></item_descr>\r\n" );
					valueXmlString.append( "<site_code><![CDATA[" ).append( loginSite ).append( "]]></site_code>\r\n" );
					valueXmlString.append( "<loc_code><![CDATA[]]></loc_code>\r\n" );
					valueXmlString.append( "<lot_no><![CDATA[]]></lot_no>\r\n" );
					valueXmlString.append( "<lot_sl><![CDATA[]]></lot_sl>\r\n" );
					valueXmlString.append( "<pallet_no><![CDATA[" ).append( palletNo ).append( "]]></pallet_no>\r\n" );
					valueXmlString.append( "<quantity><![CDATA[]]></quantity>\r\n" );
					valueXmlString.append( "<item_unit><![CDATA[]]></item_unit>\r\n" );
					valueXmlString.append( "<no_art><![CDATA[]]></no_art>\r\n" );
					valueXmlString.append( "<alloc_qty><![CDATA[]]></alloc_qty>\r\n" );
					valueXmlString.append( "<qc_sample_type><![CDATA[]]></qc_sample_type>\r\n" );
					valueXmlString.append("</Detail3>\r\n");

				}

				if(currentColumn.trim().equalsIgnoreCase("lot_sl"))
				{
					System.out.println("--------------inside lot_sl  ----------------------");

					sql = "SELECT S.ITEM_CODE, I.DESCR, S.QUANTITY, S.UNIT, S.NO_ART, S.LOC_CODE, S.ALLOC_QTY, SI.QC_SAMPLE_TYPE " 
						+ "FROM STOCK S, ITEM I, SITEITEM SI " 
						+ "WHERE S.LOT_NO = ? AND S.LOT_SL = ? AND S.SITE_CODE = ? AND S.QUANTITY > 0 AND S.INV_STAT NOT IN (?,?) " 
						+ "AND S.ITEM_CODE = I.ITEM_CODE AND I.ITEM_CODE = SI.ITEM_CODE  AND S.ITEM_CODE = SI.ITEM_CODE AND S.SITE_CODE = SI.SITE_CODE  ";	
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, lotNo);
					pstmt.setString(2, lotSl);
					pstmt.setString(3, loginSite);		
					pstmt.setString(4, "AWMS");	
					pstmt.setString(5, "AWMSQ");
					rs = pstmt.executeQuery();
					if(rs.next())
					{ 							
						itemCode = checkNullAndTrim(rs.getString("item_code"));	
						descr = checkNullAndTrim(rs.getString("descr"));	
						quantity = rs.getDouble("quantity");
						unit = checkNullAndTrim(rs.getString("unit"));
						noArt = rs.getInt("no_art");
						locCode = checkNullAndTrim(rs.getString("loc_code"));	
						allocQty = rs.getDouble("alloc_qty");
						qcSampleType = checkNullAndTrim(rs.getString("qc_sample_type"));

						//lineNo = getMaxLineNo(tranId, palletNo, loginSite, conn);
						int tmpLineNo=0;
						NodeList parentList = allFormDataDom.getElementsByTagName("Detail3");
						parentNodeListLength = parentList.getLength();
						System.out.println((new StringBuilder("parentNodeListLength[")).append(parentNodeListLength).append("]").toString());
						for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++)
						{
							parentNode1 = parentList.item(prntCtr);

							AttributeMap attrMap = (AttributeMap) parentNode1.getAttributes();
							System.out.println("[" + prntCtr + "] Node domID [" + attrMap.getNamedItem("domID").getLocalName() + ":" + attrMap.getNamedItem("domID").getNodeValue() + "]");
							lineNo = Integer.parseInt(attrMap.getNamedItem("domID").getNodeValue());
							System.out.println("lineNo----" + lineNo);
							
							childNodeList1 = parentNode1.getChildNodes();
		                    childNodeListLength1 = childNodeList1.getLength();
		                    System.out.println("childNodeListLength1::: "+ childNodeListLength1+"\n");
		                    for (int childRow = 0; childRow < childNodeListLength1; childRow++)
		                    {
		                        childNode1 = childNodeList1.item(childRow);
		                        childNodeName = childNode1.getNodeName();
		                        System.out.println("childNodeName :"+childNodeName);
		                        if (childNodeName.equals("line_no"))
		                        {
		                            if(childNode1.getFirstChild()!=null)
		                            {
		                            	lineNo = Integer.parseInt(childNode1.getFirstChild().getNodeValue().trim());
			                            System.out.println("Detail3 lineNo:::]" +lineNo);
			                            if(tmpLineNo<=lineNo)
			                            {
			                            	tmpLineNo=lineNo;
			                            }
		                            }
		                        }
		                        System.out.println("childRow :"+childRow);
		                        System.out.println("childNodeListLength1 :"+childNodeListLength1);
		                    }
						}
						tmpLineNo++;
						System.out.println("lineNo in lot_sl :::::::::::::: " + tmpLineNo);

						if( tranId != null && tranId.trim().length() > 0 )
						{

							valueXmlString.append("<Detail3 domID='"+tmpLineNo+"' selected=\"N\">\r\n");
							valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" />\r\n");

							valueXmlString.append( "<tran_id><![CDATA[" ).append( tranId ).append( "]]></tran_id>\r\n" );
						}
						else
						{
							valueXmlString.append("<Detail3 domID='"+tmpLineNo+"' selected=\"N\">\r\n");
							valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" />\r\n");

							valueXmlString.append( "<tran_id><![CDATA[" ).append( "" ).append( "]]></tran_id>\r\n" );
						}

						valueXmlString.append( "<line_no><![CDATA[" ).append( tmpLineNo ).append( "]]></line_no>\r\n" );
						valueXmlString.append( "<item_code><![CDATA[" ).append( itemCode ).append( "]]></item_code>\r\n" );
						valueXmlString.append( "<item_descr><![CDATA[" ).append( descr ).append( "]]></item_descr>\r\n" );
						valueXmlString.append( "<site_code><![CDATA[" ).append( loginSite ).append( "]]></site_code>\r\n" );
						valueXmlString.append( "<loc_code><![CDATA[" ).append( locCode ).append( "]]></loc_code>\r\n" );
						valueXmlString.append( "<lot_no><![CDATA[" ).append( lotNo ).append( "]]></lot_no>\r\n" );
						valueXmlString.append( "<lot_sl><![CDATA[" ).append( lotSl ).append( "]]></lot_sl>\r\n" );
						valueXmlString.append( "<pallet_no><![CDATA[" ).append( palletNo ).append( "]]></pallet_no>\r\n" );
						valueXmlString.append( "<quantity><![CDATA[" ).append( quantity ).append( "]]></quantity>\r\n" );
						valueXmlString.append( "<item_unit><![CDATA[" ).append( unit ).append( "]]></item_unit>\r\n" );
						valueXmlString.append( "<no_art><![CDATA[" ).append( noArt ).append( "]]></no_art>\r\n" );
						valueXmlString.append( "<alloc_qty><![CDATA[" ).append( allocQty ).append( "]]></alloc_qty>\r\n" );
						valueXmlString.append( "<qc_sample_type><![CDATA[" ).append( qcSampleType ).append( "]]></qc_sample_type>\r\n" );
						valueXmlString.append("</Detail3>\r\n");
					}
					if(pstmt != null) { pstmt.close(); pstmt = null; }
					if(rs != null) { rs.close(); rs = null; }

				}	
			} //Case 3. End
			break;

			}//End of switch block
			valueXmlString.append( "</Root>\r\n" );	 
		}
		catch (Exception e)
		{				
			e.printStackTrace();			

		}
		finally
		{	
			try
			{				
				if(rs!=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println( "valueXmlString.toString()>>>>>>>::"+valueXmlString.toString());
		return valueXmlString.toString();
	}

	private String checkNull( String input )	
	{
		if ( input == null )
		{
			input = "";
		}
		return input.trim();
	}

	private String checkNullAndTrim( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		else
		{
			inputVal = inputVal.trim();
		}
		return inputVal;
	}

	private int getMaxLineNo(String tranId, String palletNo, String siteCode, Connection conn) throws Exception
	{	

		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String sql = "";
		int lineNo = 0;

		try
		{	
			if( tranId != null && tranId.trim().length() > 0 ) // edit mode
			{
				sql = "SELECT MAX(LINE_NO)+1 AS LINE_NO FROM PALLET_DET WHERE TRAN_ID = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);		
				rs= pstmt.executeQuery();
				if(rs.next())
				{
					lineNo = rs.getInt("line_no");	
				}
				if(pstmt != null) { pstmt.close(); pstmt = null; }
				if(rs != null) { rs.close(); rs = null; }
			}
			else // add mode
			{
				sql = "SELECT MAX(LINE_NO)+1 AS LINE_NO FROM PALLET_DET DET, PALLET_HDR HDR WHERE " 
					+ " HDR.PALLET_NO = ? AND HDR.CONFIRMED = ? AND HDR.SITE_CODE = ? AND HDR.TRAN_ID = DET.TRAN_ID ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, palletNo);		
				pstmt.setString(2, "N");	
				pstmt.setString(3, siteCode);	
				rs= pstmt.executeQuery();
				if(rs.next())
				{
					lineNo = rs.getInt("line_no");	
				}
				if(pstmt != null) { pstmt.close(); pstmt = null; }
				if(rs != null) { rs.close(); rs = null; }
			}


			if(lineNo == 0)
			{
				lineNo = 1;
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception in getItemQcStatus ::::::: " + e);
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}

		System.out.println("return lineNo from getMaxLineNo :::::::::::::::::; "+lineNo);
		return lineNo;
	}
	//Changed by Jagruti Shinde Req id:[W16GSUN003][START]
	private Double getPalletSwmsQty(String palletNo, String loginSite, Connection conn) throws Exception
	{
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "" ,sqlPallet ="";
		double quantity = 0;
		int countPallet =0;
		try
		{	
			sqlPallet=" SELECT COUNT(1) FROM PALLET_HDR H,PALLET_DET D,SWMS_TO_AWMS S WHERE D.TRAN_ID=H.TRAN_ID AND " +
			" H.TRAN_ID=S.REF_ID AND H.CONFIRMED = ? AND S.SCHEDULE_STATUS = ?  AND H.PALLET_NO = S.PALLET_NO AND H.PALLET_NO = ?";
			pstmt = conn.prepareStatement(sqlPallet);
			pstmt.setString(1, "Y");
			pstmt.setString(2, "Y");
			pstmt.setString(3, palletNo);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				countPallet = rs.getInt(1);	
				System.out.println("countPallet:::::"+countPallet);
			}
			if(pstmt != null)
			{ 
				pstmt.close(); 
				pstmt = null;
			}
			if(rs != null)
			{ 
				rs.close(); 
				rs = null; 
			}
			if(countPallet > 0)
			{
				sql = "SELECT SUM(QUANTITY) FROM STOCK WHERE LOC_CODE IN(?,?,?,?,?,?,?,?) AND SITE_CODE = ? AND  INV_STAT IN(?,?) ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, palletNo);
				pstmt.setString(2, palletNo+"Q");
				pstmt.setString(3, palletNo+"B");
				pstmt.setString(4, palletNo+"X");
				pstmt.setString(5, palletNo+"M");
				pstmt.setString(6, palletNo+"U");
				pstmt.setString(7, palletNo+"P");
				pstmt.setString(8, palletNo+"S");
				pstmt.setString(9, loginSite);
				pstmt.setString(10, "AWMS");
				pstmt.setString(11, "AWMSQ");
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					quantity = rs.getInt(1);
					System.out.println("quantity::::::::"+quantity);
				}
				if(pstmt != null)
				{ 
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{ 
					rs.close(); 
					rs = null;
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception in getPalletSwmsQty ::::::::: " + e);
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		System.out.println("Return  from getPalletSwmsQty ------>>" + quantity);		
		return quantity;
	}

	private int getPalletHdrCount(String palletNo, Connection conn) throws Exception
	{	
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "" ,sqlTranId ="" ,tranId ="",errString ="";
		int countHdr = 0 ,stockCount =0 ;
		ITMDBAccessEJB itmdbAccess = new ITMDBAccessEJB();
		try
		{	
			sql ="SELECT COUNT(1) FROM PALLET_HDR WHERE PALLET_NO = ? AND CONFIRMED = ? ";	
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, palletNo);
			pstmt.setString(2, "N");
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				countHdr = rs.getInt(1);		
			}
			if(pstmt != null)
			{ 
				pstmt.close(); 
				pstmt = null;
			}
			if(rs != null)
			{ 
				rs.close(); 
				rs = null; 
			}

		}
		catch(Exception e)
		{
			System.out.println("Exception in getPalletHdrCount ::::::: " + e);
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		System.out.println("return value from getPalletHdrCount :::::::::: " + countHdr);
		return countHdr;
	}

	private int getPalletLotAWMSCount(String palletNo,String lotNo,String lotSl,Connection conn) throws Exception
	{	
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";
		int countLot = 0;
		try
		{	
			sql =" SELECT COUNT(1) FROM PALLET_HDR H,PALLET_DET D,SWMS_TO_AWMS S WHERE D.TRAN_ID=H.TRAN_ID AND " +
			" H.TRAN_ID=S.REF_ID AND H.CONFIRMED = ? AND S.SCHEDULE_STATUS = ?  " +
			//"AND H.PALLET_NO = S.PALLET_NO  " +
			" AND D.LOT_NO = S.LOT_NO AND D.LOT_SL = S.LOT_SL " +
			//"AND H.PALLET_NO = ? " +
			" AND D.LOT_NO = ?  AND D.LOT_SL = ? AND S.REF_SER = ? " ;

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "Y");
			pstmt.setString(2, "N");
			//pstmt.setString(3, palletNo);
			pstmt.setString(3, lotNo);
			pstmt.setString(4, lotSl);
			pstmt.setString(5, "PZ");
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				countLot = rs.getInt(1);		
			}
			if(pstmt != null)
			{ 
				pstmt.close(); 
				pstmt = null;
			}
			if(rs != null)
			{ 
				rs.close(); 
				rs = null; 
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception in getPalletLotAWMSCount ::::::: " + e);
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		System.out.println("return value from getPalletLotAWMSCount :::::::::: " + countLot);
		return countLot;
	}

	private Double getPalletLotQty(String palletNo,String lotNo,String lotSl, String loginSite, Connection conn) throws Exception
	{
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "" ,sqlPallet ="";
		double quantity = 0;
		int countPallet =0;
		try
		{	
			sqlPallet=" SELECT COUNT(1) FROM PALLET_HDR H,PALLET_DET D,SWMS_TO_AWMS S WHERE D.TRAN_ID=H.TRAN_ID AND " +
			" H.TRAN_ID=S.REF_ID AND H.CONFIRMED = ? AND S.SCHEDULE_STATUS = ? " +
			//" AND H.PALLET_NO = S.PALLET_NO AND H.PALLET_NO = ?" +
			" AND D.LOT_NO = S.LOT_NO AND D.LOT_SL = S.LOT_SL AND D.LOT_NO = ?  AND D.LOT_SL = ?";
			pstmt = conn.prepareStatement(sqlPallet);
			pstmt.setString(1, "Y");
			pstmt.setString(2, "Y");
			//pstmt.setString(3, palletNo);
			pstmt.setString(3, lotNo);
			pstmt.setString(4, lotSl);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				countPallet = rs.getInt(1);	
				System.out.println("countPallet:::::"+countPallet);
			}
			if(pstmt != null)
			{ 
				pstmt.close(); 
				pstmt = null;
			}
			if(rs != null)
			{ 
				rs.close(); 
				rs = null; 
			}
			if(countPallet > 0)
			{
				sql = "SELECT SUM(QUANTITY) FROM STOCK WHERE " +
				" SITE_CODE = ? AND  INV_STAT IN(?,?) AND LOT_NO = ? AND LOT_SL = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, loginSite);
				pstmt.setString(2, "AWMS");
				pstmt.setString(3, "AWMSQ");
				pstmt.setString(4, lotNo);
				pstmt.setString(5, lotSl);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					quantity = rs.getInt(1);
					System.out.println("quantity::::::::"+quantity);
				}
				if(pstmt != null)
				{ 
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{ 
					rs.close(); 
					rs = null;
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception in getPalletLotQty ::::::::: " + e);
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		System.out.println("Return  from getPalletLotQty ------>>" + quantity);		
		return quantity;
	}
	//Changed by Jagruti Shinde Req id:[W16GSUN003][End]
}