/*
 * Author:Wasim Ansari
 * Date:08-08-2016
 * Request ID:S16EBAS006 (Pack Label Wizard)
 */
package ibase.webitm.ejb.wms;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import ibase.wrkflw.metadata.Length;

import java.net.InetAddress;
import java.rmi.RemoteException;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;

import javax.ejb.Stateless;
import javax.naming.InitialContext;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Session Bean implementation class PackLabelWizPosEJB
 */
@Stateless
public class PackLabelWizPosEJB extends ValidatorEJB implements PackLabelWizPosEJBRemote,PackLabelWizPosEJBLocal 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	MasterStatefulLocal masterStatefulLocal = null;
	DistCommon distComm = new DistCommon();
	String asnNo = "";
	/**
	 * Default constructor. 
	 */
	public PackLabelWizPosEJB() {
		// TODO Auto-generated constructor stub
	}

	@Override
	public String postSave(String xmlStringAll, String tranID, String editFlag, String xtraParams, Connection conn) throws RemoteException, ITMException 
	{
		String retString="";
		try 
		{
			retString = postSave(xmlStringAll, xtraParams, "", conn);
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}


	public String postSave(String xmlstring, String xtraParams, String forcedFlag, Connection conn) throws RemoteException,ITMException
	{
		System.out.println("Inside Pack Label Wizard Post Save");

		PreparedStatement pstmt = null, pstmtUpdate = null;
		ResultSet rs = null;

		String retString = "",userInfo = "";

		SimpleDateFormat simpleDateFormat = null;
		String currDate = "";

		boolean isError = false;
		int lineNo = 0;
		Document dom = null;

		String contractNo = "",purcOrder = "",suppCode = "",siteCode = "",userId = "",loginSiteCode = "",tranCode = "", tranType = "",scacCode = "",lineNoOrd = "";

		try
		{	
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			dom = genericUtility.parseString(xmlstring);

			currDate = getCurrdateAppFormat();
			//asnNo = "ASN" + GetRandomNumber();

			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			loginSiteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");
			Node detail1Node = dom.getElementsByTagName("Detail1").item(0);
			NodeList detail1List = detail1Node.getChildNodes();
			int detail1ListLen = detail1List.getLength();
			System.out.println("Detail1 Length =========================================="+detail1ListLen);
			for(int ctr = 0 ;ctr < detail1ListLen; ctr++)
			{
				Node childNode = detail1List.item(ctr);
				if(childNode == null || childNode.getNodeType() != childNode.ELEMENT_NODE)
				{
					continue;
				}

				if(childNode != null && "contract_no".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					contractNo = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "purc_order".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					purcOrder = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "supp_code".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					suppCode = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "site_code".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					siteCode = checkNull(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "tran_code".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					tranCode = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "tran_type".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					tranType = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "scac_code".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					scacCode = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
			}
			System.out.println("site_code is ===["+siteCode+"]");
			asnNo = generateTranId("w_asn",loginSiteCode,siteCode,conn );
			
			StringBuffer xmlString = new StringBuffer();
			StringBuffer xmlStringHdr= new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
			xmlStringHdr.append("<DocumentRoot><description>Datawindow Root</description><group0><description>Group0 escription</description>");
			xmlStringHdr.append("<Header0>");
			xmlStringHdr.append("<description>Header0 members</description>");
			xmlStringHdr.append("<objName><![CDATA[").append("asn").append("]]></objName>");
			xmlStringHdr.append("<pageContext><![CDATA[").append("1").append("]]></pageContext>");
			xmlStringHdr.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
			xmlStringHdr.append("<editFlag><![CDATA[").append("A").append("]]></editFlag>");
			xmlStringHdr.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
			xmlStringHdr.append("<action><![CDATA[").append("SAVE").append("]]></action>");
			xmlStringHdr.append("<elementName><![CDATA[").append("").append("]]></elementName>");
			xmlStringHdr.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
			xmlStringHdr.append("<taxKeyValue><![CDATA[").append("").append("]]></taxKeyValue>");
			xmlStringHdr.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
			xmlStringHdr.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
			xmlStringHdr.append("<taxInFocus><![CDATA[").append(false).append("]]></taxInFocus>");

			xmlStringHdr.append("<Detail1 dbID='' domID=\"1\" objName=\"asn\" objContext=\"1\">");
			xmlStringHdr.append("<attribute pkNames=\"tran_id:\" status=\"N\" updateFlag=\"A\" selected=\"N\" />");

			xmlStringHdr.append("<asn_no><![CDATA[").append(asnNo).append("]]></asn_no>");
			xmlStringHdr.append("<site_code><![CDATA[").append(siteCode).append("]]></site_code>");
			xmlStringHdr.append("<tran_id><![CDATA[").append("").append("]]></tran_id>");
			xmlStringHdr.append("<tran_date><![CDATA[").append(currDate).append("]]></tran_date>");
			xmlStringHdr.append("<asn_date><![CDATA[").append(currDate).append("]]></asn_date>");
			xmlStringHdr.append("<tran_code><![CDATA[").append(tranCode).append("]]></tran_code>");
			xmlStringHdr.append("<tran_type><![CDATA[").append(tranType).append("]]></tran_type>");
			xmlStringHdr.append("<scac_code><![CDATA[").append(scacCode).append("]]></scac_code>");
			xmlStringHdr.append("<supp_code><![CDATA[").append(suppCode).append("]]></supp_code>");
			if(contractNo != null && contractNo.trim().length()>0)
			{
				xmlStringHdr.append("<contract_no><![CDATA[").append(contractNo).append("]]></contract_no>");
			}
			else
			{
				xmlStringHdr.append("<purc_order><![CDATA[").append(purcOrder).append("]]></purc_order>");
			}

			//xmlStringHdr.append("</Detail1>");

			StringBuffer xmlStringDet = new StringBuffer();
			String lotNo = "",itemCode = "",empCodeAprv = "",mfgSite = "",mfgDate = "",expDate = "";
			int domID = 0;
			double quantity = 0,shipperSize = 0,grossWeight = 0,grossWeightItem = 0;

			NodeList detail3NodeList =dom.getElementsByTagName("Detail2");
			int detail3NodeListlen = detail3NodeList.getLength();
			System.out.println("Detail2 Length =========================================="+detail3NodeListlen);
			for(int ctrH = 0; ctrH < detail3NodeListlen ; ctrH++)
			{
				NodeList childNodeList = detail3NodeList.item(ctrH).getChildNodes();
				int childNodeListlen = childNodeList.getLength();

				for(int ctrD = 0; ctrD < childNodeListlen ; ctrD++)
				{
					Node childNode = childNodeList.item(ctrD);

					if(childNode == null || childNode.getNodeType() != childNode.ELEMENT_NODE)
					{
						continue;
					}

					if(childNode != null && "item_code".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						itemCode = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
					}
					else if(childNode != null && "quantity".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						quantity = Double.parseDouble(childNode.getFirstChild().getNodeValue());
					}
					else if(childNode != null && "lot_no".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						lotNo = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
					}
					else if(childNode != null && "shipper_size".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						shipperSize = Double.parseDouble(childNode.getFirstChild().getNodeValue());
					}
					else if(childNode != null && "exp_date".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						expDate = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
					}
					else if(childNode != null && "mfg_date".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						mfgDate = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
					}
					else if(childNode != null && "site_code__mfg".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						mfgSite= checkNull(childNode.getFirstChild().getNodeValue());
					}
					else if(childNode != null && "line_no__ord".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						lineNoOrd= checkNull(childNode.getFirstChild().getNodeValue());
						System.out.println("lineNoOrd is ===["+lineNoOrd+"]");
					}
				}
				domID++;

				System.out.println("Before shipperSize in postSave="+shipperSize);

				shipperSize = checkShipperSize(itemCode,lotNo,shipperSize,xtraParams, conn);

				System.out.println("After shipperSize in postSave="+shipperSize);
				System.out.println("After expDate in postSave=["+expDate+"]");
				System.out.println("After mfgDate in postSave=["+mfgDate+"]");

				grossWeightItem = getItemGrossWeight(itemCode,lotNo,conn);

				grossWeight = grossWeight+grossWeightItem;
				System.out.println("Gross Weight="+grossWeight);

				xmlStringDet.append("<Detail2 dbID=':' domID='"+ domID +"' objName='asn' objContext='2'>");
				xmlStringDet.append("<attribute pkNames='tran_id:line_no:' status='N' updateFlag='A' selected='N'/>");

				xmlStringDet.append("<line_no><![CDATA[").append(domID).append("]]></line_no>");
				xmlStringDet.append("<line_no__ord><![CDATA[").append(lineNoOrd).append("]]></line_no__ord>");
				xmlStringDet.append("<item_code><![CDATA[").append(itemCode).append("]]></item_code>");
				xmlStringDet.append("<quantity><![CDATA[").append(quantity).append("]]></quantity>");
				xmlStringDet.append("<lot_no><![CDATA[").append(lotNo).append("]]></lot_no>");
				xmlStringDet.append("<pack_size><![CDATA[").append(shipperSize).append("]]></pack_size>");
				xmlStringDet.append("<exp_date><![CDATA[").append(expDate).append("]]></exp_date>");
				xmlStringDet.append("<mfg_date><![CDATA[").append(mfgDate).append("]]></mfg_date>");
				xmlStringDet.append("<site_code__mfg><![CDATA[").append(mfgSite).append("]]></site_code__mfg>");
				xmlStringDet.append("<no_pallet><![CDATA[1]]></no_pallet>");

				xmlStringDet.append("</Detail2>");

			}
			xmlStringHdr.append("<gross_weight><![CDATA[").append(grossWeight).append("]]></gross_weight>");
			xmlStringHdr.append("</Detail1>");

			xmlString.append(xmlStringHdr);
			xmlString.append(xmlStringDet);
			xmlString.append("</Header0></group0></DocumentRoot>");

			System.out.println("@@xmlString For generation ASN:: "+xmlString.toString());
			masterStatefulLocal = (MasterStatefulLocal)ctx.lookup("ibase/MasterStatefulEJB/local"); 

			if(xtraParams == null)
			{
				//xtraParams = getXtraParams(userId,siteCode,empCode,conn);//Need to consider emp code
				xtraParams = getXtraParams(userId,siteCode,userId,conn);
			}
			userInfo  = getUserInfo(xtraParams);

			retString = masterStatefulLocal.processRequest(userInfo, xmlString.toString(), true, conn); 

			System.out.println("ASN return string"+retString);

			if ( retString.indexOf("Success") > -1 && retString.indexOf("<TranID>") > 0 )
			{
				String asnTranId = retString.substring( retString.indexOf("<TranID>")+8, retString.indexOf("</TranID>"));
				System.out.println("ASN tranId is :"+asnTranId);

				String genPackLabel  = checkNullAndTrim(distComm.getDisparams("999999","GENERATE_PACK_LABEL",conn)); 

				if("Y".equalsIgnoreCase(genPackLabel))
				{
					insertCaseLabel(asnTranId,xtraParams, conn);
				}
			}
			else
			{
				System.out.println("Error while creating ASN");
				//throw new Exception(retString);
			}
		}
		catch(Exception e)
		{
			isError = true;
			//asnNo = "";
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(isError)
				{
					//asnNo = "";
					conn.rollback();
				}
				else
				{
					conn.commit();
				}
				if ( rs != null )
				{
					rs.close();rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();pstmt = null;
				}
			}
			catch( Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println("errString from post save ASN =["+retString+"]");
		return retString;
	}

	private static String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input;
	}

	private static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}

	private java.sql.Timestamp getCurrtDate() throws RemoteException,ITMException 
	{
		String currAppdate = "";
		java.sql.Timestamp currDate = null;
		try 
		{
			Object date = null;
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(genericUtility.getDBDateFormat());
			date = sdf.parse(currDate.toString());
			currDate = java.sql.Timestamp.valueOf(sdf.format(date).toString()+ " 00:00:00.0");

		} 
		catch (Exception e) 
		{
			throw new ITMException(e);
		}
		return (currDate);
	}

	private String getCurrdateAppFormat() 
	{
		String s = "";
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			java.util.Date date = null;
			Timestamp timestamp = new Timestamp(System.currentTimeMillis());

			SimpleDateFormat simpledateformat = new SimpleDateFormat(genericUtility.getDBDateFormat());
			date = simpledateformat.parse(timestamp.toString());
			timestamp = Timestamp.valueOf(simpledateformat.format(date).toString() + " 00:00:00.0");
			s = new SimpleDateFormat(genericUtility.getApplDateFormat()).format(timestamp).toString();
		}
		catch (Exception localException)
		{
		}

		return s;
	}

	private InitialContext getInitialContext() throws ITMException 
	{
		InitialContext ctx = null;
		try 
		{
			System.out.println("getInitialContext");
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());

		}
		catch (ITMException itme)
		{
			System.out.println("ITMException :StatelessItemChangeServlet :getInitialContext :==>");
			throw itme;
		}
		catch (Exception e) 
		{
			System.out.println("Exception :StatelessItemChangeServlet :getInitialContext :==>");
			throw new ITMException(e);
		}
		return ctx;
	}

	public String getUserInfo( String xtraParams )throws ITMException
	{
		StringBuffer userInfoStr = new StringBuffer();
		String userId = "";
		String loginEmpCode = "";
		String loginSiteCode = "";
		String entityCode = "";
		String profileId = "";
		String userType = "";

		String chgTerm = "";
		//Added by sarita on 26DEC2017
		String transDB = "";
		try
		{
			E12GenericUtility genericUtility = new E12GenericUtility();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			loginSiteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");
			entityCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"entityCode");
			profileId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"profileId");
			userType = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"userType");

			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"chgTerm");
			//added  by sarita on 26DEC2017 to insert transDB parameter	
			transDB = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"transDB");
			System.out.println("xtraParams  is @@@@@ " + xtraParams);

			userInfoStr.append("<UserInfo>");
			userInfoStr.append("<loginCode>").append("<![CDATA["+userId+"]]>").append("</loginCode>\r\n");
			userInfoStr.append("<empCode>").append("<![CDATA["+loginEmpCode+"]]>").append("</empCode>\r\n");
			userInfoStr.append("<siteCode>").append("<![CDATA["+loginSiteCode+"]]>").append("</siteCode>\r\n");
			userInfoStr.append("<entityCode>").append("<![CDATA["+entityCode+"]]>").append("</entityCode>\r\n");
			userInfoStr.append("<profileId>").append("<![CDATA["+profileId+"]]>").append("</profileId>\r\n");
			userInfoStr.append("<userType>").append("<![CDATA["+userType+"]]>").append("</userType>\r\n");

			userInfoStr.append("<remoteHost>").append("<![CDATA["+chgTerm+"]]>").append("</remoteHost>\r\n");
			//added  by sarita on 26DEC2017 to insert transDB parameter
			userInfoStr.append("<transDB>").append("<![CDATA["+transDB+"]]>").append("</transDB>\r\n");
			userInfoStr.append("</UserInfo>");
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		return userInfoStr.toString();
	}

	public String getXtraParams( String loginCode, String siteCode,String empCode,Connection  conn)throws Exception
	{
		String remotehost = "";
		String entityCode = "";
		String profileId = "";
		String userType = "";
		String userLang = "";
		String userCountry = "";	
		StringBuffer xtraParamsBuff = new StringBuffer();

		String sql = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		//Added by sarita on 26DEC2017
		String transDB = "";

		try
		{
			sql = "SELECT USR_LEV,USER_TYPE,ENTITY_CODE,PROFILE_ID,LOGGER_TYPE,USER_LANG,"+
			"USER_COUNTRY,TRANS_DB, USER_THEME FROM USERS WHERE CODE = ? ";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1,loginCode);			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				entityCode = rs.getString("ENTITY_CODE");
				profileId  = rs.getString("PROFILE_ID");
				userType   = rs.getString("USER_TYPE");
				userLang   = rs.getString("USER_LANG");
				userCountry= rs.getString("USER_COUNTRY");
				//added  by sarita on 26DEC2017 to insert transDB parameter
				transDB= rs.getString("TRANS_DB");
			}			

			remotehost =  InetAddress.getLocalHost().getHostAddress();
			String XTRA_PARAMS_SEPARATOR = "~~";

			xtraParamsBuff.append("loginCode=" + loginCode);
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("loginEmpCode=" + empCode);
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("loginSiteCode=" + siteCode);
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("entityCode=" + entityCode);
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("profileId=" + profileId);
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("userType=" + userType);
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("runMode=I");
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("user_lang=" + userLang);
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("user_country=" + userCountry);
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("charEnc=" + CommonConstants.ENCODING);

			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("termId="+remotehost);
			//added  by sarita on 26DEC2017 to insert transDB parameter
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("transDB="+transDB);
			String chgTerm = remotehost;
			if( chgTerm != null && chgTerm.length() > 15 )
			{
				chgTerm = chgTerm.substring(0, 15);
			}
			else if( chgTerm == null || chgTerm.length() == 0 )
			{
				chgTerm = remotehost;
			}
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("chgTerm=" + chgTerm );

			System.out.println("xtraParamsBuff ["+xtraParamsBuff+"]");


		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return xtraParamsBuff.toString();
	}

	public String insertCaseLabel( String asnTranId, String xtraParams, Connection  conn)throws Exception
	{
		String sql = "",itemCode = "",lotNo = "",packLabel = "",userId = "",chgTerm = "",loginSiteCode = "",quantity = "",asnNo1 = "";
		PreparedStatement pstmt = null, pstmtInsert = null ; 
		ResultSet rs = null;
		Timestamp currDate = null;	
		boolean isError = false;
		int cnt = 0;
		try
		{
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			currDate = getCurrtDate();

			sql = " INSERT INTO CASE_LABEL (ITEM_CODE,LOT_NO,ORDER_NO,REF_SER,QUANTITY,LABEL_NO,CHG_USER,CHG_DATE,CHG_TERM) "
				+ " VALUES (?,?,?,?,?,?,?,?,?) ";
			pstmtInsert = conn.prepareStatement(sql);	

			sql = " SELECT H.ASN_NO, D.ITEM_CODE, D.LOT_NO, D.QUANTITY FROM ASN_HDR H,ASN_DET D "
				+ " WHERE H.TRAN_ID = D.TRAN_ID AND H.TRAN_ID = ?";
			pstmt = conn.prepareStatement(sql);	
			pstmt.setString(1,asnTranId);
			rs = pstmt.executeQuery();

			while(rs.next())
			{
				cnt++;

				asnNo1 = checkNullAndTrim(rs.getString("ASN_NO"));
				itemCode = checkNullAndTrim(rs.getString("ITEM_CODE"));
				lotNo = checkNullAndTrim(rs.getString("LOT_NO"));
				quantity = checkNullAndTrim(rs.getString("QUANTITY"));

				if(quantity.length() == 1)
				{
					quantity = "000"+quantity;
				}
				else if(quantity.length() == 2)
				{
					quantity = "00"+quantity;
				}
				else if(quantity.length() == 3)
				{
					quantity = "0"+quantity;
				}

				packLabel = asnNo1 + lotNo + itemCode + quantity;

				pstmtInsert.setString(1,itemCode);
				pstmtInsert.setString(2,lotNo);	
				pstmtInsert.setString(3,asnTranId);	
				pstmtInsert.setString(4,"P-CON");	
				pstmtInsert.setString(5,quantity);	
				pstmtInsert.setString(6,packLabel);	
				pstmtInsert.setString(7,userId);
				pstmtInsert.setTimestamp(8,currDate);
				pstmtInsert.setString(9,chgTerm);
				pstmtInsert.addBatch();
			}
			if(rs != null)
			{
				rs.close();rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();pstmt = null;
			}

			System.out.println("Total Recs ="+cnt);
			if(cnt > 0)
			{	
				pstmtInsert.executeBatch();
			}
			if(pstmtInsert != null)
			{
				pstmtInsert.close();pstmtInsert = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
				if(pstmtInsert != null)
				{
					pstmtInsert.close();pstmtInsert = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return "";
	}

	public int GetRandomNumber()
	{
		long timeSeed = System.nanoTime(); // to get the current date time value
		double randSeed = Math.random() * 1000; // random number generation
		long midSeed = (long) (timeSeed * randSeed); 
		String s = midSeed + "";
		String subStr = s.substring(0, 9);
		int finalSeed = Integer.parseInt(subStr);    // integer value
		return finalSeed;
	}


	public double checkShipperSize(String itemCode,String lotNo,double userShipperSize,String xtraParams, Connection conn) throws Exception
	{
		String sql = "",LotNoFrom = "",LotNoTo = "",NewStr = "";
		PreparedStatement pstmt = null,pstmtSql = null, pstmtInsert = null ; 
		ResultSet rs = null;
		int Count = 0,left = 0,cnt1 = 0;
		double shipperSize = 0;
		String userId = "",chgTerm = "";
		Timestamp currDate = null;

		double grossWeight = 0,netWeight = 0,innerShipperSize = 0,duplexSize = 0,innerShipperGrWt = 0,innerShipperNtWt = 0,duplexGrossWt = 0,
		width = 0,height = 0,shipperlength = 0,duplexNtWt = 0;
		String unitPack = "",shelfLife = "",siteCodeMfg = "",siteCodeOwn = "",unitInnerLabel = "",tranMode = "",udfStr1 = "",lotNoToOld = "",
		lotNoFromOld = "",LotNoFromUpd = "";

		int updCnt = 0;

		try
		{
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			currDate = getCurrtDate();

			LotNoFrom = lotNo;

			sql=" SELECT LOT_NO__FROM FROM ITEM_LOT_PACKSIZE WHERE ITEM_CODE = ? AND LOT_NO__FROM <= ? AND LOT_NO__TO >= ? ";
			pstmtSql= conn.prepareStatement(sql);
			pstmtSql.setString(1,itemCode);
			pstmtSql.setString(2,LotNoFrom);
			pstmtSql.setString(3,LotNoFrom);

			rs=pstmtSql.executeQuery();
			if(rs.next())
			{
				lotNoFromOld = checkNullAndTrim(rs.getString("LOT_NO__FROM"));
				Count++;
			}
			if(rs != null)
			{
				rs.close();rs=null;
			}
			if(pstmtSql !=null)
			{
				pstmtSql.close();pstmtSql=null;
			}

			System.out.println("Lot No Fr DB["+lotNoFromOld+"] UserLotNo ["+lotNo+"]");
			if(lotNoFromOld.equalsIgnoreCase(lotNo)) //if lot number entered by user is equal to lot no present in DB then update shipper size
			{
				/**
				 * Update the shipper size as entered by user
				 */
				sql=" UPDATE ITEM_LOT_PACKSIZE SET SHIPPER_SIZE = ? WHERE ITEM_CODE = ? AND LOT_NO__FROM = ? ";
				pstmtSql=conn.prepareStatement(sql);
				pstmtSql.setDouble(1,userShipperSize);
				pstmtSql.setString(2,itemCode);
				pstmtSql.setString(3,lotNo);

				updCnt = pstmtSql.executeUpdate();
				System.out.println("Update Count="+updCnt);

				if(pstmtSql !=null)
				{
					pstmtSql.close();
					pstmtSql=null;
				}
				return userShipperSize;
			}

			System.out.println("Count ITEM_LOT_PACKSIZE-------->>["+Count+"]");
			if(Count > 0)
			{
				String s2=LotNoFrom.trim();
				System.out.println("@@@Lot Number Length="+s2.length());
				left=0;
				char right= s2.charAt(s2.length()-1);
				int diff3=0;
				String original="", result = "",result2="";
				int length = LotNoFrom.length();
				System.out.println("@@@Lot Number Length="+s2);


				System.out.println("@@@Lot Number Right Character="+right);
				for ( int i = length - 1 ; i >= 0 ; i-- )
				{
					Character character  = LotNoFrom.charAt(i);
					System.out.println("Char="+character);

					boolean flag = isNumber(character);
					System.out.println("isNumber Flag="+flag);
					if(!flag)
					{
						result = result + LotNoFrom.charAt(i);
						break;
					}
					cnt1++;
				}
				System.out.println("Result of entered string is: "+result);
				System.out.println("Count is:::"+cnt1);
				int testOrginal=0;
				int sub=0;
				testOrginal=length-cnt1;

				System.out.println("testOrginal Length["+testOrginal+"]");
				String testSub1=LotNoFrom.substring(0,testOrginal);
				System.out.println("SubString1::-["+testSub1+"]");
				int testSub=testSub1.length();
				System.out.println("SubString1 Length"+testSub);
				String testSub2=LotNoFrom.substring(s2.length()-cnt1);
				System.out.println("SubString2::-"+testSub2);
				sub=Integer.parseInt(testSub2);
				int u2=testSub2.length();
				int OrgSub=sub-1;
				String v1=String.valueOf(OrgSub);
				int v2=v1.length();
				System.out.println("V2:"+v2);
				int z=u2-v2;
				System.out.println("z:"+z);
				if(z!=0)
				{
					for(int s3=0;s3<z;s3++)
					{
						System.out.println("For loop if ");
						NewStr=NewStr.concat("0");
						System.out.println("@@@@@@@@@New String:::::::::::"+NewStr.length());
					}
				}
				int q=NewStr.length();
				String a2=Integer.toString(OrgSub);
				System.out.println("NewStr"+NewStr);
				LotNoFrom = testSub1.trim()+NewStr.trim()+a2 ;
				System.out.println("Final Lot Number From:"+LotNoFrom);

				int nextLot = OrgSub + 2;
				String newtLotFrom = testSub1.trim()+NewStr.trim()+nextLot ;
				System.out.println("Next New Lot From="+newtLotFrom);

				/**
				 * Inserting for Old lot_no__to
				 */
				sql = "SELECT * FROM ITEM_LOT_PACKSIZE WHERE ITEM_CODE = ? AND LOT_NO__FROM <= ? AND LOT_NO__TO >= ? ";
				pstmtSql = conn.prepareStatement(sql);
				pstmtSql.setString(1,itemCode);
				pstmtSql.setString(2,lotNo);	
				pstmtSql.setString(3,lotNo);	
				rs = pstmtSql.executeQuery();

				if(rs.next())
				{
					lotNoToOld = checkNullAndTrim(rs.getString("LOT_NO__TO"));
					LotNoFromUpd = checkNullAndTrim(rs.getString("LOT_NO__FROM"));
					unitPack = checkNullAndTrim(rs.getString("UNIT__PACK"));
					shipperSize = rs.getDouble("SHIPPER_SIZE");
					grossWeight = rs.getDouble("GROSS_WEIGHT");
					netWeight = rs.getDouble("NET_WEIGHT");
					shelfLife = checkNullAndTrim(rs.getString("SHELF_LIFE"));
					siteCodeMfg = checkNull(rs.getString("SITE_CODE__MFG"));
					siteCodeOwn = checkNull(rs.getString("SITE_CODE__OWN"));
					innerShipperSize = rs.getDouble("INNER_SHIPPER_SIZE");
					unitInnerLabel = checkNullAndTrim(rs.getString("UNIT__INNER_LABEL"));
					duplexSize = rs.getDouble("DUPLEX_SIZE");
					innerShipperGrWt = rs.getDouble("INNER_SHIPPER_GRWT");
					innerShipperNtWt = rs.getDouble("INNER_SHIPPER_NTWT");
					duplexNtWt = rs.getDouble("DUPLEX_NET_WT");
					duplexGrossWt = rs.getDouble("DUPLEX_GROSS_WT");
					shipperlength = rs.getDouble("LENGTH");
					width = rs.getDouble("WIDTH");
					height = rs.getDouble("HEIGHT");
					tranMode = checkNullAndTrim(rs.getString("TRAN_MODE"));
					udfStr1 = checkNullAndTrim(rs.getString("UDF_STR1"));

					sql = " INSERT INTO ITEM_LOT_PACKSIZE (ITEM_CODE,LOT_NO__FROM,LOT_NO__TO,UNIT__PACK,CHG_DATE,CHG_USER,CHG_TERM,SHIPPER_SIZE,GROSS_WEIGHT,"//9
						+" NET_WEIGHT,SHELF_LIFE,SITE_CODE__MFG,SITE_CODE__OWN,INNER_SHIPPER_SIZE,UNIT__INNER_LABEL,DUPLEX_SIZE,INNER_SHIPPER_GRWT,"//17
						+" INNER_SHIPPER_NTWT,DUPLEX_NET_WT,DUPLEX_GROSS_WT,LENGTH,WIDTH,HEIGHT,TRAN_MODE,UDF_STR1)"//25
						+" values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

					pstmtInsert = conn.prepareStatement(sql);
					pstmtInsert.setString(1,itemCode);
					pstmtInsert.setString(2,newtLotFrom); //New lot number incremented by 2 
					pstmtInsert.setString(3,lotNoToOld);  //Old Lot number	
					pstmtInsert.setString(4,unitPack);	
					pstmtInsert.setTimestamp(5,currDate);	
					pstmtInsert.setString(6,userId);	
					pstmtInsert.setString(7,chgTerm);
					pstmtInsert.setDouble(8,shipperSize);
					pstmtInsert.setDouble(9,grossWeight);
					pstmtInsert.setDouble(10,netWeight);
					pstmtInsert.setString(11,shelfLife);
					pstmtInsert.setString(12,siteCodeMfg);
					pstmtInsert.setString(13,siteCodeOwn);
					pstmtInsert.setDouble(14,innerShipperSize);
					pstmtInsert.setString(15,unitInnerLabel);
					pstmtInsert.setDouble(16,duplexSize);
					pstmtInsert.setDouble(17,innerShipperGrWt);
					pstmtInsert.setDouble(18,innerShipperNtWt);
					pstmtInsert.setDouble(19,duplexNtWt);
					pstmtInsert.setDouble(20,duplexGrossWt);
					pstmtInsert.setDouble(21,shipperlength);
					pstmtInsert.setDouble(22,width);
					pstmtInsert.setDouble(23,height);
					pstmtInsert.setString(24,tranMode);
					pstmtInsert.setString(25,udfStr1);

					updCnt = pstmtInsert.executeUpdate();
					System.out.println("Insert for Split="+updCnt);

					pstmtInsert.setString(2,lotNo); // New lot no entered by user
					pstmtInsert.setString(3,lotNo); // New lot no entered by user

					updCnt = pstmtInsert.executeUpdate();
					System.out.println("Insert for New Lot="+updCnt);

					if(pstmtInsert != null)
					{
						pstmtInsert.close();pstmtInsert = null;
					}
				}
				if(pstmtSql !=null)
				{
					pstmtSql.close();pstmtSql=null;
				}
				if(rs !=null)
				{
					rs.close();rs=null;
				}    

				/**
				 * Update for new splitted new lot_no
				 */

				//sql=" UPDATE ITEM_LOT_PACKSIZE SET LOT_NO__TO = ? WHERE ITEM_CODE = ? AND LOT_NO__FROM <= ? AND LOT_NO__TO >= ? ";
				sql=" UPDATE ITEM_LOT_PACKSIZE SET LOT_NO__TO = ? WHERE ITEM_CODE = ? AND LOT_NO__FROM = ? ";
				pstmtSql=conn.prepareStatement(sql);
				pstmtSql.setString(1,LotNoFrom);
				pstmtSql.setString(2,itemCode);
				pstmtSql.setString(3,LotNoFromUpd);
				//pstmtSql.setString(4, lotNo);

				updCnt = pstmtSql.executeUpdate();	
				System.out.println("No. of rows updated@@@@@@@@------>>"+updCnt);

				if(pstmtSql !=null)
				{
					pstmtSql.close();
					pstmtSql=null;
				}
			}
			else
			{	
				/**
				 * Inserting for new lot_no entered by user
				 */
				sql = " SELECT UNIT,PKG_SIZE,GROSS_WEIGHT,NET_WEIGHT,SHELF_LIFE,SITE_CODE__OWN,LENGTH,WIDTH,HEIGHT,UDF__STR1 "
					+ " FROM ITEM WHERE ITEM_CODE = ? ";
				pstmtSql = conn.prepareStatement(sql);
				pstmtSql.setString(1,itemCode);	
				rs = pstmtSql.executeQuery();

				if(rs.next())
				{
					unitPack = checkNullAndTrim(rs.getString("UNIT"));
					if(shipperSize == 0)
					{
						shipperSize = userShipperSize;
					}
					grossWeight = rs.getDouble("GROSS_WEIGHT");
					netWeight = rs.getDouble("NET_WEIGHT");
					shelfLife = checkNullAndTrim(rs.getString("SHELF_LIFE"));
					siteCodeOwn = checkNull(rs.getString("SITE_CODE__OWN"));
					shipperlength = rs.getDouble("LENGTH");
					width = rs.getDouble("WIDTH");
					height = rs.getDouble("HEIGHT");
					udfStr1 = checkNullAndTrim(rs.getString("UDF__STR1"));

					sql = " INSERT INTO ITEM_LOT_PACKSIZE (ITEM_CODE,LOT_NO__FROM,LOT_NO__TO,UNIT__PACK,CHG_DATE,CHG_USER,CHG_TERM," +//7
					" SHIPPER_SIZE,SITE_CODE__OWN,UNIT__INNER_LABEL,SHELF_LIFE,GROSS_WEIGHT,NET_WEIGHT,LENGTH,WIDTH,HEIGHT)" //16
					+ " VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
					pstmtInsert = conn.prepareStatement(sql);

					pstmtInsert.setString(1, itemCode);
					pstmtInsert.setString(2, lotNo);
					pstmtInsert.setString(3, lotNo);
					pstmtInsert.setString(4, unitPack);
					pstmtInsert.setTimestamp(5, currDate);
					pstmtInsert.setString(6, userId);
					pstmtInsert.setString(7, chgTerm);
					pstmtInsert.setDouble(8, shipperSize);
					pstmtInsert.setString(9, siteCodeOwn);
					pstmtInsert.setString(10, unitPack);
					pstmtInsert.setString(11, shelfLife);
					pstmtInsert.setDouble(12, grossWeight);
					pstmtInsert.setDouble(13, netWeight);
					pstmtInsert.setDouble(14, shipperlength);
					pstmtInsert.setDouble(15, width);
					pstmtInsert.setDouble(16, height);

					updCnt = pstmtInsert.executeUpdate();
					System.out.println("@@Insert for New Lot="+updCnt);

					if(pstmtInsert != null)
					{
						pstmtInsert.close();pstmtInsert = null;
					}
				}
				if(pstmtSql !=null)
				{
					pstmtSql.close();pstmtSql=null;
				}
				if(rs !=null)
				{
					rs.close();rs=null;
				}
			}	
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
				if(pstmtSql !=null)
				{
					pstmtSql.close();pstmtSql=null;
				}
				if(pstmtInsert != null)
				{
					pstmtInsert.close();pstmtInsert = null;
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return shipperSize;
	}

	private int findNosOfPallet(String itemCode, String lotNo, double quantity ,double perPalletVolume , double perPalletWeight,Connection conn)  throws RemoteException,ITMException
	{
		int findNosOfPallet=0;
		int nosOfPalletPerVolume=0;
		int nosOfPalletPerWeight=0;
		int perPalletArticle=0;
		int perPalletArticleVolume=0;
		int perPalletArticleWeight=0;

		String sql="";
		PreparedStatement pstmt = null;
		ResultSet rs =null;
		double shipperSize =0.0;
		double grossWeight =0.0;
		double netWeight =0.0;
		double length=0.0;
		double width=0.0;
		double height=0.0;
		Double nosOfPallet=0.0;
		double nosOfPalletTemp=0.0;
		int totCaseCount =0;
		double quantityIntoShippersizeDouble=0.0;

		sql="select shipper_size, gross_weight, net_weight, length, width ,height from item_lot_packsize WHERE ITEM_CODE = ? AND LOT_NO__FROM <= ? AND LOT_NO__TO >= ? ";
		try {
			pstmt =conn.prepareStatement(sql);
			pstmt.setString(1,itemCode);
			System.out.println("lotNo="+lotNo);
			if(lotNo != null && lotNo.trim().length() > 0)
			{
				System.out.println("lotNo is not null ");		
				pstmt.setString(2,lotNo);
				pstmt.setString(3,lotNo);
			}
			else
			{
				System.out.println("lotNo is null ");			
				pstmt.setString(2,"00");
				pstmt.setString(3,"ZZ");
				return 0;
			}
			rs=pstmt.executeQuery();
			if(rs.next())
			{
				shipperSize=rs.getDouble(1);
				grossWeight =rs.getDouble(2);
				netWeight=rs.getDouble(3);
				length=rs.getDouble(4);
				width=rs.getDouble(5);
				height=rs.getDouble(6);
			}
			rs.close();
			pstmt.close();
			rs=null;
			pstmt =null;
			System.out.println("shipperSize="+shipperSize);
			System.out.println("grossWeight="+grossWeight);
			System.out.println("quantity="+quantity);

			totCaseCount = (int)(quantity / shipperSize);

			quantityIntoShippersizeDouble = (quantity % shipperSize);

			if(quantityIntoShippersizeDouble > 0)
			{
				totCaseCount++;
			}
			perPalletArticleWeight= (int)(((int)(((int)( (int)(perPalletWeight*shipperSize)/grossWeight))/shipperSize))*shipperSize);
			System.out.println("perPalletArticleWeight="+perPalletArticleWeight);

			nosOfPallet=(quantity/perPalletArticleWeight);

			System.out.println("nosOfPallet="+nosOfPallet);

			nosOfPalletPerWeight=(new Double((Math.floor(nosOfPallet)))).intValue();
			nosOfPalletTemp=nosOfPalletPerWeight;

			System.out.println("quantity % perPalletArticleWeight" +quantity % perPalletArticleWeight);

			if(nosOfPallet!=nosOfPalletTemp)
			{
				nosOfPalletPerWeight=nosOfPalletPerWeight+1;

				if(quantity < perPalletArticleWeight)
				{
					System.out.println("CHECK BY PRAGYAN1 WEIGHT[" +(quantity%shipperSize) + "]");
					if(!(quantity < shipperSize) && (quantity%shipperSize) > 0)
					{
						nosOfPalletPerWeight=nosOfPalletPerWeight+1;
					}
				}

				if(quantity > perPalletArticleWeight)
				{
					double tempQty = quantity - (perPalletArticleWeight * nosOfPalletTemp);
					System.out.println("CHECK BY PRAGYAN1tempQty WEIGHT[" +tempQty + "]nosOfPalletTemp["+nosOfPalletTemp);
					if(tempQty > 0 && !(tempQty < shipperSize) && (tempQty%shipperSize) > 0)
					{
						nosOfPalletPerWeight=nosOfPalletPerWeight+1;
					}
				}

			}
			System.out.println("<nosOfPalletPerWeight after floor [" +nosOfPalletPerWeight + "]");

			perPalletArticleVolume= (int)(((int)(((int)(perPalletVolume*shipperSize/ (length*width*height) ) )/shipperSize))*shipperSize) ;

			System.out.println("perPalletArticleVolume="+perPalletArticleVolume);

			nosOfPallet=(quantity/perPalletArticleVolume);

			System.out.println("nosOfPallet="+nosOfPallet);

			nosOfPalletPerVolume = (new Double((Math.floor(nosOfPallet)))).intValue();
			nosOfPalletTemp = nosOfPalletPerVolume;
			System.out.println("(quantity % perPalletArticleVolume)" +(quantity % perPalletArticleVolume));
			if(nosOfPallet!= nosOfPalletTemp)
			{
				nosOfPalletPerVolume = nosOfPalletPerVolume + 1;

				if(quantity < perPalletArticleVolume)
				{
					System.out.println("CHECK BY PRAGYAN1 [" +(quantity%shipperSize) + "]");
					if(!(quantity < shipperSize) && (quantity%shipperSize) > 0)
					{
						nosOfPalletPerVolume = nosOfPalletPerVolume + 1;
					}
				}

				if(quantity > perPalletArticleVolume)
				{
					double tempQty = quantity - (perPalletArticleVolume * nosOfPalletTemp);
					System.out.println("CHECK BY PRAGYAN1tempQty [" +tempQty + "]nosOfPalletTemp["+nosOfPalletTemp);
					if(tempQty > 0 && !(tempQty < shipperSize) && (tempQty%shipperSize) > 0)
					{
						nosOfPalletPerVolume = nosOfPalletPerVolume + 1;
					}
				}
			}
			System.out.println("nosOfPalletPerVolume AFTER FLOR [" +nosOfPalletPerVolume + "]");
			if(nosOfPalletPerWeight > nosOfPalletPerVolume )
			{
				findNosOfPallet = nosOfPalletPerWeight;
			}
			else
			{
				findNosOfPallet = nosOfPalletPerVolume;
			}
			System.out.println("<!@#>findNosOfPallet" +findNosOfPallet);
		} catch (SQLException e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
			}
		}
		return findNosOfPallet; 
	}

	public double getItemGrossWeight(String itemCode,String lotNo,Connection conn) throws ITMException
	{
		double grossWeight = 0;
		String sql = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;

		try
		{	
			sql = " SELECT L.GROSS_WEIGHT FROM ITEM_LOT_PACKSIZE L,ITEM I "
				+ " WHERE I.ITEM_CODE = L.ITEM_CODE AND L.ITEM_CODE = ? AND L.LOT_NO__FROM <= ? AND L.LOT_NO__TO >= ? ";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1,itemCode);
			pstmt.setString(2,lotNo);
			pstmt.setString(3,lotNo);

			rs = pstmt.executeQuery();
			if(rs.next())
			{
				grossWeight = rs.getDouble("GROSS_WEIGHT");
			}
			if(rs != null)
			{
				rs.close();rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();pstmt = null;
			}
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex);
		}		
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}		
		return grossWeight;
	}

	private static boolean isNumber(Character character) 
	{
		boolean flag= false;
		try
		{
			double num = Double.parseDouble(""+character);
			flag =  true;
			return flag;
		}
		catch( Exception e)
		{
			return flag;
		}
	}
	//
	public String getPoDetails(String obj)
	{
		System.out.println("Inside EJB getPoDetails");
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";

		String purcOrder = "";
		String contractNo = "";
		String suppCode = "";
		String suppName = "";
		String itemCode = "";
		String quantity = "";
		String tranId = "";
		Date mfgDate = null;
		Date expDate = null;
		Date asnDate = null;
		String mfgDateStr = "";
		String expDateStr = "";
		String asnDateStr = "";
		String mfgSite = "";
		String packSize = "";


		StringBuffer details = new StringBuffer("<root>"); 
		details.append("<finish>");
		try
		{
			//Added & replace by sarita on 27DEC2017 for Connection
			/*ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");*/
			conn = getConnection();
			System.out.println("ASN No=======["+asnNo+"]");
			sql = "SELECT TRAN_ID,PURC_ORDER,CONTRACT_NO,SUPP_CODE,ASN_DATE FROM ASN_HDR WHERE ASN_NO = ?";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1,asnNo);			
			rs = pstmt.executeQuery();

			while(rs.next())
			{
				tranId = checkNullAndTrim(rs.getString("TRAN_ID"));
				purcOrder = checkNullAndTrim(rs.getString("PURC_ORDER"));
				contractNo = checkNullAndTrim(rs.getString("CONTRACT_NO"));
				suppCode  = checkNullAndTrim(rs.getString("SUPP_CODE"));
				asnDate  = rs.getDate("ASN_DATE");
			}		

			rs.close();rs = null;
			pstmt.close();pstmt = null;

			sql = "SELECT SUPP_NAME FROM SUPPLIER WHERE SUPP_CODE = ?";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1,suppCode);			
			rs = pstmt.executeQuery();

			while(rs.next())
			{
				suppName = checkNullAndTrim(rs.getString("SUPP_NAME"));
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
			if(contractNo != null && contractNo.trim().length() > 0)
			{
				details.append("<contract_no><![CDATA[").append(contractNo).append("]]></contract_no>\r\n");
			}
			else
			{
				details.append("<purc_order><![CDATA[").append(purcOrder).append("]]></purc_order>\r\n");
			}
			details.append("<asn_no><![CDATA[").append(asnNo).append("]]></asn_no>\r\n");
			details.append("<supp_code><![CDATA[").append(suppCode).append("]]></supp_code>\r\n");
			details.append("<supp_name><![CDATA[").append(suppName).append("]]></supp_name>\r\n");
			asnDateStr = new SimpleDateFormat(genericUtility.getApplDateFormat()).format(asnDate);
			details.append("<ship_date><![CDATA[").append(asnDateStr).append("]]></ship_date>\r\n");

			details.append("</finish>");

			sql = "SELECT ITEM_CODE,QUANTITY,MFG_DATE,EXP_DATE,SITE_CODE__MFG,PACK_SIZE FROM ASN_DET WHERE TRAN_ID = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			int domID = 0;

			while(rs.next())
			{
				itemCode  = checkNullAndTrim(rs.getString("ITEM_CODE"));
				quantity  = checkNullAndTrim(rs.getString("QUANTITY"));
				mfgDate  = rs.getDate("MFG_DATE");
				expDate  = rs.getDate("EXP_DATE");
				mfgSite  = checkNull(rs.getString("SITE_CODE__MFG"));
				packSize  = checkNullAndTrim(rs.getString("PACK_SIZE"));

				mfgDateStr = new SimpleDateFormat(genericUtility.getApplDateFormat()).format(mfgDate);
				expDateStr = new SimpleDateFormat(genericUtility.getApplDateFormat()).format(expDate);				
				System.out.println("===mfgDateStr==["+mfgDateStr+"] expDateStr====["+expDateStr+"] mfgSite=====["+mfgSite+"]");

				domID++;

				details.append("<extra>");
				details.append("<item_code><![CDATA[").append(itemCode).append("]]></item_code>\r\n");
				details.append("<quantity><![CDATA[").append(quantity).append("]]></quantity>\r\n");
				details.append("<mfg_date><![CDATA[").append(mfgDateStr).append("]]></mfg_date>\r\n");
				details.append("<exp_date><![CDATA[").append(expDateStr).append("]]></exp_date>\r\n");
				details.append("<site_code__mfg><![CDATA[").append(mfgSite).append("]]></site_code__mfg>\r\n");
				details.append("<pack_size><![CDATA[").append(packSize).append("]]></pack_size>\r\n");

				details.append("</extra>");	

			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
			details.append("</root>");
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				asnNo = "";
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}	
		return details.toString();
	}
	private String generateTranId( String windowName,String siteCode,String siteCodeLog, Connection conn )throws ITMException
    {
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String selSql = "";
		String tranId = "";
		String tranSer = "";
		String keyString = "";
		String keyCol = "";
		String xmlValues = "";
		java.sql.Timestamp currDate = null;
		ibase.utility.E12GenericUtility genericUtility= new  ibase.utility.E12GenericUtility();
		try
	    {

			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());

			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			String currDateStr = sdfAppl.format(currDate);

			selSql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
			pstmt = conn.prepareStatement(selSql);
			pstmt.setString( 1, windowName );
			rs = pstmt.executeQuery();
			if (rs.next())
			{
					keyString = rs.getString("KEY_STRING");
					keyCol = rs.getString("TRAN_ID_COL");
					tranSer = rs.getString("REF_SER");
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
			System.out.println("keyString :"+keyString);
			System.out.println("keyCol :"+keyCol);
			System.out.println("tranSer :"+tranSer);

			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +        "<tran_id></tran_id>";
			xmlValues = xmlValues +        "<site_code>" + siteCode + "</site_code>";
			xmlValues = xmlValues +        "<tran_date>" + currDateStr + "</tran_date>";
			xmlValues = xmlValues +        "<site_code__log>" + siteCodeLog + "</site_code__log>";
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			System.out.println("tranId :"+tranId);
         }
		catch (SQLException ex)
		{
			System.out.println("Exception ::" +selSql+ ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
						rs.close();
						rs = null;
				}
				if (pstmt != null)
				{
						pstmt.close();
						pstmt = null;
				}
			}
			catch(Exception e){}
		}
		 System.out.println("@@@@@@@@@@@@@@@@@@@@@@tranId[[[[[[[[[[["+tranId+"]]]]]]]]]]]]]]]");
        return tranId;
     }
}
