/* 
Window Name : w_srv_order
Button Name : Close
Action      : Puchase Order or the transaction will be Closed 
              i.e it will Update the STATUS FIELD of SRV_ORDER Table. 
*/
package ibase.webitm.ejb.fin.adv;

import java.rmi.RemoteException;
import java.sql.*;
import javax.ejb.*;

import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.*;
//import ibase.webitm.utility.GenericUtility;
import ibase.system.config.*;
import java.text.SimpleDateFormat;
import javax.ejb.Stateless; // added for ejb3

@Stateless // added for ejb3

public class SrvOrderClose extends ActionHandlerEJB implements SrvOrderCloseLocal,SrvOrderCloseRemote //SessionBean
{
	/*public void ejbCreate() throws RemoteException, CreateException 
	{
	}

	public void ejbRemove()
	{
	}

	public void ejbActivate() 
	{
	}

	public void ejbPassivate() 
	{
	}*/

    public String actionHandler() throws RemoteException,ITMException
	{
		return "";
	}

	public String actionHandler(String tranID, String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{
		String  retString = null;
		try
		{
			retString = actionClose(tranID,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception :SrvOrderEJB :actionHandler:" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("returning from SrvOrderEJB actionHandler"+retString);
		return retString;
	}

	private String actionClose(String tranID,  String xtraParams)throws ITMException
	{
		Connection conn = null;
		Statement stmt = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String errCode = "";
		String errString = "";
		String upd = "";
		String format = "";
		String status = "";
		int rows = 0;
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
//		GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new E12GenericUtility();
		ConnDriver connDriver = new ConnDriver(); 
		try
		{	
			format= genericUtility.getApplDateFormat();
			java.text.SimpleDateFormat dtf= new SimpleDateFormat(format);
		   	//Changes and Commented By Bhushan on 06-06-2016 :START
//conn = connDriver.getConnectDB("DriverITM");
conn = getConnection();
//Changes and Commented By Bhushan on 06-06-2016 :END
			sql="SELECT STATUS FROM SRV_ORDER WHERE TRAN_ID = '"+tranID+"'";
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
			if(rs.next())
			{
				status = rs.getString("status");
				System.out.println("status :: "+status+":");
			}
			if(status != null && status.trim().length()>0)
			{
				if (status.equalsIgnoreCase("C"))
				{
					errCode = "VTCLOSE1";
				}
				else if(status.equalsIgnoreCase("X"))
				{
					errCode="VTSORD4";
				}
				else
				{
					System.out.println("Updating Status For Transaction ID :: "+tranID);
					upd = "UPDATE SRV_ORDER SET STATUS = 'X',STATUS_DATE = ? WHERE TRAN_ID = ?";
					pstmt = conn.prepareStatement(upd);
					pstmt.setDate(1,new java.sql.Date(System.currentTimeMillis()));
					pstmt.setString(2,tranID);
					rows = pstmt.executeUpdate();
					System.out.println("Rows Updated ::"+rows);					
				}
				if(rows > 0)
				{
					conn.commit();
					System.out.println("\n <==== Transaction Updated Successfully ====>");
					errCode = "VTCLOSED";
				}
			}
			else
			{
				 errCode = "VTNULSTAT";
			}
			if (errCode != null  && errCode.trim().length() > 0)
			{
				System.out.println("SrvOrderEJB:errCode:"+errCode);
				errString = itmDBAccessEJB.getErrorString("", errCode, "", "", conn);
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception :SrvOrderEJB :" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
	 	}
		finally
		{
			try
			{
				System.out.println("Connection Closed......");
				conn.close();
				conn = null;
			}catch(Exception e){}
		}
		return errString;
	}
}