 /* 
	Window Name : w_misc_voucher
    Button Name : Hold
	Action      : Put Voucher on hold i.e it will update MISC_PAYABLES Table.
*/
package ibase.webitm.ejb.fin.adv;

import java.rmi.RemoteException;
import java.sql.*;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.Period;
import java.util.Calendar;

import javax.ejb.*;

import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.*;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.ejb.sys.UtilMethods;
import ibase.system.config.*;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;

import javax.ejb.Stateless; // added for ejb3
import javax.naming.InitialContext;

import org.w3c.dom.Document;

@Stateless // added for ejb3

public class MiscVoucherHld extends ActionHandlerEJB implements MiscVoucherHldLocal,MiscVoucherHldRemote //SessionBean
{
	/*public void ejbCreate() throws RemoteException, CreateException 
	{
	}

	public void ejbRemove()
	{
	}

	public void ejbActivate() 
	{
	}

	public void ejbPassivate() 
	{
	}*/

	public String actionHandler() throws RemoteException,ITMException
	{
		return "";
	}

	public String actionHandler(String tranID, String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{
		System.out.println("MiscVoucherHldEJB:actionHandler called");
		String  retString = null;
		try
		{
			System.out.println("Transaction ID To Hold :: "+tranID);
			retString = actionHold(tranID,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception :MiscVoucherHldEJB :actionHandler:" + e.getMessage() + ":");
			throw new ITMException(e);
		}
		System.out.println("returning from MiscVoucherHldEJB actionHandler"+retString);
		return retString;
	}
	public String actionHandler(String actionType, String xmlString, String objContext, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		String  resString = null;
		try
		{
			E12GenericUtility genericUtility = new E12GenericUtility();
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				System.out.println("xmlString :: "+xmlString);
				dom = genericUtility.parseString(xmlString); 
			}
			if (actionType.equalsIgnoreCase("VouchPay"))
			{
				resString = actionPay(dom,objContext,xtraParams);
			}
		}
	   	catch(Exception e)
		{
			System.out.println("Exception :MiscVoucher :actionHandler(String xmlString):" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("returning from actionVoucher actionHandler"+resString);
	    return resString;
	}


	private String actionHold(String tranID,  String xtraParams)throws ITMException
	{
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		String errCode="";
		String errString="";
		String sql = "";
		String updSql = "";
		String confirmed = null;
		int rows=0;
		float totAmt=0;
		float adjAmt=0;
		float holdAmt=0;
		float balAmt=0;
		ConnDriver connDriver = new ConnDriver();
		try
		{	
			//Changes and Commented By Bhushan on 06-06-2016 :START
//conn = connDriver.getConnectDB("DriverITM");
conn = getConnection();
//Changes and Commented By Bhushan on 06-06-2016 :END
			ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
			stmt = conn.createStatement();
			sql="SELECT CASE WHEN CONFIRMED IS NULL THEN 'N' ELSE CONFIRMED END CONF FROM MISC_VOUCHER WHERE TRAN_ID = '"+tranID+"'";
			rs = stmt.executeQuery(sql);
			if(rs.next())
			{
				confirmed = rs.getString("CONF");
			}
			if (confirmed.equalsIgnoreCase("Y"))
			{								   
				sql="SELECT TOT_AMT, ADJ_AMT,CASE WHEN HOLD_AMT IS NULL THEN 0 ELSE HOLD_AMT END HOLD_AMT FROM MISC_PAYABLES WHERE TRAN_SER = 'M-VOUC' AND REF_NO = '"+tranID+"'";
				rs = stmt.executeQuery(sql);
				if(rs.next())
				{
					totAmt=rs.getFloat("TOT_AMT");
					adjAmt=rs.getFloat("ADJ_AMT");
					holdAmt=rs.getFloat("HOLD_AMT");
				}
				balAmt = totAmt-adjAmt;
				if(balAmt == 0)
				{
					errCode = "VTBAL2";  // already paid off
				}
				//else if(adjAmt != 0 && adjAmt != totAmt)
				//{
				//	errCode = "VTBAL2"; // partly paid off
				//}
				else if (holdAmt == 0) 
				{
					//Put Voucher on hold
					//updSql = "UPDATE MISC_PAYABLES SET HOLD_AMT = TOT_AMT WHERE TRAN_SER = 'M-VOUC' AND REF_NO = '"+tranID+"'";
					updSql = "UPDATE MISC_PAYABLES SET HOLD_AMT = TOT_AMT - ADJ_AMT WHERE TRAN_SER = 'M-VOUC' AND REF_NO = '"+tranID+"'";
					System.out.println("Updating SQL :: "+updSql);
					rows=stmt.executeUpdate(updSql);					
				}
				else
				{
					errCode="VTHOLD3";
				}
			}//end if confirmed "Y"
			else
			{
				errCode="UNCONTRAN";	//if Transaction Not confirmed
			}
			if(errCode.trim().length() == 0 && rows > 0)
			{
				errCode = "VTHOLD2";
				conn.commit();
				System.out.println("\n <==== Transaction Updated Successfully ====>");

			} 
			if (errCode != null  && errCode.trim().length() > 0)
			{
				System.out.println("MiscVoucherHldEJB:errCode:"+errCode);
				//errString = itmDBAccessEJB.getErrorString("", errCode, "", "", conn);//Gulzar 30-12-06		
				errString = itmDBAccessEJB.getErrorString("", errCode, "");//Gulzar 30-12-06					
			}
			
		}
		catch(Exception e)
		{
			System.out.println("Exception :MiscVoucherHldEJB :" + e.getMessage() + ":");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("Connection Closing......");
				conn.close();
				conn = null;
			}
			catch(Exception e){}
		}
		return errString;
	}
	private String actionPay(Document dom, String objContext, String xtraParams) throws RemoteException , ITMException
	{
		System.out.println("---ActionHandler---@@@@@@@@xtraParams["+xtraParams+"]");
		Connection conn = null;
		PreparedStatement pstmt = null, pstmt1 = null, pstmt2 = null;
		ResultSet rs = null, rs1 = null, rs2 = null;
		String retString = "",errString="";
		String conf="",errCode="",payMode="",refNo="";
		int refCount=0;
		ITMDBAccessEJB itmDBAccessEJB=new ITMDBAccessEJB();
		
		

		
	    String tranType = "",loginUser = "",tranID = "",insertSql = "",remarks = "";
	    String termID = "",currCodeBc = "",exchRateBc = "",filtBankCodeAdd = "",filtBankCodeAddName = "";
	    String acctCodeBal = "",cctrCodeBal = "",acctCodeBc = "",cctrCodeBc = "",acctCodeCf = "";
	    String acctCodeCfAp = "",cctrCodeCfAp = "",cctrCodeCf = "",updateSql = "",exchRateHdr = "";
	    SimpleDateFormat sdf = null;
	    ConnDriver connDriver = new ConnDriver();
	    FinCommon finCommon = new FinCommon();
	    
	    Timestamp tranDate=null,billDate=null,dueDate=null,refDate=null,effDate=null,ldDiscountDt=null,ldStartDate=null;
	    String billNo="",currCode="",acctCode="",cctrCode="",siteCode="",finEntity="",sundryType="",bankCode="",userName="",sundryCode="",tranSer="",
			  purcOrder="",pCrTerm="",acctCodeDisc="",cctrCodeDisc="",startFrom="",tranId="";
	    double exchRate=0.0d,totAmt=0.0d,advAmt=0.0d,holdAmt=0.0d,netPayable=0.0d,adjAmt=0.0d,lcDiscount=0.0d,lcDiscountAmt=0.0d,payAmt=0.0d,totAmount=0.0d;
	    E12GenericUtility genericUtility = new E12GenericUtility();
	    try
		{
			 //Changes and Commented By Bhushan on 06-06-2016 :START
	    	//conn = connDriver.getConnectDB("DriverITM");
	    	conn = getConnection();
	    	//Changes and Commented By Bhushan on 06-06-2016 :END
	        //conn.setAutoCommit(false);
	    	
	        System.out.println("xtraParams : "+xtraParams);
			
	        
	        tranId=genericUtility.getColumnValue("tran_id", dom);
			System.out.println("TranID["+tranId+"]");
			
			String sql="Select confirmed,pay_mode from misc_voucher where tran_id= ?";
			pstmt=conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			if(rs.next())
			{
				conf=rs.getString(1);
				payMode=rs.getString(2);
				
			}
			pstmt.close();
			pstmt=null;
			rs.close();
			rs=null;
			
			
			sql="select count(1) from misc_payment where ref_no= ?";
			pstmt=conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			if(rs.next())
			{
				refCount=rs.getInt(1);
				
			}
			pstmt.close();
			pstmt=null;
			rs.close();
			rs=null;
			
			System.out.println("conf["+conf+"] paymode["+payMode+"] refNo ["+refNo+"] refCount["+refCount+"]");
			
			//validation if not confirmed
			if(!conf.equalsIgnoreCase("Y"))
			{
				errCode="VTELMNCNF2";
				errString = itmDBAccessEJB.getErrorString("", errCode, "");
				return errString;
			}
			//validation if payment already present
			else if(refCount>0)
			{
				errCode="VTPAYEXIST";
				errString = itmDBAccessEJB.getErrorString("", errCode, "");
				return errString;
			}
			//validation if paymode is not Cash
			else if(!payMode.equalsIgnoreCase("C"))
			{
				errCode="VTINMODE";
				errString = itmDBAccessEJB.getErrorString("", errCode, "");
				return errString;
				
			}
	        
	        loginUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
	        termID = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
	        tranType = finCommon.getFinparams("999999","TRAN_TYPE_AUTO_PAY",conn);
	        sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
	        if(tranType.equalsIgnoreCase("NULLFOUND"))  
	        tranType = "O";
	        
	        
	        
	        //getting data from misc_payables
	        sql="SELECT MISC_PAYABLES.REF_NO,MISC_PAYABLES.TRAN_DATE,MISC_PAYABLES.REF_DATE,MISC_PAYABLES.BILL_NO,"
	        		+ "MISC_PAYABLES.BILL_DATE,MISC_PAYABLES.CURR_CODE,MISC_PAYABLES.EXCH_RATE,MISC_PAYABLES.SUNDRY_CODE,"
	        		+ "MISC_PAYABLES.ACCT_CODE,MISC_PAYABLES.CCTR_CODE,MISC_PAYABLES.DUE_DATE,MISC_PAYABLES.SITE_CODE,"
	        		+ "MISC_PAYABLES.FIN_ENTITY,MISC_PAYABLES.TOT_AMT,MISC_PAYABLES.SUNDRY_TYPE,MISC_PAYABLES.BANK_CODE,"
	        		+ "CASE WHEN MISC_PAYABLES.PAY_MODE IS NULL THEN '' ELSE MISC_PAYABLES.PAY_MODE END as PAY_MODE,MISC_PAYABLES.ADV_AMT,MISC_PAYABLES.TRAN_ID,MISC_PAYABLES.TRAN_SER,MISC_PAYABLES.ADJ_AMT,"
	        		+ "MISC_PAYABLES.HOLD_AMT, fn_confirmed_by(misc_payables.tran_ser, misc_payables.ref_no) as username,"
	        		+ "misc_payables.tot_amt - (case when misc_payables.adj_amt is null then 0 else misc_payables.adj_amt end) - (case when misc_payables.hold_amt is null then 0 else misc_payables.hold_amt end) as net_payable"
	        		+ "FROM MISC_PAYABLES  WHERE"
	        		//+ "( misc_payables.sundry_type like '' ) AND"
	        		//+ "( misc_payables.sundry_code like '' ) AND"
	        		+ "( misc_payables.ref_no = ? )"
	        		//+ "(misc_payables.pay_mode like 'C') AND"
	        		//+ "misc_payables.entry_batch_no like '  '"
	        		+ "ORDER BY MISC_PAYABLES.SUNDRY_TYPE ASC,"
	        		+ "MISC_PAYABLES.SUNDRY_CODE ASC,"
	        		+ "MISC_PAYABLES.REF_NO ASC ";
			pstmt=conn.prepareStatement(sql);
			pstmt.setString(1,tranId );
			
			if(rs.next())
			{
				refNo=rs.getString("ref_no");
				tranDate=rs.getTimestamp("tran_date"); 
				refDate=rs.getTimestamp("ref_date");
				billNo=rs.getString("bill_no");          
				billDate=rs.getTimestamp("bill_date");
				currCode=rs.getString("curr_code");          
				exchRate=rs.getDouble("exch_rate");     
				acctCode=rs.getString("ACCT_CODE");
				cctrCode=rs.getString("CCTR_CODE");
				dueDate=rs.getTimestamp("DUE_DATE");
				siteCode=rs.getString("SITE_CODE");
				finEntity=rs.getString("FIN_ENTITY");
				sundryType=rs.getString("SUNDRY_TYPE");
				totAmt=rs.getDouble("TOT_AMT");
				bankCode=rs.getString("BANK_CODE");
				payMode=rs.getString("PAY_MODE");
				advAmt=rs.getDouble("ADV_AMT");
				tranId=rs.getString("TRAN_ID");
				adjAmt=rs.getDouble("ADJ_AMT");
				holdAmt=rs.getDouble("HOLD_AMT");
				userName=rs.getString("username");
				netPayable=rs.getDouble("NET_PAYABLE");
				sundryCode=rs.getString("sundry_code");   
				tranSer=rs.getString("tran_ser");	
				payAmt=rs.getDouble("pay_amt");
			}
			pstmt.close();
			pstmt=null;
			rs.close();
			rs=null;
			
			
			
			  			Timestamp today = new java.sql.Timestamp(System.currentTimeMillis());
			  			sdf = new java.text.SimpleDateFormat(genericUtility.getApplDateFormat());
		   
		     			remarks = "Automatic Payment";
	            
	            		//bank details	                    
	                    sql = "select acct_code__bal, cctr_code__bal, acct_code__bc, cctr_code__bc,acct_code__cf, "+
	    	        	"acct_code__cf_ap, cctr_code__cf, cctr_code__cf_ap from bank where bank_code = '"+bankCode+"'";
	    		        System.out.println("SQL : "+sql);
	    		        pstmt = conn.prepareStatement(sql);
	    		        rs = pstmt.executeQuery();
	    		        if(rs.next())
	    		        {
	    		            acctCodeBal = rs.getString("acct_code__bal");
	    		            cctrCodeBal = rs.getString("cctr_code__bal");
	    		            acctCodeBc = rs.getString("acct_code__bc");
	    		            cctrCodeBc = rs.getString("cctr_code__bc");
	    		            acctCodeCf = rs.getString("acct_code__cf");
	    		            acctCodeCfAp = rs.getString("acct_code__cf_ap");
	    		            cctrCodeCf = rs.getString("cctr_code__cf");
	    		            cctrCodeCfAp = rs.getString("cctr_code__cf_ap");
	    		        }
	    		        if(acctCodeCfAp == null || acctCodeCfAp.length() == 0)
	    		        {
	    		            acctCodeCfAp = acctCodeCf;
	    		        }
	    		        if(cctrCodeCfAp == null || cctrCodeCfAp.length() == 0)
	    		        {
	    		            cctrCodeCfAp = cctrCodeCf;
	    		        }
	    		        pstmt.close();
	    		        rs.close();
		    		    
	    		        //calculating discount
	    		        sql="select purc_order,eff_date,bill_date from voucher where tran_id = ?";
	    		        pstmt = conn.prepareStatement(sql);
	    		        pstmt.setString(1,refNo );
	    		        rs = pstmt.executeQuery();
	    		        if(rs.next())
	    		        {
	    		        	purcOrder=rs.getString("purc_order");
	    		        	effDate=rs.getTimestamp("eff_date");
	    		        }
	    		        pstmt.close();
	    		        rs.close();
	    		        
	    		        sql="select cr_term from porder where purc_order = ?";
	    		        pstmt = conn.prepareStatement(sql);
	    		        pstmt.setString(1,purcOrder );
	    		        rs = pstmt.executeQuery();
	    		        if(rs.next())
	    		        {
	    		        	pCrTerm=rs.getString("cr_term");
	    		        }
	    		        pstmt.close();
	    		        rs.close();
	    		        
	    		        
	    		        sql="select crtermfc.fin_chg,crterm.acct_code__disc,crterm.cctr_code__disc,crterm.start_from "
	    		        	+ "from crterm,crtermfc "
	    		        	+ "where crtermfc.cr_term = crterm.cr_term and crterm.cr_term = ? and trim(crtermfc.line_no) = '1'";		
	    		        pstmt = conn.prepareStatement(sql);
	    		        pstmt.setString(1,purcOrder );
	    		        rs = pstmt.executeQuery();
	    		        if(rs.next())
	    		        {
	    		        	lcDiscount=rs.getDouble("fin_chg");
	    		        	acctCodeDisc=rs.getString("acct_code__disc");
	    		        	cctrCodeDisc=rs.getString("cctr_code__disc");
	    		        	startFrom=rs.getString("start_from");
	    		        }
	    		        pstmt.close();
	    		        rs.close();
	    		        
	    		        ldDiscountDt =calcDiscountDate(pCrTerm,sdf.format(refDate),sdf.format(effDate),sdf.format(billDate),conn);

	    		        int liDateDiff=dayDiff(ldDiscountDt,today);
	    		        
	    		        sql = "select fin_chg from crtermfc where ? between min_day and max_day and cr_term = ? and trim(line_no) = '1'";				             
		                pstmt = conn.prepareStatement(sql);
		                pstmt.setInt(1, liDateDiff);
		                pstmt.setString(2, pCrTerm);
		                rs = pstmt.executeQuery();
		                
		                if(rs.next())
		                {
		                    lcDiscount=rs.getDouble(1);
		                }
		                pstmt.close();
	    		        rs.close();
	    		        
	    		        
	    		        if(startFrom.equalsIgnoreCase("R"))
	    		        {
	    		        	ldStartDate=refDate;
	    		        }
	    		        else if(startFrom.equalsIgnoreCase("D") || startFrom.equalsIgnoreCase("Q"))
	    		        {
	    		        	ldStartDate=effDate;
	    		        }
	    		        else if(startFrom.equalsIgnoreCase("B"))
	    		        {
	    		        	ldStartDate=billDate;
	    		        }
	    		        
	    		        if((today.after(ldStartDate) || today.equals(ldStartDate)) && (today.before(ldDiscountDt) || today.equals(ldDiscountDt)))
	    		        {
	    		        	lcDiscountAmt=(payAmt*lcDiscount)/100;
	    		        	
	    		        }
	    		        //calculating total amount 
	    		        totAmount = payAmt - lcDiscountAmt;
		                System.out.println("Pay Amt : "+payAmt + "Total Amt : "+totAmt);
	    		        
	    		        //09062007 (set currCode bc with Curr Code
	    		        currCodeBc = currCode;
		                
		                
		                StringBuffer xmlBuff = new StringBuffer();

		    			xmlBuff.append("<?xml version='1.0' encoding='ISO-8859-1'?>\n");
		    			xmlBuff.append("<DocumentRoot>");
		    			xmlBuff.append("<description>").append("Datawindow Root").append("</description>");
		    			xmlBuff.append("<group0>");
		    			xmlBuff.append("<description>").append("Group0 description").append("</description>");
		    			xmlBuff.append("<Header0>");
		    			xmlBuff.append("<objName><![CDATA[").append("misc_pay").append("]]></objName>");
		    			xmlBuff.append("<pageContext><![CDATA[").append("1").append("]]></pageContext>");
		    			xmlBuff.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
		    			xmlBuff.append("<editFlag><![CDATA[").append("A").append("]]></editFlag>");
		    			xmlBuff.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
		    			xmlBuff.append("<action><![CDATA[").append("SAVE").append("]]></action>");
		    			xmlBuff.append("<elementName><![CDATA[").append("").append("]]></elementName>");
		    			xmlBuff.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
		    			xmlBuff.append("<taxKeyValue><![CDATA[").append("").append("]]></taxKeyValue>");
		    			xmlBuff.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
		    			xmlBuff.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
		    			xmlBuff.append("<taxInFocus><![CDATA[").append(false).append("]]></taxInFocus>");
		    			xmlBuff.append("<description>").append("Header0 members").append("</description>");

		    			xmlBuff.append("<Detail1 dbID=\"\" domID=\"1\" objName=\"misc_pay\" objContext=\"1\">");
		    			xmlBuff.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>");
		    			xmlBuff.append("<tran_id/>");
		    			xmlBuff.append("<tran_date><![CDATA[" + sdf.format(today) + "]]></tran_date>");
		    			xmlBuff.append("<tran_type><![CDATA[" + tranType + "]]></tran_type>");
		    			xmlBuff.append("<sundry_code><![CDATA[" + sundryCode + "]]></sundry_type>");
		    			xmlBuff.append("<pay_mode><![CDATA[" + payMode + "]]></pay_mode>");
		    			xmlBuff.append("<ref_date><![CDATA[" + refDate + "]]></ref_date>");
		    			xmlBuff.append("<net_amt><![CDATA[" + totAmount + "]]></net_amt>");
		    			xmlBuff.append("<net_amt__bc><![CDATA[" + totAmount + "]]></net_amt__bc>");
		    			xmlBuff.append("<site_code><![CDATA[" + siteCode + "]]></site_code>");
		    			xmlBuff.append("<acct_code__bal><![CDATA[" +acctCodeBal + "]]></acct_code__bal>");
		    			xmlBuff.append("<cctr_code__bal><![CDATA[" + cctrCodeBal + "]]></cctr_code__bal>");
		    			xmlBuff.append("<auto_paid><![CDATA["+'Y'+"]]></auto_paid>");
		    			xmlBuff.append("<confirmed><![CDATA["+'N'+ "]]></confirmed>");
		    			xmlBuff.append("<acct_code__bc><![CDATA[" + acctCodeBc + "]]></acct_code__bc>");
		    			xmlBuff.append("<cctr_code__bc><![CDATA[" + cctrCodeBc + "]]></cctr_code__bc>");
		    			xmlBuff.append("<curr_code__bc><![CDATA[" +currCodeBc  + "]]></curr_code__bc>");
		    			xmlBuff.append("<exch_rate__bc><![CDATA[" + exchRate + "]]></exch_rate__bc>");
		    			xmlBuff.append("<acct_code__cf><![CDATA[" + acctCodeCfAp + "]]></acct_code__cf>");
		    			xmlBuff.append("<cctr_code__cf><![CDATA[" + cctrCodeCfAp + "]]></cctr_code__cf>");
		    			xmlBuff.append("<tax_amt><![CDATA[" + 0 + "]]></tax_amt>");
		    			xmlBuff.append("</Detail1>");
		                
		    			
			            xmlBuff.append("<Detail2 dbID=\"\" domID=\"1\" objName=\"misc_pay\" objContext=\"1\">");
		    			xmlBuff.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>");
		    			xmlBuff.append("<tran_ser><![CDATA[" + tranSer + "]]></tran_ser>");
		    			xmlBuff.append("<vouch_date><![CDATA[" + sdf.format(refDate) + "]]></vouch_date>");
		    			xmlBuff.append("<net_amt><![CDATA[" + totAmount + "]]></net_amt>");
		    			xmlBuff.append("<pay_amt><![CDATA[" + totAmount + "]]></pay_amt>");
		    			xmlBuff.append("<curr_code><![CDATA[" + currCode + "]]></curr_code>");
		    			xmlBuff.append("<exch_rate__vouch><![CDATA[" + exchRate + "]]></exch_rate__vouch>");
		    			xmlBuff.append("<acct_code__ap><![CDATA[" + acctCode + "]]></acct_code__ap>");
		    			xmlBuff.append("<cctr_code__ap><![CDATA[" + cctrCode + "]]></cctr_code__ap>");
		    			xmlBuff.append("<sundry_type><![CDATA[" + sundryType + "]]></sundry_type>");
		    			xmlBuff.append("<sundry_code><![CDATA[" + sundryCode + "]]></sundry_code>");
		    			xmlBuff.append("<bank_charges><![CDATA[" + 0 + "]]></bank_charges>");
		    			//xmlBuff.append("<tax_env><![CDATA[" + taxEnv + "]]></tax_env>");
		    			xmlBuff.append("<line_no><![CDATA[" + 1 + "]]></line_no>");
		    			xmlBuff.append("<tax_amt><![CDATA[" + 0 + "]]></tax_amt>");
		    			xmlBuff.append("<net_pay_amt><![CDATA[" + totAmount + "]]></net_pay_amt>");
		    			
		    			xmlBuff.append("</Header0>");
		    			xmlBuff.append("</group0>");
		    			xmlBuff.append("</DocumentRoot>");
		    			System.out.println("xmlBuff.toString() ["+xmlBuff.toString() + "]");
		    			
		    			//calling process Request 
		    			retString=saveData(xtraParams, siteCode, xmlBuff.toString(), conn);
		    			
		    			if( retString.indexOf("Success") != -1 || retString==null)
		    			{
		    			  return (itmDBAccessEJB.getErrorString("","VOUCHSUCC",""));	
		    			}
			     				        
		}
	    catch(Exception e)
		{
			try
			{
				conn.rollback();
			}
			catch (Exception e1)
			{
			}
			e.printStackTrace();
			System.out.println("Exception ::"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null;					
				}	
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;					
				}		
				if( conn != null && ! conn.isClosed() )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception ef)
			{
				System.out.println(ef.getMessage());
				ef.printStackTrace();
				throw new ITMException(ef);
			}
		}
		System.out.println("Returning Result ::"+retString);
		return retString;
		
		
		
	}
	private Timestamp calcDiscountDate(String crTerm, String vouchDate, String effDate, String billDate,Connection conn) throws ITMException
	{
		String discountDate="",sql="",lsStart="",lsMonth="",lsOverridediscdt="";
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		Timestamp ldDuedate=null,ldTranDt=null;
		long llCount,liMonth,liCrDays,liCurrDays,liDueDays;
		int sqlCount=0,liDays=0;
		UtilMethods utlMethods= new UtilMethods();
		 E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{
			// TODO Auto-generated method stub
			sql="select start_from from crterm where cr_term = ?";
			pstmt=conn.prepareStatement(sql);
			pstmt.setString(1, crTerm);
			rs=pstmt.executeQuery();
			if(rs.next())
			{
				lsStart=checkNull(rs.getString("start_from"));
			}
			pstmt.close();
			pstmt=null;
			rs.close();
			rs=null;

			if(lsStart.equalsIgnoreCase("R"))
			{
				ldTranDt=Timestamp.valueOf(vouchDate);
			}
			else if(lsStart.equalsIgnoreCase("D")||lsStart.equalsIgnoreCase("Q"))
			{
				ldTranDt=Timestamp.valueOf(effDate);
			}
			else if(lsStart.equalsIgnoreCase("B"))
			{
				//	ldTranDt=Timestamp.valueOf(billDate);
				ldTranDt=Timestamp.valueOf(genericUtility.getValidDateString(billDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) + " 00:00:00.0");
			}
			// 02-dec-16 manoharan avoid deprecated
			//liMonth=ldTranDt.getMonth();
			Calendar cal = Calendar.getInstance();
			cal.setTime(ldTranDt);
			liMonth = cal.get(Calendar.MONTH);
			
			if(liMonth==12)
			{
				liMonth=1;
				lsMonth="01";
			}
			else
			{
				liMonth=liMonth+1;
				if(liMonth>9)
				{
					lsMonth=String.valueOf(liMonth);	        		
				}
				else
				{
					lsMonth="0"+String.valueOf(liMonth);
				}
			}

			sql="select override_discount_date from crterm_disc where cr_term = ?"
					+ " and cr_month= ? and override_discount_date is not null";
			pstmt=conn.prepareStatement(sql);
			pstmt.setString(1, crTerm);
			pstmt.setString(2, lsMonth);
			rs=pstmt.executeQuery();
			if(rs.next())
			{
				sqlCount++;
				lsOverridediscdt=checkNull(rs.getString("override_discount_date"));
			}
			pstmt.close();
			pstmt=null;
			rs.close();
			rs=null;
			//System.out.println("@@@@@@@@1613 lsOverridediscdt["+lsOverridediscdt+"]");//
			if(sqlCount>0)
			{
				if(lsOverridediscdt!=null && lsOverridediscdt.trim().length()>0)
				{
					liCrDays=Long.parseLong(lsOverridediscdt.substring(2));
				}	        	
			}
			else
			{
				sql="select crtermfc.max_day,crterm_disc.override_discount_date"
						+ " from crterm_disc,crtermfc"
						+ " where crterm_disc.cr_term = crtermfc.cr_term"
						+ "  and trim(crtermfc.line_no) = '1' and crterm_disc.cr_term =?"
						+ " and crterm_disc.cr_month = '99' and crterm_disc.override_discount_date is not null";
				pstmt=conn.prepareStatement(sql);
				pstmt.setString(1, crTerm);
				rs=pstmt.executeQuery();
				if(rs.next())
				{
					sqlCount++;
					lsOverridediscdt=checkNull(rs.getString("override_discount_date"));
					liDays=rs.getInt("max_day");
				}
				pstmt.close();
				pstmt=null;
				rs.close();
				rs=null;
				//System.out.println("@@@@@@@@1614 lsOverridediscdt["+lsOverridediscdt+"]");
				if(sqlCount>0)
				{
					liCrDays=Long.parseLong(lsOverridediscdt.substring(2));
				}
				else
				{
					sql="select max_day from crtermfc where cr_term = ? and crtermfc.line_no = '1'";
					pstmt=conn.prepareStatement(sql);
					pstmt.setString(1, crTerm);
					rs=pstmt.executeQuery();
					if(rs.next())
					{
						sqlCount++;
						liDays=rs.getInt("max_day");
					}
					pstmt.close();
					pstmt=null;
					rs.close();
					rs=null;

					if(sqlCount>0)
					{
						ldDuedate=null;
						return ldDuedate;
					}
				}
			}

			ldDuedate=utlMethods.RelativeDate(ldTranDt,liDays);

		} catch (SQLException e)
		{
			e.printStackTrace();
			System.out.println("Exception ::"+ e.getMessage()); 
			throw new ITMException(e); 
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return ldDuedate;
	}
	public int dayDiff(Timestamp discountDt,Timestamp paymentDt) throws ITMException
	{
		int difference=0;
		try
		{
			
		SimpleDateFormat sdf1=new SimpleDateFormat("dd-MM-yyyy");
	    
	    String [] a1=(sdf1.format(discountDt)).split("-");
	    String [] a2=(sdf1.format(paymentDt)).split("-");
	    
	    System.out.println(Integer.parseInt(a2[2])+""+ Integer.parseInt(a2[1])+""+ Integer.parseInt(a2[0]));
	    LocalDate discDate = LocalDate.of(Integer.parseInt(a1[2]), Integer.parseInt(a1[1]), Integer.parseInt(a1[0]));
	    LocalDate payDate = LocalDate.of(Integer.parseInt(a2[2]), Integer.parseInt(a2[1]), Integer.parseInt(a2[0]));
	    Period diff = Period.between(discDate, payDate);
	    difference=diff.getDays();
	    System.out.printf("Difference is %d years, %d months and %d days old",diff.getYears(), diff.getMonths(), diff.getDays());
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return difference;
	    
	}
	private String saveData(String xtraParams,String siteCode, String xmlString, Connection conn) throws ITMException
	{
	System.out.println("saving data...........");
	InitialContext ctx = null;
	String retString = null;
	MasterStatefulLocal masterStateful = null; // for ejb3
	
	ibase.utility.UserInfoBean userInfoBean=new UserInfoBean();
	 E12GenericUtility genericUtility = new E12GenericUtility();
	try
	{
		AppConnectParm appConnect = new AppConnectParm();
		ctx = new InitialContext(appConnect.getProperty());
		masterStateful = (MasterStatefulLocal) ctx.lookup("ibase/MasterStatefulEJB/local");
		System.out.println("-----------masterStateful------- " + masterStateful);
		String[] authencate = new String[2];
		authencate[0] = "";
		authencate[1] = "";
		System.out.println("xmlString to masterstateful [" + xmlString + "]");
		
		
		userInfoBean.setEmpCode(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));
		userInfoBean.setRemoteHost(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId"));
		userInfoBean.setSiteCode(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"));
		userInfoBean.setLoginCode(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"));
		userInfoBean.setEntityCode(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));
		
		retString=masterStateful.processRequest(userInfoBean,xmlString,true,conn);
	
	} catch (ITMException itme)
	{
		System.out.println("ITMException :CreateDistOrder :saveData :==>");
		throw itme;
	} catch (Exception e)
	{
		e.printStackTrace();
		System.out.println("Exception :CreateDistOrder :saveData :==>");
		throw new ITMException(e);
	}
	return retString;
}
	private String checkNull( String input )
	{
		if ( input == null )
		{
			input = "";
		}
		return input;
	}
}