package ibase.webitm.ejb.fin;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Types;

import javax.ejb.Stateless;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;

import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.*;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.utility.ITMException;

import ibase.webitm.utility.TransIDGenerator;

@Stateless
public class MiscDrCrRcpConf extends ActionHandlerEJB implements MiscDrCrRcpConfLocal ,MiscDrCrRcpConfRemote  {
	
	E12GenericUtility genericUtility = new E12GenericUtility();
	public String confirm(String tranId,String xtraParams,String forcedFlag) throws RemoteException,ITMException
	{   boolean isPreview = false;
		Connection conn=null;
		String errString="";
		errString=confirm(tranId,xtraParams,forcedFlag,conn,isPreview);
		System.out.println("errString----"+errString);
		return errString;
		
	}
	
	public String confirm(String tranId,String xtraParams, String forcedFlag, Connection conn) throws RemoteException,ITMException
	{
		String retString = "";
		boolean isConn= false;

        boolean isPreview = false;
		try
		{
			retString = confirm( tranId, xtraParams, forcedFlag, conn ,isPreview);

			if ( retString != null && retString.length() > 0 )
			{
				throw new Exception("Exception while calling confirm for tran  Id:["+tranId+"]");
			}
		}
		catch(Exception exception)
		{
			System.out.println("Exception in [InvHoldConfEJB] getCurrdateAppFormat " + exception.getMessage());
		}
		return retString;
	}
	public String confirm(String tranId,String xtraParams,String forcedFlag,Connection conn,boolean isPreview) throws RemoteException,ITMException
	{
		//Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "";
        ConnDriver connDriver = null;
		String confirm = "",errString = "" ;
		boolean isLocal=false;	
		ITMDBAccessEJB itmDBAccessEJB = null;
		
		try
		{
			System.out.println("<!@#> In confirm :::::::::::::3007121030::::::::::::::::::");
			System.out.println("<!@#> In confirm ::::::::::::::::::::xtraParams:" +xtraParams +":");
			System.out.println("<!@#> In confirm ::::::::::::::::::::forcedFlag:" +forcedFlag +":");
          	itmDBAccessEJB = new ITMDBAccessEJB();
		//	connDriver = new ConnDriver();
         //   //Changes and Commented By Bhushan on 06-06-2016 :START
//conn = connDriver.getConnectDB("DriverITM");
 //   conn = getConnection();
//Changes and Commented By Bhushan on 06-06-2016 :END
		//	connDriver = null;
           // conn.setAutoCommit(false);
          	if(conn==null)
          	{
          		connDriver = new ConnDriver();
          		//Changes and Commented By Bhushan on 06-06-2016 :START
          		//conn = connDriver.getConnectDB("DriverITM");
          		conn = getConnection();
          		//Changes and Commented By Bhushan on 06-06-2016 :END
          		connDriver = null;
          		conn.setAutoCommit(false);
          		isLocal=true;
          	}
			sql =" select confirmed from misc_drcr_rcp where tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
            rs = pstmt.executeQuery();
            if(rs.next())
			{
                confirm = rs.getString("confirmed");
            }
            rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			if(isPreview != false)//if isPreview is true
			{
				errString = gbfRetrieveMiscDrcrRcp(tranId,xtraParams,conn,isPreview);
			}
			else{
			if(confirm != null  && "Y".equalsIgnoreCase(confirm))
			{
                System.out.println("The Selected transaction is already confirmed");
                errString = itmDBAccessEJB.getErrorString("","VTMCONF1","","",conn);
                return errString;
            }
			else
			{
				errString = this.gbfRetrieveMiscDrcrRcp(tranId,xtraParams,conn);
				if(errString != null && errString.trim().length() > 0)
				{

//					return errString;
					System.out.println("checking CONFSUCCES in errString" +errString);
					if(errString.indexOf("CONFSUCCES") > -1)
					{
						if(isLocal)
						{
							conn.commit();
						}
						System.out.println("Committing..............");
						//conn.commit();
						//conn.close();
						//conn=null;
//						return errString;

					}
					else
					{
						if(isLocal)
						{
							conn.rollback();
						}
						System.out.println("Rollbacking..............");
						//conn.rollback();
						//conn.close();
						//conn=null;
					}
				}
			}
			}
		} //end of try
		catch(Exception e)
		{
			System.out.println("Exception ::"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{			
				if(conn!=null && isLocal)
				{
					System.out.println(" finally Rollbacking..............");
					//conn.rollback();
					conn.close();
					conn=null;
				}
				//conn = null;
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception : "+e);e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
	} //end of confirm method

	private	String gbfRetrieveMiscDrcrRcp(String tranIdFrom,String tranIdto, String xtraParams,Connection conn)throws RemoteException,ITMException
	{
		String errString="";
		PreparedStatement pstmt=null;
		ArrayList<String> tranidList = new ArrayList<String>() ;
		ResultSet rs=null;
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		try{
			System.out.println("<!@#> In gbfRetrieveMiscDrcrRcp :::::::::::::::::::::::::::::::");

			String sql="";
			sql ="select tran_id from misc_drcr_rcp where tran_id <= ? and tran_id >=? and site_code =? and confirmed = ?" +
					" order by tran_id asc";
			pstmt=conn.prepareStatement(sql);
			pstmt.setString(1,tranIdFrom);
			pstmt.setString(2, tranIdto);
			pstmt.setString(3, genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"));
			pstmt.setString(4, "N");
			rs=pstmt.executeQuery();
			while (rs.next())
			{
				tranidList.add(rs.getString("tran_id"));
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
			if(tranidList.size() >0)
			{
				//Iterate through list
				Iterator<String> iterator =tranidList.iterator();
				while(iterator.hasNext())
				{
					//check for multiple
					errString=gbfRetrieveMiscDrcrRcp(iterator.next(), xtraParams, conn);
					if(!(errString.indexOf("CONFSUCCES")>-1))
					{
						throw new Exception("Transaction Fail");
						
					}
					
				}
			}else
			{
				//Show error
				errString = itmDBAccessEJB.getErrorString("","VTNOREC2","","",conn);
				return errString; 
			}
			
		}catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		
		
		return errString;
	}
	
	private	String gbfRetrieveMiscDrcrRcp(String tranId,String xtraParams,Connection conn)throws RemoteException,ITMException
	{
		String errString = gbfRetrieveMiscDrcrRcp(tranId,xtraParams,conn, false);
		return errString;
	}
	

	private	String gbfRetrieveMiscDrcrRcp(String tranId,String xtraParams,Connection conn,boolean isPreview)throws RemoteException,ITMException
	{
		PreparedStatement pstmt = null;
		PreparedStatement pstmtInsert = null;
		PreparedStatement pstmtInner = null;
		ResultSet rs = null;
		ResultSet rsInner = null;
		String sql = "",sqlInsert = "",sqlInner="";
		String loginEmpCode = "",errString="" ; 
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		
		FinCommon Fcommon = new FinCommon();
		DistCommon Dcommon = new DistCommon();
		
				
		ArrayList miscRdetList = new ArrayList();	
		ArrayList miscRcpInvList = new ArrayList();
		HashMap miscRcpMap=null,miscRdetMap= null,miscRcpInvMap=null;
		HashMap miscRdetListMap=null,miscRcpInvListMap=null;

		java.sql.Timestamp tranDate = null;
		java.sql.Timestamp effDate = null;
		java.sql.Timestamp dueDate = null;
		java.sql.Timestamp confDate = null;
		
		String tranSer="",sundryType="",tranType="",siteCode="",finEntity="",sundryCode="",acctCode="";
		String cctrCode="",currCode="",remarks="",confirmed="",empCodeAprv="",drcrFlag="",tranIdRcv="",saleOrder="";
		String itemSer="",sreturnNo="",adjMiscCrn="",custRefNo="",rndOff="",custCode="",siteCodeDrcr="";
		double amount=0,amountBc=0,exchRate=0,adjAmount=0,roundAdj=0,rndTo=0;
		
		String lineNo="",detAcctCode="",detCctrCode="",detAnalCode="",detEmpCode="",detTaxClass="";
		String detTaxChap="",detTaxEnv="",detReasCode="",detRefNo="",detItemCode="",lineNoSret="";
		String lineNoInvtrace="",detLotNo="",detLotSl="",analysis1="",analysis2="",analysis3="";
		double detAmount=0,detNetAmt=0,detTaxAmt=0,detQuantity=0,detRate=0;
		
		String adjLineNo="",adjRefSer="",adjRefNo="";
		double adjAmt=0,refBalAmt=0,mrpValueAdj=0;
		
		String runMode = "I",winName="",ledgPostConf="",acctCodeRadj="",cctrCodeRadj="";
		double amthdr1=0,amountRadj=0,amt=0,taxAmt=0,recoAmt=0,tot =0;
		java.sql.Timestamp toDay = null;
		java.util.Date toDate = new java.util.Date();
		String acctCodeReco="",cctrCodeReco="",taxAcct="",taxCctr="",itemSr="";
		int cnt =0,cnt1=0,foundAt=0;
		double recAmt=0,totAmt=0,recAdjAmt=0;
		int updCnt=0;
		int upd=0;
		boolean status=false ,flg = true;
		int[] batchCount;
		String itemCode="";
		String acctAnalysis="";
		String[] analysisStr =null;
		String analysis1__acct="",analysis2__acct="",analysis3__acct="" ;
		try{
			System.out.println("<!@#> In gbfRetrieveMiscDrcrRcp :::::::::::::::::::::::::::::::");
//			GenericUtility genericUtility = GenericUtility.getInstance();
			E12GenericUtility genericUtility = new E12GenericUtility();
			String dbDateFormat = genericUtility.getDBDateFormat();
			String applDateFormat = genericUtility.getApplDateFormat();
			SimpleDateFormat sdf = new SimpleDateFormat(applDateFormat);
			//added by kunal on 10/jun/14
			toDay = java.sql.Timestamp.valueOf(genericUtility.getValidDateString( sdf.format(toDate) , applDateFormat, dbDateFormat ) + " 00:00:00.0") ;
			
			if("db2".equalsIgnoreCase(CommonConstants.DB_NAME))
			{
				sql =" select tran_date,tran_ser,eff_date,sundry_type,tran_type,due_date, "
						+" site_code, fin_entity,sundry_code,acct_code,cctr_code,amount,curr_code,remarks, "
						+" confirmed,conf_date,emp_code__aprv,drcr_flag,tran_id__rcv,item_ser, "
						+" amount__bc,exch_rate,sreturn_no,adj_misc_crn,adj_amount,round_adj,cust_ref_no,"
						+" cust_ref_date,cust_ref_amt,rnd_off,rnd_to,sale_order "//Added by chandrashekar on dtd 25/08/2014
						+" from misc_drcr_rcp "   
						+" where tran_id = ? for update" ;

				
			}else if("mssql".equalsIgnoreCase(CommonConstants.DB_NAME))
			{
				sql =" select tran_date,tran_ser,eff_date,sundry_type,tran_type,due_date, "
						+" site_code, fin_entity,sundry_code,acct_code,cctr_code,amount,curr_code,remarks, "
						+" confirmed,conf_date,emp_code__aprv,drcr_flag,tran_id__rcv,item_ser, "
						+" amount__bc,exch_rate,sreturn_no,adj_misc_crn,adj_amount,round_adj,cust_ref_no,"
						+" cust_ref_date,cust_ref_amt,rnd_off,rnd_to,sale_order "//Added by chandrashekar on dtd 25/08/2014
						+" from misc_drcr_rcp (updlock) "   
						+" where tran_id = ? " ;
				
			}else 
			{
				sql =" select tran_date,tran_ser,eff_date,sundry_type,tran_type,due_date, "
						+" site_code, fin_entity,sundry_code,acct_code,cctr_code,amount,curr_code,remarks, "
						+" confirmed,conf_date,emp_code__aprv,drcr_flag,tran_id__rcv,item_ser, "
						+" amount__bc,exch_rate,sreturn_no,adj_misc_crn,adj_amount,round_adj,cust_ref_no,"
					//	+" cust_ref_date,cust_ref_amt,rnd_off,rnd_to,site_code__drcr "
					+" cust_ref_date,cust_ref_amt,rnd_off,rnd_to,sale_order "//Added by chandrashekar on dtd 25/08/2014
						+" from misc_drcr_rcp  "   
						+" where tran_id = ? for update nowait " ;
				
			}
			pstmt=conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs=pstmt.executeQuery();
			if(rs.next())
			{
				tranDate = rs.getTimestamp("tran_date");
				tranSer = rs.getString("tran_ser");
				effDate = rs.getTimestamp("eff_date");
				sundryType = rs.getString("sundry_type");
				tranType = rs.getString("tran_type");
				dueDate = rs.getTimestamp("due_date");
				siteCode = rs.getString("site_code");
				finEntity = rs.getString("fin_entity");
				sundryCode = rs.getString("sundry_code");
				acctCode = rs.getString("acct_code");
				cctrCode = rs.getString("cctr_code");
				amount = rs.getDouble("amount");
				currCode = rs.getString("curr_code");
				remarks = rs.getString("remarks");
				confirmed = rs.getString("confirmed");
				confDate = rs.getTimestamp("conf_date");
				empCodeAprv = rs.getString("emp_code__aprv");
				drcrFlag = rs.getString("drcr_flag");
				tranIdRcv = rs.getString("tran_id__rcv");
				itemSer = rs.getString("item_ser");
				amountBc = rs.getDouble("amount__bc");
				exchRate = rs.getDouble("exch_rate");
				sreturnNo = rs.getString("sreturn_no");
				adjMiscCrn = rs.getString("adj_misc_crn");
				adjAmount = rs.getDouble("adj_amount");
				roundAdj = rs.getDouble("round_adj");
				custRefNo = rs.getString("cust_ref_no");
				rndOff = rs.getString("rnd_off");
				rndTo = rs.getDouble("rnd_to");
				saleOrder = rs.getString("sale_order");//Added by chandrashekar dtd 25/08/2014 to set sales order in receivable
				//siteCodeDrcr = rs.getString("site_code__drcr");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null; 
			
			
			miscRcpMap = new HashMap();
			//Manoj dtd 18/12/2013 reason code set in miscRcpMap to update in receivables
			pstmt=conn.prepareStatement("SELECT MAX(REAS_CODE) FROM MISC_DRCR_RDET WHERE TRAN_ID=? AND REAS_CODE IS NOT NULL");
			pstmt.setString(1, tranId);
			rs=pstmt.executeQuery();
			if(rs.next())
			{
				miscRcpMap.put("reas_code",rs.getString(1));	
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
			miscRcpMap.put("tran_date",tranDate);
			miscRcpMap.put("tran_ser",tranSer);
			miscRcpMap.put("eff_date",effDate);
			miscRcpMap.put("sundry_type",sundryType);
			miscRcpMap.put("tran_type",tranType);
			miscRcpMap.put("due_date",dueDate);
			miscRcpMap.put("site_code",siteCode);
			miscRcpMap.put("fin_entity",finEntity);
			miscRcpMap.put("sundry_code",sundryCode);
			miscRcpMap.put("acct_code",acctCode);
			miscRcpMap.put("cctr_code",cctrCode);
			miscRcpMap.put("amount",amount);
			miscRcpMap.put("curr_code",currCode);
			miscRcpMap.put("remarks",remarks);
			miscRcpMap.put("confirmed",confirmed);
			miscRcpMap.put("conf_date",confDate);
			miscRcpMap.put("emp_code__aprv",empCodeAprv);
			miscRcpMap.put("drcr_flag",drcrFlag);
			miscRcpMap.put("tran_id__rcv",tranIdRcv);
			miscRcpMap.put("item_ser",itemSer);
			miscRcpMap.put("amount__bc",amountBc);
			miscRcpMap.put("exch_rate",exchRate);
			miscRcpMap.put("sreturn_no",sreturnNo);
			miscRcpMap.put("adj_misc_crn",adjMiscCrn);
			miscRcpMap.put("adj_amount",adjAmount);
			miscRcpMap.put("round_adj",roundAdj);
			miscRcpMap.put("cust_ref_no",custRefNo);
			miscRcpMap.put("rnd_off",rndOff);
			miscRcpMap.put("rnd_to",rndTo);
			//Added By Manoj dtd 03/05/2013 to set Customer code to update in receivable
			miscRcpMap.put("cust_code",sundryCode);
			//Added By chandrashekar dtd 25/08/2014 to set sales order in receivable
			miscRcpMap.put("sale_order",saleOrder);
			
			//miscRcpMap.put("site_code__drcr",siteCodeDrcr);
			
			//check record present in detail or not and apply lock
			
//			if("db2".equalsIgnoreCase(CommonConstants.DB_NAME))
//			{
//				sql ="select count(*) from misc_drcr_rdet where tran_id = ? for update";
//
//				
//			}else if("mssql".equalsIgnoreCase(CommonConstants.DB_NAME))
//			{
//				sql ="select count(*) from misc_drcr_rdet (updlock) where tran_id = ?";
//				
//			}else 
//			{
				sql ="select count(*) from misc_drcr_rdet where tran_id = ?";

//			}

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				cnt1 =rs.getInt(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			System.out.println("cnt1["+cnt1+"]");
			if(cnt1 <= 0)	
			{
				System.out.println("no record found in misc_drcr_rdet");
				errString = itmDBAccessEJB.getErrorString("","VTNOREC2","","",conn);
				return errString;
			}
		
			
		//taking details for particular tran_id
			sql =" select line_no,acct_code,cctr_code,amount,anal_code,emp_code,net_amt,tax_amt,tax_class,tax_chap, "
					+" tax_env,reas_code,ref_no,item_code,quantity,rate,line_no__sret,line_no__invtrace,lot_no,lot_sl,analysis1,analysis2,analysis3,item_code "  
					+" from misc_drcr_rdet "
					+" where tran_id = ? order by line_no ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					lineNo = rs.getString("line_no");
					detAcctCode = rs.getString("acct_code");
					detCctrCode = rs.getString("cctr_code");
					detAmount = rs.getDouble("amount");
					detAnalCode = rs.getString("anal_code");
					detEmpCode = rs.getString("emp_code");
					detNetAmt = rs.getDouble("net_amt");
					detTaxAmt = rs.getDouble("tax_amt");
					detTaxClass = rs.getString("tax_class");
					detTaxChap = rs.getString("tax_chap");
					detTaxEnv = rs.getString("tax_env");
					detReasCode = rs.getString("reas_code");
					detRefNo = rs.getString("ref_no");
					detItemCode = rs.getString("item_code");
					detQuantity = rs.getDouble("quantity");
					detRate = rs.getDouble("rate");
					lineNoSret = rs.getString("line_no__sret");
					lineNoInvtrace = rs.getString("line_no__invtrace");
					detLotNo = rs.getString("lot_no");
					detLotSl = rs.getString("lot_sl");
					analysis1 = (rs.getString("analysis1")==null?"":rs.getString("analysis1"));
					analysis2 = (rs.getString("analysis2")==null?"":rs.getString("analysis2"));
					analysis3 = (rs.getString("analysis3")==null?"":rs.getString("analysis3"));
					itemCode = rs.getString("item_code");
					
					miscRdetMap = new HashMap();
					miscRdetMap.put("line_no",lineNo);
					miscRdetMap.put("acct_code",detAcctCode);
					miscRdetMap.put("cctr_code",detCctrCode);
					miscRdetMap.put("amount",detAmount);
					miscRdetMap.put("anal_code",detAnalCode);
					miscRdetMap.put("emp_code",detEmpCode);
					miscRdetMap.put("net_amt",detNetAmt);
					miscRdetMap.put("tax_amt",detTaxAmt);
					miscRdetMap.put("tax_class",detTaxClass);
					miscRdetMap.put("tax_chap",detTaxChap);
					miscRdetMap.put("tax_env",detTaxEnv);
					miscRdetMap.put("reas_code",detReasCode);
					miscRdetMap.put("ref_no",detRefNo);
					miscRdetMap.put("item_code",detItemCode);
					miscRdetMap.put("quantity",detQuantity);
					miscRdetMap.put("rate",detRate);
					miscRdetMap.put("line_no__sret",lineNoSret);
					miscRdetMap.put("line_no__invtrace",lineNoInvtrace);
					miscRdetMap.put("lot_no",detLotNo);
					miscRdetMap.put("lot_sl",detLotSl);
					/*miscRdetMap.put("analysis1",analysis1);
					miscRdetMap.put("analysis2",analysis2);
					miscRdetMap.put("analysis3",analysis3);*/
					
					
					InvAcct invacct=new InvAcct();
					
					if(drcrFlag!=null)
					{
						if("D".equalsIgnoreCase(drcrFlag.trim()))
						{
							acctAnalysis=invacct.AcctAnalysisType(itemCode, tranSer, tranType, "CR", conn);		
						}
						else if("C".equalsIgnoreCase(drcrFlag.trim()))
						{
							acctAnalysis=invacct.AcctAnalysisType(itemCode, tranSer, tranType, "DR", conn);
						}
					}
					
					System.out.println("@@@@CR return analysis["+acctAnalysis+"]");
					
					analysisStr = acctAnalysis.split("@");
					int len = analysisStr.length-1;
					//System.out.println("@@@cr len["+len+"]");
					if( len > -1 )
					{
						analysis1__acct = analysisStr[0];
					}
					else
					{
						analysis1__acct = "";	
					}	
					if( len > 0 )
					{
						analysis2__acct = analysisStr[1];	
					}
					else
					{	
						analysis2__acct = "";
					}
					if( len > 1)
					{
						analysis3__acct = analysisStr[2];
					}
					else
					{
						analysis3__acct ="";	
					}
					
					
					if(analysis1__acct==null || "".equalsIgnoreCase(analysis1__acct.trim()))
							{
								analysis1__acct=analysis1;
							}
					if(analysis2__acct==null || "".equalsIgnoreCase(analysis2__acct.trim()))
					{
						analysis2__acct=analysis2;
					}
					if(analysis3__acct==null || "".equalsIgnoreCase(analysis3__acct.trim()))
					{
						analysis3__acct=analysis3;
					}
						
					//analysisStr = acctAnalysis.split("@");
					//int len = analysisStr.length-1;
					//System.out.println("@@@cr len["+len+"]");
					/*if( len > -1 )
					{
						analysis1__acct = analysisStr[0];
					}
					else
					{
						analysis1__acct = analysis1;	
					}	
					if( len > 0 )
					{
						analysis2__acct = analysisStr[1];	
					}
					else
					{	
					  analysis2__acct = analysis2;
					}
					if( len > 1)
					{
					analysis3__acct = analysisStr[2];
					}
					else
					{
						analysis3__acct =analysis3;	
					}
					*/
					System.out.println("Setting value from item_acct_analysis---"+analysis1__acct+"---"+analysis2__acct+"---"+analysis3__acct);
					miscRdetMap.put("analysis1",analysis1__acct);
					miscRdetMap.put("analysis2",analysis2__acct);
					miscRdetMap.put("analysis3",analysis3__acct);
					miscRdetList.add(miscRdetMap);		
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

//taking details from misc_drcr_rcpinv and apply lock
				
//				if("db2".equalsIgnoreCase(CommonConstants.DB_NAME))
//				{
//					sql =" select line_no,ref_ser,ref_no,adj_amt,ref_bal_amt,mrp_value__adj "
//							+" from misc_drcr_rcpinv  where tran_id = ? for update" ;
//
//					
//				}else if("mssql".equalsIgnoreCase(CommonConstants.DB_NAME))
//				{
//					sql =" select line_no,ref_ser,ref_no,adj_amt,ref_bal_amt,mrp_value__adj "
//							+" from misc_drcr_rcpinv(updlock)  where tran_id = ?" ;
//				}else 
//				{
					sql =" select line_no,ref_ser,ref_no,adj_amt,ref_bal_amt,mrp_value__adj "
							+" from misc_drcr_rcpinv where tran_id = ?" ;
					
//				}
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				rs = pstmt.executeQuery();
				//if(rs.next()) // Comment Added by Sagar on 17/Nov/15
				while(rs.next()) //Condition changed by Sagar on 17/Nov/15 for flat booking cancellation(DI3HDOS006) of dosti project 
				{
					adjLineNo = rs.getString("line_no");
					adjRefSer = rs.getString("ref_ser");
					adjRefNo = rs.getString("ref_no");
					adjAmt = rs.getDouble("adj_amt");
					refBalAmt = rs.getDouble("ref_bal_amt");
					mrpValueAdj = rs.getDouble("mrp_value__adj");
					
					System.out.println(">>>>>>>>>>>>>>>>>in while misc_drcr_rcpinv adjLineNo:"+adjLineNo);
					System.out.println(">>>>>>>>>>>>>>>>>in while misc_drcr_rcpinv adjAmt:"+adjAmt);
								
					miscRcpInvMap = new HashMap(); 
					miscRcpInvMap.put("line_no",adjLineNo);
					miscRcpInvMap.put("ref_ser",adjRefSer);
					miscRcpInvMap.put("ref_no",adjRefNo);
					miscRcpInvMap.put("adj_amt",adjAmt);
					miscRcpInvMap.put("ref_bal_amt",refBalAmt);
					miscRcpInvMap.put("mrp_value__adj",mrpValueAdj);
					
					miscRcpInvList.add(miscRcpInvMap);
				}
//commented as discussed with shri mam				else
//				{
//					System.out.println("no record found in misc_drcr_rcpinv");
//					errString = itmDBAccessEJB.getErrorString("","VTNOREC2","","",conn);
//					return errString;
//				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
//for run mode "I" {as discussed with KB sir it is only for PB compatibility}
				if ("I".equalsIgnoreCase(runMode))
				{
					//toDay =new java.sql.Timestamp(toDate.getTime());
					
					if("MDRCRC".equalsIgnoreCase(tranSer.trim()))
					{
						winName = "W_MISC_DRCR_RCP_CR";
					}
					else if("MDRCRD".equalsIgnoreCase(tranSer.trim()))
					{
						winName = "W_MISC_DRCR_RCP_DR";
					}
				
					sql =" select ledg_post_conf from transetup where upper(tran_window) = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,winName);
					rs = pstmt.executeQuery();
					if(rs.next())
					{     
						ledgPostConf = rs.getString("ledg_post_conf");
					}
					else
					{
						System.out.println("Record not found in transetup");
						errString = itmDBAccessEJB.getErrorString("","VTSEQ","","",conn);
						return errString;
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
						
					if(ledgPostConf != null  && "Y".equalsIgnoreCase(ledgPostConf))
					{
						//if(tranDate.compareTo(toDay) > 0) change done by kunal on 10/jun/14 comment if statement 
						//{
						if(!isPreview)
						{//avoiding update****Vishakha
							sql =" update misc_drcr_rcp set tran_date = ? "
								+" where tran_id = ?";
							pstmt = conn.prepareStatement(sql);
							//pstmt.setTimestamp(1,tranDate);
							pstmt.setTimestamp(1,toDay);//change done by kunal on 10/jun/14 
							pstmt.setString(2,tranId);
							
							upd = pstmt.executeUpdate();
							if(upd <1 )
							{
								throw new ITMException(new Exception("updateFail"));
							}
							pstmt.close();
							pstmt = null;
						//}
							}
					}
					
					System.out.println("roundAdj["+roundAdj+"]");
					if(("null".equals(roundAdj)) || (roundAdj == 0))
					{
						amthdr1 = amount ;
						if(!("N").equalsIgnoreCase(rndOff))
						{
							amount = Dcommon.getRndamt(amthdr1,rndOff,rndTo);
							
						}
						System.out.println("754---amount["+amount+"]");
						System.out.println("755---amthdr1["+amthdr1+"]");
						if(amthdr1 != amount)
						{
							if(!isPreview)
							{ //if isPreview is true
									sql =" update misc_drcr_rcp "
										+" set round_adj = ? ,amount = ? ,amount__bc = ? "
										+" where tran_id   = ?	";
									
									pstmt = conn.prepareStatement(sql);
									pstmt.setDouble(1,(amount - amthdr1));
									pstmt.setDouble(2,amthdr1);
									pstmt.setDouble(3,(amount * exchRate));
									pstmt.setString(4,tranId);
									upd = pstmt.executeUpdate();
									if(upd <1 )
									{
										throw new ITMException(new Exception());
									}
		
									pstmt.close();
									pstmt = null;
						}//ending isPreview Condition
							miscRcpMap.put("round_adj",(amount - amthdr1));
							//miscRcpMap.put("amount",amthdr1);
							miscRcpMap.put("amount",amount);
							miscRcpMap.put("amount__bc",(amount * exchRate));
						}
					}
					System.out.println("miscRcpMap--["+miscRcpMap+"]");
					//insert into misc_drcr_rdet
					
//					sqlInsert =" insert into misc_drcr_rdet "
//							+" (tran_id,line_no,acct_code,cctr_code,amount,emp_code,anal_code)"
//							+" values (?,?,?,?,?,?,?)";
//					pstmtInsert = conn.prepareStatement(sqlInsert);
					
					amountRadj =Double.parseDouble(miscRcpMap.get("round_adj").toString());
					System.out.println("amountRadj["+amountRadj+"]");
					if("null".equals(amountRadj))
					{
						amountRadj = 0;
					}
					if(amountRadj !=0 )
					{
						acctCodeRadj = Fcommon.getFinparams("999999","ROUND_ADJUST_ACCT",conn);
						
						cctrCodeRadj = Fcommon.getFinparams("999999","ROUND_ADJUST_CCTR",conn);
						if("null".equalsIgnoreCase(cctrCodeRadj)) cctrCodeRadj = "";
						
////						for (int ctr =0; ctr < miscRdetList.size(); ctr++)
////						{
////							miscRdetListMap = new HashMap();
////							miscRdetListMap = (HashMap) miscRdetList.get(ctr);
////							
////							lineNo = (String) miscRdetListMap.get("line_no");
////							acctCode = (String) miscRdetListMap.get("acct_code");
////							cctrCode =(String) miscRdetListMap.get("cctr_code");
////							amount = Double.parseDouble(miscRdetListMap.get("amount").toString());
////							amt = amount+amountRadj;
////finding first acctCode  & cctrCode  in misc_drcr_rdet & last line no
//							miscRdetListMap = new HashMap();
//							miscRdetListMap = (HashMap) miscRdetList.get(0);
//							
////							lineNo = (String) miscRdetListMap.get("line_no");
//							acctCode = (String) miscRdetListMap.get("acct_code");
//							cctrCode =(String) miscRdetListMap.get("cctr_code");
//							miscRdetListMap = new HashMap();
//							miscRdetListMap = (HashMap) miscRdetList.get(miscRdetList.size()-1);
//							lineNo = (String) miscRdetListMap.get("line_no");
					for (int ctr =0; ctr < miscRdetList.size(); ctr++)
					{
						
						System.out.println("Detail List Size********1****"+miscRdetList.size());
						miscRdetListMap = new HashMap();
						miscRdetListMap = (HashMap) miscRdetList.get(ctr);
						
						lineNo = (String) miscRdetListMap.get("line_no");
						acctCode = (String) miscRdetListMap.get("acct_code");
						cctrCode =(String) miscRdetListMap.get("cctr_code");
//						if(!(acctCodeRadj.equalsIgnoreCase(acctCode)) &&(cctrCodeRadj.equalsIgnoreCase(cctrCode)))
						if((acctCodeRadj.equalsIgnoreCase(acctCode)) &&(cctrCodeRadj.equalsIgnoreCase(cctrCode)))

						{
							System.out.println(" Search acctCode & cctrCode  Record found @ line no " +lineNo);
							status=true;
							foundAt=ctr;
							System.out.println("Status***value****"+status);
							break;
							
						}
					}
					
						if(!status)
					{
						
//					}
//							
//							if(!(acctCodeRadj.equalsIgnoreCase(acctCode)) &&(cctrCodeRadj.equalsIgnoreCase(cctrCode)))
//							{
							//Changed by Manoj dtd 23/05/2016 to increase line no. for round if insertion in detail
							miscRdetListMap = new HashMap();
							miscRdetListMap = (HashMap) miscRdetList.get(miscRdetList.size()-1);
							lineNo = (String) miscRdetListMap.get("line_no");
							
							lineNo = (new Integer (Integer.parseInt(lineNo)+1)).toString() ;
							if(!isPreview)
							{
								System.out.println("inserting into misc_drcr_rdetif(!(acctCodeRadj.equalsIgnoreCase(acctCode)) &&(cctrCodeRadj.equalsIgnoreCase(cctrCode)))");
								
								sqlInsert =" insert into misc_drcr_rdet "
										+" (tran_id,line_no,acct_code,cctr_code,amount,emp_code,anal_code)"
										+" values (?,?,?,?,?,?,?)";
								pstmtInsert = conn.prepareStatement(sqlInsert);
								
								
								
								
		//						lineNo =lineNo+1;
								pstmtInsert.setString(1,tranId);
								pstmtInsert.setString(2,lineNo);
								pstmtInsert.setString(3,acctCodeRadj);
								pstmtInsert.setString(4,cctrCodeRadj);
								pstmtInsert.setDouble(5,amountRadj);
								pstmtInsert.setString(6,"");
								pstmtInsert.setString(7,"");
								upd = pstmtInsert.executeUpdate();
								pstmtInsert.close();
								pstmtInsert=null;
								if(upd <1)
								{
									throw new Exception("Update Fail");
								}
							}
//								pstmtInsert.addBatch();
						//adding values to miscRdetListMap
						/*miscRdetListMap = new HashMap();
						miscRdetListMap = (HashMap) miscRdetList.get(miscRdetList.size()-1);
						lineNo = (String) miscRdetListMap.get("line_no");
						
						lineNo = (new Integer (Integer.parseInt(lineNo)+1)).toString() ;
						*/
						miscRdetMap = new HashMap();
						miscRdetMap.put("tran_id", tranId);
						miscRdetMap.put("line_no", lineNo);
						miscRdetMap.put("acct_code", lineNo);
						miscRdetMap.put("acct_code",acctCodeRadj);
						miscRdetMap.put("cctr_code",cctrCodeRadj);
						miscRdetMap.put("amount",amountRadj);
						miscRdetMap.put("emp_code","");
						miscRdetMap.put("anal_code","");
						miscRdetList.add(miscRdetMap);
						
						
						//end
						
					}
					else
					{
						if(!isPreview)
						{ //if isPreview is true
//								sqlInner =" update MISC_DRCR_RDET set amount = ? where tran_id = ? and line_no = ? ";
						sqlInner =" update MISC_DRCR_RDET set amount =amount+ ? where tran_id = ? and line_no = ? ";
						pstmtInner = conn.prepareStatement(sqlInner);
//								pstmtInner.setDouble(1,amt);
						pstmtInner.setDouble(1,amountRadj);
						pstmtInner.setString(2,tranId);
						pstmtInner.setString(3,lineNo);
						
						updCnt = pstmtInner.executeUpdate();
						if(updCnt <1)
						{
							throw new ITMException(new Exception("updateFail"));
						}
						pstmtInner.close();
						pstmtInner = null;
						}
						
					//}
						// modify Map for these new values
						miscRdetListMap = new HashMap(); 
						miscRdetListMap = (HashMap)miscRdetList.get(foundAt);

						miscRdetMap = new HashMap();
						miscRdetMap.put("line_no",miscRdetListMap.get("line_no"));
						miscRdetMap.put("acct_code",miscRdetListMap.get("acct_code"));
						miscRdetMap.put("cctr_code",miscRdetListMap.get("cctr_code"));
						miscRdetMap.put("amount",((Double)miscRdetListMap.get("amount") +amountRadj));
						miscRdetMap.put("anal_code",miscRdetListMap.get("anal_code"));
						miscRdetMap.put("emp_code",miscRdetListMap.get("emp_code"));
						miscRdetMap.put("net_amt",miscRdetListMap.get("net_amt"));
						miscRdetMap.put("tax_amt",miscRdetListMap.get("tax_amt"));
						miscRdetMap.put("tax_class",miscRdetListMap.get("tax_class"));
						miscRdetMap.put("tax_chap",miscRdetListMap.get("tax_chap"));
						miscRdetMap.put("tax_env",miscRdetListMap.get("tax_env"));
						miscRdetMap.put("reas_code",miscRdetListMap.get("reas_code"));
						miscRdetMap.put("ref_no",miscRdetListMap.get("ref_no"));
						miscRdetMap.put("item_code",miscRdetListMap.get("item_code"));
						miscRdetMap.put("quantity",miscRdetListMap.get("line_no"));
						miscRdetMap.put("rate",miscRdetListMap.get("rate"));
						miscRdetMap.put("line_no__sret",miscRdetListMap.get("line_no__sret"));
						miscRdetMap.put("line_no__invtrace",miscRdetListMap.get("line_no__invtrace"));
						miscRdetMap.put("lot_no",miscRdetListMap.get("lot_no"));
						miscRdetMap.put("lot_sl",miscRdetListMap.get("lot_sl"));
						miscRdetMap.put("analysis1",miscRdetListMap.get("analysis1"));
						miscRdetMap.put("analysis2",miscRdetListMap.get("analysis2"));
						miscRdetMap.put("analysis3",miscRdetListMap.get("analysis3"));
						miscRdetList.add(foundAt,miscRdetMap );
						
						//end
					}
					
					
//						}
					} // end of amountRadj !=0   
						
					sql =" select acct_code,cctr_code,case when sum(tax_amt) is null then 0 else sum(tax_amt) end as taxAmt, "
							+" case when sum(reco_amount) is null then 0 else sum(reco_amount) end as recoAmount "
							+" from taxtran where tran_code= ? and "
							+" tran_id	= ? and tax_amt <> 0 and effect <> 'N' "
							+" group by acct_code,cctr_code" ;
						
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,tranSer);
							pstmt.setString(2,tranId);
							rs = pstmt.executeQuery();
							while(rs.next())
							{  
								acctCodeReco = rs.getString("acct_code");
								cctrCodeReco = rs.getString("cctr_code");
								taxAmt = rs.getDouble("taxAmt");
								recoAmt = rs.getDouble("recoAmount");
								
//								for(int ctr =0; ctr< miscRdetList.size(); ctr++)
//								{
//									miscRdetListMap = new HashMap();
//									miscRdetListMap = (HashMap) miscRdetList.get(ctr);
//								
//									lineNo = (String) miscRdetListMap.get("line_no");
//									acctCode = (String) miscRdetListMap.get("acct_code");
//									cctrCode =(String) miscRdetListMap.get("cctr_code");
//									amount = Double.parseDouble(miscRdetListMap.get("amount").toString());
//									amt = amount+recoAmt;
									
									if(acctCodeReco == null)
									{
//taking default account code
										miscRdetListMap = new HashMap();
										miscRdetListMap = (HashMap) miscRdetList.get(0);
										acctCode = (String) miscRdetListMap.get("acct_code");
										cctrCode =(String) miscRdetListMap.get("cctr_code");

										acctCodeReco = acctCode;
									}
									if(cctrCodeReco == null)
									{
//taking default costCtr code
										miscRdetListMap = new HashMap();
										miscRdetListMap = (HashMap) miscRdetList.get(0);
										cctrCode =(String) miscRdetListMap.get("cctr_code");

										cctrCodeReco = cctrCode;
									}
									System.out.println("inserting into misc_drcr_rdetselect acct_code,cctr_code,sum(nvl(tax_amt,0))");
									
									sqlInsert =" insert into misc_drcr_rdet "
											+" (tran_id,line_no,acct_code,cctr_code,amount,emp_code,anal_code)"
											+" values (?,?,?,?,?,?,?)";
									
									pstmtInsert = conn.prepareStatement(sqlInsert);
									if(status && flg)
									{
										miscRdetListMap = new HashMap();
										miscRdetListMap = (HashMap) miscRdetList.get(miscRdetList.size()-1);
										lineNo = (String) miscRdetListMap.get("line_no");
										flg=false;
										System.out.println("lineNo status" +lineNo +status);
									}
									
									lineNo = (new Integer (Integer.parseInt(lineNo)+1)).toString() ;
									System.out.println("lineNo out side if  flg" +lineNo +flg);
									pstmtInsert.setString(1,tranId);
									pstmtInsert.setString(2,lineNo);
									pstmtInsert.setString(3,acctCodeReco);
									pstmtInsert.setString(4,cctrCodeReco);
									pstmtInsert.setDouble(5,(taxAmt-recoAmt));
									pstmtInsert.setString(6,"");
									pstmtInsert.setString(7,"");
									pstmtInsert.addBatch();
									//adding values to miscRdetListMap
									miscRdetMap = new HashMap();
									miscRdetMap.put("tran_id", tranId);
									miscRdetMap.put("line_no", lineNo);
									miscRdetMap.put("acct_code",acctCodeReco);
									miscRdetMap.put("cctr_code",cctrCodeReco);
									miscRdetMap.put("amount",(taxAmt-recoAmt));
									miscRdetMap.put("emp_code","");
									miscRdetMap.put("anal_code","");
									miscRdetList.add(miscRdetMap);
									
									
									//end

//									upd =pstmtInsert.executeUpdate();
//									if(upd < 1)
//									{
//										throw new Exception("UpdateFail");
//									}
//								}
							}// end while
							if(!isPreview)
							{ 
							if(pstmtInsert!=null)
							{
								batchCount =pstmtInsert.executeBatch();
								System.out.println("nos of row inserted "+batchCount.length);
								pstmtInsert.close();
								pstmtInsert=null;
						
							} 
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							
					}//end of isPreview
							
							//taking reco_amount
				
							sql =" select line_no, acct_code__reco,cctr_code__reco, "
									+" case when sum(reco_amount) is null then 0 else sum(reco_amount) end as recoAmount "
									+" from taxtran where tran_code= ? and "
									+" tran_id	= ? and "
									+" (case when (reco_amount) is null then 0 else (reco_amount) end) <> 0 "
									+" and effect <> 'N' "
									+" group by line_no,acct_code__reco,cctr_code__reco" ;
								
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1,tranSer);
									pstmt.setString(2,tranId);
									rs = pstmt.executeQuery();
									while(rs.next())
									{  
										lineNo = rs.getString("line_no");
										acctCodeReco = rs.getString("acct_code__reco");
										cctrCodeReco = rs.getString("cctr_code__reco");
										recoAmt = rs.getDouble("recoAmount");
										
//										for (int ctr =0; ctr< miscRdetList.size(); ctr++)
//										{
//											miscRdetListMap = new HashMap();
//											miscRdetListMap = (HashMap)miscRdetList.get(ctr);
//										
//											lineNo = (String) miscRdetListMap.get("line_no");
//											acctCode = (String) miscRdetListMap.get("acct_code");
//											cctrCode =(String) miscRdetListMap.get("cctr_code");
//											amount = Double.parseDouble(miscRdetListMap.get("amount").toString());
//											amt = amount+recoAmt;
											
											if(acctCodeReco == null || acctCodeReco.trim().length()== 0)
											{
												miscRdetListMap = new HashMap();
												miscRdetListMap = (HashMap)miscRdetList.get(Integer.parseInt(lineNo.trim())-1);
//												System.out.println();
												detItemCode =(String)miscRdetListMap.get("item_code"); 
//												cctrCode = Fcommon.getAcctDetrTtype(detItemCode," ","TAXRECO",tranType,conn);
												cctrCodeReco = Fcommon.getAcctDetrTtype(detItemCode," ","TAXRECO",tranType,conn);

												System.out.println("<!@#>from AcctDetrType acctCodeReco & cctrCodeReco:" +cctrCodeReco+":");
/*
												if(cctrCodeReco.trim().length() > 1)
												{
//													String[] ary =cctrCodeReco.split("//t");
													String[] ary =cctrCodeReco.split(",");
//													taxAcct = ary[0];
													acctCodeReco = ary[0];
													System.out.println("<!@#>cctrCodeReco is " +cctrCodeReco);
//													taxCctr = ary[1];
													cctrCodeReco = ary[1];
													
												}
												if(acctCodeReco == null || acctCodeReco.trim().length() == 0 )
												{
													errString = itmDBAccessEJB.getErrorString("","VTACCTRECO","","",conn);
													return errString;
												}
												if (cctrCodeReco == null || cctrCodeReco.trim().length() == 0 )
												{
													cctrCodeReco = " ";
												}
	*/
												if(cctrCodeReco.length() > 0)
												{
													System.out.println("in if");
//													String[] ary =cctrCodeReco.split("//t");
													
													String[] ary =cctrCodeReco.split(",");
													if(ary.length >0)
													{
														System.out.println("<!@#>ary " +ary.length);
														acctCodeReco = ary[0];
													}else
													{
														acctCodeReco ="";
													} if(ary.length >1)
													{
														cctrCodeReco = ary[1];
														
													}else
													{
														cctrCodeReco =" ";
													}
//													System.out.println("<!@#>cctrCodeReco is " +cctrCodeReco);
//													taxCctr = ary[1];
													
												}
												if(acctCodeReco == null || acctCodeReco.trim().length() == 0 )
												{
													errString = itmDBAccessEJB.getErrorString("","VTACCTRECO","","",conn);
													return errString;
												}

												
											}
//											if(taxAcct == null || taxAcct.trim().length() == 0 )
//											{
//												errString = itmDBAccessEJB.getErrorString("","VTACCTRECO","","",conn);
//												return errString;
//											}
//											if (taxCctr == null || taxCctr.trim().length() == 0 )
//											{
//												taxCctr = " ";
//											}
											
// finding  lines							
											status= false;
											foundAt=0;
											for (int ctr =0; ctr < miscRdetList.size()-1; ctr++)
											{
												miscRdetListMap = new HashMap();
												miscRdetListMap = (HashMap) miscRdetList.get(ctr);
												
												lineNo = (String) miscRdetListMap.get("line_no");
												acctCode = (String) miscRdetListMap.get("acct_code");
												cctrCode =(String) miscRdetListMap.get("cctr_code");
//												if(!(acctCodeRadj.equalsIgnoreCase(acctCode)) &&(cctrCodeRadj.equalsIgnoreCase(cctrCode)))
//												if(!(acctCodeReco.equalsIgnoreCase(acctCode)) &&(cctrCodeReco.equalsIgnoreCase(cctrCode)))
												if((acctCodeReco.equalsIgnoreCase(acctCode)) &&(cctrCodeReco.equalsIgnoreCase(cctrCode)))

												{
													System.out.println(" Search acctCodeReco & cctrCodeReco  Record found @ line no " +lineNo);
													status=true;
													flg=false;
													break;
													
												}
											}
											
											
											
											if(!status)
//											if(!(acctCodeReco.equalsIgnoreCase(acctCode)) &&(cctrCodeReco.equalsIgnoreCase(cctrCode)))
											{
												if(!isPreview)
												{ //if isPreview 
														sqlInsert =" insert into misc_drcr_rdet "
																+" (tran_id,line_no,acct_code,cctr_code,amount,emp_code,anal_code)"
																+" values (?,?,?,?,?,?,?)";
														pstmtInsert=conn.prepareStatement(sqlInsert);
		//												if(status && flg)
		//												{
															miscRdetListMap = new HashMap();
															miscRdetListMap = (HashMap) miscRdetList.get(miscRdetList.size()-1);
															lineNo = (String) miscRdetListMap.get("line_no");
		//													flg=false;
															System.out.println("lineNo status" +lineNo +status);
		//												}
														lineNo = (new Integer (Integer.parseInt(lineNo)+1)).toString() ;
														//	lineNo = lineNo +1;
														//for testing 
		//												if(cctrCodeReco ==null)
		//												{
		//													cctrCodeReco="";
		//												}
														//for testing 
														pstmtInsert.setString(1,tranId);
														pstmtInsert.setString(2,lineNo);
														pstmtInsert.setString(3,acctCodeReco);
														pstmtInsert.setString(4,cctrCodeReco);
														pstmtInsert.setDouble(5,recoAmt);
														pstmtInsert.setString(6,"");
														pstmtInsert.setString(7,"");
														pstmtInsert.addBatch();
											}
												//adding values to miscRdetListMap
												miscRdetMap = new HashMap();
												miscRdetMap.put("tran_id", tranId);
												miscRdetMap.put("line_no", lineNo);
												miscRdetMap.put("acct_code", lineNo);
												miscRdetMap.put("acct_code",acctCodeReco);
												miscRdetMap.put("cctr_code",cctrCodeReco);
												miscRdetMap.put("amount",(recoAmt));
												miscRdetMap.put("emp_code","");
												miscRdetMap.put("anal_code","");
												miscRdetList.add(miscRdetMap);
												
											
											}
											else
											{
												if(!isPreview){ //if isPreview 
										
//												sqlInner =" update MISC_DRCR_RDET set amount = ? where tran_id = ? and line_no = ? ";
												
												sqlInner =" update MISC_DRCR_RDET set amount = amount + ? where tran_id = ? and line_no = ? ";

												pstmtInner = conn.prepareStatement(sqlInner);
//												pstmtInner.setDouble(1,amt);
												pstmtInner.setDouble(1,recoAmt);
												pstmtInner.setString(2,tranId);
												pstmtInner.setString(3,lineNo);
												
												updCnt = pstmtInner.executeUpdate();
												if(updCnt <1)
												{
													throw new Exception("UpdateFail");
												}
												pstmtInner.close();
												
												pstmtInner = null;
											}
												// modify Map for these new values
												miscRdetListMap = new HashMap(); 
												miscRdetListMap = (HashMap)miscRdetList.get(foundAt);

												miscRdetMap = new HashMap();
												miscRdetMap.put("line_no",miscRdetListMap.get("line_no"));
												miscRdetMap.put("acct_code",miscRdetListMap.get("acct_code"));
												miscRdetMap.put("cctr_code",miscRdetListMap.get("cctr_code"));
												miscRdetMap.put("amount",((Double)miscRdetListMap.get("amount") +recoAmt));
												miscRdetMap.put("anal_code",miscRdetListMap.get("anal_code"));
												miscRdetMap.put("emp_code",miscRdetListMap.get("emp_code"));
												miscRdetMap.put("net_amt",miscRdetListMap.get("net_amt"));
												miscRdetMap.put("tax_amt",miscRdetListMap.get("tax_amt"));
												miscRdetMap.put("tax_class",miscRdetListMap.get("tax_class"));
												miscRdetMap.put("tax_chap",miscRdetListMap.get("tax_chap"));
												miscRdetMap.put("tax_env",miscRdetListMap.get("tax_env"));
												miscRdetMap.put("reas_code",miscRdetListMap.get("reas_code"));
												miscRdetMap.put("ref_no",miscRdetListMap.get("ref_no"));
												miscRdetMap.put("item_code",miscRdetListMap.get("item_code"));
												miscRdetMap.put("quantity",miscRdetListMap.get("line_no"));
												miscRdetMap.put("rate",miscRdetListMap.get("rate"));
												miscRdetMap.put("line_no__sret",miscRdetListMap.get("line_no__sret"));
												miscRdetMap.put("line_no__invtrace",miscRdetListMap.get("line_no__invtrace"));
												miscRdetMap.put("lot_no",miscRdetListMap.get("lot_no"));
												miscRdetMap.put("lot_sl",miscRdetListMap.get("lot_sl"));
												miscRdetMap.put("analysis1",miscRdetListMap.get("analysis1"));
												miscRdetMap.put("analysis2",miscRdetListMap.get("analysis2"));
												miscRdetMap.put("analysis3",miscRdetListMap.get("analysis3"));
												miscRdetList.add(foundAt,miscRdetMap );
												
												//end

												
											}
									//}//end of isPreview condition
//										}
									}// end while
									
                          if(!isPreview){
								 if(pstmtInsert !=null)
									 {
										 batchCount =pstmtInsert.executeBatch();
										 System.out.println("nos of row inserted "+batchCount.length);
										 pstmtInsert.close();
										 pstmtInsert =null;
										 
									 }

									rs.close();
									rs = null;
									pstmt.close();
									pstmt = null;
                                   }
                           if(!isPreview)
                           {
									if(("C".equalsIgnoreCase(sundryType)) && (adjMiscCrn != null))
									{
										if(("AI".equalsIgnoreCase(adjMiscCrn.trim())) || ("AC".equalsIgnoreCase(adjMiscCrn.trim())))
										{
											errString = this.gbfPopuMiscDrcrRcpAdj(tranId,miscRcpMap,adjMiscCrn,miscRcpInvList,isPreview,conn);
											if(errString != null && errString.trim().length() > 0)
											{
												return errString;
											}
										}
										else if (("MI".equalsIgnoreCase(adjMiscCrn.trim())) || ("MC".equalsIgnoreCase(adjMiscCrn.trim())))
										{
											for (int ctr =0; ctr< miscRcpInvList.size(); ctr++)
											{
												miscRcpInvListMap = new HashMap();
												miscRcpInvListMap = (HashMap) miscRcpInvList.get(ctr);
											
												adjRefNo = (String)miscRcpInvListMap.get("ref_no");
												adjRefSer = (String)miscRcpInvListMap.get("ref_ser");
												adjAmt = Double.parseDouble(miscRcpInvListMap.get("adv_amt").toString());
												tot = tot + adjAmt;
												
//												sql =" select count(*) from receivables "
//													+" where cust_code = ? and tran_ser = ? and ref_no = ?";
//												pstmt = conn.prepareStatement(sql);
//												pstmt.setString(1,sundryCode);
//												pstmt.setString(2,adjRefSer);
//												pstmt.setString(3,adjRefNo);
//												rs = pstmt.executeQuery();
//												if(rs.next())
//												{    
//													cnt = rs.getInt(1);
//												}
//												rs.close();
//												rs= null;
//												pstmt.close();
//												pstmt=null;
//												
//												if (cnt == 0)
//												{
//													errString = itmDBAccessEJB.getErrorString("","VMREF1","","",conn);
//													return errString;
//												}
												sql =" select (tot_amt - adj_amt) amt,tot_amt,adj_amt from receivables " 
													+" where cust_code = ? and tran_ser = ?	and ref_no = ? ";
												
												pstmt = conn.prepareStatement(sql);
												pstmt.setString(1,sundryCode);
												pstmt.setString(2,adjRefSer);
												pstmt.setString(3,adjRefNo);
												rs = pstmt.executeQuery();
												if(rs.next())
												{    
													recAmt = rs.getDouble("amt");
													totAmt = rs.getDouble("tot_amt");
													recAdjAmt = rs.getDouble("adj_amt");
												}else
												{
													System.out.println("NO record found in receivables ");
													errString = itmDBAccessEJB.getErrorString("","VTNOREC2","","",conn);
													return errString;

												}
												rs.close();
												rs= null;
												pstmt.close();
												pstmt=null;
												
												if((Math.abs(recAdjAmt+adjAmt)) > Math.abs(totAmt))
												{
													errString = itmDBAccessEJB.getErrorString("","VTRECBAL","","",conn);
													return errString;
												}
											}//end of for
											
											if(sreturnNo != null)
											{
												sql =" select cust_code from sreturn where tran_id = ? ";
												pstmt = conn.prepareStatement(sql);
												pstmt.setString(1,sreturnNo);
												
												rs = pstmt.executeQuery();
												if(rs.next())
												{    
													custCode = rs.getString("cust_code");
												}
												rs.close();
												rs= null;
												pstmt.close();
												pstmt=null;
												
												if(custCode.trim() != sundryCode.trim())
												{
													errString = itmDBAccessEJB.getErrorString("","VTCUSTCD","","",conn);
													return errString;
												}
												if("MI".equalsIgnoreCase(adjMiscCrn.trim())) 
												{
													sql =" select item_ser from sreturn where tran_id = ?";
													pstmt = conn.prepareStatement(sql);
													pstmt.setString(1,sreturnNo);
													
													rs = pstmt.executeQuery();
													if(rs.next())
													{    
														itemSr = rs.getString("item_ser");
													}
													rs.close();
													rs= null;
													pstmt.close();
													pstmt=null;
													
													if(itemSer.trim() != itemSr.trim())
													{
														errString = itmDBAccessEJB.getErrorString("","VTRITMSER","","",conn);
														return errString;
													}
												}
											} 
											amt = Double.parseDouble(miscRcpMap.get("amount").toString());
											if(amt < 0 && tot <= 0)
											{
												if(Math.abs(amt) < Math.abs(tot))
												{ 
													errString = itmDBAccessEJB.getErrorString("","VTRECAMT","","",conn);
													return errString;	
												}
//												else if(amt < tot)
//												{
//													errString = itmDBAccessEJB.getErrorString("","VTRECAMT","","",conn);
//													return errString;
//												}
												
											}
										} // end of MI or MC
									}// end of C is sundry Type
				               }//end of isPreview
									
									if(errString.length() == 0)
									{
										errString = this.gbfPostMiscDrcrRcp(tranId,miscRcpMap,miscRdetList,miscRcpInvList,xtraParams,conn,isPreview);
										if(errString != null && errString.trim().length() > 0)
										{
											return errString;
										}
									}

											}
										
									
				
		}

		
					catch(Exception e)
		{
			System.out.println("Exception :MiscDrcrConfirm :gbfRetrieveMiscDrcrRcp :SQLException :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		return errString;
	}
	
	//migration of gbfPopuMiscDrcrRcpAdj
	//populating automatic adjustment of advance of customer
	private	String gbfPopuMiscDrcrRcpAdj(String tranId,HashMap miscRcpMap,String adjMiscCrn,ArrayList miscRcpInvList,Boolean isPreview,Connection conn)throws RemoteException,ITMException
	{
		PreparedStatement pstmt = null;
		PreparedStatement pstmtInsert = null;
		ResultSet rs = null;
		ResultSet rsInsert = null;
		String sql = "",sqlInsert="";
		ConnDriver connDriver = null;
		String errString = "" ; 
//		GenericUtility genericUtility = null;
		ITMDBAccessEJB itmDBAccessEJB = null;
		FinCommon Fcommon = new FinCommon();
		DistCommon Dcommon = new DistCommon();
//		genericUtility = new GenericUtility();
		E12GenericUtility genericUtility = new E12GenericUtility();
		HashMap glTraceMap = null,miscRdetListMap = null;
		java.util.Date toDay = new java.util.Date();
		java.sql.Timestamp tDay = null;
			
		String date="",cust="",itemSer="",tranSer="",recNo="";
		double amt=0,adjAmt=0,totAdj=0;
		int line =0;
		int upd1=0;
		int []batchCount =null;
		HashMap<String, String>miscRcpInvMap=null;
		try
		{	
			System.out.println("<!@#> In gbfPopuMiscDrcrRcpAdj :::::::::::::::::::::::::::::::");
			date = Dcommon.getDisparams("999999","ADJ_CRN_ORD",conn);
			if("NULLFOUND".equalsIgnoreCase(date.trim()))
			{
				errString = "NULLFOUND";
				return errString;
			}
			else if("E".equalsIgnoreCase(date.trim()))
			{
				date = "eff_date";
			}
			else if("D".equalsIgnoreCase(date.trim()))
			{
				date = "due_date";
			}
			
			amt = Double.parseDouble(miscRcpMap.get("amount").toString());
			cust = (String)miscRcpMap.get("sundry_code");
			itemSer = (String)miscRcpMap.get("item_ser"); 
//			sqlInsert =" insert into misc_drcr_rcpinv "
//					+" (tran_id,line_no,ref_ser,ref_no,adj_amt,ref_bal_amt) "
//					+" values (?,?,?,?,?,?) ";
//			pstmtInsert = conn.prepareStatement(sqlInsert);
			
			if("AI".equalsIgnoreCase(adjMiscCrn))
			{
				sql =" select tran_ser,ref_no,(tot_amt - adj_amt) as amt from receivables " 
					+" where cust_code = ? and item_ser = ? "
					+" and (tot_amt - adj_amt) <> 0 and tran_ser ='S-INV' order by ? asc ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,cust);
				pstmt.setString(2,itemSer);
				pstmt.setString(3,date);
			}
			else if("AC".equalsIgnoreCase(adjMiscCrn))
			{
				sql =" select tran_ser,ref_no,(tot_amt - adj_amt) as amt from receivables "
					+" where cust_code = ? and (tot_amt - adj_amt) <> 0 "
					+" and tran_ser ='S-INV' order by ? asc " ;
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,cust);
				pstmt.setString(2,date);
			}					
			rs = pstmt.executeQuery();
			
			sqlInsert =" insert into misc_drcr_rcpinv "
					+" (tran_id,line_no,ref_ser,ref_no,adj_amt,ref_bal_amt) "
					+" values (?,?,?,?,?,?) ";
			
//			pstmtInsert = conn.prepareStatement(sqlInsert);
			pstmtInsert=null;
			while (rs.next())
			{
				miscRcpInvMap = new HashMap<String, String>();
				pstmtInsert = conn.prepareStatement(sqlInsert);

				tranSer = rs.getString("tran_ser");
				recNo = rs.getString("ref_no");
				adjAmt = rs.getDouble("amt");
				
				line =line+1;
				pstmtInsert.setString(1,tranId);
				pstmtInsert.setInt(2,line);
				pstmtInsert.setString(3,tranSer);
				pstmtInsert.setString(4,recNo.trim());
				miscRcpInvMap.put("line_no",line+"");
				miscRcpInvMap.put("ref_ser",tranSer);
				miscRcpInvMap.put("ref_no",recNo.trim());
				if(amt >= adjAmt)
				{
					totAdj = totAdj +adjAmt;
					pstmtInsert.setDouble(5,adjAmt);
					pstmtInsert.setDouble(6,adjAmt);
					amt = amt - adjAmt;
					miscRcpInvMap.put("adj_amt",adjAmt+"");
					miscRcpInvMap.put("ref_bal_amt",adjAmt+"");
				}
				else
				{
					totAdj = totAdj + amt;
					pstmtInsert.setDouble(5,amt);
					pstmtInsert.setDouble(6,adjAmt);
					miscRcpInvMap.put("adj_amt",amt+"");
					miscRcpInvMap.put("ref_bal_amt",adjAmt+"");
							
				}
				pstmtInsert.addBatch();
				
				 
			
				//miscRcpInvMap.put("adj_amt",adjAmt);
				//miscRcpInvMap.put("ref_bal_amt",refBalAmt);
				miscRcpInvMap.put("mrp_value__adj","0");
				
				miscRcpInvList.add(miscRcpInvMap);
//				pstmtInsert.executeBatch();
//				upd1 = pstmtInsert.executeUpdate();
//				if(upd1<1)
//				{
//					throw new Exception("UpdateFail");
//				}

		
			}//end of while
			if(!isPreview)
			{
				if(pstmtInsert !=null)
				{
					batchCount =pstmtInsert.executeBatch();
					System.out.println("Nos of row updated " +batchCount.length);
	
				}
	
				
				pstmtInsert.close();
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			sql =" update misc_drcr_rcp set adj_amount = ? where tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setDouble(1,totAdj);
			pstmt.setString(2,tranId);
			upd1 = pstmt.executeUpdate();
			if(upd1<1)
			{
				throw new Exception("UpdateFail");  
			}
			pstmt.close();
			pstmt = null;
		
		}// end of try
		catch(SQLException e)
		{
			System.out.println("Exception :MiscDrcrConfirm :gbfPopuMiscDrcrRcpAdj :SQLException :==>\n"+e.getMessage());
			errString = genericUtility.createErrorString(e);
			throw new ITMException(e);
		}		
		catch (Exception e)
		{
			System.out.println("Exception :MiscDrCrRcpConf :gbfPopuMiscDrcrRcpAdj :==>"+e.getMessage());
			errString = genericUtility.createErrorString(e);
			throw new ITMException(e);
		}
		finally
		{
			try
			{				
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(rsInsert != null)
				{
					rsInsert.close();
					rsInsert = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(pstmtInsert != null)
				{
					pstmtInsert.close();
					pstmtInsert = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception : "+e);e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
	}
	// migration gbf_post_misc_drcr_rcphdr
	private	String gbfPostMiscDrcrRcphdr(String tranId,HashMap miscRcpMap,String xtraParams,Connection conn,boolean isPreview)throws RemoteException,ITMException
	{
		System.out.println("Inside gbfPostMiscDrcrRcphdr......value of Ispreview****"+isPreview);
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "",errString = "" ;
		 
//		GenericUtility genericUtility = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		ITMDBAccessEJB itmDBAccessEJB = null;
		FinCommon Fcommon = new FinCommon();
//		genericUtility = new GenericUtility();
		HashMap glTraceMap = null,sundryBalMap = null,receivablesMap = null;
		java.util.Date toDay = new java.util.Date();
		java.sql.Timestamp tDay = null;
		
		String loginEmpCode="",gRefId="",tranSer="",winName="",ediOption="",acctCodePay="",siteCode="";
		String drcrFlag="",sType="",sCode="",sretNo="",confirm="",siteCodeFor="",cctrCodePay="";
		double amount=0,drAmt=0,crAmt=0,mrpValue=0;
		int cnt=0;
		int upd=0;
		 
		try
		{
			System.out.println("<!@#> In gbfPostMiscDrcrRcphdr :::::::::::::::::::::::::::::::");

			itmDBAccessEJB = new ITMDBAccessEJB();
			tDay = new java.sql.Timestamp(toDay.getTime());
			loginEmpCode =  genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			glTraceMap = new HashMap();
			sundryBalMap = new HashMap();
			drcrFlag = (String)miscRcpMap.get("drcr_flag");
			amount =Double.parseDouble(miscRcpMap.get("amount").toString());
			//System.out.println("HDR amount=="+amount);
//above row 			
//			sql = "select count(*) from misc_drcr_rcp where tran_id = ? ";
//			pstmt = conn.prepareStatement(sql);
//			pstmt.setString(1,tranId);
//			rs = pstmt.executeQuery();
//			if(rs.next())
//			{
//				cnt = rs.getInt(1);
//			}
//			rs.close();
//			rs = null;
//			pstmt.close();
//			pstmt= null;
			
			glTraceMap.put("tran_date",(miscRcpMap.get("tran_date") == null ? "":miscRcpMap.get("tran_date")));
			glTraceMap.put("eff_date",(miscRcpMap.get("eff_date") == null ? "":miscRcpMap.get("eff_date")));
			glTraceMap.put("fin_entity",(miscRcpMap.get("fin_entity") == null ? "":miscRcpMap.get("fin_entity")));
			glTraceMap.put("site_code",(miscRcpMap.get("site_code") == null ? "":miscRcpMap.get("site_code")));
			glTraceMap.put("sundry_type",(miscRcpMap.get("sundry_type")));
			glTraceMap.put("sundry_code",(miscRcpMap.get("sundry_code") == null ? "":miscRcpMap.get("sundry_code")));
			System.out.println("<!@#>acount code"+miscRcpMap.get("acct_code"));
			glTraceMap.put("acct_code",(miscRcpMap.get("acct_code")));
			glTraceMap.put("cctr_code",(miscRcpMap.get("cctr_code") == null ? "":miscRcpMap.get("cctr_code")));
			glTraceMap.put("emp_code","");
			glTraceMap.put("anal_code","");
			glTraceMap.put("curr_code",(miscRcpMap.get("curr_code")));
			glTraceMap.put("exch_rate",(miscRcpMap.get("exch_rate")));
//added on 18/07/12
			System.out.println("<!@#>:::::::::::::miscRcpMap.get(eff_date)" +miscRcpMap.get("eff_date"));
//			glTraceMap.put("ref_date",(miscRcpMap.get("eff_date") == null ? "":miscRcpMap.get("eff_date")));
//			glTraceMap.put("due_date",(miscRcpMap.get("due_date") == null ? "":miscRcpMap.get("due_date")));
//			glTraceMap.put("ref_no",tranId);
			
//end			
			if("D".equalsIgnoreCase(drcrFlag))
			{
				glTraceMap.put("dr_amt",amount);
				glTraceMap.put("cr_amt","0");
				//added on19/07/12
				miscRcpMap.put("tot_amt", amount);
				
				
			}
			else
			{
				glTraceMap.put("cr_amt",amount);
				glTraceMap.put("dr_amt","0");
				//added on19/07/12
				miscRcpMap.put("tot_amt", (0 - amount));
			}
			glTraceMap.put("ref_type","F");
			glTraceMap.put("ref_id",tranId);
			glTraceMap.put("ref_ser",(miscRcpMap.get("tran_ser")));
			glTraceMap.put("remarks",(miscRcpMap.get("remarks")));
			System.out.println("<!@#>going gbfPostMiscDrcrRcphdr::::::::::: glTraceUpdate");
			errString = Fcommon.glTraceUpdate(glTraceMap,conn,isPreview);
			System.out.println("<!@#>going gbfPostMiscDrcrRcphdr::::::::::: glTraceUpdate errString" +errString);
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}
			String sundryTypeGl = (String)glTraceMap.get("sundry_type");
				
			if(!isPreview)
			{
			if(!("O".equalsIgnoreCase(sundryTypeGl)))
			{
				sundryBalMap.put("tran_date",miscRcpMap.get("tran_date"));
				sundryBalMap.put("eff_date",miscRcpMap.get("eff_date"));
				sundryBalMap.put("fin_entity",miscRcpMap.get("fin_entity"));
				sundryBalMap.put("site_code",miscRcpMap.get("site_code"));
				sundryBalMap.put("sundry_type",glTraceMap.get("sundry_type"));
				sundryBalMap.put("sundry_code",miscRcpMap.get("sundry_code"));
				sundryBalMap.put("acct_code",glTraceMap.get("acct_code"));
				sundryBalMap.put("cctr_code",glTraceMap.get("cctr_code"));
				sundryBalMap.put("curr_code",miscRcpMap.get("curr_code"));
				sundryBalMap.put("exch_rate",miscRcpMap.get("exch_rate"));
				
				if("D".equalsIgnoreCase(drcrFlag))
				{
					drAmt = amount;
					crAmt = 0;
				}
				else
				{
					drAmt = 0;
					crAmt = amount;
				}
				
				sundryBalMap.put("dr_amt",drAmt);
				sundryBalMap.put("cr_amt",crAmt);
				sundryBalMap.put("adv_amt",0.0);
//				sType = (String)sundryBalMap.get("sundry_type");
				sCode = (String)sundryBalMap.get("sundry_code");
//				if(sType != null)
//				{
					
					sundryBalMap.put("contact_code",Fcommon.getContactCode(sundryTypeGl,sCode,conn));
//				}
//				else
//				{
//					sundryBalMap.put("contact_code","");
//				}
				System.out.println("<!@#>going gbfPostMiscDrcrRcphdr::::::::::: gbf_sundrybal_upd");
				errString = Fcommon.gbf_sundrybal_upd(sundryBalMap,conn);	
				System.out.println("<!@#>going gbfPostMiscDrcrRcphdr::::::::::: gbf_sundrybal_upd errString"+errString);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
			}
			
			}
////genrating key for receivables	
////insert into receivables 33
//			sql="insert into receivables (tran_id, tran_ser, tran_date, ref_no, ref_date, " + 
//				"curr_code, exch_rate, cust_code, acct_code, cctr_code, " +
//				"due_date, fin_entity, site_code, tot_amt, adj_amt, " + 
//				"discount, tax_amt, auto_rcp, bank_code, recd, " +
//				"ref_type, cr_term, sales_pers, item_ser, status, stat_date, " +
//				"sales_pers__1, sales_pers__2, contact_code, eff_date,fin_scheme, ref_ser__org,sale_order) values (" +
//				" ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
//			pstmt = conn.prepareStatement(sql);
//			pstmt.setString(1,"");//
//			pstmt.setString(2,(String)miscRcpMap.get("tran_ser") );
//			pstmt.setString(3,"" );//
//			pstmt.setString(4, (String)miscRcpMap.get("ref_no"));
//			pstmt.setString(5, (String)miscRcpMap.get("ref_date"));
//			pstmt.setString(6, (String)miscRcpMap.get("curr_code"));
//			pstmt.setString(7, (String)miscRcpMap.get("exch_rate"));
//			pstmt.setString(8, (String)miscRcpMap.get("cust_code"));
//			pstmt.setString(9, (String)miscRcpMap.get("acct_code"));
//			pstmt.setString(10,(String)miscRcpMap.get("cctr_code"));
//			pstmt.setString(11,(String)miscRcpMap.get("due_date"));
//			pstmt.setString(12,(String)miscRcpMap.get("fin_entity"));
//			pstmt.setString(13,(String)miscRcpMap.get("tot_amt"));
//			pstmt.setString(14,(String)miscRcpMap.get("adj_amt"));
//			pstmt.setString(15,(String)miscRcpMap.get("discount"));
//			pstmt.setString(16,(String)miscRcpMap.get("tax_amt"));
//			pstmt.setString(17,(String)miscRcpMap.get("auto_rcp"));
//			pstmt.setString(18,(String)miscRcpMap.get("bank_code"));
//			pstmt.setString(19,(String)miscRcpMap.get("recd"));
//			pstmt.setString(20,(String)miscRcpMap.get("ref_type"));
//			pstmt.setString(21,(String)miscRcpMap.get("cr_term"));
//			pstmt.setString(22,(String)miscRcpMap.get("sales_pers"));
//			pstmt.setString(23,(String)miscRcpMap.get("item_ser"));
//			pstmt.setString(24,(String)miscRcpMap.get("status"));
//			pstmt.setString(25,(String)miscRcpMap.get("stat_date"));
//			pstmt.setString(26,(String)miscRcpMap.get("sales_pers__1"));
//			pstmt.setString(27,(String)miscRcpMap.get("sales_pers__2"));
//			pstmt.setString(28,(String)miscRcpMap.get("contact_code"));
//			pstmt.setString(29,(String)miscRcpMap.get("eff_date"));
//			pstmt.setString(30,(String)miscRcpMap.get("fin_scheme"));
//			pstmt.setString(31,(String)miscRcpMap.get("ref_ser__org"));
//			pstmt.setString(32,(String)miscRcpMap.get("sale_order"));
//			
//			
//			
//			
//			upd =pstmt.executeUpdate();
//			if(upd <1)
//			{
//				throw new Exception("InsertFail");
//			}
			System.out.println("<!@#>going gbfPostMiscDrcrRcphdr::::::::::: gbfReceivablesUpd");
			miscRcpMap.put("ref_date",(miscRcpMap.get("eff_date") == null ? "":miscRcpMap.get("eff_date")));
			miscRcpMap.put("auto_rcp","N");
			miscRcpMap.put("bank_code",null);
			miscRcpMap.put("ref_type",(miscRcpMap.get("tran_type") == null ? "":miscRcpMap.get("tran_type")));
			miscRcpMap.put("cr_term",null);
			miscRcpMap.put("sales_pers",null);
			miscRcpMap.put("tax_amt",0.0);
			miscRcpMap.put("discount",0.0);
			miscRcpMap.put("ref_no",tranId);
			
			//item_ser already present
			sretNo=(String)miscRcpMap.get("sreturn_no");
			if(sretNo !=null && sretNo.trim().length() >0)
			{
				sql="select sum(case when mrp_value is null then 0 else mrp_value end) "+
					 " from sreturndet where tran_id = ? ";
				pstmt=conn.prepareStatement(sql);
				pstmt.setString(1, sretNo);
				rs=pstmt.executeQuery();
				if(rs.next())
				{
					mrpValue =rs.getDouble(1);
				}
				rs.close();
				rs=null;
				pstmt.close();
				pstmt=null;
			}
			miscRcpMap.put("mrp_value",mrpValue);
			
			
//			miscRcpMap.put("ref_no",tranId);
          if(!isPreview)
          {//if isPreview is true
			errString = Fcommon.gbfReceivablesUpd(miscRcpMap,conn);	
			System.out.println("<!@#>going gbfPostMiscDrcrRcphdr::::::::::: gbfReceivablesUpd errString"+errString);
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}
        
			//
// as per discussion with Shri Mam
//			confirm = (String)miscRcpMap.get("confirmed");
//			gRefId = (String)glTraceMap.get("ref_id");
//						
//			if(!("Y".equalsIgnoreCase(confirm)))
//			{
				sql =" update misc_drcr_rcp set confirmed = ?,conf_date = ?, "
					+" emp_code__aprv = ? 	where tran_id = ? " ;  
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,"Y");
				pstmt.setTimestamp(2,tDay);
				pstmt.setString(3,loginEmpCode);
//				pstmt.setString(3,gRefId);
				pstmt.setString(4,tranId);
				upd = pstmt.executeUpdate();
				if(upd <1)
				{
					throw new Exception("UpdateFail");
				}
				pstmt.close();
				pstmt = null;
				
          }//end of isPreview Condition
//			}
			// the window for cr/dr are now seperate, to take respective values as per tran_ser
//			tranSer =(String)miscRcpMap.get("tran_ser");
//			if("MDRCRC".equalsIgnoreCase(tranSer))
//			{
//				winName = "w_misc_drcr_rcp_cr";
//			}
//			else if ("MDRCRD".equalsIgnoreCase(tranSer))
//			{
//				winName = "w_misc_drcr_rcp_dr";
//			}
			
			//edi calculation not needed as per discussion with KB Sir
		}// end of try
		catch(SQLException e)
		{
			System.out.println("Exception :MiscDrCrRcpConf :gbfPostMiscDrcrRcphdr :SQLException :==>\n"+e.getMessage());
			errString = genericUtility.createErrorString(e);
			throw new ITMException(e);
		}		
		catch (Exception e)
		{
			System.out.println("Exception :MiscDrCrRcpConf :gbfPostMiscDrcrRcphdr :==>"+e.getMessage());
			errString = genericUtility.createErrorString(e);
			throw new ITMException(e);
		}
		finally
		{
			try
			{				
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception : "+e);e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
	} // end of method hdr
	
	//migration gbf_post_misc_drcr_rcp_det
	
	private	String gbfPostMiscDrcrRcpdet(String tranId,HashMap miscRcpMap,ArrayList miscRdetList,String xtraParams,Connection conn,boolean isPreview)throws RemoteException,ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "",errString = "" ; 
//		GenericUtility genericUtility = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		ITMDBAccessEJB itmDBAccessEJB = null;
		FinCommon Fcommon = new FinCommon();
//		genericUtility = new GenericUtility();
		HashMap glTraceMap = null,miscRdetListMap = null;
		java.util.Date toDay = new java.util.Date();
		java.sql.Timestamp tDay = null;
					
		String acctCode="",cctrCode="",empCode="",analCode="",anal1="",anal2="",anal3="",drcrFlag="";
		double amount =0;
		
		try
		{
			System.out.println("<!@#> In gbfPostMiscDrcrRcpdet ::::::::::::::::::::::::::::isPreview value:::"+isPreview);

			itmDBAccessEJB = new ITMDBAccessEJB();
			tDay = new java.sql.Timestamp(toDay.getTime());
			glTraceMap = new HashMap();
			drcrFlag = (String)miscRcpMap.get("drcr_flag");
			System.out.println("DetailList Size *****"+miscRdetList.size());
			for (int ctr =0; ctr < miscRdetList.size(); ctr++)
			{
				miscRdetListMap = new HashMap();
				miscRdetListMap = (HashMap) miscRdetList.get(ctr);

				acctCode = (String)miscRdetListMap.get("acct_code");
				cctrCode = (String)miscRdetListMap.get("cctr_code");
				//for testing
				System.out.println("<!@#>cctrCode:" +cctrCode + ":");
				//				if(cctrCode == null || cctrCode.trim().length()==0) 
				//				{
				//					cctrCode="A101";	
				//				}
				empCode = (String)miscRdetListMap.get("emp_code");
				analCode = (String)miscRdetListMap.get("anal_code");
				//				amount = Double.parseDouble(miscRdetListMap.get("amount").toString());
				amount = (Double)miscRdetListMap.get("amount");
				System.out.println("Det amount=="+amount);
				if(amount != 0) //added by kunal on 21/mar/14 
				{
					anal1 = (String)miscRdetListMap.get("analysis1");
					anal2 = (String)miscRdetListMap.get("analysis2");
					anal3 = (String)miscRdetListMap.get("analysis3");

					glTraceMap.put("tran_date",(miscRcpMap.get("tran_date")));
					glTraceMap.put("eff_date",(miscRcpMap.get("eff_date")));
					glTraceMap.put("fin_entity",(miscRcpMap.get("fin_entity")));
					glTraceMap.put("site_code",(miscRcpMap.get("site_code")));
					glTraceMap.put("sundry_type","O"); //hard coded as it is in code
					glTraceMap.put("sundry_code"," ");
					System.out.println("<!@#>acount code det " + acctCode);
					glTraceMap.put("acct_code",acctCode);
					glTraceMap.put("cctr_code",cctrCode);
					glTraceMap.put("emp_code",empCode);
					glTraceMap.put("anal_code",analCode);
					glTraceMap.put("curr_code",(miscRcpMap.get("curr_code")));
					glTraceMap.put("exch_rate",(miscRcpMap.get("exch_rate")));
					if("D".equalsIgnoreCase(drcrFlag))
					{
						if(amount > 0)
						{
							glTraceMap.put("dr_amt","0");
							glTraceMap.put("cr_amt",amount);
						}
						else
						{
							glTraceMap.put("dr_amt",(0 - amount));
							glTraceMap.put("cr_amt","0");
						}
					}
					else
					{
						if(amount > 0)
						{
							glTraceMap.put("dr_amt",amount);
							glTraceMap.put("cr_amt","0");
						}
						else
						{
							glTraceMap.put("dr_amt","0");
							glTraceMap.put("cr_amt",(0 - amount));
						}
					}
					glTraceMap.put("ref_type","F");
					glTraceMap.put("ref_id",tranId);
					glTraceMap.put("ref_ser",(miscRcpMap.get("tran_ser")));
					glTraceMap.put("remarks",(miscRcpMap.get("remarks")));
					glTraceMap.put("analysis1",anal1);
					glTraceMap.put("analysis2",anal2);
					glTraceMap.put("analysis3",anal3);

					System.out.println("<!@#> In gbfPostMiscDrcrRcpdet :::::::::::::::::::::::glTraceUpdate");
					errString = Fcommon.glTraceUpdate(glTraceMap,conn,isPreview);
					System.out.println("<!@#> In gbfPostMiscDrcrRcpdet :::::::::::::::::::::::glTraceUpdate errString "+errString);
					if(errString != null && errString.trim().length() > 0)
					{
						return errString;
					}
				}
			}//end of for
		}//end of try
		catch (Exception e)
		{
			System.out.println("Exception :MiscDrCrRcpConf :gbfPostMiscDrcrRcpdet :==>"+e.getMessage());
			errString = genericUtility.createErrorString(e);
			throw new ITMException(e);
		}
		finally
		{
			try
			{				
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception : "+e);e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
	} //end of method det

	//migration of gbf_post_misc_drcr_adj_det
	private	String gbfPostMiscDrcrAdjdet(String tranId,HashMap miscRcpMap,ArrayList miscRcpInvList,String xtraParams,Connection conn)throws RemoteException,ITMException
	{
		PreparedStatement pstmt = null;
		PreparedStatement pstmtInner = null;
		ResultSet rs = null;
		ResultSet rsInner = null;
		String sql = "",sqlInner ="";
		String errString = "" ;
		int upd=0;
		
		
		HashMap advListMap =null;
		
		String refSerHdr="",cust="",refSer="",refNo="";
		double totAdjAmt=0,amount=0,mrpValueAdj=0,adjAmt=0,totAmt=0;
		double totAdjAmtDet=0.0;
		try
		{
			System.out.println("<!@#> In gbfPostMiscDrcrAdjdet :::::::::::::::::::::::::::::::");

			refSerHdr = (String)miscRcpMap.get("tran_ser");
			cust = (String)miscRcpMap.get("sundry_code");
			
			for (int ctr =0; ctr < miscRcpInvList.size(); ctr++)
			{
				advListMap = new HashMap();
				advListMap = (HashMap) miscRcpInvList.get(ctr);
				
				refSer = (String)advListMap.get("ref_ser");
				refNo = (String)advListMap.get("ref_no");	
				amount =(Double)advListMap.get("adj_amt");
				mrpValueAdj = (Double)advListMap.get("mrp_value__adj");
				
				totAdjAmt = amount;
				
				totAdjAmtDet= totAdjAmtDet + amount; //Code Added by Sagar on 17/Nov/15 for flat booking cancellation(DI3HDOS006) of dosti project 
				System.out.println(">>>>>>In gbfPostMiscDrcrAdjdet amount:"+amount);
				
				sql =" update receivables "
					+" set adj_amt = case when adj_amt is null then 0 else adj_amt end + ? , "
					+" mrp_value = case when mrp_value is null then 0 else mrp_value end - ? "
					+" where tran_ser = ? and ref_no = ? ";
			
				pstmt = conn.prepareStatement(sql);
				pstmt.setDouble(1,amount);
				pstmt.setDouble(2,mrpValueAdj);
				pstmt.setString(3,refSer);
				pstmt.setString(4,refNo);
				upd = pstmt.executeUpdate();
				if(upd <1)
				{
					throw new Exception("UpdateFail");
				}
				pstmt.close();
				pstmt = null;
				
				//check for total adjustment
				sql =" select adj_amt,tot_amt from receivables "
					+" where tran_ser = ? and ref_no = ? " ;
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,refSer);
				pstmt.setString(2,refNo);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					adjAmt = rs.getDouble("adj_amt");
					totAmt = rs.getDouble("tot_amt");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				
				if(adjAmt == totAmt)
				{
					sql =" update receivables set status = ? "
						+" where tran_ser = ? and ref_no = ? " ;
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,"A");
					pstmt.setString(2,refSer);
					pstmt.setString(3,refNo);
					upd = pstmt.executeUpdate();
					if(upd <1)
					{
						throw new Exception("UpdateFail");
					}
					pstmt.close();
					pstmt = null;
				}
			}//end of for
			
			System.out.println(">>>>>In MiscDrCrRcpConf fianl totAdjAmtDet:"+totAdjAmtDet);

			sql =" update receivables set adj_amt = case when adj_amt is null then 0 else adj_amt end + -1 * ? "
				+" where tran_ser = ? and ref_no = ? ";
			
			pstmt = conn.prepareStatement(sql);
			//pstmt.setDouble(1,totAdjAmt); // Comment added by sagar on 17/Nov/15 for flat booking cancellation(DI3HDOS006) of dosti project 
			pstmt.setDouble(1,totAdjAmtDet); // Code changed by sagar on 17/Nov/15 for flat booking cancellation(DI3HDOS006) of dosti project 
			pstmt.setString(2,refSerHdr);
			pstmt.setString(3,tranId);
			upd = pstmt.executeUpdate();
			if(upd <1)
			{
				throw new Exception("UpdateFail");
			}
			pstmt.close();
			pstmt = null;
			
			//check for total adjustment
			sql =" select adj_amt,tot_amt from receivables "
				+" where tran_ser = ? and ref_no = ? " ;
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,refSerHdr);
			pstmt.setString(2,tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				adjAmt = rs.getDouble("adj_amt");
				totAmt = rs.getDouble("tot_amt");
				
				if (adjAmt == totAmt)
				{
					sqlInner =" update receivables set status = ? "
						+" where tran_ser = ? and ref_no = ? "; 
					pstmtInner = conn.prepareStatement(sqlInner);
					pstmtInner.setString(1,"A");
					pstmtInner.setString(2,refSerHdr);
					pstmtInner.setString(3,tranId);
					upd = pstmtInner.executeUpdate();
					if(upd <1)
					{
						throw new Exception("UpdateFail");
					}
					pstmtInner.close();
					pstmtInner = null;
				}
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		
		}//end of try
		catch(SQLException e)
		{
			System.out.println("Exception :MiscDrCrRcpConf :gbfPostMiscDrcrAdjdet :SQLException :==>\n"+e.getMessage());
			errString = genericUtility.createErrorString(e);
			throw new ITMException(e);
		}		
		catch (Exception e)
		{
			System.out.println("Exception :MiscDrCrRcpConf :gbfPostMiscDrcrAdjdet :==>"+e.getMessage());
			errString = genericUtility.createErrorString(e);
			throw new ITMException(e);
		}
		finally
		{
			try
			{				
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(rsInner != null)
				{
					rsInner.close();
					rsInner = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(pstmtInner != null)
				{
					pstmtInner.close();
					pstmtInner = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception : "+e);e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
	}//end of adj method
	//migration gbf_post_misc_drcr_rcp
	//migration gbf_post_misc_drcr_rcp
	private	String gbfPostMiscDrcrRcp(String tranId,HashMap miscRcpMap,ArrayList miscRdetList,ArrayList miscRcpInvList,String xtraParams,Connection conn,boolean isPreview)throws RemoteException,ITMException
	{
		System.out.println("Inside gbfPostMiscDrcrRcp....... Value of isPreview*******"+isPreview);
		PreparedStatement pstmt = null;
		PreparedStatement pstmtIn = null;
		ResultSet rs = null;
		ResultSet rsIn = null;
		String sql = "",sqlIn ="",errString = "" ;
		ITMDBAccessEJB itmDBAccessEJB = null;
		FinCommon Fcommon = new FinCommon();
					
		String tranSer="",runMode = "I",invIbcaGen="",cust="",site="",siteRcv="",thisWin="",xmlString="";
		String keyString="",finEntFr="",finEntTo="",link ="",acctFr ="",cctrFr="",acctTo="",cctrTo="",itemSer="";
		String ibcaId="",remarks="",curr="",custI="",acct="",cctr="",autoRcp="",bank="",recd="",refType="";
		String crTerm="",itmSer="",spers="",spers1="",spers2="",custRefNo="",chgUser="",chgTerm="",tranType="";
		String siteCodeFor="";
		int upd =0;
		
		java.util.Date toDay = new java.util.Date();
		java.sql.Timestamp refDate = null;
		java.sql.Timestamp dueDate = null;
		java.sql.Timestamp tranDate = null;
		java.sql.Timestamp custRefDate = null;
		java.sql.Timestamp tDay = null;
			
		double exch=0,amount=0,discount=0,taxAmt=0,custRefAmt=0,amountBc=0;
		
		try
		{
			System.out.println("<!@#> In gbfPostMiscDrcrRcp ::::::: ::::::::::::::::::::::::");
			itmDBAccessEJB = new ITMDBAccessEJB();
			tranSer = (String)miscRcpMap.get("tran_ser");
			siteCodeFor = (String)miscRcpMap.get("site_code__drcr");
			System.out.println("<!@#> In gbfPostMiscDrcrRcp  tran_ser :::" +tranSer);
			System.out.println("<!@#> In gbfPostMiscDrcrRcp  siteCodeFor :::" +siteCodeFor);
		
			tDay = new java.sql.Timestamp(toDay.getTime());
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
			System.out.println("<!@#> In gbfPostMiscDrcrRcp  going into gbfPostMiscDrcrRcphdr:::");
			errString = this.gbfPostMiscDrcrRcphdr(tranId,miscRcpMap,xtraParams,conn,isPreview);
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}
			System.out.println("<!@#> In gbfPostMiscDrcrRcp  returning from gbfPostMiscDrcrRcphdr errString:::" +errString);
			System.out.println("<!@#> In gbfPostMiscDrcrRcp  going into gbfPostMiscDrcrRcpdet:::");
			errString = this.gbfPostMiscDrcrRcpdet(tranId,miscRcpMap,miscRdetList,xtraParams,conn,isPreview);
			System.out.println("<!@#> In gbfPostMiscDrcrRcp  returning from gbfPostMiscDrcrRcpdet errString:::" +errString);
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}
// ask to pravin 		
			if(!isPreview){ //if isPreview is true
			System.out.println("<!@#> In gbfPostMiscDrcrRcp  going into gbfPostMiscDrcrAdjdet:::");

			errString = this.gbfPostMiscDrcrAdjdet(tranId,miscRcpMap,miscRcpInvList,xtraParams,conn);
			System.out.println("<!@#> In gbfPostMiscDrcrRcp  returning from gbfPostMiscDrcrAdjdet errString:::" +errString);

			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}
			System.out.println("<!@#> In gbfPostMiscDrcrRcp  going into Fcommon.checkGlTranDrCr:::");			
			errString = Fcommon.checkGlTranDrCr(tranSer,tranId,conn);
			System.out.println("<!@#> In gbfPostMiscDrcrRcp  returning from Fcommon.checkGlTranDrCr:::" +errString);	
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}
			System.out.println("<!@#> In gbfPostMiscDrcrRcp  going into runMode:::" +runMode);
			if("I".equalsIgnoreCase(runMode))
			{
				invIbcaGen = Fcommon.getFinparams("999999","INV_IBCA_GEN",conn);
				
				if(invIbcaGen == "NULLFOUND")
				{ 
					invIbcaGen = "Y";
				}
								
				if("Y".equalsIgnoreCase(invIbcaGen))
				{
					// create ibca if site code in voucher does not match the rcv site of the customer
					cust = (String)miscRcpMap.get("sundry_code");
					site = (String)miscRcpMap.get("site_code");

					//if the receipt site not found in site customer master then take the site receipt from
					// customer master.
					sql =" select site_code__rcp from site_customer "
						+" where site_code = ? and cust_code = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,site);
					pstmt.setString(2,cust);
					rs = pstmt.executeQuery();
					if(rs.next())
					{     
						siteRcv = rs.getString("site_code__rcp");
					}
					else
					{
						sqlIn ="select site_code__rcp from customer where cust_code = ? ";
						pstmtIn = conn.prepareStatement(sqlIn);
						pstmtIn.setString(1,cust);
						rsIn = pstmtIn.executeQuery();
						if(rsIn.next())
						{
							siteRcv = rsIn.getString("site_code__rcp");
						}
						rsIn.close();
						rsIn = null;
						pstmtIn.close();
						pstmtIn = null;

					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					System.out.println("siteRcv From query is :::"+siteRcv);
					
					if((siteRcv == null) || (siteRcv.trim().length() == 0))
					{
						System.out.println("Inside siteRcv 1:::::");
						sql ="select site_code__rcp from customer where cust_code = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,cust);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							siteRcv = rs.getString("site_code__rcp");
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						System.out.println("Inside siteRcv 2:::::"+siteRcv);
					}
					// ibca start	
					if((siteRcv == null) || (siteRcv.trim().length() == 0))
					{
						siteRcv = site;
						System.out.println("Inside siteRcv 3:::::"+siteRcv);
					}
					
					//if((siteRcv.trim() != site.trim()) && ("I".equalsIgnoreCase(runMode)))
					
					if(!(siteRcv.trim().equalsIgnoreCase(site.trim())) && ("I".equalsIgnoreCase(runMode)))
					{
						thisWin = "W_RCP_IBCA";
						System.out.println("siteRcv :::::"+siteRcv);
						System.out.println("site :::::"+site);
						
						sql =" select key_string from transetup where upper(tran_window) = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, thisWin);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							keyString = rs.getString("key_string");
						}
						else
						{
							errString = itmDBAccessEJB.getErrorString("","VTSEQ","","",conn);
							return errString;
						}
						rs.close();
						rs=null;
						pstmt.close();
						pstmt=null;
						
						sql =" select fin_entity from site where site_code =? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,site);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							finEntFr = rs.getString("fin_entity");
						}
						else
						{
							errString = itmDBAccessEJB.getErrorString("","VMSITE","","",conn);
							return errString;
						}
						rs.close();
						rs=null;
						pstmt.close();
						pstmt=null;
						
						sql =" select fin_entity from site where site_code =? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,siteRcv);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							finEntTo = rs.getString("fin_entity");
						}
						else
						{
							errString = itmDBAccessEJB.getErrorString("","VMSITE","","",conn);
							return errString;
						}
						rs.close();
						rs=null;
						pstmt.close();
						pstmt=null;
						
						sql = "select link_type,acct_code__pay,cctr_code__pay,acct_code__rcp,cctr_code__rcp "
							+" from ibca_rcp_ctrl where site_code__from = ? and site_code__to = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,site);
						pstmt.setString(2,siteRcv);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							link = rs.getString("link_type");
							acctFr = rs.getString("acct_code__pay");
							//issue
							cctrFr = rs.getString("cctr_code__pay");
							System.out.println("<!@#> cctrFr :"+cctrFr+":");
							acctTo = rs.getString("acct_code__rcp");
							cctrTo = rs.getString("cctr_code__rcp");
							
						}
						else
						{
							errString = itmDBAccessEJB.getErrorString("","VTIBCA5","","",conn);
							return errString;
						}
						rs.close();
						rs=null;
						pstmt.close();
						pstmt=null;
						SimpleDateFormat sdf=new SimpleDateFormat(genericUtility.getApplDateFormat());
						xmlString = "<?xml version=\"1.0\"?>\r\n<Root>\r\n<header>"+
			                    "\r\n</header><Detail1><item_ser></item_ser>"+
			                    "\r\n<tran_date>"+sdf.format(new java.util.Date(toDay.getTime()))+"</tran_date>"+
								"\r\n<site_code__from>"+site+"</site_code__from>"+
								"\r\n<link_type>"+link+"</link_type></Detail1></Root>";
						System.out.println("xmlString : : : : :"+xmlString);
						CommonConstants.setIBASEHOME();
						TransIDGenerator tg = new TransIDGenerator(xmlString,"Base",CommonConstants.DB_NAME);
						ibcaId = tg.generateTranSeqID("R-IBCA","tran_id",keyString,conn);
						System.out.println("Generated Key :: "+ibcaId);
						
						if (ibcaId.indexOf("ERROR") > -1 )
						{
							errString = itmDBAccessEJB.getErrorString("","VTTRANID","","",conn);
						}
						remarks = "Auto IBCA transfer of Misc Dr/Cr Note of " +cust;
						
						sql =" select ref_date,curr_code,exch_rate,cust_code,acct_code,cctr_code,"
							+" due_date,tot_amt - adj_amt as amt ,discount,tax_amt,auto_rcp,bank_code, "
							+" recd,ref_type,cr_term,item_ser,sales_pers,sales_pers__1, "
							+" sales_pers__2,tran_date,cust_ref_no,cust_ref_date,cust_ref_amt "
							+" from receivables	where  tran_ser  like 'MDRCR%' " 
							+" and ref_no = ?" ;
						
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,tranId);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							refDate = rs.getTimestamp("ref_date");
							curr = rs.getString("curr_code");
							exch = rs.getDouble("exch_rate");
							custI = rs.getString("cust_code");
							acct = rs.getString("acct_code");
							cctr = rs.getString("cctr_code");
							dueDate = rs.getTimestamp("due_date");
							amount = rs.getDouble("amt");
							discount = rs.getDouble("discount");
							taxAmt = rs.getDouble("tax_amt");
							autoRcp = rs.getString("auto_rcp");
							bank = rs.getString("bank_code");
							recd = rs.getString("recd");
							refType = rs.getString("ref_type");
							crTerm = rs.getString("cr_term");
							itmSer = rs.getString("item_ser");
							spers = rs.getString("sales_pers");
							spers1 = rs.getString("sales_pers__1");
							spers2 = rs.getString("sales_pers__2");
							tranDate = rs.getTimestamp("tran_date");
							custRefNo = rs.getString("cust_ref_no");
							custRefDate = rs.getTimestamp("cust_ref_date");
							custRefAmt = rs.getDouble("cust_ref_amt");
						}
						rs.close();
						rs=null;
						pstmt.close();
						pstmt=null;
						//Modified by Rupesh on[09/11/2017][to compare amount value with double][Start].
						/*if(amount < 0)*/
						if(amount < 0d)
						//Modified by Rupesh on[09/11/2017][to compare amount value with double][End].	
						{
							tranSer ="MDRCRC";
						}
						else
						{
							tranSer="MDRCRD";
						}
						
						amountBc = amount * exch;
						if (amountBc != 0)
						{
							sql =" insert into rcp_ibca (tran_id,tran_date,eff_date,site_code__from,fin_entity__from, " 
								+" site_code__to,fin_entity__to,amount,curr_code,exch_rate,confirmed,acct_code__ifr, "
								+" cctr_code__ifr,acct_code__ito,cctr_code__ito,chg_date,chg_user,chg_term,amount__bc, "
								+" tran_type,tran_ser,link_type,remarks) "
								+" values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)" ;
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,ibcaId);
							pstmt.setTimestamp(2,tranDate);
							pstmt.setTimestamp(3,tranDate);
							pstmt.setString(4,site);
							pstmt.setString(5,finEntFr);
							pstmt.setString(6,siteRcv);
							pstmt.setString(7,finEntTo);
							pstmt.setDouble(8,amount);
							if(curr == null || curr.trim().length() == 0)
							{
								pstmt.setNull(9,Types.VARCHAR);
							}
							else
							{
								pstmt.setString(9,curr);
							}
							pstmt.setDouble(10,exch);
							pstmt.setString(11,"N");
							
							if(acctFr == null || acctFr.trim().length() == 0)
							{
								pstmt.setNull(12,Types.VARCHAR);
							}
							else
							{
								pstmt.setString(12,acctFr);
							}//issue
							System.out.println("<!@#> Setting cctrFr :"+cctrFr+":");
							if(cctrFr == null)
							{
								pstmt.setNull(13,Types.VARCHAR);
							}
							else
							{
								pstmt.setString(13,cctrFr);
							}
							if(acctTo == null )
							{
								pstmt.setNull(14,Types.VARCHAR);
							}
							else
							{
								pstmt.setString(14,acctTo);
							}
							if(cctrTo == null )
							{
								pstmt.setNull(15,Types.VARCHAR);
							}
							else
							{
								pstmt.setString(15,cctrTo);
							}
							
							pstmt.setTimestamp(16,tDay);
							pstmt.setString(17,chgUser); 
							pstmt.setString(18,chgTerm); 
							pstmt.setDouble(19,amountBc);
							pstmt.setString(20,tranType); 
							pstmt.setString(21,"I");
							if(link == null || link.trim().length() == 0)
							{
								pstmt.setNull(22,Types.VARCHAR);
							}
							else
							{
								pstmt.setString(22,link);
							}
							pstmt.setString(23,remarks);
							upd =pstmt.executeUpdate();
							if(upd <1)
							{
								throw new Exception("UpdateFail");
							}
							pstmt.close();
							
							sql =" insert into rcp_ibca_det (tran_id,ref_ser,ref_no,ref_date,curr_code, "
								+" exch_rate,cust_code,acct_code,cctr_code,due_date,tot_amt,discount,tax_amt, "
								+" bank_code,ref_type,auto_rcp,sales_pers,item_ser,sales_pers__1,sales_pers__2, "
								+" cr_term,recd,ref_ser__org,line_no__ref,cust_ref_no,cust_ref_date,cust_ref_amt) "
								+" values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
							
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,ibcaId);
							pstmt.setString(2,tranSer);
							pstmt.setString(3,tranId);
							pstmt.setTimestamp(4,refDate);
							pstmt.setString(5,curr);
							pstmt.setDouble(6,exch);
							pstmt.setString(7,custI);
							pstmt.setString(8,acct);
							pstmt.setString(9,cctr);
							pstmt.setTimestamp(10,dueDate);
							pstmt.setDouble(11,amount);
							pstmt.setDouble(12,discount);
							pstmt.setDouble(13,taxAmt);
							pstmt.setString(14,bank); 
							pstmt.setString(15,refType); 
							pstmt.setString(16,autoRcp); 
							pstmt.setString(17,spers);
							pstmt.setString(18,itemSer);
							pstmt.setString(19,spers1);
							pstmt.setString(20,spers2);
							pstmt.setString(21,crTerm);
							pstmt.setString(22,recd);
							pstmt.setString(23,tranSer);
							pstmt.setString(24,"1");
							pstmt.setString(25,custRefNo);
							pstmt.setTimestamp(26,custRefDate);
							pstmt.setDouble(27,custRefAmt);
							
							upd= pstmt.executeUpdate();
							if(upd <1)
							{
								throw new Exception("UpdateFail");
							}

							pstmt.close();
												
						}
						
					} //end siteRcv != site & runMode = I
				}// end Y is invIbcaGen
			}// runMode is I
			System.out.println("Reaching End sucessefull <!@# new>");
//			errString = itmDBAccessEJB.getErrorString("","CONFSUCCES","");
			errString = itmDBAccessEJB.getErrorString("","CONFSUCCES","","",conn);
			System.out.println("Misc Drcr Confirmed .."+errString);
		
			}//end of isPreview Condition
			}// end of try
		catch(SQLException e)
		{
			System.out.println("Exception :MiscDrCrRcpConf :gbfPostMiscDrcrRcp :SQLException :==>\n"+e.getMessage());
			errString = genericUtility.createErrorString(e);
			throw new ITMException(e);
		}		
		catch (Exception e)
		{
			System.out.println("Exception :MiscDrCrRcpConf :gbfPostMiscDrcrRcp :==>"+e.getMessage());
			errString = genericUtility.createErrorString(e);
			throw new ITMException(e);
		}
		finally
		{
			try
			{				
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				
			}
			catch(Exception e)
			{
				System.out.println("Exception : "+e);e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
	}
	

}