package ibase.webitm.ejb.fin;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.ProcessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
//import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class AutoPmtGenPrc extends ProcessEJB
implements AutoPmtGenPrcLocal, AutoPmtGenPrcRemote
{
	File filePtr;
	File logDir;
	String logDirName = "";
	static String logOnOffFlag = "";
	ValidatorEJB validatorEJB = new ValidatorEJB();
	String err = "";
	//  GenericUtility genericUtility = GenericUtility.getInstance();
	E12GenericUtility genericUtility = new E12GenericUtility();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();

	ResultSet rs1 = null;
	PreparedStatement pstmt1 = null;
	ResultSet rs2 = null;
	PreparedStatement pstmt2 = null;
	String Sql1 = "";
	Timestamp dateTo = null;
	Timestamp dateFr = null;
	String startDateStr = null;

	FileOutputStream fos1 = null;
	java.util.Date startDate = new java.util.Date(System.currentTimeMillis());
	Calendar calendar = Calendar.getInstance();
	FinCommon finCommon=new FinCommon();


	public String getData(String xmlString, String xmlString2, String windowName, String xtraParams)
	throws RemoteException, ITMException
	{
		if (CommonConstants.J2EE_VERSION.equals("1"))
		{
			this.logDirName = (CommonConstants.JBOSSHOME + File.separator + "log");
		}
		else if (CommonConstants.J2EE_VERSION.equals("2"))
		{
			this.logDirName = (CommonConstants.JBOSSHOME + File.separator + "server" + File.separator + "default" + File.separator + "log");
		}
		this.logDir = new File(this.logDirName);
		this.filePtr = new File(this.logDirName + File.separator + "AutoPmtGenSave.log");

		String rtrStr = "";
		Document headerDom = null;
		Document detailDom = null;
		boolean isSSCUser = false;
		try
		{
			if ((xmlString != null) && (xmlString.trim().length() != 0))
			{
				headerDom = this.genericUtility.parseString(xmlString);
			}
			if ((xmlString2 != null) && (xmlString2.trim().length() != 0))
			{
				detailDom = this.genericUtility.parseString(xmlString2);
			}
			rtrStr = getData(headerDom, detailDom, windowName, xtraParams, isSSCUser);
		}
		catch (Exception e)
		{
			rtrStr = e.getMessage();
		}
		return rtrStr;
	}

	public String getData(String xmlString, String xmlString2, String windowName, String xtraParams, boolean isSSCUsers) throws RemoteException, ITMException
	{
		if (CommonConstants.J2EE_VERSION.equals("1"))
		{
			this.logDirName = (CommonConstants.JBOSSHOME + File.separator + "log");
		}
		else if (CommonConstants.J2EE_VERSION.equals("2"))
		{
			this.logDirName = (CommonConstants.JBOSSHOME + File.separator + "server" + File.separator + "default" + File.separator + "log");
		}
		this.logDir = new File(this.logDirName);
		this.filePtr = new File(this.logDirName + File.separator + "AutoPmtGenSave.log");

		String rtrStr = "";
		Document headerDom = null;
		Document detailDom = null;
		try
		{
			if ((xmlString != null) && (xmlString.trim().length() != 0))
			{
				headerDom = this.genericUtility.parseString(xmlString);
			}
			if ((xmlString2 != null) && (xmlString2.trim().length() != 0))
			{
				detailDom = this.genericUtility.parseString(xmlString2);
			}
			rtrStr = getData(headerDom, detailDom, windowName, xtraParams, isSSCUsers);
		}
		catch (Exception e)
		{
			rtrStr = e.getMessage();
		}
		return rtrStr;
	}

	public String getData(Document headerDom, Document detailDom, String windowName, String xtraParams, boolean isSSCUserConsider)
	throws RemoteException, ITMException
	{
		StringBuffer retTabSepStrBuff = new StringBuffer();
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		String fromDate = null;
		String toDate = null;
		String vouchNoFrom = null;
		String vouchNoTo = null;
		String siteCode = null;
		String bankCode = null;
		String sundryType = null;
		String sundryCode = null;
		String payMode = null;
		String entryBatchNo = null;
		String chqSplit = null;
		String bankAdd = null;
		String dueDate = "";
		String errCode = "";
		String resultString = "";
		String getSql = null;
		String currCode = "";
		String checkBarCd="";
		String sql = null;
		ResultSet rs = null;
		ResultSet rs1 = null;
		String spiltChq = "",barCode="";
		PreparedStatement pstmt = null; PreparedStatement pstmt1 = null;

		double unapprovedPayAmt = 0.0D; double payAmt = 0.0D; double netPayable = 0.0D;
		String tranSer = "";
		String refNo = "";
		String tempSql = "";
		Statement stmtTemp = null;
		ResultSet rsTemp = null;
		try
		{
			//Changes and Commented By Bhushan on 06-06-2016 :START
//conn = connDriver.getConnectDB("DriverITM");
conn = getConnection();
//Changes and Commented By Bhushan on 06-06-2016 :END
			conn.setAutoCommit(false);
			stmtTemp = conn.createStatement();
			DatabaseMetaData dbmd = conn.getMetaData();

			/**
			 * [F15KSUN014]
			 * VALLABH KADAM
			 * select finparam 'CHECK_BARCD_APMT'
			 * */
			checkBarCd=checkNull(finCommon.getFinparams("999999", "CHECK_BARCD_APMT", conn));
			if(checkBarCd==null || checkBarCd.trim().length() == 0 || checkBarCd.trim().equalsIgnoreCase("NULLFOUND"))
			{
				checkBarCd="N";
			}
			System.out.println("Check bar code from finparm :- ["+checkBarCd+"]");
			/**
			 * [F15KSUN014]
			 * VALLABH KADAM
			 * select finparam 'CHECK_BARCD_APMT'
			 * END
			 * */

			getSql = "select var_value from finparm where prd_code='999999' and var_name='AUTOPAYGEN_LOG_FLAG'";
			pstmt = conn.prepareStatement(getSql);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				logOnOffFlag = rs.getString(1);
				System.out.println("------------------in rs--------");
			}
			System.out.println("----------------logOnOff:" + logOnOffFlag);
			rs.close();

			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.genericUtility.getDBDateFormat());
			fromDate = this.genericUtility.getColumnValue("date__fr", headerDom);

			currCode = this.genericUtility.getColumnValue("curr_code", headerDom);

			toDate = this.genericUtility.getColumnValue("date__to", headerDom);

			siteCode = this.genericUtility.getColumnValue("site_code__fr", headerDom);

			if ((siteCode == null) || (siteCode.trim().length() == 0))
			{
				siteCode = "";
			}
			vouchNoFrom = this.genericUtility.getColumnValue("vouch_no__fr", headerDom);

			if ((vouchNoFrom == null) || (vouchNoFrom.trim().length() == 0))
			{
				vouchNoFrom = "0";
			}
			vouchNoTo = this.genericUtility.getColumnValue("vouch_no__to", headerDom);

			if ((vouchNoTo == null) || (vouchNoTo.trim().length() == 0))
			{
				vouchNoTo = "zz";
			}
			sundryType = this.genericUtility.getColumnValue("sundry_type", headerDom);

			System.out.println("sundryType in getData======" + sundryType);

			sundryCode = this.genericUtility.getColumnValue("sundry_code", headerDom);
			System.out.println("sundryCode in getData======" + sundryCode);

			if (("null".equals(sundryCode)) || (sundryCode == null))
			{
				System.out.println("If  sundryCode11 == null");
				sundryCode = "%";
			}
			else
			{
				System.out.println("If  sundryCode11 Not == null");
				sundryCode = sundryCode.trim() + "%";
			}
			payMode = this.genericUtility.getColumnValue("pay_mode", headerDom);

			System.out.println("Pay Mode=======" + payMode);

			if (("null".equals(payMode)) || (payMode == null))
			{
				payMode = "%";
			}
			entryBatchNo = this.genericUtility.getColumnValue("entry_batch_no", headerDom);

			if (entryBatchNo == null)
			{
				entryBatchNo = "%";
			}
			else
			{
				entryBatchNo = entryBatchNo.trim() + "%";
			}
			spiltChq = this.genericUtility.getColumnValue("chq_split", headerDom);

			fromDate = this.genericUtility.getValidDateString(fromDate, this.genericUtility.getApplDateFormat(), this.genericUtility.getDBDateFormat());

			toDate = this.genericUtility.getValidDateString(toDate, this.genericUtility.getApplDateFormat(), this.genericUtility.getDBDateFormat());

			this.dateFr = Timestamp.valueOf(fromDate + " 00:00:00 ");

			this.dateTo = Timestamp.valueOf(toDate + " 00:00:00 ");

			/*  getSql = "SELECT misc_payables.ref_no,misc_payables.tran_date,misc_payables.ref_date,misc_payables.bill_no,misc_payables.bill_date,misc_payables.curr_code,misc_payables.exch_rate,misc_payables.sundry_code,misc_payables.acct_code,misc_payables.cctr_code,misc_payables.due_date,misc_payables.site_code,misc_payables.fin_entity,misc_payables.tot_amt,misc_payables.sundry_type,misc_payables.bank_code,misc_payables.pay_mode,misc_payables.adv_amt,misc_payables.tran_id,misc_payables.tran_ser,misc_payables.adj_amt,misc_payables.hold_amt,fn_confirmed_by(misc_payables.tran_ser, misc_payables.ref_no) as username,misc_payables.tot_amt - (case when misc_payables.adj_amt is null then 0 else misc_payables.adj_amt end) - (case when misc_payables.hold_amt is null then 0 else misc_payables.hold_amt end) as pay_amt,fn_sundry_name(misc_payables.sundry_type,misc_payables.sundry_code,'') as sundry_name, misc_payables.tot_amt - (case when misc_payables.adj_amt is null then 0 else misc_payables.adj_amt end) - (case when misc_payables.hold_amt is null then 0 else misc_payables.hold_amt end) as net_payable FROM misc_payables ";

      if (isSSCUserConsider)
      {
        getSql = getSql + ", misc_voucher misc_voucher ";
      }
      getSql = getSql + "WHERE ( misc_payables.site_code = '" + siteCode + "' ) AND";

      if ((sundryType != null) && (!"null".equalsIgnoreCase(sundryType)) && (sundryType.trim().length() > 0))
      {
        getSql = getSql + "( misc_payables.sundry_type = '" + sundryType + "' ) AND ";
      }

      if ((sundryCode != null) && (!"null".equalsIgnoreCase(sundryCode)) && (sundryCode.trim().length() > 0))
      {
        getSql = getSql + "( misc_payables.sundry_code LIKE '" + sundryCode + "' ) AND ";
      }

      getSql = getSql + "( misc_payables.due_date >= ? ) AND ( misc_payables.due_date <= ? ) AND ( misc_payables.ref_no >= '" + 
        vouchNoFrom + "' ) AND " + 
        "( misc_payables.ref_no <= '" + vouchNoTo + "' ) AND " + 
        "( misc_payables.auto_pay = 'Y' ) AND " + 
        "(misc_payables.tot_amt - misc_payables.adj_amt >  0 ) AND " + 
        "(misc_payables.hold_amt is null or misc_payables.tot_amt - misc_payables.adj_amt - misc_payables.hold_amt <>  0 ) AND " + 
        "misc_payables.pay_mode like '" + payMode + "' AND " + 
        "case when misc_payables.entry_batch_no is null then ' ' else" + 
        " misc_payables.entry_batch_no end like '" + entryBatchNo + "' AND " + 
        " misc_payables.curr_code ='" + currCode + "' AND" + 
        " tran_ser NOT in('P-ADV','M-ADV')";

      if (isSSCUserConsider)
      {
        getSql = getSql + " and misc_payables.REF_NO = misc_voucher.TRAN_ID (+)  AND misc_voucher.emp_code__aprv IS NOT NULL AND  misc_voucher.emp_code__aprv IN( select emp_code from users users,gencodes gencodes where users.code=gencodes.fld_value  and FLD_NAME ='SSC_USER'    AND MOD_NAME='SSC_SITE_CODE')";
      }

      getSql = getSql + "and misc_payables.tot_amt - (case when misc_payables.adj_amt is null then 0 else misc_payables.adj_amt end) - (case when misc_payables.hold_amt is null then 0 else misc_payables.hold_amt end)>0 ORDER BY misc_payables. sundry_type ASC, misc_payables.sundry_code ASC, misc_payables.ref_no ASC";

      System.out.println(">>>>Final getSql:" + getSql);
			 */

			getSql="SELECT ref_no,tran_date,ref_date,bill_no,bill_date,curr_code,exch_rate,sundry_code,acct_code,cctr_code,due_date,site_code," +
			" fin_entity,tot_amt,sundry_type,bank_code, pay_mode,adv_amt,tran_id,tran_ser, " +
			" adj_amt,hold_amt,username, pay_amt, sundry_name, net_payable , APRV_CODE, " +
			" (SELECT 'SSC_USER' FROM DUAL WHERE APRV_CODE IN (SELECT EMP_CODE FROM " +
			" ( " +
			" SELECT GENCODES.FLD_VALUE , " +
			" (SELECT USERS.EMP_CODE FROM USERS WHERE USERS.CODE = GENCODES.FLD_VALUE) AS EMP_CODE " +
			" FROM GENCODES  WHERE FLD_NAME ='SSC_USER' AND MOD_NAME='SSC_SITE_CODE'))) AS SSC_USER " +
			" FROM " +
			" ( " +
			" SELECT misc_payables.ref_no,misc_payables.tran_date,misc_payables.ref_date,misc_payables.bill_no, " +
			" misc_payables.bill_date,misc_payables.curr_code,misc_payables.exch_rate,misc_payables.sundry_code, " +
			" misc_payables.acct_code,misc_payables.cctr_code,misc_payables.due_date,misc_payables.site_code, " +
			" misc_payables.fin_entity,misc_payables.tot_amt,misc_payables.sundry_type,misc_payables.bank_code, " +
			" misc_payables.pay_mode,misc_payables.adv_amt,misc_payables.tran_id,misc_payables.tran_ser, " +
			" misc_payables.adj_amt,misc_payables.hold_amt,fn_confirmed_by(misc_payables.tran_ser, " +
			" misc_payables.ref_no) as username, misc_payables.tot_amt - (case when misc_payables.adj_amt is null then 0 else misc_payables.adj_amt end) - (case when misc_payables.hold_amt is null then 0 else misc_payables.hold_amt end) as pay_amt, " +
			" fn_sundry_name(misc_payables.sundry_type,misc_payables.sundry_code,'') as sundry_name, " +
			" misc_payables.tot_amt - (case when misc_payables.adj_amt is null then 0 else misc_payables.adj_amt end) - (case when misc_payables.hold_amt is null then 0 else misc_payables.hold_amt end) as net_payable , " +
			" PAYABLE.APRV_CODE AS APRV_CODE " +
			" FROM misc_payables , ( " +
			" SELECT TRAN_ID,CONF_DATE,DDF_SUNDRY_NAME('E',EMP_CODE__APRV,'D') AS APRV_NAME,EMP_CODE__APRV AS APRV_CODE,REMARKS " +
			" FROM VOUCHER WHERE TRAN_DATE >=? " +
			"  UNION ALL " +
			" SELECT TRAN_ID,CONF_DATE,DDF_SUNDRY_NAME('E',EMP_CODE__APRV,'D') AS APRV_NAME,EMP_CODE__APRV AS APRV_CODE,REMARKS " +
			" FROM MISC_VOUCHER WHERE TRAN_DATE >= ? " +
			" ) PAYABLE " +
			" WHERE MISC_PAYABLES.REF_NO = PAYABLE.TRAN_ID (+) " +
			" AND ( misc_payables.site_code = '" + siteCode + "' ) " ;
			if ((sundryType != null) && (!"null".equalsIgnoreCase(sundryType)) && (sundryType.trim().length() > 0))
			{
				getSql = getSql + " AND ( misc_payables.sundry_type = '" + sundryType + "' )  ";
			}

			//" AND( misc_payables.sundry_type = 'S' ) " +
			if ((sundryCode != null) && (!"null".equalsIgnoreCase(sundryCode)) && (sundryCode.trim().length() > 0))
			{
				getSql = getSql + " AND ( misc_payables.sundry_code LIKE '" + sundryCode + "' )  ";
			}
			//" AND ( misc_payables.sundry_code LIKE '%' ) " +
			getSql=getSql+ " AND ( misc_payables.due_date >= ? ) " +
			" AND ( misc_payables.due_date <= ? ) " +
			"  AND ( misc_payables.ref_no >= '"+vouchNoFrom+"' ) AND ( misc_payables.ref_no <= '" + vouchNoTo + "' ) AND ( nvl(misc_payables.auto_pay,'Y') = 'Y' ) " +
			" AND (misc_payables.tot_amt - misc_payables.adj_amt >  0 ) " +
			" AND (misc_payables.hold_amt is null or misc_payables.tot_amt - misc_payables.adj_amt - misc_payables.hold_amt <>  0 ) " +
			" AND misc_payables.pay_mode like '" + payMode + "' " +
			"  AND case when misc_payables.entry_batch_no is null then ' ' else misc_payables.entry_batch_no end like '" + entryBatchNo + "' " +
			" AND  misc_payables.curr_code ='" + currCode + "' " +
			" AND tran_ser NOT in('P-ADV','M-ADV') " +
			" and misc_payables.tot_amt - (case when misc_payables.adj_amt is null then 0 else misc_payables.adj_amt end) - (case when misc_payables.hold_amt is null then 0 else misc_payables.hold_amt end)>0 " +
			" ORDER BY misc_payables. sundry_type ASC, " +
			" misc_payables.sundry_code ASC, misc_payables.ref_no ASC) " ;
			if (isSSCUserConsider) 
			{
				getSql=getSql+ " where aprv_code  in (SELECT EMP_CODE " +
				" FROM ( " +
				" SELECT GENCODES.FLD_VALUE , " +
				" (SELECT USERS.EMP_CODE FROM USERS WHERE USERS.CODE = GENCODES.FLD_VALUE) AS EMP_CODE " +
				" FROM GENCODES " +
				" WHERE FLD_NAME ='SSC_USER' " +
				" AND MOD_NAME='SSC_SITE_CODE'))";
			}

			pstmt = conn.prepareStatement(getSql);
			pstmt.setTimestamp(1, this.dateFr);
			pstmt.setTimestamp(2, this.dateFr);
			pstmt.setTimestamp(3, this.dateFr);
			pstmt.setTimestamp(4, this.dateTo);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				System.out.println("Inside while loop");
				tranSer = rs.getString("tran_ser");
				refNo = rs.getString("ref_no");
				payAmt = rs.getDouble("pay_amt");
				netPayable = rs.getDouble("net_payable");
				dueDate = rs.getString("due_date");


				/**
				 * [F15KSUN014]
				 * VALLABH KADAM
				 * Select BARCODE
				 * using 'DDF_GET_MULTI_BARCODE' function
				 * 24/FEB/16
				 * */
				if("Y".equalsIgnoreCase(checkBarCd))
				{
					System.out.println("Check bar code found Y");
					tempSql="select DDF_GET_MULTI_BARCODE(?) as barcode from dual";
					pstmt1=conn.prepareStatement(tempSql);
					pstmt1.setString(1, refNo);
					rsTemp = pstmt1.executeQuery();
					if (rsTemp.next())
					{
						barCode=checkNull(rsTemp.getString("barcode"));
					}
					pstmt1.close();
					pstmt1 = null;
					rsTemp.close();
					rsTemp = null;

					if(barCode==null || barCode.trim().length()==0)
					{
						continue;
					}
				}        
				/**
				 * [F15KSUN014]
				 * VALLABH KADAM
				 * Select BARCODE
				 * using 'DDF_GET_MULTI_BARCODE' function
				 * 24/FEB/16
				 * END
				 * */ 


				tempSql = " select sum(b.net_amt) as unconfirm_amt from misc_payment a,misc_paydet b  where a.tran_id=b.tran_id and  b.tran_ser=? and  b.vouch_no= ?   and a.confirmed='N' ";

				System.out.println("SQL==>" + tempSql);

				pstmt1 = conn.prepareStatement(tempSql);
				pstmt1.setString(1, tranSer);
				pstmt1.setString(2, refNo);
				rsTemp = pstmt1.executeQuery();
				if (rsTemp.next())
				{
					unapprovedPayAmt = rsTemp.getDouble("unconfirm_amt");
				}
				else
				{
					unapprovedPayAmt = 0.0D;
				}
				pstmt1.close();
				pstmt1 = null;
				rsTemp.close();
				rsTemp = null;

				System.out.println("Un confirmed Amt===" + unapprovedPayAmt + "Ref No====" + refNo);
				payAmt -= unapprovedPayAmt;
				System.out.println("PayAmt Value====" + payAmt + "UnApproved Amt=====" + unapprovedPayAmt);

				System.out.println("");
				if (payAmt <= 0.0D) {
					continue;
				}
				retTabSepStrBuff.append(rs.getString(1) == null ? " " : rs.getString(1)).append("\t");

				retTabSepStrBuff.append(rs.getTimestamp(2)).append("\t");
				this.dateTo = rs.getTimestamp(2);

				retTabSepStrBuff.append(rs.getTimestamp(3)).append("\t");
				this.dateFr = rs.getTimestamp(3);

				retTabSepStrBuff.append(rs.getString(4) == null ? " " : rs.getString(4)).append("\t");

				if (rs.getTimestamp(5) == null)
					retTabSepStrBuff.append("").append("\t");
				else {
					retTabSepStrBuff.append(rs.getTimestamp(5)).append("\t");
				}

				retTabSepStrBuff.append(rs.getString(6) == null ? " " : rs.getString(6)).append("\t");

				retTabSepStrBuff.append(rs.getDouble(7)).append("\t");

				retTabSepStrBuff.append(rs.getString(8) == null ? " " : rs.getString(8)).append("\t");

				retTabSepStrBuff.append(rs.getString(9) == null ? " " : rs.getString(9)).append("\t");

				retTabSepStrBuff.append(rs.getString(10) == null ? " " : rs.getString(10)).append("\t");

				retTabSepStrBuff.append(rs.getTimestamp(11)).append("\t");

				retTabSepStrBuff.append(rs.getString(12) == null ? " " : rs.getString(12)).append("\t");

				retTabSepStrBuff.append(rs.getString(13) == null ? " " : rs.getString(12)).append("\t");

				retTabSepStrBuff.append(rs.getDouble(14)).append("\t");

				retTabSepStrBuff.append(rs.getString(15) == null ? " " : rs.getString(15)).append("\t");

				retTabSepStrBuff.append(rs.getString(16) == null ? " " : rs.getString(16)).append("\t");

				retTabSepStrBuff.append(rs.getString(17) == null ? " " : rs.getString(17)).append("\t");

				retTabSepStrBuff.append(rs.getDouble(18)).append("\t");

				retTabSepStrBuff.append(rs.getString(19) == null ? " " : rs.getString(19)).append("\t");

				retTabSepStrBuff.append(rs.getString(20) == null ? " " : rs.getString(20)).append("\t");

				retTabSepStrBuff.append(rs.getDouble(21)).append("\t");

				retTabSepStrBuff.append(rs.getDouble(22)).append("\t");

				retTabSepStrBuff.append(rs.getString(23)).append("\t");

				retTabSepStrBuff.append(payAmt).append("\t");

				retTabSepStrBuff.append(rs.getString(25) == null ? " " : rs.getString(25)).append("\t");

				retTabSepStrBuff.append(rs.getDouble(26)).append("\t");

				retTabSepStrBuff.append(unapprovedPayAmt).append("\t");

				retTabSepStrBuff.append(spiltChq).append("\r\n");
			}

			rs.close();
			pstmt.close();
			resultString = retTabSepStrBuff.toString();
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				conn.close();
				conn = null;
				//Changed by wasim to close result set/statement [START]
				if(rsTemp!=null)
				{
					rsTemp.close();rsTemp=null;
				}
				if(pstmt!=null)
				{
					pstmt.close();pstmt=null;
				}
				if(pstmt1!=null)
				{
					pstmt1.close();pstmt1=null;
				}
				if(rs!=null)
				{
					rs.close();rs=null;
				}
				//Changed by wasim to close result set/statement [END]
			}
			catch (Exception e)
			{
				System.out.println(e.getMessage());
			}
		}
		return resultString;
	}

	public String process(String xmlString, String xmlString2, String windowName, String xtraParams)
	throws RemoteException, ITMException
	{
		Document detailDom = null;
		Document headerDom = null;
		String retStr = "";
		try
		{
			if ((xmlString != null) && (xmlString.trim().length() != 0))
			{
				headerDom = this.genericUtility.parseString(xmlString);
				System.out.println("headerDom" + headerDom);
			}

			if ((xmlString2 != null) && (xmlString2.trim().length() != 0))
			{
				detailDom = this.genericUtility.parseString(xmlString2);
				System.out.println("detailDom" + detailDom);
			}

			retStr = process(headerDom, detailDom, windowName, xtraParams);
			System.out.println("xmlString*********" + xmlString);
			System.out.println("xmlString2*********" + xmlString2);
		}
		catch (Exception e)
		{
			System.out.println("Exception :AutoPrmGen :process:" + e.getMessage() + ":");
			e.printStackTrace();

			retStr = e.getMessage();
		}

		return retStr;
	}

	public String process(Document headerDom, Document detailDom, String windowName, String xtraParams)
	throws RemoteException, ITMException
	{
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		ResultSet rs = null; ResultSet rs1 = null;
		PreparedStatement pstmt = null; PreparedStatement pstmt1 = null;
		String refNo = "";

		String chgDate = "";
		String sDate = "";
		String refDate = "";

		String billNo = "";
		String billDate = "";
		String currCode = "";
		String dueDate = "";
		String exchRate = "";
		String sundryCode = "";
		String acctCode = "";
		String cctrCode = "";
		String siteCode = "";
		String finEntity = "";
		String totAmt = "";
		String sundryType = "";
		String bankCode = "";
		String bankCodeAdd = "";
		String payMode = "";
		String drawnAt = "";
		String advAmt = "";
		String tranId = "";
		String tranSer = "";
		String adjAmt = "";
		String holdAmt = "";
		String userName = "";
		String payAmt = "";
		String sundryName = "";
		String netPayable = "";
		String childNodeName = "";
		String errCode = "";
		String errFrSret = "";
		String tranType = "";
		String chgTerm = "";
		String chgUser = "";
		String xmlOutString = "";
		String payDate = "";
		String wfStatus = "";
		String spiltChq = "";
		String stanCode = "";
		String checkBarCd="";
		String tranDate = "";
		double diffAmt = 0.0D;
		String retString = "";
		String lastChq = "";
		String uptoChq = "";
		String errString = "";

		String tranDt = "";

		StringBuffer errStringBuff = null;
		boolean validEntry = true;
		StringBuffer xmlString = null;
		int curDate = 0;
		int curMonth = 0;
		int curYear = 0;
		int lineNo = 0;

		Connection connectionObject = null;
		Statement statement = null;
		ResultSet resultSet = null;
		String sql = "";
		String siteDescr = ""; String finentDescr = ""; String bankName = ""; String chgFrm = ""; String chgTo = "";

		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int updCnt = 0;
		int parentNodeListLength = 0;
		int childNodeListLength = 0;
		String acctCodeBal = ""; String cctrCodeBal = ""; String acctCodeBc = ""; String cctrCodeBc = ""; String acctCodeCf = ""; String acctCodeCfAp = ""; String cctrCodeCf = ""; String cctrCodeCfAp = "";
		String currCodeBc = ""; String porder = ""; String sfld1 = ""; String acctCodeDisc = ""; String cctrCodeDisc = ""; String startFrom = "";
		double excRateBc = 0.0D; double discount = 0.0D; double mexrate = 0.0D; double disAmt = 0.0D; double payAmt1 = 0.0D;
		java.util.Date effDate = null; java.util.Date billDt = null; java.util.Date ldStartDate = null; java.util.Date reDate1 = null;
		java.util.Date ldStartDate1 = null; java.util.Date payDate1 = null; java.util.Date mPayDate = null;
		String transactionDate = "";
		java.util.Date startDate = new java.util.Date(System.currentTimeMillis());
		java.util.Date endDate = new java.util.Date(System.currentTimeMillis());
		String strToWrite = "";
		String endDateStr = null;

		String splitCode = ""; String tempSplitCode = "";
		HashMap splitCodeWiseMap = new HashMap(); HashMap tempMap = null;
		ArrayList tempList = null;
		long datediff = 0L;
		int cntXml = 1;
		String itemSer1 = "";
		String sysDate = "";
		java.util.Date today = new java.util.Date();
		Timestamp currDate = null; Timestamp maxRefDt = null;
		java.util.Date refrdate = null; java.util.Date dueMaxDate = null;
		java.util.Date maxRefDate = null; java.util.Date maxDueDate = null;
		FinCommon fin = new FinCommon();
		DistCommon dist = new DistCommon();
		double unconfirmAmt = 0.0D;
		HashMap maxDateMap = new HashMap();
		String chq1 = ""; String chq2 = "";
		String refDate1 = "";
		String sundryCdSpilt = "";
		HashMap splitCodeWiseNegMap = new HashMap();
		HashMap tempMapNeg = null;
		ArrayList tempListNeg = null;
		Timestamp refDateSTr=null;
		java.util.Date dueDatediff = null;
		double pay_amt = 0.0D; double totamount = 0.0D; double totAmtRem = 0.0D;
		String sundryCodeNeg = "";
		java.util.Date refdateNeg = null;

		String billNoNeg = "";
		java.util.Date billDateNeg = null;
		double balanceAmt = 0.0D;
		String sundryCodeList = "";
		double unAppNegativeAmt = 0.0D;
		String maxRefNo = "";
		try
		{



			System.out.println("intializingLog$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$........." + intializingLog("Gen_bank_payment_log"));
			StringBuffer retBuf = new StringBuffer();
			//Changes and Commented By Bhushan on 06-06-2016 :START
//conn = connDriver.getConnectDB("DriverITM");
conn = getConnection();
//Changes and Commented By Bhushan on 06-06-2016 :END
			conn.setAutoCommit(false);
			System.out.println("process starts---------");

			java.util.Date currentDate = new java.util.Date();
			SimpleDateFormat sdf = new SimpleDateFormat(this.genericUtility.getApplDateFormat());
			Calendar c = Calendar.getInstance();
			c.setTime(today);
			today = c.getTime();
			SimpleDateFormat sdf1 = new SimpleDateFormat(this.genericUtility.getApplDateFormat());
			sysDate = sdf.format(today);
			System.out.println("sysDate****==========" + sysDate);
			System.out.println("Getting winName============" + windowName);

			sql = "select var_value from finparm where prd_code='999999' and var_name='AUTOPAYGEN_LOG_FLAG'";

			pstmt = conn.prepareStatement(sql);
			resultSet = pstmt.executeQuery();
			if (resultSet.next())
			{
				logOnOffFlag = resultSet.getString(1);
			}

			System.out.println("----------------logOnOff:" + logOnOffFlag);
			resultSet.close();

			siteCode = this.genericUtility.getColumnValue("site_code__fr", headerDom);

			bankCode = this.genericUtility.getColumnValue("bank_code", headerDom);

			bankCodeAdd = this.genericUtility.getColumnValue("bank_code__add", headerDom);

			tranType = this.genericUtility.getColumnValue("tran_type", headerDom);

			payDate = this.genericUtility.getColumnValue("date__pay", headerDom);

			chgUser = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");

			chgTerm = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");

			Calendar calCurr = Calendar.getInstance();
			curDate = calCurr.get(5);

			curMonth = calCurr.get(2);

			curYear = calCurr.get(1);

			//chgDate = new Integer(curYear).toString() + "-" + new Integer(curMonth).toString() + "-" + new Integer(curDate).toString();

			exchRate = this.genericUtility.getColumnValue("exch_rate", headerDom);

			currCode = this.genericUtility.getColumnValue("curr_code", headerDom);

			lastChq = this.genericUtility.getColumnValue("ref_no", headerDom);

			uptoChq = this.genericUtility.getColumnValue("ref_no__upto", headerDom);

			System.out.println("chgDate========" + chgDate);

			payMode = this.genericUtility.getColumnValue("pay_mode", headerDom);
			System.out.println("Getting pay Mode================" + payMode);

			sundryCode = this.genericUtility.getColumnValue("sundry_code", headerDom);
			System.out.println("Getting sundry_code================" + sundryCode);

			sundryType = this.genericUtility.getColumnValue("sundry_type", headerDom);
			System.out.println("Getting sundryType================" + sundryType);

			refNo = this.genericUtility.getColumnValue("ref_no", headerDom);
			System.out.println("Getting ref_no================" + refNo);

			dueDate = this.genericUtility.getColumnValue("due_date", headerDom);
			System.out.println("Getting dueDate==============" + dueDate);

			wfStatus = this.genericUtility.getColumnValue("wf_status", headerDom);
			System.out.println("Getting wfStatus==============" + wfStatus);

			spiltChq = this.genericUtility.getColumnValue("chq_split", headerDom);
			System.out.println("Getting spiltChq==============" + spiltChq);

			if (siteCode != null)
			{
				sql = "SELECT FIN_ENTITY,DESCR FROM SITE WHERE SITE_CODE ='" + siteCode + "'";

				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					finEntity = rs.getString(1);
					siteDescr = rs.getString(2);
				}

			}

			rs.close();
			pstmt.close();
			pstmt = null;
			if (finEntity != null)
			{
				sql = "SELECT DESCR FROM FINENT WHERE FIN_ENTITY ='" + finEntity + "'";

				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					finentDescr = rs.getString(1);
				}
			}

			rs.close();
			pstmt.close();
			pstmt = null;
			if (bankCode != null)
			{
				sql = "SELECT BANK_NAME,chq1,chq3 FROM BANK WHERE BANK_CODE ='" + bankCode + "'";

				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					bankName = checkNull(rs.getString(1));
				}

			}

			rs.close();
			pstmt.close();
			pstmt = null;

			System.out.println("Bank Code=====" + bankCode);

			sql = "select acct_code__bal, cctr_code__bal, acct_code__bc, cctr_code__bc, acct_code__cf, acct_code__cf_ap, cctr_code__cf, cctr_code__cf_ap from bank where bank_code = ?";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, bankCode);
			rs = pstmt.executeQuery();

			if (rs.next())
			{
				acctCodeBal = checkNull(rs.getString("acct_code__bal"));
				cctrCodeBal = checkNull(rs.getString("cctr_code__bal"));
				acctCodeBc = checkNull(rs.getString("acct_code__bc"));
				cctrCodeBc = checkNull(rs.getString("cctr_code__bc"));
				acctCodeCf = checkNull(rs.getString("acct_code__cf"));
				acctCodeCfAp = checkNull(rs.getString("acct_code__cf_ap"));
				cctrCodeCf = checkNull(rs.getString("cctr_code__cf"));
				cctrCodeCfAp = checkNull(rs.getString("acct_code__cf_ap"));
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			System.out.println("Site Code>>>>>>>>>>" + siteCode);

			sql = "select curr_code from bank where bank_code=?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, bankCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				currCodeBc = checkNull(rs.getString("curr_code"));
			}

			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			System.out.println("currCodeBc==========" + currCodeBc);

			mexrate = fin.getDailyExchRateSellBuy(currCode, "", siteCode, payDate, "B", conn);
			System.out.println("ExcRate from getDailyExchRateSellBuy=========" + mexrate);

			excRateBc = fin.getDailyExchRateSellBuy(currCodeBc, "", siteCode, payDate, "B", conn);
			System.out.println("excRateBc from getDailyExchRateSellBuy=========" + excRateBc);

			sql = "SELECT chq1,chq2 FROM BANK WHERE BANK_CODE = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, bankCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				chq1 = checkNull(rs.getString(1)).trim();
				chq2 = checkNull(rs.getString(2)).trim();
			}

			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			System.out.println("Chq1=========" + chq1);
			System.out.println("chq2=========" + chq2);

			if (((chq1 != null ? 1 : 0) & (chq1.trim().length() > 0 ? 1 : 0)) != 0) if (((chq2 != null ? 1 : 0) & (chq2.trim().length() > 0 ? 1 : 0)) != 0)
			{
				if (Integer.parseInt(chq1) > Integer.parseInt(chq2))
				{
					maxRefNo = chq1;
				}
			}

			System.out.println("Ref No To  =======" + maxRefNo);

			System.out.println("for detail data");
			parentNodeList = detailDom.getElementsByTagName("Detail2");
			parentNodeListLength = parentNodeList.getLength();
			System.out.println("parentNodeListLength:::::::::" + parentNodeListLength);

			for (int selectedRow = 0; selectedRow < parentNodeListLength; selectedRow++)
			{
				System.out.println("Enter in first for loop for Detail2###########");
				System.out.println("For row selectedRow !!!!!!!! " + selectedRow);
				parentNode = parentNodeList.item(selectedRow);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				System.out.println("childNodeListLength::: " + childNodeListLength + "\n");

				for (int childRow = 0; childRow < childNodeListLength; childRow++)
				{
					System.out.println("Enter in 22222222 for loop for Detail2###########");
					childNode = childNodeList.item(childRow);
					childNodeName = childNode.getNodeName();
					if (childNodeName.equals("ref_no"))
					{
						if (childNode.getFirstChild() != null)
						{
							refNo = childNode.getFirstChild().getNodeValue();
						}
					}

					if (childNodeName.equals("ref_date"))
					{
						if (childNode.getFirstChild() != null)
						{
							String tmpDate = childNode.getFirstChild().getNodeValue();
							if (tmpDate.length() > 10)
							{
								tmpDate = tmpDate.substring(0, 10);
							}
							System.out.println("tmpDate ######" + tmpDate);

							refDate = this.genericUtility.getValidDateString(tmpDate, this.genericUtility.getDBDateFormat(), this.genericUtility.getApplDateFormat());
							System.out.println("refDate from all =====" + refDate);
						}
					}
					if (childNodeName.equals("bill_no"))
					{
						if (childNode.getFirstChild() != null)
						{
							billNo = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("bill_date"))
					{
						if (childNode.getFirstChild() != null)
						{
							String tmpDate = childNode.getFirstChild().getNodeValue();
							if (tmpDate.length() > 10)
							{
								tmpDate = tmpDate.substring(0, 9);
							}
							billDate = this.genericUtility.getValidDateString(tmpDate, this.genericUtility.getDBDateFormat(), this.genericUtility.getApplDateFormat());
						}

					}

					if (childNodeName.equals("curr_code"))
					{
						if (childNode.getFirstChild() != null)
						{
							currCode = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("exch_rate"))
					{
						if (childNode.getFirstChild() != null)
						{
							exchRate = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("sundry_code"))
					{
						if (childNode.getFirstChild() != null)
						{
							sundryCode = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("acct_code"))
					{
						if (childNode.getFirstChild() != null)
						{
							acctCode = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("cctr_code"))
					{
						if (childNode.getFirstChild() != null)
						{
							cctrCode = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("due_date"))
					{
						if (childNode.getFirstChild() != null)
						{
							String tmpDate = childNode.getFirstChild().getNodeValue();
							System.out.println("before tmpDate===========" + tmpDate);
							if (tmpDate.length() > 10)
							{
								tmpDate = tmpDate.substring(0, 10);
							}
							System.out.println("after tmpDate===========" + tmpDate);

							dueDate = this.genericUtility.getValidDateString(tmpDate, this.genericUtility.getDBDateFormat(), this.genericUtility.getApplDateFormat());
							System.out.println(" dueDate===========" + dueDate);
						}
					}
					if (childNodeName.equals("tot_amt"))
					{
						if (childNode.getFirstChild() != null)
						{
							totAmt = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("sundry_type"))
					{
						if (childNode.getFirstChild() != null)
						{
							sundryType = childNode.getFirstChild().getNodeValue();
						}
					}

					if (childNodeName.equals("pay_mode"))
					{
						if (childNode.getFirstChild() != null)
						{
							payMode = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("adv_amt"))
					{
						if (childNode.getFirstChild() != null)
						{
							advAmt = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("tran_id"))
					{
						if (childNode.getFirstChild() != null)
						{
							tranId = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("tran_ser"))
					{
						if (childNode.getFirstChild() != null)
						{
							tranSer = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("adj_amt"))
					{
						if (childNode.getFirstChild() != null)
						{
							adjAmt = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("hold_amt"))
					{
						if (childNode.getFirstChild() != null)
						{
							holdAmt = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("username"))
					{
						if (childNode.getFirstChild() != null)
						{
							userName = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("pay_amt"))
					{
						if (childNode.getFirstChild() != null)
						{
							payAmt = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("sundry_name"))
					{
						if (childNode.getFirstChild() != null)
						{
							sundryName = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("net_payable"))
					{
						if (childNode.getFirstChild() != null)
						{
							netPayable = childNode.getFirstChild().getNodeValue();
						}
					}

					if (childNodeName.equals("tran_date"))
					{
						if (childNode.getFirstChild() != null)
						{
							tranDate = childNode.getFirstChild().getNodeValue();
						}
						transactionDate = this.genericUtility.getValidDateString(tranDate, this.genericUtility.getDBDateFormat(), this.genericUtility.getApplDateFormat());
					}

					if (!childNodeName.equals("unconfirm_amt"))
						continue;
					if (childNode.getFirstChild() == null)
						continue;
					unconfirmAmt = Double.valueOf(childNode.getFirstChild().getNodeValue()).doubleValue();
					System.out.println("UnConfirm Amount from node=====" + unconfirmAmt);
				}

				sundryCodeList = sundryCodeList + "'" + sundryCode + "',";
				if ((spiltChq != null) && ("Y".equalsIgnoreCase(spiltChq)))
				{
					tempSplitCode = sundryCode + "@" + payMode + "@" + dueDate;
				}
				else
				{
					tempSplitCode = sundryCode + "@" + payMode;
				}

				if (maxDateMap.containsKey(tempSplitCode))
				{
					String tempPrvMaxDate = (String)maxDateMap.get(tempSplitCode);

					if (sdf.parse(tempPrvMaxDate).compareTo(sdf.parse(dueDate)) < 0)
					{
						maxDateMap.put(tempSplitCode, dueDate);
					}

				}
				else
				{
					maxDateMap.put(tempSplitCode, dueDate);
				}

				System.out.println("1090Getting combination As=====" + tempSplitCode);
				System.out.println("Getting splitCodeWiseMap=====" + splitCodeWiseMap);
				if (splitCodeWiseMap.containsKey(tempSplitCode))
				{
					System.out.println("*****Combination Exist*****");
					tempList = (ArrayList)splitCodeWiseMap.get(tempSplitCode);
					System.out.println("Combination Exist TempList======" + tempList);
				}
				else
				{
					System.out.println("*****Combination Not Exist*****");
					tempList = new ArrayList();
					System.out.println("Combination Not $$ Exist TempList======" + tempList);
				}
				System.out.println("tempList======" + tempList);

				tempMap = new HashMap();

				System.out.println("Getting RefNo Detail=================" + refNo);
				System.out.println("Getting tranDate================" + tranDate);
				System.out.println(" transactionDate===========" + transactionDate);
				sql = "select purc_order,eff_date,bill_date from voucher where tran_id = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, refNo);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					porder = checkNull(rs.getString("purc_order"));
					effDate = rs.getDate("eff_date");
					billDt = rs.getDate("bill_date");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				System.out.println("Purchase order=========" + porder);
				System.out.println("effDate=========" + effDate);
				System.out.println("billDt=========" + billDt);

				sql = "select cr_term from porder where purc_order =?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, porder);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					sfld1 = checkNull(rs.getString("cr_term"));
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				System.out.println("1143sfld1=========" + sfld1);

				sql = "select crtermfc.fin_chg,crterm.acct_code__disc,crterm.cctr_code__disc,crterm.start_from from crterm,crtermfc where crtermfc.cr_term = crterm.cr_term and crterm.cr_term =  ? and trim(crtermfc.line_no) = '1'";

				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, sfld1);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					discount = rs.getDouble("fin_chg");
					acctCodeDisc = checkNull(rs.getString("acct_code__disc"));
					cctrCodeDisc = checkNull(rs.getString("cctr_code__disc"));
					startFrom = checkNull(rs.getString("start_from"));
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				System.out.println("discount=========" + discount);
				System.out.println("acctCodeDisc=========" + acctCodeDisc);
				System.out.println("cctrCodeDisc=========" + cctrCodeDisc);
				System.out.println("startFrom=========" + startFrom);
				reDate1 = sdf.parse(refDate);

				java.util.Date discdt = getDiscountdate(sfld1, reDate1, effDate, billDt, conn);
				System.out.println("1171Getting discdt======" + discdt);
				if (discdt != null)
				{
					System.out.println("Getting discdt not null==");
					String discdt1 = sdf.format(discdt);
					System.out.println("Getting discdt================" + discdt1);
					mPayDate = sdf.parse(transactionDate);
					System.out.println("mPayDate============" + mPayDate);

					long diff = discdt.getTime() - mPayDate.getTime();
					datediff = diff / 86400000L;
					System.out.println("CurrDtae=======================" + datediff);
				}

				sql = "select fin_chg  from crtermfc where  ? between min_day and max_day and cr_term = ? and trim(line_no) = '1'";
				pstmt = conn.prepareStatement(sql);
				pstmt.setLong(1, datediff);
				pstmt.setString(2, sfld1);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					discount = rs.getDouble("fin_chg");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				System.out.println("Get Discount=======" + discount);
				if (discount == 0.0D)
				{
					discount = 0.0D;
				}

				System.out.println(">>>>>>>>startFrom===" + startFrom);
				if ((startFrom != null) && (startFrom.trim().length() > 0) && ("R".equalsIgnoreCase(startFrom)))
				{
					ldStartDate = reDate1;
				}
				else if ((startFrom != null) && (startFrom.trim().length() > 0) && ("D".equalsIgnoreCase(startFrom)) && ("Q".equalsIgnoreCase(startFrom)))
				{
					ldStartDate = effDate;
				}
				else if ((startFrom != null) && (startFrom.trim().length() > 0) && ("B".equalsIgnoreCase(startFrom)))
				{
					ldStartDate = billDt;
				}

				if ((payDate != null) && (payDate.trim().length() > 0) && (ldStartDate != null))
				{
					payDate1 = sdf.parse(payDate);
					System.out.println("@@@1222payDate1[" + payDate1 + "]ldStartDate[" + ldStartDate + "]discdt[" + discdt + "]");
					if ((payDate1 != null) && (payDate1.compareTo(ldStartDate) > 0) && (discdt != null) && (payDate1.compareTo(discdt) < 0))
					{
						if (discount != 0.0D) {
							System.out.println("Discount not equals to Zerooooooooooooo");
							payAmt1 = Double.parseDouble(payAmt);
							disAmt = payAmt1 * (discount / 100.0D);
						}
					}
				}

				System.out.println("disAmount==========" + disAmt);
				System.out.println("PayMAode=======" + payMode);
				System.out.println("BankCode>>>>>===" + bankCode);
				if (("D".equalsIgnoreCase(payMode)) || ("P".equalsIgnoreCase(payMode)))
				{
					System.out.println("payMode<<<<<<<<");
					drawnAt = checkNull(getpayablesAt(sundryType, sundryCode, bankCode, conn));
				}

				if (("D".equalsIgnoreCase(payMode)) || ("P".equalsIgnoreCase(payMode)) || ("T".equalsIgnoreCase(payMode)) || ("N".equalsIgnoreCase(payMode)))
				{
					System.out.println("payMode========>>>>");
					stanCode = checkNull(getStanDraw(sundryType, sundryCode, conn));
					System.out.println("Getting stanCode==============" + stanCode);
				}

				System.out.println("vouch_no============" + refNo);
				System.out.println("vouch_date============" + refDate);
				System.out.println("payAmt============" + payAmt);

				System.out.println("acct_code__ap=========" + acctCode);
				System.out.println("cctr_code__ap=========" + cctrCode);
				double payAmount = Double.parseDouble(payAmt);
				double exchRate1 = Double.parseDouble(exchRate);
				System.out.println("payAmount===" + payAmount);
				System.out.println("exchRate1===" + exchRate1);
				System.out.println("mexrate===" + mexrate);
				diffAmt = payAmount * exchRate1 - payAmount * mexrate;
				System.out.println("diff_amt__exch=========" + diffAmt);

				tempMap.put("tran_id", tranId);
				tempMap.put("tran_ser", tranSer);
				tempMap.put("line_no", Integer.valueOf(lineNo));
				tempMap.put("vouch_no", refNo);
				if (refDate != null)
				{
					tempMap.put("vouch_date", refDate);
				}

				tempMap.put("net_amt", payAmt);
				tempMap.put("pay_amt", payAmt);
				tempMap.put("curr_code", currCode);

				tempMap.put("exch_rate__vouch", exchRate);
				tempMap.put("diff_amt__exch", Double.valueOf(diffAmt));
				tempMap.put("acct_code__ap", acctCode);
				tempMap.put("cctr_code__ap", cctrCode);

				tempMap.put("sundry_type", sundryType);
				tempMap.put("sundry_code", sundryCode);
				tempMap.put("bank_charges", Integer.valueOf(0));
				tempMap.put("stan_code", stanCode);

				tempMap.put("drawn_at", drawnAt);
				tempMap.put("tax_amt", Integer.valueOf(0));
				tempMap.put("net_pay_amt", payAmt);
				tempMap.put("acct_code__disc", acctCodeDisc);

				tempMap.put("cctr_code__disc", cctrCodeDisc);
				tempMap.put("bill_no", billNo);
				tempMap.put("bill_date", billDate);
				tempMap.put("exch_rate", exchRate);

				tempMap.put("discount_amt", Double.valueOf(disAmt));
				tempMap.put("discount", Double.valueOf(discount));
				tempMap.put("tot_amt", totAmt);

				tempMap.put("unconfirm_amt", Double.valueOf(unconfirmAmt));

				System.out.println("Getting value in Map======" + tempMap);
				tempList.add(tempMap);
				System.out.println("1303Getting tempList value after ading in list ======" + tempList);

				if (splitCodeWiseMap.containsKey(tempSplitCode))
				{
					System.out.println("splitCodeWiseMap.containsKey(tempSplitCode)");
					splitCodeWiseMap.put(tempSplitCode, tempList);
				}
				else
				{
					System.out.println("else*************");
					splitCodeWiseMap.put(tempSplitCode, tempList);
				}

			}

			sundryCodeList = sundryCodeList.substring(0, sundryCodeList.length() - 1);

			sql = "SELECT misc_payables.ref_no,misc_payables.tran_date,misc_payables.ref_date,misc_payables.bill_no,misc_payables.bill_date,misc_payables.curr_code,misc_payables.exch_rate,misc_payables.sundry_code,misc_payables.acct_code,misc_payables.cctr_code,misc_payables.due_date,misc_payables.site_code,misc_payables.fin_entity,misc_payables.tot_amt,misc_payables.sundry_type,misc_payables.bank_code,misc_payables.pay_mode,misc_payables.adv_amt,misc_payables.tran_id,misc_payables.tran_ser,misc_payables.adj_amt,misc_payables.hold_amt,fn_confirmed_by(misc_payables.tran_ser, misc_payables.ref_no) as username,misc_payables.tot_amt - (case when misc_payables.adj_amt is null then 0 else misc_payables.adj_amt end) - (case when misc_payables.hold_amt is null then 0 else misc_payables.hold_amt end) as pay_amt,fn_sundry_name(misc_payables.sundry_type,misc_payables.sundry_code,'') as sundry_name,misc_payables.tot_amt - (case when misc_payables.adj_amt is null then 0 else misc_payables.adj_amt end) - (case when misc_payables.hold_amt is null then 0 else misc_payables.hold_amt end) as net_payable  FROM misc_payables  WHERE  ";

			sql = sql + "( misc_payables.sundry_code in (" + sundryCodeList + ") ) AND ";

			sql = sql + " curr_code= ? and site_code= ? and misc_payables.tot_amt - (case when misc_payables.adj_amt is null then 0 else misc_payables.adj_amt end) - (case when misc_payables.hold_amt is null then 0 else misc_payables.hold_amt end) <  0 AND tran_ser NOT in('P-ADV','M-ADV')   order by due_date";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, currCode);
			pstmt.setString(2, siteCode);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				tranId = rs.getString("tran_id");
				tranSer = rs.getString("tran_ser");
				refNo = rs.getString("ref_no");
				refdateNeg = rs.getDate("ref_date");
				currCode = rs.getString("curr_code");
				exchRate = rs.getString("exch_rate");
				pay_amt = rs.getDouble("pay_amt");
				sundryType = rs.getString("sundry_type");
				acctCode = rs.getString("acct_code");
				cctrCode = rs.getString("cctr_code");
				sundryCodeNeg = checkNull(rs.getString("sundry_code"));
				dueDatediff = rs.getDate("due_date");
				totamount = rs.getDouble("tot_amt");
				billNo = rs.getString("bill_no");
				billDateNeg = rs.getDate("bill_date");

				unAppNegativeAmt = 0.0D;
				System.out.println("1465Sundry Code====" + sundryCode + "Refr No====" + refNo + "Due Date====" + dueDatediff + "pay_amt===" + pay_amt);

				sql = " select sum(b.net_amt) as unconfirm_amt1 from misc_payment a,misc_paydet b  where a.tran_id=b.tran_id and  b.tran_ser=? and  b.vouch_no= ?   and a.confirmed='N' ";

				System.out.println("SQL==>" + sql);

				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1, tranSer);
				pstmt1.setString(2, refNo);
				rs1 = pstmt1.executeQuery();
				if (rs1.next())
				{
					unAppNegativeAmt = rs1.getDouble("unconfirm_amt1");
					System.out.println("Unconfirmed Negative Amt**===" + unAppNegativeAmt + "Ref No**====" + refNo);
				}

				pstmt1.close();
				pstmt1 = null;
				rs1.close();
				rs1 = null;

				System.out.println("Unconfirmed Negative Amt===" + unAppNegativeAmt + "Ref No====" + refNo);

				pay_amt -= unAppNegativeAmt;
				totamount -= unAppNegativeAmt;
				System.out.println("pay amt====" + pay_amt);
				System.out.println("totamount====" + totamount);

				System.out.println("splitCodeWiseNegMap@@@@@" + splitCodeWiseNegMap);
				if (splitCodeWiseNegMap.containsKey(sundryCodeNeg))
				{
					System.out.println("* Exist for SundryCd Spilt combo*");
					tempListNeg = (ArrayList)splitCodeWiseNegMap.get(sundryCodeNeg);
					System.out.println("Exist for SundryCd Spilt combo======" + tempListNeg);
				}
				else
				{
					System.out.println("***Not Exist for SundryCd Spilt combo*****");
					tempListNeg = new ArrayList();
					System.out.println("Not Exist for SundryCd Spilt combo======" + tempListNeg);
				}
				System.out.println("1485:records in tempListNeg======" + tempListNeg);

				sql = "select purc_order,eff_date,bill_date from voucher where tran_id = ?";
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1, refNo);
				rs1 = pstmt1.executeQuery();
				if (rs1.next())
				{
					porder = checkNull(rs1.getString("purc_order"));
					effDate = rs1.getDate("eff_date");
					billDt = rs1.getDate("bill_date");
				}
				rs1.close();
				rs1 = null;
				pstmt1.close();
				pstmt1 = null;
				System.out.println("1502Purchase order=========" + porder);
				System.out.println("effDate=========" + effDate);
				System.out.println("billDt=========" + billDt);

				sql = "select cr_term from porder where purc_order =?";
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1, porder);
				rs1 = pstmt1.executeQuery();
				if (rs1.next())
				{
					sfld1 = checkNull(rs1.getString("cr_term"));
				}
				rs1.close();
				rs1 = null;
				pstmt1.close();
				pstmt1 = null;
				System.out.println("1518sfld1=========" + sfld1);

				sql = "select crtermfc.fin_chg,crterm.acct_code__disc,crterm.cctr_code__disc,crterm.start_from from crterm,crtermfc where crtermfc.cr_term = crterm.cr_term and crterm.cr_term =  ? and trim(crtermfc.line_no) = '1'";

				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1, sfld1);
				rs1 = pstmt1.executeQuery();
				if (rs1.next())
				{
					discount = rs1.getDouble("fin_chg");
					acctCodeDisc = checkNull(rs1.getString("acct_code__disc"));
					cctrCodeDisc = checkNull(rs1.getString("cctr_code__disc"));
					startFrom = checkNull(rs1.getString("start_from"));
				}
				rs1.close();
				rs1 = null;
				pstmt1.close();
				pstmt1 = null;

				System.out.println("discount=========" + discount);
				System.out.println("acctCodeDisc=========" + acctCodeDisc);
				System.out.println("cctrCodeDisc=========" + cctrCodeDisc);
				System.out.println("startFrom=========" + startFrom);
				reDate1 = sdf.parse(refDate);

				java.util.Date discdt = getDiscountdate(sfld1, reDate1, effDate, billDt, conn);
				System.out.println("1546Getting discdt======" + discdt);
				if (discdt != null)
				{
					System.out.println("1549Getting discdt not null==");
					String discdt1 = sdf.format(discdt);
					System.out.println("Getting discdt================" + discdt1);
					mPayDate = sdf.parse(transactionDate);
					System.out.println("mPayDate============" + mPayDate);

					long diff = discdt.getTime() - mPayDate.getTime();
					datediff = diff / 86400000L;
					System.out.println("CurrDtae=======================" + datediff);
				}

				sql = "select fin_chg  from crtermfc where  ? between min_day and max_day and cr_term = ? and trim(line_no) = '1'";
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setLong(1, datediff);
				pstmt1.setString(2, sfld1);
				rs1 = pstmt1.executeQuery();
				if (rs1.next())
				{
					discount = rs1.getDouble("fin_chg");
				}
				rs1.close();
				rs1 = null;
				pstmt1.close();
				pstmt1 = null;

				System.out.println("1574Get Discount=======" + discount);
				if (discount == 0.0D)
				{
					discount = 0.0D;
				}

				System.out.println("1580>>>>>>>>startFrom===" + startFrom);
				if ((startFrom != null) && (startFrom.trim().length() > 0) && ("R".equalsIgnoreCase(startFrom)))
				{
					ldStartDate = reDate1;
				}
				else if ((startFrom != null) && (startFrom.trim().length() > 0) && ("D".equalsIgnoreCase(startFrom)) && ("Q".equalsIgnoreCase(startFrom)))
				{
					ldStartDate = effDate;
				}
				else if ((startFrom != null) && (startFrom.trim().length() > 0) && ("B".equalsIgnoreCase(startFrom)))
				{
					ldStartDate = billDt;
				}

				System.out.println("1610disAmount==========" + disAmt);
				System.out.println("PayMAode=======" + payMode);
				System.out.println("BankCode>>>>>===" + bankCode);
				if (("D".equalsIgnoreCase(payMode)) || ("P".equalsIgnoreCase(payMode)))
				{
					System.out.println("1615payMode<<<<<<<<");
					drawnAt = checkNull(getpayablesAt(sundryType, sundryCodeNeg, bankCode, conn));
				}

				if (("D".equalsIgnoreCase(payMode)) || ("P".equalsIgnoreCase(payMode)) || ("T".equalsIgnoreCase(payMode)) || ("N".equalsIgnoreCase(payMode)))
				{
					System.out.println("1622payMode========>>>>");
					stanCode = checkNull(getStanDraw(sundryType, sundryCodeNeg, conn));
					System.out.println("Getting stanCode==============" + stanCode);
				}

				System.out.println("1628vouch_no============" + refNo);
				System.out.println("vouch_date============" + refDate);
				System.out.println("payAmt============" + payAmt);

				System.out.println("acct_code__ap=========" + acctCode);
				System.out.println("cctr_code__ap=========" + cctrCode);
				double payAmount = Double.parseDouble(payAmt);
				double exchRate1 = Double.parseDouble(exchRate);
				diffAmt = payAmount * exchRate1 - payAmount * mexrate;
				System.out.println("1637diff_amt__exch=========" + diffAmt);

				tempMapNeg = new HashMap();
				tempMapNeg.put("tran_id", tranId);
				tempMapNeg.put("tran_ser", tranSer);
				tempMapNeg.put("line_no", Integer.valueOf(lineNo));
				tempMapNeg.put("vouch_no", refNo);
				if (refdateNeg != null)
				{
					System.out.println("refdateNeg[" + refdateNeg + "]");
					String dueMaxDateStr = sdf.format(refdateNeg);
					System.out.println("refdateNeg  dueMaxDateStr [" + dueMaxDateStr + "]");

					tempMapNeg.put("vouch_date", dueMaxDateStr);
				}

				tempMapNeg.put("net_amt", Double.valueOf(pay_amt));
				tempMapNeg.put("pay_amt", Double.valueOf(pay_amt));
				tempMapNeg.put("curr_code", currCode);

				tempMapNeg.put("exch_rate__vouch", exchRate);
				tempMapNeg.put("diff_amt__exch", Double.valueOf(diffAmt));
				tempMapNeg.put("acct_code__ap", acctCode);
				tempMapNeg.put("cctr_code__ap", cctrCode);

				tempMapNeg.put("sundry_type", sundryType);
				tempMapNeg.put("sundry_code", sundryCodeNeg);
				tempMapNeg.put("bank_charges", Integer.valueOf(0));
				tempMapNeg.put("stan_code", stanCode);

				tempMapNeg.put("drawn_at", drawnAt);
				tempMapNeg.put("tax_amt", Integer.valueOf(0));
				tempMapNeg.put("net_pay_amt", Double.valueOf(pay_amt));
				tempMapNeg.put("acct_code__disc", acctCodeDisc);

				tempMapNeg.put("cctr_code__disc", cctrCodeDisc);
				tempMapNeg.put("bill_no", billNo);
				tempMapNeg.put("bill_date", billDate);
				tempMapNeg.put("exch_rate", exchRate);

				tempMapNeg.put("discount_amt", Double.valueOf(disAmt));
				tempMapNeg.put("discount", Double.valueOf(discount));
				tempMapNeg.put("tot_amt", Double.valueOf(totamount));

				System.out.println("Getting value in Negative Map======" + tempMapNeg);
				tempListNeg.add(tempMapNeg);
				System.out.println("Getting tempList value after ading in list ======" + tempListNeg);

				if (splitCodeWiseNegMap.containsKey(sundryCodeNeg))
				{
					System.out.println("splitCodeWiseNegMap.containsKey(sundryCdSpilt)");
					splitCodeWiseNegMap.put(sundryCodeNeg, tempListNeg);
				}
				else
				{
					System.out.println("else*************");
					splitCodeWiseNegMap.put(sundryCodeNeg, tempListNeg);
				}

			}

			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			System.out.println("1319Sundry Code====" + sundryCode);

			double sumNetAmtDummy = 0.0D;
			double sumNetAmt = 0.0D; double totUnconfAmt = 0.0D;
			String autoPaymTranId = "";
			Set setItem = splitCodeWiseMap.entrySet();
			System.out.println("1327getting set item=====" + setItem);
			tempList = null;
			Iterator itrItem = setItem.iterator();
			int testCnt = 0;
			while (itrItem.hasNext())
			{
				testCnt++;

				System.out.println("1335while loop@@@@@@@ " + testCnt);
				Map.Entry itemMapEntry = (Map.Entry)itrItem.next();
				splitCode = (String)itemMapEntry.getKey();
				System.out.println("splitCode---" + splitCode);
				System.out.println("Length---" + splitCode.split("@").length);

				tempList = (ArrayList)splitCodeWiseMap.get(splitCode);
				System.out.println("TempList Inside While=======" + tempList);

				if (splitCode.split("@").length != 0)
				{
					sundryCode = checkNull(splitCode.split("@")[0]);
					payMode = checkNull(splitCode.split("@")[1]);
					if ("Y".equalsIgnoreCase(spiltChq))
					{
						dueDate = checkNull(splitCode.split("@")[2]);
					}
				}

				System.out.println("sundryCode after spilt =======" + sundryCode);
				System.out.println("payMode after spilt =======" + payMode);
				System.out.println("Sundry TYPEEEEEEEE" + sundryType);
				System.out.println("dueDate after spilt =======" + dueDate);

				sundryType = (String)tempMap.get("sundry_type");
				System.out.println("Sundry Type from Map =======" + sundryType);

				System.out.println("sundryCode before setting ref date =======" + sundryCode);
				System.out.println("payMode before setting ref date =======" + payMode);
				java.util.Date currentDate1 = new java.util.Date();

				System.out.println("Current date111111111111====" + currentDate1);

				String maxDateRef = (String)maxDateMap.get(splitCode);
				System.out.println("Max Due Date from MAp==" + maxDateRef + "splitCode===" + splitCode);

				if ((maxDateRef != null) && (sdf.parse(maxDateRef).compareTo(currentDate1) > 0))
				{
					dueMaxDate = sdf.parse(maxDateRef);
				}
				else
				{
					dueMaxDate = currentDate1;
				}
				//added by priyanka on 06/01/16
				String dueMaxStr = sdf.format(dueMaxDate);
				System.out.println("Due Date Max======"+dueMaxStr);
				refDateSTr = Timestamp.valueOf(genericUtility.getValidDateString(dueMaxStr, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) + " 00:00:00.0");
				System.out.println("Date to be set as Ref Date@@@@@@@==="+refDateSTr);
				///
				System.out.println("1384Getting ref due Date for header====" + dueMaxDate);
				System.out.println("1385sfld1=========" + sfld1);

				System.out.println("1416Currency_code===================" + currCode);
				System.out.println("Site_code===================" + siteCode);

				System.out.println("Final Negative List=====" + splitCodeWiseNegMap);

				sumNetAmt = 0.0D;
				System.out.println("Sum Amount 1 @@@===" + sumNetAmt);
				balanceAmt = 0.0D;
				for (int itemCtr = 0; itemCtr < tempList.size(); itemCtr++)
				{
					tempMap = (HashMap)tempList.get(itemCtr);
					System.out.println("<!@#> payAmt " + (String)tempMap.get("pay_amt"));

					sumNetAmt += Double.parseDouble((String)tempMap.get("pay_amt"));
					System.out.println("PayAmt for Combonation" + payMode + "=====Total Of Pay Amt====" + sumNetAmt);
				}

				System.out.println("Sum Amount 2 @@@===" + sumNetAmt);
				tempListNeg = (ArrayList)splitCodeWiseNegMap.get(sundryCode);
				System.out.println("Creating Header$$$$$$");
				xmlString = null;
				xmlString = new StringBuffer();
				xmlString.append("<?xml version='1.0' encoding='ISO-8859-1'?>\n");
				xmlString.append("<DocumentRoot>");
				xmlString.append("<description>").append("Datawindow Root").append("</description>");
				xmlString.append("<group0>");
				xmlString.append("<description>").append("Group0 description").append("</description>");
				xmlString.append("<Header0>");
				xmlString.append("<objName><![CDATA[").append("misc_pay").append("]]></objName>");
				xmlString.append("<pageContext><![CDATA[").append("1").append("]]></pageContext>");
				xmlString.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
				xmlString.append("<editFlag><![CDATA[").append("A").append("]]></editFlag>");
				xmlString.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
				xmlString.append("<action><![CDATA[").append("SAVE").append("]]></action>");
				xmlString.append("<elementName><![CDATA[").append("").append("]]></elementName>");
				xmlString.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
				xmlString.append("<taxKeyValue><![CDATA[").append("").append("]]></taxKeyValue>");
				xmlString.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
				xmlString.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
				xmlString.append("<taxInFocus><![CDATA[").append(false).append("]]></taxInFocus>");
				xmlString.append("<Detail1 dbID='' domID=\"1\" objName=\"misc_pay\" objContext=\"1\">");
				xmlString.append("<attribute pkNames=\"tran_id:\" status=\"N\" updateFlag=\"A\" selected=\"N\" />");
				xmlString.append("<tran_id><![CDATA[]]></tran_id>");
				xmlString.append("<tran_date><![CDATA[" + checkNull(payDate) + "]]></tran_date>");
				xmlString.append("<tran_type><![CDATA[" + checkNull(tranType) + "]]></tran_type>");

				xmlString.append("<sundry_type><![CDATA[" + tempMap.get("sundry_type") + "]]></sundry_type>");
				xmlString.append("<sundry_code><![CDATA[" + checkNull(sundryCode) + "]]></sundry_code>");
				xmlString.append("<pay_mode><![CDATA[" + payMode + "]]></pay_mode>");
				xmlString.append("<bank_code><![CDATA[" + checkNull(bankCode) + "]]></bank_code>");
				if (("Q".equalsIgnoreCase(payMode)) || ("D".equalsIgnoreCase(payMode)))
				{
					if ((maxRefNo != null) && (maxRefNo.trim().length() > 0))
					{
						//maxRefNo = Integer.parseInt(maxRefNo) + 1;
						maxRefNo = ""+(Integer.parseInt(maxRefNo)+1);
						System.out.println("@@@@@@@@@ maxRefNo[" + maxRefNo + "]");
						xmlString.append("<ref_no><![CDATA[" + checkNull(maxRefNo) + "]]></ref_no>");
					}
					else
					{
						xmlString.append("<ref_no><![CDATA[" + maxRefNo + "]]></ref_no>");
					}
				}
				else
				{
					xmlString.append("<ref_no><![CDATA[ ]]></ref_no>");
				}

				xmlString.append("<ref_date><![CDATA[" + sdf.format(dueMaxDate).toString() + "]]></ref_date>");

				xmlString.append("<remarks><![CDATA[Generate Automatic payment from scheduler]]></remarks>");
				xmlString.append("<net_amt><![CDATA[0]]></net_amt>");
				xmlString.append("<curr_code><![CDATA[" + checkNull(currCode) + "]]></curr_code>");
				xmlString.append("<exch_rate><![CDATA[" + mexrate + "]]></exch_rate>");
				xmlString.append("<net_amt__bc><![CDATA[0]]></net_amt__bc>");
				xmlString.append("<site_code><![CDATA[" + checkNull(siteCode) + "]]></site_code>");
				xmlString.append("<site_descr><![CDATA[" + checkNull(siteDescr) + "]]></site_descr>");
				xmlString.append("<fin_entity><![CDATA[" + finEntity + "]]></fin_entity>");
				xmlString.append("<finent_descr><![CDATA[" + checkNull(finentDescr) + "]]></finent_descr>");
				xmlString.append("<acct_code__bal><![CDATA[" + checkNull(acctCodeBal) + "]]></acct_code__bal>");
				xmlString.append("<cctr_code__bal><![CDATA[" + checkNull(cctrCodeBal) + "]]></cctr_code__bal>");
				xmlString.append("<auto_paid><![CDATA[Y]]></auto_paid>");
				xmlString.append("<bank_charges><![CDATA[0]]></bank_charges>");
				xmlString.append("<acct_code__bc><![CDATA[" + checkNull(acctCodeBc) + "]]></acct_code__bc>");
				xmlString.append("<cctr_code__bc><![CDATA[" + checkNull(cctrCodeBc) + "]]></cctr_code__bc>");
				xmlString.append("<curr_code__bc><![CDATA[" + checkNull(currCodeBc) + "]]></curr_code__bc>");
				xmlString.append("<exch_rate__bc><![CDATA[" + excRateBc + "]]></exch_rate__bc>");
				xmlString.append("<acct_code__cf><![CDATA[" + checkNull(acctCodeCf) + "]]></acct_code__cf>");
				xmlString.append("<cctr_code__cf><![CDATA[" + checkNull(cctrCodeCf) + "]]></cctr_code__cf>");
				xmlString.append("<tax_amt><![CDATA[0]]></tax_amt>");
				xmlString.append("<tax_date><![CDATA[" + checkNull(payDate) + "]]></tax_date>");
				xmlString.append("<WF_STATUS ><![CDATA[" + checkNull(wfStatus) + "]]></WF_STATUS >");
				xmlString.append("<bank_name><![CDATA[" + checkNull(bankName) + "]]></bank_name>");

				if (bankCodeAdd == null)
					bankCodeAdd = "";
				xmlString.append("<bank_code__add><![CDATA[" + bankCodeAdd + "]]></bank_code__add>");
				xmlString.append("<confirmed><![CDATA[N]]></confirmed>");
				xmlString.append("<emp_code__conf><![CDATA[]]></emp_code__conf>");
				xmlString.append("<conf_date><![CDATA[]]></conf_date>");
				xmlString.append("<chg_user><![CDATA[" + chgUser + "]]></chg_user>");
				xmlString.append("<chg_term><![CDATA[" + chgTerm + "]]></chg_term>");
				xmlString.append("<chg_date><![CDATA[" + sysDate + "]]></chg_date>");

				xmlString.append("</Detail1>");
				System.out.println("Creating Header====$$$$$=" + xmlString.toString());
				System.out.println("End Header$$$$$$");

				System.out.println("Size of TempList=====" + tempList.size());
				System.out.println("Line No before========" + lineNo);

				lineNo = 0;
				for (int itemCtr = 0; itemCtr < tempList.size(); itemCtr++)
				{
					System.out.println("Main Iten Conter===" + itemCtr);

					tempMap = (HashMap)tempList.get(itemCtr);

					payAmt = (String)tempMap.get("pay_amt");
					System.out.println("Get PayAmount Value from Map===========" + payAmt);

					netPayable = (String)tempMap.get("net_pay_amt");
					System.out.println("Get netPayable Value from Map===========" + netPayable);
					System.out.println("Get SumAmt of PayAmt===========" + sumNetAmt);

					System.out.println("Get totUnconfAmt Value from Map===========" + totUnconfAmt);

					System.out.println("--------------> if payAmt>0 :: " + payAmt);
					System.out.println("--------------> if netPayable>0 :: " + netPayable);
					System.out.println("--------------> totUnconfAmt :: " + totUnconfAmt);
					if (((Double.parseDouble(netPayable) > 0.0D) && (Double.parseDouble(payAmt) <= Double.parseDouble(netPayable)) && (Double.parseDouble(payAmt) >= 0.0D)) || (
							(Double.parseDouble(netPayable) < 0.0D) && (Double.parseDouble(payAmt) <= 0.0D) && (Double.parseDouble(payAmt) >= Double.parseDouble(netPayable))))
					{
						System.out.println("----------------In condition---1111-----------");
						lineNo++;
						System.out.println("Line No after increament==========" + lineNo);

						System.out.println("temp tran_id========" + (String)tempMap.get("tran_id"));
						System.out.println("temp tran_ser========" + (String)tempMap.get("tran_ser"));
						System.out.println("temp vouch_no========" + (String)tempMap.get("vouch_no"));
						System.out.println("temp vouch_date========" + (String)tempMap.get("vouch_date"));
						System.out.println("temp vouch_date========" + (String)tempMap.get("vouch_date"));
						System.out.println("temp net_amt========" + (String)tempMap.get("net_amt"));

						System.out.println("temp pay_amt========" + (String)tempMap.get("pay_amt"));
						System.out.println("temp curr_code========" + (String)tempMap.get("curr_code"));
						System.out.println("temp exch_rate__vouch========" + (String)tempMap.get("exch_rate__vouch"));
						System.out.println("temp diff_amt__exch========" + (Double)tempMap.get("diff_amt__exch"));
						System.out.println("temp acct_code__ap========" + (String)tempMap.get("acct_code__ap"));

						System.out.println("temp sundry type=======" + (String)tempMap.get("sundry_type"));

						System.out.println("temp cctr_code__ap========" + (String)tempMap.get("cctr_code__ap"));
						System.out.println("temp tax_env========" + (String)tempMap.get("tax_env"));
						System.out.println("temp bill_no========" + (String)tempMap.get("bill_no"));
						System.out.println("temp bill_date========" + (String)tempMap.get("bill_date"));
						System.out.println("temp exch_rate========" + (String)tempMap.get("exch_rate"));
						System.out.println("temp discount_amt========" + (Double)tempMap.get("discount_amt"));
						System.out.println("temp discount========" + (Double)tempMap.get("discount"));
						System.out.println("temp tot_amt========" + (String)tempMap.get("tot_amt"));

						xmlString.append("<Detail2 dbID=':' domID=\"1\" objName='misc_pay' objContext='2'>");
						xmlString.append("<attribute pkNames='tran_id:line_no:' status='N' updateFlag='A' selected='N' />");
						xmlString.append("<tran_id><![CDATA[]]></tran_id>");

						xmlString.append("<line_no><![CDATA[" + lineNo + "]]></line_no>");
						xmlString.append("<tran_ser><![CDATA[" + tempMap.get("tran_ser") + "]]></tran_ser>");
						xmlString.append("<vouch_no><![CDATA[" + tempMap.get("vouch_no") + "]]></vouch_no>");
						xmlString.append("<vouch_date><![CDATA[" + tempMap.get("vouch_date") + "]]></vouch_date>");

						xmlString.append("<net_amt><![CDATA[" + tempMap.get("net_amt") + "]]></net_amt>");
						xmlString.append("<pay_amt><![CDATA[" + tempMap.get("pay_amt") + "]]></pay_amt>");
						xmlString.append("<curr_code><![CDATA[" + tempMap.get("curr_code") + "]]></curr_code>");
						xmlString.append("<exch_rate__vouch><![CDATA[" + tempMap.get("exch_rate") + "]]></exch_rate__vouch>");

						xmlString.append("<diff_amt__exch><![CDATA[" + tempMap.get("diff_amt__exch") + "]]></diff_amt__exch>");
						xmlString.append("<acct_code__ap><![CDATA[" + tempMap.get("acct_code__ap") + "]]></acct_code__ap>");
						xmlString.append("<cctr_code__ap><![CDATA[" + tempMap.get("cctr_code__ap") + "]]></cctr_code__ap>");
						xmlString.append("<sundry_type><![CDATA[" + tempMap.get("sundry_type") + "]]></sundry_type>");
						xmlString.append("<sundry_code><![CDATA[" + tempMap.get("sundry_code") + "]]></sundry_code>");
						xmlString.append("<bank_charges><![CDATA[" + tempMap.get("bank_charges") + "]]></bank_charges>");
						xmlString.append("<stan_code><![CDATA[" + tempMap.get("stan_code") + "]]></stan_code>");
						xmlString.append("<drawn_at><![CDATA[" + tempMap.get("drawn_at") + "]]></drawn_at>");

						xmlString.append("<tax_amt><![CDATA[" + tempMap.get("tax_amt") + "]]></tax_amt>");

						xmlString.append("<acct_code__disc><![CDATA[" + tempMap.get("acct_code__disc") + "]]></acct_code__disc>");
						xmlString.append("<cctr_code__disc><![CDATA[" + tempMap.get("cctr_code__disc") + "]]></cctr_code__disc>");

						xmlString.append("<tax_env><![CDATA[" + checkNull(tempMap.get("tax_env") == null ? "" : tempMap.get("tax_env").toString()) + "]]></tax_env>");
						xmlString.append("<bill_no><![CDATA[" + tempMap.get("bill_no") + "]]></bill_no>");
						xmlString.append("<bill_date><![CDATA[" + tempMap.get("bill_date") + "]]></bill_date>");

						xmlString.append("<exch_rate><![CDATA[" + mexrate + "]]></exch_rate>");
						xmlString.append("<discount_amt><![CDATA[" + tempMap.get("discount_amt") + "]]></discount_amt>");
						xmlString.append("<discount><![CDATA[" + tempMap.get("discount") + "]]></discount>");
						xmlString.append("<tot_amt><![CDATA[" + tempMap.get("tot_amt") + "]]></tot_amt>");

						xmlString.append("</Detail2>");
						System.out.println("XmlString Detail======" + xmlString.toString());

						sumNetAmtDummy = 0.0D;
						sumNetAmtDummy = sumNetAmt;
						System.out.println("Positive of Sum amount===" + sumNetAmtDummy);

						System.out.println("Sundry Code &&&===" + sundryCode);
						System.out.println("Sundry Code @@@@@2==" + sundryCdSpilt);

						System.out.println("1898TempList negative Inside While=======" + tempListNeg);

						System.out.println("Testtttttttttttt");



					}
					else
					{
						System.out.println("--------------> Error<---------------------" + refNo);

						errString = errString + "\n" + "[ref_no ::" + refNo + "]" + 
						"\n" + "[tran_ser ::" + tranSer + "]" + 
						"\n" + "[pay_mode ::" + payMode + "]" + 
						"\n" + "[net_payable ::" + netPayable + "]" + 
						"\n" + "[pay_Amt ::" + payAmt + "]" + "\n";
					}

					System.out.println("itemCtr=====-==" + itemCtr);
					System.out.println("tempList.size()=====-==" + tempList.size());
				}
				if (tempListNeg != null)
				{
					System.out.println("IFFFFFFFFFFFFFFFFFFFfffffffffffff%%%%%%%");
					for (int itemCtr1 = 0; itemCtr1 < tempListNeg.size(); itemCtr1++)
					{
						System.out.println("itemCtr1()====" + itemCtr1);
						tempMapNeg = (HashMap)tempListNeg.get(itemCtr1);
						System.out.println("tempMapNeg>>>>>>>>====" + tempMapNeg);
						payAmt1 = ((Double)tempMapNeg.get("pay_amt")).doubleValue();
						String refNoupd = ""; String sundryCd = "";
						refNoupd = (String)tempMapNeg.get("vouch_no");
						sundryCd = (String)tempMapNeg.get("sundry_code");
						System.out.println("Get PayAmount Value from Map===========" + payAmt1);
						System.out.println("Get refNoupd Value from Map===========" + refNoupd);
						System.out.println("PayAmt absolute value====" + Math.abs(payAmt1));
						System.out.println("SumNetAmtDummy===@@@==" + sumNetAmtDummy);

						if ((sumNetAmtDummy > 0.0D) && (Math.abs(payAmt1) > 0.0D))
						{
							lineNo++;
							System.out.println("Line No after increament==========" + lineNo);
							xmlString.append("<Detail2 dbID=':' domID=\"1\" objName='misc_pay' objContext='2'>");
							xmlString.append("<attribute pkNames='tran_id:line_no:' status='N' updateFlag='A' selected='N' />");
							xmlString.append("<tran_id><![CDATA[]]></tran_id>");
							System.out.println("11111111111111");

							xmlString.append("<line_no><![CDATA[" + lineNo + "]]></line_no>");
							System.out.println("222222222222222");
							xmlString.append("<tran_ser><![CDATA[" + tempMapNeg.get("tran_ser") + "]]></tran_ser>");
							System.out.println("333333333");
							xmlString.append("<vouch_no><![CDATA[" + tempMapNeg.get("vouch_no") + "]]></vouch_no>");
							System.out.println("44444444444");
							xmlString.append("<vouch_date><![CDATA[" + tempMapNeg.get("vouch_date") + "]]></vouch_date>");

							if (sumNetAmtDummy < Math.abs(payAmt1))
							{
								balanceAmt=Double.parseDouble(""+tempMapNeg.get("pay_amt"))+sumNetAmtDummy;
								xmlString.append("<pay_amt><![CDATA[" + sumNetAmtDummy * -1.0D + "]]></pay_amt>");
								xmlString.append("<net_amt><![CDATA[" + sumNetAmtDummy * -1.0D + "]]></net_amt>");
								xmlString.append("<tot_amt><![CDATA[" + sumNetAmtDummy * -1.0D + "]]></tot_amt>");

								sumNetAmtDummy = 0.0D;
							}
							else
							{
								balanceAmt=Double.parseDouble(""+tempMapNeg.get("pay_amt"))-payAmt1;
								xmlString.append("<pay_amt><![CDATA[" + tempMapNeg.get("pay_amt") + "]]></pay_amt>");
								xmlString.append("<net_amt><![CDATA[" + tempMapNeg.get("pay_amt") + "]]></net_amt>");
								xmlString.append("<tot_amt><![CDATA[" + tempMapNeg.get("pay_amt") + "]]></tot_amt>");
								sumNetAmtDummy += payAmt1;
							}

							System.out.println("Sum of net pay dummy after================" + sumNetAmtDummy);
							HashMap tempMapNegNew = new HashMap();
							tempMapNegNew = tempMapNeg;
							tempMapNegNew.put("pay_amt", Double.valueOf(balanceAmt));

							System.out.println("Balance Amount===" + balanceAmt + "tempMapNegNew before=== " + tempMapNegNew);

							tempListNeg.set(itemCtr1, tempMapNegNew);
							System.out.println("tempListNeg.size() after==== " + tempListNeg);
							xmlString.append("<curr_code><![CDATA[" + tempMapNeg.get("curr_code") + "]]></curr_code>");

							xmlString.append("<exch_rate__vouch><![CDATA[" + tempMapNeg.get("exch_rate") + "]]></exch_rate__vouch>");

							xmlString.append("<diff_amt__exch><![CDATA[" + tempMapNeg.get("diff_amt__exch") + "]]></diff_amt__exch>");

							xmlString.append("<acct_code__ap><![CDATA[" + tempMapNeg.get("acct_code__ap") + "]]></acct_code__ap>");
							xmlString.append("<cctr_code__ap><![CDATA[" + tempMapNeg.get("cctr_code__ap") + "]]></cctr_code__ap>");
							xmlString.append("<sundry_type><![CDATA[" + tempMapNeg.get("sundry_type") + "]]></sundry_type>");
							xmlString.append("<sundry_code><![CDATA[" + tempMapNeg.get("sundry_code") + "]]></sundry_code>");
							xmlString.append("<bank_charges><![CDATA[" + tempMapNeg.get("bank_charges") + "]]></bank_charges>");
							xmlString.append("<stan_code><![CDATA[" + tempMapNeg.get("stan_code") + "]]></stan_code>");
							xmlString.append("<drawn_at><![CDATA[" + tempMapNeg.get("drawn_at") + "]]></drawn_at>");

							xmlString.append("<acct_code__disc><![CDATA[" + tempMapNeg.get("acct_code__disc") + "]]></acct_code__disc>");
							xmlString.append("<cctr_code__disc><![CDATA[" + tempMapNeg.get("cctr_code__disc") + "]]></cctr_code__disc>");
							xmlString.append("<tax_env><![CDATA[" + checkNull(tempMap.get("tax_env") == null ? "" : tempMap.get("tax_env").toString()) + "]]></tax_env>");
							xmlString.append("<bill_no><![CDATA[" + tempMapNeg.get("bill_no") + "]]></bill_no>");
							xmlString.append("<bill_date><![CDATA[" + tempMapNeg.get("bill_date") + "]]></bill_date>");

							xmlString.append("<exch_rate><![CDATA[" + mexrate + "]]></exch_rate>");

							xmlString.append("</Detail2>");
							System.out.println("XmlString Detail of Negative values======" + xmlString.toString());

							System.out.println("sumNetAmtDummy before update=====" + sumNetAmtDummy);
							System.out.println("payAmt1 before update=====" + payAmt1);
						}
						else
						{
							System.out.println("Sum Amt less than pay amt");
							sumNetAmt = 0.0D;
							System.out.println("Break*********");
						}

					}

				}

				System.out.println("Processing DATA *****");
				startDate = new java.util.Date(System.currentTimeMillis());
				this.calendar.setTime(new Timestamp(System.currentTimeMillis()));
				this.startDateStr = (sdf1.format(startDate) + " " + this.calendar.get(10) + ":" + this.calendar.get(12) + ":" + this.calendar.get(13));
				strToWrite = strToWrite + this.startDateStr + ",";

				System.out.println("STARTING DATE" + this.startDateStr + "STRING TO WRITE" + strToWrite);

				xmlString.append("</Header0></group0></DocumentRoot>");
				xmlOutString = xmlString.toString();

				System.out.println("Counter before save data===" + cntXml);
				System.out.println("xmlOutString=============" + xmlOutString);
				System.out.println("-lineNo before commit--" + lineNo);
				if (lineNo > 0)
				{
					//Changes and Commented By Ajay on 02-01-2018:START
	                String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");  System.out.println("--login code--"+userId);
	              //retString = saveData(siteCode, xmlOutString, conn);
					retString = saveData(siteCode, xmlOutString,userId, conn);
					//Changes and Commented By Ajay on 02-01-2018:END
					System.out.println(">>>After saveData() AutoPmtGenPrc retString:" + retString);
					if ((retString != null) && (retString.trim().length() > 0))
					{
						System.out.println("Result string not null++++++++");

						System.out.println("--going to commit tranaction--");

						System.out.println("tranId before commit--" + tranId);
						if (retString.indexOf("Success") > -1)
						{
							System.out.println("After Save======" + retString.toString());
							String[] arrayForTranId = retString.split("<TranID>");
							System.out.println(">>>In AutoPmtGenPrc arrayForTranId:[" + arrayForTranId.toString() + "]arrayForTranId.length[" + arrayForTranId.length + "]");
							if (arrayForTranId.length > 1)
							{
								int endIndex = arrayForTranId[1].indexOf("</TranID>");
								autoPaymTranId = arrayForTranId[1].substring(0, endIndex);
							}
							System.out.println(">>>In autoPaym Generated new Tran ID:" + autoPaymTranId);

							sql = "UPDATE MISC_PAYMENT SET WF_STATUS= ?,ref_date=?  WHERE TRAN_ID=?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, wfStatus);
							pstmt.setTimestamp(2, refDateSTr);
							pstmt.setString(3, autoPaymTranId);
							pstmt.executeUpdate();

							pstmt.close();
							pstmt = null;

							conn.commit();
							System.out.println("--transaction commited--");
						}
						else
						{
							conn.rollback();
							System.out.println("--transaction rollback--");
						}

					}

				}

				cntXml++;

				System.out.println("**********SUCCESS***********");
				endDate = new java.util.Date(System.currentTimeMillis());
				this.calendar.setTime(new Timestamp(System.currentTimeMillis()));
				endDateStr = sdf1.format(endDate) + " " + this.calendar.get(10) + ":" + this.calendar.get(12) + ":" + this.calendar.get(13);

				strToWrite = strToWrite + endDateStr + ",";
				strToWrite = strToWrite + retString + "\r\n\r\n";
				this.fos1.write(strToWrite.getBytes());

				System.out.println("End Time for transaction" + endDateStr + "string to write" + strToWrite);
				strToWrite = "";

				System.out.println("retString:: " + retString);
				System.out.println("Transaction Id====" + tranId);
			}

		}
		catch (Exception e)
		{
			System.out.println(e.getMessage());
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				conn.close();
			}
			catch (Exception ex)
			{
				System.out.println(ex.getMessage());
			}
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				conn.close();
			}
			catch (Exception e)
			{
				System.out.println(e.getMessage());
			}
		}
		if (errString.trim().length() > 0)
		{
			return this.err;
		}

		return retString;
	}

	public String errMsg(String columnName, String msgNo, String userId, String errTrace)
	throws RemoteException, ITMException
	{
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();

		PreparedStatement pstmt = null;
		PreparedStatement pstmt1 = null;
		PreparedStatement pstmt2 = null;
		ResultSet rs = null;
		ResultSet rs1 = null;
		ResultSet rs2 = null;

		String msgType = "";
		String msgString = "";
		String msgDescription = "";
		String lmsgString = "";
		String profileId = "";
		String errSource = "";
		String tempMsgType = "";
		String msgOption = "";
		String msgTime = "";

		String redirerr = "";
		String soundPlay = "";
		try
		{

			//Changes and Commented By Bhushan on 06-06-2016 :START
//conn = connDriver.getConnectDB("DriverITM");
conn = getConnection();
//Changes and Commented By Bhushan on 06-06-2016 :END
			String sqlQuery = "SELECT MSG_TYPE,MSG_STR,MSG_DESCR,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE FROM MESSAGES WHERE MSG_NO='" + msgNo + "'";
			//stmt = conn.createStatement();
			pstmt = conn.prepareStatement(sqlQuery);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
				msgString = rs.getString("MSG_STR");
				msgDescription = rs.getString("MSG_DESCR");
				errSource = rs.getString("ERR_SOURCE");
				msgOption = rs.getString("MSG_OPT");
				msgTime = rs.getString("MSG_TIME");
				soundPlay = rs.getString("ALARM");
			}
			else
			{
				lmsgString = "Message Not Defined >>" + msgNo;
				msgDescription = "Message Id not found.";
				msgType = "";
				msgString = "";
			}
			//Changed by wasim on 17-03-2016 to close statement/Result set [START]
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			//Changed by wasim on 17-03-2016 to close statement/Result set [END]
			if ((msgType.equals("E")) || (msgType.trim().length() == 0))
			{
				String sqlQuery1 = "SELECT PROFILE_ID FROM USERS WHERE CODE='" + userId + "'";
				// rs1 = conn.createStatement().executeQuery(sqlQuery1);
				pstmt1 = conn.prepareStatement(sqlQuery1);
				rs1 = pstmt1.executeQuery();
				if (rs1.next())
				{
					profileId = rs1.getString("profile_id");
					if (profileId == null)
					{
						profileId = "";
					}
					sqlQuery1 = "SELECT MSG_TYPE FROM MESSAGES_LEVEL WHERE MSG_NO='" + msgNo.trim() + "' AND PROFILE_ID='" + profileId.trim() + "'";
					//rs2 = conn.createStatement().executeQuery(sqlQuery1);
					pstmt2 = conn.prepareStatement(sqlQuery1);
					rs2 = pstmt2.executeQuery();
					if (rs2.next())
					{
						tempMsgType = rs2.getString("msg_type");
					}
				}
				//Changed by Manish on 25-04-2016 to close statement/Result set [START]
				if(pstmt1 != null)
				{
					pstmt1.close();
					pstmt1=null;
				}
				if(rs1!=null)
				{
					rs1.close();
					rs1=null;
				}
				if(pstmt2 != null)
				{
					pstmt2.close();
					pstmt2=null;
				}
				if(rs2!=null)
				{
					rs2.close();
					rs2=null;
				}

				//Changed by Manish on 25-04-2016 to close statement/Result set [END]
				if ((tempMsgType != null) && (tempMsgType.trim().length() > 0))
				{
					msgType = tempMsgType;
				}
			}
			if (msgType.equals("W"))
			{
				msgString = "Warning : " + msgString;
			}
			else if (msgType.equals("P"))
			{
				msgString = "Prompt : " + msgString;
			}
			else
			{
				msgType = "E";
				msgString = "Error : " + msgString;
			}
			if ((errSource != null) && (errSource.trim().equals("D")))
			{
				msgDescription = msgDescription + " * From Database ";
			}
			if ((redirerr == null) || (redirerr.trim().length() == 0))
			{
				redirerr = "1";
			}
			if ((msgOption != null) && (msgOption.trim().equals("M")))
			{
				if (redirerr.trim().equals("1"))
				{
					redirerr = "2";
				}
				else
				{
					redirerr = "1";
				}
			}
			if (rs != null)
			{
				rs.close();
			}
			if (rs1 != null)
			{
				rs1.close();
			}
			conn.close();

		}
		catch (ITMException itme)
		{
			System.out.println("ITMException : [ValidatorEJB][getErrorString] :==>\n" + itme.getMessage());
			throw itme;
		}
		catch (SQLException se)
		{
			lmsgString = "Database Error >>" + se.getErrorCode();
			msgDescription = se.getMessage();
			msgType = "";
			msgString = "";
			System.out.println("Exception : [ValidatorEJB][getErrorString] :==>\n" + se.getMessage());
			se.printStackTrace();
			throw new ITMException(se);
		}
		catch (Exception e)
		{
			System.out.println("Exception : [ValidatorEJB][getErrorString] :==>\n" + e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		String sqlQuery;
		StringBuffer errStringXml = new StringBuffer();
		errStringXml.append("<?xml version=\"1.0\"?>\r\n<Root><Errors>\r\n");
		errStringXml.append("<error id=\"");
		errStringXml.append(msgNo).append("\" type=\"").append(msgType).append("\" column_name=\"");
		errStringXml.append(columnName).append("\">\r\n").append("<message>").append(msgString);
		errStringXml.append("</message>\r\n<description>").append(msgDescription).append("</description>\r\n");
		errStringXml.append("<type>").append(msgType).append("</type>\r\n<option>").append(msgOption).append("</option>\r\n");
		errStringXml.append("<time>").append(msgTime).append("</time>\r\n");

		errStringXml.append("<alarm>").append(soundPlay).append("</alarm>\r\n<source>");
		errStringXml.append(errSource).append("</source>\r\n<trace>").append(errTrace);
		errStringXml.append("</trace>\r\n<redirect>").append(redirerr).append("</redirect>\r\n</error>\r\n");
		errStringXml.append("</Errors></Root>\r\n");
		try
		{
			FileOutputStream fos = new FileOutputStream("C:" + File.separator + "ErrorXml.xml");
			byte[] convertStringToByte = errStringXml.toString().getBytes();
			fos.write(convertStringToByte);
			fos.close();
		}
		catch (Exception e)
		{
			System.out.println("Exception : [ValidatorEJB][getErrorString] \n:==>" + e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		//Changed by wasim to add finally block [START]
		finally
		{
			try
			{
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs!=null)
				{
					rs.close();
					rs=null;
				}
				if(pstmt1 != null)
				{
					pstmt1.close();
					pstmt1=null;
				}
				if(rs1!=null)
				{
					rs1.close();
					rs1=null;
				}
				if(pstmt2 != null)
				{
					pstmt2.close();
					pstmt2=null;
				}
				if(rs2!=null)
				{
					rs2.close();
					rs2=null;
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		//Changed by wasim to add finally block [END]
		FileOutputStream fos;
		return errStringXml.toString();
	}

	private String checkNull(String str)
	{
		if (str == null)
		{
			return "";
		}

		return str;
	}

	private String saveData(String siteCode, String xmlString,String userId, Connection conn)
	throws ITMException
	{
		System.out.println("saving data...........");
		InitialContext ctx = null;
		String retString = null;
		MasterStatefulLocal masterStateful = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
			masterStateful = (MasterStatefulLocal)ctx.lookup("ibase/MasterStatefulEJB/local");
			System.out.println("-----------masterStateful------- " + masterStateful);
			String[] authencate = new String[2];
			//Changes By Ajay on 02-01-2018:START
			authencate[0] = userId;
			//Changes By Ajay on 02-01-2018:END
			authencate[1] = "";
			System.out.println("xmlString to masterstateful [" + xmlString + "]");
			retString = masterStateful.processRequest(authencate, siteCode, true, xmlString, true, conn);
		}
		catch (ITMException itme) {
			System.out.println("ITMException :AutoPmtGenPrc :saveData :==>");
			throw itme;
		}
		catch (Exception e) {
			e.printStackTrace();
			System.out.println("Exception :AutoPmtGenPrc :saveData :==>");
			throw new ITMException(e);
		}
		return retString;
	}

	public String getStanDraw(String sundryType, String sundryCode, Connection conn)
	throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = ""; String stanCode = ""; String empCode = "";
		try
		{
			System.out.println(">>>>>>>>>Enter in getStanDraw method");
			System.out.println(">>>>>>>>sundryType===" + sundryType);
			System.out.println(">>>>>>>>sundryCode===" + sundryCode);

			if ((sundryType != null) && (sundryType.trim().length() > 0) && ("E".equalsIgnoreCase(sundryType)))
			{
				sql = "select stan_code from employee where emp_code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, sundryCode);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					stanCode = checkNull(rs.getString("stan_code"));
				}
				rs.close();
				pstmt.close();
				pstmt = null;
				rs = null;
				System.out.println("StanCode from Sundry type=E>>>>>>" + stanCode);
			}
			else if ((sundryType != null) && (sundryType.trim().length() > 0) && ("S".equalsIgnoreCase(sundryType)))
			{
				sql = "select stan_code from supplier where supp_code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, sundryCode);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					stanCode = checkNull(rs.getString("stan_code"));
				}
				rs.close();
				pstmt.close();
				pstmt = null;
				rs = null;
				System.out.println("StanCode from Sundry type= S>>>>>>" + stanCode);
			}
			else if ((sundryType != null) && (sundryType.trim().length() > 0) && ("C".equalsIgnoreCase(sundryType)))
			{
				sql = "select stan_code from customer where cust_code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, sundryCode);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					stanCode = checkNull(rs.getString("stan_code"));
				}
				rs.close();
				pstmt.close();
				pstmt = null;
				rs = null;
				System.out.println("StanCode from Sundry type=C>>>>>>" + stanCode);
			}
			else if ((sundryType != null) && (sundryType.trim().length() > 0) && ("P".equalsIgnoreCase(sundryType)))
			{
				sql = "select emp_code  from sales_pers where sales_pers = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, sundryCode);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					empCode = checkNull(rs.getString("emp_code"));
				}
				rs.close();
				pstmt.close();
				pstmt = null;
				rs = null;

				System.out.println("empCode from Sundry type=P>>>>>>" + empCode);

				if ((empCode != null) && (empCode.trim().length() > 0))
				{
					sql = "select stan_code from employee where emp_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, empCode);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						stanCode = checkNull(rs.getString("stan_code"));
					}
					rs.close();
					pstmt.close();
					pstmt = null;
					rs = null;
					System.out.println("StanCode from Sundry type=P>>>>>>" + stanCode);
				}

			}
			else if ((sundryType != null) && (sundryType.trim().length() > 0) && ("T".equalsIgnoreCase(sundryType)))
			{
				sql = "select stan_code  from transporter where tran_code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, sundryCode);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					stanCode = checkNull(rs.getString("stan_code"));
				}
				rs.close();
				pstmt.close();
				pstmt = null;
				rs = null;
				System.out.println("StanCode from Sundry type= T>>>>>>" + stanCode);
			}
			else if ((sundryType != null) && (sundryType.trim().length() > 0) && ("X".equalsIgnoreCase(sundryType)))
			{
				sql = "select stan_code from tax_authority where tauth_code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, sundryCode);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					stanCode = checkNull(rs.getString("stan_code"));
				}
				rs.close();
				pstmt.close();
				pstmt = null;
				rs = null;
				System.out.println("StanCode from Sundry type= X>>>>>>" + stanCode);
			}

		}
		catch (Exception e)
		{
			System.out.println("Exception ::" + e);
			throw new ITMException(e);
		}
		//Changed by wasim to add finally block [START]
		finally
		{
			try
			{
				if(pstmt!=null)
				{
					pstmt.close();pstmt=null;
				}
				if(rs!=null)
				{
					rs.close();rs=null;
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		//Changed by wasim to add finally block [END]
		return stanCode;
	}

	public String getpayablesAt(String sundryType, String sundryCode, String bankCode, Connection conn)
	throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = ""; String payables = ""; String empCode = ""; String stanCode = ""; String bankRef = "";
		try
		{
			System.out.println(">>>>>>>>>Enter in getStanDraw method");
			System.out.println(">>>>>>>>sundryType===" + sundryType);
			System.out.println(">>>>>>>>sundryCode===" + sundryCode);
			System.out.println(">>>>>>>>bankCode===" + bankCode);

			if ((sundryType != null) && (sundryType.trim().length() > 0) && ("E".equalsIgnoreCase(sundryType)))
			{
				sql = "select dd_payable_bank,stan_code from employee where emp_code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, sundryCode);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					payables = checkNull(rs.getString("dd_payable_bank"));
					stanCode = checkNull(rs.getString("stan_code"));
				}
				rs.close();
				pstmt.close();
				pstmt = null;
				rs = null;
				System.out.println("payables from Sundry type=E>>>>>>" + payables);
			}
			else if ((sundryType != null) && (sundryType.trim().length() > 0) && ("S".equalsIgnoreCase(sundryType)))
			{
				sql = "select bank_ref,stan_code from supplier where supp_code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, sundryCode);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					payables = checkNull(rs.getString("bank_ref"));
					stanCode = checkNull(rs.getString("stan_code"));
				}
				rs.close();
				pstmt.close();
				pstmt = null;
				rs = null;
				System.out.println("payables from Sundry type= S>>>>>>" + payables);
			}
			else if ((sundryType != null) && (sundryType.trim().length() > 0) && ("C".equalsIgnoreCase(sundryType)))
			{
				sql = "select bank_name ,stan_code from customer where cust_code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, sundryCode);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					payables = checkNull(rs.getString("bank_name"));
					stanCode = checkNull(rs.getString("stan_code"));
				}
				rs.close();
				pstmt.close();
				pstmt = null;
				rs = null;
				System.out.println("payables from Sundry type=C>>>>>>" + payables);
			}
			else if ((sundryType != null) && (sundryType.trim().length() > 0) && ("T".equalsIgnoreCase(sundryType)))
			{
				sql = "select payable_ref,stan_code from transporter where tran_code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, sundryCode);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					payables = checkNull(rs.getString("payable_ref"));
					stanCode = checkNull(rs.getString("stan_code"));
				}
				rs.close();
				pstmt.close();
				pstmt = null;
				rs = null;
				System.out.println("payables from Sundry type= T>>>>>>" + payables);
			}
			else if ((sundryType != null) && (sundryType.trim().length() > 0) && ("X".equalsIgnoreCase(sundryType)))
			{
				sql = "select bank_ref,stan_code from tax_authority where tauth_code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, sundryCode);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					payables = checkNull(rs.getString("bank_ref"));
					stanCode = checkNull(rs.getString("stan_code"));
				}
				rs.close();
				pstmt.close();
				pstmt = null;
				rs = null;
				System.out.println("payables from Sundry type= X>>>>>>" + payables);
			}
			if ((payables != null) && (payables.trim().length() > 0))
			{
				sql = "select drawn_at, bank_ref  from bank_stan_serv where bank_code = ? and stan_code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, bankCode);
				pstmt.setString(2, stanCode);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					payables = checkNull(rs.getString("drawn_at"));
					bankRef = checkNull(rs.getString("bank_ref"));
				}
				rs.close();
				pstmt.close();
				pstmt = null;
				rs = null;
				System.out.println("payables from Sundry type= X>>>>>>" + payables);
				System.out.println("bankRef from Sundry type= X>>>>>>" + bankRef);
				if ((bankRef != null) && (bankRef.trim().length() > 0))
				{
					payables = payables.trim() + "," + bankRef.trim();
					System.out.println("Payables final=====" + payables);
				}
			}
		}
		catch (Exception e)
		{
			System.out.println("Exception ::" + e);
			throw new ITMException(e);
		}
		//Changed by wasim to add finally block [START]
		finally
		{
			try
			{
				if(pstmt!=null)
				{
					pstmt.close();pstmt=null;
				}
				if(rs!=null)
				{
					rs.close();rs=null;
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		//Changed by wasim to add finally block [END]
		return payables;
	}

	public java.util.Date getDiscountdate(String crTerm, java.util.Date vochurDate, java.util.Date effDate, java.util.Date billDt, Connection conn)
	throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = ""; String startFrom = ""; String empCode = ""; String stanCode = ""; String bankRef = "";
		java.util.Date tranDt = null; java.util.Date toDate = null; java.util.Date dueDate = null; java.util.Date newDate = null;
		String month1 = ""; String overrideDiscountDate = ""; String liCrDays = "";
		long maxDay = 0L; long liDays = 0L; long liDueDays = 0L; long liCrDays1 = 0L;
		long currDays = 0L;
		int liDays1 = 0;
		try
		{
			System.out.println(">>>>>>>>>Enter in getDiscountdate");
			System.out.println(">>>>>>>>crTerm===" + crTerm);
			System.out.println(">>>>>>>>vochurDate===" + vochurDate);
			System.out.println(">>>>>>>>effDate===" + effDate);
			System.out.println(">>>>>>>>billDt===" + billDt);

			sql = "select start_from  from crterm where cr_term = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, crTerm);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				startFrom = checkNull(rs.getString("start_from"));
			}
			rs.close();
			pstmt.close();
			pstmt = null;
			rs = null;
			System.out.println(">>>>>>>>startFrom===" + startFrom);
			if ((startFrom != null) && (startFrom.trim().length() > 0) && ("R".equalsIgnoreCase(startFrom)))
			{
				tranDt = vochurDate;
			}
			else if ((startFrom != null) && (startFrom.trim().length() > 0) && ("D".equalsIgnoreCase(startFrom)) && ("Q".equalsIgnoreCase(startFrom)))
			{
				tranDt = effDate;
			}
			else if ((startFrom != null) && (startFrom.trim().length() > 0) && ("B".equalsIgnoreCase(startFrom)))
			{
				tranDt = billDt;
			}

			SimpleDateFormat sdf = new SimpleDateFormat(this.genericUtility.getApplDateFormat());

			if (tranDt != null)
			{
				Calendar cal = Calendar.getInstance();

				cal.setTime(tranDt);
				int month = cal.get(2);
				System.out.println("Getting Month=============" + month);
				if (month == 12)
				{
					month = 1;
					month1 = "01";
				}
				else
				{
					month++;
					if (month > 9)
					{
						month1 = Integer.toString(month);
					}
					else
					{
						month1 = "0" + Integer.toString(month);
					}

				}

			}

			sql = "select override_discount_date  from crterm_disc where cr_term = ? and cr_month= ? and override_discount_date is not null";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, crTerm);
			pstmt.setString(2, month1);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				System.out.println("Data  found>>>>>.");
				overrideDiscountDate = checkNull(rs.getString("override_discount_date"));
				System.out.println("Getting overrideDiscountDate=============" + overrideDiscountDate);
				liCrDays = overrideDiscountDate.substring(3, 2);
				System.out.println("Getting liDays=============" + liDays);
			}
			else
			{
				System.out.println("<<<<<,,,Data not found");
				sql = "select crtermfc.max_day,crterm_disc.override_discount_date from crterm_disc,crtermfc where crterm_disc.cr_term = crtermfc.cr_term  and trim(crtermfc.line_no) = '1' and crterm_disc.cr_term = ? and crterm_disc.cr_month = '99' and crterm_disc.override_discount_date is not null";

				this.pstmt1 = conn.prepareStatement(sql);
				this.pstmt1.setString(1, crTerm);
				this.rs1 = this.pstmt1.executeQuery();
				if (this.rs1.next())
				{
					maxDay = this.rs1.getInt("max_day");
					overrideDiscountDate = checkNull(this.rs1.getString("override_discount_date"));
					liCrDays = overrideDiscountDate.substring(3, 2);
					liCrDays1 = Integer.parseInt(liCrDays);
					System.out.println("Getting liDays=============" + liDays);
				}
				else
				{
					sql = "select max_day\tfrom crtermfc where cr_term = ? and trim(crtermfc.line_no) = '1'";
					this.pstmt2 = conn.prepareStatement(sql);
					this.pstmt2.setString(1, crTerm);
					this.rs2 = this.pstmt2.executeQuery();
					if (this.rs2.next())
					{
						liDays = this.rs2.getInt("max_day");
					}

					this.rs2.close();
					this.pstmt2.close();
					this.pstmt2 = null;
					this.rs2 = null;
					if (liDays == 0L)
					{
						liDays = 0L;
					}
				}
				this.rs1.close();
				this.pstmt1.close();
				this.pstmt1 = null;
				this.rs1 = null;
			}
			rs.close();
			pstmt.close();
			pstmt = null;
			rs = null;

			if (liDays == 0L)
			{
				liDays = 0L;
			}

			sql = "select cr_days  from crterm where cr_term = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, crTerm);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				liDueDays = rs.getInt("cr_days");
			}
			rs.close();
			pstmt.close();
			pstmt = null;
			rs = null;
			if ((overrideDiscountDate != null) && (overrideDiscountDate.trim().length() > 0))
			{
				sql = "select to_date  from period where fr_date <= ? and to_date >=?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setDate(1, (java.sql.Date)vochurDate);
				pstmt.setDate(2, (java.sql.Date)vochurDate);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					toDate = rs.getDate("to_date");
				}
				rs.close();
				pstmt.close();
				pstmt = null;
				rs = null;
				long diff = vochurDate.getTime() - toDate.getTime();
				currDays = diff / 86400000L;
				System.out.println("CurrDtae=======================" + currDays);
				liDays = currDays + liCrDays1;
				liDays1 = (int)liDays;
				System.out.println("final liDays1======== " + liDays1);
			}
			if (tranDt != null)
			{
				Calendar calendar = Calendar.getInstance();
				calendar.setTime(tranDt);

				calendar.add(6, liDays1);

				dueDate = calendar.getTime();
			}

			System.out.println("dueDate: " + dueDate);
		}
		catch (Exception e)
		{
			System.out.println("Exception ::" + e);
			throw new ITMException(e);
		}
		//Changed by wasim to add finally block [START]
		finally
		{
			try
			{
				if(pstmt!=null)
				{
					pstmt.close();pstmt=null;
				}
				if(rs!=null)
				{
					rs.close();rs=null;
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		//Changed by wasim to add finally block [END]
		return dueDate;
	}

	private String intializingLog(String fileName)
	{
		String log = "intializingLog_Failed";
		String strToWrite = "";
		String currTime = null;
		try {
			SimpleDateFormat sdf1 = new SimpleDateFormat(this.genericUtility.getDBDateFormat());
			try
			{
				currTime = sdf1.format(new Timestamp(System.currentTimeMillis())).toString();
				currTime = currTime.replaceAll("-", "");
				this.calendar.setTime(new Timestamp(System.currentTimeMillis()));
				fileName = fileName + currTime + this.calendar.get(10) + this.calendar.get(12) + ".csv";
				this.fos1 = new FileOutputStream(CommonConstants.JBOSSHOME + File.separator + "EDI" + File.separator + fileName);
			}
			catch (Exception e)
			{
				System.out.println("Exception []::" + e.getMessage());
				e.printStackTrace();
			}
			this.startDate = new java.util.Date(System.currentTimeMillis());
			this.calendar.setTime(new Timestamp(System.currentTimeMillis()));
			this.startDateStr = (sdf1.format(this.startDate) + " " + this.calendar.get(10) + ":" + this.calendar.get(12) + ":" + this.calendar.get(13));
			this.fos1.write(("Fetching Records Started At " + this.startDateStr + "\r\n").getBytes());
		}
		catch (Exception e)
		{
			System.out.println("Exception []::" + e.getMessage());
			e.printStackTrace();
		}

		log = "intializingLog_Successesfull";
		return log;
	}
}