<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">

<html>

<body onload="formatDate(); checkType();">
<script type="text/javascript" src="/ibase/webitm/js/PlistgenWiz.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-1.10.2.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-ui-1.10.4.custom.min.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/FixedTableHeader.js"></script>
<script language="Javascript" src="/ibase/webitm/js/jquery.datetimepicker.full.js"></script>
<script language="Javascript" src="/ibase/webitm/js/date.js"></script>

<link href="/ibase/webitm/css/jquery-ui-1.10.4.custom.min.css" rel="stylesheet"/>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.core.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.widget.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.position.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.menu.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.autocomplete.js"></script>
		
<link href="/ibase/webitm/css/htmlWizard.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/PlistgenWiz.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/jquery.datetimepicker.css" rel="stylesheet"/>

<script>
<![CDATA[
	$(document).on("keydown", function (e) {
    if (e.which === 8 && !$(e.target).is("input, textarea, form")) {
        e.preventDefault();
    }
    else if(e.which ===13){
    	 e.preventDefault();
    }
});
]]>
</script>

<form name="plistgenWizForm1" id="plistgenWizForm1" METHOD="post" ACTION="/ibase/ITMWizardHandlerServlet" >
	<div class="contentHeaderLbl" style="position:fixed;overflow:hidden;width:100%;padding:12px; background-color:white;top:0px;">
		&#160;&#160;<img src="/ibase/images/menuImages/web/plistgen_wiz.png" onerror=" this.src= '/ibase/images/menuImages/errMenu.png' " style="position: absolute; margin-left: -20px; height: 20px; width: 20px;"/>
		&#160;Manage Pricing 
	</div><br></br><br></br>
	<div id="innerDiv" style="overflow-y:hidden;overflow-x:auto;max-height:80%;width:99%;position:absolute;">
	    <table id="errorActivityTable" height="10%" class="tableClass"  style="margin: 12px 0px 0px 0px;position: relative;width: calc(literal('100% - 15px'));width: -moz-calc(literal('100% - 15px'));padding-right:0px; padding-left:5xp; width: -webkit-calc(literal('100% - 15px'));box-shadow: 3px 3px 3px gray;-moz-box-shadow:3px 3px 3px gray;-webkit-box-shadow: 3px 3px 3px gray;-o-box-shadow: 3px 3px 3px gray;background: rgba(255, 204, 0, 0.66);min-height: 50px;bottom:10px"  border="0" cellspacing="0" cellpadding="0"> 
            <xsl:for-each select="//error">
                <xsl:if test="position() = 1">
                    <tr>    
                        <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"   nowrap="true" valign="bottom">
                            Message :
                        </td> 
                        <td class="tdss_leftAlign"   style="background: rgba(255, 204, 0, 0.66);"   nowrap="true" valign="bottom">
                            Description :
                        </td>
                        <td class="tdss_rightAlign"  style="background: rgba(255, 204, 0, 0.66);" nowrap="true" valign="bottom" colspan="2">
                            <a href="#" style="text-decoration:none;" onclick="doHideMsg('errorActivityTable')"><font style="color:#000;text-decoration:none;padding-right:5px;" ><b>X</b></font></a>
                        </td>
                    </tr>
                </xsl:if>
                <xsl:variable name="message"><xsl:value-of select="message"/></xsl:variable>
                <xsl:variable name="description"><xsl:value-of select="description"/></xsl:variable>
                <xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
                <xsl:variable name="dbID"><xsl:value-of select="@domId"/></xsl:variable>  
                <xsl:variable name="column_name"><xsl:value-of select="@column_name"/></xsl:variable> 
                <tr style="background: rgba(255, 204, 0, 0.66);">
                     <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true">
                        <xsl:value-of select="message"/>
                    </td> 
                    
                    <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true">
                        <xsl:value-of select="description"/>
                    </td>
                    
                    <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true">
                    </td>
                </tr>
            </xsl:for-each>
            
            <xsl:for-each select="//error">
                <xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
                <xsl:if test="position() = 1">
                    <xsl:if test="$type = 'W'">
                        <tr style="background: rgba(255, 204, 0, 0.66);">
                            <td class="tdss_leftAlign"  style="background: rgba(255, 204, 0, 0.66);"  nowrap="true" valign="bottom">
                                <input  type="checkbox" name="forceSave" value="true" checked="checked" onClick="setChecked(this)"/>
                            </td>
                            <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true"></td>
                        </tr>
                    </xsl:if>
                </xsl:if>    
            </xsl:for-each>
	    </table>
	</div>
	
	<div id="popHelpContainer"></div>
	<div id="overlay"></div>
	<div id="mainPageHeaderContatiner">
		<div id="mainPage-input-Container">
			<xsl:for-each select="//Detail1">
				<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
				<xsl:variable name="tran_id"><xsl:value-of select="tran_id"/></xsl:variable>
				<xsl:variable name="tran_date"><xsl:value-of select="tran_date"/></xsl:variable>
				<xsl:variable name="tran_type"><xsl:value-of select="tran_type"/></xsl:variable>
				<xsl:variable name="descr"><xsl:value-of select="descr"/></xsl:variable>
				<xsl:variable name="product_code"><xsl:value-of select="product_code"/></xsl:variable>
				<xsl:variable name="eff_from"><xsl:value-of select="eff_from"/></xsl:variable>
				<xsl:variable name="valid_upto"><xsl:value-of select="valid_upto"/></xsl:variable>
				<xsl:variable name="remarks"><xsl:value-of select="remarks"/></xsl:variable>
				<xsl:variable name="offer_free_qty"><xsl:value-of select="offer_free_qty"/></xsl:variable>
				<xsl:variable name="offer_free_on"><xsl:value-of select="offer_free_on"/></xsl:variable>
				<xsl:variable name="disc_perc"><xsl:value-of select="disc_perc"/></xsl:variable>
				<xsl:variable name="grp_code"><xsl:value-of select="grp_code"/></xsl:variable>
				
				<table id="activityTable" border="0" cellSpacing="1" cellPadding="0" style="margin-bottom:25px;">
					<tr style="display:none;">
						<td class="td_rightAlign" nowrap="true" valign="middle"  >
							Tran ID :
						</td>
						<td class="td_leftAlign" >
							<input type="text" class="input_editable" value="{$tran_id}" name="Detail1.{normalize-space($dbID)}.tran_id" id="Detail1.{normalize-space($dbID)}.tran_id" tabIndex="10"/>
						</td>
						<td class="td_rightAlign" nowrap="true" valign="middle">Tran date :</td>
						<td class="td_leftAlign">
							<input type="text" class="input_editable" value="{$tran_date}" name="Detail1.{normalize-space($dbID)}.tran_date" id="tran_date" tabIndex="20" onfocus="displayPopUpIcon('popUpIcon11');" />
							<a href="javascript:setDate('tran_date');" id="popUpIcon11"   tabIndex="-1"><img src="/ibase/webitm/images/calender.png" /></a>
						</td>
					</tr>
					<tr>
						<td class="td_rightAlign" nowrap="true" valign="middle" >
							Product Code<span class="req">*</span>:
						</td>
						<td class="td_leftAlign" colspan="3">
							<div id="inputDiv">
								<input type="text" class="input_editable" popupFldName="PRODUCT_CODE" value="{$product_code}" name="Detail1.{normalize-space($dbID)}.product_code" id="Detail1.{normalize-space($dbID)}.product_code" onBlur="callItemChange('product_code', this);" tabIndex="30" style="width:21%;" onfocus="displayPopUpIcon('popUpIcon1');" onkeyup="getAutoPopupData(this);" />
								<a href="javascript:getListOfValues('PRODUCT_CODE','Detail1.{normalize-space($dbID)}.product_code','','');" id="popUpIcon1"  tabIndex="-1" style="float:left;"><img src="/ibase/webitm/images/pophelp.png"/></a>
								<input type="text" class="editDisplayClass"  name="Detail1.{normalize-space($dbID)}.descr" id="Detail1.{normalize-space($dbID)}.descr" tabIndex="-1" style="width:60%;" readOnly="true" value="{$descr}"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="td_rightAlign" nowrap="true" valign="left"  >
							Item Group :
						</td>
						<td class="td_leftAlign"   >
							<input type="text" class="input_editable" value="{$grp_code}"  popupFldName="GRP_CODE" name="Detail1.{normalize-space($dbID)}.grp_code" id="Detail1.{normalize-space($dbID)}.grp_code" onfocus="displayPopUpIcon('popUpIcon3');" onkeyup="getAutoPopupData(this);"  style="width:51%;" tabIndex="40"/>
<a href="javascript:getListOfValues('GRP_CODE','Detail1.{normalize-space($dbID)}.grp_code','','product_code');" id="popUpIcon3"  tabIndex="-1" ><img src="/ibase/webitm/images/pophelp.png"/></a>
						</td>
					</tr>
					<tr>
						<td class="td_rightAlign" nowrap="true" valign="middle"  >
							Effective From <span class="req">*</span>:
						</td>
						<td class="td_leftAlign" >
							<input type="text" style="width:51.5%" class="input_editable" value="{$eff_from}" name="Detail1.{normalize-space($dbID)}.eff_from" id="eff_from" tabIndex="50"  onfocus="displayPopUpIcon('popUpIcon12');" />
							<a href="javascript:setDate('eff_from');" id="popUpIcon12"   tabIndex="-1"><img src="/ibase/webitm/images/calender.png" /></a>
						</td>
						<td class="td_rightAlign" nowrap="true" valign="middle"  >
							Valid Upto<span class="req">*</span>:
						</td>
						<td class="td_leftAlign" >
							<input type="text" style="width:63.5%" class="input_editable" value="{$valid_upto}" name="Detail1.{normalize-space($dbID)}.valid_upto" id="valid_upto" tabIndex="60"  onfocus="displayPopUpIcon('popUpIcon13');" />
							<a href="javascript:setDate('valid_upto');" id="popUpIcon13"  tabIndex="-1"><img src="/ibase/webitm/images/calender.png" /></a>
						</td>
					</tr>
					<tr>
						<td class="td_rightAlign" nowrap="true" valign="middle">
							Remarks:
						</td>
						<td class="td_leftAlign" colspan="3">
							<input type="text" class="input_editable" value="{$remarks}" name="Detail1.{normalize-space($dbID)}.remarks" id="Detail1.{normalize-space($dbID)}.remarks" tabIndex="70" style="width:85%;" />
						</td>
					</tr>
					<tr>
						<td class="td_rightAlign" nowrap="true" valign="middle"  >
							Charge Type :
						</td>
						<td class="td_leftAlign" >
							<SELECT id='Detail1.{normalize-space($dbID)}.tran_type' NAME="Detail1.{normalize-space($dbID)}.tran_type" align="LEFT" TABINDEX="80" class="input_editable">
								<OPTION value="A"><xsl:choose><xsl:when test="$tran_type='A'"><xsl:attribute name="selected"/></xsl:when></xsl:choose><![CDATA[Apply Discount]]></OPTION>
							</SELECT>
						</td>
					</tr>
					<tr>
						<td class="td_rightAlign" nowrap="true" valign="middle"  >
							Offer/Discount<span class="req">*</span>:
						</td>
					</tr>
					<tr>
						<td class="td_rightAlign" nowrap="true" valign="middle"  >
							  <input  type="radio" name="offer" value="true"  onClick="enableTextBox('offer');" id="Detail1.{normalize-space($dbID)}.offer" TABINDEX="90"/>
						</td>
						<td class="td_leftAlign" colspan="3">
							Quantity :
							<input type="text" class="editDisplayClass qtyTextBox"   onload="checkType();" value="{$offer_free_qty}" name="Detail1.{normalize-space($dbID)}.offer_free_qty" id="Detail1.{normalize-space($dbID)}.offer_free_qty" onkeypress="return isNumberKey(event);" readonly="true" tabIndex="100"  />
							Free On :
							<input type="text" class="editDisplayClass qtyTextBox" value="{$offer_free_on}" name="Detail1.{normalize-space($dbID)}.offer_free_on" id="Detail1.{normalize-space($dbID)}.offer_free_on" onkeypress="return isNumberKey(event);" readonly="true" tabIndex="110" />

						</td>
					</tr>
					<tr style="display:none;">
						<td class="td_rightAlign" nowrap="true" valign="middle"  >
							   <input  type="radio" name="offer" onClick="enableTextBox('discount');" id="Detail1.{normalize-space($dbID)}.discount" />
						</td>
						<td class="td_leftAlign" >
							Discount :
							<input type="text" class="editDisplayClass qtyTextBox" value="{$disc_perc}" name="Detail1.{normalize-space($dbID)}.disc_perc" id="Detail1.{normalize-space($dbID)}.disc_perc" onkeypress="return isNumberKey(event);" readonly="true" tabIndex="120"  /> %
						</td>
					</tr>
				</table>
			</xsl:for-each>
		</div>
		<div id="btnDiv">
			<input type="hidden" value="1" name="FORM_NO" ID="FORM_NO" />
			<input type="hidden" value="plistgen_wiz" name="OBJ_NAME" />
			<input type="hidden" value="next" name="action" id="action" />
				<input type="button" style="cursor:hand;margin-left:5px;" value="Reset" onclick="callDelete();"  class="button" title='Reset' id="reset"/>
			<input type="submit" style="cursor:hand;margin-left:2px;" value="Next" onclick="setActionVal('next');return validateHeaderForm();" class="button" title='Next' id="next"/>
		</div>
	</div>
	<div id="buttonreplacement">
		<img src="/ibase/images/preload.gif" alt="Please wait work in progress" ></img>
		<span>Please wait......</span>
	</div>
</form>
</body>
</html>
</xsl:template>
</xsl:stylesheet>
